<?php

namespace DgoraWcas\Integrations\Plugins\DiscontinuedProductStockStatusWoocommerce;

// Exit if accessed directly
use DgoraWcas\Integrations\Plugins\AbstractPluginIntegration;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Integration with Discontinued Product Stock Status for WooCommerce
 *
 * Plugin URL: https://wordpress.org/plugins/discontinued-product-stock-status-woocommerce/
 * Author: SaffireTech
 */
class DiscontinuedProductStockStatusWooCommerce extends AbstractPluginIntegration {
	protected const LABEL = 'Discontinued Product Stock Status';

	public static function isActive(): bool {
		if ( ! defined( 'DPSSW_DISCOUNTINUED_PLUGIN_BASENAME' ) ) {
			return false;
		}

		// WooCommerce >> Settings >> Discontinued Product Stock Status Global Settings tab: Hide Discontinued Products in WooCommerce Catalog & Search Results
		// Warning: This option has the opposite name than what it does.
		if ( get_option( 'discontinued_show_in_catalog' ) !== 'yes' ) {
			return false;
		}

		return true;
	}

	public function init(): void {

		if ( ! dgoraAsfwFs()->is_premium() ) {
			add_filter(
				'dgwt/wcas/search_query/args',
				function ( $args ) {
					$args['meta_query']   = $args['meta_query'] ?? [];
					$args['meta_query'][] = [
						'key'     => '_stock_status',
						'value'   => 'discontinued',
						'compare' => '!=',
					];

					return $args;
				}
			);
		}

		if ( dgoraAsfwFs()->is__premium_only() ) {
			// Exclude discontinued products in SourceQuery.
			add_filter(
				'dgwt/wcas/indexer/source_query/where',
				function ( $where ) {
					global $wpdb;

					$where .= " AND NOT EXISTS (SELECT meta_value FROM $wpdb->postmeta WHERE post_id = posts.ID AND meta_key='_stock_status' AND meta_value='discontinued') ";

					return $where;
				}
			);

			// Disallow indexing discontinued products after update.
			add_filter(
				'dgwt/wcas/indexer/updater/can_index',
				function ( $can_index, $product_id ) {
					if ( get_post_meta( $product_id, '_stock_discontinued_product', true ) === 'yes' ) {
						$product = wc_get_product( $product_id );
						if ( is_a( $product, 'WC_Product' ) ) {
							if ( in_array( $product->get_stock_status(), [ 'outofstock', 'discontinued' ] ) ) {
								$can_index = false;
							}
						}
					}

					return $can_index;
				},
				10,
				2
			);
		}
	}
}
