import { defineConfig, devices } from '@playwright/test';

/**
 * Read environment variables from file.
 * https://github.com/motdotla/dotenv
 */
// import dotenv from 'dotenv';
// import path from 'path';
// dotenv.config( { path: path.resolve( __dirname, '.env' ) } );

/**
 * See https://playwright.dev/docs/test-configuration.
 */
export default defineConfig( {
	/* Test directory */
	testDir: './tests/play',

	/* Global setup file */
	globalSetup: require.resolve( './tests/play/config/global-setup' ),

	/* Maximum time one test can run for. */
	timeout: 180 * 1000,

	/* Expect parameter configurations */
	expect: {
		/**
		 * Maximum time expect() should wait for the condition to be met.
		 * For example in `await expect(locator).toHaveText();`
		 */
		timeout: 5000,
	},

	/* Run tests in files in parallel */
	fullyParallel: true,

	/* Fail the build on CI if you accidentally left test.only in the source code. */
	forbidOnly: !! process.env.CI,

	/* Retry on CI only */
	retries: process.env.CI ? 2 : 0,

	/* Opt out of parallel tests. */
	workers: 1,

	/* Reporter to use. See https://playwright.dev/docs/test-reporters */
	reporter: process.env.CI ? 'github' : 'html',

	/* Shared settings for all the projects below. See https://playwright.dev/docs/api/class-testoptions. */
	use: {
		/* Base URL to use in actions like `await page.goto('/')`. */
		baseURL: process.env.baseURL || 'http://localhost:8889/',

		headless: true,
		browserName: 'chromium',
		viewport: { width: 1280, height: 720 },
		ignoreHTTPSErrors: true,
		video: 'on-first-retry',
		actionTimeout: 0,

		/* Collect trace when retrying the failed test. See https://playwright.dev/docs/trace-viewer */
		trace: 'on-first-retry',

		/* Use storage state for authentication */
		storageState: './tests/play/.auth/storageState.json',
	},

	/* Configure projects for major browsers */
	projects: [
		{
			name: 'chromium',
			use: { ...devices[ 'Desktop Chrome' ] },
		},

		// {
		// 	name: 'firefox',
		// 	use: { ...devices[ 'Desktop Firefox' ] },
		// },

		// {
		// 	name: 'webkit',
		// 	use: { ...devices[ 'Desktop Safari' ] },
		// },

		/* Test against mobile viewports. */
		// {
		// 	name: 'Mobile Chrome',
		// 	use: { ...devices[ 'Pixel 5' ] },
		// },
		// {
		// 	name: 'Mobile Safari',
		// 	use: { ...devices[ 'iPhone 12' ] },
		// },

		/* Test against branded browsers. */
		// {
		// 	name: 'Microsoft Edge',
		// 	use: { ...devices[ 'Desktop Edge' ], channel: 'msedge' },
		// },
		// {
		// 	name: 'Google Chrome',
		// 	use: { ...devices[ 'Desktop Chrome' ], channel: 'chrome' },
		// },
	],

	/* Run your local dev server before starting the tests */
	// webServer: {
	// 	command: 'npm run env:start',
	// 	url: 'http://localhost:8889',
	// 	reuseExistingServer: ! process.env.CI,
	// },

	/* Test result output directory */
	outputDir: 'tests/play/test-results/',
} );
