(function($) {

	<?php if ( isset( $settings->shuffle ) && '1' === $settings->shuffle && ! FLBuilderModel::is_builder_active() ) : ?>
		$.fn.randomize = function(childElem) {
			return this.each(function() {
				var $this = $(this);
				var elems = $this.children(childElem);
				elems.sort(() => Math.random() - 0.5)
				$this.detach(childElem)
				for(var i=0; i < elems.length; i++)
				$this.append(elems[i])
			});
		}
		$('.fl-node-<?php echo $id; ?> .fl-content-slider-wrapper').randomize('.fl-slide');
	<?php endif; ?>

	$(function() {
		var sliderIndex = 'undefined' === typeof FLBuilder ? false : FLBuilder.getSandbox('sliderIndex'),
			autoPlay    = <?php echo esc_js( $settings->auto_play ); ?>,
			dots        = <?php echo esc_js( $settings->dots ); ?>

		// display slider immediately if not editing a specific one
		if (false === sliderIndex) {
			$('.fl-node-<?php echo $id; ?> .fl-content-slider-wrapper').css('opacity', '1');
		}

		var slider = $('.fl-node-<?php echo $id; ?> .fl-content-slider-wrapper').delay(1000).bxSlider({
			fallbackHTML: <?php echo ( 1 === $module->version ) ? 'true' : 'false'; ?>,
			adaptiveHeight: true,
			ariaLive: false,
			startSlide: sliderIndex ? sliderIndex : 0,
			auto: autoPlay && false === sliderIndex ? true : false,
			autoHover: <?php echo ( $settings->auto_hover ) ? 'true' : 'false'; ?>,
			autoControls: <?php echo ( $settings->play_pause ) ? 'true' : 'false'; ?>,
			autoControlsCombine: <?php echo ( $settings->play_pause ) ? 'true' : 'false'; ?>,
			pause: <?php echo esc_js( $settings->delay * 1000 ); ?>,
			mode: '<?php echo esc_js( $settings->transition ); ?>',
			speed: <?php echo esc_js( $settings->speed * 1000 ); ?>,
			controls: false,
			infiniteLoop: <?php echo $module->is_loop_enabled(); ?>,
			pager: dots && false === sliderIndex ? true : false,
			video: true,
			onSliderLoad: function(currentIndex) {
				// display slider after loading if editing a specific one
				if (false !== sliderIndex) {
					$('.fl-node-<?php echo $id; ?> .fl-content-slider-wrapper').css('opacity', '1');
				}

				$('.fl-node-<?php echo $id; ?> .fl-content-slider-wrapper').addClass('fl-content-slider-loaded');

				// Remove video sources
				$('.fl-node-<?php echo $id; ?> iframe').each( function(){
					var src = $( this ).attr( 'src' );
					$( this ).attr( 'data-url', src );

					if ( ! $( this ).is( ':visible' ) || 0 === $( this ).parents( '.fl-slide-0:not(.bx-clone)' ).length ) {
						$( this ).attr( 'src', '' );
					}
				});
				/* if slide 0 contains a video and it is set to auto play, then play */
				$('.fl-slide-0:not(.bx-clone) video[autoplay]').trigger('play');
			},
			onSlideAfter: function( ele, oldIndex, newIndex ) {
				var prevSlide = $( '.fl-node-<?php echo $id; ?> .fl-slide-' + oldIndex + ':not(.bx-clone)'),
					newSlide  = $( '.fl-node-<?php echo $id; ?> .fl-slide-' + newIndex + ':not(.bx-clone)');

				// Swap autoplay video sources
				if ( newSlide.find( 'iframe:visible').length ) {
					newSlide.find( 'iframe:visible').each(function(){
						var src = $( this ).attr( 'data-url' );
						$( this ).attr( 'src', src );
					});
				}

				if ( prevSlide.find( 'iframe:visible').length ) {
					prevSlide.find( 'iframe:visible').each(function(){
						var src = $( this ).attr( 'src' );
						$( this ).attr( 'src', '' );
					});
				}

				/* Pause and play videos if autoplay */
				if ( prevSlide.find( 'video').length ) {
					prevSlide.find( 'video').trigger( 'pause' );
				}

				$( '.fl-node-<?php echo $id; ?> .fl-slide-' + newIndex + ':not(.bx-clone)').find('video[autoplay]').trigger('play')
			},
			buildPager: function( currentIndex ) {
				return JSON.parse( '<?php echo json_encode( $module->get_slides_labels() ); ?>' )[ currentIndex ];
			}
		});

		// Store a reference to the slider.
		slider.data('bxSlider', slider);

		<?php if ( $settings->arrows ) : ?>

			$('.fl-node-<?php echo $id; ?> .slider-prev').on( 'click', function( e ){
				e.preventDefault();
				slider.goToPrevSlide();
			} );

			$('.fl-node-<?php echo $id; ?> .slider-next').on( 'click', function( e ){
				e.preventDefault();
				slider.goToNextSlide();
			} );

		<?php endif; ?>

	});

})(jQuery);
