(function ($) {
  "use strict";

  $(document).ready(function () {

    if ($('.elementor-editor-active').length > 0) {
      console.log('Element Pack Smooth Scroller is disabled in Elementor Editor');
      return;
    }

    const lenis = new Lenis();
    function raf(time) {
      lenis.raf(time);
      requestAnimationFrame(raf);
    }
    requestAnimationFrame(raf);

    // Handle offcanvas overlay conflict with Lenis smooth scroll
    if (typeof bdtUIkit !== 'undefined') {
      bdtUIkit.util.on(document, 'beforeshow', '.bdt-offcanvas', function (e) {
        // Get the offcanvas element from the event target
        const $offcanvas = $(e.target);
        
        // Check if offcanvas has overlay enabled by checking data attribute
        const offcanvasAttr = $offcanvas.attr('data-bdt-offcanvas');
        
        if (offcanvasAttr && offcanvasAttr.includes('overlay: true')) {
          // Stop Lenis only when offcanvas has overlay enabled
          // The offcanvas bar has data-lenis-prevent to allow scrolling inside
          lenis.stop();
        }
      });

      bdtUIkit.util.on(document, 'hidden', '.bdt-offcanvas', function (e) {
        const $offcanvas = $(e.target);
        
        // Check if offcanvas had overlay enabled
        const offcanvasAttr = $offcanvas.attr('data-bdt-offcanvas');
        
        if (offcanvasAttr && offcanvasAttr.includes('overlay: true')) {
          // Start Lenis when offcanvas with overlay closes
          lenis.start();
        }
      });
    }
  });
  
})(jQuery);
