<?php
namespace DiviBooster\DiviBooster\Modules\MapPin\StartOpen;

const DIVI5_MODULE_SLUG = 'divi/map-pin';
const DIVI4_MODULE_SLUG = 'et_pb_map_pin';
const DIVI5_SETTING_SLUG = 'diviboosterStartOpen';
const DIVI4_SETTING_SLUG = 'db_start_open';

// === Divi 4 Field Registration ===
add_filter('et_pb_all_fields_unprocessed_' . DIVI4_MODULE_SLUG, __NAMESPACE__ . '\add_fields');
function add_fields($fields) {
    $fields[DIVI4_SETTING_SLUG] = [
        'label'           => 'Show Details by Default',
        'type'            => 'yes_no_button',
        'options'         => [
            'off' => esc_html__('No', 'et_builder'),
            'on'  => esc_html__('Yes', 'et_builder'),
        ],
        'option_category' => 'basic_option',
        'description'     => 'Choose whether marker pin details should be displayed right away or not.',
        'default'         => 'off',
        'toggle_slug'     => 'main_content',
    ];
    return $fields;
}

// === Divi 5 Attribute Registration, Mapping, and Conversion ===
add_action('wp_enqueue_scripts', __NAMESPACE__ . '\enqueue_divi5_script');
function enqueue_divi5_script() {
    if ((!function_exists('et_builder_d5_enabled') || !\et_builder_d5_enabled()) ||
        (!function_exists('et_core_is_fb_enabled') || !\et_core_is_fb_enabled())) {
        return;
    }
    $handle = sanitize_title('divi-booster-' . DIVI5_MODULE_SLUG . '-' . DIVI5_SETTING_SLUG);
    wp_register_script($handle, '', ['lodash', 'divi-vendor-wp-hooks'], null, true);
    wp_enqueue_script($handle);
    wp_add_inline_script($handle, get_inline_js());
}

function get_inline_js() {
    $attribute_json = wp_json_encode(get_attribute_definition());
    $divi5_slug = wp_json_encode(DIVI5_MODULE_SLUG);
    $divi4_slug = wp_json_encode(DIVI4_MODULE_SLUG);
    $divi5_setting_slug = wp_json_encode(DIVI5_SETTING_SLUG);
    $divi4_setting_slug = wp_json_encode(DIVI4_SETTING_SLUG);
    return <<<END
window.vendor.wp.hooks.addFilter('divi.moduleLibrary.moduleMapping', 'divi', modules => {
    const path = [{$divi5_slug}, 'metadata', 'attributes'];
    const { set, get, has } = window.lodash;
    const target = get(modules, path) ? get(modules, path) : set(modules, path, {});
    if (has(modules, path)) {
        target[{$divi5_setting_slug}] = $attribute_json;
    }
    return modules;
});
window.vendor.wp.hooks.addFilter('divi.moduleLibrary.conversion.moduleConversionOutline', 'divi', (conversionOutline, name) => {
    if (name !== {$divi4_slug}) return conversionOutline;
    conversionOutline.module[{$divi4_setting_slug}] = {$divi5_setting_slug} + '.*';
    return conversionOutline;
});
END;
}

// === Divi 5: PHP conversion outline registration ===
function dbdb_register_divi5_start_open_conversion( $conversion_outline, $module_name ) {
    if ( DIVI5_MODULE_SLUG !== $module_name ) {
        return $conversion_outline;
    }
    if ( ! isset( $conversion_outline['module'] ) || ! is_array( $conversion_outline['module'] ) ) {
        $conversion_outline['module'] = array();
    }
    $conversion_outline['module'][ DIVI4_SETTING_SLUG ] = DIVI5_SETTING_SLUG . '.*';
    return $conversion_outline;
}
add_filter( 'divi.moduleLibrary.conversion.moduleConversionOutline', __NAMESPACE__ . '\dbdb_register_divi5_start_open_conversion', 10, 2 );

add_filter('divi_module_library_register_module_attrs', function($module_attrs, $filter_args) {
    if (($filter_args['name'] ?? '') !== DIVI5_MODULE_SLUG) {
        return $module_attrs;
    }
    $module_attrs[DIVI5_SETTING_SLUG] = get_attribute_definition();
    return $module_attrs;
}, 10, 2);

function get_attribute_definition() {
    return [
        'type'     => 'object',
        'settings' => [
            'innerContent' => [
                'groupType' => 'group-items',
                'items'     => [
                    'diviboosterPinStartOpenToggle' => [
                        'groupSlug'   => 'contentText',
                        'attrName'    => DIVI5_SETTING_SLUG,
                        'label'       => 'Show Details by Default',
                        'description' => 'Choose whether marker pin details should be displayed right away or not.',
                        'features'    => [
                            'hover'      => false,
                            'sticky'     => false,
                            'responsive' => false,
                            'preset'     => 'content',
                        ],
                        'render'   => true,
                        'priority' => 10,
                        'component' => [
                            'type' => 'field',
                            'name' => 'divi/toggle',
                        ],
                        'defaultAttr' => [ 'desktop' => [ 'value' => 'off' ] ],
                    ],
                ],
            ],
        ],
    ];
}

// === Shared Output Filter Logic ===
function process_map_pin_output($content, $start_open) {
    if ($start_open === 'on') {
        $content = preg_replace('#(<div class="et_pb_map_pin[^"]*")#', '\\1 data-initial="open"', $content);
        // Enqueue the JS to apply opening of pins (only once per request)
        if (!wp_script_is('divibooster_map_pin_start_open', 'enqueued')) {
            register_feature_js();
            wp_enqueue_script('divibooster_map_pin_start_open');
        }
    }
    return $content;
}

// === Divi 4 Output Filter ===
add_filter('et_module_shortcode_output', function($output, $render_slug, $module) {
    if (!is_string($output) || $render_slug !== DIVI4_MODULE_SLUG || !isset($module->props)) {
        return $output;
    }
    $start_open = $module->props[DIVI4_SETTING_SLUG] ?? 'off';
    return process_map_pin_output($output, $start_open);
}, 10, 3);

// === Divi 5 Output Filter ===
add_filter('render_block_' . DIVI5_MODULE_SLUG, function($block_content, $parsed_block, $block) {
    $start_open = $parsed_block['attrs'][DIVI5_SETTING_SLUG]['desktop']['value'] ??
        ($parsed_block['attrs'][DIVI5_SETTING_SLUG]['value'] ?? 'off');
    return process_map_pin_output($block_content, $start_open);
}, 10, 3);

// === Register and Output Feature JS ===
//add_action('wp_enqueue_scripts', __NAMESPACE__ . '\register_feature_js');
function register_feature_js() {
    $handle = 'divibooster_map_pin_start_open';
    if (!wp_script_is($handle, 'registered')) {
        $js = <<<'END'
jQuery(function($){
    var dbdb_checkMapExists = setInterval(function(){
        $map_containers = $('.et_pb_map_container');
        $map_containers.find('.et_pb_map_pin[data-initial="open"]').each(function(){
            var $this_marker = $(this);
            var $this_map_container = $this_marker.closest('.et_pb_map_container');
            if ($this_map_container.data('map')) {
                clearInterval(dbdb_checkMapExists);
                var marker = new google.maps.Marker({
                    position: new google.maps.LatLng( parseFloat( $this_marker.attr('data-lat') ), parseFloat( $this_marker.attr('data-lng') ) ),
                    map: $this_map_container.data('map'),
                    title: $this_marker.attr('data-title'),
                    icon: { url: (window.et_pb_custom && et_pb_custom.builder_images_uri ? et_pb_custom.builder_images_uri : '') + '/marker.png', size: new google.maps.Size( 46, 43 ), anchor: new google.maps.Point( 16, 43 ) },
                    shape: { coord: [1, 1, 46, 43], type: 'rect' },
                    anchorPoint: new google.maps.Point(0, -45),
                    opacity: 0
                });
                if ( $this_marker.find('.infowindow').length ) {
                    var infowindow = new google.maps.InfoWindow({
                        content: $this_marker.html()
                    });
                    infowindow.open( $this_map_container.data('map'), marker );
                    google.maps.event.addListener( $this_map_container.data('map'), 'click', function() {
                        infowindow.close();
                        marker.setMap(null);
                    });
                    google.maps.event.addListener(infowindow, 'closeclick', function() {
                        infowindow.close();
                        marker.setMap(null);
                    });
                }
            }
        });
    }, 2000);
});
END;
        wp_register_script($handle, '', [], null, true);
        wp_add_inline_script($handle, $js);
    }
}
