<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Studio\V2;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class FlowOptions {
    /**
     * @param string $commitMessage Description on change made in the revision
     * @return CreateFlowOptions Options builder
     */
    public static function create($commitMessage = Values::NONE) {
        return new CreateFlowOptions($commitMessage);
    }

    /**
     * @param string $friendlyName The string that you assigned to describe the Flow
     * @param array $definition JSON representation of flow definition
     * @param string $commitMessage Description on change made in the revision
     * @return UpdateFlowOptions Options builder
     */
    public static function update($friendlyName = Values::NONE, $definition = Values::NONE, $commitMessage = Values::NONE) {
        return new UpdateFlowOptions($friendlyName, $definition, $commitMessage);
    }
}

class CreateFlowOptions extends Options {
    /**
     * @param string $commitMessage Description on change made in the revision
     */
    public function __construct($commitMessage = Values::NONE) {
        $this->options['commitMessage'] = $commitMessage;
    }

    /**
     * Description on change made in the revision.
     *
     * @param string $commitMessage Description on change made in the revision
     * @return $this Fluent Builder
     */
    public function setCommitMessage($commitMessage) {
        $this->options['commitMessage'] = $commitMessage;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Studio.V2.CreateFlowOptions ' . \implode(' ', $options) . ']';
    }
}

class UpdateFlowOptions extends Options {
    /**
     * @param string $friendlyName The string that you assigned to describe the Flow
     * @param array $definition JSON representation of flow definition
     * @param string $commitMessage Description on change made in the revision
     */
    public function __construct($friendlyName = Values::NONE, $definition = Values::NONE, $commitMessage = Values::NONE) {
        $this->options['friendlyName'] = $friendlyName;
        $this->options['definition'] = $definition;
        $this->options['commitMessage'] = $commitMessage;
    }

    /**
     * The string that you assigned to describe the Flow.
     *
     * @param string $friendlyName The string that you assigned to describe the Flow
     * @return $this Fluent Builder
     */
    public function setFriendlyName($friendlyName) {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * JSON representation of flow definition.
     *
     * @param array $definition JSON representation of flow definition
     * @return $this Fluent Builder
     */
    public function setDefinition($definition) {
        $this->options['definition'] = $definition;
        return $this;
    }

    /**
     * Description on change made in the revision.
     *
     * @param string $commitMessage Description on change made in the revision
     * @return $this Fluent Builder
     */
    public function setCommitMessage($commitMessage) {
        $this->options['commitMessage'] = $commitMessage;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Studio.V2.UpdateFlowOptions ' . \implode(' ', $options) . ']';
    }
}