<?php

namespace DynamicOOOS\TelegramBot\Api\Types;

use DynamicOOOS\TelegramBot\Api\BaseType;
use DynamicOOOS\TelegramBot\Api\InvalidArgumentException;
use DynamicOOOS\TelegramBot\Api\TypeInterface;
/**
 * Class Video
 * This object represents a video file.
 *
 * @package TelegramBot\Api\Types
 */
class Video extends BaseType implements TypeInterface
{
    /**
     * {@inheritdoc}
     *
     * @var array
     */
    protected static $requiredParams = ['file_id', 'file_unique_id', 'width', 'height', 'duration'];
    /**
     * {@inheritdoc}
     *
     * @var array
     */
    protected static $map = ['file_id' => \true, 'file_unique_id' => \true, 'width' => \true, 'height' => \true, 'duration' => \true, 'thumbnail' => PhotoSize::class, 'mime_type' => \true, 'file_size' => \true];
    /**
     * Unique identifier for this file
     *
     * @var string
     */
    protected $fileId;
    /**
     * Video width as defined by sender
     *
     * @var int
     */
    protected $width;
    /**
     * Video height as defined by sender
     *
     * @var int
     */
    protected $height;
    /**
     * Duration of the video in seconds as defined by sender
     *
     * @var int
     */
    protected $duration;
    /**
     * Video thumbnail
     *
     * @var PhotoSize|null
     */
    protected $thumbnail;
    /**
     * Optional. Mime type of a file as defined by sender
     *
     * @var string|null
     */
    protected $mimeType;
    /**
     * Optional. File size
     *
     * @var int|null
     */
    protected $fileSize;
    /**
     * Unique identifier for this file, which is supposed to be the same over time and for different bots. Can't be used to download or reuse the file.
     *
     * @var string
     */
    protected $fileUniqueId;
    /**
     * @return int
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * @param mixed $duration
     *
     * @throws InvalidArgumentException
     *
     * @return void
     */
    public function setDuration($duration)
    {
        if (\is_integer($duration)) {
            $this->duration = $duration;
        } else {
            throw new InvalidArgumentException();
        }
    }
    /**
     * @return string
     */
    public function getFileId()
    {
        return $this->fileId;
    }
    /**
     * @param string $fileId
     *
     * @return void
     */
    public function setFileId($fileId)
    {
        $this->fileId = $fileId;
    }
    /**
     * @return int|null
     */
    public function getFileSize()
    {
        return $this->fileSize;
    }
    /**
     * @param mixed $fileSize
     *
     * @throws InvalidArgumentException
     *
     * @return void
     */
    public function setFileSize($fileSize)
    {
        if (\is_integer($fileSize)) {
            $this->fileSize = $fileSize;
        } else {
            throw new InvalidArgumentException();
        }
    }
    /**
     * @return int
     */
    public function getHeight()
    {
        return $this->height;
    }
    /**
     * @param mixed $height
     *
     * @throws InvalidArgumentException
     *
     * @return void
     */
    public function setHeight($height)
    {
        if (\is_integer($height)) {
            $this->height = $height;
        } else {
            throw new InvalidArgumentException();
        }
    }
    /**
     * @return null|string
     */
    public function getMimeType()
    {
        return $this->mimeType;
    }
    /**
     * @param string $mimeType
     *
     * @return void
     */
    public function setMimeType($mimeType)
    {
        $this->mimeType = $mimeType;
    }
    /**
     * @return PhotoSize|null
     */
    public function getThumbnail()
    {
        return $this->thumbnail;
    }
    /**
     * @param PhotoSize|null $thumbnail
     *
     * @return void
     */
    public function setThumbnail($thumbnail)
    {
        $this->thumbnail = $thumbnail;
    }
    /**
     * @deprecated use getThumbnail method
     *
     * @return PhotoSize|null
     */
    public function getThumb()
    {
        return $this->getThumbnail();
    }
    /**
     * @deprecated use setThumbnail method
     *
     * @param PhotoSize|null $thumb
     *
     * @return void
     */
    public function setThumb($thumb)
    {
        $this->setThumbnail($thumb);
    }
    /**
     * @return int
     */
    public function getWidth()
    {
        return $this->width;
    }
    /**
     * @param mixed $width
     *
     * @throws InvalidArgumentException
     *
     * @return void
     */
    public function setWidth($width)
    {
        if (\is_integer($width)) {
            $this->width = $width;
        } else {
            throw new InvalidArgumentException();
        }
    }
    /**
     * @return string
     */
    public function getFileUniqueId()
    {
        return $this->fileUniqueId;
    }
    /**
     * @param string $fileUniqueId
     *
     * @return void
     */
    public function setFileUniqueId($fileUniqueId)
    {
        $this->fileUniqueId = $fileUniqueId;
    }
}
