/**
 * Pointer Particles Library
 * Canvas-based particle cursor trail effect
 * 
 * Based on PointerParticle by hexagoncircle - https://codepen.io/hexagoncircle/pen/vYwKNzR
 * 
 * @version 1.0.0
 * @license MIT
 */ !function(t){"use strict";class e{constructor(t,e,s){let{ctx:i,pointer:n,hue:h}=s;this.ctx=i,this.x=n.x,this.y=n.y,this.mx=.1*n.mx,this.my=.1*n.my,this.size=Math.random()+1,this.decay=.01,this.speed=.08*e,this.spread=t*this.speed,this.spreadX=(Math.random()-.5)*this.spread-this.mx,this.spreadY=(Math.random()-.5)*this.spread-this.my,this.color=`hsl(${h}deg 90% 60%)`}draw(){this.ctx.fillStyle=this.color,this.ctx.beginPath(),this.ctx.arc(this.x,this.y,this.size,0,2*Math.PI),this.ctx.fill()}collapse(){this.size-=this.decay}trail(){this.x+=this.spreadX*this.size,this.y+=this.spreadY*this.size}update(){this.draw(),this.trail(),this.collapse()}}class s{constructor(t,e={}){this.element=t,this.canvas=null,this.ctx=null,this.isActive=!1,this.animationId=null,this.options={fps:60,particleCount:20,clickParticleCount:300,colors:["#ff6b6b","#4ecdc4","#45b7d1"],colorCycle:!0,colorCycleSpeed:3,enableClick:!0,enableMove:!0,zIndex:9999,...e},this.msPerFrame=1e3/this.options.fps,this.timePrevious=0,this.particles=[],this.pointer={x:0,y:0,mx:0,my:0},this.hue=0,this.init()}init(){this.createCanvas(),this.setupEvents()}createCanvas(){this.canvas=document.createElement("canvas"),this.ctx=this.canvas.getContext("2d"),this.canvas.style.position="absolute",this.canvas.style.top="0",this.canvas.style.left="0",this.canvas.style.width="100%",this.canvas.style.height="100%",this.canvas.style.margin="0",this.canvas.style.padding="0",this.canvas.style.border="none",this.canvas.style.outline="none",this.canvas.style.pointerEvents="none",this.canvas.style.zIndex=this.options.zIndex.toString(),"static"===getComputedStyle(this.element).position&&(this.element.style.position="relative"),this.element.appendChild(this.canvas),this.setCanvasDimensions()}setCanvasDimensions(){if(!this.canvas)return;let t=this.element.getBoundingClientRect();this.canvas.width=t.width,this.canvas.height=t.height}setupEvents(){this.boundHandlers={move:this.handlePointerMove.bind(this),click:this.handleClick.bind(this),resize:this.handleResize.bind(this)},this.options.enableMove&&(this.element.addEventListener("pointermove",this.boundHandlers.move),this.element.addEventListener("mousemove",this.boundHandlers.move)),this.options.enableClick&&this.element.addEventListener("click",this.boundHandlers.click),window.addEventListener("resize",this.boundHandlers.resize)}handlePointerMove(t){this.setPointerValues(t),this.createParticles({count:this.options.particleCount,speed:this.getPointerVelocity(t),spread:1})}handleClick(t){this.setPointerValues(t),this.createParticles({count:this.options.clickParticleCount,speed:Math.random()+1,spread:Math.random()+50})}handleResize(){this.setCanvasDimensions()}setPointerValues(t){let e=this.element.getBoundingClientRect();this.pointer.x=t.clientX-e.left,this.pointer.y=t.clientY-e.top,this.pointer.mx=t.movementX||0,this.pointer.my=t.movementY||0}getPointerVelocity(t){let e=t.movementX||0,s=t.movementY||0;return Math.floor(Math.sqrt(e*e+s*s))}createParticles(t){for(let s=0;s<t.count;s++)this.particles.push(new e(t.spread,t.speed,this))}handleParticles(){for(let t=0;t<this.particles.length;t++)this.particles[t].update(),this.particles[t].size<=.1&&(this.particles.splice(t,1),t--)}animate(){if(!this.isActive)return;this.animationId=requestAnimationFrame(()=>this.animate());let t=performance.now(),e=t-this.timePrevious;if(e<this.msPerFrame)return;let s=e%this.msPerFrame;this.timePrevious=t-s,this.ctx.clearRect(0,0,this.canvas.width,this.canvas.height),this.options.colorCycle&&(this.hue=this.hue>360?0:this.hue+=this.options.colorCycleSpeed),this.handleParticles()}start(){return this.isActive||(this.isActive=!0,this.timePrevious=performance.now(),this.animate()),this}stop(){return this.isActive=!1,this.animationId&&(cancelAnimationFrame(this.animationId),this.animationId=null),this}destroy(){return this.stop(),this.boundHandlers&&(this.element.removeEventListener("pointermove",this.boundHandlers.move),this.element.removeEventListener("mousemove",this.boundHandlers.move),this.element.removeEventListener("click",this.boundHandlers.click),window.removeEventListener("resize",this.boundHandlers.resize)),this.canvas&&this.canvas.parentNode&&this.canvas.parentNode.removeChild(this.canvas),this.particles=[],this}updateOptions(t){return Object.assign(this.options,t),this.msPerFrame=1e3/this.options.fps,this}}s.create=function(t,e){return new s(t,e)},"undefined"!=typeof module&&module.exports?module.exports=s:"function"==typeof define&&define.amd?define(function(){return s}):t.PointerParticles=s}("undefined"!=typeof window?window:this);