<?php

/**
 * Plugin Name: FlyingPress
 * Plugin URI: https://flyingpress.com
 * Description: Lightning-Fast WordPress on Autopilot
 * Version: 5.2.0
 * Requires PHP: 7.4
 * Requires at least: 4.7
 * Author: FlyingWeb
 */

defined('ABSPATH') or die('No script kiddies please!');

require_once dirname(__FILE__) . '/vendor/autoload.php';
require_once dirname(__FILE__) . '/vendor/woocommerce/action-scheduler/action-scheduler.php';

define('FLYING_PRESS_VERSION', '5.2.0');
define('FLYING_PRESS_FILE', __FILE__);
define('FLYING_PRESS_FILE_NAME', plugin_basename(__FILE__));
define('FLYING_PRESS_PLUGIN_URL', plugin_dir_url(__FILE__));
define('FLYING_PRESS_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('FLYING_PRESS_CACHE_DIR', WP_CONTENT_DIR . '/cache/flying-press/');
define('FLYING_PRESS_CACHE_URL', WP_CONTENT_URL . '/cache/flying-press/');

!is_dir(FLYING_PRESS_CACHE_DIR) && mkdir(FLYING_PRESS_CACHE_DIR, 0755, true);

FlyingPress\WPCache::init();
FlyingPress\Htaccess::init();
FlyingPress\AdvancedCache::init();
FlyingPress\Integrations::init();
FlyingPress\AutoPurge::init();
FlyingPress\License::init();
FlyingPress\Preload::init();
FlyingPress\Config::init();
FlyingPress\Cron::init();
FlyingPress\Caching::init();
FlyingPress\RestApi::init();
FlyingPress\AdminBar::init();
FlyingPress\Optimizer::init();
FlyingPress\FlyingCDN::init();
FlyingPress\Dashboard::init();
FlyingPress\Database::init();
FlyingPress\Compatibility::init();
FlyingPress\Permalink::init();
FlyingPress\Shortcuts::init();
FlyingPress\Vitals::init();
FlyingPress\WpCLI::init();
FlyingPress\Queue::init();

// Bypass external optimization service calls
add_filter('pre_http_request', function($preempt, $parsed_args, $url) {
  // Intercept FlyingPress page optimizer requests
  if (strpos($url, 'page-optimizer.flyingpress.com/optimizer/') !== false) {
    return array(
      'body' => json_encode(array(
        'css_used' => array(
          'used' => '',
          'unused' => ''
        ),
        'css_critical' => '',
        'preload_fonts' => array(),
        'exclude_above_fold' => array(),
        'responsive_images' => array(),
        'lazy_load_bg_elements' => array(),
        'success' => true
      )),
      'response' => array('code' => 200, 'message' => 'OK'),
      'headers' => array('content-type' => 'application/json')
    );
  }

  // Intercept FlyingPress license validation calls
  if (strpos($url, 'license.flyingpress.com') !== false) {
    return array(
      'body' => json_encode(array(
        'valid' => true,
        'license' => array(
          'key' => 'B5E0B5F8DD8689E6ACA49DD6E6E1A930',
          'status' => 'active',
          'activations' => 1,
          'limit' => 5
        )
      )),
      'response' => array('code' => 200, 'message' => 'OK'),
      'headers' => array('content-type' => 'application/json')
    );
  }

  return $preempt;
}, 10, 3);