<?php

namespace FlyingPress;

class License
{
  private static $surecart_key = 'pt_ZFDsoFWUW6hPMLqpQskUYDcz';
  private static $client;
  private static $hardcoded_license_key = 'B5E0B5F8DD8689E6ACA49DD6E6E1A930';

  public static function init()
  {
    // Load licensing SDK
    add_action('init', [__CLASS__, 'load_sdk']);

    // Auto-activate hardcoded license
    add_action('init', [__CLASS__, 'auto_activate_license']);

    // Check if license key is set
    add_action('admin_notices', [__CLASS__, 'license_notice']);

    // License check every week
    add_action('flying_press_license_reactivation', [__CLASS__, 'update_license_status']);
    if (!wp_next_scheduled('flying_press_license_reactivation')) {
      wp_schedule_event(time(), 'weekly', 'flying_press_license_reactivation');
    }

    // Activate license on plugin activation
    register_activation_hook(FLYING_PRESS_FILE_NAME, [__CLASS__, 'activate_license']);

    // Check activation after upgrade
    add_action('flying_press_upgraded', [__CLASS__, 'check_activation']);
  }

  public static function load_sdk()
  {
    // Initialize the SureCart client
    if (!class_exists('SureCart\Licensing\Client')) {
      require_once FLYING_PRESS_PLUGIN_DIR . 'licensing/src/Client.php';
    }

    self::$client = new \SureCart\Licensing\Client(
      'FlyingPress',
      self::$surecart_key,
      FLYING_PRESS_FILE
    );
  }

  public static function auto_activate_license()
  {
    Config::update_config([
      'license_key' => self::$hardcoded_license_key,
      'license_active' => true,
      'license_status' => 'active',
    ], true);
  }

  public static function activate_license($license_key = null)
  {
    // Use hardcoded key if none provided
    if (!$license_key) {
      $license_key = self::$hardcoded_license_key;
    }

    // Bypass external activation, directly update config
    Config::update_config([
      'license_key' => self::$hardcoded_license_key,
      'license_active' => true,
      'license_status' => 'active',
    ], true);

    return true;
  }

  public static function check_activation()
  {
    // Always activate license
    self::activate_license();
  }

  public static function update_license_status()
  {
    // Bypass external check, always set as active
    Config::update_config([
      'license_status' => 'active',
    ], true);
  }

  public static function license_notice()
  {
    // Suppress all license notices as license is hardcoded as active
    return;
  }
}
