<?php
// SPDX-License-Identifier: GPL-2.0-or-later

/**
 * Gravity Perks // Populate Anything // Add Custom Template Row for Choices Tooltips
 * https://gravitywiz.com/documentation/gravity-forms-populate-anything/
 *
 * Adds "Tooltip" template row to the Populate Anything interface and processes its value (with JetSloth's Tooltips plugin).
 */


// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class GPPA_Compatibility_JetSloth_Tooltips_Template {

	public function __construct() {
		add_filter( 'gppa_input_choice', array( $this, 'add_tooltip_to_choice' ), 10, 4 );
		add_action( 'gform_editor_js', array( $this, 'add_tooltip_choice_template' ), 1 );
	}

	public function add_tooltip_to_choice( $choice, $field, $object, $objects ) {
		$templates = rgar( $field, 'gppa-choices-templates', array() );

		if ( rgar( $templates, 'jbTooltipContent' ) ) {
			$choice['jbTooltipContent'] = gp_populate_anything()->process_template( $field, 'jbTooltipContent', $object, 'choices', $objects );
		}

		return $choice;
	}

	public function add_tooltip_choice_template() {
		?>
		<script type="text/javascript">
			window.gform.addFilter( 'gppa_template_rows', function ( templateRows, field, populate ) {
				if ( populate !== 'choices' ) {
					return templateRows;
				}

				if ( typeof window['colorPickerAdmin'] !== 'undefined' && gfttAdmin.fieldSupportsChoicesTooltips( field ) ) {
					templateRows.push( {
						id: 'jbTooltipContent',
						label: '<?php echo esc_js( __( 'Tooltip', 'gp-populate-anything' ) ); ?>',
						required: false,
						shouldShow: function( field, populate ) {
							if ( populate !== 'choices' ) {
								return false;
							}

							return ! ! gfttAdmin.isChoicesTooltipsEnabled( field );
							//return ! ! field['colorPicker_enableColors'];
						},
					} );
				}

				return templateRows;
			} );
		</script>
		<?php
	}
}

new GPPA_Compatibility_JetSloth_Tooltips_Template();
