(function ($) {
    "use strict";
    var HTMegaBlobShape = function ( $scope, $ ){
        var container_elem = $scope.find('.htmega-blob-shape-wrapper').eq(0);
        if ( container_elem.length > 0 ) {
            container_elem[0].style.display='block';
            var settings = container_elem.data('settings');
            if (!settings) {
                return;
            }
            var blobPath = $('.htmega-blob-path-'+ settings['sectionid']);

            var blobAnimationProperties = {
                targets: blobPath[0],
                d: settings['blob_path'],
                easing: 'easeOutQuad',
                direction: 'alternate',
                duration: parseFloat( settings['blob_duration'] ), 
                delay: parseFloat( settings['blob_delay'] ),
                endDelay: parseFloat( settings['blob_end_delay'] ),
                loop: settings['blob_loop'],
            };
            anime(blobAnimationProperties);

       }
 
    }
    // Run this code under Elementor.
    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/htmega-blob-shape-addons.default', HTMegaBlobShape);
    });      


})(jQuery);
