(function ($) {
    'use strict';

    var ElementorWidgetWhatsAppChat = function ($scope, $) {

        const htmegaWhatsApps = $scope.find('.htmega-whatsapp-chat-popup-wrap')[0];
            
        htmegaWhatsApps.addEventListener("click", function(e) {
            const htmegaWhatsAppWrap = this.querySelector(".htmega-whatsapp-chat-popup-box");
            const htmegaWhatsAppAgentsLink = this.querySelectorAll('.htmega-whatsapp-chat-agent-link');
            const htmegaWhatsAppAgentsMessageBox = this.querySelector('.htmega-whatsapp-chat-agents-message-box');
            const htmegaWhatsAppAgentsLinkNumber = this.querySelector('.htmega-whatsapp-chat-message-send-link');
            const htmegaWhatsAppAgentsLinkClose = this.querySelector('.htmega-whatsapp-chat-agent-message-box-close');
            const htmegWhatsAppMessage = this.querySelector(".htmega-whatsapp-chat-agents-mess-input");

            // WhatsApp Button Action
            if(e.target.classList.contains("htmega-whatsapp-chat-button") || e.target.closest(".htmega-whatsapp-chat-button")){
                htmegaWhatsAppWrap.classList.toggle('htmega-whatsapp-popup-show');
            }
            if(e.target.classList.contains("htmega-whatsapp-chat-close-icon") || e.target.closest(".htmega-whatsapp-chat-close-icon")){
                htmegaWhatsAppWrap.classList.remove('htmega-whatsapp-popup-show');
            }
            
            // WhatsApp Agents Link Action
            htmegaWhatsAppAgentsLink.forEach((targetEl) => {
                targetEl.addEventListener('click', (e) => {
                    e.preventDefault()
                    htmegaWhatsAppAgentsLink.forEach((item) => {
                        item.classList.remove("htmega-whatsapp-agent-show");
                        item.style.display = 'none'
                    });
                    targetEl.style.display = 'flex'
                    targetEl.classList.add("htmega-whatsapp-agent-show")
                    htmegaWhatsAppAgentsMessageBox.classList.add("htmega-whatsapp-chat-agents-message-box-active")
                    htmegaWhatsAppAgentsLinkNumber.href = targetEl.href
                    htmegaWhatsAppAgentsLinkClose.classList.add('htmega-whatsapp-chat-closer')
                })
                // WhatsApp Agents Text Area Action
                htmegaWhatsAppAgentsLinkClose.addEventListener('click', function(){
                    targetEl.style.display = 'flex'
                    targetEl.classList.remove("htmega-whatsapp-agent-show")
                    htmegaWhatsAppAgentsMessageBox.classList.remove("htmega-whatsapp-chat-agents-message-box-active")
                    this.classList.remove('htmega-whatsapp-chat-closer')
        
                })
            })

            htmegaWhatsAppAgentsLinkNumber.addEventListener('click', function(e){
                e.preventDefault();
                const value = htmegWhatsAppMessage.value;
                const href = e.target.href;
                const url = new URL(href);
                const search_params = url.searchParams;
                search_params.set('text', value);
                var new_url = url.toString();
                window.location.href = new_url;
                
            })
        })

    }

    // Run this code under Elementor.
    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/htmega-whatsapp-chat-addons.default', ElementorWidgetWhatsAppChat);
    });    

})(jQuery);