<?php
namespace HTMegaPro;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

 /**
 * Assets Manager
 */
 class HTMega_Scripts{

    private static $instance = null;

    public static function instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    function __construct(){
        $this->init();
    }

    public function init() {
        // Frontend Scripts
        add_action( 'wp_enqueue_scripts', [ $this, 'frontend_scripts' ] );
        add_action( 'admin_enqueue_scripts', [ $this, 'htmega_pro_admin_scripts'],20 );
        // Elementor Editor Style
        add_action( 'elementor/editor/after_enqueue_styles', [ $this, 'editor_pro_scripts' ] );

    }

    /**
     * Enqueue frontend scripts
     */
    public function frontend_scripts() {

        // CSS
        wp_register_style( 
            'htmega-pro-global-style', 
            HTMEGA_ADDONS_PL_URL_PRO . 'assets/css/htmega-pro-global-style.css',
            NULL,
            HTMEGA_VERSION_PRO
        );
        wp_register_script( "htmega-pro-conditionals-script", HTMEGA_ADDONS_PL_URL_PRO ."assets/js/htmega-pro-conditional.js", array( "jquery" ), HTMEGA_VERSION_PRO, true );

        $htmega_free_version = get_option( 'htmega_elementor_addons_version' );

        if( version_compare( $htmega_free_version, '2.6.7', '>' ) ) {
            if( !is_plugin_active('elementor/elementor.php') ){
                return;
            } 
            if ( htmega_is_editing_mode() ) {
                wp_enqueue_style( 'htmega-pro-widgets-style' );
            }
        }
        wp_enqueue_script( 'htmega-pro-active' );
        wp_enqueue_style( 'htmega-pro-global-style' );


        $regenerate_elementor_file = get_option( 'htmega_pro_elementor_regenerate_file' );
            
        if ( ! $regenerate_elementor_file ){
            \Elementor\Plugin::$instance->files_manager->clear_cache();
            update_option( 'htmega_pro_elementor_regenerate_file', HTMEGA_VERSION_PRO );
        }
    }
    /**
     * Enqueue admin scripts
     */
    public function htmega_pro_admin_scripts() {

        $url_data = array(
            'site_url' => site_url(),
        );
        wp_localize_script( 'htmega-admin', 'site_url_data', $url_data );

    }

    /**
     * [editor_scripts]
     * @return [void] Load Editor Scripts
     */
    public function editor_pro_scripts() {
        wp_enqueue_style('htmega-pro-element-editor', HTMEGA_ADDONS_PL_URL_PRO . 'assets/css/htmega-pro-elementor-editor.css',['elementor-editor'], HTMEGA_VERSION_PRO );
    }
}

HTMega_Scripts::instance();