<?php

namespace HTMegaPro\Extension\Conditional_Display\Conditions;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Class Browser
 * Contain all element of browser condition
 * @package HTMegaPro\Extension\Conditional_Display\Conditions
 */
class Browser extends Condition {

	/**
	 * Get Condition Key
	 *
	 * @return string|void
	 */
	public function get_key_name() {
		return 'browser';
	}

	/**
	 * Get Condition Title
	 *
	 * @return string|void
	 */
	public function get_title() {
		return __( 'Browser', 'htmega-pro' );
	}

	/**
	 * Get Repeater Control Field Value
	 *
	 * @param array $condition
	 * @return array|void
	 */
	public function get_repeater_control( array $condition ) {
		return [
			'label' => $this->get_title(),
			'show_label' => false,
			'type' => Controls_Manager::SELECT,
			'default' => 'chrome',
			'label_block' => true,
			'options' 		=> [
				'opera'			=> __( 'Opera', 'htmega-pro' ),
				'edge'			=> __( 'Edge', 'htmega-pro' ),
				'chrome'		=> __( 'Google Chrome', 'htmega-pro' ),
				'safari'		=> __( 'Safari', 'htmega-pro' ),
				'firefox'		=> __( 'Mozilla Firefox', 'htmega-pro' ),
				'ie'			=> __( 'Internet Explorer', 'htmega-pro' ),
				'others'			=> __( 'Others', 'htmega-pro' ),
			],
			'condition' => $condition,
		];
	}

	/**
	 * Compare Condition value
	 *
	 * @param $settings
	 * @param $operator
	 * @param $value
	 * @return bool|void
	 */
	public function compare_value( $settings, $operator, $value ) {
		$user_agent = htmega_get_browser_name( $_SERVER['HTTP_USER_AGENT'] );
		return htmega_value_compare( $user_agent, $value, $operator );
	}
}
