<?php
namespace HTMegaPro\Extension\Conditional_Display\Conditions;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Class Day
 * Contain all element of day condition
 * @package HTMegaPro\Extension\Conditional_Display\Conditions
 */
class Day extends Condition {

	/**
	 * Get Condition Key
	 *
	 * @return string|void
	 */
	public function get_key_name() {
		return 'day';
	}

	/**
	 * Get Condition Title
	 *
	 * @return string|void
	 */
	public function get_title() {
		return __( 'Day', 'htmega-pro' );
	}

	/**
	 * Get Repeater Control Field Value
	 *
	 * @param array $condition
	 * @return array|void
	 */
	public function get_repeater_control( array $condition ) {
		return[
			'label' 		=> $this->get_title(),
			'show_label' 	=> false,
			'type' => Controls_Manager::SELECT,
			'default' => 'monday',
			'label_block' => true,
			'options' => [
				'monday'    => __( 'Monday', 'htmega-pro' ),
				'tuesday'   => __( 'Tuesday', 'htmega-pro' ),
				'wednesday' => __( 'Wednesday', 'htmega-pro' ),
				'thursday'  => __( 'Thursday', 'htmega-pro' ),
				'friday'    => __( 'Friday', 'htmega-pro' ),
				'saturday'  => __( 'Saturday', 'htmega-pro' ),
				'sunday'    => __( 'Sunday', 'htmega-pro' ),
			],
			'condition'	=> $condition,
		];
	}

	/**
	 * Compare Condition value
	 *
	 * @param $settings
	 * @param $operator
	 * @param $value
	 * @return bool|void
	 */
	public function compare_value ( $settings, $operator, $value ) {

		$today = htmega_get_server_time( 'l' );
		if ( 'local' === $settings['htmega_time_zone'] ) {
			$today = htmega_get_local_time( 'l' );
		}

		return htmega_value_compare( strtolower( $today ), $value, $operator );
	}

}
