<?php
namespace HTMegaPro\Extension\Conditional_Display\Conditions;

use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Class Url_String
 * Contain all element of url string text condition
 * @package HTMegaPro\Extension\Conditional_Display\Conditions
 */
class Url_String extends Condition {

	/**
	 * Get Condition Key
	 *
	 * @return string|void
	 */
	public function get_key_name() {
		return 'url_string';
	}

	/**
	 * Get Condition Title
	 *
	 * @return string|void
	 */
	public function get_title() {
		return __( 'URL String', 'htmega-pro' );
	}

	/**
	 * Get Repeater Control Field Value
	 *
	 * @param array $condition
	 * @return array|void
	 */
	public function get_repeater_control( array $condition ) {
			return [
				'label' 		=> $this->get_title(),
				'show_label' 	=> false,
				'type'        => Controls_Manager::TEXT,
				'description' => __( 'Enter the string that you want to check if exists in the page URL.', 'htmega-pro' ),
				'label_block' 	=> true,
				'condition' 		=> $condition,
			];
	}

	/**
	 * Compare Condition value
	 *
	 * @param $settings
	 * @param $operator
	 * @param $value
	 * @return bool|void
	 */
	public function compare_value( $settings, $operator, $value ) {

		if ( ! isset( $_SERVER['REQUEST_URI'] ) || empty( $_SERVER['REQUEST_URI'] ) ) {
			return;
		}

		$url = sanitize_text_field( wp_unslash( $_SERVER['REQUEST_URI'] ) );

		if ( ! $url ) {
			return false;
		}

		$condition_result = false !== strpos( $url, $value ) ? true : false;

		return htmega_value_compare( $condition_result, true, $operator );
	}
}
