<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class HTMegaBuilder_Admin_Settings {

    private $settings_api;

    function __construct() {
        add_filter( 'htmega_admin_fields_sections', [ $this, 'fields_section' ], 10, 1 );

        $this->settings_api = new HTmega_Settings_API();
        add_action( 'admin_init', [ $this, 'admin_init' ] );
    }

    // Admin Initialize
    function admin_init() {
        //initialize settings
        $this->settings_api->admin_init();
    }


     /**
     * Admin Fields Section Route
     *
     * @param [array] $sections
     * @return void
     */
    public function fields_section( $sections ){

        $sections['themebuilder'] = array(
            'id'    => 'htmega_themebuilder_element_tabs',
            'title' => esc_html__( 'Theme Builder', 'htmega-pro' ),
            'icon'  => 'htmega htmega-themebuilder',
            'content' => [
                'column' => 3,
                'title' => __( 'Theme Builder Widget List', 'htmega-pro' ),
                'desc'  => __( "Feel free to utilize these components to craft your website. You have the flexibility to activate or deactivate any elements you're not using, with associated assets being disabled to enhance your site's loading speed.", "htmega-pro" ),
            ],
            ''
        );

        return $sections;

    }


    // Admin Menu Page Render
    function plugin_page() {

        echo '<div class="wrap">';
            echo '<h2>'.esc_html__( 'HT Builder Settings','htmega-pro' ).'</h2>';
            $this->save_message();
            $this->settings_api->show_navigation();
            $this->settings_api->show_forms();
        echo '</div>';

    }

    // Save Options Message
    function save_message() {
        if( isset($_GET['settings-updated']) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended ?>
            <div class="updated notice is-dismissible"> 
                <p><strong><?php esc_html_e('Successfully Settings Saved.', 'htmega-pro') ?></strong></p>
            </div>
            <?php
        }
    }


}

new HTMegaBuilder_Admin_Settings();