<?php
namespace HTMega_Pro_Builder\Elementor\Widget;

use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\HTMega_Icon_manager;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Bl_Post_Navigation_ELement extends Widget_Base {

    public function get_name() {
        return 'bl-post-navigation';
    }

    public function get_title() {
        return __( 'Post Navigation', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-post-navigation';
    }

    public function get_categories() {
        return ['htmega_builder'];
    }
    public function get_keywords() {
        return ['post navigation', 'post pagination', 'post next prev', 'next post', 'previous post','htmega', 'ht mega', 'addons'];
    }

    public function get_help_url() {
        return 'https://wphtmega.com/docs';
    }
    protected function register_controls() {

        // Content
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Post Navigation', 'htmega-pro' ),
            ]
        );
            
            $this->add_control(
                'show_custom_label',
                [
                    'label' => __( 'Show label', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => __( 'Show', 'htmega-pro' ),
                    'label_off' => __( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );

            $this->add_control(
                'previous_label',
                [
                    'label' => __( 'Previous', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Previous', 'htmega-pro' ),
                    'placeholder' => __( 'Type your title here', 'htmega-pro' ),
                    'condition' => [
                        'show_custom_label' => 'yes'
                    ]
                ]
            );
            
            $this->add_control(
                'next_label',
                [
                    'label' => __( 'Next', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Next', 'htmega-pro' ),
                    'placeholder' => __( 'Type your title here', 'htmega-pro' ),
                    'condition' => [
                        'show_custom_label' => 'yes'
                    ]

                ]
            );

            $this->add_control(
                'show_arrow',
                [
                    'label' => __( 'Show Arrow', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => __( 'Show', 'htmega-pro' ),
                    'label_off' => __( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'separator'=>'before',
                ]
            );

            $this->add_control(
                'previous_arrow',
                [
                    'label' => __( 'Previous Arrow', 'htmega-pro' ),
                    'type' => Controls_Manager::ICONS,
                    'default' => [
                        'value' => 'fas fa-angle-left',
                        'library' => 'fa-solid',
                    ],
                    'recommended' => [
                        'fa-solid' => [
                            'arrow-circle-left',
                            'arrow-left',
                            'long-arrow-alt-left',
                            'angle-double-left',
                            'angle-left',
                            'caret-left',
                            'chevron-circle-left',
                            'chevron-left',
                        ],
                        'fa-regular' => [
                            'arrow-alt-circle-left',
                            'caret-square-left',
                            'hand-point-left',
                        ],                        
                    ],
                    'condition' => [
                        'show_arrow' => 'yes'
                    ]
                ]
            );
            // arrow-alt-circle-right
            $this->add_control(
                'next_arrow',
                [
                    'label' => __( 'Next Arrow', 'htmega-pro' ),
                    'type' => Controls_Manager::ICONS,
                    'default' => [
                        'value' => 'fas fa-angle-right',
                        'library' => 'fa-solid',
                    ],
                    'recommended' => [
                        'fa-solid' => [
                            'arrow-circle-right',
                            'arrow-right',
                            'long-arrow-alt-right',
                            'angle-double-right',
                            'angle-right',
                            'caret-right',
                            'chevron-circle-right',
                            'chevron-right',
                        ],
                        'fa-regular' => [
                            'arrow-alt-circle-right',
                            'caret-square-right',
                            'hand-point-right',
                        ],                        
                    ],
                    'condition' => [
                        'show_arrow' => 'yes'
                    ]
                ]
            );

            $this->add_control(
                'show_title',
                [
                    'label' => __( 'Show Title', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => __( 'Show', 'htmega-pro' ),
                    'label_off' => __( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'separator'=>'before',
                ]
            );

        $this->end_controls_section();

        // Style
        $this->start_controls_section(
            'area_style_section',
            array(
                'label' => __( 'Navigation Wrapper', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            )
        );
            
            $this->add_control(
                'area_margin',
                [
                    'label' => __( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htbuilder-postnavigation' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'area_padding',
                [
                    'label' => __( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htbuilder-postnavigation' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'area_border',
                    'label' => __( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htbuilder-postnavigation',
                ]
            );

        $this->end_controls_section();

        // Label Style
        $this->start_controls_section(
            'label_style_section',
            array(
                'label' => __( 'Label', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            )
        );
            
            $this->start_controls_tabs( 'label_style_tabs' );
                
                $this->start_controls_tab(
                    'label_style_normal_tab',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'label_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '#444444',
                            'selectors' => [
                                '{{WRAPPER}} .htcustom-lavel' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'label_typography',
                            'label' => __( 'Typography', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htcustom-lavel',
                        ]
                    );

                $this->end_controls_tab();
                
                // Hover
                $this->start_controls_tab(
                    'label_style_hover_tab',
                    [
                        'label' => __( 'Hover', 'htmega-pro' ),
                    ]
                );
                    
                    $this->add_control(
                        'label_hover_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '#444444',
                            'selectors' => [
                                '{{WRAPPER}} .htnavigation a:hover .htcustom-lavel' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                $this->end_controls_tab();

            $this->end_controls_tabs();

        $this->end_controls_section();

        // Title Style
        $this->start_controls_section(
            'title_style_section',
            array(
                'label' => __( 'Title', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            )
        );
            
            $this->start_controls_tabs( 'title_style_tabs' );
                
                $this->start_controls_tab(
                    'title_style_normal_tab',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'title_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '#444444',
                            'selectors' => [
                                '{{WRAPPER}} .htnavigation_title' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'title_typography',
                            'label' => __( 'Typography', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htnavigation_title',
                        ]
                    );

                $this->end_controls_tab();
                
                // Hover
                $this->start_controls_tab(
                    'title_style_hover_tab',
                    [
                        'label' => __( 'Hover', 'htmega-pro' ),
                    ]
                );
                    
                    $this->add_control(
                        'title_hover_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '#444444',
                            'selectors' => [
                                '{{WRAPPER}} .htnavigation a:hover .htnavigation_title' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                $this->end_controls_tab();

            $this->end_controls_tabs();

        $this->end_controls_section();

        // Arrow Style
        $this->start_controls_section(
            'arrow_style_section',
            array(
                'label' => __( 'Arrow', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            )
        );
            
            $this->start_controls_tabs( 'arrow_style_tabs' );
                
                $this->start_controls_tab(
                    'arrow_style_normal_tab',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                );
                    
                    $this->add_control(
                        'arrow_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '#444444',
                            'selectors' => [
                                '{{WRAPPER}} .htnavigation_arrow' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_control(
                        'arrow_size',
                        [
                            'label' => __( 'Font Size', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 100,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 16,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htnavigation_arrow' => 'font-size: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );

                    $this->add_control(
                        'arrow_space',
                        [
                            'label' => __( 'Space', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 100,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 12,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htnavigation_arrow' => 'padding-right: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .htnext .htnavigation_arrow' => 'padding-right: 0;padding-left: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );

                $this->end_controls_tab();
                
                // Hover
                $this->start_controls_tab(
                    'arrow_style_hover_tab',
                    [
                        'label' => __( 'Hover', 'htmega-pro' ),
                    ]
                );
                    
                    $this->add_control(
                        'arrow_hover_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '#444444',
                            'selectors' => [
                                '{{WRAPPER}} .htnavigation a:hover .htnavigation_arrow' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                $this->end_controls_tab();

            $this->end_controls_tabs();

        $this->end_controls_section();

    }

    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();

        //Custom Label
        $prev_custom_lavel = $next_custom_lavel = '';
        if( $settings['show_custom_label'] == 'yes' ){
            $prev_custom_lavel = '<span class="htcustom-lavel">' . wp_kses_post( $settings['previous_label'] ) . '</span>';
            $next_custom_lavel = '<span class="htcustom-lavel">' . wp_kses_post( $settings['next_label'] ).'</span>';
        }

        // Title
        $prev_title = $next_title = '';
        if( $settings['show_title'] == 'yes' ){
            $prev_title = '<span class="htnavigation_title">%title</span>';
            $next_title = '<span class="htnavigation_title">%title</span>';
        }

        // arrow
        $prev_arrow = $next_arrow = '';
        if( $settings['show_arrow'] == 'yes' ){
            $prev_arrow = '<span class="htnavigation_arrow">'.HTMega_Icon_manager::render_icon($settings['previous_arrow'], ['aria-hidden' => 'true']).'</span>';
            $next_arrow = '<span class="htnavigation_arrow">'.HTMega_Icon_manager::render_icon($settings['next_arrow'], ['aria-hidden' => 'true']).'</span>';
        }

        ?>
            <div class="htbuilder-postnavigation">
                <div class="htnavigation htprev">
                    <?php previous_post_link( '%link', $prev_arrow. '<span class="htnavigation-info">' . $prev_custom_lavel . $prev_title . '</span>' ); ?>
                </div>
                <div class="htnavigation htnext">
                    <?php next_post_link( '%link', '<span class="htnavigation-info">' . $next_custom_lavel . $next_title . '</span>' . $next_arrow ); ?>
                </div>
            </div>
        <?php

    }

}
