(function ($) {
    var HTMegaParallaxHandler = function ($scope) {
        if (!$scope.hasClass("htmega-parallax-yes"))
            return;

            var target = $scope,
            sectionId = target.data("id"),
            elementType = target.data('element_type'),
            tempTarget = target.find('#htmega-parallax-' + sectionId),
            editMode = elementorFrontend.isEditMode() && tempTarget.length > 0,
            targetID = editMode ? tempTarget : target;
            var parallaxdata = targetID.data("htmega-parallax");
            var scrollSpeed = parallaxdata.speed;
            var android = parallaxdata.android;
            var bgRepeat = parallaxdata.repeat;
            var bdSize = parallaxdata.size;
            var bgPosition = (parallaxdata.position)?parallaxdata.position:'0 0';
            var ios = parallaxdata.ios;
            if( undefined !== parallaxdata && 'multi' == parallaxdata.type ){
                var multiImages = parallaxdata.items;
                var devices = parallaxdata.devices;
                var multiItemsHtmlM = '';
                var multiItemsHtmlS = '';
                var multiItemsStye = '';
                var itemcount = 1;
                var currentDevice = elementorFrontend.getCurrentDeviceMode();

                if (devices.includes(currentDevice)) {

                    deviceCheck = ('desktop' === currentDevice) ? '' : '_' + currentDevice;
                    if( Object.keys(multiImages).length > 0 ) {

                        multiImages.forEach(element => {
                            if ( element['show_htmega_parallax_item_on'].includes(currentDevice) ) {

                                var depthY = ( 'htmega_parallax_item_mouse_movement'== element['htmega_parallax_item_effect'] )? element['htmega_parallax_item_depth_y']:0;
                                var depthX = ('htmega_parallax_item_mouse_movement'== element['htmega_parallax_item_effect'])? element['htmega_parallax_item_depth_x']:0;

                                var htmega_parallax_item_pos_x = undefined !== element["htmega_parallax_item_pos_x" + deviceCheck] ? element["htmega_parallax_item_pos_x" + deviceCheck].size : element["htmega_parallax_item_pos_x"].size;
                                var htmega_parallax_item_pos_y = undefined !== element["htmega_parallax_item_pos_y" + deviceCheck] ? element["htmega_parallax_item_pos_y" + deviceCheck].size : element["htmega_parallax_item_pos_y"].size;
                                var htmega_parallax_item_custom_size ='';
                                if('yes'== element['htmega_parallax_item_custom_size']){
                                    var htmega_parallax_item_with = undefined !== element["htmega_parallax_item_with" + deviceCheck] ? element["htmega_parallax_item_with" + deviceCheck].size : element["htmega_parallax_item_with"].size;

                                    var htmega_parallax_item_with_unit = undefined !== element["htmega_parallax_item_with" + deviceCheck] ? element["htmega_parallax_item_with" + deviceCheck].unit : element["htmega_parallax_item_with"].unit;
                                    console.log(htmega_parallax_item_with_unit);

                                    htmega_parallax_item_custom_size = `width:${htmega_parallax_item_with+htmega_parallax_item_with_unit};`;
                                }
                                var htmega_parallax_item_z_index = element['htmega_parallax_item_z_index'];

                                if( 'htmega_parallax_item_mouse_movement'== element['htmega_parallax_item_effect'] ){
                                multiItemsHtmlM += `<div class="htmega-parallax-move-item item-count-${itemcount}" data-depth-y="${depthY}" data-depth-x="${depthX}"> <img src="${element['htmega_parallax_item_image'].url}" alt="${element['alt']}"></div>`;

                                } else {
                                    var htmega_parallax_item_speed = 0,htmega_parallax_item_scroll_max_axis=0,htmega_parallax_item_scroll_min_axis=0;
                                    htmega_parallax_item_speed = undefined !== element["htmega_parallax_item_speed" + deviceCheck] ? element["htmega_parallax_item_speed" + deviceCheck].size : element["htmega_parallax_item_speed"].size;

                                    htmega_parallax_item_scroll_max_axis = undefined !== element["htmega_parallax_item_scroll_max_axis" + deviceCheck] ? element["htmega_parallax_item_scroll_max_axis" + deviceCheck].size : element["htmega_parallax_item_scroll_max_axis"].size;

                                    htmega_parallax_item_scroll_min_axis = undefined !== element["htmega_parallax_item_scroll_min_axis" + deviceCheck] ? element["htmega_parallax_item_scroll_min_axis" + deviceCheck].size : element["htmega_parallax_item_scroll_min_axis"].size;

                                    //if('vertical' == element['item_scroll_direction'] ){

                                        multiItemsHtmlS += `<div class="htmega-rellax-item rellax-vertical${sectionId}" data-rellax-speed="${htmega_parallax_item_speed}" data-rellax-max="${htmega_parallax_item_scroll_max_axis}" data-rellax-min="${htmega_parallax_item_scroll_min_axis}" style="top:${htmega_parallax_item_pos_y}%; ${htmega_parallax_item_custom_size} left:${htmega_parallax_item_pos_x}%;z-index:${htmega_parallax_item_z_index};"> <img src="${element['htmega_parallax_item_image'].url}" alt="${element['alt']}"></div>`;
                                    // } else {
                                    //     multiItemsHtmlS += `<div class="htmega-rellax-item rellax-horizontal${sectionId}" data-rellax-max-x="${htmega_parallax_item_scroll_max_axis}"data-rellax-horizontal-speed="${htmega_parallax_item_speed}" data-rellax-vertical-scroll-axis="x" data-rellax-min-x="${htmega_parallax_item_scroll_min_axis}" data-rellax-percentage="0" style="top:${htmega_parallax_item_pos_y}%; ${htmega_parallax_item_custom_size} left:${htmega_parallax_item_pos_x}%;z-index:${htmega_parallax_item_z_index};"> <img src="${element['htmega_parallax_item_image'].url}" alt="${element['alt']}"></div>`;
                                    // }

                                }

                                multiItemsStye+=`#itemId${sectionId} .item-count-${itemcount}{top:${htmega_parallax_item_pos_y}%!important; ${htmega_parallax_item_custom_size} left:${htmega_parallax_item_pos_x}%!important;z-index:${htmega_parallax_item_z_index}; }`;
                                itemcount++;
                            }
                        });

                        if( multiItemsHtmlM ){

                            multiItemsStye = `<style> ${multiItemsStye}</style>`;
                            multiItemsHtmlM = `<div class="htmega-parallax-image htmega-parallax-image-3" id="itemId${sectionId}"> ${multiItemsHtmlM}</div>`;
                        
                            targetID.prepend(multiItemsHtmlM);
                            targetID.prepend(multiItemsStye);

                            var scene = document.getElementById("itemId"+sectionId);
                            var parallaxInstance = new Parallax(scene);
                        }
                        //  multiImages scroll activation
                        if( multiItemsHtmlS ){
                            multiItemsHtmlS = `<div class="htmega-parallax-image htmega-parallax-scroll-items" id="itemIds${sectionId}"> ${multiItemsHtmlS}</div>`;
                            targetID.prepend(multiItemsHtmlS);
                            var rellax = new Rellax('.rellax-vertical'+sectionId, {
                                center: true,
                            });
                            // var rellax = new Rellax('.rellax-horizontal'+sectionId, {
                            //     center: false,
                            //     horizontal: true,
                            // });
                        }
                    }
                }
                //Multiiamge end
            } else if(  undefined !== parallaxdata && 'multi' !== parallaxdata.type ) { 

                if (elementType === 'column') {
                    target = $scope.find('.elementor-column-wrap').first();

                    if (target.length < 1)
                        target = $scope.find('.elementor-widget-wrap').first();
                }

                function removeOnResponsive(android, ios) {
                    switch (true || 1) {
                        case android && ios:
                            return /iPad|iPhone|iPod|Android/;
                        case android && !ios:
                            return /Android/;
                        case !android && ios:
                            return /iPad|iPhone|iPod/;
                        case !android && !ios:
                            return null;
                    }
                }
                if( !$('body').hasClass( "elementor-editor-active") ){
                
                    target.jarallax({
                        type: parallaxdata.type,
                        speed: scrollSpeed || 0.1,
                        disableParallax: removeOnResponsive(1 == android, 1 == ios),
                        keepImg: true,
                        imgSize: bdSize,
                        imgPosition: bgPosition,
                        imgRepeat: bgRepeat
                    });
                }
            }
    };

    $(window).on('elementor/frontend/init', function () {

        elementorFrontend.hooks.addAction("frontend/element_ready/section", HTMegaParallaxHandler);
        elementorFrontend.hooks.addAction("frontend/element_ready/column", HTMegaParallaxHandler);
        elementorFrontend.hooks.addAction("frontend/element_ready/container", HTMegaParallaxHandler);
    });

})(jQuery);