<?php 
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Control_Media;


class HTMegaParallax_Elementor {

	private static $assets_load = null;

    private static $_instance = null;
    public static function instance() {
        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    public function __construct() {

		add_action( 'elementor/preview/enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		add_action( 'elementor/preview/enqueue_styles', array( $this, 'enqueue_styles' ) );

		// Creates  Parallax tab at the end of section/column layout tab.
		add_action( 'elementor/element/section/section_layout/after_section_end', array( $this, 'register_controls' ), 10 );
		add_action( 'elementor/element/column/section_advanced/after_section_end', array( $this, 'register_controls' ), 10 );

		add_action( 'elementor/section/print_template', array( $this, '_print_template' ), 10, 2 );
		add_action( 'elementor/column/print_template', array( $this, '_print_template' ), 10, 2 );

		// add data before section/column rendering.
		add_action( 'elementor/frontend/section/before_render', array( $this, 'before_render' ), 10, 1 );
		add_action( 'elementor/frontend/column/before_render', array( $this, 'before_render' ), 10, 1 );

		add_action( 'elementor/frontend/section/before_render', array( $this, 'check_assets_enqueue' ) );
		add_action( 'elementor/frontend/column/before_render', array( $this, 'check_assets_enqueue' ) );

    }

	/**
	 * Enqueue styles.
	 *
	 * Registers required dependencies for the extension and enqueues them.
	 *
	 * @since 1.4.0
	 * @access public
	 */
	public static function enqueue_styles() {
		//CSS File
		wp_enqueue_style(  'htmega-parallax',  HTMEGA_ADDONS_PL_URL_PRO . 'extensions/parallax/assets/css/htmega-parallax.css', array(), HTMEGA_VERSION_PRO );
	}

	/**
	 * Enqueue scripts.
	 *
	 * Enqueue required JS dependencies for the extension.
	 *
	 * @since 1.4.0
	 * @access public
	 */
	public static function enqueue_scripts() {
        // JS File
        wp_enqueue_script( 'parallax', HTMEGA_ADDONS_PL_URL_PRO . 'extensions/parallax/assets/js/parallax.min.js', array('jquery'),'3.1.0' );
        wp_enqueue_script( 'jarallax', HTMEGA_ADDONS_PL_URL_PRO . 'extensions/parallax/assets/js/jarallax.min.js', array('jquery'),'2.0.4' );
        wp_enqueue_script( 'rellax', HTMEGA_ADDONS_PL_URL_PRO . 'extensions/parallax/assets/js/rellax.min.js', array('jquery'),HTMEGA_VERSION_PRO );
        wp_enqueue_script( 'htmega-parallax', HTMEGA_ADDONS_PL_URL_PRO . 'extensions/parallax/assets/js/htmega-parallax.js', array('jquery'),HTMEGA_VERSION_PRO );

	}

	 //Register Parallax controls.
	public function register_controls( $element ) {

		$element->start_controls_section(
			'section_htmega_parallax',
			[
				'label' => __( 'HT Mega Parallax', 'htmega-pro' ),
				'tab'   => Controls_Manager::TAB_LAYOUT,
			]
		);

		$element->add_control(
			'htmega_parallax_switcher',
			[
				'label'        => __( 'Enable Parallax', 'htmega-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'prefix_class' => 'htmega-parallax-',
				'render_type'  => 'template',
			]
		);
		$element->add_control(
			'htmega_parallax_update',
			[
				'label' => '<div class="elementor-update-preview editor-htmega-preview-update" style="background-color: #fff;"><div class="elementor-update-preview-title">Apply to Update changes</div><div class="elementor-update-preview-button-wrapper"><button class="elementor-update-preview-button elementor-button elementor-button-success">Apply</button></div></div>',
				'type'  => Controls_Manager::RAW_HTML,
				'condition'=>[
					'htmega_parallax_switcher'=>'yes'
				]
			]
		);
		$options = array(
			'scroll'         => __( 'Scroll', 'htmega-pro' ),
			'scroll-opacity' => __( 'Scroll + Opacity', 'htmega-pro' ),
			'opacity'        => __( 'Opacity', 'htmega-pro' ),
			'scale'          => __( 'Scale', 'htmega-pro' ),
			'scale-opacity'  => __( 'Scale + Opacity', 'htmega-pro' ),
			'multi'          => __( 'Multi Layer Parallax', 'htmega-pro' ),
		);

		if ( strpos( current_filter(), 'column/' ) ) {
			unset( $options['multi'] );
		}

		$element->add_control(
			'htmega_parallax_type',
			array(
				'label'       => __( 'Parallax Type', 'htmega-pro' ),
				'type'        => Controls_Manager::SELECT,
				'options'     => $options,
				'label_block' => 'true',
				'default' => 'scroll',
				'render_type' => 'template',
				'condition' => [
					'htmega_parallax_switcher'=>'yes'
				]
			)
		);
		$element->add_control(
			'htmega_parallax_speed',
			array(
				'label'     => __( 'Speed', 'htmega-pro' ),
				'type'      => Controls_Manager::SLIDER,

				'default'   => array(
					'size' => 0.5,
				),
				'range'     => array(
					'px' => array(
						'min'  => -2,
						'max'  => 2,
						'step' => 0.1,
					),
				),

				'condition' => array(
					'htmega_parallax_type!' => 'multi',
					'htmega_parallax_switcher' => 'yes',
				),
			)
		);
		$repeater = new Repeater();

		$repeater->add_control(
			'htmega_parallax_item_image',
			array(
				'label'       => __( 'Choose Image', 'htmega-pro' ),
				'type'        => Controls_Manager::MEDIA,
				'default'     => array(
					'url' => Utils::get_placeholder_image_src(),
				),
				'label_block' => true,
				'render_type' => 'template',
			)
		);

		$repeater->add_responsive_control(
			'htmega_parallax_item_pos_x',
			array(
				'label'       => __( 'Horizontal Position', 'htmega-pro' ),
				'type'        => Controls_Manager::SLIDER,
				'description' => __( 'Set the horizontal position for the layer background', 'htmega-pro' ),
				'default'     => array(
					'size' => 0,
					'unit' => '%',
				),
				'min'         => 0,
				'max'         => 100,
				'label_block' => true,
			)
		);

		$repeater->add_responsive_control(
			'htmega_parallax_item_pos_y',
			array(
				'label'       => __( 'Vertical Position', 'htmega-pro' ),
				'type'        => Controls_Manager::SLIDER,
				'default'     => array(
					'size' => 0,
					'unit' => '%',
				),
				'min'         => 0,
				'max'         => 100,
				'description' => __( 'Set the vertical position for the layer background', 'htmega-pro' ),
				'label_block' => true,
			)
		);
		$repeater->add_control(
			'htmega_parallax_item_custom_size',
			array(
				'label'        => __( 'Custom Size', 'htmega-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
			)
		);

		$repeater->add_responsive_control(
			'htmega_parallax_item_with',
			array(
				'label'       => __( 'Size', 'htmega-pro' ),
				'type'        => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1200,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'label_block' => true,
				'condition'=>[
					'htmega_parallax_item_custom_size'=>'yes'
				]
			)
		);

		$repeater->add_control(
			'htmega_parallax_item_z_index',
			array(
				'label'       => __( 'Z-index', 'htmega-pro' ),
				'description' => __( 'Set z-index for the current layer', 'htmega-pro' ),
				'type'        => Controls_Manager::NUMBER,
				'default'     => 1,
			)
		);
		$repeater->add_control(
			'htmega_parallax_item_effect',
			array(
				'label'     => __( 'Parallax Effect', 'htmega-pro' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => array(
					'htmega_parallax_item_mouse_movement'   => __( 'Mouse Movement', 'htmega-pro' ),
					'htmega_parallax_item_scroll' => __( 'Scroll', 'htmega-pro' ),
				),
				'default'   => 'htmega_parallax_item_mouse_movement',
			)
		);

		$repeater->add_control(
			'htmega_parallax_item_depth_y',
			array(
				'label'       => __( 'Movement Depth Y Axis', 'htmega-pro' ),
				'type'        => Controls_Manager::NUMBER,
				'default'     => 0.5,
				'min'         => -20,
				'max'         => 20,
				'step' => 0.1,
				'description' => __( 'Choose the movement depth for the layer background, default: 0.5', 'htmega-pro' ),
				'condition'   => array(
					'htmega_parallax_item_effect' => 'htmega_parallax_item_mouse_movement',
				),
			)
		);
		$repeater->add_control(
			'htmega_parallax_item_depth_x',
			array(
				'label'       => __( 'Movement Depth X Axis', 'htmega-pro' ),
				'type'        => Controls_Manager::NUMBER,
				'default'     => 0.5,
				'min'         => -20,
				'max'         => 20,
				'step' => 0.1,
				'description' => __( 'Choose the movement depth for the layer background, default: 0.5', 'htmega-pro' ),
				'condition'   => array(
					'htmega_parallax_item_effect' => 'htmega_parallax_item_mouse_movement',
				),
			)
		);

		// $repeater->add_control(
		// 	'item_scroll_direction',
		// 	[
		// 		'label' => __('Parallax Direction', 'htmega-pro'),
		// 		'type' => Controls_Manager::CHOOSE,
		// 		'options' => [
		// 			'vertical' => [
		// 				'title' => __('Vertical', 'htmega-pro'),
		// 				'icon' => 'eicon-navigation-vertical',
		// 			],
		// 			'horizontal' => [
		// 				'title' => __('Horizontal', 'htmega-pro'),
		// 				'icon' => 'eicon-navigation-horizontal',
		// 			],
		// 		],
		// 		'default' => 'vertical',
		// 		'toggle' => false,
		// 		'condition' => [
		// 			'htmega_parallax_item_effect' => 'htmega_parallax_item_scroll',
		// 		]
		// 	]
		// );

		$repeater->add_responsive_control(
			'htmega_parallax_item_speed',
			array(
				'label'     => __( 'Speed', 'htmega-pro' ),
				'type'      => Controls_Manager::SLIDER,
				'default'   => array(
					'size' => 4,
				),
				'range'     => array(
					'px' => array(

						'min'  => -10,
						'max'  => 10,
						'step' => 0.1,
					),
				),
				'condition' => array(
					'htmega_parallax_item_effect' => 'htmega_parallax_item_scroll',
				),
			)
		);
		$repeater->add_responsive_control(
			'htmega_parallax_item_scroll_min_axis',
			array(
				'label'     => __( 'Min Position', 'htmega-pro' ),
				'type'      => Controls_Manager::SLIDER,
				'default'   => array(
					'size' => 0,
				),
				'range'     => array(
					'px' => array(
						'max'  => 2000,
						'step' => 1,
					),
				),
				'condition' => array(
					'htmega_parallax_item_effect' => 'htmega_parallax_item_scroll',
				),
			)
		);
		$repeater->add_responsive_control(
			'htmega_parallax_item_scroll_max_axis',
			array(
				'label'     => __( 'Max Position', 'htmega-pro' ),
				'type'      => Controls_Manager::SLIDER,
				'default'   => array(
					'size' => 250,
				),
				'range'     => array(
					'px' => array(
						'max'  => 2000,
						'step' => 1,
					),
				),
				'condition' => array(
					'htmega_parallax_item_effect' => 'htmega_parallax_item_scroll',
				),
			)
		);

		// $repeater->add_control(
		// 	'htmega_parallax_item_direction_hor',
		// 	array(
		// 		'label'     => __( 'Direction', 'htmega-pro' ),
		// 		'type'      => Controls_Manager::SELECT,
		// 		'options'   => array(
		// 			'left'   => __( 'Left', 'htmega-pro' ),
		// 			'right' => __( 'Right', 'htmega-pro' ),
		// 		),
		// 		'default'   => 'right',
		// 		'condition' => array(
		// 			'htmega_parallax_item_effect' => 'htmega_parallax_item_scroll',
		// 			'item_scroll_direction' => 'horizontal',
		// 		),
		// 	)
		// );

		$repeater->add_control(
			'show_htmega_parallax_item_on',
			array(
				'label'       => __( 'Show Layer On', 'htmega-pro' ),
				'type'        => Controls_Manager::SELECT2,
				'options'   => array(
					'desktop'   => __( 'Desktop', 'htmega-pro' ),
					'tablet'  => __( 'Tablet', 'htmega-pro' ),
					'mobile'    => __( 'Mobile', 'htmega-pro' ),
				),
				'default'     => array('desktop','tablet','mobile'),
				'multiple'    => true,
				'separator'   => 'before',
				'label_block' => true,
			)
		);

		$element->add_control(
			'htmega_parallax_android_support',
			array(
				'label'     => __( 'Enable Parallax on Android', 'htmega-pro' ),
				'type'      => Controls_Manager::SWITCHER,
				'condition' => array(
					'htmega_parallax_type!' => array( 'automove', 'multi' ),
					'htmega_parallax_switcher' => 'yes'
				),
			)
		);

		$element->add_control(
			'htmega_parallax_ios_support',
			array(
				'label'     => __( 'Enable Parallax on iOS', 'htmega-pro' ),
				'type'      => Controls_Manager::SWITCHER,
				'condition' => array(
					'htmega_parallax_type!' => array( 'automove', 'multi' ),
					'htmega_parallax_switcher' => 'yes'
				),
			)
		);
		$element->add_control(
			'htmega_parallax_items_list',
			array(
				'type'      => Controls_Manager::REPEATER,
				'fields'    => $repeater->get_controls(),
				'condition' => array(
					'htmega_parallax_type' => 'multi',
					'htmega_parallax_switcher' => 'yes',
				),
			)
		);

		$element->add_control(
			'htmega_parallax_items_devices',
			array(
				'label'       => __( 'Apply Parallax On', 'htmega-pro' ),
				'type'        => Controls_Manager::SELECT2,
				'options'   => array(
					'desktop'   => __( 'Desktop', 'htmega-pro' ),
					'tablet'  => __( 'Tablet', 'htmega-pro' ),
					'mobile'    => __( 'Mobile', 'htmega-pro' ),
				),
				'default'     => array('desktop','tablet','mobile'),
				'multiple'    => true,
				'label_block' => true,
				'condition'   => array(
					'htmega_parallax_type' => 'multi',
					'htmega_parallax_switcher' => 'yes',
				),
			)
		);

		$element->end_controls_section();

	}

	/**
	 * Render Editor Parallax output.
	 *
	 *
	 * @since 1.4.0
	 * @access public
	 * 
	 * @param object $template for current template.
	 * @param object $widget for current widget.
	 */
	public function _print_template( $template, $widget ) {

		if ( $widget->get_name() === 'widget' ) {
			return $template;
		}

		$old_template = $template;
		ob_start();

		?>
		<#
		var parallax = ( typeof settings.htmega_parallax_type !== "undefined" && settings.htmega_parallax_type ) ? settings.htmega_parallax_type: '';

		if( 'yes' === settings.htmega_parallax_switcher && "" !== parallax ) {

			var settingOptions = {};

			settingOptions.type = parallax;

			if ( 'multi'== parallax ) {
				var layers = [] ;

				_.each( settings.htmega_parallax_items_list, function( layer, index ) {
					layers.push( layer );
				});
				settingOptions.items   = layers;
				settingOptions.devices = settings.htmega_parallax_items_devices;

			} else {
				var speed = "" !== settings.htmega_parallax_speed.size ? settings.htmega_parallax_speed.size : 0.5;

				var positiont = settings.background_position_tablet;
				if ( 'initial' === positiont ) {
					positiont = settings.background_xpos_tablet.size + settings.background_xpos_tablet.unit + ' ' + settings.background_ypos_tablet.size + settings.background_ypos_tablet.unit;
				}
				var positionm = settings.background_position_mobile;
				if ( 'initial' === positionm ) {
					positionm = settings.background_xpos_mobile.size + settings.background_xpos_mobile.unit + ' ' + settings.background_ypos_mobile.size + settings.background_ypos_mobile.unit;

				}

				settingOptions.speed    = speed;
				settingOptions.android  = "yes" === settings.htmega_parallax_android_support ? 0 : 1;
				settingOptions.ios      = "yes" === settings.htmega_parallax_ios_support ? 0 : 1;
				settingOptions.size     = settings.background_size;
				settingOptions.position = settings.background_position;
				settingOptions.positiont = positiont;
				settingOptions.positionm = positionm;
				settingOptions.repeat   = settings.background_repeat;				
			}

			view.addRenderAttribute( 'parallax_data', {
				'id': 'htmega-parallax-' + view.getID(),
				'class': 'htmega-parallax-wrapper',
				'data-htmega-parallax': JSON.stringify( settingOptions )
			});

		#>
			<div {{{ view.getRenderAttributeString( 'parallax_data' ) }}}></div>
		<# } #>
		<?php

		$parallax_content = ob_get_contents();
		ob_end_clean();
		$template = $parallax_content . $old_template;
		return $template;
	}

	/**
	 * Render HTML output on the frontend.
	 *
	 * Written in PHP and used to generate the final Output.
	 *
	 * @since 1.4.0
	 * @access public
	 * @param object $element for current element.
	 */
	public function before_render( $element ) {

		$settings = $element->get_settings_for_display();

		$parallax = isset( $settings['htmega_parallax_type'] ) ? $settings['htmega_parallax_type'] : '';

		if ( isset( $parallax ) && '' !== $parallax && 'yes' === $element->get_settings( 'htmega_parallax_switcher' ) ) {

			$parallax_settings = array(
				'type' => $parallax,
			);

			if ( 'multi' == $parallax ) {
				$layers = array();

				foreach ( $settings['htmega_parallax_items_list'] as $layer ) {

					$layer['alt'] = Control_Media::get_image_alt( $layer['htmega_parallax_item_image'] );
					array_push( $layers, $layer );
				}

				$parallax_settings = array_merge(
					$parallax_settings,
					array(
						'items'   => $layers,
						'devices' => $settings['htmega_parallax_items_devices'],
					)
				);
			}else {
				$speed = isset( $settings['htmega_parallax_speed']['size'] ) ? $settings['htmega_parallax_speed']['size'] : 0.5;
				$parallax_settings = array_merge(
					$parallax_settings,
					array(
						'speed'   => $speed,
						'android' => 'yes' === $settings['htmega_parallax_android_support'] ? 0 : 1,
						'ios'     => 'yes' === $settings['htmega_parallax_ios_support'] ? 0 : 1,
						'size'    => $settings['background_size'],
						'repeat'  => $settings['background_repeat'],
						'position'  => $settings['background_position'],
					)
				);
			}

			$element->add_render_attribute( '_wrapper', 'data-htmega-parallax', wp_json_encode( $parallax_settings ) );
			$element->add_render_attribute( '_wrapper', 'data-relative-input', 'true' );

		}
	}


	 //Check Assets Enqueue
	public function check_assets_enqueue( $element ) {
		if ( self::$assets_load ) {
			return;
		}
		if ( 'yes' === $element->get_settings_for_display( 'htmega_parallax_switcher' ) ) {
			$this->enqueue_styles();
			$this->enqueue_scripts();
			self::$assets_load = true;
			remove_action( 'elementor/frontend/section/before_render', array( $this, 'check_assets_enqueue' ) );
			remove_action( 'elementor/frontend/column/before_render', array( $this, 'check_assets_enqueue' ) );
			remove_action( 'elementor/frontend/container/before_render', array( $this, 'check_assets_enqueue' ) );
		}
	}
}


HTMegaParallax_Elementor::instance();