<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class HTMegaWcsale_Admin_Settings {

    private $settings_api;

    function __construct() {
        $this->settings_api = new HTmega_Settings_API();
        add_action( 'admin_init', [ $this, 'admin_init' ] );
        add_action( 'admin_menu', [ $this, 'admin_menu' ], 224 );
        add_action( 'admin_init', [$this, 'register_setting_fileds' ] );
        add_action('admin_enqueue_scripts', [ $this, 'enqueue_admin_scripts' ] );
        add_action( 'wsa_form_bottom_htmegawcsales_fakes_data_tabs', [ $this, 'html_fake_data_tabs' ] );
    }

    // Admin Initialize
    function admin_init() {

        //set the settings
        $this->settings_api->set_sections( $this->admin_get_settings_sections() );
        $this->settings_api->set_fields( $this->admin_fields_settings() );

        //initialize settings
        $this->settings_api->admin_init();
    }

    // Plugins menu Register
    function admin_menu() {

        add_submenu_page(
            'htmega-addons', 
            __( 'Sales Notification', 'htmega-pro' ),
            __( 'Sales Notification', 'htmega-pro' ), 
            'manage_options', 
            'htmeganotification', 
            array ( $this, 'plugin_page' ) 
        );

    }

    // Admin Scripts
    public function enqueue_admin_scripts(){

        //styles
        wp_enqueue_style( 'htmega-wcsales-admin', HTMEGA_ADDONS_PL_URL_PRO . 'extensions/wc-sales-notification/admin/assets/css/admin_optionspanel.css', FALSE, HTMEGA_VERSION_PRO );

        //scripts
        wp_enqueue_script( 'wcsales-admin', HTMEGA_ADDONS_PL_URL_PRO . 'extensions/wc-sales-notification/admin/assets/js/admin_scripts.js', array('jquery'), HTMEGA_VERSION_PRO, TRUE );

        $datalocalize = array(
            'contenttype' => htmega_get_option_pro( 'notification_content_type','htmegawcsales_setting_tabs', 'actual' ),
        );
        wp_localize_script( 'wcsales-admin', 'admin_wclocalize_data', $datalocalize );

    }

    // Options page Section register
    function admin_get_settings_sections() {
        $sections = array(

            array(
                'id'    => 'htmegawcsales_setting_tabs',
                'title' => esc_html__( 'Settings', 'htmega-pro' )
            ),

            array(
                'id'    => 'htmegawcsales_fakes_data_tabs',
                'title' => esc_html__( 'Fake Data', 'htmega-pro' )
            ),

        );
        return $sections;
    }

    // Options page field register
    protected function admin_fields_settings() {

        $settings_fields = array(
            
            'htmegawcsales_setting_tabs' => array(
                
                array(
                    'name'    => 'notification_content_type',
                    'label'   => esc_html__( 'Notification Content Type', 'htmega-pro' ),
                    'desc'    => esc_html__( 'Select Content Type', 'htmega-pro' ),
                    'type'    => 'radio',
                    'default' => 'actual',
                    'options' => array(
                        'actual' => esc_html__('Real','htmega-pro'),
                        'fakes'  => esc_html__('Fakes','htmega-pro'),
                    )
                ),

                array(
                    'name'    => 'notification_pos',
                    'label'   => esc_html__( 'Position', 'htmega-pro' ),
                    'desc'    => esc_html__( 'Sale Notification Position on frontend.', 'htmega-pro' ),
                    'type'    => 'select',
                    'default' => 'bottomleft',
                    'options' => array(
                        'topleft'       =>esc_html__( 'Top Left','htmega-pro' ),
                        'topright'      =>esc_html__( 'Top Right','htmega-pro' ),
                        'bottomleft'    =>esc_html__( 'Bottom Left','htmega-pro' ),
                        'bottomright'   =>esc_html__( 'Bottom Right','htmega-pro' ),
                    ),
                ),

                array(
                    'name'    => 'notification_layout',
                    'label'   => esc_html__( 'Image Position', 'htmega-pro' ),
                    'desc'    => esc_html__( 'Notification Layout.', 'htmega-pro' ),
                    'type'    => 'select',
                    'default' => 'imageleft',
                    'options' => array(
                        'imageleft'       =>esc_html__( 'Image Left','htmega-pro' ),
                        'imageright'      =>esc_html__( 'Image Right','htmega-pro' ),
                    ),
                    'class'       => 'notification_real'
                ),

                array(
                    'name'    => 'notification_loadduration',
                    'label'   => esc_html__( 'Loading Time', 'htmega-pro' ),
                    'desc'    => esc_html__( 'Notification Loading duration.', 'htmega-pro' ),
                    'type'    => 'select',
                    'default' => '3',
                    'options' => array(
                        '2'       =>esc_html__( '2 seconds','htmega-pro' ),
                        '3'       =>esc_html__( '3 seconds','htmega-pro' ),
                        '4'       =>esc_html__( '4 seconds','htmega-pro' ),
                        '5'       =>esc_html__( '5 seconds','htmega-pro' ),
                        '6'       =>esc_html__( '6 seconds','htmega-pro' ),
                        '7'       =>esc_html__( '7 seconds','htmega-pro' ),
                        '8'       =>esc_html__( '8 seconds','htmega-pro' ),
                        '9'       =>esc_html__( '9 seconds','htmega-pro' ),
                        '10'       =>esc_html__( '10 seconds','htmega-pro' ),
                        '20'       =>esc_html__( '20 seconds','htmega-pro' ),
                        '30'       =>esc_html__( '30 seconds','htmega-pro' ),
                        '40'       =>esc_html__( '40 seconds','htmega-pro' ),
                        '50'       =>esc_html__( '50 seconds','htmega-pro' ),
                        '60'       =>esc_html__( '1 minute','htmega-pro' ),
                        '90'       =>esc_html__( '1.5 minutes','htmega-pro' ),
                        '120'       =>esc_html__( '2 minutes','htmega-pro' ),
                    ),
                ),

                array(
                    'name'    => 'notification_time_int',
                    'label'   => esc_html__( 'Time Interval', 'htmega-pro' ),
                    'desc'    => esc_html__( 'Time between notifications.', 'htmega-pro' ),
                    'type'    => 'select',
                    'default' => '4',
                    'options' => array(
                        '2'       =>esc_html__( '2 seconds','htmega-pro' ),
                        '4'       =>esc_html__( '4 seconds','htmega-pro' ),
                        '5'       =>esc_html__( '5 seconds','htmega-pro' ),
                        '6'       =>esc_html__( '6 seconds','htmega-pro' ),
                        '7'       =>esc_html__( '7 seconds','htmega-pro' ),
                        '8'       =>esc_html__( '8 seconds','htmega-pro' ),
                        '9'       =>esc_html__( '9 seconds','htmega-pro' ),
                        '10'       =>esc_html__( '10 seconds','htmega-pro' ),
                        '20'       =>esc_html__( '20 seconds','htmega-pro' ),
                        '30'       =>esc_html__( '30 seconds','htmega-pro' ),
                        '40'       =>esc_html__( '40 seconds','htmega-pro' ),
                        '50'       =>esc_html__( '50 seconds','htmega-pro' ),
                        '60'       =>esc_html__( '1 minute','htmega-pro' ),
                        '90'       =>esc_html__( '1.5 minutes','htmega-pro' ),
                        '120'       =>esc_html__( '2 minutes','htmega-pro' ),
                    ),
                ),

                array(
                    'name'              => 'notification_limit',
                    'label'             => esc_html__( 'Limit', 'htmega-pro' ),
                    'desc'              => esc_html__( 'Order Limit for notification.', 'htmega-pro' ),
                    'min'               => 1,
                    'max'               => 100,
                    'default'           => '5',
                    'step'              => '1',
                    'type'              => 'number',
                    'sanitize_callback' => 'number',
                    'class'       => 'notification_real',
                ),

                array(
                    'name'    => 'notification_uptodate',
                    'label'   => esc_html__( 'Order Upto', 'htmega-pro' ),
                    'desc'    => esc_html__( 'Do not show purchases older than.', 'htmega-pro' ),
                    'type'    => 'select',
                    'default' => '7',
                    'options' => array(
                        '1'   =>esc_html__( '1 day','htmega-pro' ),
                        '2'   =>esc_html__( '2 days','htmega-pro' ),
                        '3'   =>esc_html__( '3 days','htmega-pro' ),
                        '4'   =>esc_html__( '4 days','htmega-pro' ),
                        '5'   =>esc_html__( '5 days','htmega-pro' ),
                        '6'   =>esc_html__( '6 days','htmega-pro' ),
                        '7'   =>esc_html__( '1 week','htmega-pro' ),
                        '10'  =>esc_html__( '10 days','htmega-pro' ),
                        '14'  =>esc_html__( '2 weeks','htmega-pro' ),
                        '21'  =>esc_html__( '3 weeks','htmega-pro' ),
                        '28'  =>esc_html__( '4 weeks','htmega-pro' ),
                        '35'  =>esc_html__( '5 weeks','htmega-pro' ),
                        '42'  =>esc_html__( '6 weeks','htmega-pro' ),
                        '49'  =>esc_html__( '7 weeks','htmega-pro' ),
                        '56'  =>esc_html__( '8 weeks','htmega-pro' ),
                    ),
                    'class'       => 'notification_real',
                ),

                array(
                    'name'    => 'notification_inanimation',
                    'label'   => esc_html__( 'Animation In', 'htmega-pro' ),
                    'desc'    => esc_html__( 'Notification Enter Animation.', 'htmega-pro' ),
                    'type'    => 'select',
                    'default' => 'fadeInLeft',
                    'options' => array(
                        'bounce'   =>esc_html__( 'bounce','htmega-pro' ),
                        'flash'   =>esc_html__( 'flash','htmega-pro' ),
                        'pulse'   =>esc_html__( 'pulse','htmega-pro' ),
                        'rubberBand'   =>esc_html__( 'rubberBand','htmega-pro' ),
                        'shake'   =>esc_html__( 'shake','htmega-pro' ),
                        'swing'   =>esc_html__( 'swing','htmega-pro' ),
                        'tada'   =>esc_html__( 'tada','htmega-pro' ),
                        'wobble'  =>esc_html__( 'wobble','htmega-pro' ),
                        'jello'  =>esc_html__( 'jello','htmega-pro' ),
                        'heartBeat'  =>esc_html__( 'heartBeat','htmega-pro' ),
                        'bounceIn'  =>esc_html__( 'bounceIn','htmega-pro' ),
                        'bounceInDown'  =>esc_html__( 'bounceInDown','htmega-pro' ),
                        'bounceInLeft'  =>esc_html__( 'bounceInLeft','htmega-pro' ),
                        'bounceInRight'  =>esc_html__( 'bounceInRight','htmega-pro' ),
                        'bounceInUp'  =>esc_html__( 'bounceInUp','htmega-pro' ),
                        'fadeIn'  =>esc_html__( 'fadeIn','htmega-pro' ),
                        'fadeInDown'  =>esc_html__( 'fadeInDown','htmega-pro' ),
                        'fadeInDownBig'  =>esc_html__( 'fadeInDownBig','htmega-pro' ),
                        'fadeInLeft'  =>esc_html__( 'fadeInLeft','htmega-pro' ),
                        'fadeInLeftBig'  =>esc_html__( 'fadeInLeftBig','htmega-pro' ),
                        'fadeInRight'  =>esc_html__( 'fadeInRight','htmega-pro' ),
                        'fadeInRightBig'  =>esc_html__( 'fadeInRightBig','htmega-pro' ),
                        'fadeInUp'  =>esc_html__( 'fadeInUp','htmega-pro' ),
                        'fadeInUpBig'  =>esc_html__( 'fadeInUpBig','htmega-pro' ),
                        'flip'  =>esc_html__( 'flip','htmega-pro' ),
                        'flipInX'  =>esc_html__( 'flipInX','htmega-pro' ),
                        'flipInY'  =>esc_html__( 'flipInY','htmega-pro' ),
                        'lightSpeedIn'  =>esc_html__( 'lightSpeedIn','htmega-pro' ),
                        'rotateIn'  =>esc_html__( 'rotateIn','htmega-pro' ),
                        'rotateInDownLeft'  =>esc_html__( 'rotateInDownLeft','htmega-pro' ),
                        'rotateInDownRight'  =>esc_html__( 'rotateInDownRight','htmega-pro' ),
                        'rotateInUpLeft'  =>esc_html__( 'rotateInUpLeft','htmega-pro' ),
                        'rotateInUpRight'  =>esc_html__( 'rotateInUpRight','htmega-pro' ),
                        'slideInUp'  =>esc_html__( 'slideInUp','htmega-pro' ),
                        'slideInDown'  =>esc_html__( 'slideInDown','htmega-pro' ),
                        'slideInLeft'  =>esc_html__( 'slideInLeft','htmega-pro' ),
                        'slideInRight'  =>esc_html__( 'slideInRight','htmega-pro' ),
                        'zoomIn'  =>esc_html__( 'zoomIn','htmega-pro' ),
                        'zoomInDown'  =>esc_html__( 'zoomInDown','htmega-pro' ),
                        'zoomInLeft'  =>esc_html__( 'zoomInLeft','htmega-pro' ),
                        'zoomInRight'  =>esc_html__( 'zoomInRight','htmega-pro' ),
                        'zoomInUp'  =>esc_html__( 'zoomInUp','htmega-pro' ),
                        'hinge'  =>esc_html__( 'hinge','htmega-pro' ),
                        'jackInTheBox'  =>esc_html__( 'jackInTheBox','htmega-pro' ),
                        'rollIn'  =>esc_html__( 'rollIn','htmega-pro' ),
                        'rollOut'  =>esc_html__( 'rollOut','htmega-pro' ),
                    ),
                ),

                array(
                    'name'    => 'notification_outanimation',
                    'label'   => esc_html__( 'Animation Out', 'htmega-pro' ),
                    'desc'    => esc_html__( 'Notification Out Animation.', 'htmega-pro' ),
                    'type'    => 'select',
                    'default' => 'fadeOutRight',
                    'options' => array(
                        'bounce'   =>esc_html__( 'bounce','htmega-pro' ),
                        'flash'   =>esc_html__( 'flash','htmega-pro' ),
                        'pulse'   =>esc_html__( 'pulse','htmega-pro' ),
                        'rubberBand'   =>esc_html__( 'rubberBand','htmega-pro' ),
                        'shake'   =>esc_html__( 'shake','htmega-pro' ),
                        'swing'   =>esc_html__( 'swing','htmega-pro' ),
                        'tada'   =>esc_html__( 'tada','htmega-pro' ),
                        'wobble'  =>esc_html__( 'wobble','htmega-pro' ),
                        'jello'  =>esc_html__( 'jello','htmega-pro' ),
                        'heartBeat'  =>esc_html__( 'heartBeat','htmega-pro' ),
                        'bounceOut'  =>esc_html__( 'bounceOut','htmega-pro' ),
                        'bounceOutDown'  =>esc_html__( 'bounceOutDown','htmega-pro' ),
                        'bounceOutLeft'  =>esc_html__( 'bounceOutLeft','htmega-pro' ),
                        'bounceOutRight'  =>esc_html__( 'bounceOutRight','htmega-pro' ),
                        'bounceOutUp'  =>esc_html__( 'bounceOutUp','htmega-pro' ),
                        'fadeOut'  =>esc_html__( 'fadeOut','htmega-pro' ),
                        'fadeOutDown'  =>esc_html__( 'fadeOutDown','htmega-pro' ),
                        'fadeOutDownBig'  =>esc_html__( 'fadeOutDownBig','htmega-pro' ),
                        'fadeOutLeft'  =>esc_html__( 'fadeOutLeft','htmega-pro' ),
                        'fadeOutLeftBig'  =>esc_html__( 'fadeOutLeftBig','htmega-pro' ),
                        'fadeOutRight'  =>esc_html__( 'fadeOutRight','htmega-pro' ),
                        'fadeOutRightBig'  =>esc_html__( 'fadeOutRightBig','htmega-pro' ),
                        'fadeOutUp'  =>esc_html__( 'fadeOutUp','htmega-pro' ),
                        'fadeOutUpBig'  =>esc_html__( 'fadeOutUpBig','htmega-pro' ),
                        'flip'  =>esc_html__( 'flip','htmega-pro' ),
                        'flipOutX'  =>esc_html__( 'flipOutX','htmega-pro' ),
                        'flipOutY'  =>esc_html__( 'flipOutY','htmega-pro' ),
                        'lightSpeedOut'  =>esc_html__( 'lightSpeedOut','htmega-pro' ),
                        'rotateOut'  =>esc_html__( 'rotateOut','htmega-pro' ),
                        'rotateOutDownLeft'  =>esc_html__( 'rotateOutDownLeft','htmega-pro' ),
                        'rotateOutDownRight'  =>esc_html__( 'rotateOutDownRight','htmega-pro' ),
                        'rotateOutUpLeft'  =>esc_html__( 'rotateOutUpLeft','htmega-pro' ),
                        'rotateOutUpRight'  =>esc_html__( 'rotateOutUpRight','htmega-pro' ),
                        'slideOutUp'  =>esc_html__( 'slideOutUp','htmega-pro' ),
                        'slideOutDown'  =>esc_html__( 'slideOutDown','htmega-pro' ),
                        'slideOutLeft'  =>esc_html__( 'slideOutLeft','htmega-pro' ),
                        'slideOutRight'  =>esc_html__( 'slideOutRight','htmega-pro' ),
                        'zoomOut'  =>esc_html__( 'zoomOut','htmega-pro' ),
                        'zoomOutDown'  =>esc_html__( 'zoomOutDown','htmega-pro' ),
                        'zoomOutLeft'  =>esc_html__( 'zoomOutLeft','htmega-pro' ),
                        'zoomOutRight'  =>esc_html__( 'zoomOutRight','htmega-pro' ),
                        'zoomOutUp'  =>esc_html__( 'zoomOutUp','htmega-pro' ),
                        'hinge'  =>esc_html__( 'hinge','htmega-pro' ),
                    ),
                ),
                
                array(
                    'name'  => 'background_color',
                    'label' => esc_html__( 'Background Color', 'htmega-pro' ),
                    'desc' => wp_kses_post( 'Notification Background Color.', 'htmega-pro' ),
                    'type' => 'color',
                ),

                array(
                    'name'  => 'heading_color',
                    'label' => esc_html__( 'Heading Color', 'htmega-pro' ),
                    'desc' => wp_kses_post( 'Notification Heading Color.', 'htmega-pro' ),
                    'type' => 'color',
                ),

                array(
                    'name'  => 'content_color',
                    'label' => esc_html__( 'Content Color', 'htmega-pro' ),
                    'desc' => wp_kses_post( 'Notification Content Color.', 'htmega-pro' ),
                    'type' => 'color',
                ),

                array(
                    'name'  => 'cross_color',
                    'label' => esc_html__( 'Cross Icon Color', 'htmega-pro' ),
                    'desc' => wp_kses_post( 'Notification Cross Icon Color.', 'htmega-pro' ),
                    'type' => 'color'
                ),

            ),

            'htmegawcsales_fakes_data_tabs' => array(),


        );
        
        return array_merge( $settings_fields );
    }

    function html_fake_data_tabs(){
        ob_start();

        $fakadata = array();
        $fake_title = get_option( 'fake_title' );
        $fake_price = get_option( 'fake_price' );
        $fake_buyer = get_option( 'fake_buyer' );
        $fake_desc  = get_option( 'fake_description' );
        $fake_image  = get_option( 'fake_image' );
        $count      =  is_array( $fake_title) ? count( $fake_title ) : 0;

        for ( $i = 0; $i < $count; $i++ ) {
            if ( $fake_title[$i] != '' ){
                $fakadata[$i]['fake_title'] = $fake_title[$i];
                $fakadata[$i]['fake_price'] = $fake_price[$i];
                $fakadata[$i]['fake_buyer'] = $fake_buyer[$i];
                $fakadata[$i]['fake_description'] = $fake_desc[$i];
                $fakadata[$i]['fake_image'] = $fake_image[$i];
            }
        }

        ?>
            <table id="htrepeatable-fieldset" class="htopt_meta_box_table" width="100%">
                <thead>
                    <tr>
                        <th><?php echo esc_html__( "Title", 'htmega-pro' );?></th>
                        <th><?php echo esc_html__( "Price", 'htmega-pro' );?></th>
                        <th><?php echo esc_html__( "Buyer", 'htmega-pro' );?></th>
                        <th><?php echo esc_html__( "Description", 'htmega-pro' );?></th>
                        <th><?php echo esc_html__( "Image", 'htmega-pro' );?></th>
                        <th><?php echo esc_html__( "Action", 'htmega-pro' );?></th>
                    </tr>
                </thead>
                <tbody>
                <?php
                    if ( $fakadata ) :
                        foreach ( $fakadata as $datainfo ) {
                            ?>
                            <tr>
                                <td>
                                    <input type="text" placeholder="<?php echo esc_attr__( 'Enter Title', 'htmega-pro' ); ?>" value="<?php echo $datainfo['fake_title'] ? esc_attr( $datainfo['fake_title'] ) : ''; ?>" name="fake_title[]" />
                                </td>
                                <td>
                                    <input type="text" placeholder="<?php echo esc_attr__( 'Enter Price', 'htmega-pro' ); ?>" value="<?php echo $datainfo['fake_price'] ? esc_attr( $datainfo['fake_price'] ) : ''; ?>" name="fake_price[]" />
                                </td>
                                <td>
                                    <input type="text" placeholder="<?php echo esc_attr__( 'Enter Buyer Name', 'htmega-pro' ); ?>" value="<?php echo $datainfo['fake_buyer'] ? esc_attr( $datainfo['fake_buyer'] ) : ''; ?>" name="fake_buyer[]" />
                                </td>
                                <td>
                                    <textarea name="fake_description[]" placeholder="<?php echo esc_attr__( 'Enter Description', 'htmega-pro' ); ?>"><?php echo $datainfo['fake_description'] ? esc_textarea( $datainfo['fake_description'] ) : ''; ?></textarea>
                                </td>
                                <td>
                                    <div class="htmedia_display">
                                        <?php
                                            if( !empty( $datainfo['fake_image'] ) ){
                                                echo '<img src="'.esc_url( $datainfo['fake_image'] ).'" alt="'.esc_attr( $datainfo['fake_title'] ).'">';
                                            }else{
                                                echo '<img src="' . esc_url( HTMEGA_ADDONS_PL_URL_PRO . 'extensions/wc-sales-notification/admin/assets/images/fake_data_placeholder.png' ) . '" alt="' . esc_attr($datainfo['fake_title'] ) . '" />';
                                            }
                                        ?>
                                    </div>
                                    <input type="hidden" class="wpsa-url" name="fake_image[]" value="<?php echo $datainfo['fake_image'] ? esc_url( $datainfo['fake_image'] ) : ''; ?>" />
                                    <input type="button" class="button wpsa-browse" value="<?php echo esc_attr__( 'Upload Image', 'htmega-pro' ); ?>" />
                                    <input type="button" class="button wpsa-remove" value="<?php echo esc_attr__( 'Remove Image', 'htmega-pro' ); ?>" />
                                </td>
                                <td width="10%"><a class="button remove-row" href="#1"><?php esc_html_e( 'Remove', 'htmega-pro' ); ?></a></td>
                            </tr>
                            <?php
                        }

                    else :
                    // show a blank one
                ?>
                    <tr>
                        <td>
                            <input type="text" placeholder="<?php echo esc_attr__( 'Enter Title', 'htmega-pro' ); ?>" name="fake_title[]" />
                        </td>
                        <td>
                            <input type="text" placeholder="<?php echo esc_attr__( 'Enter Price', 'htmega-pro' ); ?>" name="fake_price[]" />
                        </td>
                        <td>
                            <input type="text" placeholder="<?php echo esc_attr__( 'Enter Buyer Name', 'htmega-pro' ); ?>" name="fake_buyer[]" />
                        </td>
                        <td>
                            <textarea name="fake_description[]" placeholder="<?php echo esc_attr__( 'Enter Description', 'htmega-pro' ); ?>"></textarea>
                        </td>
                        <td>
                            <div class="htmedia_display"></div>
                            <input type="hidden" class="wpsa-url" name="fake_image[]" />
                            <input type="button" class="button wpsa-browse" value="<?php echo esc_attr__( 'Upload Image', 'htmega-pro' ); ?>" />
                        </td>
                        <td>
                            <a class="button remove-row button-disabled" href="#">
                                <?php esc_html_e( 'Remove', 'htmega-pro' ); ?>
                            </a>
                        </td>
                    </tr>
                <?php endif; ?>
                    <!-- empty hidden one for jQuery -->
                    <tr class="empty-row screen-reader-text">
                        <td>
                            <input type="text" placeholder="<?php echo esc_attr__( 'Enter Title', 'htmega-pro' ); ?>" name="fake_title[]" />
                        </td>
                        <td>
                            <input type="text" placeholder="<?php echo esc_attr__( 'Enter Price', 'htmega-pro' ); ?>" name="fake_price[]" />
                        </td>
                        <td>
                            <input type="text" placeholder="<?php echo esc_attr__( 'Enter Buyer Name', 'htmega-pro' ); ?>" name="fake_buyer[]" />
                        </td>
                        <td>
                            <textarea name="fake_description[]" placeholder="<?php echo esc_attr__( 'Enter Description', 'htmega-pro' ); ?>"></textarea>
                        </td>
                        <td>
                            <div class="htmedia_display"></div>
                            <input type="hidden" class="wpsa-url" name="fake_image[]" />
                            <input type="button" class="button wpsa-browse" value="<?php echo esc_attr__( 'Upload Image', 'htmega-pro' ); ?>" />
                        </td>
                        <td><a class="button remove-row" href="#"><?php esc_html_e( 'Remove', 'htmega-pro' ); ?></a></td>
                    </tr>

                </tbody>
            </table>
            <p style="text-align:right;"><a id="add-row" class="button" href="#"><?php esc_html_e( 'Add Another', 'htmega-pro' ); ?></a></p>

        <?php
        echo ob_get_clean();  // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
    }

    // Setting Fileds Register
    function register_setting_fileds() {
        register_setting( 'htmegawcsales_fakes_data_tabs', 'fake_title' );
        register_setting( 'htmegawcsales_fakes_data_tabs', 'fake_price' );
        register_setting( 'htmegawcsales_fakes_data_tabs', 'fake_buyer' );
        register_setting( 'htmegawcsales_fakes_data_tabs', 'fake_description' );
        register_setting( 'htmegawcsales_fakes_data_tabs', 'fake_image' );
    }

    // Admin Menu Page Render
    function plugin_page() {

        echo '<div class="wrap">';
            echo '<h2>'.esc_html__( 'WC Sales Notification Settings','htmega-pro' ).'</h2>';
            $this->save_message();
            $this->settings_api->show_navigation();
            $this->settings_api->show_forms();
        echo '</div>';

    }

    // Save Options Message
    function save_message() {
        if( isset($_GET['settings-updated']) ) { ?>
            <div class="updated notice is-dismissible"> 
                <p><strong><?php esc_html_e('Successfully Settings Saved.', 'htmega-pro') ?></strong></p>
            </div>
            <?php
        }
    }


}

new HTMegaWcsale_Admin_Settings();