<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class HTmega_Admin_Settings_Pro {


    function __construct() {
        add_filter( 'htmega_admin_fields', [ $this, 'admin_fields' ] );
    }

    public function admin_fields( $fields ){

        $fields['htmega_general_tabs'] = [
            array(
                'id'  => 'google_map_api_key',
                'name' => __( 'Google Map Api Key', 'htmega-pro' ),
                'desc' => sprintf('%1$s <a href="%2$s" target="_blank">%3$s</a> %4$s', __( 'Go to', 'htmega-pro' ), esc_url( 'https://developers.google.com/maps/documentation/javascript/get-api-key' ), __( 'https://developers.google.com', 'htmega-pro' ), __( 'and generate the API key.', 'htmega-pro' ) ),
                'placeholder' => __( 'Google Map Api key', 'htmega-pro' ),
                'type' => 'text',
                'sanitize_callback' => 'sanitize_text_field'
            ),
            array(
                'id'  => 'weather_map_api_key',
                'name' => __( 'Weather Map API Key', 'htmega-pro' ),
                'desc'  => __( 'Please enter a OpenWeatherMaps API key. OpenWeather is a weather provider service which is capable of delivering all the necessary weather information for any location on the globe.To create API key, go to this link <a href="https://openweathermap.org/appid" target="_blank">OpenWeather</a>.', 'htmega-pro' ),
                'placeholder' => __( 'Weather Map API key', 'htmega-pro' ),
                'type' => 'text',
                'sanitize_callback' => 'sanitize_text_field'
            ),
            array(
                'id'  => 'fb_page_id',
                'name' => __( 'Facebook Page ID', 'htmega-pro' ),
                'desc'  => __( 'Enter facebook page ID.', 'htmega-pro' ),
                'placeholder' => __( '129835963824214', 'htmega-pro' ),
                'type' => 'text',
                'sanitize_callback' => 'sanitize_text_field'
            ),
            array(
                'id'  => 'fb_page_access_token',
                'name' => __( 'Facebook Page Access Token', 'htmega-pro' ),
                'desc'  => __( 'Enter facebook page access token. To Get Page ID and Access Token <a href="https://www.facebook.com/login/?privacy_mutation_token=eyJ0eXBlIjowLCJjcmVhdGlvbl90aW1lIjoxNjU5NjAwMzEyLCJjYWxsc2l0ZV9pZCI6Mjc2MjMwNjIxNzQyMjQ4NX0%3D&next=https%3A%2F%2Fdevelopers.facebook.com%2Fproducts%2F" target="_blank">Facebook Developer</a> Login', 'htmega-pro' ),
                'type' => 'text',
                'sanitize_callback' => 'sanitize_text_field'
            ),
            array(
                'id'  => 'fb_clear_cache_button',
                'name' => __( 'Clear the cached data for Facebook review', 'htmega-pro' ),
                'desc'  => __( 'Click this button to delete all the cached data for Facebook review.', 'htmega-pro' ),
                'type' => 'html',
                'html' => '<button type="button" class="htmega-fb-clear-cache-btn">Clear cache data</button><div class="htmega-admin-notify"></div>'
            ),
            array(
                'id'  => 'schedule_update_days',
                'name' => __( 'Automatically update the Facebook review cache in every day(s)', 'htmega-pro' ),
                'desc'  => __( 'Enter the number of days after which the Facebook review cache will automically updated.', 'htmega-pro' ),
                'min'               => 1,
                'max'               => 365,
                'step'              => '1',
                'type'              => 'number',
                'default'           => '7',
                'sanitize_callback' => 'floatval',
            ),
            array(
                'id'    => 'errorpage',
                'name'   => __( 'Select 404 Page.', 'htmega-pro' ),
                'desc'    => __( 'You can select 404 page from here.', 'htmega-pro' ),
                'type'    => 'select',
                'default' => '0',
                'options' => htmega_post_name( 'page', -1 )
            ),

            array(
                'id'  => 'loadpostlimit',
                'name' => __( 'Load Post in Elementor Addons', 'htmega-pro' ),
                'desc'  => wp_kses_post( 'Load Post in Elementor Addons' ),
                'min'               => 1,
                'max'               => 1000,
                'step'              => '1',
                'type'              => 'number',
                'default'           => '20',
                'sanitize_callback' => 'floatval',
            ),
        ];

        // Post Duplicator Condition
        if( htmega_get_option( 'postduplicator', 'htmega_advance_element_tabs', 'off' ) === 'on' ){
            $post_types = htmega_get_post_types( array('defaultadd'=>'all') );
            if ( did_action( 'elementor/loaded' ) && defined( 'ELEMENTOR_VERSION' ) ) {
                $post_types['elementor_library'] = __( 'Templates', 'htmega-pro' );
            }
            $fields['htmega_general_tabs'][] = [
                'id'    => 'postduplicate_condition',
                'name'   => __( 'Post Duplicator Condition', 'htmega-pro' ),
                'desc'    => __( 'You can enable duplicator for individual post.', 'htmega-pro' ),
                'type'    => 'multiselect',
                'default' => '',
                'options' => $post_types,
            ];
        }

        $fields['htmega_element_tabs'] = [
            array(
                'id'  => 'accordion',
                'name'  => __( 'Accordion', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default' => 'on',
            ),

            array(
                'id'  => 'animatesectiontitle',
                'name'  => __( 'Animate Heading', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'addbanner',
                'name'  => __( 'Ads Banner', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'specialadsbanner',
                'name'  => __( 'Special Day Offer', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'blockquote',
                'name'  => __( 'Blockquote', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'brandlogo',
                'name'  => __( 'Brands', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            
            array(
                'id'  => 'businesshours',
                'name'  => __( 'Business Hours', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'button',
                'name'  => __( 'Button', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'calltoaction',
                'name'  => __( 'Call To Action', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'carousel',
                'name'  => __( 'Carousel', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'countdown',
                'name'  => __( 'Countdown', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'counter',
                'name'  => __( 'Counter', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'customevent',
                'name'  => __( 'Custom Event', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            
            array(
                'id'  => 'dualbutton',
                'name'  => __( 'Double Button', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            
            array(
                'id'  => 'dropcaps',
                'name'  => __( 'Dropcaps', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'flipbox',
                'name'  => __( 'Flip Box', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'galleryjustify',
                'name'  => __( 'Gallery Justify', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'googlemap',
                'name'  => __( 'Google Map', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'imagecomparison',
                'name'  => __( 'Image Comparison', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            
            array(
                'id'  => 'imagegrid',
                'name'  => __( 'Image Grid', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            
            array(
                'id'  => 'imagemagnifier',
                'name'  => __( 'Image Magnifier', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            
            array(
                'id'  => 'imagemarker',
                'name'  => __( 'Image Marker', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            
            array(
                'id'  => 'imagemasonry',
                'name'  => __( 'Image Masonry', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            
            array(
                'id'  => 'inlinemenu',
                'name'  => __( 'Inline Navigation', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'instagram',
                'name'  => __( 'Instagram', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'lightbox',
                'name'  => __( 'Light Box', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'modal',
                'name'  => __( 'Modal', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'newtsicker',
                'name'  => __( 'News Ticker', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            
            array(
                'id'  => 'notify',
                'name'  => __( 'Notify', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),

            array(
                'id'  => 'offcanvas',
                'name'  => __( 'Offcanvas', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'panelslider',
                'name'  => __( 'Panel Slider', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),

            array(
                'id'  => 'popover',
                'name'  => __( 'Popover', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),

            array(
                'id'  => 'postcarousel',
                'name'  => __( 'Post carousel', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'postgrid',
                'name'  => __( 'Post Grid', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'postgridtab',
                'name'  => __( 'Post Grid Tab', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'postslider',
                'name'  => __( 'Post Slider', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'pricinglistview',
                'name'  => __( 'Pricing List View', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),

            array(
                'id'  => 'pricingtable',
                'name'  => __( 'Pricing Table', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'progressbar',
                'name'  => __( 'Progress Bar', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'scrollimage',
                'name'  => __( 'Scroll Image', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),

            array(
                'id'  => 'scrollnavigation',
                'name'  => __( 'Scroll Navigation', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),

            array(
                'id'  => 'search',
                'name'  => __( 'Search', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),

            array(
                'id'  => 'sectiontitle',
                'name'  => __( 'Section Title', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'service',
                'name'  => __( 'Service', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            
            array(
                'id'  => 'singlepost',
                'name'  => __( 'Single Post', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            
            array(
                'id'  => 'thumbgallery',
                'name'  => __( 'Slider Thumbnail Gallery', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),

            array(
                'id'  => 'socialshere',
                'name'  => __( 'Social Share', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),

            array(
                'id'  => 'switcher',
                'name'  => __( 'Switcher', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'tabs',
                'name'  => __( 'Tabs', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'datatable',
                'name'  => __( 'Data Table', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),

            array(
                'id'  => 'teammember',
                'name'  => __( 'Team Member', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'testimonial',
                'name'  => __( 'Testimonial', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'testimonialgrid',
                'name'  => __( 'Testimonial Grid', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),

            array(
                'id'  => 'toggle',
                'name'  => __( 'Toggle', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'tooltip',
                'name'  => __( 'Tooltip', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),

            array(
                'id'  => 'twitterfeed',
                'name'  => __( 'Twitter Feed', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),

            array(
                'id'  => 'userloginform',
                'name'  => __( 'User Login Form', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),

            array(
                'id'  => 'userregisterform',
                'name'  => __( 'User Register Form', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),

            array(
                'id'  => 'verticletimeline',
                'name'  => __( 'Verticle Timeline', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),

            array(
                'id'  => 'videoplayer',
                'name'  => __( 'Video Player', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),

            array(
                'id'  => 'workingprocess',
                'name'  => __( 'Working Process', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),

            array(
                'id'  => 'htmega_view_counter',
                'name'  => __( 'View Counter', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),

            array(
                'id'  => 'htmega_sticky_section',
                'name'  => __( 'Sticky Section', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),

            array(
                'id'  => 'htmega_image_roted',
                'name'  => __( 'Image Rotate', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),

            array(
                'id'  => 'errorcontent',
                'name'  => __( '404 Content', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),

            array(
                'id'  => 'template_selector',
                'name'  => __( 'Remote Template', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),

            array(
                'id'  => 'weather',
                'name'  => __( 'Weather', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            array(
                'id'  => 'audio_player',
                'name'  => __( 'Audio Player', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=> 'off',
            ),
            array(
                'id'  => 'calendly',
                'name'  => __( 'Calendly', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=> 'on',
            ),
            array(
                'id'  => 'info_box',
                'name'  => __( 'Info Box', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            array(
                'id'  => 'lottie',
                'name'  => __( 'Lottie', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),
            array(
                'id'  => 'event_calendar',
                'name'  => __( 'Event Calendar', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),
            array(
                'id'  => 'category_list',
                'name'  => __( 'Category List', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),
            array(
                'id'  => 'pricing_menu',
                'name'  => __( 'Pricing Menu', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            array(
                'id'  => 'feature_list',
                'name'  => __( 'Feature List', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            array(
                'id'  => 'social_network_icons',
                'name'  => __( 'Social Network Icons', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            array(
                'id'  => 'taxonomy_terms',
                'name'  => __( 'Taxonomy Terms', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            array(
                'id'  => 'background_switcher',
                'name'  => __( 'Background Switcher', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),
            array(
                'id'  => 'breadcrumbs',
                'name'  => __( 'Breadcrumbs', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),
            array(
                'id'  => 'page_list',
                'name'  => __( 'Page List', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),
            array(
                'id'  => 'icon_box',
                'name'  => __( 'Icon Box', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            array(
                'id'  => 'team_carousel',
                'name'  => __( 'Team Carousel', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),
            array(
                'id'  => 'interactive_promo',
                'name'  => __( 'Interactive Promo', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),
            array(
                'id'  => 'facebook_review',
                'name'  => __( 'Facebook Review', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),
            array(
                'id'  => 'whatsapp_chat',
                'name'  => __( 'WhatsApp Chat', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),
            array(
                'id'  => 'filterable_gallery',
                'name'  => __( 'Filterable Gallery', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),
            array(
                'id'  => 'event_box',
                'name'  => __( 'Event Box', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            array(
                'id'  => 'chart',
                'name'  => __( 'Chart', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            array(
                'id'  => 'post_timeline',
                'name'  => __( 'Post Timeline', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            array(
                'id'  => 'post_masonry',
                'name'  => __( 'Post Masonry', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            array(
                'id'  => 'source_code',
                'name'  => __( 'Source Code', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            array(
                'id'  => 'threesixty_rotation',
                'name'  => __( '360 Rotation', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            array(
                'id'  => 'pricing_table_flip_box',
                'name'  => __( 'Pricing Table Flip Box', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            array(
                'id'  => 'flip_switcher_pricing_table',
                'name'  => __( 'Flip Switcher Pricing Table', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            array(
                'id'  => 'dynamic_gallery',
                'name'  => __( 'Dynamic Gallery', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            array(
                'id'  => 'advanced_slider',
                'name'  => __( 'Advanced Slider', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'on',
            ),
            array(
                'id'  => 'flip_carousel',
                'name'  => __( 'Flip Carousel', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),
            array(
                'id'  => 'interactive_circle_infographic',
                'name'  => __( 'Interactive Circle Infographic', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),
            array(
                'id'  => 'copy_coupon_code',
                'name'  => __( 'Copy Coupon Code', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=>'off',
            ),
            array(
                'id'  => 'video_gallery',
                'name'  => __( 'Video Gallery', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=> 'on',
            ),
            array(
                'id'  => 'video_playlist',
                'name'  => __( 'Video Playlist', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=> 'off',
            ),
            array(
                'id'  => 'blob_shape',
                'name'  => __( 'Blob Shape', 'htmega-pro' ),
                'type'  => 'element',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'default'=> 'off',
            ),
        ];

        $fields['htmega_advance_element_tabs'] = [
            array(
                'id'  => 'themebuilder',
                'name'  => __( 'Theme Builder', 'htmega-pro' ),
                'type'  => 'module',
                'default'=>'off',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'section'  => 'htmega_themebuilder_module_settings',
                'setting_fields' => array(
                    array(
                        'id'  => 'themebuilder_enable',
                        'name' => __( 'Enable / Disable' ),
                        'desc'  => __( 'You can enable / disable Theme Builder from  here.', 'htmega-pro' ),
                        'type'  => 'checkbox',
                        'default' => 'off',
                        'class' => 'htmega-action-field-left',
                        'label_on' => __( 'On', 'htmega-pro' ),
                        'label_off' => __( 'Off', 'htmega-pro' ),
                    ),
                    array(
                        'id'    => 'single_blog_page',
                        'name'   => __( 'Single Blog Template.', 'htmega-pro' ),
                        'desc'    => __( 'You can select Single blog page from here. Or create a ', 'htmega-pro' ) . ' <a href="' . esc_url( admin_url( 'edit.php?post_type=elementor_library&tabs_group=library' ) ) . '">' . esc_html__( 'new one', 'htmega-pro' ) . '</a>',
                        
                        'type'    => 'select',
                        'default' => '0',
                        'options' => htmega_elementor_template(),
                        'condition' => [ ['condition_key' => 'themebuilder_enable', 'condition_value' => 'on'] ]
                    ),
                    array(
                        'id'    => 'archive_blog_page',
                        'name'   => __( 'Blog Template.', 'htmega-pro' ),
                        'desc'    => __( 'You can select blog page from here. Or create a ', 'htmega-pro' ) . ' <a href="' . esc_url( admin_url( 'edit.php?post_type=elementor_library&tabs_group=library' ) ) . '">' . esc_html__( 'new one', 'htmega-pro' ) . '</a>',
                        'type'    => 'select',
                        'default' => '0',
                        'options' => htmega_elementor_template(),
                        'condition' => [ ['condition_key' => 'themebuilder_enable', 'condition_value' => 'on'] ]
                    ),
                    array(
                        'id'    => 'header_page',
                        'name'   => __( 'Header Template.', 'htmega-pro' ),
                        'desc'    => __( 'You can select header template from here. Or create a ', 'htmega-pro' ) . ' <a href="' . esc_url( admin_url( 'edit.php?post_type=elementor_library&tabs_group=library' ) ) . '">' . esc_html__( 'new one', 'htmega-pro' ) . '</a>',
                        'type'    => 'select',
                        'default' => '0',
                        'options' => htmega_elementor_template(),
                        'condition' => [ ['condition_key' => 'themebuilder_enable', 'condition_value' => 'on'] ]
                    ),
                    array(
                        'id'    => 'footer_page',
                        'name'   => __( 'Footer Template.', 'htmega-pro' ),
                        'desc'    => __( 'You can select footer template from here. Or create a ', 'htmega-pro' ) . ' <a href="' . esc_url( admin_url( 'edit.php?post_type=elementor_library&tabs_group=library' ) ) . '">' . esc_html__( 'new one', 'htmega-pro' ) . '</a>',
                        'type'    => 'select',
                        'default' => '0',
                        'options' => htmega_elementor_template(),
                        'condition' => [ ['condition_key' => 'themebuilder_enable', 'condition_value' => 'on'] ]
                    ),
                    array(
                        'id'    => 'search_page',
                        'name'   => __( 'Search Page Template.', 'htmega-pro' ),
                        'desc'    => __( 'You can select search page from here. Or create a ', 'htmega-pro' ) . ' <a href="' . esc_url( admin_url( 'edit.php?post_type=elementor_library&tabs_group=library' ) ) . '">' . esc_html__( 'new one', 'htmega-pro' ) . '</a>',
                        'type'    => 'select',
                        'default' => '0',
                        'options' => htmega_elementor_template(),
                        'condition' => [ ['condition_key' => 'themebuilder_enable', 'condition_value' => 'on'] ]
                    ),
                    array(
                        'id'    => 'error_page',
                        'name'   => __( '404 Page Template.', 'htmega-pro' ),
                        'desc'    => __( 'You can select 404 page from here. Or create a ', 'htmega-pro' ) . ' <a href="' . esc_url( admin_url( 'edit.php?post_type=elementor_library&tabs_group=library' ) ) . '">' . esc_html__( 'new one', 'htmega-pro' ) . '</a>',
                        'type'    => 'select',
                        'default' => '0',
                        'options' => htmega_elementor_template(),
                        'condition' => [ ['condition_key' => 'themebuilder_enable', 'condition_value' => 'on'] ]
                    ),
                    array(
                        'id'    => 'coming_soon_page',
                        'name'   => __( 'Coming Soon Page Template.', 'htmega-pro' ),
                        'desc'    => __( 'You can select coming soon page from here. Or create a ', 'htmega-pro' ) . ' <a href="' . esc_url( admin_url( 'edit.php?post_type=elementor_library&tabs_group=library' ) ) . '">' . esc_html__( 'new one', 'htmega-pro' ) . '</a>',
                        'type'    => 'select',
                        'default' => '0',
                        'options' => htmega_elementor_template(),
                        'condition' => [ ['condition_key' => 'themebuilder_enable', 'condition_value' => 'on'] ]
                    ),
                ),
            ),

            array(
                'id'  => 'salenotification',
                'name'  => __( 'Sales Notification', 'htmega-pro' ),
                'type'  => 'element',
                'default'=>'off',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),

            array(
                'id'  => 'megamenubuilder',
                'name'  => __( 'Menu Builder', 'htmega-pro' ),
                'type'  => 'module',
                'default'=>'off',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'section'  => 'htmega_megamenu_module_settings',
                'setting_fields' => array(
                    array(
                        'id'  => 'megamenubuilder_enable',
                        'name' => __( 'Enable / Disable' ),
                        'desc'  => __( 'You can enable / disable Menu Builder from  here.', 'htmega-pro' ),
                        'type'  => 'checkbox',
                        'default' => 'off',
                        'class' => 'htmega-action-field-left',
                        'label_on' => __( 'On', 'htmega-pro' ),
                        'label_off' => __( 'Off', 'htmega-pro' ),
                    ),

                    array(
                        'id'    => 'menu_items_color',
                        'name'   => __( 'Menu Items Color', 'htmega-pro' ),
                        'desc'    => __( 'Set the Menu Items Color.', 'htmega-pro' ),
                        'class' => 'htmega-action-field-left',
                        'type'    => 'color',
                        'default' => '',
                        'condition' => [['condition_key' => 'megamenubuilder_enable', 'condition_value' => 'on']]
                    ),
                    array(
                        'id'    => 'menu_items_hover_color',
                        'name'   => __( 'Menu Items Hover Color', 'htmega-pro' ),
                        'desc'    => __( 'Set the Menu Items Hover Color.', 'htmega-pro' ),
                        'class' => 'htmega-action-field-left',
                        'type'    => 'color',
                        'default' => '',
                        'condition' => [['condition_key' => 'megamenubuilder_enable', 'condition_value' => 'on']]
                    ),
                    array(
                        'id'  => 'sub_menu_width',
                        'name' => __( 'Sub Menu Width', 'htmega-pro' ),
                        'desc'  => __( 'Specify the width of the Sub Menu. (px)', 'htmega-pro' ),
                        'min'               => 0,
                        'max'               => 1000,
                        'step'              => '1',
                        'type'              => 'number',
                        'default'           => '200',
                        'sanitize_callback' => 'floatval',
                        'condition' => [['condition_key' => 'megamenubuilder_enable', 'condition_value' => 'on']]
                    ),
                    array(
                        'id'    => 'sub_menu_bg_color',
                        'name'   => __( 'Sub Menu Background Color', 'htmega-pro' ),
                        'desc'    => __( 'Set the Sub Menu Background Color.', 'htmega-pro' ),
                        'class' => 'htmega-action-field-left',
                        'type'    => 'color',
                        'default' => '',
                        'condition' => [['condition_key' => 'megamenubuilder_enable', 'condition_value' => 'on']]
                    ),
                    array(
                        'id'    => 'sub_menu_items_color',
                        'name'   => __( 'Sub Menu Items Color', 'htmega-pro' ),
                        'desc'    => __( 'Set the Sub Menu Items Color.', 'htmega-pro' ),
                        'class' => 'htmega-action-field-left',
                        'type'    => 'color',
                        'default' => '',
                        'condition' => [['condition_key' => 'megamenubuilder_enable', 'condition_value' => 'on']]
                    ),
                    array(
                        'id'    => 'sub_menu_items_hover_color',
                        'name'   => __( 'Sub Menu Items Hover Color', 'htmega-pro' ),
                        'desc'    => __( 'Set the Sub Menu Items Hover Color.', 'htmega-pro' ),
                        'class' => 'htmega-action-field-left',
                        'type'    => 'color',
                        'default' => '',
                        'condition' => [['condition_key' => 'megamenubuilder_enable', 'condition_value' => 'on']]
                    ),
                    array(
                        'id'  => 'mega_menu_width',
                        'name' => __( 'Mega Menu Width', 'htmega-pro' ),
                        'desc'  => __( 'Specify the Mega Menu Width (px)', 'htmega-pro' ),
                        'min'               => 0,
                        'max'               => 2000,
                        'step'              => '1',
                        'type'              => 'number',
                        'default'           => '',
                        'sanitize_callback' => 'floatval',
                        'condition' => [['condition_key' => 'megamenubuilder_enable', 'condition_value' => 'on']]
                    ),
                    array(
                        'id'    => 'mega_menu_bg_color',
                        'name'   => __( 'Mega Menu Background Color', 'htmega-pro' ),
                        'desc'    => __( 'Set the Mega Menu Background Color.', 'htmega-pro' ),
                        'class' => 'htmega-action-field-left',
                        'type'    => 'color',
                        'default' => '',
                        'condition' => [['condition_key' => 'megamenubuilder_enable', 'condition_value' => 'on']]
                    )
                ),
            ),

            array(
                'id'  => 'postduplicator',
                'name'  => __( 'Post Duplicator', 'htmega-pro' ),
                'type'  => 'element',
                'default'=>'off',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),
            array(
                'id'  => 'wrapperlink',
                'name'  => __( 'Wrapper Link', 'htmega-pro' ),
                'type'  => 'element',
                'default'=>'off',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),
            array(
                'id'  => 'floating_effects',
                'name'  => __( 'Floating Effects', 'htmega-pro' ),
                'type'  => 'element',
                'default'=>'off',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),
            array(
                'id'  => 'htmega_rpbar',
                'name'  => __( 'Reading Progress Bar', 'htmega-pro' ),
                'type'  => 'module',
                'default'=>'off',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'section'  => 'htmega_rpbar_module_settings',
                'setting_fields' => array(
                    array(
                        'id'  => 'rpbar_enable',
                        'name' => __( 'Enable/Disable', 'htmega-pro' ),
                        'desc'  => __( 'You can enable/disable the Reading Progress Bar from here.', 'htmega-pro' ),
                        'type'  => 'checkbox',
                        'default' => 'off',
                        'class' => 'htmega-action-field-left',
                        'label_on' => __( 'On', 'htmega-pro' ),
                        'label_off' => __( 'Off', 'htmega-pro' ),
                    ),
                    array(
                        'id'  => 'rpbar_global',
                        'name' => __( 'Enable/Disable Global', 'htmega-pro' ),
                        'desc'  => __( 'Enable Reading Progress Bar Globally.', 'htmega-pro' ),
                        'type'  => 'checkbox',
                        'default' => 'off',
                        'class' => 'htmega-action-field-left',
                        'label_on' => __( 'On', 'htmega-pro' ),
                        'label_off' => __( 'Off', 'htmega-pro' ),
                        'condition' => [
                            ['condition_key' => 'rpbar_enable', 'condition_value' => 'on'],
                        ]
                    ),
                    array(
                        'id'    => 'rpbar_background_color',
                        'name'   => __( 'Background Color', 'htmega-pro' ),
                        'desc'    => __( 'Set the reading progress bar background color.', 'htmega-pro' ),
                        'class' => 'htmega-action-field-left',
                        'type'    => 'color',
                        'default' => '#000000',
                        'condition' => [
                            ['condition_key' => 'rpbar_enable', 'condition_value' => 'on'],
                            ['condition_key' => 'rpbar_global', 'condition_value' => 'on']
                        ]
    
                    ),
                    array(
                        'id'    => 'rpbar_fill_color',
                        'name'   => __( 'Fill Color', 'htmega-pro' ),
                        'desc'    => __( 'Set the fill color.', 'htmega-pro' ),
                        'class' => 'htmega-action-field-left',
                        'type'    => 'color',
                        'default' => '#D43A6B',
                        'condition' => [
                            ['condition_key' => 'rpbar_enable', 'condition_value' => 'on'],
                            ['condition_key' => 'rpbar_global', 'condition_value' => 'on']
                        ]
    
                    ),
                    array(
                        'id'    => 'rpbar_select_to_show_pages',
                        'name'   => __( 'Select Pages', 'htmega-pro' ),
                        'desc'    => __( 'Select the option where you want to display it.', 'htmega-pro' ),
                        'type'    => 'select',
                        'default' => 'all',
                        'options' => [
                            'posts' => __('All Posts', 'htmega-pro'),
                            'pages' => __('All Pages', 'htmega-pro'),
                            'all' => __('All Posts & Pages', 'htmega-pro'),
                        ],
                        'condition' => [
                            ['condition_key' => 'rpbar_enable', 'condition_value' => 'on'],
                            ['condition_key' => 'rpbar_global', 'condition_value' => 'on']
                        ]
    
                    ),
                    array(
                        'id'  => 'rpbar_loading_height',
                        'name' => __( 'Loading Progress Bar Height', 'htmega-pro' ),
                        'desc'  => __( 'Specify the height of the loading progress bar.', 'htmega-pro' ),
                        'min'               => 1,
                        'max'               => 100,
                        'step'              => '1',
                        'type'              => 'number',
                        'default'           => '5',
                        'sanitize_callback' => 'floatval',
                        'condition' => [
                            ['condition_key' => 'rpbar_enable', 'condition_value' => 'on'],
                            ['condition_key' => 'rpbar_global', 'condition_value' => 'on']
                        ]
                    ),
                    array(
                        'id'    => 'rpbar_position',
                        'name'   => __( 'Position', 'htmega-pro' ),
                        'desc'    => __( 'Choose the loading bar position to display the progress bar at the top or bottom.', 'htmega-pro' ),
                        'type'    => 'select',
                        'default' => 'top',
                        'options' => [
                            'top' => __('Top', 'htmega-pro'),
                            'bottom' => __('Bottom', 'htmega-pro'),
                        ],
                        'condition' => [
                            ['condition_key' => 'rpbar_enable', 'condition_value' => 'on'],
                            ['condition_key' => 'rpbar_global', 'condition_value' => 'on']
                        ]
    
                    ),
                )
            ),
            array(
                'id'  => 'htmega_stt',
                'name'  => __( 'Scroll To Top', 'htmega-pro' ),
                'type'  => 'module',
                'default'=>'off',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
                'section'  => 'htmega_stt_module_settings',
                'setting_fields' => array(
                    array(
                        'id'  => 'stt_enable',
                        'name' => __( 'Enable/Disable', 'htmega-pro' ),
                        'desc'  => __( 'You can enable/disable Scroll To Top from here.', 'htmega-pro' ),
                        'type'  => 'checkbox',
                        'default' => 'off',
                        'class' => 'htmega-action-field-left',
                        'label_on' => __( 'On', 'htmega-pro' ),
                        'label_off' => __( 'Off', 'htmega-pro' ),
                    ),
                    array(
                        'id'  => 'stt_global',
                        'name' => __( 'Enable/Disable Global', 'htmega-pro' ),
                        'desc'  => __( 'Enable Scroll To Top Globally.', 'htmega-pro' ),
                        'type'  => 'checkbox',
                        'default' => 'off',
                        'class' => 'htmega-action-field-left',
                        'label_on' => __( 'On', 'htmega-pro' ),
                        'label_off' => __( 'Off', 'htmega-pro' ),
                        'condition' => [
                            ['condition_key' => 'stt_enable', 'condition_value' => 'on']
                        ]
                    ),
                    array(
                        'id'    => 'stt_select_to_show_pages',
                        'name'   => __( 'Select Pages', 'htmega-pro' ),
                        'desc'    => __( 'Select the option where you would like to display it.', 'htmega-pro' ),
                        'type'    => 'select',
                        'default' => 'all',
                        'options' => [
                            'posts' => __('All Posts', 'htmega-pro'),
                            'pages' => __('All Pages', 'htmega-pro'),
                            'all' => __('All Posts & Pages', 'htmega-pro'),
                        ],
                        'condition' => [
                            ['condition_key' => 'stt_enable', 'condition_value' => 'on'],
                            ['condition_key' => 'stt_global', 'condition_value' => 'on']
                        ]
                        
                    ),
                    array(
                        'id'    => 'stt_position',
                        'name'   => __( 'Position', 'htmega-pro' ),
                        'desc'    => __( 'Choose the position to display the Scroll To Top button on the left or right.', 'htmega-pro' ),
                        'type'    => 'select',
                        'default' => 'right',
                        'options' => [
                            'left' => __('Bottom Left', 'htmega-pro'),
                            'right' => __('Bottom Right', 'htmega-pro'),
                        ],
                        'condition' => [
                            ['condition_key' => 'stt_enable', 'condition_value' => 'on'],
                            ['condition_key' => 'stt_global', 'condition_value' => 'on']
                        ]
                    ),
                    array(
                        'id'  => 'stt_bottom_space',
                        'name' => __( 'Bottom Space', 'htmega-pro' ),
                        'desc'  => __( 'Specify the bottom spacing for the Scroll To Top button.', 'htmega-pro' ),
                        'step'              => '1',
                        'type'              => 'number',
                        'default'           => '30',
                        'sanitize_callback' => 'floatval',
                        'condition' => [
                            ['condition_key' => 'stt_enable', 'condition_value' => 'on'],
                            ['condition_key' => 'stt_global', 'condition_value' => 'on']
                        ]
                    ),
                    array(
                        'id'    => 'stt_color',
                        'name'   => __( 'Color', 'htmega-pro' ),
                        'desc'    => __( 'Set the button icon/text color.', 'htmega-pro' ),
                        'class' => 'htmega-action-field-left',
                        'type'    => 'color',
                        'default' => '#ffffff',
                        'condition' => [
                            ['condition_key' => 'stt_enable', 'condition_value' => 'on'],
                            ['condition_key' => 'stt_global', 'condition_value' => 'on']
                        ]
                    ),
                    array(
                        'id'    => 'stt_bg_color',
                        'name'   => __( 'Background Color', 'htmega-pro' ),
                        'desc'    => __( 'Set the button background color.', 'htmega-pro' ),
                        'class' => 'htmega-action-field-left',
                        'type'    => 'color',
                        'default' => '#000000',
                        'condition' => [
                            ['condition_key' => 'stt_enable', 'condition_value' => 'on'],
                            ['condition_key' => 'stt_global', 'condition_value' => 'on']
                        ]
    
                    ),
                    array(
                        'id'    => 'stt_color_hover',
                        'name'   => __( 'Hover Color', 'htmega-pro' ),
                        'desc'    => __( 'Set the button icon/text hover color.', 'htmega-pro' ),
                        'class' => 'htmega-action-field-left',
                        'type'    => 'color',
                        'default' => '#ffffff',
                        'condition' => [
                            ['condition_key' => 'stt_enable', 'condition_value' => 'on'],
                            ['condition_key' => 'stt_global', 'condition_value' => 'on']
                        ]
                    ),
                    array(
                        'id'    => 'stt_bg_color_hover',
                        'name'   => __( 'Hover Background Color', 'htmega-pro' ),
                        'desc'    => __( 'Set the button hover background color.', 'htmega-pro' ),
                        'class' => 'htmega-action-field-left',
                        'type'    => 'color',
                        'default' => '#000000',
                        'condition' => [
                            ['condition_key' => 'stt_enable', 'condition_value' => 'on'],
                            ['condition_key' => 'stt_global', 'condition_value' => 'on']
                        ]
                    )
                )
            ),
            array(
                'id'  => 'crossdomaincp',
                'name'  => __( 'Cross Domain Copy Paste', 'htmega-pro' ),
                'type'  => 'element',
                'default'=>'off',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),
            array(
                'id'  => 'parallax_module',
                'name'  => __( 'Parallax', 'htmega-pro' ),
                'type'  => 'element',
                'default'=>'off',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),
            array(
                'id'  => 'particles_module',
                'name'  => __( 'Particles', 'htmega-pro' ),
                'type'  => 'element',
                'default'=>'off',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),
            array(
                'id'  => 'd_conditional_module',
                'name'  => __( 'Conditional Display', 'htmega-pro' ),
                'type'  => 'element',
                'default'=>'off',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),
            array(
                'id'  => 'advanced_sticky_module',
                'name'  => __( 'Advanced Sticky', 'htmega-pro' ),
                'type'  => 'element',
                'default'=>'off',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),
            array(
                'id'  => 'custom_css_module',
                'name'  => __( 'Custom CSS', 'htmega-pro' ),
                'type'  => 'element',
                'default'=>'off',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),
        ];

        $fields['htmega_themebuilder_element_tabs'] = [
            array(
                'id'  => 'bl_post_title',
                'name'  => __( 'Post Title', 'htmega-pro' ),
                'type'  => 'element',
                'default' => 'on',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),

            array(
                'id'  => 'bl_post_featured_image',
                'name'  => __( 'Post Featured Image', 'htmega-pro' ),
                'type'  => 'element',
                'default' => 'on',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),

            array(
                'id'  => 'bl_post_meta_info',
                'name'  => __( 'Post Meta Info', 'htmega-pro' ),
                'type'  => 'element',
                'default' => 'on',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),

            array(
                'id'  => 'bl_post_excerpt',
                'name'  => __( 'Post Excerpt', 'htmega-pro' ),
                'type'  => 'element',
                'default' => 'on',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),

            array(
                'id'  => 'bl_post_content',
                'name'  => __( 'Post Content', 'htmega-pro' ),
                'type'  => 'element',
                'default' => 'on',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),

            array(
                'id'  => 'bl_post_comments',
                'name'  => __( 'Post Comments', 'htmega-pro' ),
                'type'  => 'element',
                'default' => 'on',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),

            array(
                'id'  => 'bl_post_search_form',
                'name'  => __( 'Post Search Form', 'htmega-pro' ),
                'type'  => 'element',
                'default' => 'on',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),

            array(
                'id'  => 'bl_post_archive',
                'name'  => __( 'Archive Posts', 'htmega-pro' ),
                'type'  => 'element',
                'default' => 'on',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),

            array(
                'id'  => 'bl_post_archive_title',
                'name'  => __( 'Archive Title', 'htmega-pro' ),
                'type'  => 'element',
                'default' => 'on',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),
            
            array(
                'id'  => 'bl_page_title',
                'name'  => __( 'Page Title', 'htmega-pro' ),
                'type'  => 'element',
                'default' => 'on',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),

            array(
                'id'  => 'bl_site_title',
                'name'  => __( 'Site Title', 'htmega-pro' ),
                'type'  => 'element',
                'default' => 'on',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),

            array(
                'id'  => 'bl_site_logo',
                'name'  => __( 'Site Logo', 'htmega-pro' ),
                'type'  => 'element',
                'default' => 'on',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),

            array(
                'id'  => 'bl_nav_menu',
                'name'  => __( 'Nav Menu', 'htmega-pro' ),
                'type'  => 'element',
                'default' => 'on',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),

            array(
                'id'  => 'bl_post_author_info',
                'name'  => __( 'Author Info', 'htmega-pro' ),
                'type'  => 'element',
                'default' => 'on',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),

            array(
                'id'  => 'bl_social_share',
                'name'  => __( 'Social Share', 'htmega-pro' ),
                'type'  => 'element',
                'default' => 'on',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),

            array(
                'id'  => 'bl_print_page',
                'name'  => __( 'Print Page', 'htmega-pro' ),
                'type'  => 'element',
                'default' => 'on',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),

            array(
                'id'  => 'bl_post_navigation',
                'name'  => __( 'Post Navigation', 'htmega-pro' ),
                'type'  => 'element',
                'default' => 'on',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),

            array(
                'id'  => 'bl_related_post',
                'name'  => __( 'Related Post', 'htmega-pro' ),
                'type'  => 'element',
                'default' => 'on',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),

            array(
                'id'  => 'bl_popular_post',
                'name'  => __( 'Popular Post', 'htmega-pro' ),
                'type'  => 'element',
                'default' => 'on',
                'label_on' => __( 'On', 'htmega-pro' ),
                'label_off' => __( 'Off', 'htmega-pro' ),
            ),
        ];

        return $fields;
    
    }

}

new HTmega_Admin_Settings_Pro();