<?php

// Exit if accessed directly
if( ! defined( 'ABSPATH' ) ) exit();

    //AJAX pagination 
    add_action( 'wp_ajax_htmega-ajax-posts-load', 'htmega_pagination_load_posts' );

    add_action( 'wp_ajax_nopriv_htmega-ajax-posts-load', 'htmega_pagination_load_posts' ); 

    function htmega_pagination_load_posts() {
        check_ajax_referer( 'htmega-ajax-post-request', 'security' );
        // Set default variables
        if(isset($_POST['page'])){
            // Sanitize the received page   
            $page = sanitize_text_field($_POST['page']);
            $cur_page = $page;
            $_args = $_POST['args'];
            $settings = $_POST['settings'];

            $page -= 1;
            // Set the number of results to display
            $per_page = sanitize_text_field($_args['posts_per_page']);
            $previous_btn = false;
            $next_btn = true;
            $first_btn = true;
            $last_btn = false;
            $start = $page * $per_page;

            $htmega_card_classes = $settings['htmega_card_classes'];
            $masonry_style = $settings['masonry_style'];
            $htmega_image = $settings['htmega_image'];
            $show_author = $settings['show_author'];
            $show_date = $settings['show_date'];
            $show_title = $settings['show_title'];
            $title_length = $settings['title_length'];
            $show_content = $settings['show_content'];
            $content_length = $settings['content_length'];
            $show_category = $settings['show_category'];
            $post_type = $settings['post_type'];
            $show_read_more_btn = $settings['show_read_more_btn'];
            $read_more_txt = sanitize_text_field($settings['read_more_txt']);
            $icon_imgprint = $settings['icon_imgprint'];
            $paginate_nexticon = $settings['paginate_nexticon'];
            $paginate_previcon = $settings['paginate_previcon'];
            $count = 10;


            $_args['offset'] = $start;

                $all_blog_posts = new WP_Query( $_args );

                $data_array =[];

                if( $all_blog_posts->have_posts() ) :
                    while( $all_blog_posts->have_posts() ): $all_blog_posts->the_post();
                    ob_start(); 
                    ?>
                    <div class="htmega-masonry-flex-column htmega-masonry-post-item">
                        <div class="<?php echo esc_attr( $htmega_card_classes ); ?>" >
                            <?php
                            if ( has_post_thumbnail() && '4' != $masonry_style){ ?>
                                <a href="<?php the_permalink();?>" class="htmega-masonry-post-card-image"><?php the_post_thumbnail( $htmega_image );?></a>
                                <?php 
                            } ?>
                            <?php if( 'yes' == $show_author|| $show_date == 'yes' || $show_title == 'yes' || $show_content == 'yes' || $show_category == 'yes' ){ ?>
                                <div class="htmega-masonry-post-card-content">
                                    <?php 
                                    $get_terms = get_the_category();
                                    if($post_type == 'product'){
                                        $get_terms = get_the_terms($all_blog_posts->ID, 'product_cat');
                                    }

                                    if( $show_category == 'yes' && $get_terms ): ?>
                                        <div class="htmega-masonry-post-meta-catagory">
                                            <?php
                                                foreach ( $get_terms as $category ) {
                                                    $term_link = get_term_link( $category );
                                                    ?>
                                                        <a href="<?php echo esc_url( $term_link ); ?>" class="htmega-cat-<?php echo esc_attr( $category->slug ); ?>"><?php echo esc_html( $category->name );?></a>
                                                    <?php
                                                }
                                            ?>
                                        </div>
                                        <?php 
                                    endif; ?>

                                    <!-- for style 3 mega -->
                                    <?php 
                                    if( ('yes' == $show_author || $show_date == 'yes') && ('3' == $masonry_style|| '4' == $masonry_style) ){ ?>
                                        <div class="htmega-masonry-post-card-content-meta">
                                            <?php
                                            if( 'yes' == $show_author ){ ?>
                                                <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" class="htmega-masonry-post-meta-item">
                                                    <?php 
                                                    if('4' != $masonry_style ){ ?>
                                                        <span class="htmega-masonry-post-meta-img">
                                                            <img src="<?php echo esc_url( get_avatar_url( get_the_author_meta( 'ID' ), ['size' => '30'] ) ); ?>" alt="<?php echo the_author();?>" />
                                                        </span>
                                                        <?php
                                                    } ?>
                                                    <h6 class="htmega-masonry-post-meta-name">
                                                        <?php the_author(); ?>
                                                    </h6>
                                                </a>
                                                <?php 
                                            } ?>
                                            <?php 
                                            if( $show_date == 'yes' ): ?>
                                                <div class="htmega-masonry-post-meta-item">
                                                <?php 
                                                    if('4' != $masonry_style ){ ?>
                                                        <span class="htmega-masonry-post-meta-icon">
                                                            <svg width="11" height="13" viewBox="0 0 11 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <path d="M10.5566 2.13624C10.5554 1.52355 10.2116 1.21536 9.60382 1.23132C9.39755 1.23623 9.35212 1.31727 9.35703 1.50022C9.36562 1.80963 9.37053 2.12027 9.35457 2.42969C9.33002 2.93065 9.03288 3.24252 8.53683 3.28181C8.27408 3.30268 8.00764 3.30145 7.74611 3.28304C7.21323 3.2462 6.91486 2.92328 6.90258 2.38794C6.89645 2.08958 6.89276 1.79122 6.90381 1.49285C6.91118 1.30131 6.8461 1.23255 6.64965 1.23378C5.73123 1.24237 4.81281 1.24237 3.89562 1.23378C3.68688 1.23132 3.64636 1.32095 3.6525 1.50145C3.66233 1.81086 3.6611 2.1215 3.65373 2.43092C3.64268 2.89872 3.37256 3.21673 2.90844 3.26953C2.62481 3.30268 2.33504 3.30022 2.04895 3.28304C1.52712 3.25234 1.23612 2.94292 1.21771 2.41741C1.20788 2.108 1.20666 1.79735 1.21771 1.48794C1.22507 1.29271 1.14895 1.23623 0.957405 1.23255C0.332436 1.21904 0.000920877 1.53214 0.000920877 2.17062C-0.000306959 5.22424 -0.000306959 8.27664 0.000920877 11.3303C0.000920877 11.9884 0.284551 12.2769 0.941443 12.2782C3.83422 12.2806 6.72578 12.2806 9.61856 12.2782C10.2804 12.2782 10.5566 11.9958 10.5566 11.3315C10.5591 9.8053 10.5566 8.27787 10.5566 6.75167C10.5579 5.21196 10.5603 3.67349 10.5566 2.13624ZM1.20297 4.30705C1.20174 4.14743 1.2705 4.08358 1.43012 4.08358C2.10543 4.08727 2.78074 4.08727 3.45482 4.08481C3.59971 4.08481 3.65619 4.14498 3.65496 4.29109C3.65005 4.83993 3.64882 5.39 3.65619 5.93884C3.65864 6.12056 3.56042 6.14144 3.41799 6.14021C3.08647 6.13653 2.75496 6.13898 2.42221 6.13898C2.0907 6.13898 1.75795 6.13407 1.42644 6.14144C1.26559 6.14512 1.20052 6.08373 1.20174 5.92165C1.20788 5.38263 1.20666 4.84484 1.20297 4.30705ZM3.65742 10.8269C3.65987 11.0024 3.60216 11.0724 3.4229 11.07C2.77092 11.0638 2.11894 11.0638 1.46696 11.07C1.27664 11.0724 1.19929 11.0061 1.20174 10.8121C1.20911 10.2854 1.20788 9.75987 1.20297 9.23313C1.20174 9.07228 1.26559 9.00843 1.42644 9.01212C1.75795 9.01948 2.08947 9.01457 2.42221 9.01457C2.75373 9.01457 3.08647 9.02071 3.41799 9.01212C3.59234 9.0072 3.6611 9.06614 3.65864 9.24786C3.64882 9.7746 3.65005 10.3013 3.65742 10.8269ZM3.37992 8.61061C3.05946 8.59711 2.73777 8.60693 2.41607 8.60693C2.10666 8.60693 1.79602 8.59711 1.4866 8.61061C1.28524 8.61921 1.1956 8.56396 1.20052 8.34417C1.21157 7.82848 1.21034 7.31156 1.20174 6.79464C1.19806 6.59574 1.2791 6.54048 1.46696 6.54294C2.10911 6.55153 2.7525 6.55522 3.39466 6.54171C3.61812 6.5368 3.66233 6.62766 3.65864 6.82534C3.64882 7.32998 3.64514 7.83585 3.65987 8.34049C3.66478 8.55904 3.58375 8.61921 3.37992 8.61061ZM4.29098 4.08481C4.94541 4.0885 5.59985 4.08972 6.25429 4.08358C6.4311 4.08236 6.49863 4.14743 6.49617 4.32547C6.4888 4.85344 6.48758 5.38141 6.49617 5.90938C6.49863 6.09723 6.41513 6.14389 6.24692 6.14021C5.91418 6.13284 5.58143 6.13775 5.24869 6.13775C4.927 6.13775 4.6053 6.13284 4.28484 6.14021C4.12276 6.14389 4.0626 6.0825 4.06383 5.9192C4.06997 5.38018 4.06997 4.83993 4.06383 4.30091C4.06137 4.13147 4.13627 4.08358 4.29098 4.08481ZM4.0626 6.78482C4.06015 6.61047 4.1154 6.54171 4.29835 6.54417C4.95155 6.55276 5.60476 6.55153 6.2592 6.54417C6.44092 6.54171 6.49863 6.6117 6.49617 6.78605C6.49003 7.31279 6.49003 7.84076 6.49617 8.36873C6.49863 8.54431 6.43846 8.6143 6.25797 8.60939C5.92523 8.59956 5.59371 8.60693 5.26097 8.60693C4.95155 8.60693 4.64214 8.60079 4.33272 8.60939C4.15346 8.61552 4.05769 8.57746 4.0626 8.3675C4.07365 7.84076 4.06997 7.31279 4.0626 6.78482ZM6.49863 10.7949C6.50354 11.0061 6.42618 11.0749 6.21868 11.0724C5.58757 11.0626 4.95647 11.0651 4.32413 11.0712C4.13627 11.0737 4.05646 11.0184 4.06137 10.817C4.07242 10.3001 4.07242 9.78442 4.06137 9.2675C4.05769 9.07105 4.12768 9.00475 4.31922 9.01212C4.63968 9.02317 4.96138 9.0158 5.28307 9.0158C5.59248 9.0158 5.90313 9.02439 6.21254 9.01212C6.41391 9.00475 6.50231 9.06123 6.4974 9.27978C6.48512 9.78442 6.48635 10.2903 6.49863 10.7949ZM6.8989 4.32792C6.89645 4.15234 6.95784 4.08113 7.1371 4.08358C7.79031 4.08972 8.44229 4.08972 9.0955 4.08358C9.27967 4.08236 9.36685 4.13884 9.36317 4.33897C9.35457 4.86572 9.35703 5.39246 9.36194 5.9192C9.36317 6.08127 9.30055 6.14389 9.13847 6.14021C8.79468 6.13407 8.45089 6.13775 8.10832 6.13775C7.7989 6.13775 7.48949 6.12916 7.1813 6.14144C6.98117 6.1488 6.89276 6.09232 6.8989 5.87377C6.90995 5.35931 6.90627 4.84361 6.8989 4.32792ZM9.36071 10.849C9.36194 11.0147 9.28336 11.0687 9.12988 11.0687C8.45457 11.0663 7.77803 11.0663 7.10272 11.0687C6.95784 11.0687 6.8989 11.0061 6.90013 10.8612C6.90381 10.3112 6.90504 9.76232 6.90013 9.21225C6.8989 9.02931 7.00572 9.01334 7.14447 9.01457C7.47598 9.01703 7.80873 9.0158 8.14024 9.0158C8.47176 9.0158 8.8045 9.02071 9.13602 9.01457C9.29686 9.01089 9.36194 9.07228 9.35948 9.23558C9.3558 9.77215 9.3558 10.3112 9.36071 10.849ZM9.07708 8.60939C8.75662 8.59711 8.43615 8.6057 8.11569 8.6057C7.78417 8.6057 7.45143 8.59956 7.11991 8.60693C6.95784 8.61061 6.89645 8.54799 6.8989 8.38592C6.90381 7.84813 6.90627 7.31033 6.89767 6.77254C6.89522 6.58468 6.97871 6.54171 7.14692 6.54294C7.7989 6.54908 8.45089 6.55031 9.10287 6.54171C9.29686 6.53925 9.36562 6.60556 9.36194 6.79833C9.35334 7.31279 9.35089 7.82848 9.36317 8.34295C9.36931 8.56641 9.27476 8.61675 9.07708 8.60939ZM2.48115 2.86434C2.89739 2.8361 3.22031 2.50459 3.24118 2.07239C3.251 1.85506 3.24241 1.63651 3.24241 1.41918C3.24241 1.2129 3.24977 1.00663 3.24118 0.800352C3.22153 0.363242 2.90598 0.0341825 2.48852 0.00225879C2.07474 -0.0284371 1.70025 0.256421 1.64376 0.692302C1.57992 1.18098 1.58237 1.67825 1.64254 2.16693C1.69533 2.60281 2.0686 2.89136 2.48115 2.86434ZM8.10464 2.86557C8.55157 2.88276 8.91255 2.53406 8.94448 2.04169C8.95675 1.8477 8.94693 1.65247 8.94693 1.45724H8.9457C8.9457 1.23992 8.95921 1.02013 8.94325 0.804035C8.90764 0.332546 8.5528 -0.00510823 8.11814 0.00103095C7.68226 0.00717013 7.33233 0.35342 7.31514 0.824908C7.3004 1.22518 7.30163 1.62791 7.31514 2.02819C7.32987 2.50459 7.66384 2.84838 8.10464 2.86557Z" fill="white"/>
                                                            </svg>
                                                        </span>
                                                    <?php
                                                    } ?>
                                                    <span class="htmega-masonry-post-meta-comment">
                                                        <?php the_time('d F Y') ?>
                                                    </span>
                                                </div>
                                                <?php 
                                            endif; ?>
                                        </div>
                                        <?php 
                                    }?>
                                        <?php 
                                    if( $show_title == 'yes' ): ?>
                                        <h2 class="htmega-masonry-post-card-content-title">
                                        <a href="<?php the_permalink();?>">
                                        <?php
                                            if ( 0 > $title_length ) { 
                                                the_title();
                                            } else { 
                                                echo esc_html( wp_trim_words( get_the_title(), $title_length, '' ) );
                                            }
                                        ?>
                                         </a>
                                        </h2>
                                        <?php 
                                    endif;
                                    ?>
                                        <?php 
                                    if( ('yes' == $show_author || $show_date == 'yes')  && ('1' == $masonry_style|| '2' == $masonry_style)){ ?>
                                        <div class="htmega-masonry-post-card-content-meta">
                                            <?php
                                            if( 'yes' == $show_author ){ ?>
                                                <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" class="htmega-masonry-post-meta-item">
                                                    <span class="htmega-masonry-post-meta-img">
                                                        <img src="<?php echo esc_url( get_avatar_url( get_the_author_meta( 'ID' ), ['size' => '30'] ) ); ?>" alt="<?php echo the_author();?>" />
                                                    </span>
                                                    <h6 class="htmega-masonry-post-meta-name">
                                                        <?php the_author(); ?>
                                                    </h6>
                                                </a>
                                                <?php 
                                            } ?>
                                            <?php 
                                            if( $show_date == 'yes' ): ?>
                                                <div class="htmega-masonry-post-meta-item">
                                                    <span class="htmega-masonry-post-meta-icon">
                                                        <svg width="11" height="13" viewBox="0 0 11 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M10.5566 2.13624C10.5554 1.52355 10.2116 1.21536 9.60382 1.23132C9.39755 1.23623 9.35212 1.31727 9.35703 1.50022C9.36562 1.80963 9.37053 2.12027 9.35457 2.42969C9.33002 2.93065 9.03288 3.24252 8.53683 3.28181C8.27408 3.30268 8.00764 3.30145 7.74611 3.28304C7.21323 3.2462 6.91486 2.92328 6.90258 2.38794C6.89645 2.08958 6.89276 1.79122 6.90381 1.49285C6.91118 1.30131 6.8461 1.23255 6.64965 1.23378C5.73123 1.24237 4.81281 1.24237 3.89562 1.23378C3.68688 1.23132 3.64636 1.32095 3.6525 1.50145C3.66233 1.81086 3.6611 2.1215 3.65373 2.43092C3.64268 2.89872 3.37256 3.21673 2.90844 3.26953C2.62481 3.30268 2.33504 3.30022 2.04895 3.28304C1.52712 3.25234 1.23612 2.94292 1.21771 2.41741C1.20788 2.108 1.20666 1.79735 1.21771 1.48794C1.22507 1.29271 1.14895 1.23623 0.957405 1.23255C0.332436 1.21904 0.000920877 1.53214 0.000920877 2.17062C-0.000306959 5.22424 -0.000306959 8.27664 0.000920877 11.3303C0.000920877 11.9884 0.284551 12.2769 0.941443 12.2782C3.83422 12.2806 6.72578 12.2806 9.61856 12.2782C10.2804 12.2782 10.5566 11.9958 10.5566 11.3315C10.5591 9.8053 10.5566 8.27787 10.5566 6.75167C10.5579 5.21196 10.5603 3.67349 10.5566 2.13624ZM1.20297 4.30705C1.20174 4.14743 1.2705 4.08358 1.43012 4.08358C2.10543 4.08727 2.78074 4.08727 3.45482 4.08481C3.59971 4.08481 3.65619 4.14498 3.65496 4.29109C3.65005 4.83993 3.64882 5.39 3.65619 5.93884C3.65864 6.12056 3.56042 6.14144 3.41799 6.14021C3.08647 6.13653 2.75496 6.13898 2.42221 6.13898C2.0907 6.13898 1.75795 6.13407 1.42644 6.14144C1.26559 6.14512 1.20052 6.08373 1.20174 5.92165C1.20788 5.38263 1.20666 4.84484 1.20297 4.30705ZM3.65742 10.8269C3.65987 11.0024 3.60216 11.0724 3.4229 11.07C2.77092 11.0638 2.11894 11.0638 1.46696 11.07C1.27664 11.0724 1.19929 11.0061 1.20174 10.8121C1.20911 10.2854 1.20788 9.75987 1.20297 9.23313C1.20174 9.07228 1.26559 9.00843 1.42644 9.01212C1.75795 9.01948 2.08947 9.01457 2.42221 9.01457C2.75373 9.01457 3.08647 9.02071 3.41799 9.01212C3.59234 9.0072 3.6611 9.06614 3.65864 9.24786C3.64882 9.7746 3.65005 10.3013 3.65742 10.8269ZM3.37992 8.61061C3.05946 8.59711 2.73777 8.60693 2.41607 8.60693C2.10666 8.60693 1.79602 8.59711 1.4866 8.61061C1.28524 8.61921 1.1956 8.56396 1.20052 8.34417C1.21157 7.82848 1.21034 7.31156 1.20174 6.79464C1.19806 6.59574 1.2791 6.54048 1.46696 6.54294C2.10911 6.55153 2.7525 6.55522 3.39466 6.54171C3.61812 6.5368 3.66233 6.62766 3.65864 6.82534C3.64882 7.32998 3.64514 7.83585 3.65987 8.34049C3.66478 8.55904 3.58375 8.61921 3.37992 8.61061ZM4.29098 4.08481C4.94541 4.0885 5.59985 4.08972 6.25429 4.08358C6.4311 4.08236 6.49863 4.14743 6.49617 4.32547C6.4888 4.85344 6.48758 5.38141 6.49617 5.90938C6.49863 6.09723 6.41513 6.14389 6.24692 6.14021C5.91418 6.13284 5.58143 6.13775 5.24869 6.13775C4.927 6.13775 4.6053 6.13284 4.28484 6.14021C4.12276 6.14389 4.0626 6.0825 4.06383 5.9192C4.06997 5.38018 4.06997 4.83993 4.06383 4.30091C4.06137 4.13147 4.13627 4.08358 4.29098 4.08481ZM4.0626 6.78482C4.06015 6.61047 4.1154 6.54171 4.29835 6.54417C4.95155 6.55276 5.60476 6.55153 6.2592 6.54417C6.44092 6.54171 6.49863 6.6117 6.49617 6.78605C6.49003 7.31279 6.49003 7.84076 6.49617 8.36873C6.49863 8.54431 6.43846 8.6143 6.25797 8.60939C5.92523 8.59956 5.59371 8.60693 5.26097 8.60693C4.95155 8.60693 4.64214 8.60079 4.33272 8.60939C4.15346 8.61552 4.05769 8.57746 4.0626 8.3675C4.07365 7.84076 4.06997 7.31279 4.0626 6.78482ZM6.49863 10.7949C6.50354 11.0061 6.42618 11.0749 6.21868 11.0724C5.58757 11.0626 4.95647 11.0651 4.32413 11.0712C4.13627 11.0737 4.05646 11.0184 4.06137 10.817C4.07242 10.3001 4.07242 9.78442 4.06137 9.2675C4.05769 9.07105 4.12768 9.00475 4.31922 9.01212C4.63968 9.02317 4.96138 9.0158 5.28307 9.0158C5.59248 9.0158 5.90313 9.02439 6.21254 9.01212C6.41391 9.00475 6.50231 9.06123 6.4974 9.27978C6.48512 9.78442 6.48635 10.2903 6.49863 10.7949ZM6.8989 4.32792C6.89645 4.15234 6.95784 4.08113 7.1371 4.08358C7.79031 4.08972 8.44229 4.08972 9.0955 4.08358C9.27967 4.08236 9.36685 4.13884 9.36317 4.33897C9.35457 4.86572 9.35703 5.39246 9.36194 5.9192C9.36317 6.08127 9.30055 6.14389 9.13847 6.14021C8.79468 6.13407 8.45089 6.13775 8.10832 6.13775C7.7989 6.13775 7.48949 6.12916 7.1813 6.14144C6.98117 6.1488 6.89276 6.09232 6.8989 5.87377C6.90995 5.35931 6.90627 4.84361 6.8989 4.32792ZM9.36071 10.849C9.36194 11.0147 9.28336 11.0687 9.12988 11.0687C8.45457 11.0663 7.77803 11.0663 7.10272 11.0687C6.95784 11.0687 6.8989 11.0061 6.90013 10.8612C6.90381 10.3112 6.90504 9.76232 6.90013 9.21225C6.8989 9.02931 7.00572 9.01334 7.14447 9.01457C7.47598 9.01703 7.80873 9.0158 8.14024 9.0158C8.47176 9.0158 8.8045 9.02071 9.13602 9.01457C9.29686 9.01089 9.36194 9.07228 9.35948 9.23558C9.3558 9.77215 9.3558 10.3112 9.36071 10.849ZM9.07708 8.60939C8.75662 8.59711 8.43615 8.6057 8.11569 8.6057C7.78417 8.6057 7.45143 8.59956 7.11991 8.60693C6.95784 8.61061 6.89645 8.54799 6.8989 8.38592C6.90381 7.84813 6.90627 7.31033 6.89767 6.77254C6.89522 6.58468 6.97871 6.54171 7.14692 6.54294C7.7989 6.54908 8.45089 6.55031 9.10287 6.54171C9.29686 6.53925 9.36562 6.60556 9.36194 6.79833C9.35334 7.31279 9.35089 7.82848 9.36317 8.34295C9.36931 8.56641 9.27476 8.61675 9.07708 8.60939ZM2.48115 2.86434C2.89739 2.8361 3.22031 2.50459 3.24118 2.07239C3.251 1.85506 3.24241 1.63651 3.24241 1.41918C3.24241 1.2129 3.24977 1.00663 3.24118 0.800352C3.22153 0.363242 2.90598 0.0341825 2.48852 0.00225879C2.07474 -0.0284371 1.70025 0.256421 1.64376 0.692302C1.57992 1.18098 1.58237 1.67825 1.64254 2.16693C1.69533 2.60281 2.0686 2.89136 2.48115 2.86434ZM8.10464 2.86557C8.55157 2.88276 8.91255 2.53406 8.94448 2.04169C8.95675 1.8477 8.94693 1.65247 8.94693 1.45724H8.9457C8.9457 1.23992 8.95921 1.02013 8.94325 0.804035C8.90764 0.332546 8.5528 -0.00510823 8.11814 0.00103095C7.68226 0.00717013 7.33233 0.35342 7.31514 0.824908C7.3004 1.22518 7.30163 1.62791 7.31514 2.02819C7.32987 2.50459 7.66384 2.84838 8.10464 2.86557Z" fill="white"/>
                                                        </svg>
                                                    </span>
                                                    <span class="htmega-masonry-post-meta-comment">
                                                        <?php the_time('d F Y') ?>
                                                    </span>
                                                </div>
                                                <?php 
                                            endif; ?>
                                        </div>
                                        <?php 
                                    }?>
                                        <?php
                                    if( $settings['show_content'] == 'yes' ) {
                                        echo ' <p class="htmega-masonry-post-description">'.wp_kses_post( wp_trim_words( strip_shortcodes( get_the_content() ), $settings['content_length'], '' ) ).'</p>';
                                    } 
                                    ?>
                                        <?php
                                    if( $show_read_more_btn == 'yes' && '4' != $masonry_style ): ?>
                                        <a class="htmega-masonry-post-read-more" href="<?php the_permalink();?>">
                                            <span class="htmega-masonry-post-read-more-text">
                                                <?php echo htmega_kses_desc( $read_more_txt );?>
                                            </span>
                                            <?php echo wp_kses_post( $icon_imgprint ); ?>
                                        </a>
                                        <?php
                                    endif; ?>
                                </div>
                                <?php 
                            } ?>
                            <?php
                            if ( has_post_thumbnail() && '4' == $masonry_style){ ?>
                                <a href="<?php the_permalink();?>" class="htmega-masonry-post-card-image"><?php the_post_thumbnail( $htmega_image );?></a>
                                <?php 
                            } ?>
                                <?php
                            if( $show_read_more_btn == 'yes' && '4' == $masonry_style ): ?>
                                <a class="htmega-masonry-post-read-more" href="<?php the_permalink();?>">
                                    <span class="htmega-masonry-post-read-more-text">
                                        <?php echo htmega_kses_desc( $read_more_txt ); ?>
                                    </span>
                                    <?php echo wp_kses_post( $icon_imgprint ); ?>
                                </a>
                                <?php
                            endif; ?>
                        </div>

                    </div>
            
                    <?php
                    $output = ob_get_clean();
                    $data_array[] = $output;
                    endwhile;

                    wp_reset_postdata();
                else :
                    echo esc_html( 'No Post found', 'htmega-pro');
                endif;
            // Post Count
            $_args['posts_per_page'] = -1;
            $_args['numberposts'] = -1;
            $posts = get_posts($_args);
            $count = count($posts);
    
            // This is where the magic happens
            $no_of_paginations = ceil($count / $per_page);

            if ($cur_page >= 7) {
                $start_loop = $cur_page - 3;
                if ($no_of_paginations > $cur_page + 3)
                    $end_loop = $cur_page + 3;
                else if ($cur_page <= $no_of_paginations && $cur_page > $no_of_paginations - 6) {
                    $start_loop = $no_of_paginations - 6;
                    $end_loop = $no_of_paginations;
                } else {
                    $end_loop = $no_of_paginations;
                }
            } else {
                $start_loop = 1;
                if ($no_of_paginations > 7)
                    $end_loop = 7;
                else
                    $end_loop = $no_of_paginations;
            }

            // Pagination Buttons logic     
            $pag_container = "
                <ul class='htmega-masonry-post-pagination'>";

            if ($first_btn && $cur_page > 1) {
                $pag_container .= "<li p='1' class='htmega-masonry-post-pagination-link active'><div class='htmega-masonry-post-pagination-icon'><i class='{$paginate_previcon}'></i></div></li>";
            } else if ($first_btn) {
                $pag_container .= "<li p='1' class='htmega-masonry-post-pagination-link inactive'><div class='htmega-masonry-post-pagination-icon'><i class='{$paginate_previcon}'></i></div></li>";
            }

            if ($previous_btn && $cur_page > 1) {
                $pre = $cur_page - 1;
                $pag_container .= "<li p='$pre' class='htmega-masonry-post-pagination-link active'>Previous</li>";
            } else if ($previous_btn) {
                $pag_container .= "<li class='htmega-masonry-post-pagination-link inactive'>Previous</li>";
            }
            for ($i = $start_loop; $i <= $end_loop; $i++) {

                if ($cur_page == $i)
                    $pag_container .= "<li p='$i' class = 'htmega-masonry-post-pagination-link selected' >{$i}</li>";
                else
                    $pag_container .= "<li p='$i' class='htmega-masonry-post-pagination-link active'>{$i}</li>";
            }

            if ($next_btn && $cur_page < $no_of_paginations) {
                $nex = $cur_page + 1;
                $pag_container .= "<li p='$nex' class='htmega-masonry-post-pagination-link active'><div class='htmega-masonry-post-pagination-icon'><i class='{$paginate_nexticon}'></i></div></li>";
            } else if ($next_btn) {
                $pag_container .= "<li class='htmega-masonry-post-pagination-link inactive'><div class='htmega-masonry-post-pagination-icon'><i class='{$paginate_nexticon}'></i></div></li>";
            }

            if ($last_btn && $cur_page < $no_of_paginations) {
                $pag_container .= "<li p='$no_of_paginations' class='htmega-masonry-post-pagination-link active'>Last</li>";
            } else if ($last_btn) {
                $pag_container .= "<li p='$no_of_paginations' class='htmega-masonry-post-pagination-link inactive'>Last</li>";
            }

            $pag_container = $pag_container . "
                </ul>";

            // We echo the final output
            $data_array['pagination'] = $pag_container;
            echo wp_json_encode($data_array);

        }
        // Always exit to avoid further execution
        exit();
    }


    //AJAX dYnamic gallery filter  
    add_action( 'wp_ajax_htmega_ajax_dynamic_gallery_posts', 'htmega_dynamic_gallery_posts' );

    add_action( 'wp_ajax_nopriv_htmega_ajax_dynamic_gallery_posts', 'htmega_dynamic_gallery_posts' ); 

    function htmega_dynamic_gallery_posts(){
        check_ajax_referer( 'htmega-ajax-post-request', 'security' );
        if(isset($_POST['args'])){
            $_args = $_POST['args'];
            $catId = $_POST['catId'];
            $postLimit = $_POST['postLimit'];
            $post_ids_array = $_POST['excludePost'];
            if('all' != $catId ){
                $_args['tax_query'][0]['terms'] = $catId;
            }
            if($_args['posts_per_page'] > $postLimit ){
                $_args['posts_per_page'] = $postLimit;
            }
            $_args['post__not_in'] = $post_ids_array;
            $settings = $_POST['settings'];
            $htmega_image = $settings['htmega_image'];
            $unicid = $settings['unicid'];
            $layout = $settings['layout'];
            $post_type = $settings['post_type'];
            $category_name =  get_object_taxonomies($post_type);
            $all_blog_posts = new WP_Query( $_args );
            $data_array =[];
            
            if( $all_blog_posts->have_posts() ) :

                while( $all_blog_posts->have_posts() ): $all_blog_posts->the_post();
                array_push($post_ids_array,get_the_ID());
                $full_image = [];
                $full_image = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_id()),'full',true); 
                $full_image = $full_image[0];  
                $filter_data = "";
                if( $category_name ){
                    $category_name['0'] = ( $category_name['0'] == "product_type" )? 'product_cat': $category_name['0'];        
                    $terms = get_the_terms(get_the_id(),$category_name[0]);
                    $filter_data = "";
                        if( $terms ){  foreach($terms as $term ){
                                $filter_data .= " ".strval($term->term_id)."_".$unicid;
                            } 
                        }
                }
                ob_start();
                ?>
                
                <div class="<?php echo esc_attr($settings['dynamic_gallery_colum_and_catagory_attr'].$filter_data ); ?> htmega-load-item-effect">
                    <div class="htmega-dynamic-gallery-item htmega-dynamic-gallery-item-<?php echo esc_attr($layout); ?>">
                        <?php 
                        if( has_post_thumbnail() ):
                            echo '<div class="dynamic-gallery-image">';
                                if('yes' == $settings['popup_display'] ){ ?>
                                    <div class="htmega-dynamic-gallery-item-image">
                                        <?php the_post_thumbnail( $htmega_image ); ?>
                                    </div>
                                    <?php 
                                }else{ ?>
                                    <a data-elementor-open-lightbox='no' class="htmega-dynamic-gallery-item-image htmega-filterable-img-popup <?php echo esc_html( 'htmega-gallery-img-popup-'.$unicid )?>" href="<?php echo esc_url( $full_image ); ?>">
                                    <?php the_post_thumbnail( $htmega_image ); ?>
                                    </a>
                                <?php 
                                }
                                if('yes' == $settings['popup_display'] ){
                                    ?>
                                    <div class="dynamic-gallery-popup-button">
                                        <?php if( $settings['popup_link_icon'] ){ ?>
                                        <a data-elementor-open-lightbox="no" href="<?php echo esc_url( $full_image ) ?>" class=" <?php echo esc_attr( 'htmega-gallery-img-popup-'.$unicid )?>">
                                        <?php echo stripslashes($settings['popup_link_icon'] ); ?>
                                        </a>
                                        <?php }
                                        if( $settings['read_more_link_icon'] ){ ?>
                                        <a href="<?php the_permalink(); ?>" target="_blank" class="htmega-dynamic-gallery-link">
                                        <?php echo stripslashes($settings['read_more_link_icon'] ); ?>
                                        </a>
                                        <?php } ?>
                                    </div>
                                    <?php 
                                } ?>
                            </div>
                            <?php
                        endif;
                        //gallery popup content                                   
                        if( $settings['show_content'] == 'yes' ||  $settings['show_title'] == 'yes'){
                            ?>
                            <div class="htmega-dynamic-gallery-item-content">
                                <?php
                                    if( $settings['show_title'] == 'yes' ){
                                        ?>
                                        <h3>
                                            <a href="<?php the_permalink(); ?>" target="_blank" class="htmega-dynamic-gallery-item-title">
                                                <?php
                                                    if ( 0 > $settings['title_length'] ) { 
                                                        the_title();
                                                    } else { 
                                                        echo esc_html( wp_trim_words( get_the_title(), $settings['title_length'], '' ) );
                                                    }
                                                ?>
                                            </a>
                                        </h3>
                                        <?php
                                    }
                                    if( $settings['show_content'] == 'yes' ){
                                        if( $settings['content_type'] == 'excerpt' ){
                                            echo '<p>'.get_the_excerpt().'</p>';
                                        } else {
                                            echo '<p class="htmega-dynamic-gallery-item-description">'.wp_kses_post( wp_trim_words( strip_shortcodes( get_the_content() ), $settings['content_length'], '' ) ).'</p>'; 
                                        }
                                    }

                                if( $settings['show_read_more_btn'] == 'yes'): ?>
                                    <div class="htmega-dynamic-gallery-read-more">
                                        <a target="_blank" href="<?php the_permalink();?>">
                                            <?php echo htmega_kses_desc( $settings['read_more_txt'] );?>
                                        </a>
                                    </div>
                                    <?php
                                endif; ?>
                                
                            </div>
                            <?php 
                        }
                        ?>
                    </div>
                </div>
                <?php
                $output = ob_get_clean();
                $data_array[] = $output;
                endwhile;
                wp_reset_postdata();
                $data_array['no_post_found'] = $all_blog_posts->found_posts;
           else:
            $data_array['no_post_found'] = $all_blog_posts->found_posts;
            endif;
            $data_array['post_ids_array'] = $post_ids_array;
            echo wp_json_encode($data_array);
        }
        exit();
    }
    //AJAX dYnamic gallery filter  
    add_action( 'wp_ajax_htmega_ajax_post_gird_posts_load', 'htmega_post_gird_posts_load' );

    add_action( 'wp_ajax_nopriv_htmega_ajax_post_gird_posts_load', 'htmega_post_gird_posts_load' ); 

    function htmega_post_gird_posts_load(){
        check_ajax_referer( 'htmega-ajax-post-request', 'security' );
        if(isset($_POST['args'])){
            $_args = $_POST['args'];
            $postLimit = $_POST['postLimit'];
            $post_ids_array = $_POST['excludePost'];
            if($_args['posts_per_page'] > $postLimit ){
                $_args['posts_per_page'] = $postLimit;
            }
            $_args['post__not_in'] = $post_ids_array;
            $settings = $_POST['settings'];
            $htmega_image_size = $settings['htmega_image'];
            $unicid = $settings['unicid'];
            $layout = $settings['layout'];
            $post_type = $settings['post_type'];
            $category_name =  get_object_taxonomies($post_type);
            $grid_post = new WP_Query( $_args );
            $data_array =[];
            
            if( $grid_post->have_posts() ) :

                while( $grid_post->have_posts() ): $grid_post->the_post();
                array_push($post_ids_array,get_the_ID());
                $full_image = [];
                $full_image = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_id()),'full',true); 
                $full_image = $full_image[0];  
                $filter_data = "";
                if( $category_name ){
                    $category_name['0'] = ( $category_name['0'] == "product_type" )? 'product_cat': $category_name['0'];        
                    $terms = get_the_terms(get_the_id(),$category_name[0]);
                    $filter_data = "";
                        if( $terms ){  foreach($terms as $term ){
                                $filter_data .= " ".strval($term->term_id)."_".$unicid;
                            } 
                        }
                }

                if ( 0 > $settings['title_length'] ) {
                    $title_link_text = "<a ".stripslashes($settings['link_attr']['open_in_window'].$settings['link_attr']['add_nofollow'])." href='".get_the_permalink()."'>" . get_the_title() . "</a>";
                } else { 
                    $title_link_text = "<a ".stripslashes($settings['link_attr']['open_in_window'].$settings['link_attr']['add_nofollow'])." href='".get_the_permalink()."'>" . esc_html( wp_trim_words( get_the_title(), $settings['title_length'], '' ) ) . "</a>";
                }

                ob_start();
                ?>
                
                <div class="htb-col-lg-4 htb-col-sm-6 htb-col-12 htmega-load-item-effect">
                    <div class="ht-post black-overlay mt--30">
                        <?php
                        if ('yes' == $settings['show_thumbnail']) { ?>
                            <div class="thumb">
                                <a <?php echo stripslashes($settings['link_attr']['open_in_window'] . $settings['link_attr']['add_nofollow'] );?> href="<?php the_permalink(); ?>">
                                    <?php
                                    if (has_post_thumbnail()) {
                                        the_post_thumbnail($htmega_image_size);
                                    } else {
                                        echo '<img src="' . esc_url( HTMEGA_ADDONS_PL_URL . '/assets/images/image-placeholder.png' ) . '" alt="' . esc_attr( get_the_title() ) . '" />';
                                    }
                                    ?>
                                </a>
                            </div>
                        <?php
                        }
                        if( $settings['show_category'] == 'yes' ){
                            if( $category_name ){
                                $i=0;
                                $get_terms = get_the_terms($grid_post->ID, $category_name[0] );
                                if( $post_type == 'product' ){
                                    $get_terms = get_the_terms($grid_post->ID, 'product_cat');
                                }
                                if( $get_terms ){
                                    foreach ( $get_terms as $category ) {
                                        $i++;
                                        $term_link = get_term_link( $category );
                                        ?>
                                            <a <?php echo stripslashes($settings['link_attr']['open_in_window'] . $settings['link_attr']['add_nofollow'] );?>  href="<?php echo esc_url( $term_link ); ?>" class="category post-category post-position-top-left <?php echo esc_attr( $category->slug ); ?>"><?php echo esc_html( $category->name );?></a>
                                        <?php
                                        if($i==1){break;}
                                    }
                                }
                            }
                        }
                        if ($settings['show_title'] == 'yes' || $settings['show_date'] == 'yes' || $settings['show_content'] == 'yes' || $settings['show_read_more_btn'] == 'yes') {
                            ?>
                            <div class="post-content">
                                <div class="content">
                                    <?php if( $settings['show_title'] == 'yes' ):

                                    printf( '<%1$s class="htmega-post-g-title">%2$s</%1$s>',
                                    htmega_escape_tags( $settings['title_tag'], 'h4' ),
                                    $title_link_text);

                                    endif; if( $settings['show_date'] == 'yes' ): ?>
                                        <div class="meta">
                                            <span class="meta-item date"><i class="fa fa-clock-o"></i>  
                                                <?php the_time( 'd F Y' ); ?>
                                            </span>
                                        </div>
                                    <?php endif;?>
                                    <?php
                                    if( $settings['show_content'] == 'yes' ):
                                        if( $settings['content_type'] == 'excerpt' ){
                                            echo '<p class="htmega-post-g-description">'. esc_html( get_the_excerpt() ).'</p>';
                                        } else {
                                            echo '<p class="htmega-post-g-description">'.wp_kses_post( wp_trim_words( strip_shortcodes( get_the_content() ), $settings['content_length'], '' ) ).'</p>'; 
                                        }
                                    endif;
                                    if( $settings['show_read_more_btn'] == 'yes' && !empty( $settings['read_more_txt'] ) ): ?>
                                        <a class="htmega-post-g-read-more" <?php echo stripslashes($settings['link_attr']['open_in_window'] . $settings['link_attr']['add_nofollow'] );?>  href="<?php the_permalink();?>">
                                            <?php echo htmega_kses_desc( $settings['read_more_txt'] ); ?>
                                        </a>
                                        <?php
                                    endif; ?>
                                </div>
                            </div>
                            <?php
                        } ?>
                    </div>
                </div>
                <?php
                $output = ob_get_clean();
                $data_array[] = $output;
                endwhile;
                wp_reset_postdata();
                $data_array['no_post_found'] = $grid_post->found_posts;
           else:
            $data_array['no_post_found'] = $grid_post->found_posts;
            endif;
            $data_array['post_ids_array'] = $post_ids_array;
            echo wp_json_encode($data_array);
        }
        exit();
    }