<?php 

class Htmega_Pro_Assets {

    private static $instance = null;
    public static function instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    function __construct(){
        // Add Plugin actions
        add_filter( 'htmega_style_list', [ $this, 'register_stype' ] );
        add_filter( 'htmega_script_list', [ $this, 'register_script' ] );
    }

    public function register_stype($style_list){
        $style_list ['lottie'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/lottie/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];

        $style_list ['full-calendar'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/event-calendar/full-calendar.css',
            'version' => HTMEGA_VERSION_PRO
        ];
        $style_list ['event-calendar'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/event-calendar/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];
        $style_list ['info-box'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/info-box/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];

        $style_list ['category-list'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/category-list/style.css',
            'version' => HTMEGA_VERSION_PRO,
        ];
        $style_list ['pricing-menu'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/pricing-menu/style.css',
            'version' => HTMEGA_VERSION_PRO,
        ];

        $style_list ['feature-list'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/feature-list/style.css',
            'version' => HTMEGA_VERSION_PRO,
        ];
        
        $style_list ['social-network-icons'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/social-network-icons/style.css',
            'version' => HTMEGA_VERSION_PRO,
        ];

        $style_list ['hover-animation'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/social-network-icons/hover.css',
            'version' => HTMEGA_VERSION_PRO,
        ];
        
        $style_list ['taxonomy-terms'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/taxonomy-terms/style.css',
            'version' => HTMEGA_VERSION_PRO,
        ];
        $style_list ['background-switcher'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/background-switcher/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];
        $style_list ['team-carousel'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/team-carousel/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];
        $style_list ['icon-box'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/icon-box/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];
        $style_list ['interactive-promo'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/interactive-promo/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];
        $style_list ['facebook-review'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/facebook-review/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];
        $style_list ['breadcrumbs'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/breadcrumbs/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];
        $style_list ['page-list'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/page-list/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];
        $style_list ['event-box'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/event-box/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];
        $style_list ['filterable-gallery'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/filterable-gallery/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];
        $style_list ['whatsapp-chat'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/whatsapp-chat/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];
        $style_list ['htmega-chart'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/chart/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];
        $style_list ['htmega-post-timeline'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/post-timeline/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];
        $style_list ['htmega-post-masonry'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/post-masonry/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];
        $style_list ['prism'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/source-code/prism.css',
            'version' => HTMEGA_VERSION_PRO
        ];
        $style_list ['htmega-source-code'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/source-code/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];
        $style_list ['htmega-threesixty-rotation'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/threesixty-rotation/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];
        $style_list ['pricing-table-flip-box'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/pricing-table-flip-box/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];  
        $style_list ['htmega-dynamic-gallery'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/dynamic-gallery/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];  
        $style_list ['htmega-advanced-slider'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/advanced-slider/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];  
        $style_list ['htmega-flipster'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/flip-carousel/flipster.min.css',
            'version' => HTMEGA_VERSION_PRO
        ];  
        $style_list ['htmega-circle-infographic'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/interactive-circle-infographic/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];  
        $style_list ['htmega-cpc'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/copy-coupon-code/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];  
        $style_list ['htmega-video-gallery'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/video-gallery/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];  
        $style_list ['htmega-unitegallery'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/video-playlist/unite-gallery.css',
            'version' => HTMEGA_VERSION_PRO
        ];   
        $style_list ['htmega-blob-shape'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/blob-shape/style.css',
            'version' => HTMEGA_VERSION_PRO
        ];   
        $style_list ['htmega-pro-widgets-style'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/htmega-pro-widgets-style.min.css',
            'version' => HTMEGA_VERSION_PRO
        ];   

        return $style_list;
    }

    public function register_script($script_list){
        $script_list ['htmega-blob-shape-active'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/blob-shape/active.js',
            'version' => HTMEGA_VERSION_PRO
        ];  
        $script_list ['htmega-unitegallery'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/video-playlist/unitegallery.min.js',
            'version' => HTMEGA_VERSION_PRO
        ];  
        $script_list ['htmega-ug-theme-video'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/video-playlist/ug-theme-video.js',
            'version' => HTMEGA_VERSION_PRO
        ];  
        $script_list ['htmega-video-playlist-active'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/video-playlist/active.js',
            'version' => HTMEGA_VERSION_PRO
        ];  
        $script_list ['htmega-video-gallery-active'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/video-gallery/active.js',
            'version' => HTMEGA_VERSION_PRO
        ];  
        $script_list ['htmega-cpc'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/copy-coupon-code/active.js',
            'version' => HTMEGA_VERSION_PRO
        ];  
        $script_list ['htmega-circle-infographic-active'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/interactive-circle-infographic/active.js',
            'version' => HTMEGA_VERSION_PRO
        ];  
        $script_list ['htmega-flipster'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/flip-carousel/flipster.min.js',
            'version' => HTMEGA_VERSION_PRO
        ];  
        $script_list ['htmega-flipster-active'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/flip-carousel/active.js',
            'version' => HTMEGA_VERSION_PRO
        ];
        $script_list ['lottie'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/lottie/lottie-player.js',
            'version' => HTMEGA_VERSION_PRO
        ];
        $script_list ['full-calendar'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/event-calendar/full-calendar.js',
            'version' => HTMEGA_VERSION_PRO
        ];
        $script_list ['dayjs'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/event-calendar/dayjs.min.js',
            'version' => HTMEGA_VERSION_PRO
        ];
        $script_list ['locales-all'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/event-calendar/locales-all.min.js',
            'version' => HTMEGA_VERSION_PRO
        ];
        $script_list ['switcher-active'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/background-switcher/active.js',
            'version' => HTMEGA_VERSION_PRO
        ];
        $script_list ['htmega-pro-slick-active'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/js/htmega-pro-slick-active.js',
            'version' => HTMEGA_VERSION_PRO
        ];
        $script_list ['team-carousel-active'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/team-carousel/active.js',
            'version' => HTMEGA_VERSION_PRO
        ];

        $script_list ['filterable-gallery-active'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/filterable-gallery/active.js',
            'version' => HTMEGA_VERSION_PRO
        ];
        $script_list ['whatsapp-chat-active'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/whatsapp-chat/active.js',
            'version' => HTMEGA_VERSION_PRO
        ];
        $script_list ['circle-progress'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/chart/circle-progress.min.js',
            'version' => HTMEGA_VERSION_PRO
        ];
        $script_list ['echarts'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/chart/echarts.js',
            'version' => HTMEGA_VERSION_PRO
        ];
        $script_list ['htmega-chart-active'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/chart/active.js',
            'version' => HTMEGA_VERSION_PRO
        ];
        $script_list ['prism'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/source-code/prism.js',
            'version' => HTMEGA_VERSION_PRO
        ];
        $script_list ['htmega-source-code-active'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/source-code/active.js',
            'version' => HTMEGA_VERSION_PRO
        ];
        $script_list ['htmega-source-code-active-editor'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/source-code/editor-active.js',
            'version' => HTMEGA_VERSION_PRO
        ];
        $script_list ['circlr'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/threesixty-rotation/circlr-main.js',
            'version' => '3.1.1'
        ];
        $script_list ['htmega-threesixty-rotation'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/threesixty-rotation/active.js',
            'version' => HTMEGA_VERSION_PRO
        ];
        $script_list ['pricing-table-flip-box-active'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/pricing-table-flip-box/active.js',
            'version' => HTMEGA_VERSION_PRO
        ];

        $script_list ['dynamic-gallery-active'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/dynamic-gallery/active.js',
            'version' => HTMEGA_VERSION_PRO
        ];
        $script_list ['post-grid-pro-active'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/widgets/others/post-grid-pro-active.js',
            'version' => HTMEGA_VERSION_PRO
        ];
        $script_list ['htmega-pro-active'] = [
            'src'     => HTMEGA_ADDONS_PL_URL_PRO . 'assets/js/htmega-pro-active.min.js',
            'version' => HTMEGA_VERSION_PRO
        ];

        return $script_list;
    }
}

Htmega_Pro_Assets::instance();