<?php
use Elementor\Plugin;
use Elementor\Utils;
use Elementor\Controls_Stack;
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

class HTMega_Cross_Domain_Copy_Paste_Manager{

    /**
     * [$_instance]
     * @var null
     */
    private static $_instance = null;

    /**
     * [instance] Initializes a singleton instance
     * @return [HTMega_Cross_Domain_Copy_Pest_Manager]
     */
    public static function instance() {
        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    /**
     * [init] Initializes
     * @return void
     */
    public function init() {
        add_action( 'wp_ajax_htmega_copy_paste_data', [ $this, 'copy_paste_data'] );
        add_action( 'elementor/editor/after_enqueue_scripts', [ $this, 'enqueue' ] );
    }

    /**
     * [enqueue] Manage Assets
     * @return void 
     */
    public function enqueue(){

        wp_enqueue_script(
            'htmega-xd-localstorage',
            HTMEGA_ADDONS_PL_URL_PRO . 'assets/js/xd-local-storage.min.js',
            NULL,
            HTMEGA_VERSION_PRO,
            TRUE
        );

        wp_enqueue_script(
            'htmega-cross-domain-cp',
            HTMEGA_ADDONS_PL_URL_PRO . 'assets/js/cross-domain-cp.js',
            [ 'jquery', 'elementor-editor' ],
            HTMEGA_VERSION_PRO,
            TRUE
        );

        wp_localize_script(
            'htmega-cross-domain-cp',
            'htmegacrosscp',
            [
                'ajaxurl' => admin_url( 'admin-ajax.php' ),
                'nonce'   => wp_create_nonce( 'htmega_copy_data' ),
                'copy'    => esc_html__( 'HT Copy', 'htmega-pro' ),
                'paste'   => esc_html__( 'HT Paste', 'htmega-pro' ),
            ]
        );

    }


    /**
     * [copy_paste_data] Fetch Elementor data
     * @return [html] HTML | Error
     */
    public function copy_paste_data() {

        $data  = isset( $_POST['data'] ) ? wp_unslash( $_POST['data'] ) : '';
        $nonce = isset( $_POST['security'] ) ? $_POST['security'] : '';

        if ( ! wp_verify_nonce( $nonce, 'htmega_copy_data' ) || ! current_user_can( 'edit_posts' )
        ) {
            wp_send_json_error(__( 'Sorry, invalid nonce or you are not allowed to import the content.', 'htmega-pro' ));
        }

        if ( empty( $data ) ) {
            wp_send_json_error( __( 'Sorry, your content is empty!', 'htmega-pro' ) );
        }

        $data = array( json_decode( $data, true ) );

        $content = $this->generate_import_ids( $data );
        $content = $this->process_import_content( $data, 'on_import' );

        wp_send_json_success( $content );

    }

    /**
     * [generate_import_ids]
     * @param  [json] $content
     * @return [html] 
     */
    protected function generate_import_ids( $content ){
        return htmega_pro_get_elementor()->db->iterate_data( $content, function ($element){
                $element['id'] = Utils::generate_random_string();
                return $element;
            }
        );
    }
    
    /**
     * [process_import_content]
     * @param  [json] $content
     * @param  [string] $method
     * @return [html]
     */
    protected function process_import_content( $content, $method ){
        return htmega_pro_get_elementor()->db->iterate_data( $content, function ($element_data) use ( $method ){
                $element = htmega_pro_get_elementor()->elements_manager->create_element_instance( $element_data );

                if ( !$element ){ return null; }

                $impdata = $this->process_import_element_content( $element, $method );
                
                return $impdata;
            } 
        );
    }
    
    /**
     * [process_import_element_content]
     * @param Controls_Stack $element
     * @return [array]
     */
    protected function process_import_element_content( Controls_Stack $element, $method ){
        $element_data = $element->get_data();

        if ( method_exists( $element, $method ) ){
            $element_data = $element->{$method}( $element_data );
        }

        foreach ( $element->get_controls() as $control ){
            $control_class = htmega_pro_get_elementor()->controls_manager->get_control( $control['type'] );

            if ( !$control_class ) {
                return $element_data;
            }

            if ( method_exists( $control_class, $method ) ) {
                $element_data['settings'][ $control['name'] ] = $control_class->{$method}( $element->get_settings( $control['name'] ), $control );
            }

        }

        return $element_data;
    }


}

HTMega_Cross_Domain_Copy_Paste_Manager::instance()->init();