<?php

// Exit if accessed directly
if( ! defined( 'ABSPATH' ) ) exit();

define( 'FACEBOOK_AVATAR','<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
viewBox="0 0 35 35" style="enable-background:new 0 0 35 35;" xml:space="preserve">
<style type="text/css">
.st0{fill:url(#SVGID_1_);}
.st1{fill:url(#SVGID_00000167398330377931941220000009764469287497336720_);}
.st2{opacity:0.4;fill:#4285F4;enable-background:new    ;}
.st3{fill:#4285F4;}
.st4{fill-rule:evenodd;clip-rule:evenodd;fill:#072A30;}
.st5{fill-rule:evenodd;clip-rule:evenodd;fill:#43D685;}
.st6{fill:#E7ECED;}
.st7{fill:#556080;}
</style>
<linearGradient id="SVGID_1_" gradientUnits="userSpaceOnUse" x1="17.5" y1="-669.2772" x2="17.5" y2="-634.2772" gradientTransform="matrix(1 0 0 1 0 479)">
<stop  offset="0" style="stop-color:#2AF598"/>
<stop  offset="1" style="stop-color:#009EFD"/>
</linearGradient>
<path class="st0" d="M29.9-167.7c-1.9-1.9-4.2-3.3-6.7-4.2c2.7-1.8,4.4-4.9,4.4-8.3c0-5.6-4.5-10.1-10.1-10.1s-10.1,4.5-10.1,10.1
c0,3.5,1.7,6.5,4.4,8.3c-2.5,0.9-4.7,2.3-6.7,4.2C1.8-164.3,0-160,0-155.3h2.7c0-8.1,6.6-14.8,14.8-14.8s14.8,6.6,14.8,14.8H35
C35-160,33.2-164.3,29.9-167.7z M10.1-180.2c0-4.1,3.3-7.4,7.4-7.4s7.4,3.3,7.4,7.4s-3.3,7.4-7.4,7.4S10.1-176.1,10.1-180.2z"/>
<linearGradient id="SVGID_00000155123275988035624250000012980472308830129324_" gradientUnits="userSpaceOnUse" x1="-9.094947e-13" y1="-604.9653" x2="35" y2="-604.9653" gradientTransform="matrix(1 0 0 1 0 479)">
<stop  offset="0" style="stop-color:#00F2FE"/>
<stop  offset="2.100000e-02" style="stop-color:#03EFFE"/>
<stop  offset="0.293" style="stop-color:#24D2FE"/>
<stop  offset="0.554" style="stop-color:#3CBDFE"/>
<stop  offset="0.796" style="stop-color:#4AB0FE"/>
<stop  offset="1" style="stop-color:#4FACFE"/>
</linearGradient>
<path style="fill:url(#SVGID_00000155123275988035624250000012980472308830129324_);" d="M34.9-113.5c-0.2-0.7-0.9-1.2-1.6-1.1
c-0.7,0.2-1.2,0.9-1.1,1.6c0.1,0.4,0,0.9-0.3,1.2c-0.2,0.2-0.5,0.5-1.1,0.5H4.1c-0.6,0-0.9-0.3-1.1-0.5c-0.3-0.3-0.4-0.8-0.3-1.2
c1.4-6.8,7.4-11.8,14.4-12c0.1,0,0.2,0,0.4,0c0.1,0,0.2,0,0.4,0c4.9,0.1,9.4,2.6,12.1,6.7c0.4,0.6,1.3,0.8,1.9,0.4
c0.6-0.4,0.8-1.3,0.4-1.9c-2.2-3.3-5.5-5.8-9.2-7c2.3-1.7,3.7-4.4,3.7-7.4c0-5.1-4.2-9.3-9.3-9.3s-9.3,4.2-9.3,9.3
c0,3,1.5,5.7,3.7,7.4c-2.1,0.7-4,1.7-5.7,3.1c-3.1,2.6-5.3,6.2-6.1,10.1c-0.3,1.2,0.1,2.5,0.8,3.5c0.8,1,2,1.5,3.2,1.5h26.7
c1.3,0,2.4-0.6,3.2-1.5C34.9-111,35.2-112.2,34.9-113.5z M10.9-134.2c0-3.6,2.9-6.6,6.6-6.6s6.6,2.9,6.6,6.6c0,3.5-2.8,6.4-6.2,6.6
c-0.1,0-0.2,0-0.3,0c-0.1,0-0.2,0-0.3,0C13.7-127.8,10.9-130.7,10.9-134.2z"/>
<g>
<path class="st2" d="M17.5-61.1c9.7,0,17.5-7.8,17.5-17.5c0-9.7-7.8-17.5-17.5-17.5C7.8-96.1,0-88.2,0-78.6
   C0-68.9,7.8-61.1,17.5-61.1z"/>
<path class="st3" d="M17.5-87.4c-3.6,0-6.6,2.9-6.6,6.6c0,3.6,2.8,6.4,6.5,6.5h0.2h0.1h0c3.5-0.1,6.3-3,6.3-6.5
   C24.1-84.5,21.1-87.4,17.5-87.4L17.5-87.4z"/>
<path class="st3" d="M29.4-65.7c-3.1,2.9-7.3,4.6-11.9,4.6s-8.8-1.8-11.9-4.6c0.4-1.6,1.6-3,3.2-4.2c4.8-3.2,12.5-3.2,17.3,0
   C27.8-68.7,28.9-67.3,29.4-65.7z"/>
</g>
<g>
<path class="st4" d="M27.6-15.1c0,0,0,0.1,0.1,0.1c-6.1,4.4-14.3,4.4-20.4,0c0,0,0.1-0.1,0.1-0.1l1.6-4c1-2.5,3.4-4.1,6.1-4.1h4.8
   c2.7,0,5.1,1.6,6.1,4.1L27.6-15.1z"/>
<path class="st4" d="M22.8-34.2c0,2.9-2.4,5.3-5.3,5.3c-2.9,0-5.3-2.4-5.3-5.3s2.4-5.3,5.3-5.3S22.8-37.1,22.8-34.2L22.8-34.2z"/>
<path class="st5" d="M17.5-46.7C7.8-46.7,0-38.9,0-29.2c0,5,2.1,9.7,5.8,13l1.5-3.6c1.3-3.2,4.4-5.3,7.8-5.3h4.8
   c3.5,0,6.6,2.1,7.8,5.3l1.5,3.6c7.2-6.5,7.8-17.5,1.3-24.7C27.2-44.6,22.5-46.7,17.5-46.7z M17.5-27c-4,0-7.2-3.2-7.2-7.2
   s3.2-7.2,7.2-7.2s7.2,3.2,7.2,7.2l0,0C24.7-30.2,21.5-27,17.5-27z"/>
</g>
<g>
<path class="st6" d="M12.3,27.4l-5.2,2.8c-0.3,0.2-0.6,0.4-0.8,0.6c3,2.6,7,4.1,11.3,4.1c4.3,0,8.2-1.5,11.2-4.1
   c-0.3-0.2-0.6-0.4-0.9-0.6l-5.6-2.8c-0.7-0.4-1.2-1.1-1.2-1.9v-2.2c0.2-0.2,0.3-0.4,0.5-0.7c0.8-1.1,1.3-2.3,1.7-3.5
   c0.7-0.2,1.2-0.9,1.2-1.7v-2.3c0-0.5-0.2-1-0.6-1.3v-3.4c0,0,0.7-5.3-6.4-5.3s-6.4,5.3-6.4,5.3v3.4c-0.4,0.3-0.6,0.8-0.6,1.3v2.3
   c0,0.6,0.3,1.2,0.8,1.5c0.6,2.5,2.1,4.4,2.1,4.4v2.1C13.4,26.3,13,27.1,12.3,27.4z"/>
<g>
   <path class="st7" d="M17.8,0C8.1-0.2,0.2,7.5,0,17.2c-0.1,5.5,2.3,10.4,6.2,13.7c0.3-0.2,0.5-0.4,0.8-0.6l5.2-2.8
       c0.7-0.4,1.1-1.1,1.1-1.9v-2.1c0,0-1.5-1.8-2.1-4.4c-0.5-0.3-0.8-0.9-0.8-1.5v-2.3c0-0.5,0.2-1,0.6-1.3v-3.4c0,0-0.7-5.3,6.4-5.3
       s6.4,5.3,6.4,5.3v3.4c0.4,0.3,0.6,0.8,0.6,1.3v2.3c0,0.8-0.5,1.4-1.2,1.7c-0.4,1.2-1,2.4-1.7,3.5c-0.2,0.3-0.4,0.5-0.5,0.7v2.2
       c0,0.8,0.5,1.5,1.2,1.9l5.6,2.8c0.3,0.2,0.6,0.4,0.9,0.6c3.8-3.1,6.2-7.8,6.3-13.1C35.2,8.1,27.5,0.2,17.8,0z"/>
</g>
</g>
</svg>');

/**
 * Get module option value
 * @input section, option_id, option_key, default
 * @return mixed
 */
if( !function_exists('htmega_get_module_option') ) {
    function htmega_get_module_option( $section = '', $option_id = '', $option_key = '', $default = null ){

        $module_settings = get_option( $section );
        
        if( $option_id && is_array( $module_settings ) && count( $module_settings ) > 0 ) {

            if( isset ( $module_settings[ $option_id ] ) && '' != $module_settings[ $option_id ] ) {

                $option_value = json_decode( $module_settings[ $option_id ], true );

                if( $option_key && is_array( $option_value  ) && count( $option_value  ) > 0 ) {

                    if ( isset($option_value[$option_key] ) && '' != $option_value[$option_key] ) {
                        return $option_value[$option_key];
                    } else {
                        return $default;
                    }
                } else {
                    return $module_settings[ $option_id ];
                }
                
            } else {
                return $default;;
            }

        } else {
            return $module_settings;
        }

    }
}

/**
* Options return
*/
function htmega_get_option_pro( $option, $section, $default = '' ){
    $options = get_option( $section );
    if ( isset( $options[$option] ) ) {
        return $options[$option];
    }
    return $default;
}

function htmega_pro_get_elementor() {

    if( !is_plugin_active('elementor/elementor.php') ){
        return;
    } 
    return \Elementor\Plugin::instance();
}
if( !function_exists('htmega_is_editing_mode') ){
    if( !is_plugin_active('elementor/elementor.php') ){
        return;
    } 
    function htmega_is_editing_mode() {
        return ( htmega_pro_get_elementor()->editor->is_edit_mode() ||
        htmega_pro_get_elementor()->preview->is_preview_mode() ||
        is_preview() );
    }
}
/**
 * [htmega_pro_template_endpoint]
 * @return [url]
 */
function htmega_pro_template_endpoint(){
    return 'https://library.wphtmega.com/wp-json/htmega/v1promnmnsdc/templates';
}

/**
 * [htmega_pro_template_url]
 * @return [url]
 */
function htmega_pro_template_url(){
    return 'https://library.wphtmega.com/wp-json/htmega/v1/templates/%s';
}

/**
 * [htmega_get_cookie_name] Get Compare cookie name
 * @return [string] 
 */
function htmega_get_cookie_name() {
    $name = 'htmega_has_count';
    if ( is_multisite() ){
        $name .= '_' . get_current_blog_id();
    }
    return $name;
}

/**
 * [htmega_setpostviews]
 * @param  [int] $postid
 * @param  [string] $posttype
 * @return [null] 
 */
if( !function_exists('htmega_setpostviews') ){
    function htmega_setpostviews( $postid, $posttype ) {

        if( $posttype == 'page' ){
            $count_key = 'ht_page_views_count';
        }else{
            $count_key = 'ht_post_views_count';
        }

        $count = get_post_meta( $postid, $count_key, true );
        if( $count == '' ){
            $count = 0;
            delete_post_meta( $postid, $count_key );
            add_post_meta( $postid, $count_key, '0' );
        }else{
            // if the post has already been stored under the cookie
            $cookie_name = htmega_get_cookie_name();        
            if( !isset( $_COOKIE[ $cookie_name.'-'.$postid ] ) ){
                setcookie( $cookie_name.'-'.$postid, 'htmega_already_count', 0, COOKIEPATH, COOKIE_DOMAIN, false, false );
                $_COOKIE[$cookie_name.'-'.$postid] = "htmega_already_count";
                $count++;
                update_post_meta( $postid, $count_key, $count );
            }
        }

    }
}

/*
 * Get View Counter
 * return $count
 */
if( !function_exists('htmega_getpostviews') ){
    function htmega_getpostviews( $postid, $posttype ){
        if( $posttype == 'page' ){
            $count_key = 'ht_page_views_count';
        }else{
            $count_key = 'ht_post_views_count';
        }
        $count =  get_post_meta( $postid, $count_key, true );
        if( $count == '' ){
            delete_post_meta( $postid, $count_key );
            add_post_meta( $postid, $count_key, '0' );
            return "0";
        }
        return $count;
    }
}

/*
 * Get View Counter
 * return $count
 */
if( !function_exists('htmega_view_count') ){
    function htmega_view_count(){
        if( is_single() && get_post_type() == 'post' ){
            htmega_setpostviews( get_the_ID(), 'post' );
        }elseif( is_singular( 'page' ) && get_post_type() == 'page' ){
            htmega_setpostviews( get_the_ID(), 'page' );
        }
    }
    add_action('template_redirect', 'htmega_view_count');
}
/**
 * [htmega_addons_language_code]
 * @return [array]
 */
function htmega_addons_language_code(){
    return [
        'af' => 'Afrikaans',
        'sq' => 'Albanian',
        'ar' => 'Arabic',
        'eu' => 'Basque',
        'bn' => 'Bengali',
        'bs' => 'Bosnian',
        'bg' => 'Bulgarian',
        'ca' => 'Catalan',
        'zh-cn' => 'Chinese',
        'zh-tw' => 'Chinese-tw',
        'hr' => 'Croatian',
        'cs' => 'Czech',
        'da' => 'Danish',
        'nl' => 'Dutch',
        'en' => 'English',
        'et' => 'Estonian',
        'fi' => 'Finnish',
        'fr' => 'French',
        'gl' => 'Galician',
        'ka' => 'Georgian',
        'de' => 'German',
        'el' => 'Greek (Modern)',
        'he' => 'Hebrew',
        'hi' => 'Hindi',
        'hu' => 'Hungarian',
        'is' => 'Icelandic',
        'io' => 'Ido',
        'id' => 'Indonesian',
        'it' => 'Italian',
        'ja' => 'Japanese',
        'kk' => 'Kazakh',
        'ko' => 'Korean',
        'lv' => 'Latvian',
        'lb' => 'Letzeburgesch',
        'lt' => 'Lithuanian',
        'lu' => 'Luba-Katanga',
        'mk' => 'Macedonian',
        'mg' => 'Malagasy',
        'ms' => 'Malay',
        'ro' => 'Moldovan, Moldavian, Romanian',
        'nb' => 'Norwegian Bokmål',
        'nn' => 'Norwegian Nynorsk',
        'fa' => 'Persian',
        'pl' => 'Polish',
        'pt' => 'Portuguese',
        'ru' => 'Russian',
        'sr' => 'Serbian',
        'sk' => 'Slovak',
        'sl' => 'Slovenian',
        'es' => 'Spanish',
        'sv' => 'Swedish',
        'tr' => 'Turkish',
        'uk' => 'Ukrainian',
        'vi' => 'Vietnamese',
    ];
}

/**
 * Escaped title html tags
 *
 * @param string $tag input string of title tag
 * @return string $default default tag will be return during no matches
 */

function htmega_escape_tags( $tag, $default = 'span', $extra = [] ) {

    $supports = ['h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'div', 'span', 'p'];

    $supports = array_merge( $supports, $extra );

    if ( !in_array($tag, $supports, true) ) {
        return $default;
    }

    return $tag;
}

/*
 * All Taxonomie Category Load
 * return Array
*/
if( !function_exists('all_object_taxonomie_show_catagory') ){
    function all_object_taxonomie_show_catagory($taxonomieName){

        $allTaxonomie =  get_object_taxonomies($taxonomieName);
        if(isset($allTaxonomie['0'])){
            if($allTaxonomie['0'] == "product_type"){
                $allTaxonomie['0'] = 'product_cat';
            }
            return htmega_get_taxonomies($allTaxonomie['0']);
        }
    }
}


/*
 * Get Taxonomie by Post Type 
 * return Array
*/
if( !function_exists('get_taxonomie_by_post_type') ){
    function get_taxonomie_by_post_type($taxonomieName){

        $args=array('object_type' => array($taxonomieName)); 
        $output = 'objects'; // or objects
        $operator = 'and'; // 'and' or 'or'
        $taxonomies = get_taxonomies($args,$output,$operator); 

        $newTaxonomyList = array();
        if  ($taxonomies) {
            foreach ($taxonomies  as $taxonomy ) {
                $newTaxonomyList[$taxonomy->name] = $taxonomy->label;
            }
        }
        
       return $newTaxonomyList;
    }
}

/*
 * Get Post Type
 * return Array
*/
if( !function_exists('htmega_get_terms_post_types') ){
    function htmega_get_terms_post_types(){
        $post_types = htmega_get_post_types();
        $newTermsPost = array();
        foreach($post_types as $typeKey => $typeValue){
            if($typeKey != 'page' && $typeKey != 'e-landing-page'){
                $newTermsPost[$typeKey] = $typeValue;
            }
        }
        return $newTermsPost;
    }
}

/*
 * Get rating
 * Input average value,font size, empty color, rated color,icon class
 * return html star with div
*/
if( !function_exists('htmega_get_avg_rating') ){
    function htmega_get_avg_rating( $avg=100, $font_size=23, $empty_color="#E2E0E5", $rated_color="#FCBD23"){
        $avg = (int)$avg;
        $font_size = (int)$font_size;
        $star_width = ($font_size * 5)+16;
        ?>
        <div class="htmega-avg-rating" style="position:relative;overflow:hidden;line-height:1">
                <svg width="<?php echo esc_attr($star_width); ?>" viewBox="0 0 130 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M23.0577 8.96564L16.611 8.02872L13.7291 2.18634C13.6504 2.02638 13.5209 1.89688 13.361 1.81817C12.9598 1.62013 12.4723 1.78517 12.2717 2.18634L9.38989 8.02872L2.9432 8.96564C2.76547 8.99103 2.60297 9.07482 2.47855 9.20177C2.32814 9.35636 2.24526 9.56435 2.24812 9.78002C2.25097 9.99569 2.33934 10.2014 2.49379 10.352L7.15805 14.8994L6.0561 21.3207C6.03025 21.4701 6.04678 21.6237 6.10381 21.7642C6.16084 21.9046 6.25608 22.0263 6.37873 22.1154C6.50139 22.2045 6.64655 22.2574 6.79776 22.2682C6.94896 22.279 7.10017 22.2472 7.23422 22.1764L13.0004 19.1447L18.7667 22.1764C18.9241 22.2602 19.1069 22.2881 19.2821 22.2576C19.7239 22.1815 20.021 21.7625 19.9448 21.3207L18.8428 14.8994L23.5071 10.352C23.634 10.2276 23.7178 10.0651 23.7432 9.88732C23.8118 9.44298 23.502 9.03165 23.0577 8.96564Z" fill="<?php echo esc_attr($empty_color); ?>"/>
                    <path d="M49.0577 8.96564L42.611 8.02872L39.7291 2.18634C39.6504 2.02638 39.5209 1.89688 39.361 1.81817C38.9598 1.62013 38.4723 1.78517 38.2717 2.18634L35.3899 8.02872L28.9432 8.96564C28.7655 8.99103 28.603 9.07482 28.4786 9.20177C28.3281 9.35636 28.2453 9.56435 28.2481 9.78002C28.251 9.99569 28.3393 10.2014 28.4938 10.352L33.158 14.8994L32.0561 21.3207C32.0303 21.4701 32.0468 21.6237 32.1038 21.7642C32.1608 21.9046 32.2561 22.0263 32.3787 22.1154C32.5014 22.2045 32.6465 22.2574 32.7978 22.2682C32.949 22.279 33.1002 22.2472 33.2342 22.1764L39.0004 19.1447L44.7667 22.1764C44.9241 22.2602 45.1069 22.2881 45.2821 22.2576C45.7239 22.1815 46.021 21.7625 45.9448 21.3207L44.8428 14.8994L49.5071 10.352C49.634 10.2276 49.7178 10.0651 49.7432 9.88732C49.8118 9.44298 49.502 9.03165 49.0577 8.96564Z" fill="<?php echo esc_attr($empty_color); ?>"/>
                    <path d="M75.0577 8.96564L68.611 8.02872L65.7291 2.18634C65.6504 2.02638 65.5209 1.89688 65.361 1.81817C64.9598 1.62013 64.4723 1.78517 64.2717 2.18634L61.3899 8.02872L54.9432 8.96564C54.7655 8.99103 54.603 9.07482 54.4786 9.20177C54.3281 9.35636 54.2453 9.56435 54.2481 9.78002C54.251 9.99569 54.3393 10.2014 54.4938 10.352L59.158 14.8994L58.0561 21.3207C58.0303 21.4701 58.0468 21.6237 58.1038 21.7642C58.1608 21.9046 58.2561 22.0263 58.3787 22.1154C58.5014 22.2045 58.6465 22.2574 58.7978 22.2682C58.949 22.279 59.1002 22.2472 59.2342 22.1764L65.0004 19.1447L70.7667 22.1764C70.9241 22.2602 71.1069 22.2881 71.2821 22.2576C71.7239 22.1815 72.021 21.7625 71.9448 21.3207L70.8428 14.8994L75.5071 10.352C75.634 10.2276 75.7178 10.0651 75.7432 9.88732C75.8118 9.44298 75.502 9.03165 75.0577 8.96564Z" fill="<?php echo esc_attr($empty_color); ?>"/>
                    <path d="M101.058 8.96564L94.611 8.02872L91.7291 2.18634C91.6504 2.02638 91.5209 1.89688 91.361 1.81817C90.9598 1.62013 90.4723 1.78517 90.2717 2.18634L87.3899 8.02872L80.9432 8.96564C80.7655 8.99103 80.603 9.07482 80.4786 9.20177C80.3281 9.35636 80.2453 9.56435 80.2481 9.78002C80.251 9.99569 80.3393 10.2014 80.4938 10.352L85.158 14.8994L84.0561 21.3207C84.0303 21.4701 84.0468 21.6237 84.1038 21.7642C84.1608 21.9046 84.2561 22.0263 84.3787 22.1154C84.5014 22.2045 84.6465 22.2574 84.7978 22.2682C84.949 22.279 85.1002 22.2472 85.2342 22.1764L91.0004 19.1447L96.7667 22.1764C96.9241 22.2602 97.1069 22.2881 97.2821 22.2576C97.7239 22.1815 98.021 21.7625 97.9448 21.3207L96.8428 14.8994L101.507 10.352C101.634 10.2276 101.718 10.0651 101.743 9.88732C101.812 9.44298 101.502 9.03165 101.058 8.96564Z" fill="<?php echo esc_attr($empty_color); ?>"/>
                    <path d="M127.058 8.96564L120.611 8.02872L117.729 2.18634C117.65 2.02638 117.521 1.89688 117.361 1.81817C116.96 1.62013 116.472 1.78517 116.272 2.18634L113.39 8.02872L106.943 8.96564C106.765 8.99103 106.603 9.07482 106.479 9.20177C106.328 9.35636 106.245 9.56435 106.248 9.78002C106.251 9.99569 106.339 10.2014 106.494 10.352L111.158 14.8994L110.056 21.3207C110.03 21.4701 110.047 21.6237 110.104 21.7642C110.161 21.9046 110.256 22.0263 110.379 22.1154C110.501 22.2045 110.647 22.2574 110.798 22.2682C110.949 22.279 111.1 22.2472 111.234 22.1764L117 19.1447L122.767 22.1764C122.924 22.2602 123.107 22.2881 123.282 22.2576C123.724 22.1815 124.021 21.7625 123.945 21.3207L122.843 14.8994L127.507 10.352C127.634 10.2276 127.718 10.0651 127.743 9.88732C127.812 9.44298 127.502 9.03165 127.058 8.96564Z" fill="<?php echo esc_attr($empty_color); ?>"/>
                    </svg>
            <div class="htmega-active-rating" style="position: absolute;display: block;top: 0; width:<?php echo  esc_attr($avg); ?>%;overflow: hidden;">
                <svg width="<?php echo esc_attr($star_width); ?>" viewBox="0 0 130 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M23.0577 8.96564L16.611 8.02872L13.7291 2.18634C13.6504 2.02638 13.5209 1.89688 13.361 1.81817C12.9598 1.62013 12.4723 1.78517 12.2717 2.18634L9.38989 8.02872L2.9432 8.96564C2.76547 8.99103 2.60297 9.07482 2.47855 9.20177C2.32814 9.35636 2.24526 9.56435 2.24812 9.78002C2.25097 9.99569 2.33934 10.2014 2.49379 10.352L7.15805 14.8994L6.0561 21.3207C6.03025 21.4701 6.04678 21.6237 6.10381 21.7642C6.16084 21.9046 6.25608 22.0263 6.37873 22.1154C6.50139 22.2045 6.64655 22.2574 6.79776 22.2682C6.94896 22.279 7.10017 22.2472 7.23422 22.1764L13.0004 19.1447L18.7667 22.1764C18.9241 22.2602 19.1069 22.2881 19.2821 22.2576C19.7239 22.1815 20.021 21.7625 19.9448 21.3207L18.8428 14.8994L23.5071 10.352C23.634 10.2276 23.7178 10.0651 23.7432 9.88732C23.8118 9.44298 23.502 9.03165 23.0577 8.96564Z" fill="<?php echo esc_attr($rated_color); ?>"/>
                    <path d="M49.0577 8.96564L42.611 8.02872L39.7291 2.18634C39.6504 2.02638 39.5209 1.89688 39.361 1.81817C38.9598 1.62013 38.4723 1.78517 38.2717 2.18634L35.3899 8.02872L28.9432 8.96564C28.7655 8.99103 28.603 9.07482 28.4786 9.20177C28.3281 9.35636 28.2453 9.56435 28.2481 9.78002C28.251 9.99569 28.3393 10.2014 28.4938 10.352L33.158 14.8994L32.0561 21.3207C32.0303 21.4701 32.0468 21.6237 32.1038 21.7642C32.1608 21.9046 32.2561 22.0263 32.3787 22.1154C32.5014 22.2045 32.6465 22.2574 32.7978 22.2682C32.949 22.279 33.1002 22.2472 33.2342 22.1764L39.0004 19.1447L44.7667 22.1764C44.9241 22.2602 45.1069 22.2881 45.2821 22.2576C45.7239 22.1815 46.021 21.7625 45.9448 21.3207L44.8428 14.8994L49.5071 10.352C49.634 10.2276 49.7178 10.0651 49.7432 9.88732C49.8118 9.44298 49.502 9.03165 49.0577 8.96564Z" fill="<?php echo esc_attr($rated_color); ?>"/>
                    <path d="M75.0577 8.96564L68.611 8.02872L65.7291 2.18634C65.6504 2.02638 65.5209 1.89688 65.361 1.81817C64.9598 1.62013 64.4723 1.78517 64.2717 2.18634L61.3899 8.02872L54.9432 8.96564C54.7655 8.99103 54.603 9.07482 54.4786 9.20177C54.3281 9.35636 54.2453 9.56435 54.2481 9.78002C54.251 9.99569 54.3393 10.2014 54.4938 10.352L59.158 14.8994L58.0561 21.3207C58.0303 21.4701 58.0468 21.6237 58.1038 21.7642C58.1608 21.9046 58.2561 22.0263 58.3787 22.1154C58.5014 22.2045 58.6465 22.2574 58.7978 22.2682C58.949 22.279 59.1002 22.2472 59.2342 22.1764L65.0004 19.1447L70.7667 22.1764C70.9241 22.2602 71.1069 22.2881 71.2821 22.2576C71.7239 22.1815 72.021 21.7625 71.9448 21.3207L70.8428 14.8994L75.5071 10.352C75.634 10.2276 75.7178 10.0651 75.7432 9.88732C75.8118 9.44298 75.502 9.03165 75.0577 8.96564Z" fill="<?php echo esc_attr($rated_color); ?>"/>
                    <path d="M101.058 8.96564L94.611 8.02872L91.7291 2.18634C91.6504 2.02638 91.5209 1.89688 91.361 1.81817C90.9598 1.62013 90.4723 1.78517 90.2717 2.18634L87.3899 8.02872L80.9432 8.96564C80.7655 8.99103 80.603 9.07482 80.4786 9.20177C80.3281 9.35636 80.2453 9.56435 80.2481 9.78002C80.251 9.99569 80.3393 10.2014 80.4938 10.352L85.158 14.8994L84.0561 21.3207C84.0303 21.4701 84.0468 21.6237 84.1038 21.7642C84.1608 21.9046 84.2561 22.0263 84.3787 22.1154C84.5014 22.2045 84.6465 22.2574 84.7978 22.2682C84.949 22.279 85.1002 22.2472 85.2342 22.1764L91.0004 19.1447L96.7667 22.1764C96.9241 22.2602 97.1069 22.2881 97.2821 22.2576C97.7239 22.1815 98.021 21.7625 97.9448 21.3207L96.8428 14.8994L101.507 10.352C101.634 10.2276 101.718 10.0651 101.743 9.88732C101.812 9.44298 101.502 9.03165 101.058 8.96564Z" fill="<?php echo esc_attr($rated_color); ?>"/>
                    <path d="M127.058 8.96564L120.611 8.02872L117.729 2.18634C117.65 2.02638 117.521 1.89688 117.361 1.81817C116.96 1.62013 116.472 1.78517 116.272 2.18634L113.39 8.02872L106.943 8.96564C106.765 8.99103 106.603 9.07482 106.479 9.20177C106.328 9.35636 106.245 9.56435 106.248 9.78002C106.251 9.99569 106.339 10.2014 106.494 10.352L111.158 14.8994L110.056 21.3207C110.03 21.4701 110.047 21.6237 110.104 21.7642C110.161 21.9046 110.256 22.0263 110.379 22.1154C110.501 22.2045 110.647 22.2574 110.798 22.2682C110.949 22.279 111.1 22.2472 111.234 22.1764L117 19.1447L122.767 22.1764C122.924 22.2602 123.107 22.2881 123.282 22.2576C123.724 22.1815 124.021 21.7625 123.945 21.3207L122.843 14.8994L127.507 10.352C127.634 10.2276 127.718 10.0651 127.743 9.88732C127.812 9.44298 127.502 9.03165 127.058 8.96564Z" fill="<?php echo esc_attr($rated_color); ?>"/>
                    </svg> 
                </div>
        </div>
        <?php
    }
}
// Date and time function
function htmega_time_ago($date) {
    $time = strtotime($date);
    // Calculate difference between current
    // time and given timestamp in seconds
    //date_default_timezone_set("Asia/Dhaka");
    $diff     = time() - $time;
    // Time difference in seconds
    $sec     = $diff;
      
    // Convert time difference in minutes
    $min     = round($diff / 60 );
      
    // Convert time difference in hours
    $hrs     = round($diff / 3600);
      
    // Convert time difference in days
    $days     = round($diff / 86400 );
      
    // Convert time difference in weeks
    $weeks     = round($diff / 604800);
      
    // Convert time difference in months
    $mnths     = round($diff / 2600640 );
      
    // Convert time difference in years
    $yrs     = round($diff / 31207680 );
      
    // Check for seconds
    if ($sec <= 60) {
        echo sprintf( esc_html__( '%s Seconds ago', 'htmega-pro' ), esc_html( $sec ) );
    }
    // Check for minutes
    else if($min <= 60) {
        if($min==1) {
            echo esc_html__('One minute ago','htmega-pro');
        }
        else {
            echo esc_html( $min ) . esc_html__( ' Minutes ago', 'htmega-pro' );
        }
    }
      
    // Check for hours
    else if($hrs <= 24) {
        if($hrs == 1) { 
            echo esc_html__('An hour ago','htmega-pro');
        }
        else {
            echo esc_html( $hrs ) .esc_html__(' Hours ago','htmega-pro');
            
        }
    }
      
    // Check for days
    else if($days <= 7) {
        if($days == 1) {
            echo esc_html__('Yesterday','htmega-pro');
        }
        else {
            echo esc_html( $days ) .esc_html__(' Days ago','htmega-pro');
        }
    }
      
    // Check for weeks
    else if($weeks <= 4.3) {
        if($weeks == 1) {
            echo esc_html__('A week ago','htmega-pro');
        }
        else {
            echo esc_html( $weeks ) .esc_html__(' Weeks ago','htmega-pro');
        }
    }
      
    // Check for months
    else if($mnths <= 12) {
        if($mnths == 1) {
            echo esc_html__('A month ago','htmega-pro');
        }
        else {
            echo esc_html( $mnths ) .esc_html__(' A month ago','htmega-pro');
        }
    }
      
    // Check for years
    else {
        if($yrs == 1) {
            echo esc_html__('One year ago','htmega-pro');
        }
        else {
            echo esc_html( $yrs ) .esc_html__(' Years ago','htmega-pro');
        }
    }
}

    // Transient Delete action
    add_action('wp_ajax_my_delete_transient_action', 'htmega_fb_transient'); // wp_ajax_{ACTION HERE}  

    function htmega_fb_transient(){
        check_ajax_referer( 'htmega-admin-ajax-request', 'security' );
        delete_transient( 'fb_page_info_transient' );
        delete_transient( 'fb_rating_transient' );
        die();
    }


    /**
     * Get all Authors List
     *
     * @return array
     */
    function htmega_get_authors_list() {
        $args = [
            'capability'          => [ 'edit_posts' ],
            'has_published_posts' => true,
            'fields'              => [
                'ID',
                'display_name',
            ],
        ];

        // Version check 5.9.
        if ( version_compare( $GLOBALS['wp_version'], '5.9-alpha', '<' ) ) {
            $args['who'] = 'authors';
            unset( $args['capability'] );
        }

        $authors = get_users( $args );

        if ( ! empty( $authors ) ) {
            return wp_list_pluck( $authors, 'display_name', 'ID' );
        }

        return [];
    }

    /**
     * Get all Tags List
     *
     * @param  array  $args
     *
     * @return array
     */
    function htmega_get_tags_list( $args = array() ) {
        $options = [];
        $tags = get_tags( $args );

        if (!is_wp_error( $tags ) && !empty( $tag )) {
            foreach ( $tags as $tag ) {
                $options[$tag->term_id] = $tag->name;
            }
        }
        return $options;
    }

/**
 * Get all Database Table List
 *
 * @version 1.5.2
 * @return array
 */
function htmega_all_db_tbl_list() {
	global $wpdb;

	$all_tbl_list = [];
	$all_tables = $wpdb->get_results('show tables', ARRAY_N);

	if ( $all_tables ) {

		$all_tables = wp_list_pluck($all_tables, 0);

		foreach ( $all_tables as $table ) {
			$all_tbl_list[$table] = $table;
		}
	}

	return $all_tbl_list;
}

/**
 *  Get TablePress table list
 * 
 * @version 1.5.2
 * @return array
 */
function htmega_get_table_press_tbl_list() {
	$tbl_list = [];
	if ( !class_exists('TablePress') ) return $tbl_list;
	$all_tables = TablePress::$model_table->load_all(true);
	if ( $all_tables ) {
		foreach ( $all_tables as $table ) {
			$table = TablePress::$model_table->load( $table, false, false );
			$tbl_list[$table['id']] = $table['name'];
		}
	}
	return $tbl_list;
}

/**
 * get all the user roll
 *
 * @version 1.5.3
 * @return array
 */
 function htmega_get_user_roles() {
    $wp_roles       = [];
    $all_roles      = wp_roles()->roles;
    foreach ( $all_roles as $slug => $role ) {
        $wp_roles[ $slug ] = $role['name'];
    }
    return $wp_roles;
}


/**
 * Compare value.
 * @since 1.6.0
 * Compare two values based on Comparison operator
 *
 * @param mixed $left_value  First value to compare.
 * @param mixed $right_value  Second value to compare.
 * @param string $operator  Comparison operator.
 * @return bool
 */
function htmega_value_compare( $left_value, $right_value, $operator ) {
	switch ( $operator ) {
		case 'is':
			return $left_value == $right_value;
		case 'not':
			return $left_value != $right_value;
		default:
			return $left_value === $right_value;
	}
}

/**
 * Get User Browser name
 *
 * @version 1.6.0
 * @param $user_agent
 * @return string
 */
function htmega_get_browser_name( $user_agent ) {

	if ( strpos( $user_agent, 'Opera' ) || strpos( $user_agent, 'OPR/' ) ) return 'opera';
	elseif ( strpos( $user_agent, 'Edge' ) ) return 'edge';
	elseif ( strpos( $user_agent, 'Edg' ) ) return 'edge';
	elseif ( strpos( $user_agent, 'Chrome' ) ) return 'chrome';
	elseif ( strpos( $user_agent, 'Safari' ) ) return 'safari';
	elseif ( strpos( $user_agent, 'Firefox' ) ) return 'firefox';
	elseif ( strpos( $user_agent, 'MSIE' ) || strpos( $user_agent, 'Trident/7' ) ) return 'ie';
	return 'other';
}

/**
  * @version 1.6.0
 * Get Client Website Time
 * @param string $format
 * @return string
 */
function htmega_get_local_time( $format = 'Y-m-d h:i:s A' ) {
	$local_time_zone = isset( $_COOKIE['HTMegaLocalTimeZone'] ) && !empty( $_COOKIE['HTMegaLocalTimeZone'] ) ? str_replace( 'GMT ', 'GMT+', $_COOKIE['HTMegaLocalTimeZone'] ) : date_default_timezone_get();
	$now_date = new \DateTime( 'now', new \DateTimeZone( $local_time_zone ) );
	$today = $now_date->format( $format );
	return $today;
}

/**
 * @version 1.6.0
 * Get Server Time
 * @param string $format
 * @return string
 */
function htmega_get_server_time( $format = 'Y-m-d h:i:s A' ) {
	$today 	= gmdate( $format, strtotime("now") + ( get_option( 'gmt_offset') * HOUR_IN_SECONDS ) );
	return $today;
}

/**
 * @version 1.6.1
 * Get Elementor template id using template title
 *
 * @param [type] $template_title
 * @return int/void
 */
function htmega_get_template_id_by_title( $template_title ) {
    $query = new WP_Query( array(
        'post_type'      => 'elementor_library',
        'posts_per_page' => 1,
        's'              => $template_title, // Search by template title
    ) );

    // Check if there are any posts found
    if ($query->have_posts()) {
        // Return the first template ID found
        $template_id = $query->posts[0]->ID;
        return $template_id;
    }

    // Template not found
    return false;
}

/**
 * ExtractVideoId
 * @since 1.7.4
 * @param [type] $url
 * @return $videoid || null
 */
function htmega_extract_video_id($url) {

    // Parse the URL and extract the "v" parameter
    $parsed_url = wp_parse_url($url);

    // check if exist youtube.com in the url
    if ( strpos($url, 'youtube.com') !== false  || strpos($url, 'youtu.be') !== false ) {
        if (isset($parsed_url['query'])) {
            parse_str($parsed_url['query'], $query_params);
            if (isset($query_params['v'])) {
                return $query_params['v'];
            }
        }
        // If the above method didn't work, try to extract the video ID from the path
        $path = trim($parsed_url['path'], '/');
        $path_parts = explode('/', $path);
        foreach ($path_parts as $part) {
            if (strlen($part) === 11) {
                return $part;
            }
        }

    } else if ( strpos($url, 'vimeo.com') !== false ) {
        // If the URL is a Vimeo URL, extract the video ID from the path
        $path = trim($parsed_url['path'], '/');
        $path_parts = explode('/', $path);
        foreach ($path_parts as $part) {
            if (is_numeric($part)) {
                return $part;
            }
        }
    
    }

    // Return null if the video ID couldn't be found
    return null;
}

/**
 * Slugify
 * Slugify a string to be used as a URL slug or class name.
 *
 * @param string $text
 * @param string $separator (optional)
 * @param string $as_class_name (optional) if slug has , then retun the text adding a space 
 * @return string
 */
function htmega_slugify($text, $as_class_name = false, $separator = '-' ) {
    // Check if the text contains a comma

    if ( $as_class_name && strpos($text, ',') !== false ) {
        // Split the text by commas and process each word
        $words = explode(',', $text);
        $trimmed_and_cleaned_words = [];
        
        foreach ($words as $word) {
            // Trim each word and remove non-alphanumeric characters
            $word = preg_replace('/[^a-zA-Z0-9]+/', '', trim($word));
            if (!empty($word)) {
                $trimmed_and_cleaned_words[] = $word;
            }
        }
        
      return $text = implode(' ', $trimmed_and_cleaned_words);
    }

    // Convert the string to lowercase and remove non-alphanumeric characters.
    $text = strtolower(preg_replace('/[^a-zA-Z0-9]+/', $separator, $text));

    // Remove leading and trailing separator characters.
    $text = trim($text, $separator);

    return $text;
}

/**
 * [htmega_clean]
 * @param  [JSON] $var
 * @return [array]
 */

 if( !function_exists('htmega_clean') ) {
    function htmega_clean( $var ) {
        if ( is_array( $var ) ) {
            return array_map( 'htmega_clean', $var );
        } else {
            return is_scalar( $var ) ? esc_html( $var ) : $var;
        }
    }
 }

 /**
 * [htmega_get_local_file_data]
 * @param  string $file_path
 * @return mixed  $data | false
 */
if ( ! function_exists( 'htmega_get_local_file_data' ) ) {
    function htmega_get_local_file_data( $file_path ) {
        if ( ! file_exists( $file_path ) ) {
            return false;
        }

        // Initialize the WordPress filesystem
        global $wp_filesystem;
        if ( empty( $wp_filesystem ) ) {
            require_once( ABSPATH . 'wp-admin/includes/file.php' );
            WP_Filesystem();
        }
        
        // Check if the file is readable
        if ( ! is_readable( $file_path ) ) {
            return false;
        }
        
        // Read the file contents using the WP_Filesystem API
        $data = $wp_filesystem->get_contents( $file_path );
        if ( $data === false ) {
            return false;
        }

        return $data;
    }
}

/**
 * [htmega_get_remote_file_data]
 * @param  string $file_url
 * @return mixed  $data | false
 */
if ( ! function_exists( 'htmega_get_remote_file_data' ) ) {
    function htmega_get_remote_file_data( $file_url ) {
        // Using wp_remote_get to fetch the remote file
        $response = wp_remote_get( $file_url );

        // Check if the response contains an error
        if ( is_wp_error( $response ) ) {
            return false;
        }

        // Retrieve the body of the response
        $data = wp_remote_retrieve_body( $response );

        // Check if the body is empty
        if ( empty( $data ) ) {
            return false;
        }

        return $data;
    }
}

/**
 * Get template content by id
 * @since 1.9.3
 * @param [type] $template_id
 * @return string
 */

 if ( !function_exists('htmega_get_template_content_by_id') ) {
    function htmega_get_template_content_by_id( $template_id ) {
        $template_post = get_post( $template_id );
        
        // Check if the post exists and its status is 'publish'
        if ( $template_post && $template_post->post_status === 'publish' ) {
            return \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $template_id );
        } else {
            return esc_html__( 'Template not published or does not exist', 'htmega-pro');
        }
    }
}


function htmega_force_update_plugin($pluginFile) {
    include_once ABSPATH . 'wp-includes/pluggable.php';
    include_once ABSPATH . 'wp-admin/includes/misc.php';
    include_once ABSPATH . 'wp-admin/includes/file.php';
    include_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';
    include_once ABSPATH . 'wp-admin/includes/plugin-install.php';

    $skin = new Automatic_Upgrader_Skin();
    $upgrader = new Plugin_Upgrader($skin);
    $result = $upgrader->upgrade($pluginFile);

    if (!is_wp_error($result)) {
        $result = activate_plugin($pluginFile);
    }
    
    return ( ! is_wp_error($result) ? true : false);
}
