<?php

    require_once "HTMegaProBase.php";

	class HTMegaPro {
        public $plugin_file=HTMEGA_ADDONS_PL_ROOT_PRO;
        public $responseObj;
        public $licenseMessage;
        public $showMessage=false;
        public $slug="htmega-pro";
        function __construct() {
    	    add_action( 'admin_print_styles', [ $this, 'SetAdminStyle' ] );
    	    $licenseKey=get_option("HTMegaPro_lic_Key","");
    	    $liceEmail=get_option( "HTMegaPro_lic_email","");
            HTMegaProBase::addOnDelete(function(){
               delete_option("HTMegaPro_lic_Key");
            });
            $checkLicense = HTMegaProBase::CheckWPPlugin($licenseKey,$liceEmail,$this->licenseMessage,$this->responseObj,HTMEGA_ADDONS_PL_ROOT_PRO);
            if( !$checkLicense || $checkLicense){
                if( $this->isWooLentorBundle() ){
                    return;
                }
            }
    	    if ( $checkLicense ){
    		    add_action( 'admin_menu', [$this,'ActiveAdminMenu'], 228 );
    		    add_action( 'admin_post_HTMegaPro_el_deactivate_license', [ $this, 'action_deactivate_license' ] );
                add_filter( 'htmega_license_title', [ $this, 'get_license_title' ] );
    	    }else{
    	        if(!empty($licenseKey) && !empty($this->licenseMessage)){
    	           $this->showMessage=true;
                }
    		    update_option("HTMegaPro_lic_Key","") || add_option("HTMegaPro_lic_Key","");
    		    add_action( 'admin_post_HTMegaPro_el_activate_license', [ $this, 'action_activate_license' ] );
    		    add_action( 'admin_menu', [$this,'InactiveMenu'], 228 );
    	    }
        }
        
        public function get_license_title($value){
            $value = $this->responseObj->license_title;
            return $value;
        }

        function isWooLentorBundle(){
            HTMegaProBase::setWooLentorData();
            $dataObj = HTMegaProBase::$woolentorLicenseData;
            if( $dataObj ){
                if( $dataObj->is_valid && strstr( $dataObj->license_title, 'WooLentor Bundle' ) ){
                    return true;
                }else{
                    return false;
                }
            }else{
                return false;
            }
        }

    	function SetAdminStyle() {
    		wp_register_style( "HTMegaProLic", HTMEGA_ADDONS_PL_URL_PRO . 'includes/licence/style.css' ,10 );
    		wp_enqueue_style( "HTMegaProLic" );
    	}
        function ActiveAdminMenu(){
            add_submenu_page(
                'htmega-addons', 
                __( 'License', 'htmega-pro' ),
                __( 'License', 'htmega-pro' ), 
                'manage_options', 
                $this->slug, 
                array ( $this, 'Activated' ) 
            );

        }
        function InactiveMenu() {
            add_submenu_page(
                'htmega-addons', 
                __( 'License', 'htmega-pro' ),
                __( 'License', 'htmega-pro' ), 
                'manage_options', 
                $this->slug, 
                array ( $this, 'LicenseForm' ) 
            );

        }
        function action_activate_license(){
        		check_admin_referer( 'el-license' );
        		$licenseKey=!empty($_POST['el_license_key'])?$_POST['el_license_key']:"";
        		$licenseEmail=!empty($_POST['el_license_email'])?$_POST['el_license_email']:"";
        		update_option("HTMegaPro_lic_Key",$licenseKey) || add_option("HTMegaPro_lic_Key",$licenseKey);
        		update_option("HTMegaPro_lic_email",$licenseEmail) || add_option("HTMegaPro_lic_email",$licenseEmail);
        		wp_safe_redirect(admin_url( 'admin.php?page='.$this->slug));
        	}
        function action_deactivate_license() {
    	    check_admin_referer( 'el-license' );
    	    if(HTMegaProBase::RemoveLicenseKey(__FILE__,$message)){
    		    update_option("HTMegaPro_lic_Key","") || add_option("HTMegaPro_lic_Key","");
    	    }
    	    wp_safe_redirect(admin_url( 'admin.php?page='.$this->slug));
        }
        function Activated(){
            ?>
            <form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
                <input type="hidden" name="action" value="HTMegaPro_el_deactivate_license"/>
                <div class="el-license-container">
                    <h3 class="el-license-title"><i class="dashicons-before dashicons-star-filled"></i> <?php echo esc_html__("HT Mega Pro License Info",'htmega-pro');?> </h3>
                    <hr>
                    <ul class="el-license-info">
                    <li>
                        <div>
                            <span class="el-license-info-title"><?php echo esc_html__("Status",'htmega-pro');?></span>

    			            <?php if ( $this->responseObj->is_valid ) : ?>
                                <span class="el-license-valid"><?php echo esc_html__("Valid",'htmega-pro');?></span>
    			            <?php else : ?>
                                <span class="el-license-valid"><?php echo esc_html__("Invalid",'htmega-pro');?></span>
    			            <?php endif; ?>
                        </div>
                    </li>

                    <li>
                        <div>
                            <span class="el-license-info-title"><?php echo esc_html__("License Type",'htmega-pro');?></span>
    			            <?php echo $this->responseObj->license_title; ?>
                        </div>
                    </li>

                    <li>
                        <div>
                            <span class="el-license-info-title"><?php echo esc_html__("License Expired on",'htmega-pro');?></span>
    			            <?php echo $this->responseObj->expire_date; ?>
                        </div>
                    </li>

                    <li>
                        <div>
                            <span class="el-license-info-title"><?php echo esc_html__("Support Expired on",'htmega-pro');?></span>
    			            <?php echo $this->responseObj->support_end; ?>
                        </div>
                    </li>
                        <li>
                            <div>
                                <span class="el-license-info-title"><?php echo esc_html__("Your License Key",'htmega-pro');?></span>
                                <span class="el-license-key"><?php echo esc_attr( substr($this->responseObj->license_key,0,9)."XXXXXXXX-XXXXXXXX".substr($this->responseObj->license_key,-9) ); ?></span>
                            </div>
                        </li>
                    </ul>
                    <div class="el-license-active-btn">
    				    <?php wp_nonce_field( 'el-license' ); ?>
    				    <?php submit_button('Deactivate'); ?>
                    </div>
                </div>
            </form>
    	<?php
        }

        function LicenseForm() {
    	    ?>
        <form method="post" action="<?php echo esc_url( admin_url( 'admin-post.php' ) ); ?>">
    	    <input type="hidden" name="action" value="HTMegaPro_el_activate_license"/>
    	    <div class="el-license-container">
    		    <h3 class="el-license-title"><i class="dashicons-before dashicons-star-filled"></i> <?php echo esc_html__("HT Mega Pro Licensing",'htmega-pro');?></h3>
    		    <hr>
                <?php
                if(!empty($this->showMessage) && !empty($this->licenseMessage)){
                    ?>
                    <div class="notice notice-error is-dismissible">
                        <p><?php echo esc_html( $this->licenseMessage); ?></p>
                    </div>
                    <?php
                }
                ?>
    		    <p><?php echo esc_html__("Enter your license key here, to activate the product, and get full feature updates and htmega support.",'htmega-pro');?></p>
    		    <div class="el-license-field">
    			    <label for="el_license_key"><?php echo esc_html__("License code",'htmega-pro');?></label>
    			    <input type="text" class="regular-text code" name="el_license_key" size="50" placeholder="xxxxxxxx-xxxxxxxx-xxxxxxxx-xxxxxxxx" required="required">
    		    </div>
                <div class="el-license-field">
                    <label for="el_license_key"><?php echo esc_html__("Email Address",'htmega-pro');?></label>
                    <?php
                        $purchaseEmail   = get_option( "HTMegaPro_lic_email", get_bloginfo( 'admin_email' ));
                    ?>
                    <input type="text" class="regular-text code" name="el_license_email" size="50" value="<?php echo esc_attr( $purchaseEmail ); ?>" placeholder="" required="required">
                    <div><small><?php echo esc_html__("We will send update news of this product by this email address, don't worry, we hate spam",'htmega-pro');?></small></div>
                </div>
    		    <div class="el-license-active-btn">
    			    <?php wp_nonce_field( 'el-license' ); ?>
    			    <?php submit_button('Activate'); ?>
    		    </div>
    	    </div>
        </form>
    	    <?php
        }
    }

    new HTMegaPro();