<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\HTMega_Icon_manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Advanced_Slider_Element extends Widget_Base {
    public function get_name() {
        return 'htmega-advanced-slider-addons';
    }
    
    public function get_title() {
        return __( 'Advanced Slider', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-post-slider';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }

    public function get_script_depends() {
        return [ 'slick' ];
    }

    public function get_style_depends() {
        return ['slick' ];
    }

    public function get_keywords() {
        return [ 'htmega', 'ht mega', 'slider', 'advanced slider', 'content slider', 'htmega pro' ];
    }
    
    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/';
	}

    protected function register_controls() {

        // Content
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Slides', 'htmega-pro' ),
            ]
        );
        $repeater = new Repeater();

            $repeater->add_control(
                'content_type',
                [
                    'label' => esc_html__( 'Content Type', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'custom',
                    'options' => [
                        'custom'   => esc_html__( 'Custom', 'htmega-pro' ),
                        'template'   => esc_html__( 'Elementor Template', 'htmega-pro' ),
                    ],
                ]
            );

            $repeater->add_control(
                'live_temp_content',
                array(
                    'label'       => __( 'Template Title', 'htmega-pro' ),
                    'type'        => Controls_Manager::TEXT,
                    'classes'     => 'htmega-live-temp-title control-hidden',
                    'label_block' => true,
                    'condition' => [
                        'content_type' => [ 'template' ],
                    ],
                )
            );
            $repeater->add_control(
                'content_temp_live',
                array(
                    'type'        => Controls_Manager::BUTTON,
                    'label_block' => true,
                    'button_type' => 'default htmega-editor-block-btn',
                    'text'        => __( 'Create / Edit Template', 'htmega-pro' ),
                    'event'       => 'createTempEvent',
                    'condition' => [
                        'content_type' => [ 'template' ],
                    ],
                ),
            );

            $repeater->add_control(
                'content_temp',
                [
                    'label' => esc_html__( 'Select Template', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'custom',
                    'options' => htmega_elementor_template(),
                    'condition' => [
                        'content_type' => [ 'template' ],
                    ],
                ]
            );
            $repeater->start_controls_tabs( 'custom_slide_tabs');

            $repeater->start_controls_tab(
                'custom_slide_background_tab',
                    [
                        'label' => __('Background', 'htmega-pro'),
                        'condition' => [
                            'content_type' => [ 'custom' ],
                        ],
                    ]
                );
                $repeater->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'slimage',
                        'label' => __( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}.htmega-advns-slider-item',
                        'condition' => [
                            'content_type' => [ 'custom' ],
                        ],
                    ]
                );
                $repeater->add_control(
                    'slider_overlay_color',
                    [
                        'label' => __( 'Slide Overlay Color', 'htmega' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => 'rgba(0,0,0,0.0)',
                        'selectors' => [
                            '{{WRAPPER}} {{CURRENT_ITEM}}.htmega-advns-slider-item::before' => 'background: {{VALUE}};',
                        ],
                        'condition' => [
                            'content_type' => [ 'custom' ],
                        ],
                    ]
                );
            $repeater->end_controls_tab();

            $repeater->start_controls_tab(
                    'custom_slide_content_tab',
                    [
                        'label' => __('Content', 'htmega-pro'),
                        'condition' => [
                            'content_type' => [ 'custom' ],
                        ],
                    ]
                );
                    $repeater->add_control(
                        'sltitle',
                        [
                            'label' => __( 'Title', 'htmega-pro' ),
                            'type' => Controls_Manager::TEXT,
                            'default' => '',
                            'title' => __( 'Slider Title', 'htmega-pro' ),
                            'label_block' => 'true',
                            'condition' => [
                                'content_type' => [ 'custom' ],
                            ],
                        ]
                    );             
                    $repeater->add_control(
                        'slsubtitle',
                        [
                            'label' => __( 'Subtitle', 'htmega-pro' ),
                            'type' => Controls_Manager::TEXT,
                            'default' => '',
                            'label_block' => 'true',
                            'title' => __( 'Slide Subtitle', 'htmega-pro' ),
                            'condition' => [
                                'content_type' => [ 'custom' ],
                            ],
                        ]
                    );
                    $repeater->add_control(
                        'slcontent',
                        [
                            'label' => __( 'Content', 'htmega-pro' ),
                            'type' => Controls_Manager::TEXTAREA,
                            'default' => '',
                            'label_block' => 'true',
                            'title' => __( 'Description', 'htmega-pro' ),
                            'condition' => [
                                'content_type' => [ 'custom' ],
                            ],
                        ]
                    );

                    $repeater->add_control(
                        'slbutton',
                        [
                            'label' => __( 'Button Text', 'htmega-pro' ),
                            'type' => Controls_Manager::TEXT,
                            'default' => 'Read More',
                            'condition' => [
                                'content_type' => [ 'custom' ],
                            ],
                        ]
                    );

                    $repeater->add_control(
                        'slbuttonlink',
                        [
                            'label' => __( 'Link', 'htmega-pro' ),
                            'type' => Controls_Manager::URL,
                            'placeholder' => __( 'https://example.com', 'htmega-pro' ),
                            'show_external' => true,
                            'default' => [
                                'url' => '',
                                'is_external' => true,
                                'nofollow' => true,
                            ],
                            'condition' => [
                                'content_type' => [ 'custom' ],
                            ],
                        ]
                    );
                    $repeater->add_control(
                        'slbutton2_show',
                        array(
                            'label'        => __( 'Button Two?', 'htmega-pro' ),
                            'type'         => Controls_Manager::SWITCHER,
                            'return_value' => 'yes',
                            'condition' => [
                                'content_type' => [ 'custom' ],
                            ],
                        )
                    );
                    $repeater->add_control(
                        'slbutton2',
                        [
                            'label' => __( 'Button Two Text', 'htmega-pro' ),
                            'type' => Controls_Manager::TEXT,
                            'default' => 'Download',
                            'condition'=>[
                                'slbutton2_show'=>'yes',
                                'content_type' => [ 'custom' ],
                            ]
                        ]
                    );

                    $repeater->add_control(
                        'slbuttonlink2',
                        [
                            'label' => __( 'Button Two Link', 'htmega-pro' ),
                            'type' => Controls_Manager::URL,
                            'placeholder' => __( 'https://example.com', 'htmega-pro' ),
                            'show_external' => true,
                            'default' => [
                                'url' => '',
                                'is_external' => true,
                                'nofollow' => true,
                            ],
                            'condition'=>[
                                'content_type' => [ 'custom' ],
                                'slbutton2_show'=>'yes'
                            ]
                        ]
                    );

                $repeater->end_controls_tab();
                $repeater->start_controls_tab(
                        'custom_slide_style_tab',
                        [
                            'label' => __('Style', 'htmega-pro'),
                            'condition' => [
                                'content_type' => [ 'custom' ],
                            ],
                        ]
                    );
                    $repeater->add_control(
                        'custom_style',
                        array(
                            'label'        => __( 'Custom Style', 'htmega-pro' ),
                            'type'         => Controls_Manager::SWITCHER,
                            'return_value' => 'yes',
                            'condition' => [
                                'content_type' => [ 'custom' ],
                            ],
                        )
                    );

                    $repeater->add_responsive_control(
                        'Slide_Content_Wrapper_Width_each',
                        [
                            'label' => esc_html__( 'Content Box Width', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'range' => [
                                '%' => [
                                    'min' => 20,
                                    'max' => 100,
                                ],
                                'px' => [
                                    'min' => 200,
                                    'max' => 1500,
                                ],
                            ],
                            'size_units' => [ '%', 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-content' => 'max-width: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' =>[
                                'custom_style'=>'yes',
                            ]
                        ]
                    );  
            
                    $repeater->add_responsive_control(
                        'Slide_Content_Wrapper_HR_Pos_each',
                        [
                            'label' => esc_html__( 'Horizontal Position', 'htmega-pro' ),
                            'type' => Controls_Manager::CHOOSE,
                            'label_block' => false,
                            'options' => [
                                'left' => [
                                    'title' => esc_html__( 'Left', 'htmega-pro' ),
                                    'icon' => 'eicon-h-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Center', 'htmega-pro' ),
                                    'icon' => 'eicon-h-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__( 'Right', 'htmega-pro' ),
                                    'icon' => 'eicon-h-align-right',
                                ]
                            ],
        
                            'selectors' => [
                                '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-content-wrapper' => 'justify-content:{{VALUE}};',
                            ],
                            'condition' =>[
                                'custom_style'=>'yes',
                            ]
                        ]
                    );
            
                    $repeater->add_responsive_control(
                        'Slide_Content_Wrapper_BR_Pos_each',
                        [
                            'label' => esc_html__( 'Vertical Position', 'htmega-pro' ),
                            'type' => Controls_Manager::CHOOSE,
                            'label_block' => false,
                            'options' => [
                                'start' => [
                                    'title' => esc_html__( 'Top', 'htmega-pro' ),
                                    'icon' => 'eicon-v-align-top',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Middle', 'htmega-pro' ),
                                    'icon' => 'eicon-v-align-middle',
                                ],
                                'end' => [
                                    'title' => esc_html__( 'Bottom', 'htmega-pro' ),
                                    'icon' => 'eicon-v-align-bottom',
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-content-wrapper' => 'align-items: {{VALUE}};',
                            ],
                            'condition' =>[
                                'custom_style'=>'yes',
                            ]
                        ]
                    );
            
                    $repeater->add_responsive_control(
                        'Slide_Content_Wrapper_Alignment_each',
                        [
                            'label' => esc_html__( 'Text Alignment', 'htmega-pro' ),
                            'type' => Controls_Manager::CHOOSE,
                            'label_block' => false,
                            'options' => [
                                'left' => [
                                    'title' => esc_html__( 'Left', 'htmega-pro' ),
                                    'icon' => 'eicon-text-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Center', 'htmega-pro' ),
                                    'icon' => 'eicon-text-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__( 'Right', 'htmega-pro' ),
                                    'icon' => 'eicon-text-align-right',
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-content' => 'text-align: {{VALUE}};',
                            ],
                            'condition' =>[
                                'custom_style'=>'yes',
                            ]
                        ]
                    );
                    $repeater->add_control(
                        'Slide_Content_Wrapper_BG_color_each',
                        [
                            'label' => esc_html__( 'Background Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-content' => 'background-color: {{VALUE}};',
                            ],
                            'condition' =>[
                                'custom_style'=>'yes',
                            ]
                        ]
                    );
                    $repeater->add_responsive_control(
                        'slider_content_padding_each',
                        [
                            'label' => esc_html__( 'Padding', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%' ],
                            'selectors' => [
                                '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'after',
                            'condition' =>[
                                'custom_style'=>'yes',
                            ]
                        ]
                    );

                    $repeater->add_control(
                        'title_color_each',
                        [
                            'label' => __( 'Title color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-content .htmega-sltitle' => 'color: {{VALUE}};',
                            ],
                            'condition' =>[
                                'custom_style'=>'yes',
                                'sltitle!'=>'',
                            ]
                        ]
                    );
                    $repeater->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'Title_typography_each',
                            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-content .htmega-sltitle',
                            'condition' =>[
                                'custom_style'=>'yes',
                                'sltitle!'=>'',
                            ],
                            
                        ]
                    ); 
                    $repeater->add_control(
                        'subtitle_color_each',
                        [
                            'label' => __( 'Sub Title color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-content .htmega-slsubtitle' => 'color: {{VALUE}};',
                            ],
                            'condition' =>[
                                'custom_style'=>'yes',
                                'slsubtitle!'=>'',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $repeater->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'SubTitle_typography_each',
                            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-content .htmega-slsubtitle',
                            'condition' =>[
                                'custom_style'=>'yes',
                                'slsubtitle!'=>'',
                            ],
                            'separator' => 'after',
                        ]
                    ); 
                    $repeater->add_control(
                        'content_color_each',
                        [
                            'label' => __( 'Content color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-content p' => 'color: {{VALUE}};',
                            ],
                            'condition' =>[
                                'custom_style'=>'yes',
                                'slcontent!'=>'',
                            ],
                           
                        ]
                    );
                    $repeater->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'Content_typography_each',
                            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-content p',
                            'condition' =>[
                                'custom_style'=>'yes',
                                'slcontent!'=>'',
                            ],
                            'separator' => 'before',
                        ]
                    ); 
                    $repeater->add_control(
                        'slbtn_color_each',
                        [
                            'label' => __( 'Primary Button color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-btn a' => 'color: {{VALUE}};',
                            ],
                            'condition' =>[
                                'custom_style'=>'yes',
                                'slbutton!'=>'',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $repeater->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'readmore_background_each',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-btn a',
                            'condition' =>[
                                'custom_style'=>'yes',
                                'slbutton!'=>'',
                            ]
                        ]
                    );
                    $repeater->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'readmore_border_each',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-btn a',
                            'condition' =>[
                                'custom_style'=>'yes',
                                'slbutton!'=>'',
                            ]
                        ]
                    );
                    $repeater->add_control(
                        'slbtn_color_each_hover',
                        [
                            'label' => __( 'Primary Button Hover color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-btn a:hover' => 'color: {{VALUE}};',
                            ],
                            'condition' =>[
                                'custom_style'=>'yes',
                                'slbutton!'=>'',
                            ]
                        ]
                    );
                    $repeater->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'readmore_background_each_hover',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-btn a:hover',
                            'condition' =>[
                                'custom_style'=>'yes',
                                'slbutton!'=>'',
                            ]
                        ]
                    );
                    $repeater->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'readmore_border_each_hover',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-btn a:hover',
                            'condition' =>[
                                'custom_style'=>'yes',
                                'slbutton!'=>'',
                            ],
                        ]
                    );
                    $repeater->add_control(
                        'slbtn_color_each2',
                        [
                            'label' => __( 'Secondary Button color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-btn a.htmega-slide-button2' => 'color: {{VALUE}};',
                            ],
                            'condition' =>[
                                'custom_style'=>'yes',
                                'slbutton2!'=>'',
                                'slbutton2_show'=>'yes',
                            ],
                            'separator' => 'before',
                        ]
                    );
                    $repeater->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'readmore_background_each2',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-btn a.htmega-slide-button2',
                            'condition' =>[
                                'custom_style'=>'yes',
                                'slbutton2!'=>'',
                                'slbutton2_show'=>'yes',
                            ]
                        ]
                    );
                    $repeater->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'readmore_border_each2',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-btn a.htmega-slide-button2',
                            'condition' =>[
                                'custom_style'=>'yes',
                                'slbutton2!'=>'',
                                'slbutton2_show'=>'yes',
                            ]
                        ]
                    );
                    $repeater->add_control(
                        'slbtn_color_each_hover2',
                        [
                            'label' => __( 'Primary Button Hover color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-btn a.htmega-slide-button2:hover' => 'color: {{VALUE}};',
                            ],
                            'condition' =>[
                                'custom_style'=>'yes',
                                'slbutton2!'=>'',
                                'slbutton2_show'=>'yes',
                            ]
                        ]
                    );
                    $repeater->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'readmore_background_each_hover2',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-btn a.htmega-slide-button2:hover',
                            'condition' =>[
                                'custom_style'=>'yes',
                                'slbutton2!'=>'',
                                'slbutton2_show'=>'yes',
                            ]
                        ]
                    );
                    $repeater->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'readmore_border_each_hover2',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-btn a.htmega-slide-button2:hover',
                            'condition' =>[
                                'custom_style'=>'yes',
                                'slbutton2!'=>'',
                                'slbutton2_show'=>'yes',
                            ],
                        ]
                    );

                    $repeater->add_control(
                        'Slide_Content_Animation_each',
                        [
                            'label' => __('Content Animation', 'htmega-pro'),
                            'type' => Controls_Manager::SELECT,
                            'default' => 'fadeInUp',
                            'options' => [
                                'none'  => __('None', 'htmega-pro'),
                                'fadeInUp'  => __('FadeInUp', 'htmega-pro'),
                                'fadeInDown' => __('FadeInDown', 'htmega-pro'),
                                'fadeInLeft' => __('FadeInLeft', 'htmega-pro'),
                                'fadeInRight' => __('FadeInRight', 'htmega-pro'),
                                'zoomIn' => __('ZoomIn', 'htmega-pro'),
                                'rollIn' => __('RollIn', 'htmega-pro'),
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .slick-active {{CURRENT_ITEM}} .htmega-advns-slide-content' => '
                                -webkit-animation-name: {{VALUE}};
                                animation-name:{{VALUE}};'
                            ],
                            'condition' =>[
                                'custom_style'=>'yes',
                            ],
                            'separator' =>'before'
                        ]
                    );
                    $repeater->add_control(
                        'Animation_hidden_filed_each',
                        [
                            'label' => __('Animation hidden filed', 'htmega-pro'),
                            'type' => Controls_Manager::SWITCHER ,
                            'selectors' => [
                                '{{WRAPPER}} {{CURRENT_ITEM}} .htmega-advns-slide-content' => 'opacity:1;',
                            ],
                            'classes'     => 'htmega-control-hidden',
                            'default'=>'yes',
                            'condition' => [
                                'Slide_Content_Animation_each' => 'none',
                            ],
            
                        ]
                    );

                $repeater->end_controls_tab();

            $repeater->end_controls_tabs();

            $this->add_control(
                'slide_lists',
                [
                    'label' => esc_html__( 'Slides', 'htmega-pro' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'default' => [
                        [
                            'sltitle' => esc_html__( 'HT Mega Slide Title', 'htmega-pro' ),
                            'slsubtitle' => esc_html__( 'Welcome To HTMega', 'htmega-pro' ),
                            'slcontent' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer auctor pharetra iss neque. Nullam cursus elit sit amet justo interdum facilisis id at tortor', 'htmega-pro' ),
                            'slider_overlay_color' =>'#6f8053'
                        ],
                        [
                            'sltitle' => esc_html__( 'HT Mega Slide Title2', 'htmega-pro' ),
                            'slsubtitle' => esc_html__( 'Welcome To HT Mega', 'htmega-pro' ),
                            'slcontent' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer auctor pharetra iss neque. Nullam cursus elit sit amet justo interdum facilisis id at tortor', 'htmega-pro' ),
                            'slider_overlay_color' =>'#7f7f7f'
                        ],
                        [
                            'sltitle' => esc_html__( 'HT Mega Slide Title3', 'htmega-pro' ),
                            'slsubtitle' => esc_html__( 'Welcome To HT Mega', 'htmega-pro' ),
                            'slcontent' => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer auctor pharetra iss neque. Nullam cursus elit sit amet justo interdum facilisis id at tortor', 'htmega-pro' ),
                            'slider_overlay_color' =>'#61b0ce'
                        ],
                    ],
                ]
            );


        $this->end_controls_section();
        // Slider Option
        $this->start_controls_section(
            'slider_option_setting',
                [
                    'label' => esc_html__( 'Slider Settings', 'htmega-pro' ),
                ]
            );
            $this->add_responsive_control(
                'slitems',
                [
                    'label' => esc_html__( 'Slide Items', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 1,
                    'max' => 10,
                    'step' => 1,
                    'default' => 1,
                    'separator' =>'before'
                ]
            );
            $this->add_responsive_control(
                'slscroll_columns',
                [
                    'label' => __('Slide Item to Scroll', 'htmega-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 1,
                    'max' => 10,
                    'step' => 1,
                    'default' => 1,
                    'condition' =>[
                        'slitems!' => 1
                    ]
                ]
            );
            $this->add_responsive_control(
                'gird_gutter',
                [
                    'label' => __('Column Gap', 'htmega-pro'),
                    'description' => __('This Column gap value shows in multiplying 2', 'htmega-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 10,
                    'selectors' => [
                        '{{WRAPPER}} .slick-slide' => 'padding-left: {{SIZE}}px; padding-right: {{SIZE}}px;',
                        '{{WRAPPER}} .slick-list' => 'margin-left: -{{SIZE}}px; margin-right: -{{SIZE}}px;',
                    ],
                    'condition' =>[
                        'slitems!' => 1
                    ]
                ]
            );            
            $this->add_control(
                'slider_resolution_toggle',
                [
                    'type' =>Controls_Manager::POPOVER_TOGGLE,
                    'label' => esc_html__( 'Responsive Breakpoints', 'htmega-pro' ),
                    'label_off' => esc_html__( 'Default', 'htmega-pro' ),
                    'label_on' => esc_html__( 'Custom', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'condition' =>[
                        'slitems!' => 1
                    ]
                ]
            );
        
            $this->start_popover();
            
                $this->add_control(
                    'tablet_width',
                    [
                        'label' => __('Tablet Breakpoints', 'htmega-pro'),
                        'description' => __('The resolution to tablet device.', 'htmega-pro'),
                        'type' => Controls_Manager::NUMBER,
                        'default' => 991,
                        'separator' => 'after',
                    ]
                );

                $this->add_control(
                    'mobile_width',
                    [
                        'label' => __('Mobile Breakpoints', 'htmega-pro'),
                        'description' => __('The resolution to mobile device.', 'htmega-pro'),
                        'type' => Controls_Manager::NUMBER,
                        'default' => 575,
                    ]
                );
            $this->end_popover();
            $this->add_control(
                'slide_effect',
                [
                    'type' => Controls_Manager::SELECT,
                    'label' => esc_html__( 'Slide Effect', 'htmega-pro' ),
                    'default' => 'fade',
                    'options' => [
                        'slide' => esc_html__( 'Slide', 'htmega-pro' ),
                        'fade' => esc_html__( 'Fade', 'htmega-pro' ),
                    ],
                    'separator' => 'before'
                ]
            );
            $this->add_control(
                    'sl_loop',
                    [
                        'label' => esc_html__( 'Loop', 'htmega-pro' ),
                        'type' => Controls_Manager::SWITCHER,
                        'return_value' => 'yes',
                        'default' => 'yes',
                    ]
                );
                $this->add_control(
                    'slautoplay',
                    [
                        'label' => esc_html__( 'Autoplay', 'htmega-pro' ),
                        'type' => Controls_Manager::SWITCHER,
                        'return_value' => 'yes',
                        'default' => 'yes',
                    ]
                );
                $this->add_control(
                    'slautoplayspeed',
                    [
                        'label' => __( 'Autoplay Speed', 'htmega-pro' ),
                        'type' => Controls_Manager::NUMBER,
                        'min' => 5,
                        'min' => 200,
                        'step' => 100,
                        'default' => 5000,
                        'condition' => [
                            'slautoplay' => 'yes',
                        ]
                    ]
                );
                $this->add_control(
                    'slanimation_speed',
                    [
                        'label' => __( 'Slide Speed', 'htmega-pro' ),
                        'type' => Controls_Manager::NUMBER,
                        'min' => 5,
                        'max' => 5000,
                        'step' => 100,
                        'default' => 1000,
                    ]
                );
                $this->add_control(
                    'slcentermode',
                    [
                        'label' => esc_html__( 'Center Mode', 'htmega-pro' ),
                        'type' => Controls_Manager::SWITCHER,
                        'return_value' => 'yes',
                        'default' => 'no',
                    ]
                );
    
                $this->add_control(
                    'slcenterpadding',
                    [
                        'label' => esc_html__( 'Center padding', 'htmega-pro' ),
                        'type' => Controls_Manager::NUMBER,
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                        'default' => 0,
                        'condition' =>[
                            'slcentermode' => 'yes'
                        ]
                    ]
                );
                $this->add_control(
                    'variable_width',
                    [
                        'label' => esc_html__( 'Variable Width', 'htmega-pro' ),
                        'type' => Controls_Manager::SWITCHER,
                        'description' => __('Column width according to Content', 'htmega-pro'),
                        'return_value' => 'yes',
                        'default' => 'no',
                        
                    ]
                );
                
                $this->add_control(
                    'vertical',
                    [
                        'label' => esc_html__( 'Vertical Mode', 'htmega-pro' ),
                        'type' => Controls_Manager::SWITCHER,
                        'description' => __('On this Switcher to Verticle Slide', 'htmega-pro'),
                        'return_value' => 'yes',
                        'default' => 'no',
                        'condition' => [
                            'slide_effect' => 'slide'
                        ] 
                        
                    ]
                );

                $this->add_control(
                    'slarrows',
                    [
                        'label' => esc_html__( 'Navigation', 'htmega-pro' ),
                        'type' => Controls_Manager::SWITCHER,
                        'return_value' => 'yes',
                        'default' => 'yes',
                        'separator' =>'before',
                    ]
                );
                $this->add_control(
                    'arrow_style',
                    [
                        'label' => esc_html__( 'Navigation Styles', 'htmega-pro' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'arrow_st1',
                        'options' => [
                            'arrow_st1' => esc_html__( 'Style One', 'htmega-pro' ),
                            'arrow_st2' => esc_html__( 'Style Two', 'htmega-pro' ),
                            'arrow_st3' => esc_html__( 'Style Three', 'htmega-pro' ),
                        ],
                        'condition' => [
                            'slarrows' => 'yes',
                        ]                    
                    ]
                );
                $this->add_control(
                    'arrow_position_st1',
                    [
                        'label' => esc_html__( 'Show In', 'htmega-pro' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'arrow_st1_middle',
                        'options' => [
                            'arrow_st1_top' => esc_html__( 'Top', 'htmega-pro' ),
                            'arrow_st1_middle' => esc_html__( 'Middle', 'htmega-pro' ),
                            'arrow_st1_bottom' => esc_html__( 'Bottom', 'htmega-pro' ),
                        ],
                        'condition' => [
                            'slarrows' => 'yes',
                            'arrow_style' => 'arrow_st1',
                        ]                    
                    ]
                );
                $this->add_control(
                    'arrow_position_st2',
                    [
                        'label' => esc_html__( 'Show In', 'htmega-pro' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'arrow_st2_bottom_right',
                        'options' => [
                            'arrow_st2_top_right' => esc_html__( 'Top Right', 'htmega-pro' ),
                            'arrow_st2_top_center' => esc_html__( 'Top Center', 'htmega-pro' ),
                            'arrow_st2_top_left' => esc_html__( 'Top Left', 'htmega-pro' ),
                            'arrow_st2_bottom_right' => esc_html__( 'Bottom Right', 'htmega-pro' ),
                            'arrow_st2_bottom_center' => esc_html__( 'Bottom Center', 'htmega-pro' ),
                            'arrow_st2_bottom_left' => esc_html__( 'Bottom Left', 'htmega-pro' ),
                        ],
                        'condition' => [
                            'slarrows' => 'yes',
                            'arrow_style' => 'arrow_st2',
                        ]                    
                    ]
                );
                $this->add_control(
                    'arrow_position_st3',
                    [
                        'label' => esc_html__( 'Show In', 'htmega-pro' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'arrow_st3_right',
                        'options' => [
                            'arrow_st3_right' => esc_html__( 'Right', 'htmega-pro' ),
                            'arrow_st3_left' => esc_html__( 'Left', 'htmega-pro' ),
                        ],
                        'condition' => [
                            'slarrows' => 'yes',
                            'arrow_style' => 'arrow_st3',
                        ]                    
                    ]
                );


            $this->add_control(
                    'slarrows_type',
                    [
                        'label' => esc_html__( 'Select Icon Type', 'htmega-pro' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'icon',
                        'options' => [
                            'icon' => esc_html__( 'Icon', 'htmega-pro' ),
                            'image' => esc_html__( 'Image', 'htmega-pro' ),
                            'text' => esc_html__( 'Text', 'htmega-pro' ),
                        ],
                        'condition' => [
                            'slarrows' => 'yes',
                        ]                    
                    ]
                );

                $this->add_control(
                    'slarrows_iamge_next',
                    [
                        'label' => __( 'Icon Image Next', 'htmega-pro' ),
                        'type' => Controls_Manager::MEDIA,
                        'default' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                        'condition' => [
                            'slarrows' => 'yes',
                            'slarrows_type' => 'image',
                        ]
                    ]
                );
                $this->add_control(
                    'slarrows_iamge_prev',
                    [
                        'label' => __( 'Icon Image Prev', 'htmega-pro' ),
                        'type' => Controls_Manager::MEDIA,
                        'default' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                        'condition' => [
                            'slarrows' => 'yes',
                            'slarrows_type' => 'image',
                        ]
                    ]
                );


                $this->add_control(
                    'slarrowsicon_font_next_nav',
                    [
                        'label' => __( 'Icon Next', 'htmega-pro' ),
                        'type' => Controls_Manager::TEXT,
                        'default' =>'NEXT',
                        'condition' => [
                            'slarrows' => 'yes',
                            'slarrows_type' => 'text',
                        ],
                    ]
                );
                $this->add_control(
                    'slarrowsicon_font_prev_nav',
                    [
                        'label' => __( 'Icon Prev', 'htmega-pro' ),
                        'type' => Controls_Manager::TEXT,
                        'default' =>'PREV',
                        'condition' => [
                            'slarrows' => 'yes',
                            'slarrows_type' => 'text',
                        ],
                    ]
                );

                $this->add_control(
                    'slarrowsicon_font_next',
                    [
                        'label' => __( 'Icon Next', 'htmega-pro' ),
                        'type' => Controls_Manager::ICONS,
                        'default' => [
                            'value' => 'fas fa-angle-right',
                            'library' => 'fa-solid',
                        ],
                        'condition' => [
                            'slarrows' => 'yes',
                            'slarrows_type' => 'icon',
                        ],
                    ]
                );

                $this->add_control(
                    'slarrowsicon_font_prev',
                    [
                        'label' => __( 'Icon Prev', 'htmega-pro' ),
                        'type' => Controls_Manager::ICONS,
                        'default' => [
                            'value' => 'fas fa-angle-left',
                            'library' => 'fa-solid',
                        ],
                        'condition' => [
                            'slarrows' => 'yes',
                            'slarrows_type' => 'icon',
                        ],
                    ]
                );
                $this->add_control(
                    'sldots',
                    [
                        'label' => esc_html__( 'Dots', 'htmega-pro' ),
                        'type' => Controls_Manager::SWITCHER,
                        'return_value' => 'yes',
                        'default' => 'no',
                        'separator' =>'before',
                    ]
                );
                $this->add_control(
                    'dot_show_position',
                    [
                        'label' => esc_html__( 'Dots Show In', 'htmega-pro' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'dot_bottom_center',
                        'options' => [
                            'dot_bottom_center' => esc_html__( 'Bottom Center', 'htmega-pro' ),
                            'dot_bottom_left' => esc_html__( 'Bottom Left', 'htmega-pro' ),
                            'dot_bottom_right' => esc_html__( 'Bottom Right', 'htmega-pro' ),
                            'dot_right_center' => esc_html__( 'Right Center', 'htmega-pro' ),
                            'dot_left_center' => esc_html__( 'Left Center', 'htmega-pro' ),
                        ],
                        'condition' => [
                            'sldots' => 'yes',
                        ]                    
                    ]
                );
                $this->add_control(
                    'dots_index',
                    [
                        'label' => esc_html__( 'Show Dots Index', 'htmega-pro' ),
                        'type' => Controls_Manager::SWITCHER,
                        'return_value' => 'yes',
                        'default' => 'no',
                        'condition' => [
                            'sldots' => 'yes',
                        ]  
                    ]
                );
        $this->end_controls_section();
        // Additional Settions 
        $this->start_controls_section(
            'Additional_Settings',
            [
                'label' => esc_html__( 'Additional Settings', 'htmega-pro' ),
            ]
            );
            $this->add_responsive_control(
                'Slider_Height',
                [
                    'label' => __('Slider Height', 'htmega-pro'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', 'vh','%'],
                    'range' => [
                        'px' => [
                            'min' => 5,
                            'max' => 3000,
                            'step' => 5,
                        ],
                        'vh' => [
                            'min' => 1,
                            'max' => 100,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ],
                    ],
                    'default' => [
                        'size' => 580,
                        'unit' => 'px',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .slick-slide' => 'height: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .slick-slide > div' => 'height: 100%',
                        '{{WRAPPER}} .htmega-slick-center-yes .slick-slide > div' => 'height: auto',
                    ],
                ]
            );
            $this->add_control(
                'title_tag',
                [
                    'label' => __('Title Tag', 'htmega-pro'),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'h1',
                    'options' => [
                        'h1' => __('H1', 'htmega-pro'),
                        'h2' => __('H2', 'htmega-pro'),
                        'h3' => __('H3', 'htmega-pro'),
                        'h4' => __('H4', 'htmega-pro'),
                        'h5' => __('H5', 'htmega-pro'),
                        'h6' => __('H6', 'htmega-pro'),
                        'span' => __('Span', 'htmega-pro'),
                        'p' => __('P', 'htmega-pro'),
                        'div' => __('Div', 'htmega-pro'),
                    ],
                ]
            );
            $this->add_control(
                'sub_title_tag',
                [
                    'label' => __('Sub Title Tag', 'htmega-pro'),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'h4',
                    'options' => [
                        'h1' => __('H1', 'htmega-pro'),
                        'h2' => __('H2', 'htmega-pro'),
                        'h3' => __('H3', 'htmega-pro'),
                        'h4' => __('H4', 'htmega-pro'),
                        'h5' => __('H5', 'htmega-pro'),
                        'h6' => __('H6', 'htmega-pro'),
                        'span' => __('Span', 'htmega-pro'),
                        'p' => __('P', 'htmega-pro'),
                        'div' => __('Div', 'htmega-pro'),
                    ],
                    'separator' =>'after'
                ]
            );
            $this->add_control(
                'Slide_Content_Animation',
                [
                    'label' => __('Content Animation', 'htmega-pro'),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'fadeInUp',
                    'options' => [
                        'none'  => __('None', 'htmega-pro'),
                        'fadeInUp'  => __('FadeInUp', 'htmega-pro'),
                        'fadeInDown' => __('FadeInDown', 'htmega-pro'),
                        'fadeInLeft' => __('FadeInLeft', 'htmega-pro'),
                        'fadeInRight' => __('FadeInRight', 'htmega-pro'),
                        'zoomIn' => __('ZoomIn', 'htmega-pro'),
                        'rollIn' => __('RollIn', 'htmega-pro'),
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .slick-active .htmega-advns-slide-content' => '
                        -webkit-animation-name: {{VALUE}};
                        animation-name:{{VALUE}};'
                    ],
                ]
            );

            $this->add_control(
                'Animation_hidden_filed',
                [
                    'label' => __('Animation hidden filed', 'htmega-pro'),
                    'type' => Controls_Manager::SWITCHER ,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-advns-slide-content' => 'opacity:1;',
                    ],
                    'classes'     => 'htmega-control-hidden',
                    'default'=>'yes',
                    'condition' => [
                        'Slide_Content_Animation' => 'none',
                    ],

                ]
            );
            $this->add_control(
                'Slide_Content_animation_speed',
                [
                    'label' => __('Animation Speed (ms)', 'htmega-pro'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['ms'],
                    'range' => [
                        'ms' => [
                            'min' => 100,
                            'max' => 5000,
                            'step' => 50,
                        ],
                    ],
                    'default' => [
                        'unit' => 'ms',
                        'size' => 1000,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-advns-slide-content' => '
                        -webkit-animation-duration: {{SIZE}}{{UNIT}};
                        animation-duration: {{SIZE}}{{UNIT}};',
                    ],
                    'description' => __('Slide speed in milliseconds', 'htmega-pro'),
                    'condition' => [
                        'Slide_Content_Animation!' => 'none',
                    ],

                ]
            );
            $this->add_control(
                'Animation_delay',
                [
                    'label' => __('Animation Delay (ms)', 'htmega-pro'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['ms'],
                    'range' => [
                        'ms' => [
                            'min' => 100,
                            'max' => 5000,
                            'step' => 50,
                        ],
                    ],
                    'default' => [
                        'unit' => 'ms',
                        'size' => 700,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-advns-slide-content' => '
                        -webkit-animation-delay: {{SIZE}}{{UNIT}};
                        animation-delay: {{SIZE}}{{UNIT}};',
                    ],
                    'description' => __('Slide speed in miliseconds', 'htmega-pro'),
                    'condition' => [
                        'Slide_Content_Animation!' => 'none',
                    ],

                ]
            );

        $this->end_controls_section();
        // Style
        $this->start_controls_section(
            'Slide_Content_Wrapper',
                array(
                    'label' => __( 'Content Wrapper', 'htmega-pro' ),
                    'tab' => Controls_Manager::TAB_STYLE,
                )
            );
            $this->add_responsive_control(
                'Slide_Content_Wrapper_container_Width',
                [
                    'label' => esc_html__( 'Container Width', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        '%' => [
                            'min' => 20,
                            'max' => 100,
                        ],
                        'px' => [
                            'min' => 200,
                            'max' => 1920,
                        ],
                    ],
                    'size_units' => [ '%', 'px' ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 1170,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-advns-slide-content-wrapper' => 'max-width: {{SIZE}}{{UNIT}};margin:auto',
                    ],
                ]
            );  
            $this->add_responsive_control(
                'Slide_Content_Wrapper_Width',
                [
                    'label' => esc_html__( 'Content Box Width', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        '%' => [
                            'min' => 20,
                            'max' => 100,
                        ],
                        'px' => [
                            'min' => 200,
                            'max' => 1500,
                        ],
                    ],
                    'size_units' => [ '%', 'px' ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 750,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-advns-slide-content' => 'max-width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );  
    
            $this->add_responsive_control(
                'Slide_Content_Wrapper_HR_Pos',
                [
                    'label' => esc_html__( 'Horizontal Position', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'label_block' => false,
                    'options' => [
                        'left' => [
                            'title' => esc_html__( 'Left', 'htmega-pro' ),
                            'icon' => 'eicon-h-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'htmega-pro' ),
                            'icon' => 'eicon-h-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'htmega-pro' ),
                            'icon' => 'eicon-h-align-right',
                        ]
                    ],
                    'default' => 'center',

                    'selectors' => [
                        '{{WRAPPER}} .htmega-advns-slide-content-wrapper' => 'justify-content:{{VALUE}};',
                    ],
                ]
            );
    
            $this->add_responsive_control(
                'Slide_Content_Wrapper_BR_Pos',
                [
                    'label' => esc_html__( 'Vertical Position', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'label_block' => false,
                    'default' => 'center',
                    'options' => [
                        'start' => [
                            'title' => esc_html__( 'Top', 'htmega-pro' ),
                            'icon' => 'eicon-v-align-top',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Middle', 'htmega-pro' ),
                            'icon' => 'eicon-v-align-middle',
                        ],
                        'end' => [
                            'title' => esc_html__( 'Bottom', 'htmega-pro' ),
                            'icon' => 'eicon-v-align-bottom',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-advns-slide-content-wrapper' => 'align-items: {{VALUE}};',
                    ],
                ]
            );
    
            $this->add_responsive_control(
                'Slide_Content_Wrapper_Alignment',
                [
                    'label' => esc_html__( 'Text Alignment', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'label_block' => false,
                    'default' => 'center',
                    'options' => [
                        'left' => [
                            'title' => esc_html__( 'Left', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-advns-slide-content' => 'text-align: {{VALUE}};',
                    ],
                ]
            );
            $this->add_control(
                'Slide_Content_Wrapper_BG_color',
                [
                    'label' => esc_html__( 'Background Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-advns-slide-content' => 'background-color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'slider_content_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'default' => [
                        'top' => 50,
                        'right' => 50,
                        'bottom' => 50,
                        'left' => 50,
                    ],
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-advns-slide-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();
        // Title Style 
        $this->start_controls_section(
            'Slide_Content_Wrapper_Title_Style',
            [
                'label' => esc_html__('Title Style', 'htmega-pro'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
            );
            
            $this->add_control(
                'Slide_Content_Title_color',
                [
                    'label' => esc_html__('Color', 'htmega-pro'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-advns-slide-content .htmega-sltitle' => 'color: {{VALUE}};',
                    ],

                ]
            );
            
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'Slide_Content_Title_typography',
                    'selector' => '{{WRAPPER}} .htmega-advns-slide-content .htmega-sltitle',
                ]
            );

            $this->add_responsive_control(
                'Slide_Content_Title_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-advns-slide-content .htmega-sltitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'Slide_Content_Title_hover_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-advns-slide-content .htmega-sltitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],                
                ]
            );
            
        $this->end_controls_section();
        // Sub Title Style 
        $this->start_controls_section(
            'Sub_Title_Style',
            [
                'label' => esc_html__('Sub Title Style', 'htmega-pro'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
            );
            
            $this->add_control(
                'Sub_Title_color',
                [
                    'label' => esc_html__('Color', 'htmega-pro'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-advns-slide-content .htmega-slsubtitle' => 'color: {{VALUE}};',
                    ],

                ]
            );
            
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'Sub_Title_typography',
                    'selector' => '{{WRAPPER}} .htmega-advns-slide-content .htmega-slsubtitle',
                ]
            );

            $this->add_responsive_control(
                'Sub_Title_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-advns-slide-content .htmega-slsubtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],                
                ]
            );
            
        $this->end_controls_section();
        // Content Title Style 
        $this->start_controls_section(
            'Description_Style',
            [
                'label' => esc_html__('Decription Style', 'htmega-pro'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
            );
            
            $this->add_control(
                'Description_color',
                [
                    'label' => esc_html__('Color', 'htmega-pro'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-advns-slide-content p' => 'color: {{VALUE}};',
                    ],

                ]
            );
            
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'Description_typography',
                    'selector' => '{{WRAPPER}} .htmega-advns-slide-content p',
                ]
            );

            $this->add_responsive_control(
                'Description_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-advns-slide-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],                
                ]
            );
            
        $this->end_controls_section();

       // Style Read More button tab section
       $this->start_controls_section(
            'readmore_style_section',
            [
                'label' => __( 'Primary Button Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
            );
            $this->start_controls_tabs('readmore_style_tabs');

                $this->start_controls_tab(
                    'readmore_style_normal_tab',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                    );

                    $this->add_control(
                        'readmore_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-advns-slide-btn a' => 'color: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'readmore_typography',
                            'label' => __( 'Typography', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-advns-slide-btn a',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'readmore_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-advns-slide-btn a',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'readmore_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-advns-slide-btn a',
                        ]
                    );

                    $this->add_responsive_control(
                        'readmore_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-advns-slide-btn a' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'readmore_padding',
                        [
                            'label' => __( 'Padding', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-advns-slide-btn a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'readmore_margin',
                        [
                            'label' => __( 'Margin', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-advns-slide-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                $this->end_controls_tab(); // Normal Tab end

                $this->start_controls_tab(
                    'readmore_style_hover_tab',
                    [
                        'label' => __( 'Hover', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'readmore_hover_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-advns-slide-btn a:hover' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'readmore_hover_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-advns-slide-btn a:hover',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'readmore_hover_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-advns-slide-btn a:hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'readmore_hover_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-advns-slide-btn a:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab(); // Hover Tab end

            $this->end_controls_tabs();

        $this->end_controls_section();
       // Style Read More button 2 tab section
       $this->start_controls_section(
            'readmore_style_section2',
            [
                'label' => __( 'Secondary Button Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
            );
            $this->start_controls_tabs('readmore_style_tabs2');

                $this->start_controls_tab(
                    'readmore_style_normal_tab2',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                    );

                    $this->add_control(
                        'readmore_color2',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-advns-slide-btn a.htmega-slide-button2' => 'color: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'readmore_typography2',
                            'label' => __( 'Typography', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-advns-slide-btn a.htmega-slide-button2',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'readmore_background2',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-advns-slide-btn a.htmega-slide-button2',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'readmore_border2',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-advns-slide-btn a.htmega-slide-button2',
                        ]
                    );

                    $this->add_responsive_control(
                        'readmore_border_radius2',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-advns-slide-btn a.htmega-slide-button2' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'readmore_padding2',
                        [
                            'label' => __( 'Padding', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-advns-slide-btn a.htmega-slide-button2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'readmore_margin2',
                        [
                            'label' => __( 'Margin', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-advns-slide-btn a.htmega-slide-button2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                $this->end_controls_tab(); // Normal Tab end

                $this->start_controls_tab(
                    'readmore_style_hover_tab2',
                    [
                        'label' => __( 'Hover', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'readmore_hover_color2',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-advns-slide-btn a.htmega-slide-button2:hover' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'readmore_hover_background2',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-advns-slide-btn a.htmega-slide-button2:hover',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'readmore_hover_border2',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-advns-slide-btn a.htmega-slide-button2:hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'readmore_hover_border_radius2',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-advns-slide-btn a.htmega-slide-button2:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab(); // Hover Tab end

            $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'htmega_carousel_arrow_style',
            [
                'label'     => __( 'Navigation', 'htmega-pro' ),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' =>[
                    'slarrows'  => 'yes',
                ],
            ]
            );
            
            $this->start_controls_tabs( 'carousel_arrow_style_tabs' );
    
                // Normal tab Start
                $this->start_controls_tab(
                    'carousel_arrow_style_normal_tab',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                );
    
                    $this->add_responsive_control(
                        'htmega_carousel_arrow_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '#ffffff',
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow svg path' => 'fill: {{VALUE}};',
                            ],
                        ]
                    );
    
                    $this->add_responsive_control(
                        'htmega_carousel_arrow_fontsize',
                        [
                            'label' => __( 'Font Size', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 100,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 32,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'font-size: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow svg' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
    
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'carousel_arrow_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow',
                            'default' => '#000000',
                        ]
                    );
    
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'htmega_carousel_arrow_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow',
                        ]
                    );
    
                    $this->add_responsive_control(
                        'htmega_carousel_arrow_border_radius',
                        [
                            'label' => __( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
    
                    $this->add_responsive_control(
                        'htmega_carousel_arrow_height',
                        [
                            'label' => __( 'Height', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 200,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 60,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
    
                    $this->add_responsive_control(
                        'htmega_carousel_arrow_width',
                        [
                            'label' => __( 'Width', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 200,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 60,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
    
                    $this->add_responsive_control(
                        'htmega_carousel_arrow_padding',
                        [
                            'label' => __( 'Padding', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' =>'before',
                        ]
                    );
    
                    $this->add_control(
                        'arrow_position_opover',
                        [
                            'type' =>Controls_Manager::POPOVER_TOGGLE,
                            'label' => esc_html__( 'Positions', 'htmega-pro' ),
                            'label_off' => esc_html__( 'Default', 'htmega-pro' ),
                            'label_on' => esc_html__( 'Custom', 'htmega-pro' ),
                            'return_value' => 'yes',
                        ]
                    );
                
                    $this->start_popover();
                    
                    $this->add_responsive_control(
                        'htmega_carousel_arrow_position',
                        [
                            'label' => __( 'Vertical Position', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => -1000,
                                    'max' => 1000,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => -100,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => '',
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'top: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-arrow_st1.htmega-arrow_st1_bottom button.slick-arrow,{{WRAPPER}} .htmega-arrow_st2.htmega-arrow_st2_bottom_center button.slick-arrow,{{WRAPPER}} .htmega-arrow_st2.htmega-arrow_st2_bottom_left button.slick-arrow,{{WRAPPER}} .htmega-arrow_st2.htmega-arrow_st2_bottom_right button.slick-arrow' => 'bottom: {{SIZE}}{{UNIT}};top:auto',
                            ],
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                    'terms' => [
                                           
                                            ['name' => 'arrow_style', 'operator' => '===', 'value' => 'arrow_st1'],
                                            ['name' => 'arrow_position_st1', 'operator' => '!==', 'value' => 'arrow_st1_middle']
                                        ]
                                    ],
                                    [
                                    'terms' => [
                                            ['name' => 'arrow_style', 'operator' => '===', 'value' => 'arrow_st2'],
                                            
                                        ]
                                    ],
                                ]
                            ],  
                        ]
                    );
    
                    $this->add_responsive_control(
                        'htmega_carousel_arrow_position_x',
                        [
                            'label' => __( 'Horizontal Position', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => -1000,
                                    'max' => 1000,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => -100,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => '',
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pro-carousel-activation .htmega-carosul-next.slick-arrow,.htmega-arrow_st3.htmega-arrow_st3_right button.htmega-carosul-prev.slick-arrow,{{WRAPPER}} .htmega-arrow_st3.htmega-arrow_st3_right button.htmega-carosul-prev.slick-arrow' => 'right: {{SIZE}}{{UNIT}};left:auto',
                                '{{WRAPPER}} .htmega-pro-carousel-activation .htmega-carosul-prev.slick-arrow,{{WRAPPER}} .htmega-arrow_st3.htmega-arrow_st3_left button.htmega-carosul-prev.slick-arrow,{{WRAPPER}} .htmega-arrow_st3.htmega-arrow_st3_left button.htmega-carosul-next' => 'left: {{SIZE}}{{UNIT}};right:auto',
                            ],
                            'condition' =>[
                                'arrow_style' => array('arrow_st1','arrow_st3'),
                            ]
                        ]
                    );

                    $this->add_responsive_control(
                        'prev_possition_h',
                        [
                            'label' => __( 'Prev Horizontal Position', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => -1000,
                                    'max' => 1000,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => -100,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => '',
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-arrow_st2 .htmega-carosul-prev.slick-arrow' => 'right: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-arrow_st2.htmega-arrow_st2_top_left .htmega-carosul-prev.slick-arrow,{{WRAPPER}} .htmega-arrow_st2.htmega-arrow_st2_bottom_left .htmega-carosul-prev.slick-arrow' => 'left: {{SIZE}}{{UNIT}}; right:auto;',
                            ],
                            'condition' =>[
                                'arrow_style!' => array('arrow_st1','arrow_st3'),
                                'arrow_position_st2!' => array('arrow_st2_top_center','arrow_st2_bottom_center'),
                            ]
                        ]
                    );

                    $this->add_responsive_control(
                        'next_possition_h',
                        [
                            'label' => __( 'Next Horizontal Position', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => -1000,
                                    'max' => 1000,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => -100,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => '',
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-arrow_st2 .htmega-carosul-next' => 'right: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-arrow_st2.htmega-arrow_st2_top_left button.htmega-carosul-next,{{WRAPPER}} .htmega-arrow_st2.htmega-arrow_st2_bottom_left button.htmega-carosul-next' => 'left: {{SIZE}}{{UNIT}};right:auto;',
                            ],
                            'condition' =>[
                                'arrow_style!' => array('arrow_st1','arrow_st3'),
                                'arrow_position_st2!' => array('arrow_st2_top_center','arrow_st2_bottom_center'),
                            ]
                        ]
                    );


                    $this->add_responsive_control(
                        'possition_h_inner_gap',
                        [
                            'label' => __( 'Innger Gap', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'description' => __('Default 60px','htmega-pro'),
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 200,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => '',
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-arrow_st2.htmega-arrow_st2_top_center .htmega-carosul-prev.slick-arrow,{{WRAPPER}} .htmega-arrow_st2.htmega-arrow_st2_bottom_center .htmega-carosul-prev.slick-arrow' => 'margin-left: -{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-arrow_st2.htmega-arrow_st2_top_center button.htmega-carosul-next,{{WRAPPER}} .htmega-arrow_st2.htmega-arrow_st2_bottom_center button.htmega-carosul-next' => 'margin-right: -{{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-arrow_st3.htmega-arrow_st3_left button.htmega-carosul-next,{{WRAPPER}} .htmega-arrow_st3.htmega-arrow_st3_right button.htmega-carosul-next' => 'margin-top: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-arrow_st3.htmega-arrow_st3_left button.htmega-carosul-prev.slick-arrow,{{WRAPPER}} .htmega-arrow_st3.htmega-arrow_st3_right button.htmega-carosul-prev.slick-arrow' => 'margin-top: -{{SIZE}}{{UNIT}};',
                            ],
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                    'terms' => [
                                           
                                            ['name' => 'arrow_style', 'operator' => '===', 'value' => 'arrow_st2'],
                                            ['name' => 'arrow_position_st2', 'operator' => 'in', 'value' => ['arrow_st2_top_center','arrow_st2_bottom_center']]
                                        ]
                                    ],
                                    [
                                    'terms' => [
                                            ['name' => 'arrow_style', 'operator' => '===', 'value' => 'arrow_st3'],
                                            
                                        ]
                                    ],
                                ]
                            ],  

                        ]
                    );

                    $this->end_popover();
    
                $this->end_controls_tab(); // Normal tab end
    
                // Hover tab Start
                $this->start_controls_tab(
                    'carousel_arrow_style_hover_tab',
                    [
                        'label' => __( 'Hover', 'htmega-pro' ),
                    ]
                );
    
                    $this->add_control(
                        'htmega_carousel_arrow_hover_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '#ffffff',
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow:hover' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow:hover svg path' => 'fill: {{VALUE}};',
                            ],
                        ]
                    );
    
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'carousel_arrow_hover_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow:hover',
                        ]
                    );
    
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'htmega_carousel_arrow_hover_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow:hover',
                        ]
                    );
    
                    $this->add_responsive_control(
                        'htmega_carousel_arrow_hover_border_radius',
                        [
                            'label' => __( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
    
                $this->end_controls_tab(); // Hover tab end
    
            $this->end_controls_tabs();
    
        $this->end_controls_section(); // Style arrow style end
    
    
        // Style Dots style start
        $this->start_controls_section(
            'htmega_carousel_dots_style',
            [
                'label'     => __( 'Dots', 'htmega-pro' ),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' =>[
                    'sldots'  => 'yes',
                ],
            ]
            );
            
            $this->start_controls_tabs( 'carousel_dots_style_tabs' );
    
                // Normal tab Start
                $this->start_controls_tab(
                    'carousel_dots_style_normal_tab',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                );
    
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'carousel_dots_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li button',
                        ]
                    );
    
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'htmega_carousel_dots_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li button',
                        ]
                    );
    
                    $this->add_responsive_control(
                        'htmega_carousel_dots_border_radius',
                        [
                            'label' => __( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
                    $this->add_control(
                        'dot_color',
                        [
                            'label' => __( 'Dot Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '#000000',
                            'selectors' => [
                                '{{WRAPPER}} .htmega-dot-index-yes .slick-dots li button' => 'color: {{VALUE}};',
                            ],
                            'condition' =>[
                                'dots_index'=>'yes',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'dot_typgrapry',
                            'selector' => '{{WRAPPER}} .htmega-dot-index-yes .slick-dots li button',
                            'condition' =>[
                                'dots_index'=>'yes',
                            ],
                            
                        ]
                    ); 

                    $this->add_responsive_control(
                        'htmega_carousel_dots_height',
                        [
                            'label' => __( 'Height', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 200,
                                    'step' => 1,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 15,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li button,{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li' => 'height: {{SIZE}}px;',
                            ],
                        ]
                    );
    
                    $this->add_responsive_control(
                        'htmega_carousel_dots_width',
                        [
                            'label' => __( 'Width', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px'],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 200,
                                    'step' => 1,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 15,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li button,{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li' => 'width: {{SIZE}}px !important;',
                            ],
                        ]
                    );
    
                    $this->add_responsive_control(
                        'htmega_carousel_dots_position_y',
                        [
                            'label' => __( 'Offset Y', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => -500,
                                    'max' => 500,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => -100,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => '',
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots' => 'bottom: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-pro-carousel-activation.dot_right_center .slick-dots,{{WRAPPER}} .htmega-pro-carousel-activation.dot_left_center .slick-dots' => 'top: {{SIZE}}{{UNIT}};bottom:auto',
                                '{{WRAPPER}} .htmega-pro-carousel-activation' => 'margin: 0px;',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'htmega_carousel_dots_position_X',
                        [
                            'label' => __( 'Offset X', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => -1000,
                                    'max' => 1000,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => -100,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => '',
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pro-carousel-activation.dot_bottom_right .slick-dots,{{WRAPPER}} .htmega-pro-carousel-activation.dot_right_center .slick-dots' => 'right: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-pro-carousel-activation.dot_bottom_left .slick-dots,{{WRAPPER}} .htmega-pro-carousel-activation.dot_left_center .slick-dots' => 'left: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-pro-carousel-activation' => 'margin: 0px;',
                                '{{WRAPPER}} .htmega-pro-carousel-activation.dot_bottom_center .slick-dots' => 'margin-left: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'htmega_carousel_dots_pagination_inner_space',
                        [
                            'label' => __( 'Inner Gap', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 200,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => '5',
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pro-carousel-activation.dot_right_center .slick-dots li:not(:last-child), {{WRAPPER}} .htmega-pro-carousel-activation.dot_left_center .slick-dots li:not(:last-child)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-pro-carousel-activation.dot_bottom_center .slick-dots li:not(:last-child), {{WRAPPER}} .htmega-pro-carousel-activation.dot_bottom_right .slick-dots li:not(:last-child),{{WRAPPER}} .htmega-pro-carousel-activation.dot_bottom_left .slick-dots li:not(:last-child)' => 'margin-right: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_control(
                        'dot_shap_color',
                        [
                            'label' => __( 'Dot Shape Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '#ddd',
                            'selectors' => [
                                '{{WRAPPER}} .htmega-dot-index-yes .slick-dots::after' => 'border-color: {{VALUE}};',
                            ],
                            'condition' =>[
                                'dots_index'=>'yes',
                            ],
                            'separator' =>'before'
                        ]
                    );
                    $this->add_responsive_control(
                        'dot_liden_height',
                        [
                            'label' => __( 'Border Line Height', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 10,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 2,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-dot-index-yes .slick-dots::after' => 'border-width: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' =>[
                                'dots_index'=>'yes',
                            ],
                        ]
                    ); 

                $this->end_controls_tab(); // Normal tab end
    
                // Hover tab Start
                $this->start_controls_tab(
                    'carousel_dots_style_hover_tab',
                    [
                        'label' => __( 'Active', 'htmega-pro' ),
                    ]
                );
    
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'carousel_dots_hover_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li.slick-active button',
                        ]
                    );
                    $this->add_control(
                        'dot_color_hover',
                        [
                            'label' => __( 'Dot Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '#000000',
                            'selectors' => [
                                '{{WRAPPER}} .htmega-dot-index-yes .slick-dots li.slick-active button' => 'color: {{VALUE}};',
                            ],
                            'condition' =>[
                                'dots_index'=>'yes',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'htmega_carousel_dots_hover_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li.slick-active button',
                        ]
                    );
    
                    $this->add_responsive_control(
                        'htmega_carousel_dots_hover_border_radius',
                        [
                            'label' => __( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li.slick-active button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
    
                $this->end_controls_tab(); // Hover tab end
    
            $this->end_controls_tabs();
    
        $this->end_controls_section(); // Style dots style end
    }

    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();
        $sectionid =  "sid".$this-> get_id();
        $sl_loop = $settings['sl_loop'];
        $slautoplay = $settings['slautoplay'];
        $slarrows = $settings['slarrows'];
        $sldots = $settings['sldots'];
        $slautoplayspeed = $settings['slautoplayspeed'];
        $slarrows_type        = $this->get_settings_for_display('slarrows_type');
         $slarrowsicon_font_next        = $settings['slarrowsicon_font_next'];
         $slarrowsicon_font_prev        = $settings['slarrowsicon_font_prev'];
         $slarrowsicon_font_next_nav        = $settings['slarrowsicon_font_next_nav'];
         $slarrowsicon_font_prev_nav        = $settings['slarrowsicon_font_prev_nav'];
         $slarrows_iamge_next =  $slarrows_iamge_prev = "";
         if($slarrows_type == 'image'){
            
            if ( isset($settings['slarrows_iamge_next']['url']) ) {
                $slarrows_iamge_next ='<img src="' . esc_url( $settings['slarrows_iamge_next']['url'] ) . '" alt="'. esc_html__( 'Next','htmega-pro ' ) . '" />';
            }
            if ( isset($settings['slarrows_iamge_prev']['url']) ) {
                $slarrows_iamge_prev ='<img src="' . esc_url( $settings['slarrows_iamge_prev']['url'] ) . '" alt="'. esc_html__('Prev','htmega-pro ') . '" />';
            }
        }

        if($slarrows_type == 'icon'){
        $print_next =  HTMega_Icon_manager::render_icon( $settings['slarrowsicon_font_next'], [ 'aria-hidden' => 'true' ] );
        $print_prev = HTMega_Icon_manager::render_icon( $settings['slarrowsicon_font_prev'], [ 'aria-hidden' => 'true' ] );
            
            }else if($slarrows_type == 'text'){
            $print_next = $slarrowsicon_font_next_nav;
            $print_prev = $slarrowsicon_font_prev_nav;

            }else{
            $print_next = $slarrows_iamge_next;
            $print_prev = $slarrows_iamge_prev;
            }
        $slider_settings = [
            'sectionid'=> esc_attr( $sectionid ),
            'arrows' => ('yes' === $settings['slarrows']),
            'arrow_prev_txt' => $print_prev,
            'arrow_next_txt' => $print_next,
            'dots' => ('yes' === $settings['sldots']),
            'autoplay' => ('yes' === $settings['slautoplay'])?true:false,
            'autoplay_speed' => absint($settings['slautoplayspeed']),
            'animation_speed' => absint($settings['slanimation_speed']),
            'fade' => ('fade' == $settings['slide_effect'])? true : false,
            'loop' => ('yes' === $settings['sl_loop']),
            'center_mode' => ( 'yes' === $settings['slcentermode']),
            'center_padding' => absint($settings['slcenterpadding']),
            'variable_width' => ('yes' === $settings['variable_width']),
            'vertical' => ('yes' === $settings['vertical']),
        ];

        $slider_responsive_settings = [
            'display_columns' => absint( $settings['slitems'] ),
            'scroll_columns' => absint( $settings['slscroll_columns'] ),
            'tablet_width' =>absint( $settings['tablet_width'] ),
            'tablet_display_columns' => isset( $settings["slitems_tablet"] ) ? absint( $settings["slitems_tablet"] )  : absint( $settings['slitems'] ),
            'tablet_scroll_columns' => isset( $settings["slscroll_columns_tablet"] ) ? absint( $settings["slscroll_columns_tablet"] ) : absint( $settings['slscroll_columns'] ),
            'mobile_width' => absint( $settings['mobile_width'] ),
            'mobile_display_columns' => isset( $settings["slitems_mobile"] )? absint( $settings["slitems_mobile"] ) : absint( $settings['slitems'] ),
            'mobile_scroll_columns' => isset( $settings["slscroll_columns_mobile"] ) ? absint( $settings["slscroll_columns_mobile"] ) : absint( $settings['slscroll_columns'] ),
        ];

        $slider_settings = array_merge( $slider_settings, $slider_responsive_settings );

        $s_display_none = ' style="display:none;"';
        $this->add_render_attribute( 'htmega_pro_wrapper_attr', 'class', 'htmega-template-slide htmega-pro-carousel-activation '. esc_attr( $sectionid.' '.$settings['dot_show_position'] ) );
        if( $settings['dots_index'] ){
            $this->add_render_attribute( 'htmega_pro_wrapper_attr', 'class', ' htmega-dot-index-' . esc_attr( $settings['dots_index'] ) );
        }
        if( $settings['slcentermode'] ){
            $this->add_render_attribute( 'htmega_pro_wrapper_attr', 'class', ' htmega-slick-center-' . esc_attr( $settings['slcentermode'] ) );
        }
        if( $settings['slarrows'] ){
            $this->add_render_attribute( 'htmega_pro_wrapper_attr', 'class', ' htmega-' . esc_attr( $settings['arrow_style'] ) . ' htmega-' . esc_attr( $settings['arrow_position_st1'] . $settings['arrow_position_st2'] . $settings['arrow_position_st3'] ) );
        }
        $this->add_render_attribute( 'htmega_pro_wrapper_attr', 'data-settings', wp_json_encode( $slider_settings ) ); 
        $this->add_render_attribute( 'htmega_sltitle', 'class', 'htmega-sltitle' );
        $this->add_render_attribute( 'htmega_slsubtitle', 'class', 'htmega-slsubtitle' );
        echo "<div class='htmega-advanced-slider-wrapper' {$s_display_none}>";
        if( $settings['slide_lists'] ){
            echo "<div ".$this->get_render_attribute_string( 'htmega_pro_wrapper_attr' )." >";

                foreach ( $settings['slide_lists'] as $item ) :
                ?>
                <!-- Slider Single -->
                <?php  //&& !empty( $item['content_temp'])
                if ( $item['content_type'] === "template" && ( !empty( $item['content_temp']) || !empty( $item['live_temp_content'] ) ) ) {
                    $temp_id = '';
                    if( !empty( $item['content_temp'] ) ){
                        $temp_id = $item['content_temp'];
                    } else {
                        $temp_id = htmega_get_template_id_by_title( $item['live_temp_content'] );
                        $temp_id = !empty( $temp_id ) ? $temp_id : $item['live_temp_content']; 
                    }                    
                        echo "<div class='htmega-elementor-temp-slide'>".htmega_get_template_content_by_id( $temp_id )."</div>"; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                    }else{

                        // Button Link
                        $url = $item['_id'];
                        $url2 = $item['_id'].$item['slbutton2'];

                        if ( ! empty( $item['slbuttonlink']['url'] ) ) {
                            $this->add_link_attributes( $url, $item['slbuttonlink'] );
                        }
                        if ( ! empty( $item['slbuttonlink2']['url'] ) ) {
                            $this->add_link_attributes( $url2, $item['slbuttonlink2'] );
                        }
                        ?>
                        <div class="htmega-advns-slider-item elementor-repeater-item-<?php echo esc_attr( $item['_id'] ) ; ?>">
                            <div class="htmega-advns-slide-content-wrapper">
                                <div class="htmega-advns-slide-content">
                                    <?php

                                    if( !empty( $item['slsubtitle'] ) ){
                                        printf( '<%1$s %2$s>%3$s</%1$s>',
                                        htmega_escape_tags( $settings['sub_title_tag'], 'h2' ),
                                        $this->get_render_attribute_string( 'htmega_slsubtitle' ),
                                        htmega_kses_title( $item['slsubtitle'] ));
                                    }
                                    if( !empty( $item['sltitle'] ) ){
                                        
                                        printf( '<%1$s %2$s>%3$s</%1$s>',
                                        htmega_escape_tags( $settings['title_tag'], 'h1' ),
                                        $this->get_render_attribute_string( 'htmega_sltitle' ),
                                        htmega_kses_title( $item['sltitle'] ));
                                    }

                                    if( !empty( $item['slcontent'] ) ){
                                        echo '<p>'. wp_kses_post($item['slcontent']).'</p>';
                                    }
                                    if( !empty($item['slbutton']) || !empty($item['slbutton2'] ) ){
                                        echo'<div class="htmega-advns-slide-btn">';
                                    if( !empty($item['slbuttonlink']) ){
                                        echo '<a '.$this->get_render_attribute_string( $url).' >';
                                        echo wp_kses_post($item['slbutton'] ) .'</a>';
                                    }
                                    if( !empty($item['slbuttonlink2']) ){
                                        echo '<a '.$this->get_render_attribute_string( $url2).' class="htmega-slide-button2" >';
                                        echo wp_kses_post($item['slbutton2'] ) .'</a>';
                                    }
                                    echo'</div>';
                                    }
                                    ?>

                                </div>
                            </div>
                        </div>
                    <?php

                    }
                    ?>
                <!-- Slider Single -->
            <?php endforeach; ?>
            </div>  
        <?php
        }
        echo '</div>';
    }

}

