<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\HTMega_Icon_manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Background_Switcher_Element extends Widget_Base {

    public function get_name() {
        return 'htmega-background-switcher';
    }
    
    public function get_title() {
        return __( 'Background Switcher', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-exchange';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }
    public function get_keywords() {
        return [ 'htmega', 'ht mega', 'background switcher', 'Image Switcher','htmega pro'];
    }
    
    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/general-widgets/background-switcher-widget/';
	}
    protected function is_dynamic_content():bool {
		return false;
	}
    protected function register_controls() {

        // General
        $this->start_controls_section(
            'switcher_general_section',
            [
                'label' => __( 'General', 'htmega-pro' ),
            ]
        );

            $this->add_control(
                'items_style',
                [
                    'label'         => esc_html__('Direction', 'htmega-pro'),
                    'type'          => Controls_Manager::SELECT,
                    'options'       => [
                        'horizontal'    => esc_html__('Horizontal', 'htmega-pro'),
                        'vertical'      => esc_html__('Vertical', 'htmega-pro'),
                    ],
                    'default'       => 'horizontal',
                ]
            );
        
          $this->add_control(
            'show_title',
            [
              'label' => esc_html__( 'Show Title', 'htmega-pro' ),
              'type' => Controls_Manager::SWITCHER,
              'label_on' => esc_html__( 'Show', 'htmega-pro' ),
              'label_off' => esc_html__( 'Hide', 'htmega-pro' ),
              'return_value' => 'yes',
              'default' => 'yes',
            ]
          );
        
          $this->add_control(
            'show_description',
            [
              'label' => esc_html__( 'Show Description', 'htmega-pro' ),
              'type' => Controls_Manager::SWITCHER,
              'label_on' => esc_html__( 'Show', 'htmega-pro' ),
              'label_off' => esc_html__( 'Hide', 'htmega-pro' ),
              'return_value' => 'yes',
              'default' => 'yes',
            ]
          );
        
          $this->add_control(
            'show_button',
            [
              'label' => esc_html__( 'Show Button', 'htmega-pro' ),
              'type' => Controls_Manager::SWITCHER,
              'label_on' => esc_html__( 'Show', 'htmega-pro' ),
              'label_off' => esc_html__( 'Hide', 'htmega-pro' ),
              'return_value' => 'yes',
              'default' => 'yes',
            ]
          );
            
          $this->add_control(
              'content_text_align',
              [
                  'label' => __('Alignment', 'htmega-pro'),
                  'type' => Controls_Manager::CHOOSE,
                  'options' => [
                      'left' => [
                          'title' => __('Left', 'htmega-pro'),
                          'icon' => 'eicon-text-align-left',
                      ],
                      'center' => [
                          'title' => __('Center', 'htmega-pro'),
                          'icon' => 'eicon-text-align-center',
                      ],
                      'right' => [
                          'title' => __('Right', 'htmega-pro'),
                          'icon' => 'eicon-text-align-right',
                      ],
                  ],
                  'default' => 'left',
                  'toggle' => true,
                  'selectors' => [
                      '{{WRAPPER}} .htmega-bg-image-switcher .htmega-bg-image-switcher-item.active .htmega-bg-image-switcher-item-content , {{WRAPPER}} .htmega-bg-image-switcher .htmega-bg-image-switcher-item:hover .htmega-bg-image-switcher-item-content , {{WRAPPER}} .htmega-bg-image-switcher .htmega-bg-image-switcher-item-content' => 'text-align: {{VALUE}};',
                  ],
                  'separator' => 'before'
              ]
          );

        $this->end_controls_section();

        // Content
        $this->start_controls_section(
            'switcher_item_section',
            [
                'label' => __( 'Items', 'htmega-pro' ),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'background_image',
            [
                'label' => __( 'Image', 'htmega-pro' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        // image position 
		$repeater->add_control(
			'image_position',
			[
				'label' => esc_html__( 'Image Position', 'htmega-pro' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'left top',
				'options' => [
					'left top'  => esc_html__( 'Left Top', 'htmega-pro' ),
					'left center' => esc_html__( 'Left Center', 'htmega-pro' ),
					'left bottom' => esc_html__( 'Left Bottom', 'htmega-pro' ),
					'right top'  => esc_html__( 'Right Top', 'htmega-pro' ),
					'right center' => esc_html__( 'Right Center', 'htmega-pro' ),
					'right bottom' => esc_html__( 'Right Bottom', 'htmega-pro' ),
					'center top'  => esc_html__( 'Center Top', 'htmega-pro' ),
					'center center' => esc_html__( 'Center Center', 'htmega-pro' ),
					'center bottom' => esc_html__( 'Center Bottom', 'htmega-pro' ),
				],
			]
		);

        $repeater->add_control(
            'title',
            [
                'label'   => __( 'Title', 'htmega-pro' ),
                'type'    => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => __('Switch Title.','htmega-pro'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'description',
            [
                'label'   => __( 'Description', 'htmega-pro' ),
                'type'    => Controls_Manager::TEXTAREA,
                'placeholder' => __('Switch Description.','htmega-pro'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'button_text',
            [
                'label'   => __( 'Button Text', 'htmega-pro' ),
                'type'    => Controls_Manager::TEXT,
                'placeholder' => __('Read More','htmega-pro'),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

		$repeater->add_control(
			'link', [
				'label'         => __( 'Button Link', 'htmega-pro' ),
				'placeholder'   => __( 'Add your button link', 'htmega-pro' ),
				'type'          => Controls_Manager::URL,
				'label_block'   => true,
				'autocomplete'  => false,
				'show_external' => false,
				'dynamic'       => [
					'active' => true,
				],
			]
		);

        $repeater->add_control(
            'button_icon',
            [
                'label'       => __( 'Icon', 'htmega-pro' ),
                'type'        => Controls_Manager::ICONS,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'icon_specing',
            [
                'label' => __( 'Icon Spacing', 'htmega-pro' ),
                'type'  => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 150,
                    ],
                ],
                'default' => [
                    'size' => 10,
                ],
                'condition' => [
                    'button_icon!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-bg-image-switcher {{CURRENT_ITEM}} a.htmega-bg-image-switcher-item-btn span.button-icon'  => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $repeater->add_control(
            'active_item',
            [
                'label'        => __('Active', 'htmega-pro'),
                'type'         => Controls_Manager::SWITCHER,
                'description'  => __('Active on Load', 'htmega-pro'),
                'label_on'     => __('Yes', 'htmega-pro'),
                'label_off'    => __('No', 'htmega-pro'),
                'return_value' => 'yes',
                'default'      => 'no',
                'separator'    => 'before'
            ]
        );

        $this->add_control(
            'switch_list',
            [
                'type'    => Controls_Manager::REPEATER,
                'fields'  =>  $repeater->get_controls(),
                'default' => [

                    [
                        'title'        => __('Cold Drink','htmega-pro'),
                        'description'  => __('There are many variat pass of Lorem Ipsull availab but the majority have.','htmega-pro'),
                        'active_item'  => 'yes',
                        'button_text'  => __('Read More','htmega-pro'),
                    ],
                    [
                        'title'        => __('Fish Burger','htmega-pro'),
                        'description'  => __('There are many variat pass of Lorem Ipsull availab but the majority have.','htmega-pro'),
                        'button_text'  => __('Read More','htmega-pro'),
                    ],
                    [
                        'title'        => __('Hot Coffee','htmega-pro'),
                        'description'  => __('There are many variat pass of Lorem Ipsull availab but the majority have.','htmega-pro'),
                        'button_text'  => __('Read More','htmega-pro'),
                    ],

                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->add_control(
            'show_hover_on_display',
            [
                'label'         => esc_html__('Direction', 'htmega-pro'),
                'type'          => Controls_Manager::SELECT,
                'options'       => [
                    'normal'    => esc_html__('Normal', 'htmega-pro'),
                    'hover'      => esc_html__('Hover', 'htmega-pro'),
                ],
                'default'       => 'normal',
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => __('Padding', 'htmega-pro'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .htmega-bg-image-switcher .htmega-bg-image-switcher-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'show_hover_on_display' => 'normal',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_hover_padding',
            [
                'label' => __('Padding', 'htmega-pro'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .htmega-bg-image-hover .htmega-bg-image-switcher-item-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'show_hover_on_display!' => 'normal',
                ],
            ]
        );

        $this->end_controls_section();

        // Item Style
        $this->start_controls_section(
            'switcher_item_style',
            array(
                'label' => __( 'Item', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            )
        );

            $this->add_responsive_control(
                'common_height',
                [
                    'label' => __('Common Height', 'htmega-pro'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'vh'],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 5,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                        'vh' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 500,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-bg-image-switcher .htmega-bg-image-switcher-item' => 'height: {{SIZE}}{{UNIT}};',
                    ]
                ]
            );

            $this->add_responsive_control(
                'common_border_width',
                [
                    'label' => __('Border Width', 'htmega-pro'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 10,
                            'step' => 1,
                        ]
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 1,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-bg-image-switcher .htmega-bg-image-switcher-item:not(:last-child)' => 'border-width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'common_border_color',
                [
                    'label' => __('Border Color', 'htmega-pro'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-bg-image-switcher .htmega-bg-image-switcher-item:not(:last-child)' => 'border-color: {{VALUE}}',
                    ]
                ]
            );

            $this->add_control(
                'item_background_heading',
                [
                    'label' => esc_html__( 'Set Overlay Color?', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );            

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'item_background_color',
                    'label' => __( 'Background Color', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'exclude' => ['image'],
                    'selector' => '{{WRAPPER}} .htmega-bg-image-switcher .htmega-bg-image-switcher-item',
                ]
            );

        $this->end_controls_section();

        // Item Title Style
        $this->start_controls_section(
            'switcher_item_title',
            array(
                'label' => __( 'Title', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_title!' => ''
                ],
            )
        );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .htmega-bg-image-switcher-item-title',
                ]
            );

            $this->add_control(
                'item_title_color',
                [
                    'label' => __('Color', 'htmega-pro'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-bg-image-switcher-item-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_responsive_control(
                'title_margin',
                [
                    'label' => __('Margin', 'htmega-pro'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'em'],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-bg-image-switcher-item-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();

        // Item Description Style
        $this->start_controls_section(
            'switcher_item_description',
            array(
                'label' => __( 'Description', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_description!' => ''
                ],
            )
        );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'description_typography',
                    'selector' => '{{WRAPPER}} .htmega-bg-image-switcher-item-text',
                ]
            );

            $this->add_control(
                'item_description_color',
                [
                    'label' => __('Color', 'htmega-pro'),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-bg-image-switcher-item-text' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_responsive_control(
                'description_margin',
                [
                    'label' => __('Margin', 'htmega-pro'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'em'],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-bg-image-switcher-item-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();

        // Item Button Style
        $this->start_controls_section(
            'switcher_item_button',
            array(
                'label' => __( 'Button', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_button!' => ''
                ],
            )
        );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'button_typography',
                    'selector' => '{{WRAPPER}} .htmega-bg-image-switcher-item-btn'
                ]
            );

            $this->start_controls_tabs('button_color_tab');

                $this->start_controls_tab(
                    'button_normal',
                    [
                        'label' => __('Normal', 'htmega-pro'),
                    ]
                );

                    $this->add_control(
                        'item_button_color',
                        [
                            'label' => __('Color', 'htmega-pro'),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-bg-image-switcher-item-btn' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'button_background',
                            'label' => __('Background', 'htmega-pro'),
                            'types' => ['classic', 'gradient'],
                            'exclude' => [ 'image' ],
                            'selector' => '{{WRAPPER}} .htmega-bg-image-switcher-item-btn',
                        ]
                    );

                $this->end_controls_tab();

                $this->start_controls_tab(
                    'button_hover',
                    [
                        'label' => __('Hover', 'htmega-pro'),
                    ]
                );

                    $this->add_control(
                        'item_button_hover_color',
                        [
                            'label' => __('Color', 'htmega-pro'),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-bg-image-switcher-item-btn:hover' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'button_hover_background',
                            'label' => __('Background', 'htmega-pro'),
                            'types' => ['classic', 'gradient'],
                            'exclude' => [ 'image' ],
                            'selector' => '{{WRAPPER}} .htmega-bg-image-switcher-item-btn:hover',
                        ]
                    );

                $this->end_controls_tab();

            $this->end_controls_tabs();

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'htmega_pro_border',
                    'label' => __( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-bg-image-switcher-item-btn',
                    'separator' => 'before',
                ]
            ); 

            $this->add_responsive_control(
                'button_border_radius',
                [
                    'label' => __('Border Radius', 'htmega-pro'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'em'],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-bg-image-switcher-item-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'button_padding',
                [
                    'label' => __('Padding', 'htmega-pro'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'em'],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-bg-image-switcher-item-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'button_margin',
                [
                    'label' => __('Margin', 'htmega-pro'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'em'],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-bg-image-switcher-item-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();

        // Item Button Style
        $this->start_controls_section(
            'switcher_item_button_icon',
            array(
                'label' => __( 'Button Icon', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_button!' => ''
                ],
            )
        );

            $this->add_control(
                'icon_size',
                [
                    'label' => __( 'Icon Size', 'htmega-pro' ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'size' => 14,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} a.htmega-bg-image-switcher-item-btn span.button-icon i'  => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} a.htmega-bg-image-switcher-item-btn span.button-icon svg path, {{WRAPPER}} a.htmega-bg-image-switcher-item-btn span.button-icon svg'  => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'icon_color',
                [
                    'label'     => __('Color', 'htmega-pro'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-bg-image-switcher-item a.htmega-bg-image-switcher-item-btn span.button-icon i' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .htmega-bg-image-switcher-item a.htmega-bg-image-switcher-item-btn span.button-icon svg path, {{WRAPPER}} .htmega-bg-image-switcher-item a.htmega-bg-image-switcher-item-btn span.button-icon svg' => 'fill: {{VALUE}}',
                    ],
                ]
            );

            $this->add_control(
                'icon_hover_color',
                [
                    'label'     => __('Hover Color', 'htmega-pro'),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-bg-image-switcher-item a.htmega-bg-image-switcher-item-btn:hover span.button-icon i' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .htmega-bg-image-switcher-item a.htmega-bg-image-switcher-item-btn:hover span.button-icon svg path, {{WRAPPER}} .htmega-bg-image-switcher-item a.htmega-bg-image-switcher-item-btn:hover span.button-icon svg' => 'fill: {{VALUE}}',
                    ],
                ]
            );

        $this->end_controls_section();

    }

    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();
        
        $this->add_render_attribute( 'htmega_swatch_control', 'class', 'htmega-bg-image-switcher' );
        $this->add_render_attribute( 'htmega_swatch_control', 'class', 'htmega-bg-image-' . esc_attr( $settings['items_style'] ) );
        $this->add_render_attribute( 'htmega_swatch_control', 'class', 'htmega-bg-image-' . esc_attr( $settings['show_hover_on_display'] ) );
        
        ?>

        <div class="htmega-bg-image-switcher-wrap d-flex">
            <div <?php echo $this->get_render_attribute_string( 'htmega_swatch_control' ); ?>>

                <div class="htmega-bg-image-switcher-background">
                    <?php $i=0; foreach ( $settings['switch_list'] as $switcher ): ?>  
                        <?php 
                        $i++;
                        if( $switcher['active_item'] == 'yes' ){ $active_tab = 'active'; } else{ $active_tab = ' '; }
                        ?>
                        <img data-img-id="<?php echo esc_attr( $i ); ?>" class="<?php echo esc_attr($active_tab); ?>" src="<?php echo esc_url($switcher['background_image']['url']); ?>" alt="<?php echo esc_html($switcher['title']); ?>" style="object-position: <?php echo esc_attr( $switcher['image_position'] ); ?>">
                    <?php endforeach;?>
                </div>

                <?php $j=0; foreach ( $settings['switch_list'] as $key => $switcher ): ?>  
                <?php 
                $j++;
                if( $switcher['active_item'] == 'yes' ){ $active_tab = 'active'; } else{ $active_tab = ' '; }
                ?>                
                <div class="htmega-bg-image-switcher-item <?php echo esc_attr($active_tab); ?> elementor-repeater-item-<?php echo esc_attr($switcher['_id']); ?>" data-img-target="<?php echo esc_attr( $j ); ?>">
                    <div class="htmega-bg-image-switcher-item-content">
                        
                        <?php

                        //Title
                        if ( !empty($switcher['title']) && 'yes' == $settings['show_title'] ) : ?>
                            <h3 class="htmega-bg-image-switcher-item-title"><?php echo esc_html($switcher['title']); ?></h3>
                        <?php endif;  

                        //Description
                        if ( !empty($switcher['description'] ) && 'yes' == $settings['show_description'] ) : ?>
                            <p class="htmega-bg-image-switcher-item-text"><?php echo esc_html($switcher['description']); ?></p>
                        <?php endif;

                        //Button                        
                        if ( ( $settings['show_button'] == 'yes') && ( !empty( $switcher['button_text'] ) || !empty( $switcher['button_icon']['value'] ) ) ) :

                            if( isset(  $switcher['link']['url'] ) && !empty( $switcher['link']['url'] ) ){
                                $this->add_link_attributes( $key, $switcher['link'] );
                            }

                        ?>
                        <a class="htmega-bg-image-switcher-item-btn" <?php echo $this->get_render_attribute_string( $key ); ?>>
                            <!-- Button text -->
                            <?php if(!empty($switcher['button_text'])){
                                ?><span><?php echo esc_html($switcher['button_text']); ?></span><?php
                            } ?>    
                            <!-- button icon  -->
                            <?php if(!empty($switcher['button_icon']['value'])){ ?>
                                <span class="button-icon"> <?php echo HTMega_Icon_manager::render_icon( $switcher['button_icon'], [ 'aria-hidden' => 'true' ] ); ?> </span> 
                            <?php } ?>
                        </a>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach;?>
            
            </div>
        </div>

    <?php

    }

}