<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Css_Filter;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Blob_Shape_Element extends Widget_Base {

    public function get_name() {
        return 'htmega-blob-shape-addons';
    }
    
    public function get_title() {
        return __( 'Blob Shape', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-shape';
    }

    public function get_categories() {
        return [ 'htmega-pro' ];
    }

    public function get_script_depends() {
        return [
            'anime',
        ];
	}
    public function get_keywords() {
        return ['blob shape', 'svg shape', 'htmega', 'ht mega'];
    }

    public function get_help_url() {
        return 'https://wphtmega.com/docs/';
    }
    protected function is_dynamic_content():bool {
		return false;
	}
    protected function register_controls() {

        // Video Layout
        $this->start_controls_section(
            'blob_shape_type_section',
            [
                'label' => esc_html__('Blob Shape', 'htmega-pro'),
            ]
        );
        $this->add_control(
            'blob_shape_type',
            [
                'label' => __('Shape Type', 'htmega-pro'),
                'type' => Controls_Manager::SELECT,
                'default' => 'image',
                'options' => [
                    'color' => __('Color', 'htmega-pro'),
                    'gradient' => __('Gradient Color', 'htmega-pro'),
                    'image' => __('Image', 'htmega-pro'),
                ],

            ]
        );

        // image controll 
        $this->add_control(
            'blob_shape_image',
            [
                'label' => esc_html__('Image', 'htmega-pro'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => HTMEGA_ADDONS_PL_URL_PRO.'assets/widgets/blob-shape/htmega-blob-placeholder.jpg',
                ],
                'condition' => [
                    'blob_shape_type' => 'image',
                ]
            ]);
            $this->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'blob_image_size',
                    'default' => 'large',
                    'separator' => 'none',
                    'condition'	=> [
                        'blob_shape_type' => 'image',
                    ],
                ]
            );
    
            $this->add_control(
                'blob_color_show_stroke',
                [
                    'label' => esc_html__('Show Stroke', 'htmega-pro'),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__('Show', 'htmega-pro'),
                    'label_off' => esc_html__('Hide', 'htmega-pro'),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition'	=> [
                        'blob_shape_type' => ['color'],
                    ],
                ]
            );
        $this->add_control(
            'blob_shape_style',
            [
                'label' => __('Shape Style', 'htmega-pro'),
                'type' => Controls_Manager::SELECT,
                'default' => 'style1',
                'options' => [
                    'style1' => __('Style 1', 'htmega-pro'),
                    'style2' => __('Style 2', 'htmega-pro'),
                    'style3' => __('Style 3', 'htmega-pro'),
                    'style4' => __('Style 4', 'htmega-pro'),
                    'style5' => __('Style 5', 'htmega-pro'),
                    'style6' => __('Style 6', 'htmega-pro'),
                    'style7' => __('Style 7', 'htmega-pro'),
                    'style8' => __('Style 8', 'htmega-pro'),
                    'style9' => __('Style 9', 'htmega-pro'),
                    'style10' => __('Style 10', 'htmega-pro'),
                    'style11' => __('Style 11', 'htmega-pro'),
                    'style12' => __('Style 12', 'htmega-pro'),
                    'style13' => __('Style 13', 'htmega-pro'),
                    'style14' => __('Style 14', 'htmega-pro'),
                    'style15' => __('Style 15', 'htmega-pro'),
                ],

            ]
        );

        $this->add_control(
            'blob_animation',
            [
                'label' => esc_html__('Animation', 'htmega-pro'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'blob_loop',
            [
                'label' => esc_html__('Loop', 'htmega-pro'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
                'condition' => [
                    'blob_animation'=> 'yes'
                ]

            ]
        );

        $this->add_control(
            'blob_duration',
            [
                'label' => esc_html__('Duration', 'htmega-pro'),
                'type' => Controls_Manager::SLIDER,
                'description' => esc_html__('Set the duration of the animation in millisecond.', 'htmega-pro'),
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 15000,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 5000,
                ],
                'frontend_available' => true,
                'condition' => [
                    'blob_animation'=> 'yes'
                ]
            ]
        );
        $this->add_control(
            'blob_delay',
            [
                'label' => esc_html__('Starting Delay', 'htmega-pro'),
                'type' => Controls_Manager::SLIDER,
                'description' => esc_html__('Set the duration of the animation in millisecond.', 'htmega-pro'),
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10000,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 100,
                ],
                'frontend_available' => true,
                'condition' => [
                    'blob_animation'=> 'yes'
                ]
            ]
        );
        $this->add_control(
            'blob_end_delay',
            [
                'label' => esc_html__('Ending Delay', 'htmega-pro'),
                'type' => Controls_Manager::SLIDER,
                'description' => esc_html__('Set the end delay of the animation in millisecond.', 'htmega-pro'),
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 10000,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 100,
                ],
                'frontend_available' => true,
                'condition' => [
                    'blob_animation'=> 'yes'
                ]
            ]
        );

        $this->end_controls_section();

        // content section end
        // Blob Shape style section
		$this->start_controls_section(
			'blob_section_style',
			[
				'label' => esc_html__('Blob Shape', 'htmega-pro'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
            'blob_shape_color',
            [
                'label' => esc_html__('Shape Color', 'htmega-pro'),
                'type' => Controls_Manager::COLOR,
                'default' => '#D73361',
                'condition' => [
                    'blob_shape_type' => ['color'],
                ]
            ]
        );

        // Gradient Color style

        $this->add_control(
            'blob_gradient_color_1',
            [
                'label' => esc_html__('Color One', 'htmega-pro'),
                'type' => Controls_Manager::COLOR,
                'default' => '#D73361',
                'condition'	=> [
                    'blob_shape_type' => ['gradient'],
                ],

            ]
        );

        $this->add_control(
            'blob_gradient_color_2',
            [
                'label' => esc_html__('Color Two', 'htmega-pro'),
                'type' => Controls_Manager::COLOR,
                'default' => '#4d2ba8',
                'condition'	=> [
                    'blob_shape_type' => ['gradient'],
                ],
            ]
        );
              // popover 
              $this->add_control(
                'gradient_pop_over',
                [
                    'type' =>Controls_Manager::POPOVER_TOGGLE,
                    'label' => esc_html__( 'Customize Gradeint', 'htmega-pro' ),
                    'label_off' => esc_html__( 'Default', 'htmega-pro' ),
                    'label_on' => esc_html__( 'Custom', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'condition' =>[
                        'blob_shape_type' => ['gradient'],
                    ]
                ]
            );
            $this->start_popover();
            
                $this->add_control(
                    'blob_color1_location',
                    [
                        'label' => esc_html__('Color One Locaiton (%)', 'htmega-pro'),
                        'type' => Controls_Manager::SLIDER,
                        'separator' => 'before',
                        'size_units' => ['%'],
                        'range' => [
                            '%' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'default' => [
                            'unit' => '%',
                            'size' => 0,
                        ],
                    ]
                );
                $this->add_control(
                    'blob_color2_location',
                    [
                        'label' => esc_html__('Color Two Location (%)', 'htmega-pro'),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => ['%'],
                        'range' => [
                            '%' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'default' => [
                            'unit' => '%',
                            'size' => 100,
                        ],
                    ]
                );
                $this->add_control(
                    'blob_color_position_x1',
                    [
                        'label' => esc_html__('Position X1', 'htmega-pro'),
                        'type' => Controls_Manager::SLIDER,
                        'separator' => 'before',
                        'size_units' => ['%'],
                        'range' => [
                            '%' => [
                                'min' => 1,
                                'max' => 100,
                            ],
                        ],
                        'step' => 0.5,
                        'default' => [
                            'unit' => '%',
                            'size' => 0,
                        ],
                    ]
                );
        
                $this->add_control(
                    'blob_color_position_x2',
                    [
                        'label' => esc_html__('Position X2', 'htmega-pro'),
                        'type' => Controls_Manager::SLIDER,
                        'default' => [
                            'unit' => '%',
                            'size' => 100,
                        ],
                        'size_units' => ['%'],
                        'range' => [
                            '%' => [
                                'min' => 1,
                                'max' => 100,
                            ],
                        ],
                        'step' => 0.5,
                    ]
                );
        
                $this->add_control(
                    'blob_color_position_y1',
                    [
                        'label' => esc_html__('Position Y1', 'htmega-pro'),
                        'type' => Controls_Manager::SLIDER,
                        'default' => [
                            'unit' => '%',
                            'size' => 0,
                        ],
                        'size_units' => ['%'],
                        'range' => [
                            '%' => [
                                'min' => 1,
                                'max' => 100,
                            ],
                        ],
                        'step' => 0.5,
                    ]
                );
        
                $this->add_control(
                    'blob_color_position_y2',
                    [
                        'label' => esc_html__('Position Y2', 'htmega-pro'),
                        'type' => Controls_Manager::SLIDER,
                        'default' => [
                            'unit' => '%',
                            'size' => 100,
                        ],
                        'size_units' => ['%'],
                        'range' => [
                            '%' => [
                                'min' => 1,
                                'max' => 100,
                            ],
                        ],
                        'step' => 0.5,
                    ]
                );
                $this->end_popover();
		$this->add_responsive_control(
			'blob_width',
			[
				'label' => esc_html__('Width', 'htmega-pro'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 1200,
					],
					'%' => [
						'min' => 1,
						'max' => 100,
					],
				],
                'default' => [
                    'unit' => 'px',
                    'size' => 400,
                ],
				'selectors' => [
					'{{WRAPPER}} .htmega-blob-svg' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'blob_height',
			[
				'label' => esc_html__('Height', 'htmega-pro'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 1200,
					],
					'%' => [
						'min' => 1,
						'max' => 100,
					],
				],
                'default' => [
                    'unit' => 'px',
                    'size' => 400,
                ],
				'selectors' => [
					'{{WRAPPER}} .htmega-blob-svg' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'blob_opacity',
			[
				'label' => esc_html__('Opacity', 'htmega-pro'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 1,
						'min' => 0.10,
						'step' => 0.01,
					],
				],
				'separator' => 'before',
				'selectors' => [
					'{{WRAPPER}} .htmega-blob-svg > *' => 'opacity: {{SIZE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Css_Filter::get_type(),
			[
				'name' => 'blob_filters',
				'selector' => '{{WRAPPER}} .htmega-blob-svg > *',

			]
		);


        $this->add_control(
            'blob_stroke_color',
            [
                'label' => esc_html__('Stroke Color', 'htmega-pro'),
                'type' => Controls_Manager::COLOR,
                'default' => '#777777',
                'selectors' => [
                    '{{WRAPPER}} .htmega-blob-svg path' => 'stroke: {{VALUE}};',
                ],
                'condition' => [
                    'blob_color_show_stroke' => ['yes'],
                    'blob_shape_type' => ['color'],
                ],
                'separator' => 'before',

            ]
        );

        $this->add_control(
            'blob_stroke_weight',
            [
                'label' => esc_html__('Stroke Weight', 'htmega-pro'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 5,
                ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-blob-svg path' => 'stroke-width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'blob_color_show_stroke' => ['yes'],
                    'blob_shape_type' => ['color'],
                ]
            ]
        );

        $this->add_responsive_control(
            'blob_align',
            [
                'label' => __( 'Alignment', 'htmega-pro' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'htmega-pro' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'htmega-pro' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'htmega-pro' ),
                        'icon' => 'eicon-text-align-right',
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-blob-shape-wrapper' => 'text-align: {{VALUE}};',
                ],
                'separator' => 'before'
            ]
        );    
        $this->end_controls_section();
        // item style end
    }

    protected function render( $instance = [] ) {
        $settings  = $this->get_settings_for_display();
        $items     = $this->get_settings_for_display('item_list');
        $sectionid = $this->get_id();

        $all_shape_style = [
			'style1' => [
				'M456,280.5Q434,321,390.5,334Q347,347,312.5,339.5Q278,332,259,360.5Q240,389,204.5,400Q169,411,167.5,362.5Q166,314,106.5,317Q47,320,26,280Q5,240,65.5,216.5Q126,193,125.5,159Q125,125,144,89.5Q163,54,201.5,78Q240,102,266,108Q292,114,344.5,98.5Q397,83,390.5,131.5Q384,180,431,210Q478,240,456,280.5Z',
				'M419.5,284Q453,328,412.5,350Q372,372,347,405Q322,438,281,426Q240,414,202,418Q164,422,145.5,387.5Q127,353,123.5,321.5Q120,290,75.5,265Q31,240,29,196Q27,152,70.5,133Q114,114,137.5,81.5Q161,49,200.5,82Q240,115,285,69Q330,23,344.5,72Q359,121,359,156Q359,191,372.5,215.5Q386,240,419.5,284Z',
			],
			'style2' => [
				'M360.5,319.5Q292,399,192,373.5Q92,348,119,259.5Q146,171,223.5,112Q301,53,365,146.5Q429,240,360.5,319.5Z',
				'M376,329.5Q298,419,231,357Q164,295,107,198.5Q50,102,178.5,68Q307,34,380.5,137Q454,240,376,329.5Z',
			],
			'style3' => [
				'M359,334Q348,428,247,415Q146,402,85.5,321Q25,240,77.5,145Q130,50,204,112Q278,174,324,207Q370,240,359,334Z',
                'M394.5,331Q345,422,251.5,402Q158,382,95,311Q32,240,98.5,174.5Q165,109,242.5,105.5Q320,102,382,171Q444,240,394.5,331Z',
			],
			'style4' => [
				'M415.5,312Q355,384,273.5,416.5Q192,449,155,374Q118,299,82,222.5Q46,146,117.5,82Q189,18,253.5,80Q318,142,397,191Q476,240,415.5,312Z',
				'M371.5,296Q329,352,265.5,379.5Q202,407,124,370Q46,333,56,244.5Q66,156,139.5,138.5Q213,121,285.5,107Q358,93,386,166.5Q414,240,371.5,296Z',
			],
			'style5' => [
				'M338.5,279Q302,318,252,361.5Q202,405,164,350Q126,295,96.5,226Q67,157,139,135.5Q211,114,270,121.5Q329,129,352,184.5Q375,240,338.5,279Z',
				'M382,327Q379,414,283.5,441.5Q188,469,145,387.5Q102,306,71.5,225Q41,144,116.5,88Q192,32,281,55Q370,78,377.5,159Q385,240,382,327Z',
			],
			'style6' => [
				'M382,327Q379,414,283.5,441.5Q188,469,145,387.5Q102,306,71.5,225Q41,144,116.5,88Q192,32,281,55Q370,78,377.5,159Q385,240,382,327Z',
				'M338.5,279Q302,318,252,361.5Q202,405,164,350Q126,295,96.5,226Q67,157,139,135.5Q211,114,270,121.5Q329,129,352,184.5Q375,240,338.5,279Z',
			],
			'style7' => [
				'M373.5,327.5Q380,415,299,376Q218,337,195,305Q172,273,110.5,210.5Q49,148,135.5,155.5Q222,163,297,119Q372,75,369.5,157.5Q367,240,373.5,327.5Z',
				'M328.5,282.5Q308,325,256,361Q204,397,148,354Q92,311,67.5,228Q43,145,132.5,153Q222,161,275,145Q328,129,338.5,184.5Q349,240,328.5,282.5Z',
			],
			'style8' => [
				'M384,297.5Q332,355,263,399Q194,443,161,368.5Q128,294,77,215.5Q26,137,114,105Q202,73,267,98.5Q332,124,384,182Q436,240,384,297.5Z',
				'M371.5,296Q329,352,265.5,379.5Q202,407,124,370Q46,333,56,244.5Q66,156,139.5,138.5Q213,121,285.5,107Q358,93,386,166.5Q414,240,371.5,296Z',
			],
			'style9' => [
				'M398.5,262.5Q377,285,392,323Q407,361,375.5,372Q344,383,320.5,398.5Q297,414,268.5,443.5Q240,473,213,440Q186,407,170.5,382Q155,357,102,368Q49,379,70,333.5Q91,288,55.5,264Q20,240,41.5,211.5Q63,183,84.5,162.5Q106,142,119.5,117.5Q133,93,163,93.5Q193,94,216.5,57.5Q240,21,277,17Q314,13,326,59Q338,105,372.5,112Q407,119,437,142.5Q467,166,443.5,203Q420,240,398.5,262.5Z',
				'M461.5,275.5Q459,311,445,345Q431,379,399.5,397.5Q368,416,340,439Q312,462,276,440Q240,418,216.5,401Q193,384,146,409Q99,434,104.5,384Q110,334,72,320.5Q34,307,39,273.5Q44,240,70,216.5Q96,193,106,171.5Q116,150,120.5,116Q125,82,154,73Q183,64,211.5,63.5Q240,63,276,41Q312,19,331,54Q350,89,381,102Q412,115,437,141.5Q462,168,463,204Q464,240,461.5,275.5Z',
			],
			'style10' => [
				'M384.5,265Q395,290,374,306Q353,322,348,351.5Q343,381,321.5,403Q300,425,270,411.5Q240,398,203.5,432Q167,466,144.5,434Q122,402,95,383.5Q68,365,50.5,336Q33,307,62.5,273.5Q92,240,99,218Q106,196,121,180Q136,164,145.5,144Q155,124,161.5,71.5Q168,19,204,12Q240,5,264,48.5Q288,92,327,79Q366,66,382.5,95.5Q399,125,389.5,160Q380,195,377,217.5Q374,240,384.5,265Z',
				'M410.5,259Q356,278,388,324.5Q420,371,372,363.5Q324,356,306.5,373.5Q289,391,264.5,384.5Q240,378,219.5,372Q199,366,180.5,357Q162,348,121,352Q80,356,91.5,320Q103,284,110,262Q117,240,97.5,213.5Q78,187,85.5,160Q93,133,111.5,111Q130,89,164.5,102Q199,115,219.5,59Q240,3,258.5,64Q277,125,302.5,122Q328,119,347.5,133.5Q367,148,416.5,157.5Q466,167,465.5,203.5Q465,240,410.5,259Z',
			],
			'style11' => [
				'M372,258Q350,276,338,289Q326,302,328.5,333.5Q331,365,312,383.5Q293,402,266.5,397.5Q240,393,215,393.5Q190,394,155,399.5Q120,405,139,352Q158,299,142,288Q126,277,110,258.5Q94,240,121,225Q148,210,106.5,161.5Q65,113,99,103Q133,93,158,79Q183,65,211.5,100Q240,135,272,88.5Q304,42,338,50.5Q372,59,345,121Q318,183,336,193Q354,203,374,221.5Q394,240,372,258Z',
				'M417.5,273.5Q445,307,385,304.5Q325,302,349,362.5Q373,423,342.5,443Q312,463,276,405Q240,347,219.5,357Q199,367,190,344.5Q181,322,115.5,350Q50,378,41.5,342.5Q33,307,43.5,273.5Q54,240,36.5,204Q19,168,49,145.5Q79,123,119,126Q159,129,169,90.5Q179,52,209.5,93.5Q240,135,266.5,106Q293,77,305.5,105Q318,133,354,132Q390,131,411.5,154Q433,177,411.5,208.5Q390,240,417.5,273.5Z',
			],
			'style12' => [
				'M394.5,265.5Q397,291,395,321Q393,351,386.5,392Q380,433,332.5,406.5Q285,380,262.5,403Q240,426,209.5,427Q179,428,154,410.5Q129,393,131.5,355Q134,317,95.5,308.5Q57,300,35.5,270Q14,240,32.5,209.5Q51,179,73.5,157Q96,135,108.5,105.5Q121,76,147.5,55.5Q174,35,207,77Q240,119,277,66Q314,13,327,58Q340,103,367.5,115Q395,127,413.5,152.5Q432,178,412,209Q392,240,394.5,265.5Z',
				'M430,265.5Q397,291,389,316.5Q381,342,355.5,353Q330,364,318,404Q306,444,273,424Q240,404,218,389Q196,374,161,385.5Q126,397,115.5,367.5Q105,338,111,309Q117,280,76,260Q35,240,27.5,204.5Q20,169,51,147Q82,125,120.5,127Q159,129,170,94Q181,59,210.5,87Q240,115,273,75.5Q306,36,340,45.5Q374,55,393.5,84.5Q413,114,410,150Q407,186,435,213Q463,240,430,265.5Z',
			],
			'style13' => [
				'M376,250.5Q304,261,318,284Q332,307,313,310.5Q294,314,299,375.5Q304,437,272,414.5Q240,392,214.5,394Q189,396,155,400Q121,404,110,373Q99,342,144.5,299Q190,256,131,248Q72,240,107.5,224.5Q143,209,165,205.5Q187,202,160,147.5Q133,93,163,94Q193,95,216.5,58Q240,21,275.5,21Q311,21,305,90Q299,159,362,132.5Q425,106,432.5,140.5Q440,175,444,207.5Q448,240,376,250.5Z',
				'M357.5,269Q419,298,371,299.5Q323,301,308.5,307.5Q294,314,284.5,330.5Q275,347,257.5,343.5Q240,340,212,376.5Q184,413,157,402.5Q130,392,146.5,344Q163,296,139.5,288Q116,280,63,260Q10,240,42.5,213Q75,186,127.5,191.5Q180,197,185.5,184.5Q191,172,180,97Q169,22,204.5,97Q240,172,251,172.5Q262,173,272.5,176.5Q283,180,290,189.5Q297,199,342.5,195.5Q388,192,342,216Q296,240,357.5,269Z',
			],
			'style14' => [
				'M427,264.5Q392,289,376,308Q360,327,369,378Q378,429,336,417Q294,405,267,403.5Q240,402,217.5,390Q195,378,160,388.5Q125,399,122.5,363Q120,327,110.5,306Q101,285,87.5,262.5Q74,240,81,215.5Q88,191,80,154.5Q72,118,91.5,90Q111,62,152,78Q193,94,216.5,71Q240,48,268.5,56Q297,64,315,88.5Q333,113,370,116Q407,119,436,143Q465,167,463.5,203.5Q462,240,427,264.5Z',
				'M436.5,275Q456,310,433,336.5Q410,363,391.5,393Q373,423,342,440Q311,457,275.5,421.5Q240,386,207,414.5Q174,443,148,422.5Q122,402,91.5,386Q61,370,56,335.5Q51,301,64.5,270.5Q78,240,89,217.5Q100,195,108,172.5Q116,150,115.5,109.5Q115,69,154.5,83Q194,97,217,72.5Q240,48,273.5,41.5Q307,35,333.5,55Q360,75,370,106.5Q380,138,386,164.5Q392,191,404.5,215.5Q417,240,436.5,275Z',
			],
			'style15' => [
				'M411.5,268Q412,296,417.5,334.5Q423,373,389,385.5Q355,398,325,403.5Q295,409,267.5,413.5Q240,418,203.5,441.5Q167,465,153.5,421.5Q140,378,114,364Q88,350,57.5,329.5Q27,309,15,274.5Q3,240,35.5,212Q68,184,77,156Q86,128,103,101.5Q120,75,146.5,54.5Q173,34,206.5,33Q240,32,276,25Q312,18,327,58.5Q342,99,370,112Q398,125,432.5,145.5Q467,166,439,203Q411,240,411.5,268Z',
				'M386.5,269.5Q420,299,391,314Q362,329,361.5,368Q361,407,331.5,419.5Q302,432,271,406.5Q240,381,203,424.5Q166,468,162,410.5Q158,353,150.5,332Q143,311,108,302.5Q73,294,106.5,267Q140,240,140.5,224Q141,208,115,169Q89,130,105.5,103.5Q122,77,165,109Q208,141,224,96Q240,51,274,41Q308,31,304.5,93.5Q301,156,322.5,160Q344,164,337.5,187Q331,210,342,225Q353,240,386.5,269.5Z',
			],
		];
        $blobPathData = $all_shape_style[ $settings['blob_shape_style']];
        $this->add_render_attribute( 'area_attr', 'class', 'htmega-blob-shape-wrapper htmega-blob-shape-' . esc_attr( $settings['blob_shape_type'] ) );
        $this->add_render_attribute( 'area_attr', 'id', 'htmega-blob-shape-' . esc_attr(  $sectionid ) );
        if ( 'yes' == $settings['blob_animation'] ) {

            $slider_settings = [
                'sectionid'      => esc_attr( $sectionid ),
                'blob_path'      => $blobPathData[1],
                'blob_duration'  => absint( $settings['blob_duration']['size'] ),
                'blob_delay'     => absint( $settings['blob_delay']['size'] ),
                'blob_end_delay' => absint( $settings['blob_end_delay']['size'] ),
                'blob_loop'      => ( 'yes' == $settings['blob_loop'] ) ? true : false,
                
            ];

            $this->add_render_attribute( 'area_attr', 'data-settings', wp_json_encode( $slider_settings ) );
        } 
        $this->add_render_attribute( 'area_attr', 'style', 'display:none;' );
        
       ?>

        <div <?php echo $this->get_render_attribute_string( 'area_attr' ); ?> >

            <svg viewBox="0 0 480 480" class="htmega-blob-svg" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
                <?php
                if ( 'color' == $settings['blob_shape_type'] ) {

                    echo '<path class="htmega-blob-path-'. esc_attr( $sectionid ) .'" fill="' . esc_attr( $settings['blob_shape_color'] ) . '" d="' . esc_attr( $blobPathData[0] ) . '" />';

                } else if ( 'image' == $settings['blob_shape_type'] ) {
                    if ( !empty( $settings['blob_shape_image']['id'] ) ) {
                        $settings['blob_shape_image']['url'] = Group_Control_Image_Size::get_attachment_image_src($settings['blob_shape_image']['id'], 'blob_image_size', $settings);
                    }  
                    ?>
                        <clipPath id="htmega-blob-id-<?php echo esc_attr( $sectionid ); ?>">
                            <path class="htmega-blob-path-<?php echo esc_attr( $sectionid ); ?>" d="<?php echo esc_attr( $blobPathData[0] ); ?>"  />
                        </clipPath>

                        <g clip-path="url(#htmega-blob-id-<?php echo esc_attr( $sectionid ); ?>)">
                            <image class="htmega-svg-blob-image"
                                xlink:href="<?php echo esc_url( $settings['blob_shape_image']['url'] ); ?>"
                                width="100%" height="100%" preserveAspectRatio="none"></image>
                        </g>
                    <?php
                } else if ('gradient' == $settings['blob_shape_type']) {
                    $blob_color1_location = ( $settings['blob_color1_location']['size'] ) ? absint( $settings['blob_color1_location']['size'] ) : 0;
                    $blob_color2_location =  ( $settings['blob_color2_location']['size'] ) ? absint( $settings['blob_color2_location']['size'] ) : 100;
                    $blob_color_position_x1 = absint( $settings['blob_color_position_x1']['size'] );
                    $blob_color_position_x2 = absint( $settings['blob_color_position_x2']['size'] );
                    $blob_color_position_y1 = absint( $settings['blob_color_position_y1']['size'] );
                    $blob_color_position_y2 = absint( $settings['blob_color_position_y2']['size'] );

                    $gradient_color1 = esc_attr($settings['blob_gradient_color_1']);
                    $gradient_color2 = esc_attr($settings['blob_gradient_color_2']);
                    
                    ?>
                    
                        <linearGradient id="htmega-blob-gradient-<?php echo esc_attr( $sectionid ); ?>" x1="<?php echo esc_attr( $blob_color_position_x1 ); ?>%" y1="<?php echo esc_attr( $blob_color_position_y1 ); ?>%" x2="<?php echo esc_attr( $blob_color_position_x2 ); ?>%" y2="<?php echo esc_attr( $blob_color_position_y2 ); ?>%">
                            <stop offset="<?php echo esc_attr( $blob_color1_location ); ?>%" style="stop-color: <?php echo esc_attr( $gradient_color1 ); ?>; stop-opacity: 1" />
                            <stop offset="<?php echo esc_attr( $blob_color2_location ); ?>%" style="stop-color: <?php echo esc_attr( $gradient_color2 ); ?>; stop-opacity: 1" />
                        </linearGradient>
                        <path class="htmega-blob-path-<?php echo esc_attr( $sectionid ); ?>" fill="url(#htmega-blob-gradient-<?php echo esc_attr( $sectionid ); ?>)" d="<?php echo esc_attr( $blobPathData[0] ); ?>" />
                    <?php
                }
                ?>
            </svg>
        </div>
         <?php
    }

}