<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\HTMega_Icon_Manager;
use Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Copy_Coupon_Code_Element extends Widget_Base {

    public function get_name() {
        return 'htmega-copy-coupon-code-addons';
    }
    
    public function get_title() {
        return __( 'Copy Coupon Code', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-copy';
    }

    public function get_categories() {
        return [ 'htmega-pro' ];
    }

    public function get_keywords() {
        return ['copy coupon code', 'coupon code', 'copy','offer code', 'htmega', 'ht mega'];
    }

    public function get_help_url() {
        return 'https://wphtmega.com/docs/';
    }
    protected function is_dynamic_content():bool {
		return false;
	}
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Copy Coupon Code', 'htmega-pro' ),
            ]
        );
        $this->add_control(
            'coupon_layout',
            [
                'label'        => esc_html__( 'Coupon Layout', 'htmega-pro' ),
                'type'         => Controls_Manager::SELECT,
                'default'      => 'style-1',
                'options'      => [
                    'style-1' => esc_html__( 'Style 1', 'htmega-pro' ),
                    'style-2' => esc_html__( 'Style 2', 'htmega-pro' ),
                    'style-3' => esc_html__( 'Style 3', 'htmega-pro' ),
                ],
            ]
        );
                
        $this->add_control(
            'coupon_code',
            [
                'label'   => esc_html__( 'Coupon Code', 'htmega-pro' ),
                'type'    => Controls_Manager::TEXT,
                'dynamic' => [ 'active' => true ],
                'default' => esc_html__( 'D63AACD', 'htmega-pro' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'copy_button_text',
            [
                'label'   => esc_html__( 'Copy Button Text', 'htmega-pro' ),
                'type'    => Controls_Manager::TEXT,
                'dynamic' => [ 'active' => true ],
                'default' => esc_html__( 'Copy', 'htmega-pro' ),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'copy_icon_switcher',
            [
                'label'       => esc_html__( 'Copy Icon', 'htmega-pro' ),
                'type'        => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'icon_type',
            [
                'label'   => __( 'Icon Type', 'htmega-pro' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'icon' => [
                        'title' => __( 'Icon', 'htmega-pro' ),
                        'icon'  => 'eicon-info-circle',
                    ],
                    'image' => [
                        'title' => __( 'Image', 'htmega-pro' ),
                        'icon'  => 'eicon-image-bold',
                    ],
                ],
                'default' => 'image',
                'condition' => [
                    'copy_icon_switcher'=> 'yes'
                ]
            ]
        );
        $this->add_control(
            'copy_icon',
            [
                'label'         => __( 'Icon', 'htmega-pro' ),
                'type'          => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-copy',
                    'library' => 'fa-solid',
                ],
                'condition'=>[
                    'icon_type'=>'icon',
                    'copy_icon_switcher'=> 'yes'
                ],
            ]
        );

        $this->add_control(
            'copy_image',
            [
                'label' => __('Image','htmega-pro'),
                'type'=>Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'icon_type' => 'image',
                    'copy_icon_switcher'=> 'yes'
                ]
            ]
        );

        $this->add_control(
            'copied_button_text',
            [
                'label'   => esc_html__( 'Copied Button Text', 'htmega-pro' ),
                'type'    => Controls_Manager::TEXT,
                'dynamic' => [ 'active' => true ],
                'default' => esc_html__( 'Copied', 'htmega-pro' ),
                'label_block' => true,
                'separator' => 'before'
            ]
        );

        $this->add_control(
            'copied_icon_switcher',
            [
                'label'       => esc_html__( 'Copied Icon', 'htmega-pro' ),
                'type'        => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'copied_icon_type',
            [
                'label'   => __( 'Icon Type', 'htmega-pro' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'icon' => [
                        'title' => __( 'Icon', 'htmega-pro' ),
                        'icon'  => 'eicon-info-circle',
                    ],
                    'image' => [
                        'title' => __( 'Image', 'htmega-pro' ),
                        'icon'  => 'eicon-image-bold',
                    ],
                ],
                'default' => 'image',
                'condition' => [
                    'copied_icon_switcher'=> 'yes'
                ]
            ]
        );
        $this->add_control(
            'copied_icon',
            [
                'label'         => __( 'Icon', 'htmega-pro' ),
                'type'          => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-copy',
                    'library' => 'fa-solid',
                ],
                'condition'=>[
                    'copied_icon_type'=>'icon',
                    'copied_icon_switcher'=> 'yes'
                ],
            ]
        );

        $this->add_control(
            'copied_image',
            [
                'label' => __('Image','htmega-pro'),
                'type'=>Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'copied_icon_type' => 'image',
                    'copied_icon_switcher'=> 'yes'
                ]
            ]
        );

        $this->add_control(
            'attention_graber',
            [
                'label'        => esc_html__( 'Attenion Grabber', 'htmega-pro' ),
                'type'         => Controls_Manager::SELECT,
                'default'      => 'none',
                'options'      => [
                    'none' => esc_html__( 'None', 'htmega-pro' ),
                    'hang' => esc_html__( 'Hang', 'htmega-pro' ),
                    'bounce' => esc_html__( 'Bounce', 'htmega-pro' ),
                    'pulse' => esc_html__( 'Pulse', 'htmega-pro' ),
                    'spin' => esc_html__( 'Spin', 'htmega-pro' ),
                    'fadeIn' => esc_html__( 'Fade', 'htmega-pro' ),
                    'blink' => esc_html__( 'Blink', 'htmega-pro' ),

                ],
                'selectors_dictionary' => [
                    'hang' => 'elementor-animation-hang',
                ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-coupon-animation' => ' animation-name: {{VALUE}};',
                ],
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'button_hover_animation',
            [
                'label' => __( 'Hover Animation', 'htmega-pro' ),
                'type' => Controls_Manager::HOVER_ANIMATION,
            ]
        );
        $this->end_controls_section();

        // Style
        // Coupon Box style section
        $this->start_controls_section(
            'box_style',
            [
                'label' => esc_html__( 'Coupon Box', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_responsive_control(
                'box_width_wrpper',
                [
                    'label' => __( 'Width', 'htmega-pro' ),
                    'type'      => Controls_Manager::NUMBER,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-cpc-wrapper' => 'width: {{SIZE}}px;',
                    ],
                ]
            );

            $this->add_responsive_control(
                'box_height_wrpper',
                [
                    'label' => __( 'Height', 'htmega-pro' ),
                    'type'      => Controls_Manager::NUMBER,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-cpc-wrapper' => 'height: {{SIZE}}px;',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'box_normal_background_wrpper',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-cpc-wrapper',
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'box_normal_border_wrpper',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-cpc-wrapper',
                ]
            );

            $this->add_responsive_control(
                'box_normal_border_radius_wrpper',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-cpc-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'box_normal_shadow_wrpper',
                    'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-cpc-wrapper',
                ]
            );
            $this->add_responsive_control(
                'box_normal_padding_wrpper',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-cpc-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'content_alignment',
                [
                    'label' => esc_html__( 'Alignment', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__( 'Left', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-coupon-btn span,{{WRAPPER}}' => 'text-align: {{VALUE}}; justify-content: {{VALUE}};',
                    ],
                ]
            );
        $this->end_controls_section();

        // Coupon Box style section
        $this->start_controls_section(
            'coupon_code_style',
            [
                'label' => esc_html__( 'Coupon Code', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_responsive_control(
                'coupon_code_width_wrpper',
                [
                    'label' => __( 'Width', 'htmega-pro' ),
                    'type'      => Controls_Manager::NUMBER,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-coupon input' => 'width: {{SIZE}}px;',
                        '{{WRAPPER}} .htmega-coupon' => 'min-width: {{SIZE}}px;',
                    ],
                ]
            );

            $this->add_control(
                'coupon_code_color',
                [
                    'label' => __( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-coupon input' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'coupon_code_typography',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-coupon input',
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'coupon_code_normal_background_wrpper',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-coupon input',
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'coupon_code_normal_border_wrpper',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-coupon input',
                ]
            );

            $this->add_responsive_control(
                'coupon_code_normal_border_radius_wrpper',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-coupon input' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'coupon_code_normal_shadow_wrpper',
                    'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-coupon input',
                ]
            );
            $this->add_responsive_control(
                'coupon_code_normal_padding_wrpper',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-coupon input' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
        $this->end_controls_section();
        // Copy button style section
        $this->start_controls_section(
            'coupon_copy_button_style',
            [
                'label' => esc_html__( 'Copy Button', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_responsive_control(
                'copy_button_width',
                [
                    'label' => __( 'Width', 'htmega-pro' ),
                    'type'      => Controls_Manager::NUMBER,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-coupon-btn' => 'width: {{SIZE}}px;',
                    ],
                ]
            );

            $this->add_responsive_control(
                'copy_button_height',
                [
                    'label' => __( 'Height', 'htmega-pro' ),
                    'type'      => Controls_Manager::NUMBER,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-coupon-btn' => 'height: {{SIZE}}px;',
                    ],
                ]
            );
            $this->add_control(
                'copy_button__color',
                [
                    'label' => __( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-coupon-btn' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'copy_button_typography',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-coupon-btn',
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'copy_button_background',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-coupon-btn',
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'copy_button_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-coupon-btn',
                ]
            );

            $this->add_responsive_control(
                'copy_button_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-coupon-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'copy_button_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-coupon-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'copy_button_shadow',
                    'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-coupon-btn',
                ]
            );
            $this->add_responsive_control(
                'icon_font_size',
                [
                    'label' => __( 'Icon Size', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => '',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-coupon-btn i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-coupon-btn svg,
                        {{WRAPPER}} .htmega-coupon-btn img' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                    'condition' => [
                        'copy_icon_switcher' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'icon_font_color',
                [
                    'label' => __( 'Icon Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-coupon-btn i' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .htmega-coupon-btn svg path' => 'fill: {{VALUE}}',
                    ],
                    'condition' => [
                        'copy_icon_switcher' => 'yes',
                    ]
                ]
            );
            $this->add_control(
                'icon_position',
                [
                    'label' => __('Position', 'htmega-pro'),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => __('Left', 'htmega-pro'),
                            'icon' => 'eicon-h-align-left',
                        ],
                        'right' => [
                            'title' => __('Right', 'htmega-pro'),
                            'icon' => 'eicon-h-align-right',
                        ],
                    ],
                    'default' => 'left',
                    'toggle' => false,
                    'condition' => [
                        'copy_icon_switcher' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'icon_space',
                [
                    'label' => __( 'Icon Space', 'htmega-pro' ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-copy-icon-pos-right i,
                        {{WRAPPER}} .htmega-copy-icon-pos-right  img,
                        {{WRAPPER}} .htmega-copy-icon-pos-right svg' => 'margin-left: {{SIZE}}px;',                
                        '{{WRAPPER}} .htmega-copy-icon-pos-left i,
                        {{WRAPPER}} .htmega-copy-icon-pos-left img,
                        {{WRAPPER}} .htmega-copy-icon-pos-left svg' => 'margin-right: {{SIZE}}px;',  
                
                    ],
                    'condition' => [
                        'copy_icon_switcher' => 'yes'
                    ]
                ]
            );
        $this->end_controls_section();
        // Copied button style section
        $this->start_controls_section(
            'coupon_copied_button_style',
            [
                'label' => esc_html__( 'Copied Button', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'copied_button__color',
                [
                    'label' => __( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-btn-copy-status-copied' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'copied_button_typography',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-btn-copy-status-copied',
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'copied_button_background',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-btn-copy-status-copied',
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'copied_button_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-btn-copy-status-copied',
                ]
            );

            $this->add_responsive_control(
                'copied_button_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-btn-copy-status-copied' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'copied_button_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-btn-copy-status-copied' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'copied_button_shadow',
                    'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-btn-copy-status-copied',
                ]
            );
            $this->add_responsive_control(
                'icon_font_size_copied',
                [
                    'label' => __( 'Icon Size', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => '',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-btn-copy-status-copied i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-btn-copy-status-copied svg,
                        {{WRAPPER}} .htmega-btn-copy-status-copied img' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                    'condition' => [
                        'copied_icon_switcher' => 'yes',
                        'copied_icon_type!' => 'none'
                    ]
                ]
            );
            $this->add_control(
                'icon_font_color_copied',
                [
                    'label' => __( 'Icon Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-btn-copy-status-copied i' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .htmega-btn-copy-status-copied svg path' => 'fill: {{VALUE}}',
                    ],
                    'condition' => [
                        'copied_icon_switcher' => 'yes'
                    ]
                ]
            );
        $this->end_controls_section();
    }

    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();
        $id         = $this->get_id();
        $this->add_render_attribute( 'area_attr', 'class', 'htmega-cpc-wrapper htmega-coupon' );
        $this->add_render_attribute( 'area_attr', 'class', 'htmega-cpc-' . $settings['coupon_layout'] );

        if ( $settings['button_hover_animation'] ) {
            $this->add_render_attribute( 'area_attr', 'class', 'elementor-animation-' . $settings['button_hover_animation'] );
        }
        if ( 'none'!== $settings['attention_graber'] ) {
            $this->add_render_attribute( 'area_attr', 'class', 'htmega-coupon-animation' );
        }
        if ( isset($settings['icon_position'] ) ) {
            $this->add_render_attribute( 'area_attr', 'class', 'htmega-copy-icon-pos-' . $settings['icon_position'] );
        }

        ?>                
            <div <?php echo $this->get_render_attribute_string( 'area_attr' ); ?> >
                <input class="htmega-coupon-text" type="text" value="<?php echo esc_html( $settings['coupon_code'] ) ?>" readonly>
                <button class="htmega-coupon-btn htmega-btn-copy-status-copy">
                    <span class="htmega-coupon-copy-content">
                        <?php
                        if ( $settings['icon_type'] == 'image' ) {

                            $copy_image_url = HTMEGA_ADDONS_PL_URL.'admin/assets/images/icon/copy.png';
                            if( $settings['copy_image']['url'] ) {
                                $copy_image_url = wp_get_attachment_image( $settings['copy_image']['id'], 'full' );
                            }
                            $allText = !empty($settings['copy_image']['alt']) ? $settings['copy_image']['alt'] : esc_attr( 'copy', 'htmega-pro' );
                            $copy_image = '<img alt="'. $allText .'" src="'. $copy_image_url .'" /> ';
                            echo wp_kses_post( $copy_image );
                        } 
                        if ( $settings['icon_type'] == 'icon' && $settings['copy_icon']['value'] ) {
                            echo HTMega_Icon_manager::render_icon( $settings['copy_icon'] ) . ' ';
                        }
                        
                        echo esc_html( $settings['copy_button_text'] ); ?>
                    </span>
                    <span  class="htmega-coupon-copied-content">

                        <?php
                        if ( $settings['copied_icon_type'] == 'image' ) {

                            $copied_image_url = HTMEGA_ADDONS_PL_URL.'admin/assets/images/icon/copied.png';
                            if( $settings['copied_image']['url'] ) {
                                $copied_image_url = wp_get_attachment_image( $settings['copied_image']['id'], 'full' );
                            }
                            $allText = !empty($settings['copied_image']['alt']) ? $settings['copied_image']['alt'] : esc_html__( 'copied', 'htmega-pro' );
                            $copied_image = '<img alt="'. esc_attr( $allText ) .'" src="'. esc_url( $copied_image_url ) .'" /> ';
                            echo $copied_image; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                        } 
                        if ( $settings['copied_icon_type'] == 'icon' && $settings['copied_icon']['value'] ) {
                            echo HTMega_Icon_manager::render_icon( $settings['copied_icon'] ).' ';
                        }
                        echo esc_html( $settings['copied_button_text']  ); ?>
                    </span>
                </button>
            </div>
        <?php

    }

}