<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Elementor_Widget_Data_Table extends Widget_Base {

    public function get_name() {
        return 'htmega-datatable-addons';
    }
    
    public function get_title() {
        return __( 'Data Table', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-table';
    }

    public function get_categories() {
        return [ 'htmega-addons' ];
    }

    public function get_keywords() {
        return ['data table','data', 'data sheet', 'advanced table','advanced data table', 'ht mega', 'htmega pro'];
    }

    public function get_help_url() {
        return 'https://wphtmega.com/docs/general-widgets/data-table-widget/';
    }

    public function get_script_depends() {
        return [ 'datatables' ];
    }

    public function get_style_depends() {
        return [ 'datatables' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'datatable_layout',
            [
                'label' => __( 'Table Data', 'htmega-pro' ),
            ]
        );

            $this->add_control(
                'content_source',
                [
                    'label' => __( 'Source', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'custom',
                    'options' => [
                        'custom'      => __( 'Custom', 'htmega-pro' ),
                        'csv'         => __( 'CSV File', 'htmega-pro' ),
                        'google'      => __( 'Google Sheet', 'htmega-pro' ),
                        'table_press' => __( 'TablePress', 'htmega-pro' ),
                        'database'    => __( 'Database', 'htmega-pro' ),
                    ],
                ]
            );
            
            $this->add_control(
                'database_tbl_list',
                [
                    'label' => __( 'Select Table', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => htmega_all_db_tbl_list(),
                    'condition' => [
                        'content_source' => 'database'
                    ],
                ]
            );
            $this->add_control(
                'table_press_table_list',
                [
                    'label' => __( 'Select Table', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => htmega_get_table_press_tbl_list(),
                    'condition' => [
                        'content_source' => 'table_press'
                    ],
                ]
            );
            $this->add_control(
                'source_type',
                [
                    'label'              => __( 'Source Type', 'htmega-pro' ),
                    'type'               => Controls_Manager::SELECT,
                    'default'            => 'url',
                    'options'            => [
                        'url'            => __( 'Remote URL', 'htmega-pro' ),
                        'file'           => __( 'Upload File', 'htmega-pro' ),
                    ],
                    'condition'          => [
                        'content_source' => 'csv',
                    ],
                ]
            );
            $this->add_control(
                'uploaded_csv_file',
                [
                    'label'              => __( 'Upload CSV', 'htmega-pro' ),
                    'type'               => Controls_Manager::MEDIA,
                    'media_type'         => array(),
                    'condition'          => [
                        'content_source' => 'csv',
                        'source_type'    => 'file',
                    ],
                ]
            );

            $this->add_control(
                'remote_csv_file',
                [
                    'label'              => __( 'Remote URL', 'htmega-pro' ),
                    'type'               => Controls_Manager::TEXT,
                    'condition'          => [
                        'source_type'    => 'url',
                        'content_source' => 'csv',
                    ],
                ]
            );
            $this->add_control(
                'csv_separator',
                [   
                    'label'              => __( 'Data Separator', 'htmega-pro' ),
                    'type'               => Controls_Manager::TEXT,
                    'default'            => __( ',', 'htmega-pro' ),
                    'conditions' => [
                        'relation' => 'or',
                        'terms' => [
                            [
                            'terms' => [
                                    ['name' => 'content_source', 'operator' => '===', 'value' => 'csv'],
                                    ['name' => 'remote_csv_file', 'operator' => '!=', 'value' => ''],
                                    ['name' => 'source_type', 'operator' => '==', 'value' => 'url'],
                                ]
                            ],
                            [
                            'terms' => [
                                    ['name' => 'content_source', 'operator' => '===', 'value' => 'csv'],
                                    ['name' => 'uploaded_csv_file[url]', 'operator' => '!==', 'value' => ''],
                                    ['name' => 'source_type', 'operator' => '==', 'value' => 'file'],
                                ]
                            ],
                        ]
                    ],
                   
                ]
            );

            $this->add_control(
                'google_api_key',
                [
                    'label'       => __('API Key', 'htmega-pro'),
                    'label_block' => true,
                    'type'        => Controls_Manager::TEXT,
                    'default' => '',
                    'description' => sprintf( // translators: %s represents the link to Google Cloud Console
                        esc_html__('<a href="https://console.cloud.google.com/apis/credentials" target="_blank">%s</a>','htmega-pro'), esc_html__( 'Get API Key','htmega-pro' ) ), 
                    'condition'   => [
                        'content_source' => 'google',
                    ],
                ]
            );
    
            $this->add_control(
                'google_sheet_id',
                [
                    'label'       => __('Spreadsheet ID', 'htmega-pro'),
                    'label_block' => true,
                    'type'        => Controls_Manager::TEXT,
                    'default' => '',
                    'description' => __('To get the spreadsheet ID for a Google Spreadsheet, open the spreadsheet and look for a long string of letters and numbers between "/d/" and "/edit" in the URL. That string is the spreadsheet ID.','htmega-pro'),
                    'condition'   => [
                        'content_source' => 'google',
                    ],
                ]
            );
    
            $this->add_control(
                'google_sheet_range',
                [
                    'label'     => esc_html__('Google Sheets Range', 'htmega-pro'),
                    'type'      => Controls_Manager::TEXT,
                    'default'   => 'A1:D5',
                    'description' => __('Example A1:D5. Here A1 is the upper left cell of the range, and "D5" is the lower right cell of the range','htmega-pro'),
                    'condition' => [
                        'content_source' => 'google',
                    ],
                ]
            );
            $this->add_control(
                'remove_cache',
                [
                    'label'        => __( 'Remove Cache', 'htmega-pro' ),
                    'type'         => Controls_Manager::SWITCHER,
                    'label_on'     => __( 'ON', 'htmega-pro' ),
                    'label_off'    => __( 'OFF', 'htmega-pro' ),
                    'description' => __('To delete instant cache, please <b>Turn ON and OFF</b> this switcher. In the meantime the cache will clear.','htmega-pro'),
                    'return_value' => 'yes',
                    'default'      => 'no',
                    'condition' => [
                        'content_source' => 'google',
                    ],
                ]
            );
            $this->add_control(
                'clear_cache_data_after',
                [
                    'label'     => esc_html__('Clear cached data Every(days)', 'htmega-pro'),
                    'type'      => Controls_Manager::NUMBER,
                    'default'   => '7',
                    'description' => __('Cache data will update every 7 day(Default)','htmega-pro'),
                    'condition' => [
                        'content_source' => 'google',
                    ],
                ]
            );

        $this->end_controls_section();

        // Table Header
        $this->start_controls_section(
            'datatable_header',
            [
                'label' => __( 'Table Header', 'htmega-pro' ),
                'condition'    => [
                    'content_source'  => 'custom',
                ],
            ]
        );

            $repeater = new Repeater();

            $repeater->add_control(
                'column_name',
                [
                    'label'   => __( 'Column Name', 'htmega-pro' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => __( 'No', 'htmega-pro' ),
                ]
            );

           $repeater->add_control(
                'column_heading',
                [
                    'label' => esc_html__( 'Column styles', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $repeater->add_responsive_control(
                'column_heading_align',
                [
                    'label' => __( 'Alignment', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => __( 'Left', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => __( 'Center', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => __( 'Right', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style {{CURRENT_ITEM}}' => 'text-align: {{VALUE}};',
                    ],
                    'default' => '',
                ]
            );
           $repeater->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'column_heading_background_color',
                    'label' => __( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-table-style {{CURRENT_ITEM}}',
                ]
            );

           $repeater->add_group_control(
                Group_Control_Border::get_type(),
                    [
                    'name' => 'column_background_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-table-style {{CURRENT_ITEM}}',
                ]
            );

           $repeater->add_responsive_control(
                'column_background_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selector' => '{{WRAPPER}} .htmega-table-style {{CURRENT_ITEM}}',
                ]
            );

           $repeater->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'column_background_border_shadow',
                    'label' => __( 'Box Shadow', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-table-style {{CURRENT_ITEM}}',
                ]
            );

            $this->add_control(
                'header_column_list',
                [
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                    'prevent_empty' => false,
                    'default' => [
                        [
                            'column_name' => __( 'No', 'htmega-pro' ),
                        ],

                        [
                            'column_name' => __( 'Name', 'htmega-pro' ),
                        ],

                        [
                            'column_name' => __( 'Designation', 'htmega-pro' ),
                        ],

                        [
                            'column_name' => __( 'Email', 'htmega-pro' ),
                        ]

                    ],
                    'title_field' => '{{{ column_name }}}',
                ]
            );
            
        $this->end_controls_section();

        // Table Content
        $this->start_controls_section(
            'datatable_content',
            [
                'label' => __( 'Table Content', 'htmega-pro' ),
                'condition'    => [
                    'content_source'  => 'custom',
                ],
            ]
        );

            $repeater_one = new Repeater();

            $repeater_one->add_control(
                'field_type',
                [
                    'label' => __( 'Field Type', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'row',
                    'options' => [
                        'row'   => __( 'Row', 'htmega-pro' ),
                        'col'   => __( 'Column', 'htmega-pro' ),
                    ],
                ]
            );

            $repeater_one->add_control(
                'cell_data_type',
                [
                    'label' => __( 'Data Type', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'text',
                    'options' => [
                        'text'     => __( 'Text', 'htmega-pro' ),
                        'icon'     => __( 'Icon', 'htmega-pro' ),
                        'image'    => __( 'Image', 'htmega-pro' ),
                        'template' => __( 'Elementor Template', 'htmega-pro' ),
                    ],
                    'condition'=>[
                        'field_type'=>'col',
                    ]
                ]
            );
            $repeater_one->add_control(
                'live_temp_content',
                array(
                    'label'              => __( 'Template Title', 'htmega-pro' ),
                    'type'               => Controls_Manager::TEXT,
                    'classes'            => 'htmega-live-temp-title control-hidden',
                    'label_block'        => true,
                    'condition'          => [
                        'cell_data_type' => 'template',
                        'field_type'     => 'col',
                    ]
                )
            );
            $repeater_one->add_control(
                'content_temp_live',
                array(
                    'type'        => Controls_Manager::BUTTON,
                    'label_block' => true,
                    'button_type' => 'default htmega-editor-block-btn',
                    'text'        => __( 'Create / Edit Template', 'htmega-pro' ),
                    'event'       => 'createTempEvent',
                    'condition'=>[
                        'cell_data_type'=>'template',
                        'field_type'=>'col',
                    ]
                ),
            );

            $repeater_one->add_control(
                'content_temp',
                [
                    'label' => esc_html__( 'Select Template', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'custom',
                    'options' => htmega_elementor_template(),
                    'condition'=>[
                        'cell_data_type'=>'template',
                        'field_type'=>'col',
                    ]
                ]
            );

            $repeater_one->add_control(
                'cell_text',
                [
                    'label'   => __( 'Cell Content', 'htmega-pro' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => __( 'Louis Hudson', 'htmega-pro' ),
                    'condition'=>[
                        'cell_data_type'=>'text',
                        'field_type'=>'col',
                    ]
                ]
            );

            $repeater_one->add_control(
                'cell_icon',
                [
                    'label'   => esc_html__( 'Cell Icon', 'htmega-pro' ),
                    'type'    => Controls_Manager::ICONS,
                    'condition'=>[
                        'cell_data_type'=>'icon',
                        'field_type'=>'col',
                    ]
                ]
            );

            $repeater_one->add_responsive_control(
                'cell_icon_size',
                [
                    'label' => esc_html__( 'Icon SIze', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px'],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 20,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style {{CURRENT_ITEM}} svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}',
                        '{{WRAPPER}} .htmega-table-style {{CURRENT_ITEM}}' => 'font-size: {{SIZE}}{{UNIT}};',

                    ],
                    'condition'=>[
                        'cell_data_type'=>'icon',
                        'field_type'=>'col',
                    ]
                ]
            );

            $repeater_one->add_control(
                'cell_icon_color',
                [
                    'label'     => __( 'Color', 'htmega-pro' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style {{CURRENT_ITEM}} i' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .htmega-table-style {{CURRENT_ITEM}} svg path' => 'fill: {{VALUE}};',
                    ],
                    'condition'=>[
                        'cell_data_type'=>'icon',
                        'field_type'=>'col',
                    ]
                ]
            );

            $repeater_one->add_control(
                'cell_image',
                [
                    'label' => esc_html__( 'Cell Image', 'htmega-pro' ),
                    'type' => Controls_Manager::MEDIA,
                    'condition'=>[
                        'cell_data_type'=>'image',
                        'field_type'=>'col',
                    ]
                ]
            );

            $repeater_one->add_responsive_control(
                'cell_image_width',
                [
                    'label' => esc_html__( 'Image Width', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px'],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                            'step' => 1,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style {{CURRENT_ITEM}} img' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition'=>[
                        'cell_data_type'=>'image',
                        'field_type'=>'col',
                    ]
                ]
            );

            $repeater_one->add_responsive_control(
                'cell_image_height',
                [
                    'label' => esc_html__( 'Image Height', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px'],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                            'step' => 1,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style {{CURRENT_ITEM}} img' => 'height: {{SIZE}}{{UNIT}}',
                    ],
                    'condition'=>[
                        'cell_data_type'=>'image',
                        'field_type'=>'col',
                    ]
                ]
            );


            $repeater_one->add_control(
                'row_colspan',
                [
                    'label' => __( 'Colspan', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 1,
                    'step' => 1,
                    'default' => 1,
                    'condition'=>[
                        'field_type'=>'col',
                    ]
                ]
            );

            $repeater_one->add_control(
                'cell_heading',
                [
                    'label' => esc_html__( 'Cell Styles', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition'=>[
                        'field_type'=>'col',
                    ]
                ]
            );
            $repeater_one->add_control(
                'cell_text_color',
                [
                    'label'     => __( 'Color', 'htmega-pro' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style {{CURRENT_ITEM}}' => 'color: {{VALUE}};',
                    ],
                    'condition'=>[
                        'cell_data_type'=>'text',
                        'field_type'=>'col',
                    ]
                ]
            );
            $repeater_one->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'cell_background_color',
                    'label' => __( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-table-style {{CURRENT_ITEM}}',
                    'condition'=>[
                        'field_type'=>'col',
                    ]
                ]
            );

            $repeater_one->add_group_control(
                Group_Control_Border::get_type(),
                    [
                    'name' => 'cell_background_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-table-style {{CURRENT_ITEM}}',
                    'condition'=>[
                        'field_type'=>'col',
                    ]
                ]
            );
            $repeater_one->add_responsive_control(
                'column_cell_align',
                [
                    'label' => __( 'Alignment', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => __( 'Left', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => __( 'Center', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => __( 'Right', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style {{CURRENT_ITEM}}' => 'text-align: {{VALUE}};',
                    ],
                    'default' => '',
                    'condition'=>[
                        'field_type'=>'col',
                    ]
                ]
            );
            $this->add_control(
                'content_list',
                [
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater_one->get_controls(),
                    'default' => [
                        [
                            'field_type' => __( 'row', 'htmega-pro' ),
                        ],

                        [
                            'field_type' => __( 'col', 'htmega-pro' ),
                            'cell_text' => __( '1', 'htmega-pro' ),
                            'row_colspan' => __( '1', 'htmega-pro' ),
                        ],

                        [
                            'field_type' => __( 'col', 'htmega-pro' ),
                            'cell_text' => __( 'Louis Hudson', 'htmega-pro' ),
                            'row_colspan' => __( '1', 'htmega-pro' ),
                        ],

                        [
                            'field_type' => __( 'col', 'htmega-pro' ),
                            'cell_text' => __( 'Developer', 'htmega-pro' ),
                            'row_colspan' => __( '1', 'htmega-pro' ),
                        ],


                        [
                            'field_type' => __( 'col', 'htmega-pro' ),
                            'cell_text' => __( 'jondoy@gmail.com', 'htmega-pro' ),
                            'row_colspan' => __( '1', 'htmega-pro' ),
                        ]

                    ],
                    'title_field' => '{{{field_type}}}',
                ]
            );
            
        $this->end_controls_section();
        // Sorting Options
        $this->start_controls_section(
            'datatable_sorting_options',
            [
                'label' => __( 'Display Options', 'htmega-pro' ),
            ]
        );
            $this->add_control(
                'datatable_style',
                [
                    'label'   => __( 'Layout', 'htmega-pro' ),
                    'type'    => 'htmega-preset-select',
                    'default' => '1',
                    'options' => [
                        '1'   => __( 'Layout One', 'htmega-pro' ),
                        '2'   => __( 'Layout Two', 'htmega-pro' ),
                        '3'   => __( 'Layout Three', 'htmega-pro' ),
                    ],
                ]
            );
            $this->add_control(
                'show_datatable_sorting',
                [
                    'label'        => __( 'Show Sorting Options', 'htmega-pro' ),
                    'type'         => Controls_Manager::SWITCHER,
                    'label_on'     => __( 'Show', 'htmega-pro' ),
                    'label_off'    => __( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default'      => 'no',
                ]
            );
            $this->add_control(
                'show_datatable_paging',
                [
                    'label' => __( 'Pagination', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => __( 'Show', 'htmega-pro' ),
                    'label_off' => __( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' => [
                        'show_datatable_sorting' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'default_row_number',
                [
                    'label' => __( 'Default option for number of Rows', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 1,
                    'step' => 1,
                    'default' => 10,
                    'condition' =>[
                        'show_datatable_paging'=>'yes',
                        'show_datatable_sorting' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'custom_display_row',
                [
                    'label' => __( 'Custom options for number of Rows?', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => __( 'Show', 'htmega-pro' ),
                    'label_off' => __( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' =>[
                        'show_datatable_paging'=>'yes',
                        'show_datatable_sorting' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'display_options',
                [
                    'label'   => __( 'Options for number of Rows', 'htmega-pro' ),
                    'type'    => Controls_Manager::TEXTAREA,
                    'default' => __( '10,25,50,100', 'htmega-pro' ),
                    'description'=> esc_html__( 'Enter the number separate by comma(10,25,50,100)','htmega-pro'),
                    'condition'=> [
                        'custom_display_row'=>'yes',
                        'show_datatable_paging'=>'yes',
                        'show_datatable_sorting' => 'yes'
                    ]
                ]
            );

            $this->add_control(
                'show_all_button',
                [
                    'label' => __( 'Add all option', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => __( 'Show', 'htmega-pro' ),
                    'label_off' => __( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' =>[
                        'show_datatable_paging'=>'yes',
                        'custom_display_row'=>'yes',
                        'show_datatable_sorting' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'show_all_text',
                [
                    'type'    => Controls_Manager::TEXT,
                    'default' => __( 'All', 'htmega-pro' ),
                    'label_block'=>true,
                    'condition'=>[
                        'show_all_button'=>'yes',
                        'show_datatable_paging'=>'yes',
                        'custom_display_row'=>'yes',
                        'show_datatable_sorting' => 'yes'
                    ],
                   
                ]
            );
            $this->add_control(
                'show_datatable_searching',
                [
                    'label' => __( 'Searching', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => __( 'Show', 'htmega-pro' ),
                    'label_off' => __( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'separator' =>'before',
                    'condition'=>[
                        'show_datatable_sorting' => 'yes'
                    ],
                ]
            );

            $this->add_control(
                'show_datatable_ordering',
                [
                    'label' => __( 'Ordering', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => __( 'Show', 'htmega-pro' ),
                    'label_off' => __( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition'=>[
                        'show_datatable_sorting' => 'yes'
                    ],
                ]
            );

            $this->add_control(
                'show_datatable_info',
                [
                    'label' => __( 'Footer Info', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => __( 'Show', 'htmega-pro' ),
                    'label_off' => __( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition'=>[
                        'show_datatable_sorting' => 'yes'
                    ],
                ]
            );

            $this->add_control(
                'export_data',
                [
                    'label'        => __( 'Data Export Button', 'htmega-pro' ),
                    'type'         => Controls_Manager::SWITCHER,
                    'label_on'     => __( 'Show', 'htmega-pro' ),
                    'label_off'    => __( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default'      => 'no',
                    'separator'    => 'before',
                ]
            );
            $this->add_control(
                'export_button_text',
                [
                    'label'     => esc_html__('Export Data', 'htmega-pro'),
                    'type'      => Controls_Manager::TEXT,
                    'default'   => 'Export Data',
                    'description' => __('The Exported Data will save as CSV file','htmega-pro'),
                    'condition' => [
                        'export_data' => 'yes',
                    ],
                ]
            );
            $this->add_control(
                'export_table_data_visitor',
                [
                    'label' => __( 'Export table data for visitors', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => __( 'Yes', 'htmega-pro' ),
                    'label_off' => __( 'No', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => '',
                    'condition' => [
                        'export_data' => 'yes'
                    ]
                ]
            );

        $this->end_controls_section();


        // Style tab section
        $this->start_controls_section(
            'htmega_table_style_section',
            [
                'label' => __( 'Table', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'datatable_bg_color',
                    'label' => __( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-table-style .dataTables_wrapper',
                ]
            );

            
            $this->add_responsive_control(
                'datatable_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                            '{{WRAPPER}} .htmega-table-style' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'datatable_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                            '{{WRAPPER}} .htmega-table-style' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                    [
                        'name' => 'datatable_border',
                        'label' => esc_html__( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-table-style',
                    ]
            );

            $this->add_responsive_control(
                'datatable_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'datatable_border_shadow',
                    'label' => __( 'Box Shadow', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-table-style',
                ]
            );
            
        $this->end_controls_section();

        // Table Header Style tab section
        $this->start_controls_section(
            'htmega_table_header_style_section',
            [
                'label' => __( 'Table Header', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_control(
                'datatable_header_text_color',
                [
                    'label' => esc_html__( 'Text Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style thead tr th' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'datatable_header_bg_color',
                    'label' => __( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-table-style thead tr th',
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'datatable_header_typography',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-table-style thead tr th',
                ]
            );

            $this->add_responsive_control(
                'datatable_header_padding',
                [
                    'label' => esc_html__( 'Table Header Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                            '{{WRAPPER}} .htmega-table-style thead tr th' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                    [
                        'name' => 'datatable_header_border',
                        'label' => esc_html__( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-table-style thead tr th',
                    ]
            );

            $this->add_responsive_control(
                'datatable_header_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style thead tr th' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );

            $this->add_responsive_control(
                'datatable_header_align',
                [
                    'label' => __( 'Alignment', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => __( 'Left', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => __( 'Center', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => __( 'Right', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                        'justify' => [
                            'title' => __( 'Justified', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-justify',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style thead tr th' => 'text-align: {{VALUE}};',
                    ],
                    'default' => '',
                    'separator' =>'before',
                ]
            );

            $this->add_control(
                'htmega_table_sorting_pagination_ordering',
                [
                    'label' => esc_html__( 'Ordering Icon', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition'=>[
                        'show_datatable_ordering'=>'yes',
                    ]
                ]
            );

            $this->add_control(
                'datatable_sorting_Ordering_color',
                [
                    'label' => esc_html__( 'Sorting Icon Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style .htb-table thead tr th.sorting::before' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .htmega-table-style .htb-table thead tr th.sorting::after' => 'color: {{VALUE}};',
                    ],
                    'condition'=>[
                        'show_datatable_ordering'=>'yes',
                    ]
                ]
            );

            $this->add_control(
                'datatable_sorting_Ordering_before_color',
                [
                    'label' => esc_html__( 'Sorting Active Top Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style .htb-table thead tr th.sorting_asc::before' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .htmega-table-style .htb-table thead tr th.sorting_desc::after' => 'color: {{VALUE}};',
                    ],
                    'condition'=>[
                        'show_datatable_ordering'=>'yes',
                    ]
                ]
            );

            $this->add_control(
                'datatable_sorting_Ordering_after_color',
                [
                    'label' => esc_html__( 'Sorting Active Bottom Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style .htb-table thead tr th.sorting_desc::before' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .htmega-table-style .htb-table thead tr th.sorting_asc::after' => 'color: {{VALUE}};',
                    ],
                    'condition'=>[
                        'show_datatable_ordering'=>'yes',
                    ]
                ]
            );

        $this->end_controls_section();
        // Custom Labels
        $this->start_controls_section(
            'datatable_custom_labels',
            [
                'label' => __( 'Custom Labels', 'htmega-pro' ),
            ]
        );
        $this->add_control(
            'search_label',
            [
                'label'        => __( 'Search', 'htmega-pro' ),
                'type'    => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( 'Search:', 'htmega-pro' ),
                'placeholder' => __( 'Search:', 'htmega-pro' ),
            ]
        );
        $this->add_control(
            'menu_lenght_label',
            [
                'label'        => __( 'Menu Lenght Text', 'htmega-pro' ),
                'type'    => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( 'Show _MENU_ entries', 'htmega-pro' ),
                'placeholder' => __( 'Show _MENU_ entries', 'htmega-pro' ),
                'description'  => esc_html__( 'Enter the label with underscores and uppercase words to dynamically display content (e.g., "Show _MENU_ entries").', 'htmega-pro' )
            ]
        );
        $this->add_control(
            'paginate_next_label',
            [
                'label'        => __( 'Paginate Next', 'htmega-pro' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __( 'Next', 'htmega-pro' ),
                'placeholder' => __( 'Next', 'htmega-pro' ),
                
            ]
        );
        $this->add_control(
            'paginate_prev_label',
            [
                'label'        => __( 'Paginate Prev', 'htmega-pro' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __( 'Previous', 'htmega-pro' ),
                'placeholder' => __( 'Previous', 'htmega-pro' ),
            ]
        );
        $this->add_control(
            'paginate_info_label',
            [
                'label'        => __( 'Paginate Info', 'htmega-pro' ),
                'type'    => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( 'Showing _START_ to _END_ of _TOTAL_ entries', 'htmega-pro' ),
                'placeholder' => __( 'Showing _START_ to _END_ of _TOTAL_ entries', 'htmega-pro' ),
                'description'  => esc_html__( 'Enter the label with underscores and uppercase words to dynamically display content (e.g., "Showing _START_ to _END_ of _TOTAL_ entries").', 'htmega-pro' )
            ]
        );
        $this->add_control(
            'empty_info_label',
            [
                'label'        => __( 'Empty Info', 'htmega-pro' ),
                'type'    => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( 'Showing 0 to 0 of 0 entries', 'htmega-pro' ),
                'placeholder' => __( 'Showing 0 to 0 of 0 entries', 'htmega-pro' ),
                'description'  => esc_html__( 'Enter the label with underscores and uppercase words to dynamically display content (e.g., "Showing 0 to 0 of 0 entries").', 'htmega-pro' )
            ]
        );
        $this->add_control(
            'filtered_info_label',
            [
                'label'        => __( 'Filtered Info', 'htmega-pro' ),
                'type'    => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( '(filtered from _MAX_ total entries)', 'htmega-pro' ),
                'placeholder' => __( '(filtered from _MAX_ total entries)', 'htmega-pro' ),
                'description'  => esc_html__( 'Enter the label with underscores and uppercase words to dynamically display content (e.g., "(filtered from _MAX_ total entries)").', 'htmega-pro' )
            ]
        );
        $this->add_control(
            'no_match_info_label',
            [
                'label'        => __( 'Data Not Found', 'htmega-pro' ),
                'type'    => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __( 'No matching records found', 'htmega-pro' ),
                'placeholder' => __( 'No matching records found', 'htmega-pro' ),
            ]
        );
        $this->end_controls_section();
        // Table Body Style tab section
        $this->start_controls_section(
            'htmega_table_body_style_section',
            [
                'label' => __( 'Table Body', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_control(
                'datatable_body_bg_color',
                [
                    'label' => esc_html__( 'Background Color ( Event )', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .htb-table tbody tr:nth-child(even)' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'datatable_body_odd_bg_color',
                [
                    'label' => esc_html__( 'Background Color ( Odd )', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .htb-table tbody tr:nth-child(odd)' => 'background-color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                    [
                        'name' => 'datatable_body_all_border',
                        'label' => esc_html__( 'Table Body Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} table.dataTable.no-footer',
                    ]
            );
            $this->add_control(
                'datatable_body_text_color',
                [
                    'label' => esc_html__( 'Text Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style tbody tr td' => 'color: {{VALUE}};',
                    ],
                    'separator' =>'before',
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'datatable_body_typography',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-table-style tbody tr td',
                ]
            );

            $this->add_responsive_control(
                'datatable_body_padding',
                [
                    'label' => esc_html__( 'Table Cell Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                            '{{WRAPPER}} .htmega-table-style tbody tr td' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                    [
                        'name' => 'datatable_body_border',
                        'label' => esc_html__( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-table-style tbody tr td',
                    ]
            );

            $this->add_responsive_control(
                'datatable_body_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style tbody tr td' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );

            $this->add_responsive_control(
                'datatable_body_align',
                [
                    'label' => __( 'Alignment', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => __( 'Left', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => __( 'Center', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => __( 'Right', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                        'justify' => [
                            'title' => __( 'Justified', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-justify',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style tbody tr td' => 'text-align: {{VALUE}};',
                    ],
                    'default' => '',
                ]
            );

        $this->end_controls_section();
        // Entires section
        $this->start_controls_section(
            'entries_style_section',
                [
                    'label' => __( 'Entries Style', 'htmega-pro' ),
                    'tab' => Controls_Manager::TAB_STYLE,
                    'condition'=>[
                        'show_datatable_paging'=>'yes',
                    ]
                ]
            );
            $this->add_control(
                'datatable_sorting_text_color_header',
                [
                    'label' => esc_html__( 'Label Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style .dataTables_length label' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .htmega-table-style .dataTables_filter label' => 'color: {{VALUE}};',
                    ],
                    'condition'=>[
                        'show_datatable_paging'=>'yes',
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'datatable_sorting_typography_header',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-table-style .dataTables_length label',
                    'condition'=>[
                        'show_datatable_paging'=>'yes',
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                    [
                    'name' => 'datatable_sorting_border_header',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-table-style .dataTables_wrapper .dataTables_length, {{WRAPPER}} .htmega-table-style .dataTables_wrapper .dataTables_filter input, {{WRAPPER}} .htmega-table-style .dataTables_wrapper .dataTables_paginate',
                    'condition'=>[
                        'show_datatable_paging'=>'yes',
                    ]
                ]
            );
            $this->add_responsive_control(
                'entries_border_box_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style .dataTables_wrapper .dataTables_length' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'header_bottom_space',
                [
                    'label' => esc_html__( 'Bottom Space', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 0,
                    'max' => 300,
                    'step' => 1,
                    'default' => 0,
                    'selectors' => [
                        '{{WRAPPER}} .dataTables_length,{{WRAPPER}} .dataTables_filter' => 'margin-bottom: {{VALUE}}px',
                    ],
                ]
            );
            $this->add_control(
                'htmega_table_sorting_length_pagination_header',
                [
                    'label' => esc_html__( 'Input Style', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition'=>[
                        'show_datatable_paging'=>'yes',
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'typography_header_slect_entries',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-table-style .dataTables_length label select',
                    'condition'=>[
                        'show_datatable_paging'=>'yes',
                    ]
                ]
            );
            $this->start_controls_tabs('entries_style_tabs');

            $this->start_controls_tab(
                'entries_style_normal_tab',
                [
                    'label' => __( 'Normal', 'htmega-pro' ),
                ]
            );

                $this->add_control(
                    'datatable_sorting_length_text_color_header',
                    [
                        'label' => esc_html__( 'Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '',
                        'selectors' => [
                            '{{WRAPPER}} .htmega-table-style .dataTables_length label select' => 'color: {{VALUE}};',
                        ],
                        'condition'=>[
                            'show_datatable_paging'=>'yes',
                        ]
                    ]
                );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'datatable_sorting_length_typography_background_color_header',
                        'label' => __( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'selector' => '{{WRAPPER}} .htmega-table-style .dataTables_length label select',
                        'condition'=>[
                            'show_datatable_paging'=>'yes',
                        ]
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                        [
                        'name' => 'datatable_sorting_length_border_header',
                        'label' => esc_html__( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-table-style .dataTables_length label select',
                        'condition'=>[
                            'show_datatable_paging'=>'yes',
                        ]
                    ]
                );

            $this->end_controls_tab(); // Normal Tab end

            $this->start_controls_tab(
                'entries_style_hover_tab',
                [
                    'label' => __( 'Focus', 'htmega-pro' ),
                ]
            );
                $this->add_control(
                    'entries_hover_color',
                    [
                        'label' => __( 'Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-table-style .dataTables_length label select:hover,{{WRAPPER}} .htmega-table-style .dataTables_length label select:focus' => 'color: {{VALUE}}',
                        ],
                    ]
                );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'entries_hover_background',
                        'label' => __( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'selector' => '{{WRAPPER}} .htmega-table-style .dataTables_length label select:hover,{{WRAPPER}} .htmega-table-style .dataTables_length label select:focus',
                        'exclude' =>['image'],
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'entries_hover_border',
                        'label' => __( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-table-style .dataTables_length label select:hover,{{WRAPPER}} .htmega-table-style .dataTables_length label select:focus',
                    ]
                );

            $this->end_controls_tab(); // Hover Tab end

        $this->end_controls_tabs();
        $this->end_controls_section();
        // Info section
        $this->start_controls_section(
            'info_style_section',
                [
                    'label' => __( 'Info Style', 'htmega-pro' ),
                    'tab' => Controls_Manager::TAB_STYLE,
                    'condition'=>[
                        'show_datatable_info'=>'yes',
                    ]
                ]
            );
            $this->add_control(
                'datatable_sorting_text_color_footer',
                [
                    'label' => esc_html__( 'Text Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style .dataTables_info' => 'color: {{VALUE}};',
                    ],
                    'condition'=>[
                        'show_datatable_info'=>'yes',
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'datatable_sorting_typography_footer',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-table-style .dataTables_info',
                    'condition'=>[
                        'show_datatable_info'=>'yes',
                    ]
                ]
            );
            $this->add_responsive_control(
                'info_top_space',
                [
                    'label' => esc_html__( 'Top Space', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 0,
                    'max' => 300,
                    'step' => 1,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style .dataTables_info' => 'padding-top: {{VALUE}}px',
                    ],
                ]
            );
        $this->end_controls_section();

        // Search Box Style section
        $this->start_controls_section(
            'search_box_style_section',
                [
                    'label' => __( 'Search Box', 'htmega-pro' ),
                    'tab' => Controls_Manager::TAB_STYLE,
                    'condition'=>[
                        'show_datatable_searching'=>'yes',
                    ]
                ]
            );
            $this->add_responsive_control(
                'search_box_space_bottom',
                [
                    'label' => esc_html__( 'Bottom Space', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 0,
                    'max' => 300,
                    'step' => 1,
                    'default' => 0,
                    'selectors' => [
                        '{{WRAPPER}} .dataTables_filter' => 'margin-bottom: {{VALUE}}px',
                    ],
                ]
            );
            $this->add_control(
                'search_box_label',
                [
                    'label' => __( 'Label Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style .dataTables_filter label' => 'color: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'search_box_typography_label',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-table-style .dataTables_filter label',
                ]
            );
            $this->add_control(
                'search_box_input_heading',
                [
                    'label' => esc_html__( 'Input Box', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',

                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'search_box_typography',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-table-style .dataTables_wrapper .dataTables_filter input',
                ]
            );

            $this->add_responsive_control(
                'search_box_padding',
                [
                    'label' => __( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style .dataTables_wrapper .dataTables_filter input' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->start_controls_tabs('search_box_style_tabs');

                $this->start_controls_tab(
                    'search_box_style_normal_tab',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                );

                    $this->add_control(
                        'search_box_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-table-style .dataTables_wrapper .dataTables_filter input' => 'color: {{VALUE}};',
                            ],
                        ]
                    );


                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'search_box_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-table-style .dataTables_wrapper .dataTables_filter input',
                            'exclude' =>['image'],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'search_box_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-table-style .dataTables_wrapper .dataTables_filter input',
                        ]
                    );

                    $this->add_responsive_control(
                        'search_box_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-table-style .dataTables_wrapper .dataTables_filter input' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );


                $this->end_controls_tab(); // Normal Tab end

                $this->start_controls_tab(
                    'search_box_style_hover_tab',
                    [
                        'label' => __( 'Focus', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'search_box_hover_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-table-style .dataTables_wrapper .dataTables_filter input:hover,{{WRAPPER}} .htmega-table-style .dataTables_wrapper .dataTables_filter input:focus' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'search_box_hover_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-table-style .dataTables_wrapper .dataTables_filter input:hover,{{WRAPPER}} .htmega-table-style .dataTables_wrapper .dataTables_filter input:focus',
                            'exclude' =>['image'],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'search_box_hover_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-table-style .dataTables_wrapper .dataTables_filter input:hover,{{WRAPPER}} .htmega-table-style .dataTables_wrapper .dataTables_filter input:focus',
                        ]
                    );

                    $this->add_responsive_control(
                        'search_box_hover_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-table-style .dataTables_wrapper .dataTables_filter input:hover,{{WRAPPER}} .htmega-table-style .dataTables_wrapper .dataTables_filter input:focus' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab(); // Hover Tab end

            $this->end_controls_tabs();

        $this->end_controls_section();
         // Table Pagination Style tab section
         $this->start_controls_section(
            'htmega_table_sorting_style_section',
            [
                'label' => __( 'Pagination Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition'=>[
                    'show_datatable_paging'=>'yes',
                ]
            ]
        );

        
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'datatable_pagination_typography',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-table-style .dataTables_paginate a.paginate_button',
                ]
            );
            $this->add_responsive_control(
                'paginat_top_space',
                [
                    'label' => esc_html__( 'Top Space', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 0,
                    'max' => 300,
                    'step' => 1,
                    'default' => 0,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style .dataTables_paginate' => 'margin-top: {{VALUE}}px',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                    [
                    'name' => 'paginat_active_border_box',
                    'label' => esc_html__( 'Pagination Box Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-table-style .dataTables_wrapper .dataTables_paginate',
                ]
            );
            $this->add_responsive_control(
                'paginat_active_border_box_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-table-style .dataTables_wrapper .dataTables_paginate' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'pagination_box_bg',
                    'label' => __( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic','gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-table-style .dataTables_wrapper .dataTables_paginate',
                ]
            );
            $this->start_controls_tabs('paginat_style_tabs');

                $this->start_controls_tab(
                    'paginat_style_normal_tab',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                );

                    $this->add_control(
                        'datatable_pagination_text_color',
                        [
                            'label' => esc_html__( 'Text Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .htmega-table-style .dataTables_paginate a.paginate_button' => 'color: {{VALUE}} !important;',
                            ],
                        ]
                    );
                
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'datatable_pagination_background_color',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-table-style .dataTables_paginate span a.paginate_button,
                            {{WRAPPER}} .htmega-table-style .dataTables_paginate a.paginate_button',
                        ]
                    );
        
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                            [
                            'name' => 'datatable_pagination_border_header',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-table-style .dataTables_paginate span a.paginate_button,{{WRAPPER}} .htmega-table-style .dataTables_paginate a.paginate_button',
                        ]
                    );
                $this->end_controls_tab(); // Normal Tab end

                $this->start_controls_tab(
                    'paginat_style_hover_tab',
                    [
                        'label' => __( 'Active', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'datatable_pagination_text_active_color',
                        [
                            'label' => esc_html__( 'Text Active Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .htmega-table-style .dataTables_paginate span a.paginate_button.current,
                                {{WRAPPER}} .htmega-table-style .dataTables_paginate a.paginate_button:not(.disabled):hover' => 'color: {{VALUE}} !important;',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'paginat_active_bg',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-table-style .dataTables_paginate span a.paginate_button.current,
                            {{WRAPPER}} .htmega-table-style .dataTables_paginate a.paginate_button:not(.disabled):hover',
                        ]
                    );
        
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                            [
                            'name' => 'paginat_active_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-table-style .dataTables_paginate span a.paginate_button.current,
                            {{WRAPPER}} .htmega-table-style .dataTables_paginate a.paginate_button:not(.disabled):hover',
                        ]
                    );

                $this->end_controls_tab(); // Hover Tab end

            $this->end_controls_tabs();


        $this->end_controls_section();


        // Style Export Data button tab section
        $this->start_controls_section(
            'export_data_style_section',
                [
                    'label' => __( 'Export Data Button', 'htmega-pro' ),
                    'tab' => Controls_Manager::TAB_STYLE,
                    'condition'=>[
                        'export_data'=>'yes',
                        'export_button_text!' => '',
                    ]
                ]
            );
            $this->start_controls_tabs('export_data_style_tabs');

                $this->start_controls_tab(
                    'export_data_style_normal_tab',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                );

                    $this->add_control(
                        'export_data_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-table-export-btn' => 'color: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'export_data_typography',
                            'label' => __( 'Typography', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-table-export-btn',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'export_data_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-table-export-btn',
                            'exclude' =>['image'],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'export_data_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-table-export-btn',
                        ]
                    );

                    $this->add_responsive_control(
                        'export_data_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-table-export-btn' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'export_data_padding',
                        [
                            'label' => __( 'Padding', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-table-export-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'export_data_margin',
                        [
                            'label' => __( 'Margin', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-table-export-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'export_data_margin_alignment',
                        [
                            'label'   => esc_html__( 'Alignment', 'htmega-pro' ),
                            'type'    => Controls_Manager::CHOOSE,
                            'options' => [
                                'left'    => [
                                    'title' => esc_html__( 'Left', 'htmega-pro' ),
                                    'icon'  => 'eicon-text-align-left',
                                ],
                                'right' => [
                                    'title' => esc_html__( 'Right', 'htmega-pro' ),
                                    'icon'  => 'eicon-text-align-right',
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-table-export-btn'   => 'float: {{VALUE}};',
                            ],
                        ]
                    );
                $this->end_controls_tab(); // Normal Tab end

                $this->start_controls_tab(
                    'export_data_style_hover_tab',
                    [
                        'label' => __( 'Hover', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'export_data_hover_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-table-export-btn:hover' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'export_data_hover_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-table-export-btn:hover',
                            'exclude' =>['image'],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'export_data_hover_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-table-export-btn:hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'export_data_hover_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-table-export-btn:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab(); // Hover Tab end

            $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render( $instance = [] ) {

        $settings   = $this->get_settings_for_display();
        $id = $this->get_id();
        $settings['export_data'];
        if ( 'yes' == $settings['export_table_data_visitor'] ){
            $settings['export_data'] = 'yes';
        } else {
            $settings['export_data'] = 'no';
           if( is_admin() == true ) {
            $settings['export_data'] = 'yes';
           }
        }
        

        $this->add_render_attribute( 'datatable_attr', 'class', 'htmega-table-style htmega-table-style-' . esc_attr( $settings['datatable_style'] ) );

        if( $settings['show_datatable_sorting'] != 'yes' ){
            $this->add_render_attribute( 'datatable_attr', 'class', 'htb-table-responsive' );
        }

        $table_tr = array();
        $table_td = array();
        if ( $settings['content_list'] ) {
            foreach( $settings['content_list'] as $content_row ) {

                $row_id = uniqid();
                if( $content_row['field_type'] == 'row' ) {
                    $table_tr[] = [
                        'id' => $row_id,
                        'type' => $content_row['field_type'],
                    ];
                }
                if( $content_row['field_type'] == 'col' ) {

                    $table_tr_keys = array_keys( $table_tr );
                    $last_key = end( $table_tr_keys );
                    //Elementor template
                    if( 'template' == $content_row['cell_data_type'] && ( !empty( $content_row['content_temp'] ) || !empty( $content_row['live_temp_content'] )) ){
                        $temp_id = '';
                        if( !empty( $content_row['content_temp'] ) ){
                            $temp_id = $content_row['content_temp'];
                        } else{
                            $temp_id = htmega_get_template_id_by_title( $content_row['live_temp_content'] );
                            $temp_id = !empty( $temp_id ) ? $temp_id : $content_row['live_temp_content']; 
                        }                    
                        $table_cell_data =  htmega_get_template_content_by_id( $temp_id );
                    
                     //Image Control
                    } elseif( isset($content_row['cell_image']) ){
                        $table_cell_data = Group_Control_Image_Size::get_attachment_image_html( $content_row, 'large', 'cell_image' );
                    
                    //Icon Control
                    } elseif ( isset( $content_row['cell_icon'] ) ){
                        $table_cell_data = '<div class="elementor-repeater-item-' . esc_attr( $content_row['_id'] ) . '">' . HTMega_Icon_manager::render_icon( $content_row['cell_icon'], [ 'aria-hidden' => 'false' ] ) . '</div>';
                    
                    //Text Control
                    } else {
                        $table_cell_data = $content_row['cell_text'];
                    }
                    
                    $table_td[] = [
                        'row_id' => $table_tr[$last_key]['id'],
                        'title' => $table_cell_data,
                        'colspan' => $content_row['row_colspan'],
                        'content_sal_id' => $content_row['_id'],
                    ];
                }

            }
        }

        ?>
        <div <?php echo $this->get_render_attribute_string( 'datatable_attr' ); ?>>
            <table id="<?php echo esc_attr( "table_id_".$id ); ?>" class="htb-table <?php if( $settings['show_datatable_sorting'] == 'yes' ){ echo 'htmega-datatable-'.esc_attr( $id ); } ?>">
                <?php
                if( 'csv' == $settings['content_source'] ){
                    $csv_file_data = array();
                    if( 'url' == $settings['source_type'] && filter_var( $settings['remote_csv_file'] ) ){
                       $csv_file_data = wp_remote_get( $settings['remote_csv_file'] );

                    } else {

                        if( !empty( $settings['uploaded_csv_file']['url'] ) ){
                            $csv_file_data = wp_remote_get( $settings['uploaded_csv_file']['url'] );
                        }
                    }
                   
                    $this->get_csv_file_data( $csv_file_data );

                } elseif ( 'google' == $settings['content_source'] ) {
                    $this->get_google_sheet_data( $id );

                } elseif ( 'table_press' == $settings['content_source'] ) {
                    $this->get_table_press_file_data();
                } elseif ( 'database' == $settings['content_source'] ) {
                    $this->get_database_table_data();
                } else {
                    
                    if( $settings['header_column_list'] ): ?>
                        <thead>
                            <tr>
                                <?php
                                    foreach ( $settings['header_column_list'] as $headeritem ) {
                                        echo "<th class='elementor-repeater-item-". esc_attr( $headeritem['_id'] )."'>" . wp_kses_post( $headeritem['column_name'] ) . '</th>';
                                    }
                                ?>
                            </tr>
                        </thead>
                    <?php endif;


                    $table_html = '';
                    for ($i = 0, $tr_count = count($table_tr); $i < $tr_count; $i++) {
                        $table_html .= '<tr>';
                        for ($j = 0, $td_count = count($table_td); $j < $td_count; $j++) {
                            if ($table_tr[$i]['id'] == $table_td[$j]['row_id']) {
                                $table_html .= sprintf(
                                    '<td class="elementor-repeater-item-%1$s" %2$s>%3$s</td>',
                                    esc_attr($table_td[$j]['content_sal_id']),
                                    ($table_td[$j]['colspan'] > 1) ? ' colspan="' . esc_attr($table_td[$j]['colspan']) . '"' : '',
                                    wp_kses_post($table_td[$j]['title'])
                                );
                            }
                        }
                        $table_html .= '</tr>';
                    }

                    echo '<tbody>' . $table_html . '</tbody>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                } ?>

            </table>
            <?php if ( 'yes' == $settings['export_data'] && !empty( $settings['export_button_text'] ) ){ ?>
                <div id="downloadID_<?php echo esc_attr( $id );?>" class="htmega-table-export-btn" ><?php echo esc_html( $settings['export_button_text'] ); ?></div>
            <?php } ?>
        </div>
        <?php if( $settings['show_datatable_sorting'] == 'yes' ): 

        $display_options    = '10, 25, 50, 100';
        $show_all_num       = '';
        $show_all_text      = '';
        $default_row_number = 10;
            if( 'yes' == $settings['custom_display_row'] && !empty( $settings['display_options'] ) ){
                $display_options = $settings['display_options'];
            }
            if( 'yes'== $settings['show_all_button'] && !empty( $settings['show_all_text'] ) ){
                $show_all_text = " ,'".esc_html($settings['show_all_text'])."'";
                $show_all_num =', -1';
            }
            if(!empty($settings['default_row_number'])){
                $default_row_number = $settings['default_row_number'];
            }
            ?>

            <script>
                jQuery(document).ready(function($) {
                    'use strict';
                    $('.htmega-datatable-<?php echo esc_attr( $id ); ?>').DataTable({
                        paging: <?php echo esc_js(( $settings['show_datatable_paging'] == 'yes' ) ? 'true' : 'false'); ?>,
                        searching: <?php echo esc_js(( $settings['show_datatable_searching'] == 'yes' ) ? 'true' : 'false'); ?>,
                        ordering:  <?php echo esc_js(( $settings['show_datatable_ordering'] == 'yes' ) ? 'true' : 'false'); ?>,
                        info: <?php echo esc_js(( $settings['show_datatable_info'] == 'yes' ) ? 'true' : 'false'); ?>,
                        pageLength: <?php echo esc_js($default_row_number ); ?>,
                        lengthMenu: [ [<?php echo esc_js( $display_options ).$show_all_num;?>], [<?php echo esc_js( $display_options ).$show_all_text;?>] ],
                        oLanguage: {
                            sSearch: "<?php echo wp_kses_post( $settings['search_label'] ); ?>",
                            oPaginate: {
                                sPrevious: "<?php echo wp_kses_post( $settings['paginate_prev_label'] ); ?>",
                                sNext: "<?php echo wp_kses_post( $settings['paginate_next_label'] ); ?>"
                            },
                            sInfo: "<?php echo esc_html( $settings['paginate_info_label'] ); ?>",
                            sLengthMenu:"<?php echo esc_html( $settings['menu_lenght_label'] ); ?>",
                            sInfoEmpty:      "<?php echo esc_html( $settings['empty_info_label'] ); ?>",
                            sInfoFiltered:   "<?php echo esc_html( $settings['filtered_info_label'] ); ?>",
                            sZeroRecords:    "<?php echo esc_html( $settings['no_match_info_label'] ); ?>",
                            
                        },
                    });

                 });
            </script>
        <?php endif;
        if ( 'yes' == $settings['export_data'] && !empty( $settings['export_button_text'] ) ){ ?>
            <script>
                jQuery(document).ready(function($) {
                    'use strict';
                    // Get the table data
                    var table = document.getElementById('<?php echo esc_js( "table_id_".$id ) ?>');
                    var data = [];

                    for (var i = 0; i < table.rows.length; i++) {
                        var row = table.rows[i];
                        var rowData = [];
                        
                        for ( var j = 0; j < row.cells.length; j++ ) {
                            rowData.push(row.cells[j].innerText);
                        }
                        
                        data.push(rowData.join(","));
                    }
                    // Create the CSV file
                    var csv = data.join("\n");
                    var filename = 'htmega-data-table-<?php echo esc_js( $id ); ?>.csv';

                    // Add download functionality to button
                    var downloadBtn = document.getElementById("downloadID_<?php echo esc_js( $id );?>");
                    downloadBtn.addEventListener("click", function() {
                        var link = document.createElement("a");
                        link.setAttribute("href", "data:text/csv;charset=utf-8," + encodeURIComponent(csv));
                        link.setAttribute("download", filename);
                        link.style.display = "none";
                        document.body.appendChild(link);
                        link.click();
                        document.body.removeChild(link);
                    });

                });
            </script>
        <?php
        }
    }


    /**
     * Get Database data
     *
     * @param [type] $get_database_table_data
     * @return void array
     */
    protected function get_database_table_data( ) {
        $settings      = $this->get_settings_for_display();
        global $wpdb;

		$tbl_name = $settings["database_tbl_list"];
		if ( empty( $tbl_name ) ) {
            echo "<div class='htmega-error-notice'>".esc_html__('Please select a table!','htmega-pro')."</div>";
            return;
		}
		$database_tbl = $wpdb->get_results("SELECT * FROM $tbl_name", ARRAY_A);

		if (!$database_tbl ) {

            echo "<div class='htmega-error-notice'>".esc_html__('No data found!','htmega-pro')."</div>";
            return;
		}
		if ( is_wp_error( $database_tbl ) ) {
            
            echo "<div class='htmega-error-notice'>".esc_html( $database_tbl->get_error_message() )."</div>";
            return;
		}
        
        if( $database_tbl ): 
                if( $database_tbl[0] ){ ?>
                <thead>
                    <tr>
                        <?php foreach ( array_keys( $database_tbl[0] ) as $key => $td ) :
                            echo "<th class='htmega-data-item". esc_attr( $key )."'>".wp_kses_post( $td ).'</th>';
                                endforeach; ?>
                    </tr>
                </thead>
            <?php }; ?>
            <tbody>
                <?php 
                    //unset( $database_tbl[0] );
                    if( $database_tbl ) {
                        foreach( $database_tbl as $tr ) {
                            echo '<tr>';
                                foreach( $tr as $key => $td ) {
                                    echo "<td class='htmega-table-sel--". esc_attr( strtolower( $key ) )."'>".wp_kses_post( $td ).'</td>';
                                }
                            echo '</tr>';
                        }
                    }
                    ?>
            </tbody>

        <?php else :
                echo "<div class='htmega-error-notice'>".esc_html__('No data found!','htmega-pro')."</div>";
            endif;
    }


    /**
     * Get TablePress data
     *
     * @param [type] $get_table_press_file_data
     * @return void array
     */
    protected function get_table_press_file_data( ) {
        $settings      = $this->get_settings_for_display();

		if ( !class_exists('TablePress') ) {
            echo "<div class='htmega-error-notice'>".esc_html__('Please Install TablePress.','htmega-pro')."</div>";
            return;
		}
		if ( empty( htmega_get_table_press_tbl_list() ) ) {
			echo "<div class='htmega-error-notice'>".esc_html__('Create Table.','htmega-pro')."</div>";
            return;
		}
		if ( empty( $settings['table_press_table_list'] ) ) {
			echo "<div class='htmega-error-notice'>".esc_html__('Please select a table!','htmega-pro')."</div>";
            return;
		}

		$tbl_data = [];
		$tbl_option = get_option( 'tablepress_tables', '{}' );
        $tables_opt = json_decode( $tbl_option, true );
		$tbl_data = $tables_opt['table_post'];
        $tbl_id = $tbl_data[$settings['table_press_table_list']];
        $get_data = get_post_field( 'post_content', $tbl_id );
		$tbl_data = json_decode( $get_data, true );

        if ( $tbl_data ){

            if( $tbl_data ): 
                    if( $tbl_data[0] ){ ?>
                    <thead>
                        <tr>
                            <?php foreach ( $tbl_data[0] as $key => $column ) : 
                            echo "<th class='htmega-data-item". esc_attr( $key )."'>".wp_kses_post( $column ).'</th>';
                             endforeach; ?>
                        </tr>
                    </thead>
                <?php }; ?>
                <tbody>
                    <?php 
                        unset( $tbl_data[0] );
                        if( $tbl_data ) {
                            foreach( $tbl_data as $tr ) {
                                echo '<tr>';
                                    foreach( $tr as $key => $td ) {
                                        echo "<td class='htmega-table-sel--". esc_attr( strtolower( $key ) )."'>".wp_kses_post( $td ).'</td>';
                                    }
                                echo '</tr>';
                            }
                        }
                        ?>
                </tbody>

            <?php else :
                    echo "<div class='htmega-error-notice'>".esc_html__('No data found!','htmega-pro')."</div>";
                endif;
        }
    }
    
    /**
     * Get CSV data
     *
     * @param [type] $csv_file_data
     * @return void array
     */
    protected function get_csv_file_data( $csv_file_data = null ) {
        $settings      = $this->get_settings_for_display();
        $csv_separator = $settings['csv_separator'] ? $settings['csv_separator'] : ',' ;
       if( !is_array( $csv_file_data ) || empty( $csv_file_data ) ){
            echo "<div class='htmega-error-notice'>".esc_html__('Please upload CSV file.','htmega-pro')."</div>";
            return;
       }

        if ( 200 ===  wp_remote_retrieve_response_code( $csv_file_data ) ){

            $data = str_getcsv( $csv_file_data['body'], "\n" );
            if( count( $data ) > 1  && $data  && 'text/csv' === $csv_file_data['headers']['content-type'] ): 
                    if( $data[0] ){ ?>
                    <thead>
                        <tr>
                            <?php
                                foreach( str_getcsv( $data[0], $csv_separator ) as $key=> $th ) {
                                    echo "<th class='htmega-data-item". esc_attr( $key )."'>".wp_kses_post( $th ).'</th>';
                                }
                            ?>
                        </tr>
                    </thead>
                <?php }; ?>
                <tbody>
                    <?php 
                        unset( $data[0] );
                        if( $data ){
                            foreach( $data as $tr ) {
                                $tr = str_getcsv( $tr, $csv_separator );
                                echo '<tr>';
                                    foreach( $tr as $key => $td ) {
                                        echo "<td class='htmega-table-sel--". esc_attr( strtolower( $key ) )."'>".wp_kses_post( $td ).'</td>';
                                    }
                                echo '</tr>';
                            }
                        }
                        ?>
                </tbody>

            <?php else :
                    echo "<div class='htmega-error-notice'>".esc_html__('No data found! Please upload valid CSV file.','htmega-pro')."</div>";
                endif;
        }
    }

    /**
     * Get Google sheet data
     *
     * @param [type] $sid
     * @return HTML
     */

     protected function get_google_sheet_data( $sid ) {

        $settings = $this->get_settings_for_display();
        $schedule_update_days = ( $settings['clear_cache_data_after'] ) ? absint( $settings['clear_cache_data_after'] ) : 7;
    
        $google_api_key = sanitize_text_field( $settings['google_api_key'] );
        $google_sheet_id = sanitize_text_field( $settings['google_sheet_id'] );
        $google_sheet_range = sanitize_text_field( $settings['google_sheet_range'] );
    
        if ( false === get_transient( 'google_sheet_transient'.$sid ) ) {
            $expire = 86400 * $schedule_update_days;
            $sheet_info_url = "https://sheets.googleapis.com/v4/spreadsheets/{$google_sheet_id}/values/{$google_sheet_range}?dateTimeRenderOption=FORMATTED_STRING&majorDimension=ROWS&valueRenderOption=FORMATTED_VALUE&key={$google_api_key}";
    
            $response = wp_remote_get( $sheet_info_url );
    
            if ( is_wp_error( $response ) ) {
                // Handle error
                $error_message = $response->get_error_message();
                echo sprintf( // translators: %s is replaced with the error message. Example: "Something went wrong: File not found."
                    esc_html__( 'Something went wrong: %s', 'htmega-pro' ), 
                    esc_html( $error_message )
                );
                return;
            }
    
            $google_sheet_data = wp_remote_retrieve_body( $response );
            set_transient( 'google_sheet_transient'.$sid, $google_sheet_data, $expire );
        }
    
        $google_sheet_all_data = get_transient( 'google_sheet_transient'.$sid );
        $google_sheet_all_data = json_decode($google_sheet_all_data, true);
    
        if ( 'yes' == $settings['remove_cache'] ) {
            delete_transient( 'google_sheet_transient'.$sid );
            $google_sheet_all_data['error']['message'] = __( 'Please turn Off the "Remove Cache" switcher','htmega-pro' );
        }
    
        if ( isset( $google_sheet_all_data['error'] ) ) {
            delete_transient( 'google_sheet_transient'.$sid );
        }
    
        if ( empty( $google_api_key ) || empty( $google_sheet_id ) || empty( $google_sheet_range ) ) {
            delete_transient( 'google_sheet_transient'.$sid );
            $google_sheet_all_data['error']['message'] = __( 'Must be enter valid info in the Google API, Spreadsheet ID and Spreadsheet Range fields', 'htmega-pro' );
        }
    
        if ( 'yes' != $settings['remove_cache'] && !isset( $google_sheet_all_data['error'] ) ) {
    
            $table_header = $google_sheet_all_data['values'][0];
            $table_body = array_splice( $google_sheet_all_data['values'], 1, count( $google_sheet_all_data['values'] ) );
    
            if ( !empty( $table_header ) ) { ?>
                <thead>
                    <tr>
                        <?php
                        foreach ( $table_header as $key => $th ) {
                            echo "<th class='elementor-repeater-item-". esc_attr( $key ) ."'>". wp_kses_post( $th ) .'</th>';
                        }
                        ?>
                    </tr>
                </thead>
            <?php }; ?>
            <tbody>
                <?php 
                for ( $i = 0; $i < count( $table_body ); $i++ ) :
                    if ( count( $table_header ) > count( $table_body[$i] ) ) {
                        $differ = count( $table_header ) - count( $table_body[$i] );
    
                        for ( $j = 0; $j < $differ; $j++ ) {
                            array_push( $table_body[$i], null );
                        }
                    }
                ?>
                <tr>
                    <?php
                    foreach ( $table_body[$i] as $key => $td ) :
                        echo "<td class='htmega-table-sel-". esc_attr( strtolower( $key ) ) ."'>". wp_kses_post( $td ) .'</td>';
                    endforeach; ?>
                </tr>
                <?php endfor; ?>
            </tbody>
            <?php
        } else {
            echo "<div class='htmega-error-notice'>". esc_html( $google_sheet_all_data['error']['message'] ) ."</div>";
            delete_transient( 'google_sheet_transient'.$sid );
        }
    }
    
}

