<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\HTMega_Icon_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
use Elementor\Repeater;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Event_Box_Element extends Widget_Base {
    public function get_name() {
        return 'htmega-event-box-addons';
    }
    
    public function get_title() {
        return esc_html__( 'Event Box', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-table-of-contents';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }
    public function get_keywords() {
        return [ 'htmega', 'ht mega', 'event box', 'event', 'box',',htmega pro' ];
    }

    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/general-widgets/event-box-widget/';
	}
    protected function is_dynamic_content():bool {
		return false;
	}
    protected function register_controls() {
        $this->_general_controls();
        $this->_style_controls();
    }

    protected function _general_controls(){ 
        $this->__event_box_data_section();
        $this->__event_box_repater_item_section();
        $this->__event_box_additional_options_section();
    }

    protected function __event_box_data_section(){

        $this->start_controls_section(
            'event_box_section',
            [
                'label' => esc_html__( 'Event Box', 'htmega-pro' ),
            ]
        );

            $this->add_control(
                'event_layout_Style',
                [
                    'label' => esc_html__('Style', 'htmega-pro'),
                    'type' => Controls_Manager::SELECT,
                    'default' => '1',
                    'options' => [
                        '1' => esc_html__('Style One', 'htmega-pro'),
                        '2' => esc_html__('Style Two', 'htmega-pro'),
                        '3' => esc_html__('Style Three', 'htmega-pro'),
                        '4' => esc_html__('Style Four', 'htmega-pro'),
                        '5' => esc_html__('Style Five', 'htmega-pro'),
                    ],
                ]
            );

            $this->add_control(
                'event_image_position',
                [
                    'label'   => esc_html__( 'Event Image Position', 'htmega-pro' ),
                    'type'    => Controls_Manager::CHOOSE,
                    'toggle' => false,
                    'options' => [
                        'row' => [
                            'title' => esc_html__('Left', 'htmega-pro'),
                            'icon' => 'eicon-h-align-left',
                        ],
                        'row-reverse' => [
                            'title' => esc_html__('Right', 'htmega-pro'),
                            'icon' => 'eicon-h-align-right',
                        ],
                        
                    ],
                    'default' => 'center',
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card.htmega-event-box-card-5' => 'flex-direction: {{VALUE}}',
                    ],
                    'condition' => [
                        'event_layout_Style' => '5',
                    ]
                ]
            );

            $this->add_control(
                'event_image',
                [
                    'label' => esc_html__('Event Image','htmega-pro'),
                    'type'=>Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src(),
                    ],
                    'dynamic' => [
                        'active' => true,
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'event_image_size',
                    'default' => 'full',
                    'condition' => [
                        'event_bg_image[url]!' => '',
                    ]
                ]
            );

            $this->add_control(
                'event_title',
                [
                    'label' => esc_html__( 'Title', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default' => esc_html__( 'There many variant majority have suffered.', 'htmega-pro' ),
                    'separator' => 'before',
                    'dynamic' => [
                        'active' => true,
                    ],
                ]
            );
            
            $this->add_control(
                'event_description',
                [
                    'label' => esc_html__( 'Description', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'rows' => 5,
                    'dynamic' => [
                        'active' => true,
                    ]
                ]
            );

            $this->add_control(
                'event_button_text',
                [
                    'label' => esc_html__( 'Button Text', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default' => esc_html__( 'Learn More', 'htmega-pro' ),
                    'separator' => 'before',
                    'dynamic' => [
                        'active' => true,
                    ],
                ]
            );

            $this->add_control(
                'event_button_link',
                [
                    'label' => esc_html__( 'Button Link', 'htmega-pro' ),
                    'type' => Controls_Manager::URL,
                    'placeholder' => 'https://example.com',
                    'dynamic' => [
                        'active' => true,
                    ],
                    'default' => [
                        'url' => '#',
                    ]
                ]
            );

            $this->add_control(
                'event_button_show',
                [
                    'label' => esc_html__( 'Use Button Icon?', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Show', 'htmega-pro' ),
                    'label_off' => esc_html__( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );

            $this->add_control(
                'event_button_icon',
                [
                    'label' => esc_html__( 'Icon', 'htmega-pro' ),
                    'type'  => Controls_Manager::ICONS,
                    'default' => [
                        'value' => 'fas fa-angle-double-right',
                        'library' => 'fa-solid',
                    ],
                    'condition'=>[
                        'event_button_show' => 'yes'
                    ],
                ]
            );

            $this->add_control(
                'event_footer_text',
                [
                    'label' => esc_html__( 'Footer Text', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default' => esc_html__( 'Sale ends soon', 'htmega-pro' ),
                    'separator' => 'before',
                    'dynamic' => [
                        'active' => true,
                    ],
                    'condition' => [
                        'event_layout_Style!' => '5',
                    ]
                ]
            );
        
        $this->end_controls_section(); 
    }

    protected function __event_box_repater_item_section(){

        $this->start_controls_section(
            'event_item_section',
            [
                'label' => esc_html__( 'Event Meta Info', 'htmega-pro' ),
            ]
        );

            $repeater = new Repeater();

            $repeater->add_control(
                'item_icon',
                [
                    'label'       => esc_html__( 'Icon', 'htmega-pro' ),
                    'type'        => Controls_Manager::ICONS,
                    'label_block' => true,
                    'default' => [
                        'value' => 'fa fa-calendar-alt',
                        'library' => 'fa-solid',
                    ],
                ]
            );

            $repeater->add_control(
                'item_content',
                [
                    'label' => esc_html__( 'Content', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'rows' => 2,
                    'description' => esc_html__( 'Put the highlighted word in between the span tags!', 'htmega-pro')

                ]
            );

            $this->add_control(
                'event_item',
                [
                    'label' => esc_html__( 'Add Event Meta', 'htmega-pro' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                    'prevent_empty' => false,
                    'default' => [
                        [
                            'item_icon' =>[
                                'value' => 'fa fa-calendar-alt',
                                'library' => 'fa-solid',
                            ],
                            'item_content' => esc_html__( '22 November, 2022', 'htmega-pro' ),
                        ],
                        [
                            'item_icon' =>[
                                'value' => 'fa fa-location-arrow',
                                'library' => 'fa-solid',
                            ],
                            'item_content' => esc_html__( 'USA', 'htmega-pro' ),
                        ],
                        [
                            'item_icon' =>[
                                'value' => 'fa fa-clock',
                                'library' => 'fa-solid',
                            ],
                            'item_content' => esc_html__( '10:00 - 18:00', 'htmega-pro' ),
                        ]
                    ],
                    'title_field' => '<i class="{{ item_icon.value }}" aria-hidden="true"></i> {{{ item_content }}}',
                ]
            );
            
        $this->end_controls_section(); 
    }

    protected function __event_box_additional_options_section(){

        $this->start_controls_section(
            'event_additional_options_section',
            [
                'label' => esc_html__( 'Additional Options', 'htmega-pro' ),
            ]
        );
            $this->add_control(
                'event_title_tag',
                [
                    'label' => esc_html__('Select Title Tag', 'htmega-pro'),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'h2',
                    'options' => htmega_html_tag_lists(),
                    'condition' => [
                        'event_title[value]!' =>'',
                    ]
                ]
            );

            $this->add_control(
                'show_title_separator_swtcher',
                [
                    'label' => esc_html__( 'Item Separator', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Show', 'htmega-pro' ),
                    'label_off' => esc_html__( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );

            $this->add_control(
                'date_and_month_information',
                [
                    'label' => esc_html__( 'Date and Month Information', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'show_date_and_month_swtcher',
                [
                    'label' => esc_html__( 'Show Date and Month', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Show', 'htmega-pro' ),
                    'label_off' => esc_html__( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );


            $this->add_control(
                'event_date_and_month_style',
                [
                    'label' => esc_html__('Date and Month Style', 'htmega-pro'),
                    'type' => Controls_Manager::SELECT,
                    'default' => '1',
                    'options' => [
                        '1' => esc_html__('Style One', 'htmega-pro'),
                        '2' => esc_html__('Style Two', 'htmega-pro'),
                    ],
                    
                    'condition' => [
                        'show_date_and_month_swtcher' => 'yes',
                    ]
                ]
            );

            $this->add_control(
                'event_date_number',
                [
                    'label' => esc_html__( 'Date Number', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 22,
                    'dynamic' => [
                        'active' => true,
                    ],
                    'condition' => [
                        'show_date_and_month_swtcher' => 'yes',
                    ]
                ]
            );

            $this->add_control(
                'event_date_month',
                [
                    'label' => esc_html__( 'Date Month', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__( 'March', 'htmega-pro' ),
                    'dynamic' => [
                        'active' => true,
                    ],
                    'condition' => [
                        'show_date_and_month_swtcher' => 'yes',
                    ]
                ]
            );

            $this->add_control(
                'event_organizer_information_header',
                [
                    'label' => esc_html__( 'Organizer Information', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'show_event_organizer_information',
                [
                    'label' => esc_html__( 'Show Organizer', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Show', 'htmega-pro' ),
                    'label_off' => esc_html__( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );

            $this->add_control(
                'event_organizer_text',
                [
                    'label' => esc_html__( 'Organizer Text:', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__( 'Organize By', 'htmega-pro' ),
                    'dynamic' => [
                        'active' => true,
                    ],
                    'condition' => [
                        'show_event_organizer_information' => 'yes',
                    ]
                ]
            );
            
            $this->add_control(
                'event_organizer',
                [
                    'label' => esc_html__( 'Organizer By:', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__( 'HasTech', 'htmega-pro' ),
                    'dynamic' => [
                        'active' => true,
                    ],
                    'condition' => [
                        'show_event_organizer_information' => 'yes',
                    ]
                ]
            );

            $this->add_control(
                'event_organizer_link',
                [
                    'label' => esc_html__( 'Organizer Link', 'htmega-pro' ),
                    'type' => Controls_Manager::URL,
                    'placeholder' => 'https://example.com',
                    'dynamic' => [
                        'active' => true,
                    ],
                    'default' => [
                        'url' => '',
                    ],
                    'condition' => [
                        'show_event_organizer_information' => 'yes',
                    ]
                ]
            );

            
        $this->end_controls_section(); 
    }

    //_style_controls
    protected function _style_controls() {
        $this->__event_section_style();
        $this->__event_content_style();
        $this->__event_title_style();
        $this->__event_description_style();
        $this->__event_item_style();
        $this->__event_button_style();
        $this->__event_footer_style();
        $this->__event_date_and_month_style();
        $this->__event_organize_style();
    }

    protected function __event_section_style(){
        $this->start_controls_section(
            'event_section_style',
            [
                'label' => esc_html__( 'Event Box Wrapper Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_responsive_control(
                'event_box_normal_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                    ],
                ]
            );

            $this->add_responsive_control(
                'event_box_normal_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'event_box_section_background_color',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-event-box-card',
                ]
            );

            $this->start_controls_tabs('event_box_style_tabs');
                
                // Box Normal Style Tab
                $this->start_controls_tab(
                    'event_box_normal_style_tab',
                    [
                        'label' => esc_html__( 'Normal', 'htmega-pro' ),
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'event_box_normal_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-event-box-card',
                        ]
                    );

                    $this->add_responsive_control(
                        'event_box_normal_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-event-box-card' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'event_box_normal_shadow',
                            'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-event-box-card',
                        ]
                    );

                $this->end_controls_tab();

                // Box Hover Style Tab
                $this->start_controls_tab(
                    'event_box_hover_style_tab',
                    [
                        'label' => esc_html__( 'Hover', 'htmega-pro' ),
                    ]
                );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'event_box_hover_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-event-box-card:hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'event_box_hover_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-event-box-card:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'event_box_hover_shadow',
                            'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-event-box-card:hover',
                        ]
                    );

                $this->end_controls_tab();

            $this->end_controls_tabs();

            $this->add_control(
                'top_separate_background_style_header',
                [
                    'label' => esc_html__( 'Top Separate Background Style', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'event_layout_Style' => '1',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'event_box_background',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-event-box-card::after, {{WRAPPER}} .htmega-event-box-card-style-1::after, {{WRAPPER}} .htmega-event-box-card-style-3::after',
                    'condition' => [
                        'event_layout_Style' => '1',
                    ],
                ]
            );

            $this->add_responsive_control(
                'top_separate_height',
                [
                    'label' => esc_html__( 'Height', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px','%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card::after' => 'height: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-event-box-card-style-1::after' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'event_layout_Style' => '1',
                    ],
                ]
            );

            $this->add_control(
                'top_separate_background_img_header',
                [
                    'label' => esc_html__( 'Background Image Style', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'top_separate_background_img_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-image img',
                ]
            );

            $this->add_responsive_control(
                'top_separate_background_img_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-image img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );

            

        $this->end_controls_section();
    }

    protected function __event_content_style(){
        $this->start_controls_section(
            'event_cection_style',
            [
                'label' => esc_html__( 'Content Box Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'event_box_content_background_color',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-event-box-content',
                ]
            );

            $this->start_controls_tabs('event_box_content_style_tabs');
                
                // Box Normal Style Tab
                $this->start_controls_tab(
                    'event_box_content_normal_style_tab',
                    [
                        'label' => esc_html__( 'Normal', 'htmega-pro' ),
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'event_box_content_normal_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-event-box-content',
                        ]
                    );

                    $this->add_responsive_control(
                        'event_box_content_normal_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-event-box-content' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'event_box_content_normal_shadow',
                            'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-event-box-content',
                        ]
                    );

                $this->end_controls_tab();

                // Box Hover Style Tab
                $this->start_controls_tab(
                    'event_box_content_hover_style_tab',
                    [
                        'label' => esc_html__( 'Hover', 'htmega-pro' ),
                    ]
                );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'event_box_content_hover_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-event-box-content:hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'event_box_content_hover_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-event-box-content:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'event_box_content_hover_shadow',
                            'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-event-box-content:hover',
                        ]
                    );

                $this->end_controls_tab();

            $this->end_controls_tabs();

            $this->add_responsive_control(
                'event_box_content_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                    ],
                ]
            );

        $this->end_controls_section();
    }

    protected function __event_title_style(){
        $this->start_controls_section(
            'event_box_title_style',
            [
                'label' => esc_html__( 'Title Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'event_title!' => '',
                ]
            ]
        );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'event_box_title_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-title',
                ]
            );
            
            $this->add_control(
                'event_box_title_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-title a' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_control(
                'event_box_title_color_hover',
                [
                    'label' => esc_html__( 'Hover Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-title a:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_responsive_control(
                'title_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();
    }

    protected function __event_description_style(){
        $this->start_controls_section(
            'event_description_style',
            [
                'label' => esc_html__( 'Description Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                        'event_description!' => '',
                ]
            ]
        );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'event_box_description_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-description',
                ]
            );
            
            $this->add_control(
                'event_box_description_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-description' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_responsive_control(
                'description_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();
    }
    protected function  __event_item_style(){
        $this->start_controls_section(
            'event_item_style',
            [
                'label' => esc_html__( 'Item Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_control(
                'item_icon',
                [
                    'label' => esc_html__( 'Item Icon', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            
            $this->add_control(
                'event_item_icon_font_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-meta-item i' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .htmega-event-box-meta-item svg path' => 'fill: {{VALUE}}',
                    ],
                ]
            );
            $this->add_responsive_control(
                'event_item_icon_font_size',
                [
                    'label' => esc_html__( 'Font Size', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 5,
                            'max' => 100,
                            'step' => 1,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-meta-item i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-event-box-meta-item svg' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'item_content',
                [
                    'label' => esc_html__( 'Item Content', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'event_item_content_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-meta-item' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'event_item_content_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-event-box-meta-item',
                ]
            );

            $this->add_control(
                'item_content_highlight_text',
                [
                    'label' => esc_html__( 'Item Content Highlight', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'event_item_content_highlight_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-meta-item span' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'event_item_content_highlight_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-event-box-meta-item span',
                ]
            );

            $this->add_responsive_control(
                'event_item_content_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'separator' => 'before',
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-meta-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'item_separator_heading',
                [
                    'label' => esc_html__( 'Item Separator', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'show_title_separator_swtcher' => 'yes',
                    ]
                ]
            );

            
            $this->add_responsive_control(
                'event_item_separator_border_width',
                [
                    'label' => esc_html__( 'Breder Height', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 1,
                            'max' => 50,
                            'step' => 1,
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 2,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-meta' => 'border-top: {{SIZE}}{{UNIT}} solid;',
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-meta::after' => 'height: {{SIZE}}{{UNIT}}; top: -{{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_title_separator_swtcher' => 'yes',
                    ]
                ]
            );

            $this->add_control(
                'event_item_separator_border_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-meta' => 'border-top-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'show_title_separator_swtcher' => 'yes',
                    ]
                ]
            );

            $this->add_control(
                'item_separator_overlay_heading',
                [
                    'label' => esc_html__( 'Item Separator Overlay', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'show_title_separator_swtcher' => 'yes',
                    ]
                ]
            );

            $this->add_responsive_control(
                'event_item_separator_overlay_border_width_after',
                [
                    'label' => esc_html__( 'Breder Width', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 1,
                            'max' => 1000,
                            'step' => 1,
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 2,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-meta::after' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_title_separator_swtcher' => 'yes',
                    ]
                ]
            );

            $this->add_control(
                'event_item_separator_overlay_border_color_after',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-meta::after' => 'background-color: {{VALUE}}',
                    ],
                    'condition' => [
                        'show_title_separator_swtcher' => 'yes',
                    ]
                ]
            );

        $this->end_controls_section();
    }

    protected function __event_button_style(){
        
        $this->start_controls_section(
            'event_button_style',
            [
                'label' => esc_html__( 'Button Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'event_button_text!' => '',
                ]
            ]
        );

            $this->add_control(
                'event_button_position',
                [
                    'label'   => esc_html__( 'Button Icon Position', 'htmega-pro' ),
                    'type'    => Controls_Manager::CHOOSE,
                    'toggle' => false,
                    'options' => [
                        'row' => [
                            'title' => esc_html__('Left', 'htmega-pro'),
                            'icon' => 'eicon-h-align-left',
                        ],
                        'row-reverse' => [
                            'title' => esc_html__('Right', 'htmega-pro'),
                            'icon' => 'eicon-h-align-right',
                        ],
                        
                    ],

                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-button' => 'flex-direction: {{VALUE}}',
                    ],
                    'condition' => [
                        'event_button_show' => 'yes',
                    ]
                ]
            );


            $this->add_control(
                'event_button_icon_size',
                [
                    'label' => esc_html__('Icon Font Size', 'htmega-pro'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', 'em'],
                    'range' => [
                        'px' => [
                            'max' => 150,
                        ],
                        'em' => [
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-button i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-button svg' => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'event_button_show' => 'yes',
                    ]
                ]
            );

            $this->add_control(
                'event_button_icon_gap',
                [
                    'label' => esc_html__('Icon Gap', 'htmega-pro'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', 'em'],
                    'range' => [
                        'px' => [
                            'max' => 150,
                        ],
                        'em' => [
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-button' => 'gap: {{SIZE}}{{UNIT}};',

                    ],
                    'condition' => [
                        'event_button_show' => 'yes',
                    ]
                ]
            );

            $this->start_controls_tabs('event_button_style_tabs');

                // Button Normal tab Start
                $this->start_controls_tab(
                    'event_button_style_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'htmega_event_button_text_color',
                        [
                            'label'     => esc_html__( 'Text Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-event-box-button' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-event-box-button svg path' => 'fill: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'event_button_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-event-box-button',
                            'separator' => 'before',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'event_button_typography',
                            'label' => esc_html__( 'Typography', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-event-box-button',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'event_button_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-event-box-button',
                        ]
                    );

                    $this->add_responsive_control(
                        'event_button_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-event-box-button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'box_shadow',
                            'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-event-box-button',
                            'separator' => 'before',
                        ]
                    );

                    $this->add_responsive_control(
                        'event_button_padding',
                        [
                            'label' => esc_html__( 'Padding', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-event-box-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                            ],
                            'separator' => 'before',
                        ]
                    );

                    $this->add_responsive_control(
                        'event_button_margin',
                        [
                            'label' => esc_html__( 'Margin', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-event-box-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );

                $this->end_controls_tab(); // Button Normal tab end

                // Button Hover tab start
                $this->start_controls_tab(
                    'event_button_style_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'htmega-pro' ),
                    ]
                );

                    $this->add_control(
                        'htmega_buttonhover_text_color',
                        [
                            'label'     => esc_html__( 'Text Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-event-box-button:hover' => 'color: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'event_button_hover_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-event-box-button:hover',
                            'separator' => 'before',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'buttonhover_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-event-box-button:hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'buttonhover_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-event-box-button:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
                $this->end_controls_tab(); // Button Hover tab end

            $this->end_controls_tabs();
        $this->end_controls_section();
    }

    protected function __event_footer_style(){
        $this->start_controls_section(
            'event_box_footer_style',
            [
                'label' => esc_html__( 'Footer Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'event_layout_Style!' => '5',
                    'event_footer_text!' => '',
                ]
            ]
        );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'event_box_footer_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-event-box-ends-soon-text',
                ]
            );
            
            $this->add_control(
                'event_box_footer_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-ends-soon-text' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .htmega-event-box-ends-soon-text svg path' => 'fill: {{VALUE}}',
                    ],
                ]
            );

            $this->add_responsive_control(
                'event_footer_svg_size',
                [
                    'label' => esc_html__( 'Font Size', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 5,
                            'max' => 100,
                            'step' => 1,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-ends-soon-text svg' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();
    }

    protected function __event_date_and_month_style(){
        $this->start_controls_section(
            'event_box_date_and_month_style',
            [
                'label' => esc_html__( 'Date And Month Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_date_and_month_swtcher' => 'yes',
                ]
            ]
        );

            $this->add_control(
                'event_box_date_and_month_position',
                [
                    'label' => esc_html__( 'Position', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'event_date_and_month_style' => '1',
                    ]
                ]
            );

            $this->add_responsive_control(
                'event_box_date_and_month_top_position',
                [
                    'label' => esc_html__( 'Top', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 1,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-date-style-1' => 'top: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'event_date_and_month_style' => '1',
                    ]
                ]
            );

            $this->add_responsive_control(
                'event_box_date_and_month_left_position',
                [
                    'label' => esc_html__( 'Left', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 1,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-date-style-1' => 'left: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'event_date_and_month_style' => '1',
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'event_box_date_and_month_background_color',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'separator' => 'before',
                    'selector' => '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-date-style-1',
                    'condition' => [
                        'event_date_and_month_style' => '1',
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'event_box_date_and_month_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-date-style-1',
                    'condition' => [
                        'event_date_and_month_style' => '1',
                    ]
                ]
            );

            $this->add_responsive_control(
                'event_box_date_and_month_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-date-style-1' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                    'condition' => [
                        'event_date_and_month_style' => '1',
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'event_box_date_and_month_box_shadow',
                    'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-date-style-1',
                    'separator' => 'before',
                    'condition' => [
                        'event_date_and_month_style' => '1',
                    ]
                ]
            );

            $this->add_responsive_control(
                'event_box_date_and_month_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-date-style-1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                    ],
                    'separator' => 'before',
                    'condition' => [
                        'event_date_and_month_style' => '1',
                    ]
                ]
            );

            $this->add_control(
                'event_box_date_style',
                [
                    'label' => esc_html__( 'Date', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'event_box_date_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-date-style-1' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-date-style-2' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'event_box_date_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-date-style-1, {{WRAPPER}} .htmega-event-box-card .htmega-event-box-date-style-2',
                ]
            );

            $this->add_control(
                'event_box_month_style',
                [
                    'label' => esc_html__( 'Month', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'event_box_month_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-date-month-style-1' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-date-month-style-2' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'event_box_month_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-date-month-style-1, {{WRAPPER}} .htmega-event-box-card .htmega-event-box-date-month-style-2',
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'event_box__month_background_color',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-date-month-style-1',
                    'condition' => [
                        'event_date_and_month_style' => '1',
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'event_box_month_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-date-month-style-1',
                    'condition' => [
                        'event_date_and_month_style' => '1',
                    ]
                ]
            );

            $this->add_responsive_control(
                'event_box_month_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-date-month-style-1' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                    'condition' => [
                        'event_date_and_month_style' => '1',
                    ]
                ]
            );

            $this->add_responsive_control(
                'event_box_month_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-date-month-style-1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                    ],
                    'separator' => 'before',
                    'condition' => [
                        'event_date_and_month_style' => '1',
                    ]
                ]
            );

            $this->add_responsive_control(
                'event_box_month_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-date-style-2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                    ],
                    'separator' => 'before',
                    'condition' => [
                        'event_date_and_month_style' => '2',
                    ]
                ]
            );


        $this->end_controls_section();
    }

    protected function __event_organize_style(){
        $this->start_controls_section(
            'event_box_organizer_style',
            [
                'label' => esc_html__( 'Organizer Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_event_organizer_information' => 'yes',
                ]
            ]
        );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'event_organizer_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-event-box-organize',
                ]
            );

            $this->add_control(
                'event_organizer_text_style',
                [
                    'label' => esc_html__( 'Organizer Text', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'event_organizer_text_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-organize' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_control(
                'event_box_organizer_by_style',
                [
                    'label' => esc_html__( 'Organizer By', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'event_box_organizer_by_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-organize a' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_control(
                'event_box_organizer_by_hover_color',
                [
                    'label' => esc_html__( 'Hover Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-organize a:hover' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'event_box_organizer_by_color!' => '',
                    ]
                ]
            );

            $this->add_responsive_control(
                'event_box_organizer_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-event-box-card .htmega-event-box-organize' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                    ],
                    'separator' => 'before',
                ]
            );


        $this->end_controls_section();
    }



    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();
        $title = $settings['event_title'];
        $title_tag = $settings['event_title_tag'];
        $event_link = $settings['event_button_link'];
        $event_button_icon = $settings['event_button_icon'];

        $description = $settings['event_description'];
        $event_item = $settings['event_item'];

        $event_date_style = $settings['event_date_and_month_style'];
        $event_day = $settings['event_date_number'];
        $event_month = $settings['event_date_month']; 
        
        $button_text = $settings['event_button_text'];
        $footer_text = $settings['event_footer_text'];
        
        $organizer_text = $settings['event_organizer_text'];
        $organizer = $settings['event_organizer'];
        $organizer_link = $settings['event_organizer_link'];
        

        $event_box_style = "";
        if($settings['event_layout_Style'] == "1"){
            $event_box_style = "htmega-event-box-card-style-1";
        }else{
            $event_box_style = "htmega-event-box-card-".$settings['event_layout_Style'];
        }

        $show_title_separator = '';

        if($settings['show_title_separator_swtcher'] == 'yes'){
            $show_title_separator = 'htmega-title-separator';
        }else{
            $show_title_separator = '';
        }

        $this->add_render_attribute( 'layout_area_attr', 'class', 'htmega-event-box-card '.$event_box_style. ' '.  $show_title_separator );
        ?>
        
         <!--  Event Box 1 style Start -->
        <div class="htmega-event-box-wrap">
            <div <?php echo $this->get_render_attribute_string( 'layout_area_attr' ); ?>>
                <!-- Image Render -->
                <?php 
                    $this->event_image_render($settings);
                    if($event_date_style == "1"){
                        $this->event_date_and_month_box($event_date_style, $event_day, $event_month);
                    }
                ?>

                <div class="htmega-event-box-content">
                    <?php
                        echo "<div class='htmega-event-box-left'>";    
                            if($event_date_style == "2"){
                                $this->event_date_and_month_box($event_date_style, $event_day, $event_month);
                            }
                            $this->organizer_by_render($organizer_text, $organizer, $organizer_link); 
                            $this->title_and_description_render($title, $title_tag, $event_link, $description);
                            $this->event_box_item_render($event_item);
                        echo "</div>";    
                            $this->button_and_footer_text_render( $event_button_icon, $button_text, $event_link, $footer_text);
                    ?>
                </div>
            </div>
        </div>
        <!--  Event Box 1 style End -->
        <?php
    }

    //Event Image Render
    protected function event_image_render($settings){
        if( !empty( $settings['event_image']['url'] ) ){
            echo '<div class="htmega-event-box-image">'.Group_Control_Image_Size::get_attachment_image_html( $settings, 'event_image_size', 'event_image' ).'</div>';
        }
    }

    protected function event_date_and_month_box($event_date_style, $event_day, $event_month){
        if($event_day || $event_month){
            $this->add_render_attribute( 'htmega-event-box-date-style', 'class', 'htmega-event-box-date-style-'.$event_date_style );
            $this->add_render_attribute( 'htmega-event-box-date-month', 'class', 'htmega-event-box-date-month-style-'.$event_date_style );
           
            printf('<div %3$s> %1$s <span %4$s>%2$s</span> </div>', esc_html( $event_day ), esc_html( $event_month ), $this->get_render_attribute_string( 'htmega-event-box-date-style' ), $this->get_render_attribute_string( 'htmega-event-box-date-month' ));
        }
    }

    protected function organizer_by_render($organizer_text, $organizer, $organizer_link){
       if(!empty($organizer)){
            if ( !empty( $organizer_link['url'] ) ) {
                $this->remove_render_attribute( 'event_organizer_link');
                $this->add_link_attributes( 'event_organizer_link', $organizer_link );
            }?>

            <div class="htmega-event-box-organize"><?php echo esc_html( $organizer_text." "); ?> <a <?php echo $this->get_render_attribute_string( 'event_organizer_link' )?>><?php echo esc_html( $organizer ) ?></a></div>

        <?php }
    }

    //Title Render
    protected function title_and_description_render($title, $title_tag, $event_link, $description){
        if ( ! empty( $event_link['url'] ) ) {
            $this->remove_render_attribute( 'event_button_link');
            $this->add_link_attributes( 'event_button_link', $event_link );
		}
        
        //Event Title
        if($title){
            printf('<%1$s class="htmega-event-box-title"><a %3$s>%2$s</a></%1$s>', esc_html( $title_tag ), esc_html( $title ), $this->get_render_attribute_string( 'event_button_link' ));   
        }
        
        //Event Designation
        if($description): ?>
            <p class="htmega-event-box-description"><?php echo htmega_kses_desc( $description ) ?></p>
        <?php endif; 
    }

    protected function event_box_item_render($event_item){ ?>
        <ul class="htmega-event-box-meta">
            <?php foreach($event_item as $item): ?>    
                <li class="htmega-event-box-meta-item">
                    <?php echo HTMega_Icon_Manager::render_icon( $item['item_icon'], [ 'aria-hidden' => 'true' ] ). htmega_kses_desc( $item['item_content'] ); ?>
                </li>
            <?php endforeach; ?>
        </ul>
    <?php }

    //Button and Footer Text
    protected function button_and_footer_text_render( $event_button_icon, $button_text, $event_link, $footer_text){
        if ( ! empty( $event_link['url'] ) ) {
            $this->remove_render_attribute( 'event_button_link');
            $this->add_link_attributes( 'event_button_link', $event_link );
		}

        $event_link = $this->get_render_attribute_string( 'event_button_link' );

        if($button_text || $event_link || $footer_text){
            echo "<div class='htmega-event-box-content-right'>"; 
                echo "<div class='htmega-event-box-content-bottom'>";
                    if($button_text && $event_link){
                        printf('<a class="htmega-event-box-button" %1$s>%2$s%3$s</a>', $event_link , esc_html( $button_text ), HTMega_Icon_manager::render_icon( $event_button_icon, [ 'aria-hidden' => 'true' ] ));
                    }
                    if($footer_text){
                        echo '<span class="htmega-event-box-ends-soon-text">';
                        printf('%1$s%2$s</span>', $this->footer_text_icon(), esc_html( $footer_text ));
                    }
                echo "</div>";
            echo "</div>";
        }
    }

    // Footer Icon
    protected function footer_text_icon(){?>
        <svg width="13" height="13" viewBox="0 0 13 13" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M6.5 0C2.9159 0 0 2.9159 0 6.5C0 10.0841 2.9159 13 6.5 13C10.0841 13 13 10.0841 13 6.5C13 2.9159 10.0841 0 6.5 0ZM6.5 11.7C3.63285 11.7 1.3 9.36715 1.3 6.5C1.3 3.63285 3.63285 1.3 6.5 1.3C9.36715 1.3 11.7 3.63285 11.7 6.5C11.7 9.36715 9.36715 11.7 6.5 11.7Z" fill="#7D7B7B"/>
            <path d="M6.5001 3.25C6.14065 3.25 5.8501 3.5412 5.8501 3.9V7.15C5.8501 7.5088 6.14065 7.8 6.5001 7.8C6.85955 7.8 7.1501 7.5088 7.1501 7.15V3.9C7.1501 3.5412 6.85955 3.25 6.5001 3.25Z" fill="#7D7B7B"/>
            <path d="M6.5001 8.44995C6.3311 8.44995 6.1621 8.52145 6.0386 8.63845C5.92095 8.76195 5.8501 8.93095 5.8501 9.09995C5.8501 9.26895 5.92095 9.43795 6.0386 9.56145C6.2856 9.80195 6.7146 9.80195 6.9616 9.56145C7.0786 9.43795 7.1501 9.26895 7.1501 9.09995C7.1501 8.93095 7.0786 8.76195 6.9616 8.63845C6.8381 8.52145 6.6691 8.44995 6.5001 8.44995Z" fill="#7D7B7B"/>
        </svg>
    <?php }

}