<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Repeater;
use Elementor\HTMega_Icon_Manager;
use Elementor\Group_Control_Image_Size;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Feature_List_Element extends Widget_Base {
    public function get_name() {
        return 'htmega-feature-list-addons';
    }
    
    public function get_title() {
        return __( 'Feature List', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-post-list';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }

    public function get_keywords() {
        return [ 'htmega', 'ht mega', 'feature', 'feature list', 'feature grid', 'list','htmega pro' ];
    }

    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/general-widgets/feature-list-widget/';
	}
    protected function is_dynamic_content():bool {
		return false;
	}
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Feature', 'htmega-pro' ),
            ]
        );
            
            $repeater = new Repeater();

            $repeater->add_control(
                'title',
                [
                    'label' => esc_html__( 'Title', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__( 'Feature Title', 'htmega-pro' ),
                    'label_block' => true,
                    'description' => htmega_get_allowed_tag_desc('title'),
                    
                ]
            );

            $repeater->add_control(
                'content',
                [
                    'label' => esc_html__( 'Content', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => esc_html__( 'If your budget doesn’t allow for buying a new vehicle, then there are many options available for used cars as well.','htmega-pro' ),
                    'description' => htmega_get_allowed_tag_desc('desc'),
                ]
            );

            $repeater->add_control(
                'icon_type',
                [
                    'label' => esc_html__( 'Icon Type', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'icon' => [
                            'title' => esc_html__( 'Icon', 'htmega-pro' ),
                            'icon' => 'eicon-editor-italic',
                        ],
                        'image' => [
                            'title' => esc_html__( 'Image', 'htmega-pro' ),
                            'icon' => 'eicon-image',
                        ],
                    ],
                    'default'=>'icon',
                    'toggle' => false,
                ]
            );

            $repeater->add_control(
                'feature_icon',
                [
                    'label'       => esc_html__( 'Icon', 'htmega-pro' ),
                    'type'        => Controls_Manager::ICONS,
                    'label_block' => true,
                    'condition'=>[
                        'icon_type'=>'icon'
                    ]
                ]
            );

            $repeater->add_control(
                'feature_icon_image',
                [
                    'label' => esc_html__( 'Icon Image', 'htmega-pro' ),
                    'type' => Controls_Manager::MEDIA,
                    'condition'=>[
                        'icon_type'=>'image'
                    ]
                ]
            );

            $repeater->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'feature_icon_image_size',
                    'default' => 'large',
                    'separator' => 'none',
                    'condition'=>[
                        'feature_icon_image[url]!'=>'',
                        'icon_type'=>'image',
                    ]
                ]
            );

            $repeater->add_control(
                'individual_style',
                [
                    'label' => esc_html__( 'Individual Style', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Yes', 'htmega-pro' ),
                    'label_off' => esc_html__( 'No', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'separator' => 'before',
                ]
            );
                
                $repeater->add_control(
                    'ind_title_color_header',
                    [
                        'label' => esc_html__( 'Title', 'htmega-pro' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                        'condition' => [
                            'individual_style' => 'yes'
                        ],
                    ]
                );

                    $repeater->add_control(
                        'ind_title_color',
                        [
                            'label' => esc_html__( 'Title Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-feature-list-item{{CURRENT_ITEM}} .htmega-feature-list-title' => 'color: {{VALUE}}',
                            ],
                            'condition' => [
                                'individual_style' => 'yes'
                            ],
                        ]
                    );

                    $repeater->add_control(
                        'ind_title_hover_color',
                        [
                            'label' => esc_html__( 'Title Hover Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-feature-list-item{{CURRENT_ITEM}} .htmega-feature-list-title a:hover' => 'color: {{VALUE}}',
                            ],
                            'condition' => [
                                'individual_style' => 'yes'
                            ],
                        ]
                    );

                $repeater->add_control(
                    'ind_content_color_header',
                    [
                        'label' => esc_html__( 'Content', 'htmega-pro' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                        'condition' => [
                            'individual_style' => 'yes'
                        ],
                    ]
                );

                $repeater->add_control(
                    'ind_content_color',
                    [
                        'label' => esc_html__( 'Content Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-feature-list-item{{CURRENT_ITEM}} .htmega-feature-list-desc' => 'color: {{VALUE}}',
                        ],
                        'condition' => [
                            'individual_style' => 'yes'
                        ],
                    ]
                );
                    

                $repeater->add_control(
                    'ind_icon_color_header',
                    [
                        'label' => esc_html__( 'Icon', 'htmega-pro' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                        'condition'=>[
                            'individual_style' => 'yes',
                            'icon_type'=>'icon'
                        ]
                    ]
                );

                $repeater->add_control(
                    'ind_icon_color',
                    [
                        'label' => esc_html__( 'Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-feature-list-item{{CURRENT_ITEM}} .htmega-feature-list-icon' => 'color: {{VALUE}}',
			                '{{WRAPPER}} .htmega-feature-list-item{{CURRENT_ITEM}} .htmega-feature-list-icon svg *' => 'fill: {{VALUE}}; stroke: {{VALUE}}',
                        ],
                        'condition'=>[
                            'individual_style' => 'yes',
                            'icon_type'=>'icon'
                        ]
                    ]
                );

                $repeater->add_control(
                    'ind_icon_bg_color',
                    [
                        'label' => esc_html__( 'Background Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-feature-list-item{{CURRENT_ITEM}} .htmega-feature-list-icon' => 'background-color: {{VALUE}};opacity:1;transform: scale(1);',
                        ],
                        'condition'=>[
                            'individual_style' => 'yes',
                            'icon_type'=>'icon'
                        ]
                    ]
                );

                $repeater->add_control(
                    'ind_icon_border_color',
                    [
                        'label' => esc_html__( 'Border Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-feature-list-item{{CURRENT_ITEM}} .htmega-feature-list-icon' => 'border-color: {{VALUE}}',
                        ],
                        'condition'=>[
                            'individual_style' => 'yes',
                            'icon_type'=>'icon'
                        ]
                    ]
                );
            

            $repeater->add_control(
                'feature_list_link',
                [
                    'label'       => esc_html__( 'Link', 'htmega-pro' ),
                    'type'        => Controls_Manager::URL,
                    'dynamic'     => ['active' => true],
                    'placeholder' => esc_html__( 'https://your-link.com', 'htmega-pro' ),
                    'separator'   => 'before',
                ]
            );

            $repeater->add_responsive_control(
                'rep_feature_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-feature-list-section {{CURRENT_ITEM}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator'   => 'before',
                ]
            );

            $this->add_control(
                'feature_list',
                [
                    'label' => esc_html__( 'Feature Item', 'htmega-pro' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                    'default' => [
                        [
                            'title' => esc_html__( 'USER JOURNEYS', 'htmega-pro' ),
                            'content' => esc_html__( 'If your budget doesn’t allow for buying a new vehicle, then there are many options available for used cars as well.','htmega-pro' ),
                            'feature_icon' => [
                                'value'     => 'fas fa-dove',
                                'library'   => 'fa-solid'
                            ]
                        ],
                        [
                            'title' => esc_html__( 'PUTTING IT ALL', 'htmega-pro' ),
                            'content' => esc_html__( 'If your budget doesn’t allow for buying a new vehicle, then there are many options available for used cars as well.','htmega-pro' ),
                            'feature_icon' => [
                                'value'     => 'fas fa-chart-line',
                                'library'   => 'fa-solid'
                            ]
                        ],
                        [
                            'title' => esc_html__( 'TECHNICAL ARCHITRCTURE', 'htmega-pro' ),
                            'content' => esc_html__( 'If your budget doesn’t allow for buying a new vehicle, then there are many options available for used cars as well.','htmega-pro' ),
                            'feature_icon' => [
                                'value'     => 'fas fa-crown',
                                'library'   => 'brands'
                            ]
                        ],
                    ],
                    'title_field' => '{{{ elementor.helpers.renderIcon( this, feature_icon, {}, "i", "panel" ) || \'<i class="{{ feature_icon.value }}" aria-hidden="true"></i>\' }}} {{ title }}',
                ]
            );

            $this->add_responsive_control(
                'icon_position',
                [
                    'label' => esc_html__( 'Icon Position', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'initial' => [
                            'title' => esc_html__( 'Left', 'htmega-pro' ),
                            'icon' => 'eicon-h-align-left',
                        ],
                        'column' => [
                            'title' => esc_html__( 'Top', 'htmega-pro' ),
                            'icon' => 'eicon-v-align-top',
                        ],
                        'row-reverse' => [
                            'title' => esc_html__( 'Right', 'htmega-pro' ),
                            'icon' => 'eicon-h-align-right',
                        ],
                    ],
                    'default'=>'initial',
                    'toggle' => false,
                    'separator' => 'before',
                    'selectors' => [
                        '{{WRAPPER}} .htmega-feature-list-section .htmega-feature-list-item' => 'flex-direction: {{VALUE}};',
                        '{{WRAPPER}} .htmega-feature-list-section .htmega-feature-list-top' => 'flex-direction: {{VALUE}};',
                       
                    ],
                ]
            );

            $this->add_control(
                'icon_with_title',
                [
                    'label' => esc_html__( 'Icon With Title', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Yes', 'htmega-pro' ),
                    'label_off' => esc_html__( 'No', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'no',                   
                ]
            );
            
            $this->add_control(
                'feature_position_left',
                [
                    'type' => Controls_Manager::HIDDEN,
                    'default' => 'traditional',
                    'selectors' => [
                        '{{WRAPPER}} .htmega-feature-list-section .htmega-feature-list-title' => 'text-align: left;',
                        '{{WRAPPER}} .htmega-feature-list-section .htmega-feature-list-desc' => 'text-align: left;',
                    ],
                    'condition'=>[
                        'icon_position'=>'initial'
                    ]
                ]
            );

            $this->add_control(
                'feature_position_top',
                [
                    'type' => Controls_Manager::HIDDEN,
                    'default' => 'traditional',
                    'selectors' => [
                        '{{WRAPPER}} .htmega-feature-list-section .htmega-feature-list-item' => 'align-items: center;',
                        '{{WRAPPER}} .htmega-feature-list-section .htmega-feature-list-title' => 'text-align: center;',
                        '{{WRAPPER}} .htmega-feature-list-section .htmega-feature-list-desc' => 'text-align: center;',
                    ],
                    'condition'=>[
                        'icon_position'=>'column'
                    ]
                ]
            );

            $this->add_control(
                'feature_position_right',
                [
                    'type' => Controls_Manager::HIDDEN,
                    'default' => 'traditional',
                    'selectors' => [
                        '{{WRAPPER}} .htmega-feature-list-section .htmega-feature-list-title' => 'text-align: right;',
                        '{{WRAPPER}} .htmega-feature-list-section .htmega-feature-list-desc' => 'text-align: right;',
                    ],
                    'condition'=>[
                        'icon_position'=>'row-reverse'
                    ]
                ]
            );

            $this->add_responsive_control(
                'icon_position_space_between_left',
                [
                    'label' => esc_html__( 'Space Between', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 30,
                        ],
                    ],
                    
                    'size_units' => [ 'px', '%' ],
                    
                    'selectors' => [
                        '{{WRAPPER}} .htmega-feature-list-item .htmega-feature-list-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                    'condition'=>[
                        'icon_position'=>'initial'
                    ]
                ]
            );

            $this->add_responsive_control(
                'icon_position_space_between_right',
                [
                    'label' => esc_html__( 'Space Between', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 30,
                        ],
                    ],
                    
                    'size_units' => [ 'px', '%' ],
                    
                    'selectors' => [
                        '{{WRAPPER}} .htmega-feature-list-item .htmega-feature-list-icon' => 'margin-left: {{SIZE}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                    'condition'=>[
                        'icon_position'=>'row-reverse'
                    ]
                ]
            );

            $this->add_responsive_control(
                'icon_position_space_between_top',
                [
                    'label' => esc_html__( 'Space Between', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 30,
                        ],
                    ],
                    
                    'size_units' => [ 'px', '%' ],
                    
                    'selectors' => [
                        '{{WRAPPER}} .htmega-feature-list-item .htmega-feature-list-icon' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                    'condition'=>[
                        'icon_position'=>'column'
                    ]
                ]
            );

            $this->add_control(
                'feature_list_title_tag',
                [
                    'label'     => esc_html__( 'Title HTML Tag', 'htmega-pro' ),
                    'type'      => Controls_Manager::SELECT,
                    'options'   => [
                        'h1'   => 'H1',
                        'h2'   => 'H2',
                        'h3'   => 'H3',
                        'h4'   => 'H4',
                        'h5'   => 'H5',
                        'h6'   => 'H6',
                        'div'  => 'div',
                        'span' => 'span',
                        'p'    => 'p',
                    ],
                    'default'   => 'h3',
                ]
            );
    
            $this->add_control(
                'feature_list_icon_shape',
                [
                    'label'       => esc_html__( 'Icon Shape', 'htmega-pro' ),
                    'type'        => Controls_Manager::SELECT,
                    'options'     => [
                        'circle'  => esc_html__( 'Circle', 'htmega-pro' ),
                        'square'  => esc_html__( 'Square', 'htmega-pro' ),
                    ],
                    'default'     => 'circle',
                    'label_block' => false,
                ]
            );

            $this->add_responsive_control(
                'space_between',
                [
                    'label' => esc_html__( 'Space Between', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    
                    'size_units' => [ 'px', '%' ],
                    
                    'selectors' => [
                        '{{WRAPPER}} .htmega-feature-list-section .htmega-feature-list-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
        $this->end_controls_section();


        // Title tab section
        $this->start_controls_section(
            'area_style',
            [
                'label' => esc_html__( 'Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'ind_Section_bg_color',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .htmega-feature-list-section .htmega-feature-list-item-6',
                    'condition' => [
                        'icon_with_title' => 'yes'
                    ],
                ]
            );

            $this->add_responsive_control(
                'area_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-feature-list-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            
            $this->add_responsive_control(
                'area_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-feature-list-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'icon_with_title' => 'no'
                    ],
                ]
            );

            $this->add_responsive_control(
                'area_padding_icon_with_title',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-feature-list-section .htmega-feature-list-item-6' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'icon_with_title' => 'yes'
                    ],
                ]
            );
        $this->end_controls_section();

        // Title tab section
        $this->start_controls_section(
            'title_style',
            [
                'label' => esc_html__( 'Title', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-feature-list-item .htmega-feature-list-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_control(
                'title_color_hover',
                [
                    'label' => esc_html__( 'Title Hover Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-feature-list-item .htmega-feature-list-title a:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-feature-list-item .htmega-feature-list-title',
                ]
            );

            $this->add_responsive_control(
                'title_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-feature-list-item .htmega-feature-list-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();

        // Content tab section
        $this->start_controls_section(
            'content_style',
            [
                'label' => esc_html__( 'Content', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            
            $this->add_control(
                'content_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-feature-list-content .htmega-feature-list-desc' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-feature-list-content .htmega-feature-list-desc',
                ]
            );

            $this->add_responsive_control(
                'content_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-feature-list-content .htmega-feature-list-desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'content_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-feature-list-content .htmega-feature-list-desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();

        // Icon tab section
        $this->start_controls_section(
            'icon_style',
            [
                'label' => esc_html__( 'Icon', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'icon_box_width',
            [
                'label' => esc_html__( 'Icon Box Width', 'htmega-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 60,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-feature-list-item .htmega-feature-list-icon' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
            
            $this->add_responsive_control(
                'icon_box_height',
                [
                    'label' => esc_html__( 'Icon Box Height', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 500,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 60,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-feature-list-item .htmega-feature-list-icon' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => esc_html__( 'Icon Size', 'htmega-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 20,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-feature-list-item .htmega-feature-list-icon svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before'
            ]
        );

            $this->add_control(
                'icon_normal_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-feature-list-item .htmega-feature-list-icon' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .htmega-feature-list-item .htmega-feature-list-icon svg *' => 'fill: {{VALUE}}; stroke: {{VALUE}}',
                    ],
                ]
            );

            $this->add_control(
                'icon_normal_bg_color',
                [
                    'label' => esc_html__( 'Background Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-feature-list-item .htmega-feature-list-icon' => 'background-color: {{VALUE}};opacity:1;transform: scale(1);',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'icon_normal_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-feature-list-item .htmega-feature-list-icon',
                ]
            );

            $this->add_responsive_control(
                'icon_normal_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-feature-list-item .htmega-feature-list-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-feature-list-item .htmega-feature-list-icon img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-feature-list-item .htmega-feature-list-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'icon_normal_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-feature-list-item .htmega-feature-list-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();
    }

    protected function render( $instance = [] ) {
        $settings = $this->get_settings_for_display();
        $feature_list = $settings['feature_list'];

        ?>
            <div class="htmega-feature-list-section">
                <div class="htmega-feature-list-right">
                    <!-- Single Feature List Start -->
                    <?php foreach($feature_list as $feature):
                        $iconImage = "";
                        if( $feature['icon_type'] === 'icon' ){

                            if($feature['feature_icon']['library'] == 'svg'){
                                $iconImage = "<div class='htmega-feature-list-icon htmega-feature-icon'>". HTMega_Icon_manager::render_icon( $feature['feature_icon'], [ 'aria-hidden' => 'true' ] )."</div>";
                            }else{
                                $iconImage = "<div class='htmega-feature-list-icon'>".HTMega_Icon_manager::render_icon( $feature['feature_icon'], [ 'aria-hidden' => 'true' ] )."</div>";
                            }
                        }elseif( $feature['icon_type'] === 'image' ){
                            $iconImage = ( !empty( $feature['feature_icon_image']['url'] ) ? "<div class='htmega-feature-list-icon htmega-feature-image '".$this->get_render_attribute_string( 'icon_attr' ).">". Group_Control_Image_Size::get_attachment_image_html( $feature, 'feature_icon_image_size', 'feature_icon_image' ).'</div>' : '' );
                        }
                        
                        $urlBefor = ''; 
                        $urlAfter = '';
                        if(!empty($feature['feature_list_link']['url'])){
                            $this->add_link_attributes( $feature['_id'], $feature['feature_list_link'] );
                            $urlBefor = "<a ".$this->get_render_attribute_string( $feature['_id'] )." href='". esc_url( $feature['feature_list_link']['url'] ) ."'>";
                            $urlAfter = "</a>";
                        }
                        
                        if($settings['icon_with_title'] != 'yes'):?>

                            <div class="htmega-feature-list-item elementor-repeater-item-<?php echo esc_attr($feature['_id']) . esc_attr(($settings['feature_list_icon_shape'] == 'square') ? ' htmega-feature-list-item-shape' : ''); ?>">
                                <!-- Image/Icon -->
                                <?php if(!empty($iconImage)){
                                    echo $iconImage;
                                }?>
                                <div class="htmega-feature-list-content">
                                    <!-- Title -->
                                    <?php if( !empty($feature['title']) ){
                                            echo "<". esc_attr( $settings['feature_list_title_tag'] ) . " class='htmega-feature-list-title'>" . (!empty($feature['feature_list_link']['url']) ? $urlBefor : "") . htmega_kses_title( $feature['title'] ). (!empty($feature['feature_list_link']['url']) ? $urlAfter : "")."</".esc_attr( $settings['feature_list_title_tag'] ).">";
                                    }?>
                                    <!-- Content -->
                                    <?php if( !empty($feature['content']) ): ?>
                                        <p class="htmega-feature-list-desc"><?php echo htmega_kses_desc( $feature['content']) ?></p>
                                    <?php endif ?>
                                </div>
                            </div>
                            <!-- Single Feature List End -->
                        
                    <?php else: ?>
                        <!-- Single Feature List Start -->
                        <div class="htmega-feature-list-item elementor-repeater-item-<?php echo esc_attr($feature['_id'])?> htmega-feature-list-item-6">
                            <div class="htmega-feature-list-top">
                                <!-- Image/Icon -->
                                <?php if(!empty($iconImage)){
                                    echo $iconImage;
                                }?>
                                <!-- Title -->
                                <?php
                                    if( !empty($feature['title']) ){
                                        echo "<". esc_attr( $settings['feature_list_title_tag'] ) . " class='htmega-feature-list-title'>" . (!empty($feature['feature_list_link']['url']) ? $urlBefor : "") . htmega_kses_title( $feature['title']). (!empty($feature['feature_list_link']['url']) ? $urlAfter : "")."</".esc_attr( $settings['feature_list_title_tag'] ).">";
                                    }
                                ?>
                            </div>
                            <div class="htmega-feature-list-content">
                                <!-- Content -->
                                <?php if( !empty($feature['content']) ): ?>
                                    <p class="htmega-feature-list-desc"><?php echo htmega_kses_desc( $feature['content'] ) ?></p>
                                <?php endif ?>
                            </div>
                        </div>
                        <!-- Single Feature List End -->
                    <?php 
                        endif;
                    endforeach; ?>
                </div>
            </div>
        <?php 
    }

}