<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\HTMega_Icon_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Flip_Carousel_Element extends Widget_Base {

    public function get_name() {
        return 'htmega-flip-carousel-addons';
    }
    
    public function get_title() {
        return __( 'Flip Carousel', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-media-carousel';
    }

    public function get_categories() {
        return [ 'htmega-pro' ];
    }

    public function get_style_depends() {
        return [
            'htmega-flipster'
        ];
    }
    public function get_script_depends() {
        return [
            'htmega-flipster',
        ];
	}
    public function get_keywords() {
        return ['flip carousel', 'custom carousel','image carousel', 'slide', 'flip', 'carousel', 'flip slider', 'image slider', 'htmega', 'ht mega'];
    }

    public function get_custom_help_url() {
        return 'https://wphtmega.com/docs/creative-widgets/elementor-flip-carousel-widget/';
    }
    protected function is_dynamic_content():bool {
		return false;
	}
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Flip Slides', 'htmega-pro' ),
            ]
        );
            $repeater = new \Elementor\Repeater();

            $repeater->add_control(
                'flip_image',
                [
                    'label' => esc_html__('Image','htmega-pro'),
                    'type'=>Controls_Manager::MEDIA,
                    'dynamic' => [
                        'active' => true,
                    ],
                    'default' => [
                        'url' => HTMEGA_ADDONS_PL_URL.'assets/images/image-placeholder.png',
                    ],
                ]
            );

            $repeater->add_control(
                'flip_caption',
                [
                    'label'   => esc_html__( 'Caption', 'htmega-pro' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => '',
                    'label_block'=>true,
                ]
            );
            $repeater->add_control(
                'enable_image_link',
                [
                    'label' => __( 'Slide Link', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
    
            $repeater->add_control(
                'image_link',
                [
                    'type' => Controls_Manager::URL,
                    'dynamic' => [
                        'active' => true,
                    ],
                    'placeholder' => __( 'https://your-link.com', 'htmega-pro' ),
                    'show_external' => true,
                    'default' => [
                        'url' => '',
                    ],
                    'condition' => [
                        'enable_image_link' => 'yes'
                    ]
                ]
            );

            $this->add_control(
                'carousel_list',
                [
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                    'default' => [
                        [
                            'flip_image'=>[
                                'url' => HTMEGA_ADDONS_PL_URL.'assets/images/image-placeholder.png',
                            ],
                        ],
                        [
                            'flip_image'=>[
                                'url' => HTMEGA_ADDONS_PL_URL.'assets/images/image-placeholder.png',
                            ],
                        ],
                        [
                            'flip_image'=>[
                                'url' => HTMEGA_ADDONS_PL_URL.'assets/images/image-placeholder.png',
                            ],
                        ]
                    ],
                    'title_field' => '{{flip_caption}}',
                ]
            );

        $this->end_controls_section();

        // Carousel Settings
        $this->start_controls_section(
            'carousel_settings_section',
            [
                'label' => esc_html__( 'Settings', 'htmega-pro' ),
            ]
        );
            $this->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'flip_image_size',
                    'default' => 'full',
                    'separator' => 'none',
                ]
            );
            $this->add_control(
                'carousel_style',
                [
                    'label' => esc_html__( 'Carousel Style', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'carousel',
                    'options' => [
                        'flat'  => esc_html__( 'Flat', 'htmega-pro' ),
                        'coverflow'  => esc_html__( 'Coverflow', 'htmega-pro' ),
                        'carousel'  => esc_html__( 'Carousel', 'htmega-pro' ),
                        'wheel'  => esc_html__( 'Wheel', 'htmega-pro' ),
                    ],
                ]
            );

            $this->add_control(
                'spacing',
                [
                    'label' => esc_html__( 'Spacing', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => -1,
                    'max' => 1,
                    'step' => 0.1,
                    'default' => -0.6,
                ]
            );

            $this->add_control(
                'carousel_start',
                [
                    'label' => esc_html__( 'Carousel start', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'center',
                    'options' => [
                        'center'  => esc_html__( 'Center', 'htmega-pro' ),
                        'number'  => esc_html__( 'First item', 'htmega-pro' ),
                    ],
                ]
            );

            $this->add_control(
                'carousel_fadein',
                [
                    'label' => esc_html__( 'Animation Delay', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'step' => 10,
                    'default' => 400,
                ]
            );

            $this->add_control(
                'carousel_loop',
                [
                    'label' => esc_html__( 'Repeatable Loop', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                ]
            );
            $this->add_control(
                'carousel_autoplay',
                [
                    'label' => esc_html__( 'Autoplay', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
            $this->add_control(
                'autoplay_speed',
                [
                    'label' => esc_html__( 'Autoplay Speed', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'step' => 10,
                    'default' => 2000,
                    'condition' => ['carousel_autoplay' => 'yes']
                ]
                
            );
            $this->add_control(
                'carousel_keyboard',
                [
                    'label' => esc_html__( 'Keyboard', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'description' => esc_html__( 'Enable left/right arrow navigation', 'htmega-pro' ),
                ]
            );

            $this->add_control(
                'carousel_scrollwheel',
                [
                    'label' => esc_html__( 'Scroll wheel', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'description' => esc_html__( 'Enable mousewheel/trackpad navigation', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );
            $this->add_control(
                'flip_caption_switcher',
                [
                    'label' => __( 'Show Image Caption', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                    'separator' => 'before'
                ]
            );
    
            $this->add_control(
                'flip_caption_position',
                [
                    'label' => esc_html__( 'Position', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'column',
                    'options' => [
                        'column-reverse' => esc_html__( 'Above Image', 'htmega-pro' ),
                        'column' => esc_html__( 'Below Image', 'htmega-pro' ),
                    ],
                    'condition' => [
                        'flip_caption_switcher' => 'yes'
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .flipster__item__content' => 'display:flex; flex-direction:{{VALUE}};',
                    ],
                    'separator' => 'after'
                ]
            );
            $this->add_control(
                'show_image_link',
                [
                    'label' => __( 'Show Image Link', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                    'separator' => 'after'
                ]
            );


            $this->add_responsive_control(
                'slarrows',
                [
                    'label' => esc_html__( 'Navigation', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                    'widescreen_default' => 'yes',
                    'laptop_default' => 'yes',
                    'tablet_extra_default' => 'yes',
                    'tablet_default' => 'yes',
                    'mobile_extra_default' => 'yes',
                    'mobile_default' => 'yes',
                    'selectors_dictionary' => [
                        '' => 'none',
                        'yes' => 'flex'
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .flipster__button' => 'display:{{VALUE}} !important; align-items:center; justify-content:center;',
                    ],
                    'render_type' => 'template',
                ]
            );
            $this->add_control(
                'slarrows_type',
                [
                    'label' => esc_html__( 'Select Icon Type', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'icon',
                    'options' => [
                        'icon' => esc_html__( 'Icon', 'htmega-pro' ),
                        'text' => esc_html__( 'Text', 'htmega-pro' ),
                    ],
                    'condition' => [
                        'slarrows' => 'yes',
                    ]                    
                ]
            );
            $this->add_control(
                'slarrowsicon_font_next_nav',
                [
                    'label' => __( 'Icon Next', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' =>'NEXT',
                    'condition' => [
                        'slarrows' => 'yes',
                        'slarrows_type' => 'text',
                    ],
                ]
            );
            $this->add_control(
                'slarrowsicon_font_prev_nav',
                [
                    'label' => __( 'Icon Prev', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' =>'PREV',
                    'condition' => [
                        'slarrows' => 'yes',
                        'slarrows_type' => 'text',
                    ],
                ]
            );

            $this->add_control(
                'slarrowsicon_font_next',
                [
                    'label' => __( 'Icon Next', 'htmega-pro' ),
                    'type' => Controls_Manager::ICONS,
                    'default' => [
                        'value' => 'fas fa-angle-right',
                        'library' => 'fa-solid',
                    ],
                    'condition' => [
                        'slarrows' => 'yes',
                        'slarrows_type' => 'icon',
                    ],
                ]
            );

            $this->add_control(
                'slarrowsicon_font_prev',
                [
                    'label' => __( 'Icon Prev', 'htmega-pro' ),
                    'type' => Controls_Manager::ICONS,
                    'default' => [
                        'value' => 'fas fa-angle-left',
                        'library' => 'fa-solid',
                    ],
                    'condition' => [
                        'slarrows' => 'yes',
                        'slarrows_type' => 'icon',
                    ],
                ]
            );

            $this->add_responsive_control(
                'sldots',
                [
                    'label' => esc_html__( 'Pagination', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                    'selectors_dictionary' => [
                        '' => 'none',
                        'yes' => 'block'
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .flipster__nav' => 'display:{{VALUE}} !important;',
                        '{{WRAPPER}} .flipster__nav__link' => 'z-index:1;',
                    ],
                    'render_type' => 'template',
                ]
            );

            $this->add_control(
                'dots_position',
                [
                    'label' => esc_html__( 'Position', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'before',
                    'options' => [
                        'before'   => esc_html__( 'Above Image', 'htmega-pro' ),
                        'after'   => esc_html__( 'Below Image', 'htmega-pro' ),

                    ],
                    'condition' => [
                        'sldots' => 'yes',
                    ]
                ]
            );
        $this->end_controls_section();
        $this->start_controls_section(
            'htmega_carousel_arrow_style',
            [
                'label'     => __( 'Navigation', 'htmega-pro' ),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' =>[
                    'slarrows'  => 'yes',
                ],
            ]
            );
            $this->add_responsive_control(
                'htmega_carousel_arrow_height',
                [
                    'label' => __( 'Height', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 45,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .flipster__button' => 'height: {{SIZE}}{{UNIT}};opacity:1;',
                    ],
                ]
            );

            $this->add_responsive_control(
                'htmega_carousel_arrow_width',
                [
                    'label' => __( 'Width', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 45,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .flipster__button' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'arrow_position_opover',
                [
                    'type' =>Controls_Manager::POPOVER_TOGGLE,
                    'label' => esc_html__( 'Positions', 'htmega-pro' ),
                    'label_off' => esc_html__( 'Default', 'htmega-pro' ),
                    'label_on' => esc_html__( 'Custom', 'htmega-pro' ),
                    'return_value' => 'yes',
                ]
            );
        
            $this->start_popover();
            
            $this->add_responsive_control(
                'htmega_carousel_arrow_position',
                [
                    'label' => __( 'Vertical Position', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => -100,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => '',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .flipster__button' => 'top: {{SIZE}}{{UNIT}};',
                    ], 
                    'condition' => ['arrow_position_opover' => 'yes' ],
                ]
            );

            $this->add_responsive_control(
                'htmega_carousel_arrow_position_x',
                [
                    'label' => __( 'Horizontal Position', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => '',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .flipster__button' => 'left: {{SIZE}}{{UNIT}}; right:auto; margin: 0;',
                        '{{WRAPPER}} .flipster__button.flipster__button--next' => 'right: {{SIZE}}{{UNIT}}; left:auto;',
                    ],
                    'condition' => ['arrow_position_opover' => 'yes' ],
                ]
            );

            $this->end_popover();
            $this->add_responsive_control(
                'htmega_carousel_arrow_fontsize',
                [
                    'label' => __( 'Font Size', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 32,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .flipster__button' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .flipster__button svg' => 'width: {{SIZE}}{{UNIT}};height: auto;',
                    ],
                ]
            );
            $this->add_control(
                'navigaton_border_heading',
                [
                    'label' => __( 'Colors and Border', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $this->start_controls_tabs( 'carousel_arrow_style_tabs' );
    
                // Normal tab Start
                $this->start_controls_tab(
                    'carousel_arrow_style_normal_tab',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                );
    
                    $this->add_responsive_control(
                        'htmega_carousel_arrow_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '#000000',
                            'selectors' => [
                                '{{WRAPPER}} .flipster__button' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .flipster__button svg path' => 'fill: {{VALUE}}; height: auto; transition: all 0.3s ease-in-out;',
                            ],
                        ]
                    );
    
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'carousel_arrow_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .flipster__button',
                        ]
                    );
    
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'htmega_carousel_arrow_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .flipster__button',
                        ]
                    );
    
                    $this->add_responsive_control(
                        'htmega_carousel_arrow_border_radius',
                        [
                            'label' => __( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .flipster__button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
        
                $this->end_controls_tab(); // Normal tab end
    
                // Hover tab Start
                $this->start_controls_tab(
                    'carousel_arrow_style_hover_tab',
                    [
                        'label' => __( 'Hover', 'htmega-pro' ),
                    ]
                );
    
                    $this->add_control(
                        'htmega_carousel_arrow_hover_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '#ffffff',
                            'selectors' => [
                                '{{WRAPPER}} .flipster__button:hover' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .flipster__button:hover svg path' => 'fill: {{VALUE}};',
                            ],
                        ]
                    );
    
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'carousel_arrow_hover_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .flipster__button:hover',
                        ]
                    );
    
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'htmega_carousel_arrow_hover_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .flipster__button:hover',
                        ]
                    );
    
                    $this->add_responsive_control(
                        'htmega_carousel_arrow_hover_border_radius',
                        [
                            'label' => __( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .flipster__button:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
    
                $this->end_controls_tab(); // Hover tab end
    
            $this->end_controls_tabs();
    
        $this->end_controls_section(); // Style arrow style end
    
    
        // Style Dots style start
        $this->start_controls_section(
            'htmega_carousel_dots_style',
            [
                'label'     => __( 'Pagination', 'htmega-pro' ),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' =>[
                    'sldots'  => 'yes',
                ],
            ]
            );
            $this->add_control(
                'pagination_style',
                [
                    'label' => esc_html__( 'Style', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'default',
                    'options' => [
                        'default' => esc_html__( 'Default', 'htmega-pro' ),
                        'custom' => esc_html__( 'Custom', 'htmega-pro' ),
                    ],
                    'selectors_dictionary' => [
                        'custom' => 'none',
                        'default' => 'block'
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-flipster-pagination-custom .flipster__nav__link::after' => 'display: {{VALUE}};',
                    ],
                    'render_type' => 'template',
                ]
            );
            $this->start_controls_tabs( 'carousel_dots_style_tabs' );
    
                // Normal tab Start
                $this->start_controls_tab(
                    'carousel_dots_style_normal_tab',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'dot_color',
                        [
                            'label' => __( 'Index Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '#000000',
                            'selectors' => [
                                '{{WRAPPER}} .flipster__nav__item .flipster__nav__link,
                                {{WRAPPER}} .htmega-flipster-pagination-custom .flipster__nav__link' => 'color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'carousel_dots_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .flipster__nav__item .flipster__nav__link::after, {{WRAPPER}} .htmega-flipster-pagination-custom .flipster__nav__link',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'dot_typgrapry',
                            'selector' => '{{WRAPPER}} .flipster__nav__item .flipster__nav__link',
                        ]
                    ); 
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'htmega_carousel_dots_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .flipster__nav__item .flipster__nav__link::after,
                            {{WRAPPER}} .htmega-flipster-pagination-custom .flipster__nav__link',
                        ]
                    );
    
                    $this->add_responsive_control(
                        'htmega_carousel_dots_border_radius',
                        [
                            'label' => __( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .flipster__nav__item .flipster__nav__link::after,
                                {{WRAPPER}} .htmega-flipster-pagination-custom .flipster__nav__link' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                    $this->add_responsive_control(
                        'htmega_carousel_dots_height',
                        [
                            'label' => __( 'Height', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 200,
                                    'step' => 1,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 40,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .flipster__nav__link' => 'height: {{SIZE}}px; display:flex; align-items:center; justify-content:center;',
                            ],
                        ]
                    );
    
                    $this->add_responsive_control(
                        'htmega_carousel_dots_width',
                        [
                            'label' => __( 'Width', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px'],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 200,
                                    'step' => 1,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 38,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .flipster__nav__link' => 'width: {{SIZE}}px !important;',
                            ],
                        ]
                    );
    
                    $this->add_responsive_control(
                        'htmega_carousel_dots_position_y',
                        [
                            'label' => __( 'Offset Y', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => -500,
                                    'max' => 500,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => -100,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => '',
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .flipster__nav' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-flipster-pagination-postion-after .flipster__nav' => 'margin-top: {{SIZE}}{{UNIT}}; margin-bottom: 0;',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'htmega_carousel_dots_pagination_inner_space',
                        [
                            'label' => __( 'Inner Gap', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 200,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => '5',
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .flipster__nav__item' => 'margin-right: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'pagination_padding',
                        [
                            'label' => esc_html__( 'Padding', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%' ],
                            'selectors' => [
                                '{{WRAPPER}} .flipster__nav__link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'before'
                        ]
                    );
                $this->end_controls_tab(); // Normal tab end
    
                // Hover tab Start
                $this->start_controls_tab(
                    'carousel_dots_style_hover_tab',
                    [
                        'label' => __( 'Active', 'htmega-pro' ),
                    ]
                );
    
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'carousel_dots_hover_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-flipster-pagination-custom .flipster__nav__item--current .flipster__nav__link,
                            {{WRAPPER}} .flipster__nav__item--current .flipster__nav__link::after,
                            {{WRAPPER}} .flipster__nav__item:hover .flipster__nav__link::after,
                            {{WRAPPER}} .htmega-flipster-pagination-custom .flipster__nav__link:hover',
                        ]
                    );
                    $this->add_control(
                        'dot_color_hover',
                        [
                            'label' => __( 'Index Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '#ffffff',
                            'selectors' => [
                                '{{WRAPPER}} .flipster__nav__item--current .flipster__nav__link, {{WRAPPER}} .flipster__nav__link:hover' => 'color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'htmega_carousel_dots_hover_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-flipster-pagination-custom .flipster__nav__item--current .flipster__nav__link,
                            {{WRAPPER}} .flipster__nav__item--current .flipster__nav__link::after,
                            {{WRAPPER}} .flipster__nav__item:hover .flipster__nav__link::after,
                            {{WRAPPER}} .htmega-flipster-pagination-custom .flipster__nav__link:hover',
                        ]
                    );
    
                    $this->add_responsive_control(
                        'htmega_carousel_dots_hover_border_radius',
                        [
                            'label' => __( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-flipster-pagination-custom .flipster__nav__item--current .flipster__nav__link,
                                {{WRAPPER}} .flipster__nav__item--current .flipster__nav__link::after,
                                {{WRAPPER}} .flipster__nav__item:hover .flipster__nav__link::after,
                                {{WRAPPER}} .htmega-flipster-pagination-custom .flipster__nav__link:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
    
                $this->end_controls_tab(); // Hover tab end
    
            $this->end_controls_tabs();
    
        $this->end_controls_section(); // Style dots style end


        // Caption Style
        $this->start_controls_section(
			'flip_caption_styles_section',
			[
				'label' => esc_html__( 'Caption', 'htmega-pro' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'flip_caption_switcher' => 'yes'
				]
			]
		);

		$this->add_control(
			'caption_color',
			[
				'label'  => esc_html__( 'Color', 'htmega-pro' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .htmega-flip-caption' => 'color: {{VALUE}}',
				],
			]
		);
			
		$this->add_control(
			'caption_background_color',
			[
				'label'  => esc_html__( 'Background Color', 'htmega-pro' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .htmega-flip-caption' => 'background-color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'caption_typography',
                'selector' => '{{WRAPPER}} .htmega-flip-caption',
            ]
        );

		$this->add_responsive_control(
			'flipcaption_padding',
			[
				'label' => esc_html__( 'Padding', 'htmega-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .htmega-flip-caption' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'flipcaption_margin',
			[
				'label' => esc_html__( 'Margin', 'htmega-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .htmega-flip-caption' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'flipcaption_alignment',
			[
				'label' => esc_html__( 'Alignment', 'htmega-pro' ),
				'type' => Controls_Manager::CHOOSE,
				'label_block' => false,
				'default' => 'center',
				'separator' => 'before',
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'htmega-pro' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'htmega-pro' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'htmega-pro' ),
						'icon' => 'eicon-text-align-right',
					],
				],
                'selectors' => [
					'{{WRAPPER}} .htmega-flip-caption' => 'text-align: {{VALUE}};',
				]
			]
		);

		$this->end_controls_section();

    }

    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();
        $carouseles = $this->get_settings_for_display('carousel_list');
        $id         = $this->get_id();
        $slarrows_type        = $settings['slarrows_type'];
        $print_next = $print_prev = '';
        if( $slarrows_type == 'icon' ) {
            $print_next =  HTMega_Icon_manager::render_icon( $settings['slarrowsicon_font_next'], [ 'aria-hidden' => 'true' ] );
            $print_prev = HTMega_Icon_manager::render_icon( $settings['slarrowsicon_font_prev'], [ 'aria-hidden' => 'true' ] );
                
        } else if( $slarrows_type == 'text' ) {
            $print_next = $settings['slarrowsicon_font_next_nav'];
            $print_prev = $settings['slarrowsicon_font_prev_nav'];

        }
        $this->add_render_attribute( 'area_attr', 'class', 'htmega-flipster htmega-flipster-' . esc_attr( $settings['carousel_style'] ) );
        $this->add_render_attribute( 'area_attr', 'style', 'overflow:hidden; display:none;' );

        if ( isset($settings['flip_caption_position'] ) ) {
            $this->add_render_attribute( 'area_attr', 'class', 'htmega-flipster-content-' . esc_attr( $settings['flip_caption_position'] ) );
        }
        if( 'yes' == $settings['sldots']  && $settings['pagination_style'] ) {

            $this->add_render_attribute( 'area_attr', 'class', 'htmega-flipster-pagination-' . esc_attr( $settings['pagination_style'].' htmega-flipster-pagination-postion-'. $settings['dots_position'] ) );
        }

        $carousel_settings = [
            'style'  => esc_attr( $settings['carousel_style'] ),
            'spacing'  => esc_attr( $settings['spacing'] ),
            'start' => esc_attr( $settings['carousel_start'] ),
            'fadein' => esc_attr( $settings['carousel_fadein'] ),
            'loop' => ( 'yes' === $settings['carousel_loop'] ),
            'keyboard' => ( 'yes' === $settings['carousel_keyboard'] ),
            'scrollwheel' => ( 'yes' === $settings['carousel_scrollwheel'] ),
            'autoplay' => ( 'yes' === $settings['carousel_autoplay'] ),
            'autoplay_speed' => absint( $settings['autoplay_speed'] ),
            'arrows' => ('yes' === $settings['slarrows']) ? 'custom' : false,
            'prev_txt' => $print_prev,
            'next_txt' => $print_next,
            'dots' => ( 'yes' === $settings['sldots'] ),
            'dots_position' => ( $settings['dots_position'] ) ? $settings['dots_position'] : false,
        ];
        $this->add_render_attribute( 'area_attr', 'data-settings', wp_json_encode( $carousel_settings ) );

        if( is_array( $carouseles ) ){
        ?>                
            <div <?php echo $this->get_render_attribute_string( 'area_attr' ); ?> >
                <ul>
                    <?php 
                        foreach ( $carouseles as $carousele ){
                            $url = $carousele['_id'];
                            if ( ! empty( $carousele['image_link']['url'] ) ) {
                                $this->add_link_attributes( $url, $carousele['image_link'] );
                            }
                            if ( HTMEGA_ADDONS_PL_URL.'assets/images/image-placeholder.png' === $carousele['flip_image']['url'] ) {
                                $flip_image = '<img src="'. esc_url( $carousele['flip_image']['url'] ) . '" />';
                            } else {
                                $allText = !empty($carousele['flip_image']['alt']) ? $carousele['flip_image']['alt'] : esc_html( 'Flip Image', 'htmega-pro' );
                                $flip_image = '<img alt="'. esc_attr( $allText ) . '" src="'.  Group_Control_Image_Size::get_attachment_image_src( $carousele['flip_image']['id'], 'flip_image_size', $settings ) .'" />';
                            }

                            echo '<li>';
                            if ( 'yes' == $settings['show_image_link'] ) {
                                echo '<a '.$this->get_render_attribute_string( $url).' >';
                                echo wp_kses_post( $flip_image ) .'</a>';
                            } else {
                                echo wp_kses_post( $flip_image );
                            }
                            if ( $carousele['flip_caption']  && 'yes' === $settings['flip_caption_switcher'] ) {
                                echo '<div class="htmega-flip-caption">' . htmega_kses_desc( $carousele['flip_caption'] ) . '</div>';
                            }
                            
                            echo '</li>';
                        }
                    ?>
                </ul>
            </div>
        <?php
        }

    }

}