<?php
namespace Elementor;
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\HTMega_Icon_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
use Elementor\Repeater;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Flip_Switcher_Pricing_Table_Element extends Widget_Base {
    public function get_name() {
        return 'htmega-flip-switcher-pricing-table-addons';
    }
    
    public function get_title() {
        return esc_html__( 'Flip Switcher Pricing Table', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-dual-button';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }

    public function get_keywords() {
        return [ 'htmega', 'ht mega', 'flip switcher pricing table', 'flip', 'switcher', 'flip switcher' ];
    }

    public function get_help_url() {
		return 'https://wphtmega.com/docs/';
	}
    protected function register_controls() {
        $this->_general_controls();
        $this->_style_controls();
    }

    protected function _general_controls(){ 
        $this->__seitcher_pricing_menu_list_section();
        $this->__seitcher_Package_section();
    }

    //Feature
    protected function __seitcher_pricing_menu_list_section(){
        // Features tab start
        $this->start_controls_section(
            'htmega_pricing_filp_switcher',
            [
                'label' => esc_html__('Pricing Menu', 'htmega-pro'),
            ]
        );

        $this->add_control(
            'htmega_package_plan',
            [
                'label' => esc_html__('Select Package', 'htmega-pro'),
                'type' => 'htmega-preset-select',
                'default' => '2',
                'options' => [
                    '1'   => esc_html__('Pricing One', 'htmega-pro'),
                    '2'   => esc_html__('Pricing Two', 'htmega-pro'),
                    '3'   => esc_html__('Pricing Three', 'htmega-pro'),
                ],
            ]
        );

            $this->add_control(
                "htmega_switcher_menu_list_1",
                [
                    'label'   => esc_html__("Pricing Menu 1", "htmega-pro"),
                    'type'    => Controls_Manager::TEXT,
                    'default' => esc_html__('Monthly', 'htmega-pro'),
                    'label_block' => true,
                    'dynamic' => [
                        'active' => true,
                    ],
                    'conditions' => [
                        'terms' => [
                            [
                                'name' => 'htmega_package_plan',
                                'operator' => '>=',
                                'value' => 1,
                            ],
                        ],
                    ],
                ]
            );

            $this->add_control(
                "htmega_switcher_menu_list_2",
                [
                    'label'   => esc_html__("Pricing Menu 2", "htmega-pro"),
                    'type'    => Controls_Manager::TEXT,
                    'default' => esc_html__('Yearly', 'htmega-pro'),
                    'label_block' => true,
                    'dynamic' => [
                        'active' => true,
                    ],
                    'conditions' => [
                        'terms' => [
                            [
                                'name' => 'htmega_package_plan',
                                'operator' => '>=',
                                'value' => 2,
                            ],
                        ],
                    ],
                ]
            );

            $this->add_control(
                "htmega_switcher_menu_list_3",
                [
                    'label'   => esc_html__("Pricing Menu 3", "htmega-pro"),
                    'type'    => Controls_Manager::TEXT,
                    'default' => esc_html__('Lifetime', 'htmega-pro'),
                    'label_block' => true,
                    'dynamic' => [
                        'active' => true,
                    ],
                    'conditions' => [
                        'terms' => [
                            [
                                'name' => 'htmega_package_plan',
                                'operator' => '>=',
                                'value' => 3,
                            ],
                        ],
                    ],
                ]
            );
        $this->end_controls_section(); // 

    }
    
    //Feature
    protected function __seitcher_Package_section(){
        $this->start_controls_section(
            'htmega_switcher_package_plan',
            [
                'label' => esc_html__('Package Plan', 'htmega-pro'),
            ]
        );

            $this->add_control(
                'select_htmega_total_package',
                [
                    'label' => esc_html__('Select Package Plan', 'htmega-pro'),
                    'type' => 'htmega-preset-select',
                    'default' => '3',
                    'options' => [
                        '1'   => esc_html__('Package One', 'htmega-pro'),
                        '2'   => esc_html__('Package Two', 'htmega-pro'),
                        '3'   => esc_html__('Package Three', 'htmega-pro'),
                        '4'   => esc_html__('Package Four', 'htmega-pro'),
                        '5'   => esc_html__('Package Five', 'htmega-pro'),
                        '6'   => esc_html__('Package Six', 'htmega-pro'),
                    ],
                ]
            );

            $this->add_control(
                'select_htmega_column',
                [
                    'label' => esc_html__('Select column', 'htmega-pro'),
                    'type' => 'htmega-preset-select',
                    'default' => '3',
                    'options' => [
                        '1'   => esc_html__('column One', 'htmega-pro'),
                        '2'   => esc_html__('column Two', 'htmega-pro'),
                        '3'   => esc_html__('column Three', 'htmega-pro'),
                        '4'   => esc_html__('column Four', 'htmega-pro'),
                        '5'   => esc_html__('column Five', 'htmega-pro'),
                    ],
                ]
            );
    
            //Monthly 
            $this->add_control(
                "package_name_monthly",
                [
                    'label' => esc_html__( 'Monthly Package', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'conditions' => [
                        'terms' => [
                            [
                                'name' => 'htmega_package_plan',
                                'operator' => '>=',
                                'value' => 1,
                            ],
                        ],
                    ],
                ]
            );
    
            for($i = 1; $i <=6; $i++){
                $this->add_control(
                    "template_id_monthly_{$i}",
                    [
                        'label' => sprintf( // translators: %s represents the dynamic content that will be escaped as HTML
                            esc_html__( 'Package %s', 'htmega-pro' ),
                            esc_attr( $i )
                        ),
                        'type'        => Controls_Manager::SELECT,
                        'default'     => '0',
                        'options'     => htmega_elementor_template(),
                        'conditions' => [
                            'relation' => 'and',
                            'terms' => [
                                [
                                    'name' => 'select_htmega_total_package',
                                    'operator' => '>=',
                                    'value' => $i,
                                ],
                                [
                                    'name' => 'htmega_package_plan',
                                    'operator' => '>=',
                                    'value' => 1,
                                ],
                            ],
                        ],
                    ]
                );
            }

            //Yearly
            $this->add_control(
                "package_name_yearly",
                [
                    'label' => esc_html__( 'Yearly Package', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'conditions' => [
                        'terms' => [
                            [
                                'name' => 'htmega_package_plan',
                                'operator' => '>=',
                                'value' => 2,
                            ],
                        ],
                    ],
                ]
            );
    
            for($i = 1; $i <=6; $i++){
                $this->add_control(
                    "template_id_yearly_{$i}",
                    [
                        'label' => sprintf( // translators: %s represents the dynamic content that will be escaped as HTML
                            esc_html__( 'Package %s', 'htmega-pro' ),
                            esc_attr( $i )
                        ),
                        'type'        => Controls_Manager::SELECT,
                        'default'     => '0',
                        'options'     => htmega_elementor_template(),
                        'conditions' => [
                            'relation' => 'and',
                            'terms' => [
                                [
                                    'name' => 'select_htmega_total_package',
                                    'operator' => '>=',
                                    'value' => $i,
                                ],
                                [
                                    'name' => 'htmega_package_plan',
                                    'operator' => '>=',
                                    'value' => 2,
                                ],
                            ],
                        ],
                    ]
                );
            }

            //Lifetime
            $this->add_control(
                "package_name_lifetime",
                [
                    'label' => esc_html__( 'Lifetime Package', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'htmega_package_plan' => '3',
                    ],
                ]
            );

            for($i = 1; $i <=6; $i++){
                $this->add_control(
                    "template_id_lifetime_{$i}",
                    [
                        'label' => sprintf( // translators: %s represents the dynamic content that will be escaped as HTML
                            esc_html__( 'Package %s', 'htmega-pro' ),
                            esc_attr( $i )
                        ),
                        'type'        => Controls_Manager::SELECT,
                        'default'     => '0',
                        'options'     => htmega_elementor_template(),
                        'conditions' => [
                            'relation' => 'and',
                            'terms' => [
                                [
                                    'name' => 'select_htmega_total_package',
                                    'operator' => '>=',
                                    'value' => $i,
                                ],
                                [
                                    'name' => 'htmega_package_plan',
                                    'operator' => '>=',
                                    'value' => 3,
                                ],
                            ],
                        ],
                    ]
                );
            }
        $this->end_controls_section(); // Style tab section end 
    }


    //_style_controls
    protected function _style_controls() {
        $this->__switcher_menu_area_section();
        $this->__switcher_content_area_section();
    }

    protected function __switcher_menu_area_section(){
        // Style tab section
        $this->start_controls_section(
            'flip_switcher_menu_style_section',
            [
                'label' => esc_html__( 'Flip Switcher Menu', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_control(
                'flip_switcher_menu_style_area',
                [
                    'label' => esc_html__( 'Tab Area Style', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                ]
            );

            
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'flip_switcher_menu_area_background',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}}  .htmega-pt-flip-box-switcher',
                ]
            );
            
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'flip_switcher_menu_area_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-pt-flip-box-switcher',
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'flip_switcher_menu_area_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pt-flip-box-switcher' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );

            $this->add_responsive_control(
                'flip_switcher_menu_area_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pt-flip-box-switcher' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'flip_switcher_menu_area_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pt-flip-box-switcher' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'flip_switcher_menu_style',
                [
                    'label' => esc_html__( 'Switcher Manu Style', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->start_controls_tabs('flip_switcher_menu_style_tabs');

                $this->start_controls_tab(
                    'flip_switcher_menu_style_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'htmega-pro' ),
                    ]
                );

                    $this->add_responsive_control(
                        'flip_switcher_menu_align',
                        [
                            'label'   => __( 'Alignment', 'htmega-pro' ),
                            'type'    => Controls_Manager::CHOOSE,
                            'options' => [
                                'start'    => [
                                    'title' => __( 'Left', 'htmega-pro' ),
                                    'icon'  => 'eicon-text-align-left',
                                ],
                                'center' => [
                                    'title' => __( 'Center', 'htmega-pro' ),
                                    'icon'  => 'eicon-text-align-center',
                                ],
                                'end' => [
                                    'title' => __( 'Right', 'htmega-pro' ),
                                    'icon'  => 'eicon-text-align-right',
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pt-flip-box-switcher'   => 'justify-content: {{VALUE}} !important;',
                            ],
                            'default' =>'center',
                            'separator' => 'after',
                        ]
                    );

                    $this->add_control(
                        'flip_switcher_menu_color',
                        [
                            'label'     => esc_html__( 'Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pt-flip-box-switcher-inner .text' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'flip_switcher_menu_typography',
                            'label' => esc_html__( 'Typography', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-pt-flip-box-switcher-inner .text',
                            'separator' => 'before',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'flip_switcher_menu_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-pt-flip-box-switcher .htmega-pt-flip-box-switcher-inner',
                        ]
                    );

                    $this->add_responsive_control(
                        'flip_switcher_menu_padding',
                        [
                            'label' => esc_html__( 'Padding', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pt-flip-box-switcher .htmega-pt-flip-box-switcher-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'before',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'flip_switcher_menu_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-pt-flip-box-switcher .htmega-pt-flip-box-switcher-inner',
                        ]
                    );

                    $this->add_responsive_control(
                        'flip_switcher_menu_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pt-flip-box-switcher .htmega-pt-flip-box-switcher-inner' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab(); // Normal style 

                // Active tab style
                $this->start_controls_tab(
                    'flip_switcher_menu_style_active_tab',
                    [
                        'label' => esc_html__( 'Active', 'htmega-pro' ),
                    ]
                );
                    
                    $this->add_control(
                        'flip_switcher_menu_active_color',
                        [
                            'label'     => esc_html__( 'Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pt-flip-box-switcher input[type="radio"]:checked + label .text' => 'color: {{VALUE}}',
    
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'flip_switcher_menu_active_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-pt-flip-box-switcher input[type="radio"]:checked + label::before',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'flip_switcher_menu_active_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-pt-flip-box-switcher input[type="radio"]:checked + label::before',
                        ]
                    );

                    $this->add_responsive_control(
                        'flip_switcher_menu_active_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pt-flip-box-switcher input[type="radio"]:checked + label::before' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab();

            $this->end_controls_tabs();

            
        $this->end_controls_section();
    }

    protected function __switcher_content_area_section(){
        // Style tab section
        $this->start_controls_section(
            'flip_switcher_style_content_section',
            [
                'label' => esc_html__( 'Content', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'flip_switcher_content_background',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-pt-flip-box',
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'flip_switcher_content_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-pt-flip-box',
                ]
            );

            $this->add_responsive_control(
                'flip_switcher_content_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pt-flip-box' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );

            $this->add_responsive_control(
                'flip_switcher_content_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pt-flip-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'flip_switcher_content_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pt-flip-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();
    }

    protected function render( $instance = [] ) { 
        $settings   = $this->get_settings_for_display();
        $unicid         = $this->get_id();
        $flip_switcher_settings = [
            'box_switcher_container' => '.htmega-pt-flip-box-switcher-container-' . esc_attr( $unicid ),
        ];


        $this->add_render_attribute( 'flip_switcher_settings_attr', 'class', 'htmega-flip-box-switcher-active' );
        $this->add_render_attribute( 'flip_switcher_settings_attr', 'data-settings', wp_json_encode( $flip_switcher_settings ) );

    ?>
    <div <?php echo $this->get_render_attribute_string( 'flip_switcher_settings_attr' ); ?>>
        <div class="htmega-pt-flip-box-wrap ">
            <div class="htmega-pt-flip-box-switcher-container">
                <div class="htmega-pt-flip-box-switcher">
                    <div class="htmega-pt-flip-box-switcher-inner">
                        <?php 
                            
                            for($i = 1; $i <= $settings['htmega_package_plan']; $i++ ): 
                                $switcher_menu_list = strtolower($settings["htmega_switcher_menu_list_{$i}"]."_".$this->get_id());
                                $checked = ($settings['htmega_package_plan'] == $i) ? "checked" : "";
                            ?>
                                
                                <input type="radio" name="duration_<?php echo esc_attr( $this->get_id() )?>" value="<?php echo esc_attr( $switcher_menu_list ) ?>" id="<?php echo esc_attr( $switcher_menu_list ) ?>" <?php echo esc_attr( $checked ) ?>>
                                <label for="<?php echo esc_attr( $switcher_menu_list ) ?>" data-target="<?php echo esc_attr( $switcher_menu_list ) ?>"><span class="text"><?php echo esc_html( $settings["htmega_switcher_menu_list_{$i}"] ) ?></span></label>
                                
                            <?php endfor ?>
                    </div>
                </div>

                <div class="htmega-mpg-row htmega-pt-flip-box-main-active htmega-pt-flip-box-bounce-invert">    
                    <?php for($j=1; $j <= $settings['select_htmega_total_package']; $j++ ):?>
                            
                        <div class="htmega-mpg-col-<?php echo esc_attr( $settings["select_htmega_column"] ) ?>">
                            <div class="htmega-pt-flip-box htmega-pt-flip-box-element-2 htmega-pt-flip-box-active">

                                <div class="htmega-pt-flip-box__side <?php echo (1 == $settings['htmega_package_plan']) ? "is-visible":"is-hidden" ?>" data-type="<?php echo esc_attr( strtolower($settings["htmega_switcher_menu_list_1"]."_".$this->get_id()) ) ?>">
                                    <?php                                            
                                        if(isset( $settings["template_id_monthly_{$j}"] ) && !empty( $settings["template_id_monthly_{$j}"])){
                                            echo htmega_get_template_content_by_id( $settings["template_id_monthly_{$j}"]); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                                        }
                                    ?>
                                </div>

                                <div class="htmega-pt-flip-box__side <?php echo (2 == $settings['htmega_package_plan']) ? "is-visible":"is-hidden" ?>" data-type="<?php echo esc_attr( strtolower($settings["htmega_switcher_menu_list_2"]."_".$this->get_id()) ) ?>">
                                    <?php                                            
                                        if(isset( $settings["template_id_yearly_{$j}"] ) && !empty( $settings["template_id_yearly_{$j}"] )){
                                            echo htmega_get_template_content_by_id( $settings["template_id_yearly_{$j}"] ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                                        }
                                    ?>
                                </div>

                                <div class="htmega-pt-flip-box__side <?php echo (3 == $settings['htmega_package_plan']) ? "is-visible":"is-hidden" ?>" data-type="<?php echo esc_attr( strtolower($settings["htmega_switcher_menu_list_3"]."_".$this->get_id()) ) ?>">
                                    <?php                                            
                                            if(isset( $settings["template_id_lifetime_{$j}"] ) && !empty( $settings["template_id_lifetime_{$j}"] )){
                                            echo htmega_get_template_content_by_id( $settings["template_id_lifetime_{$j}"] ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                                        }
                                    ?>
                                </div>
                            </div>
                        </div>
                    <?php endfor ?>
                </div>
            </div>
        </div>
    </div>
    <?php }
}