<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\HTMega_Icon_Manager;
use Elementor\Group_Control_Image_Size;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Icon_Box_Element extends Widget_Base {
    public function get_name() {
        return 'htmega-icon-box-addons';
    }
    
    public function get_title() {
        return esc_html__( 'Icon Box', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-icon-box';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }

    public function get_keywords() {
        return [ 'htmega', 'ht mega', 'icon', 'icon box', 'box', 'htmega pro' ];
    }

    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/general-widgets/icon-box-widget/';
	}
    protected function is_dynamic_content():bool {
		return false;
	}
    protected function register_controls() {
        $this->_general_controls();
        $this->_style_controls();
    }

    protected function _general_controls(){ 
        $this->__icon_box_section();
    }

    protected function __icon_box_section() {
        $this->start_controls_section(
            'icon_box_section',
            [
                'label' => esc_html__( 'Icon Box', 'htmega-pro' ),
            ]
        );

            $this->add_control(
                'icon_type',
                [
                    'label'   => esc_html__( 'Icon Type', 'htmega-pro' ),
                    'type'    => Controls_Manager::CHOOSE,
                    'toggle' => false,
                    'options' => [
                        'none' => [
                            'title' => esc_html__( 'None', 'htmega-pro' ),
                            'icon'  => 'eicon-ban',
                        ],
                        'icon' => [
                            'title' => esc_html__( 'Icon', 'htmega-pro' ),
                            'icon'  => 'eicon-info-circle',
                        ],
                        'image' => [
                            'title' => esc_html__( 'Image', 'htmega-pro' ),
                            'icon'  => 'eicon-image-bold',
                        ],
                        'number' => [
                            'title' => esc_html__( 'Number', 'htmega-pro' ),
                            'icon'  => 'eicon-counter',
                        ],
                    ],
                    'default' => 'icon',
                ]
            );
            $this->add_control(
                'icon_box_number',
                [
                    'label'         => esc_html__( 'Number', 'htmega-pro' ),
                    'type'          => Controls_Manager::TEXT,
                    'default'       => esc_html__( '01', 'htmega-pro' ),
                    'condition'=>[
                        'icon_type'=>'number',
                    ],
                ]
            );

            $this->add_control(
                'icon_box_icon',
                [
                    'label'         => esc_html__( 'Icon', 'htmega-pro' ),
                    'type'          => Controls_Manager::ICONS,
                    'default' => [
                        'value' => 'fas fa-info',
                        'library' => 'fa-solid',
                    ],
                    'condition'=>[
                        'icon_type'=>'icon',
                    ],
                ]
            );

            $this->add_control(
                'icon_box_image',
                [
                    'label' => esc_html__('Image','htmega-pro'),
                    'type'=>Controls_Manager::MEDIA,
                    'dynamic' => [
                        'active' => true,
                    ],
                    'condition' => [
                        'icon_type' => 'image',
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'icon_box_imagesize',
                    'default' => 'thumbnail',
                    'separator' => 'none',
                    'condition' => [
                        'icon_box_image[url]!' => '',
                        'icon_type' => 'image',
                    ]
                ]
            );

            $this->add_control(
                'icon_box_title',
                [
                    'label'         => esc_html__( 'Title', 'htmega-pro' ),
                    'type'          => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default'       => esc_html__( 'Icon Box Title', 'htmega-pro' ),
                    'separator' => 'before',
                    'dynamic' => [
                        'active' => true,
                    ]
                ]
            );
            
            $this->add_control(
                'icon_box_description',
                [
                    'label'         => esc_html__( 'Description', 'htmega-pro' ),
                    'type'          => Controls_Manager::TEXTAREA,
                    'rows' => 5,
                    'dynamic' => [
                        'active' => true,
                    ]
                ]
            );

            $this->add_control(
                'indexing_number',
                [
                    'label'         => esc_html__( 'Index Number', 'htmega-pro' ),
                    'type'          => Controls_Manager::TEXT,
                    'label_block' => true,
                    'placeholder'       => esc_html__( '01', 'htmega-pro' ),
                    'dynamic' => [
                        'active' => true,
                    ],
                ]
            );

            $this->add_control(
                'icon_box_button_link',
                [
                    'label' => __( 'Box Link', 'htmega-pro' ),
                    'type' => Controls_Manager::URL,
                    'placeholder' => 'https://example.com',
                    'dynamic' => [
                        'active' => true,
                    ],
                    'default' => [
                        'url' => '',
                    ]
                ]
            );

            $this->add_control(
                'additional_options',
                [
                    'label' => esc_html__( 'Additional Options', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'icon_and_title_position',
                [
                    'label'   => esc_html__( 'Icon And Title Position', 'htmega-pro' ),
                    'type'    => Controls_Manager::CHOOSE,
                    'toggle' => false,
                    'options' => [
                        'left' => [
                            'title' => esc_html__('Left', 'htmega-pro'),
                            'icon' => 'eicon-h-align-left',
                        ],
                        'top' => [
                            'title' => esc_html__('Top', 'htmega-pro'),
                            'icon' => 'eicon-v-align-top',
                        ],
                        'bottom' => [
                            'title' => esc_html__('Bottom', 'htmega-pro'),
                            'icon' => 'eicon-v-align-bottom',
                        ],
                        'right' => [
                            'title' => esc_html__('Right', 'htmega-pro'),
                            'icon' => 'eicon-h-align-right',
                        ],
                        
                    ],
                    'default' => 'top',
                    'condition' => [
                        'icon_type!' =>'none',
                    ]
                ]
            );

            $this->add_control(
                'icon_box_title_tag',
                [
                    'label' => esc_html__('Select Title Tag', 'htmega-pro'),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'h3',
                    'options' => [
                        'h1' => esc_html__('H1', 'htmega-pro'),
                        'h2' => esc_html__('H2', 'htmega-pro'),
                        'h3' => esc_html__('H3', 'htmega-pro'),
                        'h4' => esc_html__('H4', 'htmega-pro'),
                        'h5' => esc_html__('H5', 'htmega-pro'),
                        'h6' => esc_html__('H6', 'htmega-pro'),
                        'span' => esc_html__('Span', 'htmega-pro'),
                        'p' => esc_html__('P', 'htmega-pro'),
                        'div' => esc_html__('Div', 'htmega-pro'),
                    ],
                    'condition' => [
                        'icon_box_title[value]!' =>'',
                    ]
                ]
            );

        $this->end_controls_section();
    }


    //_style_controls
    protected function _style_controls() {
        $this->__icon_box_style();
        $this->__icon_style();
        $this->__title_style();
        $this->__description_style();
        $this->__indexing_style();

    }

    protected function __icon_box_style() {
        // Icon box style section
        $this->start_controls_section(
            'box_style',
            [
                'label' => esc_html__( 'Icon Box Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_responsive_control(
                'box_normal_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-icon-box-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                    ],
                ]
            );

            $this->add_responsive_control(
                'box_normal_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-icon-box-card' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            
            $this->start_controls_tabs('icon_box_style_tabs');
                
                // Box Normal Style Tab
                $this->start_controls_tab(
                    'box_normal_style_tab',
                    [
                        'label' => esc_html__( 'Normal', 'htmega-pro' ),
                    ]
                );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'box_normal_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-icon-box-card',
                        ]
                    );
    
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'box_normal_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-icon-box-card',
                        ]
                    );

                    $this->add_responsive_control(
                        'box_normal_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-icon-box-card' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'box_normal_shadow',
                            'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-icon-box-card',
                        ]
                    );

                $this->end_controls_tab();

                // Box Hover Style Tab
                $this->start_controls_tab(
                    'box_hover_style_tab',
                    [
                        'label' => esc_html__( 'Hover', 'htmega-pro' ),
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'box_hover_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-icon-box-card:hover',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'box_hover_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-icon-box-card:hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'box_hover_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-icon-box-card:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'box_hover_shadow',
                            'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-icon-box-card:hover',
                        ]
                    );

                $this->end_controls_tab();

            $this->end_controls_tabs();

            $this->add_control(
                'after_bottom_color_switcher',
                [
                    'label' => esc_html__( 'Bottom Active Color', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                    'separator' => 'before',
                    'condition' => [
                        'icon_box_top_style_switcher!' =>'yes'
                    ]
                ]
            );

            $this->start_controls_tabs(
                'after_bottom_style_tab'
            );

                $this->start_controls_tab(
                    'after_bottom_normal_style_tab',
                    [
                        'label' => esc_html__( 'Normal', 'htmega-pro' ),
                        'condition' => [
                            'after_bottom_color_switcher' =>'yes'
                        ]
                    ]
                );

                    $this->add_control(
                        'after_normal_button_color',
                        [
                            'label' => esc_html__( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-icon-box-card.htmega-icon-box-card-5::after' => 'background-color: {{VALUE}}',
                            ],
                            'condition' => [
                                'after_bottom_color_switcher' =>'yes',
                                'icon_box_top_style_switcher!' =>'yes'
                            ]
                            
                        ]
                    );
    
                    $this->add_responsive_control(
                        'after_normal_button_position',
                        [
                            'label' => esc_html__( 'Position', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => -500,
                                    'max' => 500,
                                    'step' => 1,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 0,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-icon-box-card.htmega-icon-box-card-5::after' => 'bottom: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'after_bottom_color_switcher' =>'yes',
                            ]
                        ]
                    );

                    $this->add_responsive_control(
                        'after_normal_button_height',
                        [
                            'label' => esc_html__( 'Height', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 100,
                                    'step' => 1,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-icon-box-card.htmega-icon-box-card-5::after' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'after_bottom_color_switcher' =>'yes',
                            ]
                        ]
                    );

                    $this->add_responsive_control(
                        'after_normal_button_Width',
                        [
                            'label' => esc_html__( 'Width', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 500,
                                    'step' => 1,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-icon-box-card.htmega-icon-box-card-5::after' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'after_bottom_color_switcher' =>'yes',
                            ]
                        ]
                    );

                $this->end_controls_tab();

                $this->start_controls_tab(
                    'after_bottom_hover_style_tab',
                    [
                        'label' => esc_html__( 'Hover', 'htmega-pro' ),
                        'condition' => [
                            'after_bottom_color_switcher' =>'yes'
                        ]
                    ]
                );

                    $this->add_control(
                        'after_hover_button_color',
                        [
                            'label' => esc_html__( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-icon-box-card.htmega-icon-box-card-5:hover::after' => 'background-color: {{VALUE}}',
                            ],
                            'condition' => [
                                'after_bottom_color_switcher' =>'yes',
                                'icon_box_top_style_switcher!' =>'yes'
                            ]
                            
                        ]
                    );

                    $this->add_responsive_control(
                        'after_hover_button_position',
                        [
                            'label' => esc_html__( 'Position', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => -500,
                                    'max' => 500,
                                    'step' => 1,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 0,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-icon-box-card.htmega-icon-box-card-5:hover::after' => 'bottom: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'after_bottom_color_switcher' =>'yes',
                            ]
                        ]
                    );

                    $this->add_responsive_control(
                        'after_hover_button_height',
                        [
                            'label' => esc_html__( 'Height', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 100,
                                    'step' => 1,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-icon-box-card.htmega-icon-box-card-5:hover::after' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'after_bottom_color_switcher' =>'yes',
                            ]
                        ]
                    );

                    $this->add_responsive_control(
                        'after_hover_button_Width',
                        [
                            'label' => esc_html__( 'Width', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 500,
                                    'step' => 1,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-icon-box-card.htmega-icon-box-card-5:hover::after' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'after_bottom_color_switcher' =>'yes',
                            ]
                        ]
                    );

                $this->end_controls_tabs();

            $this->end_controls_tab();

        $this->end_controls_section();
    }

    protected function __icon_style() {
        // icon box icon style
        $this->start_controls_section(
            'icon_box_icon_style_section',
            [
                'label' => esc_html__( 'Icon Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'icon_type!' =>'none',
                ]
            ]
        );
            
            $this->add_responsive_control(
                'icon_width_top_buttom',
                [
                    'label' => esc_html__( 'Width', 'htmega-pro' ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 500,
                        ],
                    ],
                    'default' => [
                        'size' =>110,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-icon-box-icon' => 'width: {{SIZE}}px;',
                    ],
                    'condition' => [
                        'icon_and_title_position' => ['top','buttom'],
                    ]
                ]
            );

            $this->add_responsive_control(
                'icon_width_left_right',
                [
                    'label' => esc_html__( 'Width', 'htmega-pro' ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 500,
                        ],
                    ],
                    'default' => [
                        'size' =>110,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-icon-box-icon' => 'width: {{SIZE}}px;',
                        '{{WRAPPER}} .htmega-icon-box-content' => 'width: calc(100% - {{SIZE}}px);',
                    ],
                    'condition' => [
                        'icon_and_title_position' => ['left','right'],
                    ]
                ]
            );

            $this->add_responsive_control(
                'icon_height',
                [
                    'label' => esc_html__( 'Height', 'htmega-pro' ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 500,
                        ],
                    ],
                    'default' => [
                        'size' =>110,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-icon-box-icon' => 'height: {{SIZE}}px; line-height:{{SIZE}}px;',
                        '{{WRAPPER}} .htmega-icon-box-icon .htmega-icon-box-card-image i' => 'line-height:{{SIZE}}px;',                
                    ],
                ]
            );
            $this->add_responsive_control(
                'icon_font_size',
                [
                    'label' => esc_html__( 'Font Size', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 20,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-icon-box-icon i, {{WRAPPER}} .htmega-icon-box-icon' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-icon-box-icon .htmega-icon-box-card-image svg' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'icon_type!' =>'image',
                    ]
                ]
            );

            $this->start_controls_tabs('iconbox_icon_style_tabs');
                        
                // Box Normal Style Tab
                $this->start_controls_tab(
                    'iconbox_normal_style_tab',
                    [
                        'label' => esc_html__( 'Normal', 'htmega-pro' ),
                    ]
                );

                    $this->add_control(
                        'icon_color_normal',
                        [
                            'label' => esc_html__( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-icon-box-icon .htmega-icon-box-card-image' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .htmega-icon-box-icon .htmega-icon-box-card-image i' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .htmega-icon-box-icon .htmega-icon-box-card-image svg path' => 'fill: {{VALUE}}',
                            ],
                            'condition' => [
                                'icon_type!' =>'image',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'icon_background_normal',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-icon-box-icon, {{WRAPPER}} .htmega-icon-box-card.htmega-icon-box-card-5 .htmega-icon-box-icon::after',
                            
                        ]
                    );    
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'icon_border_normal',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-icon-box-icon',
                        ]
                    );
        
                    $this->add_responsive_control(
                        'icon_border_radius_normal',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-icon-box-icon, {{WRAPPER}} .htmega-icon-box-card.htmega-icon-box-card-5 .htmega-icon-box-icon::after' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );       
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'icon_box_shadow_normal',
                            'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-icon-box-icon',
                        ]
                    );

                $this->end_controls_tab();

                // Box Hover Style Tab
                $this->start_controls_tab(
                    'iconbox_icon_hover_style_tab',
                    [
                        'label' => esc_html__( 'Hover', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'icon_color_hover',
                        [
                            'label' => esc_html__( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [                                
                                '{{WRAPPER}} .htmega-icon-box-card:hover .htmega-icon-box-icon' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .htmega-icon-box-card:hover .htmega-icon-box-icon i' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .htmega-icon-box-card:hover .htmega-icon-box-icon svg path' => 'fill: {{VALUE}}',
                            ],
                            'condition' => [
                                'icon_type!' =>'image',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'icon_background_hover',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-icon-box-card:hover .htmega-icon-box-icon, {{WRAPPER}} .htmega-icon-box-card.htmega-icon-box-card-5:hover .htmega-icon-box-icon::after',
                            
                        ]
                    );    
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'icon_border_hover',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-icon-box-icon:hover',
                            'separator' =>'before'
                        ]
                    );
        
                    $this->add_responsive_control(
                        'icon_border_radius_hover',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-icon-box-icon:hover, {{WRAPPER}} .htmega-icon-box-card.htmega-icon-box-card-5:hover .htmega-icon-box-icon:hover::after' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );       
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'icon_box_shadow_hover',
                            'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-icon-box-icon:hover',
                        ]
                    );

                $this->end_controls_tab();

            $this->end_controls_tabs();


            $this->add_responsive_control(
                'icon_box_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-icon-box-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' =>'before'
                ]
            );

            $this->add_control(
                'icon_box_before_Heading',
                [
                    'label' => esc_html__( 'Icon Box Outer Shap Style', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            ); 


            $this->add_control(
                'icon_box_before_switcher',
                [
                    'label' => esc_html__( 'Outer Shap Style 1', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                    'separator' => 'before',
                    'condition' => [
                        'icon_box_top_style_switcher!' =>'yes',
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'icon_box_before_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-icon-box-card-5 .htmega-icon-box-icon::before',
                    'condition' => [
                        'icon_box_before_switcher' =>'yes',
                        'icon_box_top_style_switcher!' =>'yes',
                    ]
                ]
            );

            $this->add_responsive_control(
                'icon_box_before_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-icon-box-card-5 .htmega-icon-box-icon::before' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],

                    'condition' => [
                        'icon_box_before_switcher' =>'yes',
                        'icon_box_top_style_switcher!' =>'yes',
                    ]
                ]
            );

            $this->add_responsive_control(
                'icon_box_before_width',
                [
                    'label' => esc_html__( 'Width', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 500,
                            'step' => 1,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 190,
				    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-icon-box-card-5 .htmega-icon-box-icon::before' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'icon_box_before_switcher' =>'yes',
                        'icon_box_top_style_switcher!' =>'yes',
                    ]
                ]
            );

            $this->add_responsive_control(
                'icon_box_before_height',
                [
                    'label' => esc_html__( 'Height', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 500,
                            'step' => 1,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 57,
				    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-icon-box-card-5 .htmega-icon-box-icon::before' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'icon_box_before_switcher' =>'yes',
                        'icon_box_top_style_switcher!' =>'yes',
                    ]
                ]
            );

            $this->add_control(
                'icon_box_top_style_switcher',
                [
                    'label' => esc_html__( 'Outer Shap Style 2', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' => [
                        'icon_box_before_switcher!' =>'yes',
                        'after_bottom_color_switcher!' =>'yes',
                        'icon_box_before_inner_shap!' =>'yes',
                    ]
                ]
            );

            $this->add_control(
                'icon_box_top_style_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-icon-box-card-6 .htmega-icon-box-icon::before' => 'border-bottom-color: {{VALUE}} !important',
                        '{{WRAPPER}} .htmega-icon-box-card-6 .htmega-icon-box-icon::after' => 'border-top-color: {{VALUE}} !important',
                    ],
                    'condition' => [
                        'icon_box_top_style_switcher' =>'yes',
                        'icon_box_before_switcher!' =>'yes',
                        'icon_box_before_inner_shap!' =>'yes',
                    ]
                ]
            );

            $this->add_control(
                'icon_box_top_style_hover_color',
                [
                    'label' => esc_html__( 'Hover Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-icon-box-card-6:hover .htmega-icon-box-icon::before' => 'border-bottom-color: {{VALUE}} !important',
                        '{{WRAPPER}} .htmega-icon-box-card-6:hover .htmega-icon-box-icon::after' => 'border-top-color: {{VALUE}} !important',
                    ],
                    'condition' => [
                        'icon_box_top_style_switcher' =>'yes',
                        'icon_box_before_switcher!' =>'yes',
                        'icon_box_before_inner_shap!' =>'yes',
                        'icon_box_top_style_color!' =>'',
                    ]
                ]
            );

            $this->add_responsive_control(
                'icon_box_top_style_width',
                [
                    'label' => esc_html__( 'Width', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 500,
                            'step' => 0.1,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-icon-box-card-6 .htmega-icon-box-icon::before' => 'border-left: {{SIZE}}{{UNIT}} solid transparent; border-right:{{SIZE}}{{UNIT}} solid transparent;',
                        '{{WRAPPER}} .htmega-icon-box-card-6 .htmega-icon-box-icon::after' => 'border-left: {{SIZE}}{{UNIT}} solid transparent; border-right:{{SIZE}}{{UNIT}} solid transparent;',
                    ],
                    'condition' => [
                        'icon_box_top_style_switcher' =>'yes',
                        'icon_box_before_switcher!' =>'yes',
                        'icon_box_before_inner_shap!' =>'yes',
                    ]
                ]
            );

            $this->add_responsive_control(
                'icon_box_top_style_height',
                [
                    'label' => esc_html__( 'Height', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 500,
                            'step' => 0.1,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-icon-box-card-6 .htmega-icon-box-icon::before' => 'border-bottom: {{SIZE}}{{UNIT}} solid',
                        '{{WRAPPER}} .htmega-icon-box-card-6 .htmega-icon-box-icon::after' => 'border-top: {{SIZE}}{{UNIT}} solid',
                    ],
                    'condition' => [
                        'icon_box_top_style_switcher' =>'yes',
                        'icon_box_before_switcher!' =>'yes',
                        'icon_box_before_inner_shap!' =>'yes',
                    ]
                ]
            );


            $this->add_responsive_control(
                'icon_box_top_style_position_top',
                [
                    'label' => esc_html__( 'Position Top and Buttom', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => -500,
                            'max' => 500,
                            'step' => 0.1,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-icon-box-card-6 .htmega-icon-box-icon::before' => 'top: {{SIZE}}{{UNIT}}',
                        '{{WRAPPER}} .htmega-icon-box-card-6 .htmega-icon-box-icon::after' => 'bottom: {{SIZE}}{{UNIT}}',
                    ],
                    'condition' => [
                        'icon_box_top_style_switcher' =>'yes',
                        'icon_box_before_switcher!' =>'yes',
                        'icon_box_before_inner_shap!' =>'yes',
                    ]
                ]
            );

            $this->add_responsive_control(
                'icon_box_top_style_position_left',
                [
                    'label' => esc_html__( 'Position Left', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => -500,
                            'max' => 500,
                            'step' => 0.1,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-icon-box-card-6 .htmega-icon-box-icon::before' => 'left: {{SIZE}}{{UNIT}}',
                        '{{WRAPPER}} .htmega-icon-box-card-6 .htmega-icon-box-icon::after' => 'left: {{SIZE}}{{UNIT}}',
                    ],
                    'condition' => [
                        'icon_box_top_style_switcher' =>'yes',
                        'icon_box_before_switcher!' =>'yes',
                        'icon_box_before_inner_shap!' =>'yes',
                    ]
                ]
            );
            
            $this->add_control(
                'icon_box_inner_shap_Heading',
                [
                    'label' => esc_html__( 'Icon Box Inner Shap Style', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'icon_box_top_style_switcher!' =>'yes',
                    ]
                ]
            ); 

            $this->add_control(
                'icon_box_before_inner_shap',
                [
                    'label' => esc_html__( 'Inner Shap', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes', 
                    'default' => 'no',
                    'condition' => [
                        'icon_box_top_style_switcher!' =>'yes',
                    ]
                ]
            );

            $this->add_control(
                'icon_box_inner_shap_style_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-icon-box-card .htmega-icon-box-card-inner-shap svg path' => 'fill: {{VALUE}}',
                    ],
                    'condition' => [
                        'icon_box_top_style_switcher!' =>'yes',
                        'icon_box_before_inner_shap' =>'yes',
                    ]
                ]
            );

            $this->add_control(
                'icon_box_inner_shap_hover_color',
                [
                    'label' => esc_html__( 'Hover Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-icon-box-card:hover .htmega-icon-box-card-inner-shap svg path' => 'fill: {{VALUE}}',

                    ],
                    'condition' => [
                        'icon_box_top_style_switcher!' =>'yes',
                        'icon_box_before_inner_shap' =>'yes',
                        'icon_box_inner_shap_style_color!' =>'',
                    ]
                ]
            );

            $this->add_responsive_control(
                'icon_box_inner_shap_size',
                [
                    'label' => esc_html__( 'Size', 'htmega-pro' ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 500,
                        ],
                    ],
                    'default' => [
                        'size' =>110,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-icon-box-icon .htmega-icon-box-card-inner-shap' => 'width: {{SIZE}}px; height: {{SIZE}}px;',
                        '{{WRAPPER}} .htmega-icon-box-card .htmega-icon-box-card-inner-shap svg' => 'width: {{SIZE}}px; height: {{SIZE}}px;',
                    ],
                    'condition' => [
                        'icon_box_top_style_switcher!' =>'yes',
                        'icon_box_before_inner_shap' =>'yes',
                    ]
                ]
            );
        $this->end_controls_section();
    }

    protected function __title_style() {
        // Title tab section
        $this->start_controls_section(
            'title_style',
            [
                'label' => esc_html__( 'Title Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'icon_box_title!' =>'',
                ]
            ]
        );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-icon-box-title',
                ]
            );

            $this->start_controls_tabs('iconbox_title_style_tabs');
                
            // Box Normal Style Tab
            $this->start_controls_tab(
                'iconbox_title_normal_style_tab',
                [
                    'label' => esc_html__( 'Normal', 'htmega-pro' ),
                ]
            );

            $this->add_control(
                'title_color_normal',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-icon-box-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->end_controls_tab();

                // Box Hover Style Tab
                $this->start_controls_tab(
                    'iconbox_title_hover_style_tab',
                    [
                        'label' => esc_html__( 'Hover', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'title_color_hover',
                        [
                            'label' => esc_html__( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-icon-box-title:hover' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .htmega-icon-box-card:hover .htmega-icon-box-title' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                $this->end_controls_tab();

            $this->end_controls_tabs();

            $this->add_responsive_control(
                'title_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-icon-box-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'icon_box_separator_image',
                [
                    'label' => esc_html__('Title Separator Image','htmega-pro'),
                    'type'=>Controls_Manager::MEDIA,
                    'dynamic' => [
                        'active' => true,
                    ],
                    'separator' => 'before',
                    'condition' => [
                        'icon_box_title!' =>'',
                        'icon_and_title_position' => ['top','bottom'],
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'icon_box_separator_image_size',
                    'default' => 'thumbnail',
                    'separator' => 'none',
                    'condition' => [
                        'icon_box_separator_image[url]!' => '',
                        'icon_box_title!' =>'',
                    ]
                    
                ]
            );

        $this->end_controls_section();
    }

    protected function __description_style() {
        // Description tab section
        $this->start_controls_section(
            'descrioption_style',
            [
                'label' => esc_html__( 'Description Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'icon_box_description!' =>'',
                ]
            ]
        );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'description_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-icon-box-description',
                ]
            );

            $this->start_controls_tabs('iconbox_description_style_tabs');
                
                // Box Normal Style Tab
                $this->start_controls_tab(
                    'iconbox_description_normal_style_tab',
                    [
                        'label' => esc_html__( 'Normal', 'htmega-pro' ),
                    ]
                );

                    $this->add_control(
                        'description_color_normal',
                        [
                            'label' => esc_html__( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-icon-box-description' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                $this->end_controls_tab();

                // Box Hover Style Tab
                $this->start_controls_tab(
                    'iconbox_description_hover_style_tab',
                    [
                        'label' => esc_html__( 'Hover', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'description_color_hover',
                        [
                            'label' => esc_html__( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-icon-box-description:hover' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .htmega-icon-box-card:hover .htmega-icon-box-description' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                $this->end_controls_tab();

            $this->end_controls_tabs();

            $this->add_responsive_control(
                'description_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-icon-box-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );

        $this->end_controls_section();
    }

    protected function __indexing_style(){
        // Indexing style tab section
        $this->start_controls_section(
            'indexing_style',
            [
                'label' => esc_html__( 'Indexing Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'indexing_number[value]!' =>'',
                ]
            ]
        );

            $this->add_control(
                'indexing_size',
                [
                    'label' => esc_html__( 'Index Box Size', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

                $this->add_responsive_control(
                    'icon_box_indexing_width',
                    [
                        'label' => esc_html__( 'Width', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 500,
                                'step' => 1,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-icon-box-card .htmega-icon-box-number' => 'width: {{SIZE}}{{UNIT}};',
                        ]
                    ]
                );

                $this->add_responsive_control(
                    'icon_box_indexing_height',
                    [
                        'label' => esc_html__( 'Height', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 500,
                                'step' => 1,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-icon-box-card .htmega-icon-box-number' => 'height: {{SIZE}}{{UNIT}};',
                        ]
                    ]
                );

                $this->add_control(
                    'index_position',
                    [
                        'label' => esc_html__( 'Index Position', 'htmega-pro' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                    ]
                );

                $this->add_responsive_control(
                    'icon_box_indexing_top',
                    [
                        'label' => esc_html__( 'Top', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px' ],
                        'range' => [
                            'px' => [
                                'min' => -500,
                                'max' => 500,
                                'step' => 1,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 0,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-icon-box-card .htmega-icon-box-number' => 'top: {{SIZE}}{{UNIT}};',
                        ]
                    ]
                );

                $this->add_responsive_control(
                    'icon_box_indexing_left',
                    [
                        'label' => esc_html__( 'Left', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px' ],
                        'range' => [
                            'px' => [
                                'min' => -500,
                                'max' => 500,
                                'step' => 1,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 0,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-icon-box-card .htmega-icon-box-number' => 'left: {{SIZE}}{{UNIT}};',
                        ],
                        'separator' => 'after',
                    ]
                );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'indexing_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-icon-box-number',
                ]
            );

            $this->start_controls_tabs('iconbox_indexing_style_tabs');
                // Box Normal Style Tab
                $this->start_controls_tab(
                    'iconbox_indexing_normal_style_tab',
                    [
                        'label' => esc_html__( 'Normal', 'htmega-pro' ),
                    ]
                );

                    $this->add_control(
                        'indexing_color_normal',
                        [
                            'label' => esc_html__( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-icon-box-number' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'indexing_background_normal',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-icon-box-number',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'indexing_border_normal',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-icon-box-number',
                        ]
                    );

                    $this->add_responsive_control(
                        'indexing_border_radius_normal',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-icon-box-number' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab();

                // Box Hover Style Tab
                $this->start_controls_tab(
                    'iconbox_indexing_hover_style_tab',
                    [
                        'label' => esc_html__( 'Hover', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'indexing_color_hover',
                        [
                            'label' => esc_html__( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-icon-box-card:hover .htmega-icon-box-number' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'indexing_background_hover',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-icon-box-card:hover .htmega-icon-box-number',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'indexing_border_hover',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-icon-box-card:hover .htmega-icon-box-number',
                        ]
                    );

                    $this->add_responsive_control(
                        'indexing_border_radius_hover',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-icon-box-card:hover .htmega-icon-box-number' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab();

            $this->end_controls_tabs();

            $this->add_responsive_control(
                'indexing_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-icon-box-number' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );

        $this->end_controls_section(); // end indexing style
    }

    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();
        $icon_box_id = "htmega-icon-box-".$this->get_id();
        $number = $settings['indexing_number'];
        // Box Icon URL
        if ( ! empty( $settings['icon_box_button_link']['url'] ) ) {
			$this->add_link_attributes( 'icon_box_button_link', $settings['icon_box_button_link'] );
		}?>
            <div class="htmega-icon-box-wrap">
                <div class="<?php echo esc_attr( $icon_box_id ) ?>">
                    <!-- URL start -->
                    <a class="htmega-icon-box-card-link" <?php echo $this->get_render_attribute_string( 'icon_box_button_link' ); ?>>
                        <div class="htmega-icon-box-card <?php echo esc_attr( (($settings['after_bottom_color_switcher'] == "yes") || ($settings['icon_box_before_switcher'] == "yes")) ? "htmega-icon-box-card-5 active":"");  echo esc_attr( (($settings['icon_box_top_style_switcher'] == "yes")) ? " htmega-icon-box-card-6":"")?>">
                            <?php 
                                $this->icon_and_image_section($settings);
                                $this->title_and_description_section($settings);
                                $this->number_section($number);
                            ?>
                        </div>
                    <!-- URL End -->
                    </a>
                </div>
            </div>

        <?php 
        echo "<style>";    
            echo ".".esc_attr( $icon_box_id) . " .htmega-icon-box-card { display: flex; align-items: center; justify-content: center;";
            if($settings['icon_and_title_position'] == 'top'){
                echo "flex-direction: column;";
            }else if($settings['icon_and_title_position'] == 'right'){
                echo "flex-direction:row-reverse;";
            }else if($settings['icon_and_title_position'] == 'bottom'){
                echo "flex-direction:column-reverse;";
            }else if($settings['icon_and_title_position'] == 'laft'){
                echo "flex-direction:row;";
            }
        echo "}</style>";    
    }

    protected function title_and_description_section($settings){
        $title = $settings['icon_box_title'];
        $title_tag = $settings['icon_box_title_tag'];
        $description = $settings['icon_box_description'];

         if(!empty($title) || !empty($description)):?>          
            <div class="htmega-icon-box-content">
                <?php
                    //Separetor
                    if(!empty($settings['icon_box_separator_image'])){
                        echo '<span class="htmega-icon-box-inner-shap">'.Group_Control_Image_Size::get_attachment_image_html( $settings, 'icon_box_separator_image_size', 'icon_box_separator_image' ).'</span>';
                    }
                    //Icon Box Title
                    if($title){
                        printf('<%1$s class="htmega-icon-box-title">%2$s</%1$s>', htmega_escape_tags( $title_tag ,'h3' ), esc_html( $title ));
                    }
                    //Icon Box Description
                    if($description){
                        printf('<p class="htmega-icon-box-description">%1$s</p>', esc_html( $description ));
                    }        
                ?>
            </div>
        <?php endif;
    }

    protected function icon_and_image_section($settings){   
        if($settings['icon_type'] != "none"){
            echo "<div class='htmega-icon-box-icon'>";
                if( !empty( $settings['icon_box_number'] ) ){
                    echo '<div class="htmega-icon-box-card-image"><div class="htmega-box-icon-number">'.esc_html( $settings['icon_box_number'] ).'</div></div>';
                }else if( !empty( $settings['icon_box_icon'] ) ){
                    echo '<div class="htmega-icon-box-card-image">'.HTMega_Icon_manager::render_icon( $settings['icon_box_icon'], [ 'aria-hidden' => 'true' ] ).'</div>';
                }else if( !empty( $settings['icon_box_image']['url'] ) ){
                    echo '<div class="htmega-icon-box-card-image">'.Group_Control_Image_Size::get_attachment_image_html( $settings, 'icon_box_imagesize', 'icon_box_image' ).'</div>';
                }

                if($settings['icon_box_before_inner_shap'] == "yes"){?>
                    <div class="htmega-icon-box-card-inner-shap">
                        <svg viewBox="0 0 110 110" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M43.5 6.63953C50.6162 2.53097 59.3838 2.53097 66.5 6.63953L91.1314 20.8605C98.2476 24.969 102.631 32.5619 102.631 40.7791V69.2209C102.631 77.438 98.2476 85.031 91.1314 89.1395L66.5 103.36C59.3838 107.469 50.6162 107.469 43.5 103.36L18.8686 89.1395C11.7524 85.031 7.3686 77.438 7.3686 69.2209V40.7791C7.3686 32.5619 11.7524 24.969 18.8686 20.8605L43.5 6.63953Z" fill="#242424"/>
                        </svg>
                    </div>
                <?php }
            echo "</div>";
        }

    }

    protected function number_section($number){
        if(!empty($number)):?>
            <span class="htmega-icon-box-number"><?php echo esc_html( $number ) ?></span>
        <?php endif;
    }
}