<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Lottie_Element extends Widget_Base {
    public function get_name() {
        return 'htmega-lottie-addons';
    }
    
    public function get_title() {
        return __( 'Lottie', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-lottie';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }

    public function get_script_depends() {
        return [ 'lottie' ];
    }

    public function get_keywords() {
        return [ 'htmega', 'ht mega', 'lottie', 'lottie animation', 'animation', 'htmega pro' ];
    }
    
    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/general-widgets/lottie-widget/';
	}
    protected function is_dynamic_content():bool {
		return false;
	}
    protected function register_controls() {

        // Content
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Lottie Settings', 'htmega-pro' ),
            ]
        );
            
            $this->add_control(
                'source_type',
                [
                    'label' => __( 'Source Type', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'url',
                    'options' => [
                        'url'      => __( 'JSON URL', 'htmega-pro' ),
                        'file'      => __( 'Upload JSON', 'htmega-pro' ),
                    ],
                ]
            );

            $this->add_control(
                'lottie_file',
                [
                    'label' => __( 'Upload JSON', 'htmega-pro' ),
                    'type' => Controls_Manager::MEDIA,
                    'media_type'    => 'application/json',
                    'description'   => sprintf( // translators: %1$s represents the opening <a> tag, %2$s represents the closing </a> tag
                        esc_html__(
                            'Find thousands of %1$sLottie animations%2$s ready to use',
                            'htmega-pro'
                        ),
                        '<a href="https://lottiefiles.com/featured" target="_blank">',
                        '</a>'
                    ),
                    'condition'    => [
                        'source_type'  => 'file',
                    ],
                ]
            );

            $this->add_control(
                'lottie_url',
                [
                    'label'   => __( 'JSON URL', 'htmega-pro' ),
                    'type'    => Controls_Manager::TEXT,
                    'description'   => sprintf( // translators: %1$s represents the opening <a> tag, %2$s represents the closing </a> tag
                        esc_html__(
                            'Find thousands of %1$sLottie animations%2$s ready to use',
                            'htmega-pro'
                        ),
                        '<a href="https://lottiefiles.com/featured" target="_blank">',
                        '</a>'
                    ),
                    'default' => 'https://assets8.lottiefiles.com/private_files/lf30_rg5wrsf4.json',
                    'condition'    => [
                        'source_type'  => 'url',
                    ],
                ]
            );

            $this->add_control(
                'lottie_link_check',
                [
                    'label'         => esc_html__( 'Link', 'htmega-pro' ),
                    'type'          => Controls_Manager::SWITCHER,
                ]
            );

            $this->add_control(
                'lottie_link',
                [
                    'show_label'    => false,
                    'type'          => Controls_Manager::URL,
                    'condition'     => [
                        'lottie_link_check'    => 'yes'
                    ],
                ]
            );

            $this->add_responsive_control(
                'lottie_width',
                [
                    'label' => __( 'Display size', 'htmega-pro' ),
                    'type'  => Controls_Manager::SLIDER,
                    'size_units'  => array( 'px', 'em', '%' ),
                    'range'       => array(
                        'px' => array(
                            'min' => 1,
                            'max' => 1000,
                        ),
                        'em' => array(
                            'min' => 1,
                            'max' => 30,
                        ),
                    ),
                    'selectors' => [
                        '{{WRAPPER}} lottie-player' => 'max-width: {{SIZE}}{{UNIT}};display:inline-block;',
                    ],
                ]
            );

            $this->add_responsive_control(
                'lottie_width_align',
                array(
                    'label'     => __( 'Alignment', 'htmega-pro' ),
                    'type'      => Controls_Manager::CHOOSE,
                    'options'   => array(
                        'left'   => array(
                            'title' => __( 'Left', 'htmega-pro' ),
                            'icon'  => 'eicon-text-align-left',
                        ),
                        'center' => array(
                            'title' => __( 'Center', 'htmega-pro' ),
                            'icon'  => 'eicon-text-align-center',
                        ),
                        'right'  => array(
                            'title' => __( 'Right', 'htmega-pro' ),
                            'icon'  => 'eicon-text-align-right',
                        ),
                    ),
                    'default'   => 'center',
                    'selectors' => array(
                        '{{WRAPPER}} .htmega-lottie-image' => 'text-align: {{VALUE}}',
                    ),
                )
            );

            $this->add_control(
                'lottie_options',
                [
                    'label'         => esc_html__( 'Animation Settings', 'htmega-pro' ),
                    'type'          => Controls_Manager::HEADING,
                    'separator'     => 'before',
                ]
            );

            $this->add_control(
                'lottie_autoplay',
                [
                    'label'         => esc_html__( 'Autoplay', 'htmega-pro' ),
                    'type'          => Controls_Manager::SWITCHER,
                    'return_value'  => 'yes',
                    'default'       => 'yes',
                ]
            );

            $this->add_control(
                'lottie_loop',
                [
                    'label'         => esc_html__( 'Loop', 'htmega-pro' ),
                    'type'          => Controls_Manager::SWITCHER,
                    'return_value'  => 'yes',
                    'default'       => 'yes',
                ]
            );

            $this->add_control(
                'lottie_speed',
                [
                    'label'         => esc_html__( 'Speed', 'htmega-pro' ),
                    'type'          => Controls_Manager::SLIDER,
                    'range'         => [
                        'px'    => [
                            'max'   => 10,
                            'step'  => 0.2,
                        ]
                    ],
                    'default'       => [
                        'size'  => 1,
                    ],
                ]
            );

            $this->add_control(
                'lottie_reverse',
                [
                    'label'         => esc_html__( 'Reverse', 'htmega-pro' ),
                    'type'          => Controls_Manager::SWITCHER,
                    'return_value' => "-1",
                ]
            );

            // $this->add_control(
            //     'lottie_render',
            //     [
            //         'label' => __( 'Render Type', 'htmega-pro' ),
            //         'type' => Controls_Manager::SELECT,
            //         'default' => 'svg',
            //         'options' => [
            //             'svg'      => __( 'SVG', 'htmega-pro' ),
            //             'canvas'      => __( 'Canvas', 'htmega-pro' ),
            //         ],
            //         'description' => esc_html__( 'If you\'re having performance issues on the page, set render type to canvas.','htmega-pro'),
            //     ]
            // );


        $this->end_controls_section();

        // Style
        $this->start_controls_section(
            'lottie_style_section',
            array(
                'label' => __( 'Lottie Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            )
        );
                $this->start_controls_tabs(
                    'style_tabs'
                );
                    // Normal Style Tab
                    $this->start_controls_tab(
                        'style_normal_tab',
                        [
                            'label' => __( 'Normal', 'htmega-pro' ),
                        ]
                    );
                    $this->add_control(
                        'lottie_background',
                        [
                            'label' => __( 'Background Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default'=>'',
                            'selectors' => [
                                '{{WRAPPER}} lottie-player' => 'background-color: {{VALUE}}!important',
                            ],
                        ]
                    );
                    $this->add_control(
                        'lottie_opacity',
                        [
                            'label'         => esc_html__( 'Opacity', 'htmega-pro' ),
                            'type'          => Controls_Manager::SLIDER,
                            'range'         => [
                                'px'    => [
                                    'min'   => 0,
                                    'max'   => 1,
                                    'step'  => 0.1,
                                ]
                            ],
                            'selectors'     => [
                                '{{WRAPPER}} lottie-player'   => 'opacity: {{SIZE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Css_Filter::get_type(),
                        [
                            'name'      => 'lottie_css_filter',
                            'selector'  => '{{WRAPPER}} lottie-player',
                        ]
                    );

                    $this->add_control(
                        'lottie_transition',
                        [
                            'label' => esc_html__( 'Transition', 'htmega-pro' ),
                            'type'  => Controls_Manager::SLIDER,
                            'range' => [
                                'px'    => [
                                    'max'   => 10,
                                    'step'  => 0.1,
                                ],
                            ],
                            'default' => [
                                'size' => 0.3,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} lottie-player'   => 'transition: all {{SIZE}}s ease;',
                            ],
                        ]
                    );
                    $this->end_controls_tab();

                    // Hover Style Tab
                    $this->start_controls_tab(
                        'hover_tabs',
                        [
                            'label' => __( 'Hover', 'htmega-pro' ),
                        ]
                    );
                    $this->add_control(
                        'lottie_background_hover',
                        [
                            'label' => __( 'Background Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default'=>'',
                            'selectors' => [
                                '{{WRAPPER}} lottie-player:hover' => 'background-color: {{VALUE}}!important',
                            ],
                        ]
                    );
                    $this->add_control(
                        'lottie_opacity_hover',
                        [
                            'label'         => esc_html__( 'Opacity', 'htmega-pro' ),
                            'type'          => Controls_Manager::SLIDER,
                            'range'         => [
                                'px'    => [
                                    'min'   => 0,
                                    'max'   => 1,
                                    'step'  => 0.1,
                                ]
                            ],
                            'selectors'     => [
                                '{{WRAPPER}} lottie-player:hover'   => 'opacity: {{SIZE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Css_Filter::get_type(),
                        [
                            'name'      => 'lottie_css_filter_hover',
                            'selector'  => '{{WRAPPER}} lottie-player:hover',
                        ]
                    );
                    $this->end_controls_tab();
                $this->end_controls_tabs();

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'lottie_border',
                    'label' => __( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} lottie-player',
                    'separator'     => 'before',
                ]
            );

            $this->add_responsive_control(
                'lottie_border_radius',
                [
                    'label' => __( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} lottie-player' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'lottie_padding',
                [
                    'label' => __( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} lottie-player' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();

    }

    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();

        $json_url = 'url' === $settings['source_type'] ? $settings['lottie_url'] : $settings['lottie_file']['url'];

		if ( empty( $json_url ) ) {
			return;
		}
        $render_attribute_args = array(
            'src'     => $json_url,
            // 'renderer'  => $settings['lottie_render'],
            'speed'  => $settings['lottie_speed']['size'],
            'direction'  => $settings['lottie_reverse'],
            'loop'    =>'',
            'autoplay'  => '',
        );

        if( 'yes' !== $settings['lottie_loop'] ) {
            unset( $render_attribute_args['loop'] );
        }

        if( 'yes' !== $settings['lottie_autoplay'] ) {
            unset( $render_attribute_args['autoplay'] );
        }
        
        $this->add_render_attribute( 'lottie', $render_attribute_args );

        echo '<div class="htmega-lottie-image">';

        if ( !empty($settings['lottie_link']['url']) && $settings['lottie_link']['url'] ):

            $this->add_link_attributes( 'link', $settings['lottie_link'] ); // link generate
            ?>
            <a <?php echo $this->get_render_attribute_string( 'link' ); ?>><lottie-player <?php echo $this->get_render_attribute_string( 'lottie' ); ?>></lottie-player> </a>
            <?php
            else:
            ?>
                <lottie-player <?php echo $this->get_render_attribute_string( 'lottie' ); ?>></lottie-player>
            <?php
        endif;

        echo "</div>"; 
    }

}

