<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;
use Elementor\HTMega_Icon_manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Page_List_Element extends Widget_Base {
    public function get_name() {
        return 'htmega-page-list-addons';
    }
    
    public function get_title() {
        return __( 'Page List', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-bullet-list';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }

	public function get_keywords() {
        return [ 'htmega', 'ht mega', 'taxonomy', 'terms', 'page', 'page list', 'htmega pro' ];
    }

    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/general-widgets/page-list-widget/';
	}

    protected function register_controls() {
		$this->start_controls_section(
			'section_icon',
			[
				'label' => esc_html__( 'Page List', 'htmega-pro' ),
			]
		);

			$this->add_control(
					'page_list_column',
					[
							'label' => __( 'Column', 'htmega-pro' ),
							'type' => Controls_Manager::SELECT,
							'default' => '2',
							'options' => [
									'1'   => __( 'One', 'htmega-pro' ),
									'2'   => __( 'Two', 'htmega-pro' ),
									'3'   => __( 'Three', 'htmega-pro' ),
									'4'   => __( 'Four', 'htmega-pro' ),
							],
							'separator' =>'before'
					]
			);

			//Local Function Repeater Catagory 
			$this->show_repeater_catagory();

				$this->add_control(
						'title_html_tag',
						[
								'label' => __('Select Title Tag', 'htmega-pro'),
								'type' => Controls_Manager::SELECT,
								'default' => 'h4',
								'options' => [
										'h1' => __('H1', 'htmega-pro'),
										'h2' => __('H2', 'htmega-pro'),
										'h3' => __('H3', 'htmega-pro'),
										'h4' => __('H4', 'htmega-pro'),
										'h5' => __('H5', 'htmega-pro'),
										'h6' => __('H6', 'htmega-pro'),
										'span' => __('Span', 'htmega-pro'),
										'p' => __('P', 'htmega-pro'),
										'div' => __('Div', 'htmega-pro'),
								]
						]
				);	
		
				$this->add_control(
					'media_direction',
					[
						'label' => __('Media direction', 'htmega-pro'),
						'type' => Controls_Manager::CHOOSE,
						'options' => [
							'left' => [
								'title' => __('Left', 'htmega-pro'),
								'icon' => 'eicon-h-align-left',
							],
							'top' => [
								'title' => __('Top', 'htmega-pro'),
								'icon' => 'eicon-v-align-top',
							],
						],
						'default' => 'left',
						'prefix_class' => 'ht-page-media-dir-',
					]
				);

				$this->add_control(
					'media_v_align',
					[
						'label' => __('Vertical Alignment', 'htmega-pro'),
						'type' => Controls_Manager::CHOOSE,
						'options' => [
							'top' => [
								'title' => __('Top', 'htmega-pro'),
								'icon' => 'eicon-v-align-top',
							],
							'center' => [
								'title' => __('Center', 'htmega-pro'),
								'icon' => 'eicon-v-align-middle',
							],
							'bottom' => [
								'title' => __('Bottom', 'htmega-pro'),
								'icon' => 'eicon-v-align-bottom',
							],
						],
						'default' => 'top',
						'toggle' => false,
						'condition' => [
							'media_direction' => 'left',
						],
						'style_transfer' => true,
						'selectors_dictionary' => [
							'center' => '    -webkit-align-self: center; -ms-flex-item-align: center; align-self: center;',
							'bottom' => '    -webkit-align-self: flex-end; -ms-flex-item-align: end; align-self: flex-end;',
						],
						'selectors' => [
							'{{WRAPPER}}.ht-page-media-dir-left .htmega-page-list-item-image' => '{{VALUE}};'
						]
					]
				);

				$this->add_control(
					'content_text_align',
					[
							'label' => __('Item Alignment', 'htmega-pro'),
							'type' => Controls_Manager::CHOOSE,
							'options' => [
									'left' => [
											'title' => __('Left', 'htmega-pro'),
											'icon' => 'eicon-text-align-left',
									],
									'center' => [
											'title' => __('Center', 'htmega-pro'),
											'icon' => 'eicon-text-align-center',
									],
									'right' => [
											'title' => __('Right', 'htmega-pro'),
											'icon' => 'eicon-text-align-right',
									],
							],
							'default' => 'left',
							'toggle' => true,
							'condition' => [
								'media_direction' => 'top',
							],
							'selectors' => [
									'{{WRAPPER}}.ht-page-media-dir-top .htmega-page-list-item' => 'text-align: {{VALUE}};',
							],
					]
				);

				$this->add_control(
					'icon_box_position',
					[
							'label' => __( 'Gap', 'htmega-pro' ),
							'type'  => Controls_Manager::SLIDER,
							'range' => [
									'px' => [
											'max' => 100,
									],
							],
							'default' => [
									'size' => 20,
							],
							'selectors' => [
								'{{WRAPPER}}.ht-page-media-dir-left .htmega-page-list-item-image' => 'margin-right: {{SIZE}}{{UNIT}};',
								'{{WRAPPER}}.ht-page-media-dir-top .htmega-page-list-item-image' => 'margin-bottom: {{SIZE}}{{UNIT}};',
							],
					]
				);	

		$this->end_controls_section();

		//Item Area Style
		$this->start_controls_section(	
			'item_area_control',
			[
				'label' => esc_html__( 'Item', 'htmega-pro' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_responsive_control(
					'item_comon_margin',
					[
							'label' => __('Margin', 'htmega-pro'),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors' => [
									'{{WRAPPER}} .htmega-page-list-wrap .htmega-page-list-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
					]
			);

			$this->add_responsive_control(
					'item_comon_padding',
					[
							'label' => __('Padding', 'htmega-pro'),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors' => [
									'{{WRAPPER}} .htmega-page-list-wrap .htmega-page-list-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							]
					]
			);

			$this->add_responsive_control(
					'item_comon_border_radius',
					[
							'label' => __('Border Radius', 'htmega-pro'),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors' => [
									'{{WRAPPER}} .htmega-page-list-wrap .htmega-page-list-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							]
					]
			);					

			$this->start_controls_tabs('item_tabs_style');

				$this->start_controls_tab(
						'item_tab_normal',
						[
								'label' => __('Normal', 'htmega-pro'),
						]
				);

					$this->add_group_control(
						Group_Control_Box_Shadow::get_type(),
						[
							'name' => 'item_box_shadow',
							'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
							'selector' => '{{WRAPPER}} .htmega-page-list-item',
						]
					);

					$this->add_control(
							'comon_item_title_color',
							[
									'label' => __('Title Color', 'htmega-pro'),
									'type' => Controls_Manager::COLOR,
									'selectors' => [
											'{{WRAPPER}} .htmega-page-list-item-title' => 'color: {{VALUE}}',
									],
							]
					);

					$this->add_control(
							'comon_item_sub_title_color',
							[
									'label' => __('Sub Title Color', 'htmega-pro'),
									'type' => Controls_Manager::COLOR,
									'selectors' => [
											'{{WRAPPER}} .htmega-page-list-item-description' => 'color: {{VALUE}}',
									],
							]
					);

					$this->add_group_control(
							Group_Control_Background::get_type(),
							[
									'name' => 'item_background_color',
									'label' => __( 'Background Color', 'htmega-pro' ),
									'types' => [ 'classic', 'gradient' ],
									'exclude' => ['image'],
									'selector' => '{{WRAPPER}} .htmega-page-list-item',
							]
					);

					$this->add_group_control(
							Group_Control_Border::get_type(),
							[
									'name' => 'item_border_color',
									'label' => __('Border', 'htmega-pro'),
									'selector' => '{{WRAPPER}} .htmega-page-list-item',
									'separator' => 'before',
							]
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
						'item_tab_hover',
						[
								'label' => __('Hover', 'htmega-pro'),
						]
				);

					$this->add_group_control(
						Group_Control_Box_Shadow::get_type(),
						[
							'name' => 'item_box_shadow_hover',
							'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
							'selector' => '{{WRAPPER}} .htmega-page-list-item:hover',
							
						]
					);

					$this->add_control(
							'comon_item_title_hover_color',
							[
									'label' => __('Title Color', 'htmega-pro'),
									'type' => Controls_Manager::COLOR,
									'selectors' => [
											'{{WRAPPER}} .htmega-page-list-item:hover .htmega-page-list-item-title' => 'color: {{VALUE}}',
									],
							]
					);

					$this->add_control(
							'comon_item_sub_title_hover_color',
							[
									'label' => __('Sub Title Color', 'htmega-pro'),
									'type' => Controls_Manager::COLOR,
									'selectors' => [
											'{{WRAPPER}} .htmega-page-list-item:hover .htmega-page-list-item-description' => 'color: {{VALUE}}',
									],
							]
					);

					$this->add_group_control(
							Group_Control_Background::get_type(),
							[
									'name' => 'item_background_hover_color',
									'label' => __( 'Background Color', 'htmega-pro' ),
									'types' => [ 'classic', 'gradient' ],
									'exclude' => ['image'],
									'selector' => '{{WRAPPER}} .htmega-page-list-item:hover',
							]
					);

					$this->add_group_control(
							Group_Control_Border::get_type(),
							[
									'name' => 'item_border_hover_color',
									'label' => __('Border', 'htmega-pro'),
									'selector' => '{{WRAPPER}} .htmega-page-list-item:hover',
									'separator' => 'before',
							]
					);			

				$this->end_controls_tab();

			$this->end_controls_tabs();		

		$this->end_controls_section();

		//Title Style Control
		$this->start_controls_section(	
			'item_title_control',
			[
				'label' => esc_html__( 'Title', 'htmega-pro' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_group_control(
					Group_Control_Typography::get_type(),
					[
							'name' => 'title_typography',
							'selector' => '{{WRAPPER}} .htmega-page-list-item-title',
					]
			);

			$this->add_responsive_control(
				'page_align',
				[
					'label' => __( 'Alignment', 'htmega-pro' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => __( 'Left', 'htmega-pro' ),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => __( 'Center', 'htmega-pro' ),
							'icon' => 'eicon-text-align-center',
						],
						'right' => [
							'title' => __( 'Right', 'htmega-pro' ),
							'icon' => 'eicon-text-align-right',
						],
					],
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .htmega-page-list-item-title' => 'text-align: {{VALUE}};',
					],
				]
			);

			$this->add_responsive_control(
					'title_margin',
					[
							'label' => __('Margin', 'htmega-pro'),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors' => [
									'{{WRAPPER}} .htmega-page-list-item-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
					]
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_subtitle_style',
			[
				'label' => esc_html__( 'Sub Title', 'htmega-pro' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_group_control(
					Group_Control_Typography::get_type(),
					[
							'name' => 'sub_title_typography',
							'selector' => '{{WRAPPER}} .htmega-page-list-item-description',
					]
			);

			$this->add_responsive_control(
				'page_sub_title_align',
				[
					'label' => __( 'Alignment', 'htmega-pro' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => __( 'Left', 'htmega-pro' ),
							'icon' => 'eicon-text-align-left',
						],
						'center' => [
							'title' => __( 'Center', 'htmega-pro' ),
							'icon' => 'eicon-text-align-center',
						],
						'right' => [
							'title' => __( 'Right', 'htmega-pro' ),
							'icon' => 'eicon-text-align-right',
						],
					],
					'selectors' => [
						'{{WRAPPER}} .htmega-page-list-item-description' => 'text-align: {{VALUE}};',
					],
				]
			);

			$this->add_responsive_control(
					'sub_title_margin',
					[
							'label' => __('Margin', 'htmega-pro'),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors' => [
									'{{WRAPPER}} .htmega-page-list-item-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
					]
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_icon_box_style',
			[
				'label' => esc_html__( 'Icon Box', 'htmega-pro' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'icon_size',
				[
						'label' => __( 'Icon Size', 'htmega-pro' ),
						'type'  => Controls_Manager::SLIDER,
						'range' => [
								'px' => [
										'max' => 100,
								],
						],
						'default' => [
								'size' => 30,
						],
						'selectors' => [
								'{{WRAPPER}} .htmega-page-list-wrap {{CURRENT_ITEM}} .htmega-page-list-item-image i'  => 'font-size: {{SIZE}}{{UNIT}};',
								'{{WRAPPER}} .htmega-page-list-wrap {{CURRENT_ITEM}} .htmega-page-list-item-image svg'  => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
						]
				]
			);	

			$this->add_control(
					'icon_comon_border_width',
					[
							'label' => __( 'Icon Box Size', 'htmega-pro' ),
							'type'  => Controls_Manager::SLIDER,
							'range' => [
									'px' => [
											'max' => 250,
									],
							],
							'default' => [
									'size' => 70,
							],
							'selectors' => [
									'{{WRAPPER}} .htmega-page-list-item-image'  => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
							]
					]
			);		

			$this->add_responsive_control(
					'icon_border_radius',
					[
							'label' => __('Border Radius', 'htmega-pro'),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%', 'em'],
							'selectors' => [
									'{{WRAPPER}} .htmega-page-list-item-image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
					]
			);		

			$this->start_controls_tabs('comon_rep_page_icon_style_tabs');

			$this->start_controls_tab(
				'comon_rep_page_icon_style_normal_tab',
				[
					'label' => __( 'Normal', 'htmega-pro' ),
				]
			);	

			$this->add_control(
					'comon_icons_color',
					[
						'label' => __('Icon Color', 'htmega-pro'),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
								'{{WRAPPER}} .htmega-page-list-item-image i' => 'color: {{VALUE}}',
								'{{WRAPPER}} .htmega-page-list-item-image svg path' => 'fill: {{VALUE}}',
						]
					]
			);	

			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
						'name' => 'icon_background_color',
						'label' => __( 'Background Color', 'htmega-pro' ),
						'types' => [ 'classic', 'gradient' ],
						'exclude' => ['image'],
						'selector' => '{{WRAPPER}} .htmega-page-list-item-image',
				]
			);					

			$this->end_controls_tab();
		
			$this->start_controls_tab(
				'comon_rep_page_icon_style_hover_tab',
				[
					'label' => __( 'Hover', 'htmega-pro' ),
				]
			);	
				$this->add_control(
						'comon_icons_hover_color',
						[
							'label' => __('Icon Color', 'htmega-pro'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
									'{{WRAPPER}} .htmega-page-list-item-image:hover i' => 'color: {{VALUE}}',
									'{{WRAPPER}} .htmega-page-list-item-image:hover svg path' => 'fill: {{VALUE}}',
							]
						]
				);	

				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
							'name' => 'icon_background_hover_color',
							'label' => __( 'Background Color', 'htmega-pro' ),
							'types' => [ 'classic', 'gradient' ],
							'exclude' => ['image'],
							'selector' => '{{WRAPPER}} .htmega-page-list-item-image:hover',
					]
				);
			$this->end_controls_tab();
	
			$this->end_controls_tabs();

		$this->end_controls_section();

	}

    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();

				$this->add_render_attribute( 'htmega_page_parent_control', 'class', 'htmega-page-list-wrap' );
				$this->add_render_attribute( 'htmega_page_child_control', 'class', 'htmega-page-list-item' );        
				$this->add_render_attribute( 'htmega_page_list_title', 'class', 'htmega-page-list-item-title' );
				$this->add_render_attribute( 'htmega_page_list_desc', 'class', 'htmega-page-list-item-description' );

        $columns = $settings['page_list_column'];
        $collumval = 'htb-col-lg-6 htb-col-md-6';
        if( $columns != 5 ){
            $colwidth = round(12/$columns);
            $collumval = 'htb-col-md-'.$colwidth.' htb-col-sm-6 htb-col-12';
        }else{
            $collumval = 'htb-col-lg-6 htb-col-md-6';
        }    
				?>
			<div <?php echo $this->get_render_attribute_string( 'htmega_page_parent_control' ); ?>>
				<div class="htb-row">
					<?php foreach( $settings['page_list'] as $key => $page ): 

					$postid = '';

					if($page['page_list_or_custom_link'] != 'yes') {
						$target = '_self';
						if($page['sourse_href_target'] == 'yes') :
							$target = '_blank';
						else: 
							$target = '_self';
						endif;
			
						$postid = !empty($page['page_list_sourse']) ? get_the_permalink($page['page_list_sourse']) : '#';
			
					}else {
						if( isset(  $page['htmega_custom_url']['url'] ) && !empty( $page['htmega_custom_url']['url'] ) ){
								$this->add_link_attributes( $key, $page['htmega_custom_url'] );
						}
					}

					$page_itle  = ! empty( $page['custom_page_title'] ) ? $page['custom_page_title'] : '';
					$page_sub_title  = ! empty( $page['custom_page_sub_title'] ) ? $page['custom_page_sub_title'] : '';

					?>
					
					<div class="elementor-repeater-item-<?php echo esc_attr( $page['_id'] ) ?> <?php echo esc_attr( $collumval );?>">
					<?php 
					
					if ( $page['page_list_or_custom_link'] != 'yes' ) {
						?>
						<a href="<?php echo esc_url($postid);?>" target="<?php echo esc_attr($target); ?>">
							<div <?php echo $this->get_render_attribute_string( 'htmega_page_child_control' ); ?>>
								<?php if( !empty( $page['page_list_image']['url'] ) ){
									echo '<div class="htmega-page-list-item-image">'.Group_Control_Image_Size::get_attachment_image_html( $page, 'page_list_imagesize', 'page_list_image' ).'</div>';
								}		
								if( !empty( $page['icons'] ) ){
										echo '<div class="htmega-page-list-item-image">'.HTMega_Icon_manager::render_icon( $page['icons'], [ 'aria-hidden' => 'true' ] ).'</div>';
								} ?>

								<div class="htmega-page-list-item-content">
									<?php 
										if( !empty( $page['custom_page_title'] ) ){
											printf( '<%1$s %2$s>%3$s</%1$s>', 
											htmega_escape_tags( $settings['title_html_tag'], 'h4' ),
											$this->get_render_attribute_string( 'htmega_page_list_title' ), 
											esc_html( $page_itle )
										);
										}
										if( !empty( $page['custom_page_sub_title'] ) ){
											printf( '<p %1$s>%2$s</p>', $this->get_render_attribute_string( 'htmega_page_list_desc' ), wp_kses_post( $page_sub_title ) );
										}
									?>
								</div>
							</div>
							
						</a>
					<?php } else{ ?>
						<a <?php echo $this->get_render_attribute_string( $key ); ?> >
							<div <?php echo $this->get_render_attribute_string( 'htmega_page_child_control' ); ?>>
								<?php if( !empty( $page['page_list_image']['url'] ) ){
									echo '<div class="htmega-page-list-item-image">'.Group_Control_Image_Size::get_attachment_image_html( $page, 'page_list_imagesize', 'page_list_image' ).'</div>';
								}		
								if( !empty( $page['icons'] ) ){
										echo '<div class="htmega-page-list-item-image">'.HTMega_Icon_manager::render_icon( $page['icons'], [ 'aria-hidden' => 'true' ] ).'</div>';
								} ?>

								<div class="htmega-page-list-item-content">
									<?php 
										if( !empty( $page['custom_page_title'] ) ){
											printf( '<%1$s %2$s>%3$s</%1$s>', 
											htmega_escape_tags( $settings['title_html_tag'], 'h4' ),
											$this->get_render_attribute_string( 'htmega_page_list_title' ), 
											esc_html( $page_itle )
										);
										}
										if( !empty( $page['custom_page_sub_title'] ) ){
											printf( '<p %1$s>%2$s</p>', $this->get_render_attribute_string( 'htmega_page_list_desc' ), wp_kses_post( $page_sub_title ) );
										}
									?>
								</div>	
							</div>
						</a>
					<?php } ?>
					
						</a>
					</div>
					<!-- Category List Item End -->
					<?php endforeach; ?>
				</div>
			</div>

		<?php }

	public function show_repeater_catagory(){
		
		$repeater = new Repeater();

		$repeater->add_control(
			'custom_page_title',
			[
				'label' => esc_html__( 'Title', 'htmega-pro' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => esc_html__( 'List Title', 'htmega-pro' ),
			]
		);

		$repeater->add_control(
			'custom_page_sub_title',
			[
				'label' => esc_html__( 'Sub Title', 'htmega-pro' ),
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'placeholder' => esc_html__( 'List Sub Title', 'htmega-pro' ),
			]
		);

		$repeater->add_control(
				'icon_type',
				[
						'label'   => __( 'Icon Type', 'htmega-pro' ),
						'type'    => Controls_Manager::CHOOSE,
						'options' => [
								'none' => [
										'title' => __( 'None', 'htmega-pro' ),
										'icon'  => 'eicon-ban',
								],
								'icon' => [
										'title' => __( 'Icon', 'htmega-pro' ),
										'icon'  => 'eicon-info-circle',
								],
								'image' => [
										'title' => __( 'Image', 'htmega-pro' ),
										'icon'  => 'eicon-image-bold',
								]
						],
						'default' => 'none',
				]
		);

		$repeater->add_control(
			'icons',
			[
				'label' => esc_html__( 'Icon', 'htmega-pro' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
						'value' => 'fas fa-check',
						'library' => 'fa-solid',
				],
				'condition'=>[
						'icon_type'=>'icon',
				],
			]
		);

		$repeater->add_control(
				'page_list_image',
				[
						'label' => __('Image','htmega-pro'),
						'type'=>Controls_Manager::MEDIA,
						'dynamic' => [
								'active' => true,
						],
						'condition' => [
								'icon_type' => 'image',
						]
				]
		);

		$repeater->add_group_control(
				Group_Control_Image_Size::get_type(),
				[
						'name' => 'page_list_imagesize',
						'default' => 'thumbnail',
						'separator' => 'none',
						'condition' => [
								'page_list_image[url]!' => '',
								'icon_type' => 'image',
						]
				]
		);	

	$repeater->start_controls_tabs('rep_page_icon_style_tabs');

		$repeater->start_controls_tab(
			'rep_page_icon_style_normal_tab',
			[
				'label' => __( 'Normal', 'htmega-pro' ),
				'condition' => [
						'icon_type!' => 'none',
				]
			]
		);	

			$repeater->add_control(
					'icons_color',
					[
						'label' => __('Icon Color', 'htmega-pro'),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
								'{{WRAPPER}} .htmega-page-list-item-image i' => 'color: {{VALUE}}',
						],
						'condition' => [
								'icons[library]!' => ['','svg'],
								'icon_type!' => ['none','image'],
						]
					]
			);	

			$repeater->add_control(
					'icons_svg_color',
					[
						'label' => __('SVG Color', 'htmega-pro'),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
								'{{WRAPPER}} .htmega-page-list-wrap {{CURRENT_ITEM}} .htmega-page-list-item-image svg path' => 'fill: {{VALUE}}',
						],
						'condition' => [
								'icons[library]' => 'svg',
								'icon_type!' => ['none','image'],
						]
					]
			);

			$repeater->add_group_control(
					Group_Control_Background::get_type(),
					[
							'name' => 'background_color',
							'label' => __( 'Background', 'htmega-pro' ),
							'types' => [ 'classic', 'gradient' ],
							'exclude' => ['image'],
							'selector' => '{{WRAPPER}} .htmega-page-list-wrap {{CURRENT_ITEM}} .htmega-page-list-item-image',
							'condition' => [
									'icon_type!' => 'none',
							]
					]
			);	

		$repeater->end_controls_tab();
	
		$repeater->start_controls_tab(
			'rep_page_icon_style_hover_tab',
			[
				'label' => __( 'Hover', 'htmega-pro' ),
				'condition' => [
						'icon_type!' => 'none',
				]
			]
		);	

			$repeater->add_control(
					'icons_hover_color',
					[
						'label' => __('Icon Color', 'htmega-pro'),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
								'{{WRAPPER}} .htmega-page-list-wrap {{CURRENT_ITEM}} .htmega-page-list-item-image:hover i' => 'color: {{VALUE}}',
						],
						'condition' => [
								'icons[library]!' => ['','svg'],
								'icon_type!' => 'image',
						]
					]
			);	

			$repeater->add_control(
					'icons_svg_hover_color',
					[
						'label' => __('SVG Color', 'htmega-pro'),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
								'{{WRAPPER}} .htmega-page-list-wrap {{CURRENT_ITEM}} .htmega-page-list-item-image:hover svg path' => 'fill: {{VALUE}}',
						],
						'condition' => [
								'icons[library]' => 'svg',
								'icon_type!' => ['none','image'],
						]
					]
			);

			$repeater->add_group_control(
					Group_Control_Background::get_type(),
					[
							'name' => 'background_hover_color',
							'label' => __( 'Background', 'htmega-pro' ),
							'types' => [ 'classic', 'gradient' ],
							'exclude' => ['image'],
							'selector' => '{{WRAPPER}} .htmega-page-list-wrap {{CURRENT_ITEM}} .htmega-page-list-item-image:hover',
							'condition' => [
									'icon_type!' => 'none',
							]
					]
			);

		$repeater->end_controls_tab();

		$repeater->end_controls_tabs();
		
		$repeater->add_control(
			'page_list_or_custom_link',
			[
				'label' => esc_html__( 'Custom Link', 'htmega-pro' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'htmega-pro' ),
				'label_off' => esc_html__( 'No', 'htmega-pro' ),
				'return_value' => 'yes',
				'default' => 'no',
				'separator' => 'before',
			]
		);

		$repeater->add_control(
				'page_list_sourse',
				[
						'label' => esc_html__( 'Select Page', 'htmega-pro' ),
						'type' => Controls_Manager::SELECT2,
						'label_block' => true,
						'multiple' => false,
						'options' => htmega_get_page_list(),
						'condition' => [
							'page_list_or_custom_link!' => 'yes'
						]
				]
		);

		$repeater->add_control(
			'sourse_href_target',
			[
				'label' => esc_html__( 'Open in new window?', 'htmega-pro' ),
				'type' => Controls_Manager::SWITCHER,
				'yes' => esc_html__( 'Yes', 'htmega-pro' ),
				'no' => esc_html__( 'No', 'htmega-pro' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'page_list_or_custom_link!' => 'yes'
				]
			]
		);		

		$repeater->add_control(
			'htmega_custom_url',
			[
				'label' => esc_html__( 'Link', 'htmega-pro' ),
				'type' => Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://wphtmega.com/', 'htmega-pro' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition' => [
					'page_list_or_custom_link' => 'yes'
				]
			]
		);

		$repeater->add_control(
			'show_item_individual_item',
			[
				'label' => esc_html__( 'Individual Item Style?', 'htmega-pro' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'htmega-pro' ),
				'label_off' => esc_html__( 'Hide', 'htmega-pro' ),
				'return_value' => 'yes',
				'default' => 'label_off',
				'separator' => 'before',
			]
		);		

		$repeater->start_controls_tabs('rep_page_style_tabs');

			$repeater->start_controls_tab(
				'rep_page_style_normal_tab',
				[
					'label' => __( 'Normal', 'htmega-pro' ),
					'condition'	=> [
						'show_item_individual_item' => 'yes'
					]
				]
			);

				$repeater->add_control(
						'item_title_color',
						[
								'label' => __('Title Color', 'htmega-pro'),
								'type' => Controls_Manager::COLOR,
								'selectors' => [
										'{{WRAPPER}} .htmega-page-list-wrap {{CURRENT_ITEM}} .htmega-page-list-item-title' => 'color: {{VALUE}}',
								],
								'condition'	=> [
									'show_item_individual_item' => 'yes'
								]
						]
				);

				$repeater->add_control(
						'item_sub_title_color',
						[
								'label' => __('Sub Title Color', 'htmega-pro'),
								'type' => Controls_Manager::COLOR,
								'selectors' => [
										'{{WRAPPER}} .htmega-page-list-wrap {{CURRENT_ITEM}} .htmega-page-list-item-description' => 'color: {{VALUE}}',
								],
								'condition'	=> [
									'show_item_individual_item' => 'yes'
								]
						]
				);
		
				$repeater->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'rep_page_menu_background',
						'label' => esc_html__( 'Background', 'htmega-pro' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => '{{WRAPPER}} .htmega-page-list-wrap {{CURRENT_ITEM}} .htmega-page-list-item',
						'condition'	=> [
							'show_item_individual_item' => 'yes'
						]
					]
				);

				$repeater->add_group_control(
					Group_Control_Border::get_type(),
					[
						'name' => 'item_border_border',
						'label' => __( 'Border', 'htmega-pro' ),
						'selector' => '{{WRAPPER}} .htmega-page-list-wrap {{CURRENT_ITEM}} .htmega-page-list-item',
						'condition'	=> [
							'show_item_individual_item' => 'yes'
						]
					]
				);

			$repeater->end_controls_tab();
		
		
			$repeater->start_controls_tab(
				'rep_page_style_hover_tab',
				[
					'label' => __( 'Hover', 'htmega-pro' ),
					'condition'	=> [
						'show_item_individual_item' => 'yes'
					]
				]
			);

				$repeater->add_control(
						'item_title_hover_color',
						[
								'label' => __('Title Color', 'htmega-pro'),
								'type' => Controls_Manager::COLOR,
								'selectors' => [
										'{{WRAPPER}} .htmega-page-list-wrap {{CURRENT_ITEM}} a:hover .htmega-page-list-item-title' => 'color: {{VALUE}}',
								],
								'condition'	=> [
									'show_item_individual_item' => 'yes'
								]
						]
				);

				$repeater->add_control(
						'item_sub_title_hover_color',
						[
								'label' => __('Sub Title Color', 'htmega-pro'),
								'type' => Controls_Manager::COLOR,
								'selectors' => [
										'{{WRAPPER}} .htmega-page-list-wrap {{CURRENT_ITEM}} a:hover .htmega-page-list-item-description' => 'color: {{VALUE}}',
								],
								'condition'	=> [
									'show_item_individual_item' => 'yes'
								]
						]
				);
		
				$repeater->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'rep_page_menu_background_hover',
						'label' => esc_html__( 'Background', 'htmega-pro' ),
						'types' => [ 'classic', 'gradient' ],
						'selector' => '{{WRAPPER}} .htmega-page-list-wrap {{CURRENT_ITEM}} a:hover .htmega-page-list-item',
						'condition'	=> [
							'show_item_individual_item' => 'yes'
						]
					]
				);

				$repeater->add_group_control(
					Group_Control_Border::get_type(),
					[
						'name' => 'item_border_border_hover',
						'label' => __( 'Border', 'htmega-pro' ),
						'selector' => '{{WRAPPER}} .htmega-page-list-wrap {{CURRENT_ITEM}} a:hover .htmega-page-list-item',
						'condition'	=> [
							'show_item_individual_item' => 'yes'
						]
					]
				);
		
			$repeater->end_controls_tab();
			
		$repeater->end_controls_tabs();

		$this->add_control(
			'page_list',
			[
					'type'    => Controls_Manager::REPEATER,
					'fields'  =>  $repeater->get_controls(),
					'default' => [

							[
									'custom_page_title'        => __('Website design service','htmega-pro'),
									'custom_page_sub_title'  => __('We are taking our classic menu too seriously. You deserve the best, so choose wisely.','htmega-pro'),
							],
							[
									'custom_page_title'        => __('WordPress Theme design','htmega-pro'),
									'custom_page_sub_title'  => __('We are taking our classic menu too seriously. You deserve the best, so choose wisely.','htmega-pro'),
							],

					],
					'title_field' => '{{{ custom_page_title }}}',
			]
	);

	}

}