<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\HTMega_Icon_manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Post_Masonry_Element extends Widget_Base {
    public function get_name() {
        return 'htmega-post-masonry-addons';
    }
    
    public function get_title() {
        return __( 'Post Masonry', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-posts-masonry';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }

    public function get_script_depends() {
        return ['imagesloaded','masonry', ];
    }

    public function get_keywords() {
        return [ 'post masonry', 'masonry','pagination masonry','post pagination','htmega addons','htmega pro' ];
    }
    
    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/post-widgets/post-masonry-widget/';
	}

    protected function register_controls() {

        // Content
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Content Source', 'htmega-pro' ),
            ]
        );
        $this->show_post_source();

        $this->end_controls_section();
        // Display Options
        $this->start_controls_section(
            'display_option_section',
            [
                'label' => __( 'Display Options', 'htmega-pro' ),
            ]
        );
        $this->add_control(
            'masonry_style',
            [
                'label' => esc_html__( 'Card Style', 'htmega-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => '4',
                'options' => [
                    '1'  => esc_html__('Style One','htmega-pro'),
                    '2'   => esc_html__('Style Two','htmega-pro'),
                    '3'   => esc_html__('Style Three','htmega-pro'),
                    '4'   => esc_html__('Style Four','htmega-pro'),
                ],
            ]
        );
        $this->add_responsive_control(
            'masonry_column',
            [
                'label' => esc_html__( 'Column', 'htmega-pro' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    100  => esc_html__('One','htmega-pro'),
                    50  => esc_html__('Two','htmega-pro'),
                    33   => esc_html__('Three','htmega-pro'),
                    25  => esc_html__('Four','htmega-pro'),
                    20   => esc_html__('Five','htmega-pro'),
                ],
				'desktop_default' => 33,
				'tablet_default' => 50,
				'mobile_default' => 100,
                'selectors_dictionary' => [
                            33 => 33.333,
                        ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-masonry-flex-column'   => 'flex: 0 0 {{VALUE}}%; max-width:{{VALUE}}%;width:{{VALUE}}%',
                ],
                'frontend_available' => true,
            ]
        );
        $this->add_responsive_control(
            'gird_gutter',
            [
                'label' => __('Column Gap', 'htmega-pro'),
                'description' => __('This Column gap value shows in multiplying 2', 'htmega-pro'),
                'type' => Controls_Manager::NUMBER,
                'default' => 10,
                'selectors' => [
                    '{{WRAPPER}} .htmega-masonry-row .htmega-masonry-flex-column' => 'padding-left: {{SIZE}}px;padding-right: {{SIZE}}px;',
                    '{{WRAPPER}} .htmega-post-masonry-widget-wrapper' => 'margin-left: -{{SIZE}}px;margin-right: -{{SIZE}}px;',
                ],
            ]
        ); 
        $this->add_responsive_control(
            'space_bottom',
            [
                'label' => __('Bottom Space', 'htmega-pro'),
                'description' => __('Add the item bottom space', 'htmega-pro'),
                'type' => Controls_Manager::NUMBER,
                'default' => 30,
                'selectors' => [
                    '{{WRAPPER}} .htmega-masonry-post-card' => 'margin-bottom: {{SIZE}}px;',
                ],
            ]
        ); 
        $this->add_control(
            'show_category',
            [
                'label' => esc_html__( 'Category', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'show_date',
            [
                'label' => esc_html__( 'Date', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_author',
            [
                'label' => esc_html__( 'Author', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
         $this->add_control(
            'show_title',
            [
                'label' => esc_html__( 'Title', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'title_length',
            [
                'label' => __( 'Title Length', 'htmega-pro' ),
                'type' => Controls_Manager::NUMBER,
                'step' => 1,
                'default' => 5,
                'condition'=>[
                    'show_title'=>'yes',
                ]
            ]
        );

        $this->add_control(
            'show_content',
            [
                'label' => esc_html__( 'Content', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'content_length',
            [
                'label' => __( 'Content Length', 'htmega-pro' ),
                'type' => Controls_Manager::NUMBER,
                'step' => 1,
                'default' => 20,
                'condition'=>[
                    'show_content'=>'yes',
                ]
            ]
        );

        $this->add_control(
            'show_read_more_btn',
            [
                'label' => esc_html__( 'Read More', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'read_more_txt',
            [
                'label' => __( 'Read More Button Text', 'htmega-pro' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Read More', 'htmega-pro' ),
                'placeholder' => __( 'Read More', 'htmega-pro' ),
                'label_block'=>true,
                'condition'=>[
                    'show_read_more_btn'=>'yes',
                ]
            ]
        );
        $this->add_control(
            'show_read_more_btn_icon',
            [
                'label' => esc_html__( 'Read More Icon', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
                'condition'=>[
                    'show_read_more_btn'=>'yes',
                ]
            ]
        );

        $this->add_control(
            'read_mor_icon_type',
            [
                'label' => esc_html__( 'Select Icon Type', 'htmega-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'image',
                'options' => [
                    'icon' => esc_html__( 'Icon', 'htmega-pro' ),
                    'image' => esc_html__( 'Image', 'htmega-pro' ),
                ],
                'condition'=>[
                    'show_read_more_btn'=>'yes',
                    'show_read_more_btn_icon'=>'yes',
                ]                   
            ]
        );

        $this->add_control(
            'read_mor_icon_image',
            [
                'label' => __( 'Icon image', 'htmega-pro' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => HTMEGA_ADDONS_PL_URL_PRO.'/assets/images/arrow-right.png',
                ],
                'condition' => [
                    'show_read_more_btn'=>'yes',
                    'show_read_more_btn_icon'=>'yes',
                    'read_mor_icon_type' => 'image',
                ]
            ]
        );
        $this->add_control(
            'read_mor_icon_font',
            [
                'label' => __( 'Icon', 'htmega-pro' ),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fa fa-long-arrow-right',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'show_read_more_btn'=>'yes',
                    'show_read_more_btn_icon'=>'yes',
                    'read_mor_icon_type' => 'icon',
                ],
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' => esc_html__( 'Show Pagination', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'paginate_previcon',
            [
                'label' => __( 'Prev Icon', 'htmega-pro' ),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value'=>'fas fa-angle-left',
                    'library'=>'fa-solid',
                ],
                'condition' => [
                    'show_pagination' => 'yes',
                ],
                'separator' =>'before'
            ]
        );

        $this->add_control(
            'paginate_nexticon',
            [
                'label' => __( 'Next Icon', 'htmega-pro' ),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value'=>'fas fa-angle-right',
                    'library'=>'fa-solid',
                ],
                'condition' => [
                    'show_pagination' => 'yes',
                ]
            ]
        );


        $this->end_controls_section();

        // Style
        $this->start_controls_section(
            'item_style_section',
                array(
                    'label' => __( 'Item Style', 'htmega-pro' ),
                    'tab' => Controls_Manager::TAB_STYLE,
                )
            );

            $this->add_responsive_control(
                'box_content_alignment',
                [
                    'label' => esc_html__( 'Alignment', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__( 'Left', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-masonry-post-card-content' => 'text-align: {{VALUE}};',
                        '{{WRAPPER}} .htmega-masonry-post-card-content-meta,{{WRAPPER}} .htmega-masonry-post-card-style-2.htmega-masonry-post-card .htmega-masonry-post-card-content .htmega-masonry-post-meta-catagory,{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-meta-catagory' => 'justify-content: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'box_background_color',
                [
                    'label' => __( 'Background Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-masonry-post-card' => 'background-color: {{VALUE}}',
                    ],
                ]
            );   
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'box_border',
                    'label' => __( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-masonry-post-card',
                ]
            ); 
            $this->add_responsive_control(
                'box_border_radius',
                [
                    'label' => __( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-masonry-post-card' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                    
                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'box_shadow',
                    'label' => __( 'Box Shadow', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-masonry-post-card',
                ]
            );
            $this->add_responsive_control(
                'box_normal_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-masonry-post-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                    ],
                ]
            );
            $this->add_responsive_control(
                'content_box_spacing',
                [
                    'label' => esc_html__( 'Content Box Spacing', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-masonry-post-card-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                    ],
                ]
            );
        $this->end_controls_section();
 
        // Title Style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_title' =>'yes',
                ]
            ]
            );

            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-card-content-title a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'title_color_hover',
                [
                    'label' => __( 'Hover Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-card-content-title a:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-card-content-title',
                ]
            );

            $this->add_responsive_control(
                'title_margin',
                [
                    'label' => __( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-card-content-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();
        // Style Content tab section
        $this->start_controls_section(
            'content_style_section',
            [
                'label' => __( 'Content', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition'=>[
                    'show_content'=>'yes',
                ]
            ]
            );
                $this->add_control(
                    'content_color',
                    [
                        'label' => __( 'Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-description' => 'color: {{VALUE}}',
                        ],
                    ]
                );

                $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                        'name' => 'content_typography',
                        'label' => __( 'Typography', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-description',
                    ]
                );

                $this->add_responsive_control(
                    'content_margin',
                    [
                        'label' => __( 'Margin', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                    ]
                );
            $this->end_controls_section();

            //style thumbnail opacity section
            $this->start_controls_section(
                'post_thumbnail_opacity_section',
                [
                    'label' => __( 'Thumbnail', 'htmega-pro' ),
                    'tab' => Controls_Manager::TAB_STYLE,
                ]
            );
            $this->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'htmega_image',
                    'label' => esc_html__( 'Image Size', 'htmega-pro' ),
                    'exclude'      => ['custom'],
                    'default'      => 'medium',
                    'separator' => 'none',
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'image_border',
                    'label' => __( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-card-image',
                ]
            );

            $this->add_responsive_control(
                'image_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-card-image' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );
            $this->add_control(
                'item_overlay_color_heading',
                [
                    'label' => __( 'Image Overlay Color', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'masonry_style' =>array('1','3'),
                    ]
                ]
            );
    
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'box_background_overlay_color',
                    'label' => __( 'Background', 'htmega-pro' ),
                    'types' => [ 'gradient' ],
                    'exclude' => array('image'),
                    'selector' => '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-card-image::after,{{WRAPPER}} .htmega-masonry-post-card-style-3.htmega-masonry-post-card .htmega-masonry-post-card-image::after',
                    'condition' => [
                        'masonry_style' =>array('1','3'),
                    ]
                ]
            );

            $this->end_controls_section();

            // Style Category tab section
            $this->start_controls_section(
                'category_style_section',
                [
                    'label' => __( 'Category', 'htmega-pro' ),
                    'tab' => Controls_Manager::TAB_STYLE,
                    'condition'=>[
                        'show_category'=>'yes',
                    ]
                ]
                );
                
                $this->start_controls_tabs('category_style_tabs');

                    $this->start_controls_tab(
                        'category_style_normal_tab',
                        [
                            'label' => __( 'Normal', 'htmega-pro' ),
                        ]
                    );

                        $this->add_control(
                            'category_color',
                            [
                                'label' => __( 'Color', 'htmega-pro' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-meta-catagory a' => 'color: {{VALUE}}',
                                ],
                            ]
                        );
                        $this->add_group_control(
                            Group_Control_Background::get_type(),
                            [
                                'name' => 'category_background',
                                'label' => __( 'Background', 'htmega-pro' ),
                                'types' => [ 'classic', 'gradient' ],
                                'exclude' => array('image'),
                                'selector' => '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-meta-catagory a',
                            ]
                        );

                        $this->add_group_control(
                            Group_Control_Typography::get_type(),
                            [
                                'name' => 'category_typography',
                                'label' => __( 'Typography', 'htmega-pro' ),
                                'selector' => '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-meta-catagory a',
                            ]
                        );
                        $this->add_responsive_control(
                            'category_padding',
                            [
                                'label' => __( 'Padding', 'htmega-pro' ),
                                'type' => Controls_Manager::DIMENSIONS,
                                'size_units' => [ 'px', '%', 'em' ],
                                'selectors' => [
                                    '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-meta-catagory a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                            ]
                        );

                        $this->add_responsive_control(
                            'category_margin',
                            [
                                'label' => __( 'Margin', 'htmega-pro' ),
                                'type' => Controls_Manager::DIMENSIONS,
                                'size_units' => [ 'px', '%', 'em' ],
                                'selectors' => [
                                    '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-meta-catagory' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                            ]
                        );
                        $this->add_responsive_control(
                            'category_border_radius',
                            [
                                'label' => __( 'Border Radius', 'htmega-pro' ),
                                'type' => Controls_Manager::DIMENSIONS,
                                'size_units' => [ 'px', '%', 'em' ],
                                'selectors' => [
                                    '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-meta-catagory a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                            ]
                        );
                    $this->end_controls_tab(); // Normal Tab end

                    $this->start_controls_tab(
                        'category_style_hover_tab',
                        [
                            'label' => __( 'Hover', 'htmega-pro' ),
                        ]
                    );
                        $this->add_control(
                            'category_hover_color',
                            [
                                'label' => __( 'Color', 'htmega-pro' ),
                                'type' => Controls_Manager::COLOR,
                                'default'=>'#ffffff',
                                'selectors' => [
                                    '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-meta-catagory a:hover' => 'color: {{VALUE}}',
                                ],
                            ]
                        );

                        $this->add_group_control(
                            Group_Control_Background::get_type(),
                            [
                                'name' => 'category_hover_background',
                                'label' => __( 'Background', 'htmega-pro' ),
                                'types' => [ 'classic', 'gradient' ],
                                'exclude' => array('image'),
                                'selector' => '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-meta-catagory a:hover',
                            ]
                        );

                    $this->end_controls_tab(); // Hover Tab end

                $this->end_controls_tabs();

            $this->end_controls_section();

            // Style Meta tab section
            $this->start_controls_section(
                'post_meta_style_section',
                [
                    'label' => __( 'Meta', 'htmega-pro' ),
                    'tab' => Controls_Manager::TAB_STYLE,
                    'conditions' => [
                        'relation' => 'or',
                        'terms' => [
                            ['name' => 'show_author', 'operator' => '===', 'value' => 'yes'],
                            ['name' => 'show_date', 'operator' => '==', 'value' => 'yes'],
                        ]
                       
                    ],
                ]
                );
                $this->add_control(
                    'meta_color',
                    [
                        'label' => __( 'Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-card-content-meta .htmega-masonry-post-meta-item .htmega-masonry-post-meta-name,{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-card-content-meta .htmega-masonry-post-meta-item .htmega-masonry-post-meta-comment' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-card-content-meta .htmega-masonry-post-meta-item .htmega-masonry-post-meta-icon svg path' => 'fill: {{VALUE}}',
                            '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-card-content-meta .htmega-masonry-post-meta-item .htmega-masonry-post-meta-name' => 'border-color: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_control(
                    'meta_author_color',
                    [
                        'label' => __( 'Author Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-card-content-meta .htmega-masonry-post-meta-item .htmega-masonry-post-meta-name' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .htmega-masonry-post-card-style-2.htmega-masonry-post-card .htmega-masonry-post-card-content-meta .htmega-masonry-post-meta-item .htmega-masonry-post-meta-name' => 'border-color: {{VALUE}}',
                        ],
                    ]
                );

                $this->add_control(
                    'meta_color_hover',
                    [
                        'label' => __( 'Meta Hover Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-card-content-meta .htmega-masonry-post-meta-item:hover .htmega-masonry-post-meta-name' => 'color: {{VALUE}}',
                            '{{WRAPPER}} .htmega-masonry-post-card-style-2.htmega-masonry-post-card .htmega-masonry-post-card-content-meta .htmega-masonry-post-meta-item:hover .htmega-masonry-post-meta-name' => 'border-color: {{VALUE}}',
                        ],
                    ]
                );

                $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                        'name' => 'meta_typography',
                        'label' => __( 'Typography', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-card-content-meta .htmega-masonry-post-meta-item .htmega-masonry-post-meta-name,{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-card-content-meta .htmega-masonry-post-meta-item .htmega-masonry-post-meta-comment',
                    ]
                );
                $this->add_responsive_control(
                    'meta_icon_font_size',
                    [
                        'label' => __( 'Icon Size', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px'],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 100,
                                'step' => 1,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-masonry-post-card .htmega-post-masonry-meta-item svg,{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-card-content-meta .htmega-masonry-post-meta-item .htmega-masonry-post-meta-icon svg' => 'width: {{SIZE}}px;',
                        ],
                    ]
                );
                $this->add_control(
                    'meta_separator_color',
                    [
                        'label' => __( 'Separator Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-masonry-post-meta-item:not(:last-child)::after' => 'background: {{VALUE}}',
                            '{{WRAPPER}} .htmega-masonry-post-card-style-2.htmega-masonry-post-card .htmega-masonry-post-card-content-meta' => 'border-color: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'meta_margin',
                    [
                        'label' => __( 'Margin', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-card-content-meta' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                    ]
                );

            $this->end_controls_section();

            // Style Read More button tab section
            $this->start_controls_section(
                'readmore_style_section',
                [
                    'label' => __( 'Read More', 'htmega-pro' ),
                    'tab' => Controls_Manager::TAB_STYLE,
                    'condition'=>[
                        'show_read_more_btn'=>'yes',
                        'read_more_txt!'=>'',
                    ]
                ]
                );
                $this->start_controls_tabs('readmore_style_tabs');

                    $this->start_controls_tab(
                        'readmore_style_normal_tab',
                        [
                            'label' => __( 'Normal', 'htmega-pro' ),
                        ]
                    );

                        $this->add_control(
                            'readmore_color',
                            [
                                'label' => __( 'Color', 'htmega-pro' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-read-more,{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-read-more-text' => 'color: {{VALUE}};',
                                    '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-read-more svg path,{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-read-more-text svg path' => 'fill: {{VALUE}};',
                                ],
                            ]
                        );

                        $this->add_group_control(
                            Group_Control_Typography::get_type(),
                            [
                                'name' => 'readmore_typography',
                                'label' => __( 'Typography', 'htmega-pro' ),
                                'selector' => '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-read-more',
                            ]
                        );
                        $this->add_group_control(
                            Group_Control_Background::get_type(),
                            [
                                'name' => 'readmore_background',
                                'label' => __( 'Background', 'htmega-pro' ),
                                'types' => [ 'classic', 'gradient' ],
                                'selector' => '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-read-more',
                            ]
                        );

                        $this->add_group_control(
                            Group_Control_Border::get_type(),
                            [
                                'name' => 'readmore_border',
                                'label' => __( 'Border', 'htmega-pro' ),
                                'selector' => '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-read-more',
                            ]
                        );

                        $this->add_responsive_control(
                            'readmore_border_radius',
                            [
                                'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                                'type' => Controls_Manager::DIMENSIONS,
                                'selectors' => [
                                    '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-read-more' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                                ],
                            ]
                        );
                        $this->add_responsive_control(
                            'readmore_padding',
                            [
                                'label' => __( 'Padding', 'htmega-pro' ),
                                'type' => Controls_Manager::DIMENSIONS,
                                'size_units' => [ 'px', '%', 'em' ],
                                'selectors' => [
                                    '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-read-more' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                            ]
                        );
                        $this->add_responsive_control(
                            'readmore_margin',
                            [
                                'label' => __( 'Margin', 'htmega-pro' ),
                                'type' => Controls_Manager::DIMENSIONS,
                                'size_units' => [ 'px', '%', 'em' ],
                                'selectors' => [
                                    '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-read-more' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                            ]
                        );
                    $this->end_controls_tab(); // Normal Tab end

                    $this->start_controls_tab(
                        'readmore_style_hover_tab',
                        [
                            'label' => __( 'Hover', 'htmega-pro' ),
                        ]
                    );
                        $this->add_control(
                            'readmore_hover_color',
                            [
                                'label' => __( 'Color', 'htmega-pro' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-read-more:hover,{{WRAPPER}} .htmega-masonry-post-card-style-4.htmega-masonry-post-card .htmega-masonry-post-read-more:hover .htmega-masonry-post-read-more-text ' => 'color: {{VALUE}}',
                                ],
                            ]
                        );

                        $this->add_group_control(
                            Group_Control_Background::get_type(),
                            [
                                'name' => 'readmore_hover_background',
                                'label' => __( 'Background', 'htmega-pro' ),
                                'types' => [ 'classic', 'gradient' ],
                                'selector' => '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-read-more:hover',
                            ]
                        );

                        $this->add_group_control(
                            Group_Control_Border::get_type(),
                            [
                                'name' => 'readmore_hover_border',
                                'label' => __( 'Border', 'htmega-pro' ),
                                'selector' => '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-read-more:hover',
                            ]
                        );

                        $this->add_responsive_control(
                            'readmore_hover_border_radius',
                            [
                                'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                                'type' => Controls_Manager::DIMENSIONS,
                                'selectors' => [
                                    '{{WRAPPER}} .htmega-masonry-post-card .htmega-masonry-post-read-more:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                                ],
                            ]
                        );

                    $this->end_controls_tab(); // Hover Tab end

                $this->end_controls_tabs();

            $this->end_controls_section();
            // Style Load More button tab section
            $this->start_controls_section(
                'pagination_style_section',
                [
                    'label' => __( 'Pagination', 'htmega-pro' ),
                    'tab' => Controls_Manager::TAB_STYLE,
                    'condition'=>[
                        'show_pagination'=>'yes',
                    ]
                ]
                );

                $this->add_responsive_control(
                    'paginate_alignment',
                    [
                        'label' => esc_html__( 'Alignment', 'htmega-pro' ),
                        'type' => Controls_Manager::CHOOSE,
                        'options' => [
                            'left' => [
                                'title' => esc_html__( 'Left', 'htmega-pro' ),
                                'icon' => 'eicon-text-align-left',
                            ],
                            'center' => [
                                'title' => esc_html__( 'Center', 'htmega-pro' ),
                                'icon' => 'eicon-text-align-center',
                            ],
                            'right' => [
                                'title' => esc_html__( 'Right', 'htmega-pro' ),
                                'icon' => 'eicon-text-align-right',
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-masonry-post-pagination' => 'justify-content: {{VALUE}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'paginate_background_color',
                    [
                        'label' => __( 'Background Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-custom-pagination' => 'background-color: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'paginate_border',
                        'label' => __( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-custom-pagination',
                    ]
                ); 
                $this->add_responsive_control(
                    'paginate_border_radius',
                    [
                        'label' => __( 'Border Radius', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-custom-pagination' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                        ],
                    ]
                );
                $this->add_group_control(
                    Group_Control_Box_Shadow::get_type(),
                    [
                        'name' => 'paginate_shadow',
                        'selector' => '{{WRAPPER}} .htmega-custom-pagination',
                    ]
                );
                $this->add_responsive_control(
                    'paginate_normal_padding',
                    [
                        'label' => esc_html__( 'Padding', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-custom-pagination' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'paginate_normal_margin',
                    [
                        'label' => esc_html__( 'Margin', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-custom-pagination' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'paginate_Loading_icon_color',
                    [
                        'label' => __( 'Preloader Icon  Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-preloader-wrap .htmega-preloader .htmega-dot' => 'background-color: {{VALUE}}',
                        ],
                    ]
                );   
                $this->add_control(
                    'pagination_item_heading',
                    [
                        'label' => __( 'Pagination Item Style', 'htmega-pro' ),
                        'type' => Controls_Manager::HEADING,
                        'separator' => 'before',
                    ]
                );
        
                $this->start_controls_tabs('pagination_style_tabs');

                    $this->start_controls_tab(
                        'pagination_style_normal_tab',
                        [
                            'label' => __( 'Normal', 'htmega-pro' ),
                        ]
                    );

                        $this->add_control(
                            'pagination_color',
                            [
                                'label' => __( 'Color', 'htmega-pro' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .htmega-masonry-post-pagination-link' => 'color: {{VALUE}};',
                                    '{{WRAPPER}} .htmega-masonry-post-pagination-link svg path' => 'fill: {{VALUE}};',
                                ],
                            ]
                        );
                        $this->add_group_control(
                            Group_Control_Typography::get_type(),
                            [
                                'name' => 'pagination_typography',
                                'label' => __( 'Typography', 'htmega-pro' ),
                                'selector' => '{{WRAPPER}} .htmega-masonry-post-pagination-link',
                            ]
                        );
                        $this->add_group_control(
                            Group_Control_Background::get_type(),
                            [
                                'name' => 'pagination_background',
                                'label' => __( 'Background', 'htmega-pro' ),
                                'types' => [ 'classic', 'gradient' ],
                                'exclude' => array('image'),
                                'selector' => '{{WRAPPER}} .htmega-masonry-post-pagination-link',
                            ]
                        );
                        $this->add_responsive_control(
                            'pagination_item_height',
                            [
                                'label' => __( 'Height', 'htmega-pro' ),
                                'type' => Controls_Manager::SLIDER,
                                'size_units' => [ 'px', '%' ],
                                'range' => [
                                    'px' => [
                                        'min' => 0,
                                        'max' => 200,
                                        'step' => 1,
                                    ],
                                    '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                    ],
                                ],
                                'default' => [
                                    'unit' => 'px',
                                    'size' => 45,
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .htmega-masonry-post-pagination-link' => 'height: {{SIZE}}{{UNIT}};',
                                ],
                            ]
                        );
        
                        $this->add_responsive_control(
                            'pagination_item_width',
                            [
                                'label' => __( 'Width', 'htmega-pro' ),
                                'type' => Controls_Manager::SLIDER,
                                'size_units' => [ 'px', '%' ],
                                'range' => [
                                    'px' => [
                                        'min' => 0,
                                        'max' => 200,
                                        'step' => 1,
                                    ],
                                    '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                    ],
                                ],
                                'default' => [
                                    'unit' => 'px',
                                    'size' => 45,
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .htmega-masonry-post-pagination-link' => 'width: {{SIZE}}{{UNIT}};',
                                ],
                            ]
                        );
                        $this->add_group_control(
                            Group_Control_Border::get_type(),
                            [
                                'name' => 'pagination_border',
                                'label' => __( 'Border', 'htmega-pro' ),
                                'selector' => '{{WRAPPER}} .htmega-masonry-post-pagination-link',
                            ]
                        );

                        $this->add_responsive_control(
                            'pagination_border_radius',
                            [
                                'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                                'type' => Controls_Manager::DIMENSIONS,
                                'selectors' => [
                                    '{{WRAPPER}} .htmega-masonry-post-pagination-link' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                                ],
                            ]
                        );
                        $this->add_responsive_control(
                            'pagination_item_gap',
                            [
                                'label' => __( 'Inner Gap', 'htmega-pro' ),
                                'type' => Controls_Manager::SLIDER,
                                'size_units' => [ 'px', '%' ],
                                'range' => [
                                    'px' => [
                                        'min' => 0,
                                        'max' => 1000,
                                        'step' => 1,
                                    ],
                                    '%' => [
                                        'min' => 0,
                                        'max' => 100,
                                    ],
                                ],
                                'default' => [
                                    'unit' => 'px',
                                    'size' => 15,
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .htmega-masonry-post-pagination' => 'gap: {{SIZE}}{{UNIT}};',
                                ],
                            ]
                        );
                    $this->end_controls_tab(); // Normal Tab end

                    $this->start_controls_tab(
                        'pagination_style_hover_tab',
                        [
                            'label' => __( 'Active', 'htmega-pro' ),
                        ]
                    );
                        $this->add_control(
                            'pagination_hover_color',
                            [
                                'label' => __( 'Color', 'htmega-pro' ),
                                'type' => Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .htmega-masonry-post-pagination-link:hover,{{WRAPPER}} .htmega-masonry-post-pagination-link.selected' => 'color: {{VALUE}}',
                                    '{{WRAPPER}} .htmega-masonry-post-pagination-link:hover svg path,{{WRAPPER}} .htmega-masonry-post-pagination-link.selected svg path' => 'fill: {{VALUE}}',
                                ],
                            ]
                        );

                        $this->add_group_control(
                            Group_Control_Background::get_type(),
                            [
                                'name' => 'pagination_hover_background',
                                'label' => __( 'Background', 'htmega-pro' ),
                                'types' => [ 'classic', 'gradient' ],
                                'exclude' => array('image'),
                                'selector' => '{{WRAPPER}} .htmega-masonry-post-pagination-link:hover,{{WRAPPER}} .htmega-masonry-post-pagination-link.selected',
                            ]
                        );

                        $this->add_group_control(
                            Group_Control_Border::get_type(),
                            [
                                'name' => 'pagination_hover_border',
                                'label' => __( 'Border', 'htmega-pro' ),
                                'selector' => '{{WRAPPER}} .htmega-masonry-post-pagination-link:hover,{{WRAPPER}} .htmega-masonry-post-pagination-link.selected',
                            ]
                        );

                        $this->add_responsive_control(
                            'pagination_hover_border_radius',
                            [
                                'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                                'type' => Controls_Manager::DIMENSIONS,
                                'selectors' => [
                                    '{{WRAPPER}} .htmega-masonry-post-pagination-link:hover,{{WRAPPER}} .htmega-masonry-post-pagination-link.selected' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                                ],
                            ]
                        );

                    $this->end_controls_tab(); // Hover Tab end

                $this->end_controls_tabs();

            $this->end_controls_section();
    }

    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();

        $read_mor_icon_font  = $settings['read_mor_icon_font'];
        $read_mor_icon_image  =   ( isset($settings['read_mor_icon_image']['url']) ? $settings['read_mor_icon_image']['url'] : '');
        $icon_imgprint = '';

        if('yes' == $settings['show_read_more_btn_icon'] ){
            if( $read_mor_icon_font && 'icon' == $settings['read_mor_icon_type'] ){
                $icon_imgprint = HTMega_Icon_manager::render_icon( $settings['read_mor_icon_font'], [ 'aria-hidden' => 'true' ] );
            }else{
                $icon_imgprint ='<img src="'. esc_url( $read_mor_icon_image ) .'" alt="icon" />';
            }
        }

        $sectionid =  $this-> get_id();
        $sectionid = 'secid'.$sectionid;
        $htmega_image  = $this->get_settings_for_display('htmega_image_size');

        $post_type = $settings['post_type'];
        $post_categorys = $settings[ $post_type.'_post_category'];
        $post_author = $settings['post_author'];
        $exclude_posts = $settings['exclude_posts'];
        $orderby            = $this->get_settings_for_display('orderby');
        $postorder          = $this->get_settings_for_display('postorder');
        $category_name =  get_object_taxonomies($post_type);
        // Post query
        $args = array(
            'post_type'             => $post_type,
            'post_status'           => 'publish',
            'ignore_sticky_posts'   => 1,
            'posts_per_page'        => !empty( $settings['post_limit'] ) ? (int)$settings['post_limit'] : 3,
        );

        if (  !empty( $post_categorys ) ) {

            if( $category_name['0'] == "product_type" ){

                    $category_name['0'] = 'product_cat';
            }

            if( is_array($post_categorys) && count($post_categorys) > 0 ){

                $field_name = is_numeric( $post_categorys[0] ) ? 'term_id' : 'slug';
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => $category_name[0],
                        'terms' => $post_categorys,
                        'field' => $field_name,
                        'include_children' => false
                    )
                );
            }
        }
        // author check
        if (  !empty( $post_author ) ) {
            $args['author__in'] = $post_author;
        }
        // order by  check
        if ( !empty( $orderby ) ) {
            if ( 'date' == $orderby && 'yes'== $settings['custom_order_by_date'] && (!empty( $settings['order_by_date_after'] || $settings['order_by_date_before'] ) ) ) {
            $order_by_date_after = strtotime($settings['order_by_date_after']);
            $order_by_date_before = strtotime($settings['order_by_date_before']);
                $args['date_query'] = array(
                    array(
                        'before'    => array(
                            'year'  => gmdate('Y', $order_by_date_before),
                            'month' =>gmdate('m', $order_by_date_before),
                            'day'   => gmdate('d', $order_by_date_before),
                        ),
                        'after'    => array(
                            'year'  => gmdate('Y', $order_by_date_after),
                            'month' =>gmdate('m', $order_by_date_after),
                            'day'   => gmdate('d', $order_by_date_after),
                        ),
                        'inclusive' => true,
                    ),
                );

            } else {
                $args['orderby'] = $orderby;
            }
        }

        // Exclude posts check
        if (  !empty( $exclude_posts ) ) {
            $exclude_posts = explode(',',$exclude_posts);
            $args['post__not_in'] =  $exclude_posts;
        }

        // Order check
        if (  !empty( $postorder ) ) {
            $args['order'] =  $postorder;
        }
        // empty thumbnail post
        if ( 'yes' === $settings['hide_empty_thumbnail_post'] ) {
            $args['meta_query'] = [
                [
                    'key' => '_thumbnail_id',
                    'compare' => 'EXISTS'
                ],
            ];
        }

        $post_query = new \WP_Query( $args );

        $args_json =  wp_json_encode($args);

       $masonry_style =  $settings['masonry_style'];
       $pagination_times_class = ('yes' == $settings['show_pagination']) ? "htmega-masonry-load-more-item-{$sectionid}":'';

        $this->add_render_attribute( 'htmega_pro_wrapper_attr', 'class', "htmega-masonry-row htmega-masonry-post-grid-{$sectionid} " );

        $this->add_render_attribute( 'htmega_card_classes', 'class', "htmega-masonry-post-card htmega-masonry-post-card-style-{$masonry_style}" );

        if( 'yes' == $settings['show_pagination'] ){ 
            $display_options = array(
                'htmega_card_classes'=> "htmega-masonry-post-card htmega-masonry-post-card-style-{$masonry_style}",
                'masonry_style' => $settings['masonry_style'],
                'htmega_image' => $htmega_image,
                'show_author' => $settings['show_author'],
                'show_date' => $settings['show_date'],
                'show_title' => $settings['show_title'],
                'title_length' => $settings['title_length'],
                'show_content' => $settings['show_content'],
                'content_length' => $settings['content_length'],
                'show_category' => $settings['show_category'],
                'post_type' => $settings['post_type'],
                'show_read_more_btn' => $settings['show_read_more_btn'],
                'read_more_txt' => $settings['read_more_txt'],
                'icon_imgprint' => $icon_imgprint,
                'paginate_previcon' => $settings['paginate_previcon']['value'],
                'paginate_nexticon' => $settings['paginate_nexticon']['value'],
            );

            $display_options_json =  wp_json_encode($display_options);
        }
        ?>
        <div class="htmega-post-masonry-widget-wrapper">
            <?php
            if( 'yes' == $settings['show_pagination'] ){ ?>
                <div class="htmega-preloader-wrap" id ="<?php echo esc_attr($sectionid);?>">
                    <div class="htmega-preloader">
                        <span class="htmega-dot"></span>
                        <div class="htmega-dots">
                            <span></span>
                            <span></span>
                            <span></span>
                        </div>
                    </div>
                </div>
                <?php 
            } ?>
            <!-- masonry section start -->
            <div <?php echo $this->get_render_attribute_string( 'htmega_pro_wrapper_attr' ); ?> style="opacity:0;">

                <?php 
                if( 'yes' != $settings['show_pagination'] ){ 
                    if( $post_query->have_posts() ):
                        echo '<div class="htmega-masonry-sizer htmega-masonry-flex-column"></div>'; //default resizer
                        while( $post_query->have_posts() ): $post_query->the_post();
                            ?>
                            <div class="htmega-masonry-flex-column htmega-masonry-post-item">
                                <div <?php echo $this->get_render_attribute_string( 'htmega_card_classes' ); ?> >
                                    <?php
                                    if ( has_post_thumbnail() && '4' != $masonry_style){ ?>
                                        <a href="<?php the_permalink();?>" class="htmega-masonry-post-card-image"><?php the_post_thumbnail( $htmega_image );?></a>
                                        <?php 
                                    } ?>
                                    <?php if( 'yes' == $settings['show_author'] || $settings['show_date'] == 'yes' || $settings['show_title'] == 'yes' || $settings['show_content'] == 'yes' || $settings['show_category'] == 'yes' ){ ?>
                                        <div class="htmega-masonry-post-card-content">
                                            <?php 
                                            if ( $category_name ){
                                            $get_terms = get_the_terms( $post_query->ID, $category_name[0] );
                                            if($post_type == 'product'){
                                                $get_terms = get_the_terms($post_query->ID, 'product_cat');
                                            }

                                            if( $settings['show_category'] == 'yes' && $get_terms ): ?>
                                                <div class="htmega-masonry-post-meta-catagory">
                                                    <?php
                                                        foreach ( $get_terms as $category ) {
                                                            $term_link = get_term_link( $category );
                                                            ?>
                                                                <a href="<?php echo esc_url( $term_link ); ?>" class="htmega-cat-<?php echo esc_attr( $category->slug ); ?>"><?php echo esc_html( $category->name );?></a>
                                                            <?php
                                                        }
                                                    ?>
                                                </div>
                                                <?php 
                                            endif; 
                                            }
                                            ?>

                                            <!-- for style 3 mega -->
                                            <?php 
                                            if( ('yes' == $settings['show_author'] || $settings['show_date'] == 'yes') && ('3' == $masonry_style|| '4' == $masonry_style) ){ ?>
                                                <div class="htmega-masonry-post-card-content-meta">
                                                    <?php
                                                    if( 'yes' == $settings['show_author'] ){ ?>
                                                        <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" class="htmega-masonry-post-meta-item">
                                                            <?php 
                                                            if('4' != $masonry_style ){ ?>
                                                                <span class="htmega-masonry-post-meta-img">
                                                                    <img src="<?php echo esc_url( get_avatar_url( get_the_author_meta( 'ID' ), ['size' => '30'] ) ); ?>" alt="<?php echo the_author();?>" />
                                                                </span>
                                                                <?php
                                                            } ?>
                                                            <h6 class="htmega-masonry-post-meta-name">
                                                                <?php the_author(); ?>
                                                            </h6>
                                                        </a>
                                                        <?php 
                                                    } ?>
                                                    <?php 
                                                    if( $settings['show_date'] == 'yes' ): ?>
                                                        <div class="htmega-masonry-post-meta-item">
                                                        <?php 
                                                            if('4' != $masonry_style ){ ?>
                                                                <span class="htmega-masonry-post-meta-icon">
                                                                    <svg width="11" height="13" viewBox="0 0 11 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                        <path d="M10.5566 2.13624C10.5554 1.52355 10.2116 1.21536 9.60382 1.23132C9.39755 1.23623 9.35212 1.31727 9.35703 1.50022C9.36562 1.80963 9.37053 2.12027 9.35457 2.42969C9.33002 2.93065 9.03288 3.24252 8.53683 3.28181C8.27408 3.30268 8.00764 3.30145 7.74611 3.28304C7.21323 3.2462 6.91486 2.92328 6.90258 2.38794C6.89645 2.08958 6.89276 1.79122 6.90381 1.49285C6.91118 1.30131 6.8461 1.23255 6.64965 1.23378C5.73123 1.24237 4.81281 1.24237 3.89562 1.23378C3.68688 1.23132 3.64636 1.32095 3.6525 1.50145C3.66233 1.81086 3.6611 2.1215 3.65373 2.43092C3.64268 2.89872 3.37256 3.21673 2.90844 3.26953C2.62481 3.30268 2.33504 3.30022 2.04895 3.28304C1.52712 3.25234 1.23612 2.94292 1.21771 2.41741C1.20788 2.108 1.20666 1.79735 1.21771 1.48794C1.22507 1.29271 1.14895 1.23623 0.957405 1.23255C0.332436 1.21904 0.000920877 1.53214 0.000920877 2.17062C-0.000306959 5.22424 -0.000306959 8.27664 0.000920877 11.3303C0.000920877 11.9884 0.284551 12.2769 0.941443 12.2782C3.83422 12.2806 6.72578 12.2806 9.61856 12.2782C10.2804 12.2782 10.5566 11.9958 10.5566 11.3315C10.5591 9.8053 10.5566 8.27787 10.5566 6.75167C10.5579 5.21196 10.5603 3.67349 10.5566 2.13624ZM1.20297 4.30705C1.20174 4.14743 1.2705 4.08358 1.43012 4.08358C2.10543 4.08727 2.78074 4.08727 3.45482 4.08481C3.59971 4.08481 3.65619 4.14498 3.65496 4.29109C3.65005 4.83993 3.64882 5.39 3.65619 5.93884C3.65864 6.12056 3.56042 6.14144 3.41799 6.14021C3.08647 6.13653 2.75496 6.13898 2.42221 6.13898C2.0907 6.13898 1.75795 6.13407 1.42644 6.14144C1.26559 6.14512 1.20052 6.08373 1.20174 5.92165C1.20788 5.38263 1.20666 4.84484 1.20297 4.30705ZM3.65742 10.8269C3.65987 11.0024 3.60216 11.0724 3.4229 11.07C2.77092 11.0638 2.11894 11.0638 1.46696 11.07C1.27664 11.0724 1.19929 11.0061 1.20174 10.8121C1.20911 10.2854 1.20788 9.75987 1.20297 9.23313C1.20174 9.07228 1.26559 9.00843 1.42644 9.01212C1.75795 9.01948 2.08947 9.01457 2.42221 9.01457C2.75373 9.01457 3.08647 9.02071 3.41799 9.01212C3.59234 9.0072 3.6611 9.06614 3.65864 9.24786C3.64882 9.7746 3.65005 10.3013 3.65742 10.8269ZM3.37992 8.61061C3.05946 8.59711 2.73777 8.60693 2.41607 8.60693C2.10666 8.60693 1.79602 8.59711 1.4866 8.61061C1.28524 8.61921 1.1956 8.56396 1.20052 8.34417C1.21157 7.82848 1.21034 7.31156 1.20174 6.79464C1.19806 6.59574 1.2791 6.54048 1.46696 6.54294C2.10911 6.55153 2.7525 6.55522 3.39466 6.54171C3.61812 6.5368 3.66233 6.62766 3.65864 6.82534C3.64882 7.32998 3.64514 7.83585 3.65987 8.34049C3.66478 8.55904 3.58375 8.61921 3.37992 8.61061ZM4.29098 4.08481C4.94541 4.0885 5.59985 4.08972 6.25429 4.08358C6.4311 4.08236 6.49863 4.14743 6.49617 4.32547C6.4888 4.85344 6.48758 5.38141 6.49617 5.90938C6.49863 6.09723 6.41513 6.14389 6.24692 6.14021C5.91418 6.13284 5.58143 6.13775 5.24869 6.13775C4.927 6.13775 4.6053 6.13284 4.28484 6.14021C4.12276 6.14389 4.0626 6.0825 4.06383 5.9192C4.06997 5.38018 4.06997 4.83993 4.06383 4.30091C4.06137 4.13147 4.13627 4.08358 4.29098 4.08481ZM4.0626 6.78482C4.06015 6.61047 4.1154 6.54171 4.29835 6.54417C4.95155 6.55276 5.60476 6.55153 6.2592 6.54417C6.44092 6.54171 6.49863 6.6117 6.49617 6.78605C6.49003 7.31279 6.49003 7.84076 6.49617 8.36873C6.49863 8.54431 6.43846 8.6143 6.25797 8.60939C5.92523 8.59956 5.59371 8.60693 5.26097 8.60693C4.95155 8.60693 4.64214 8.60079 4.33272 8.60939C4.15346 8.61552 4.05769 8.57746 4.0626 8.3675C4.07365 7.84076 4.06997 7.31279 4.0626 6.78482ZM6.49863 10.7949C6.50354 11.0061 6.42618 11.0749 6.21868 11.0724C5.58757 11.0626 4.95647 11.0651 4.32413 11.0712C4.13627 11.0737 4.05646 11.0184 4.06137 10.817C4.07242 10.3001 4.07242 9.78442 4.06137 9.2675C4.05769 9.07105 4.12768 9.00475 4.31922 9.01212C4.63968 9.02317 4.96138 9.0158 5.28307 9.0158C5.59248 9.0158 5.90313 9.02439 6.21254 9.01212C6.41391 9.00475 6.50231 9.06123 6.4974 9.27978C6.48512 9.78442 6.48635 10.2903 6.49863 10.7949ZM6.8989 4.32792C6.89645 4.15234 6.95784 4.08113 7.1371 4.08358C7.79031 4.08972 8.44229 4.08972 9.0955 4.08358C9.27967 4.08236 9.36685 4.13884 9.36317 4.33897C9.35457 4.86572 9.35703 5.39246 9.36194 5.9192C9.36317 6.08127 9.30055 6.14389 9.13847 6.14021C8.79468 6.13407 8.45089 6.13775 8.10832 6.13775C7.7989 6.13775 7.48949 6.12916 7.1813 6.14144C6.98117 6.1488 6.89276 6.09232 6.8989 5.87377C6.90995 5.35931 6.90627 4.84361 6.8989 4.32792ZM9.36071 10.849C9.36194 11.0147 9.28336 11.0687 9.12988 11.0687C8.45457 11.0663 7.77803 11.0663 7.10272 11.0687C6.95784 11.0687 6.8989 11.0061 6.90013 10.8612C6.90381 10.3112 6.90504 9.76232 6.90013 9.21225C6.8989 9.02931 7.00572 9.01334 7.14447 9.01457C7.47598 9.01703 7.80873 9.0158 8.14024 9.0158C8.47176 9.0158 8.8045 9.02071 9.13602 9.01457C9.29686 9.01089 9.36194 9.07228 9.35948 9.23558C9.3558 9.77215 9.3558 10.3112 9.36071 10.849ZM9.07708 8.60939C8.75662 8.59711 8.43615 8.6057 8.11569 8.6057C7.78417 8.6057 7.45143 8.59956 7.11991 8.60693C6.95784 8.61061 6.89645 8.54799 6.8989 8.38592C6.90381 7.84813 6.90627 7.31033 6.89767 6.77254C6.89522 6.58468 6.97871 6.54171 7.14692 6.54294C7.7989 6.54908 8.45089 6.55031 9.10287 6.54171C9.29686 6.53925 9.36562 6.60556 9.36194 6.79833C9.35334 7.31279 9.35089 7.82848 9.36317 8.34295C9.36931 8.56641 9.27476 8.61675 9.07708 8.60939ZM2.48115 2.86434C2.89739 2.8361 3.22031 2.50459 3.24118 2.07239C3.251 1.85506 3.24241 1.63651 3.24241 1.41918C3.24241 1.2129 3.24977 1.00663 3.24118 0.800352C3.22153 0.363242 2.90598 0.0341825 2.48852 0.00225879C2.07474 -0.0284371 1.70025 0.256421 1.64376 0.692302C1.57992 1.18098 1.58237 1.67825 1.64254 2.16693C1.69533 2.60281 2.0686 2.89136 2.48115 2.86434ZM8.10464 2.86557C8.55157 2.88276 8.91255 2.53406 8.94448 2.04169C8.95675 1.8477 8.94693 1.65247 8.94693 1.45724H8.9457C8.9457 1.23992 8.95921 1.02013 8.94325 0.804035C8.90764 0.332546 8.5528 -0.00510823 8.11814 0.00103095C7.68226 0.00717013 7.33233 0.35342 7.31514 0.824908C7.3004 1.22518 7.30163 1.62791 7.31514 2.02819C7.32987 2.50459 7.66384 2.84838 8.10464 2.86557Z" fill="white"/>
                                                                    </svg>
                                                                </span>
                                                            <?php
                                                            } ?>
                                                            <span class="htmega-masonry-post-meta-comment">
                                                                <?php the_time('d F Y') ?>
                                                            </span>
                                                        </div>
                                                        <?php 
                                                    endif; ?>
                                                </div>
                                                <?php 
                                            }?>
                                                <?php 
                                            if( $settings['show_title'] == 'yes' ): ?>
                                                <h2 class="htmega-masonry-post-card-content-title">
                                                    <a href="<?php the_permalink();?>">
                                                    <?php 
                                                        if ( 0 > $settings['title_length'] ) { 
                                                            the_title();
                                                        } else { 
                                                            echo esc_html( wp_trim_words( get_the_title(), $settings['title_length'], '' ) );
                                                        }
                                                    ?>
                                                    </a>
                                                </h2>
                                                <?php 
                                            endif;
                                            ?>
                                                <?php 
                                            if( ('yes' == $settings['show_author'] || $settings['show_date'] == 'yes')  && ('1' == $masonry_style|| '2' == $masonry_style)){ ?>
                                                <div class="htmega-masonry-post-card-content-meta">
                                                    <?php
                                                    if( 'yes' == $settings['show_author'] ){ ?>
                                                        <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" class="htmega-masonry-post-meta-item">
                                                            <span class="htmega-masonry-post-meta-img">
                                                                <img src="<?php echo esc_url( get_avatar_url( get_the_author_meta( 'ID' ), ['size' => '30'] ) ); ?>" alt="<?php echo the_author();?>" />
                                                            </span>
                                                            <h6 class="htmega-masonry-post-meta-name">
                                                                <?php the_author(); ?>
                                                            </h6>
                                                        </a>
                                                        <?php 
                                                    } ?>
                                                    <?php 
                                                    if( $settings['show_date'] == 'yes' ): ?>
                                                        <div class="htmega-masonry-post-meta-item">
                                                            <span class="htmega-masonry-post-meta-icon">
                                                                <svg width="11" height="13" viewBox="0 0 11 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                    <path d="M10.5566 2.13624C10.5554 1.52355 10.2116 1.21536 9.60382 1.23132C9.39755 1.23623 9.35212 1.31727 9.35703 1.50022C9.36562 1.80963 9.37053 2.12027 9.35457 2.42969C9.33002 2.93065 9.03288 3.24252 8.53683 3.28181C8.27408 3.30268 8.00764 3.30145 7.74611 3.28304C7.21323 3.2462 6.91486 2.92328 6.90258 2.38794C6.89645 2.08958 6.89276 1.79122 6.90381 1.49285C6.91118 1.30131 6.8461 1.23255 6.64965 1.23378C5.73123 1.24237 4.81281 1.24237 3.89562 1.23378C3.68688 1.23132 3.64636 1.32095 3.6525 1.50145C3.66233 1.81086 3.6611 2.1215 3.65373 2.43092C3.64268 2.89872 3.37256 3.21673 2.90844 3.26953C2.62481 3.30268 2.33504 3.30022 2.04895 3.28304C1.52712 3.25234 1.23612 2.94292 1.21771 2.41741C1.20788 2.108 1.20666 1.79735 1.21771 1.48794C1.22507 1.29271 1.14895 1.23623 0.957405 1.23255C0.332436 1.21904 0.000920877 1.53214 0.000920877 2.17062C-0.000306959 5.22424 -0.000306959 8.27664 0.000920877 11.3303C0.000920877 11.9884 0.284551 12.2769 0.941443 12.2782C3.83422 12.2806 6.72578 12.2806 9.61856 12.2782C10.2804 12.2782 10.5566 11.9958 10.5566 11.3315C10.5591 9.8053 10.5566 8.27787 10.5566 6.75167C10.5579 5.21196 10.5603 3.67349 10.5566 2.13624ZM1.20297 4.30705C1.20174 4.14743 1.2705 4.08358 1.43012 4.08358C2.10543 4.08727 2.78074 4.08727 3.45482 4.08481C3.59971 4.08481 3.65619 4.14498 3.65496 4.29109C3.65005 4.83993 3.64882 5.39 3.65619 5.93884C3.65864 6.12056 3.56042 6.14144 3.41799 6.14021C3.08647 6.13653 2.75496 6.13898 2.42221 6.13898C2.0907 6.13898 1.75795 6.13407 1.42644 6.14144C1.26559 6.14512 1.20052 6.08373 1.20174 5.92165C1.20788 5.38263 1.20666 4.84484 1.20297 4.30705ZM3.65742 10.8269C3.65987 11.0024 3.60216 11.0724 3.4229 11.07C2.77092 11.0638 2.11894 11.0638 1.46696 11.07C1.27664 11.0724 1.19929 11.0061 1.20174 10.8121C1.20911 10.2854 1.20788 9.75987 1.20297 9.23313C1.20174 9.07228 1.26559 9.00843 1.42644 9.01212C1.75795 9.01948 2.08947 9.01457 2.42221 9.01457C2.75373 9.01457 3.08647 9.02071 3.41799 9.01212C3.59234 9.0072 3.6611 9.06614 3.65864 9.24786C3.64882 9.7746 3.65005 10.3013 3.65742 10.8269ZM3.37992 8.61061C3.05946 8.59711 2.73777 8.60693 2.41607 8.60693C2.10666 8.60693 1.79602 8.59711 1.4866 8.61061C1.28524 8.61921 1.1956 8.56396 1.20052 8.34417C1.21157 7.82848 1.21034 7.31156 1.20174 6.79464C1.19806 6.59574 1.2791 6.54048 1.46696 6.54294C2.10911 6.55153 2.7525 6.55522 3.39466 6.54171C3.61812 6.5368 3.66233 6.62766 3.65864 6.82534C3.64882 7.32998 3.64514 7.83585 3.65987 8.34049C3.66478 8.55904 3.58375 8.61921 3.37992 8.61061ZM4.29098 4.08481C4.94541 4.0885 5.59985 4.08972 6.25429 4.08358C6.4311 4.08236 6.49863 4.14743 6.49617 4.32547C6.4888 4.85344 6.48758 5.38141 6.49617 5.90938C6.49863 6.09723 6.41513 6.14389 6.24692 6.14021C5.91418 6.13284 5.58143 6.13775 5.24869 6.13775C4.927 6.13775 4.6053 6.13284 4.28484 6.14021C4.12276 6.14389 4.0626 6.0825 4.06383 5.9192C4.06997 5.38018 4.06997 4.83993 4.06383 4.30091C4.06137 4.13147 4.13627 4.08358 4.29098 4.08481ZM4.0626 6.78482C4.06015 6.61047 4.1154 6.54171 4.29835 6.54417C4.95155 6.55276 5.60476 6.55153 6.2592 6.54417C6.44092 6.54171 6.49863 6.6117 6.49617 6.78605C6.49003 7.31279 6.49003 7.84076 6.49617 8.36873C6.49863 8.54431 6.43846 8.6143 6.25797 8.60939C5.92523 8.59956 5.59371 8.60693 5.26097 8.60693C4.95155 8.60693 4.64214 8.60079 4.33272 8.60939C4.15346 8.61552 4.05769 8.57746 4.0626 8.3675C4.07365 7.84076 4.06997 7.31279 4.0626 6.78482ZM6.49863 10.7949C6.50354 11.0061 6.42618 11.0749 6.21868 11.0724C5.58757 11.0626 4.95647 11.0651 4.32413 11.0712C4.13627 11.0737 4.05646 11.0184 4.06137 10.817C4.07242 10.3001 4.07242 9.78442 4.06137 9.2675C4.05769 9.07105 4.12768 9.00475 4.31922 9.01212C4.63968 9.02317 4.96138 9.0158 5.28307 9.0158C5.59248 9.0158 5.90313 9.02439 6.21254 9.01212C6.41391 9.00475 6.50231 9.06123 6.4974 9.27978C6.48512 9.78442 6.48635 10.2903 6.49863 10.7949ZM6.8989 4.32792C6.89645 4.15234 6.95784 4.08113 7.1371 4.08358C7.79031 4.08972 8.44229 4.08972 9.0955 4.08358C9.27967 4.08236 9.36685 4.13884 9.36317 4.33897C9.35457 4.86572 9.35703 5.39246 9.36194 5.9192C9.36317 6.08127 9.30055 6.14389 9.13847 6.14021C8.79468 6.13407 8.45089 6.13775 8.10832 6.13775C7.7989 6.13775 7.48949 6.12916 7.1813 6.14144C6.98117 6.1488 6.89276 6.09232 6.8989 5.87377C6.90995 5.35931 6.90627 4.84361 6.8989 4.32792ZM9.36071 10.849C9.36194 11.0147 9.28336 11.0687 9.12988 11.0687C8.45457 11.0663 7.77803 11.0663 7.10272 11.0687C6.95784 11.0687 6.8989 11.0061 6.90013 10.8612C6.90381 10.3112 6.90504 9.76232 6.90013 9.21225C6.8989 9.02931 7.00572 9.01334 7.14447 9.01457C7.47598 9.01703 7.80873 9.0158 8.14024 9.0158C8.47176 9.0158 8.8045 9.02071 9.13602 9.01457C9.29686 9.01089 9.36194 9.07228 9.35948 9.23558C9.3558 9.77215 9.3558 10.3112 9.36071 10.849ZM9.07708 8.60939C8.75662 8.59711 8.43615 8.6057 8.11569 8.6057C7.78417 8.6057 7.45143 8.59956 7.11991 8.60693C6.95784 8.61061 6.89645 8.54799 6.8989 8.38592C6.90381 7.84813 6.90627 7.31033 6.89767 6.77254C6.89522 6.58468 6.97871 6.54171 7.14692 6.54294C7.7989 6.54908 8.45089 6.55031 9.10287 6.54171C9.29686 6.53925 9.36562 6.60556 9.36194 6.79833C9.35334 7.31279 9.35089 7.82848 9.36317 8.34295C9.36931 8.56641 9.27476 8.61675 9.07708 8.60939ZM2.48115 2.86434C2.89739 2.8361 3.22031 2.50459 3.24118 2.07239C3.251 1.85506 3.24241 1.63651 3.24241 1.41918C3.24241 1.2129 3.24977 1.00663 3.24118 0.800352C3.22153 0.363242 2.90598 0.0341825 2.48852 0.00225879C2.07474 -0.0284371 1.70025 0.256421 1.64376 0.692302C1.57992 1.18098 1.58237 1.67825 1.64254 2.16693C1.69533 2.60281 2.0686 2.89136 2.48115 2.86434ZM8.10464 2.86557C8.55157 2.88276 8.91255 2.53406 8.94448 2.04169C8.95675 1.8477 8.94693 1.65247 8.94693 1.45724H8.9457C8.9457 1.23992 8.95921 1.02013 8.94325 0.804035C8.90764 0.332546 8.5528 -0.00510823 8.11814 0.00103095C7.68226 0.00717013 7.33233 0.35342 7.31514 0.824908C7.3004 1.22518 7.30163 1.62791 7.31514 2.02819C7.32987 2.50459 7.66384 2.84838 8.10464 2.86557Z" fill="white"/>
                                                                </svg>
                                                            </span>
                                                            <span class="htmega-masonry-post-meta-comment">
                                                                <?php the_time('d F Y') ?>
                                                            </span>
                                                        </div>
                                                        <?php 
                                                    endif; ?>
                                                </div>
                                                <?php 
                                            }?>
                                                <?php
                                            if( $settings['show_content'] == 'yes' ) {
                                                echo ' <p class="htmega-masonry-post-description">'. wp_kses_post( wp_trim_words( strip_shortcodes( get_the_content() ), $settings['content_length'], '' ) ) . '</p>';
                                            } 
                                            ?>
                                                <?php
                                            if( $settings['show_read_more_btn'] == 'yes' && '4' != $masonry_style ): ?>
                                                <a class="htmega-masonry-post-read-more" href="<?php the_permalink();?>">
                                                    <span class="htmega-masonry-post-read-more-text">
                                                        <?php echo htmega_kses_desc( $settings['read_more_txt'] );?>
                                                    </span>
                                                    <?php echo $icon_imgprint; ?>
                                                </a>
                                                <?php
                                            endif; ?>
                                        </div>
                                        <?php 
                                    } ?>
                                    <?php
                                    if ( has_post_thumbnail() && '4' == $masonry_style){ ?>
                                        <a href="<?php the_permalink();?>" class="htmega-masonry-post-card-image"><?php the_post_thumbnail( $htmega_image );?></a>
                                        <?php 
                                    } ?>
                                        <?php
                                    if( $settings['show_read_more_btn'] == 'yes' && '4' == $masonry_style ): ?>
                                        <a class="htmega-masonry-post-read-more" href="<?php the_permalink();?>">
                                            <span class="htmega-masonry-post-read-more-text">
                                                <?php echo htmega_kses_desc( $settings['read_more_txt'] ); ?>
                                            </span>
                                            <?php echo $icon_imgprint; ?>
                                        </a>
                                        <?php
                                    endif; ?>
                                </div>

                            </div>
                            <?php 
                        endwhile;

                    else:
                        echo "<div class='htmega-error-notice'>".esc_html__('There are no posts in this query','htmega-pro')."</div>";
                            
                    endif;
                }
                ?>
            <!-- masonry section End -->

            </div>
            <?php
            if( 'yes' == $settings['show_pagination'] ){ ?>
                <div class="htmega-custom-pagination paginat-active-<?php echo esc_attr($sectionid)?>"></div>
                <?php 
            } ?>
        </div>
    
        <?php
    
            ?>
        <script>
            jQuery(document).ready(function($) {            
                var postLoadingInterval = '';
                let currentDevice = elementorFrontend.getCurrentDeviceMode();
                $(".htmega-post-masonry-widget-wrapper").addClass('htmega-'+currentDevice );

                let masonry_active_container = $(".htmega-masonry-post-grid-<?php echo esc_attr($sectionid)?>");
                let masonryContainerHeight ='';
                <?php
                if( 'yes' == $settings['show_pagination'] ){

                    ?>
                    //$(masonry_active_container).css('opacity','0');   
                    // This is required for AJAX to work on our page
                    function htmega_load_all_posts(page){
                        masonryContainerHeight = masonry_active_container.outerHeight();
                        
                        $("#<?php echo esc_js($sectionid);?>").fadeIn().css('display','block');

                        clearInterval(postLoadingInterval);
                        $(masonry_active_container).css('opacity','0');

                        var data = {
                            page: page,
                            settings: <?php echo $display_options_json ?>,
                            args: <?php echo $args_json ?>,
                            action: "htmega-ajax-posts-load",
                            security: '<?php echo esc_js( wp_create_nonce( "htmega-ajax-post-request" ) ); ?>',
                        };
                        var itemHTML = '<div class="htmega-masonry-sizer htmega-masonry-flex-column"></div>';
                        $.ajax({
                            url:"<?php echo site_url() .'/wp-admin/admin-ajax.php'; ?>",

                            data: data,// form data
                            method : 'POST',
                            success:function(data){
                                var obj = JSON.parse(data);
                                for(const item in obj){
                                    if(item != 'pagination'){
                                        itemHTML += obj[item];
                                        }
                                }

                                $(".paginat-active-<?php echo esc_attr($sectionid); ?>").html(obj['pagination']);

                                var $moreBlocks = $( itemHTML );
                                
                                // Have Masonry position new blocks
                                $(masonry_active_container).html( itemHTML );
                                if($(masonry_active_container).masonry()){

                                    $(masonry_active_container).masonry('destroy'); // destroy existing masonry

                                    $(masonry_active_container).imagesLoaded(function() {
                                            $(masonry_active_container).masonry({
                                                // options
                                                itemSelector: '.htmega-masonry-post-item',
                                                columnWidth: '.htmega-masonry-sizer'
                                            });
                                            
                                    });
                                } else{
                                    $(masonry_active_container).imagesLoaded(function() {
                                            $(masonry_active_container).masonry({
                                                // options
                                                itemSelector: '.htmega-masonry-post-item',
                                                columnWidth: '.htmega-masonry-sizer'
                                            });
                                            
                                    });
                                }
                                pagination_load();
                               
                                postLoadingInterval = setInterval(function(){
                                    $("#<?php echo esc_js($sectionid);?>").fadeIn().css('display','none');
                                    $(masonry_active_container).fadeIn().css('opacity','1');
                                    //alert('ddd');
                                }, 50);
                                $(masonry_active_container).fadeIn().css('height',masonryContainerHeight);                         
          
                            }
                        });
                    }
                    // Load page 1 as the default
                    htmega_load_all_posts(1);
                    
                    // Handle the clicks
                    function pagination_load(){
                        $(".paginat-active-<?php echo esc_attr($sectionid); ?> li.active").on('click',function(){
                            var page = $(this).attr('p');
                            htmega_load_all_posts(page);
                        });
                    }
                    pagination_load();     
                   
                    <?php 
                }else { ?>
                   
                    if( $(masonry_active_container).masonry() ){
                        masonryContainerHeight = masonry_active_container.outerHeight();
                        $(masonry_active_container).masonry('destroy');
                        $(masonry_active_container).imagesLoaded(function() {
                            $(masonry_active_container).masonry({
                                // options
                                itemSelector: '.htmega-masonry-post-item',
                                columnWidth: '.htmega-masonry-sizer'
                                });
                               
                            $("#<?php echo esc_js($sectionid);?>").fadeIn().css('display','none');
                            $(masonry_active_container).fadeIn().css('opacity','1');
                        });
                        $(masonry_active_container).fadeIn().css('height',masonryContainerHeight); 
                    }else{

                        $(masonry_active_container).imagesLoaded(function() {
                            $(masonry_active_container).masonry({
                                // options
                                itemSelector: '.htmega-masonry-post-item',
                                columnWidth: '.htmega-masonry-sizer'
                                });
                               
                            $("#<?php echo esc_js($sectionid);?>").fadeIn().css('display','none');
                            $(masonry_active_container).fadeIn().css('opacity','1');
                        });

                    }
                    <?php
                } ?>
            }); 
        </script>
        <?php
    }

    public function show_post_source(){

        $this->add_control(
            'post_type',
            [
                'label' => esc_html__( 'Post Type', 'htmega-pro' ),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => htmega_get_post_types(),
                'default' =>'post',
                'frontend_available' => true,
                'separator' => 'before'
            ]
        );
        $this->add_control(
            'include_by',
            [
                'label' => __( 'Include By', 'htmega-pro' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => [
                    'in_author'      => __( 'Author', 'htmega-pro' ),
                    'in_category'      => __( 'Category', 'htmega-pro' ),
                ],
            ]
        );
        $this->add_control(
            'post_author',
            [
                'label' => esc_html__( 'Authors', 'htmega-pro' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => htmega_get_authors_list(),
                'condition' =>[
                    'include_by' => 'in_author',
                ]
            ]
        );
        $texnomy_list = htmega_get_post_types();
        foreach( $texnomy_list as $texnomykey => $texnomyValue ){
            
            $this->add_control(
                "{$texnomykey}_post_category",
                [
                    'label' => esc_html__( 'Select Categories', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => all_object_taxonomie_show_catagory($texnomykey),
                    'condition' => [
						'post_type' => $texnomykey,
						'include_by' => 'in_category',
					],
                ]
            );
        }
        $this->add_control(
            "exclude_posts",
            [
                'label' => esc_html__( 'Exclude Posts', 'htmega-pro' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => esc_html__( 'Example: 10,11,105', 'htmega-pro' ),
                'description' => esc_html__( "To Exclude Post, Enter  the post id separated by ','", 'htmega-pro' ),
            ]
        );
        $this->add_control(
            'post_limit',
            [
                'label' => __('Limit', 'htmega-pro'),
                'type' => Controls_Manager::NUMBER,
                'default' => 10,
                'separator'=>'before',
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label' => esc_html__( 'Order By', 'htmega-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'ID'            => esc_html__('ID','htmega-pro'),
                    'date'          => esc_html__('Date','htmega-pro'),
                    'name'          => esc_html__('Name','htmega-pro'),
                    'title'         => esc_html__('Title','htmega-pro'),
                    'comment_count' => esc_html__('Comment count','htmega-pro'),
                    'rand'          => esc_html__('Random','htmega-pro'),
                ],
            ]
        );
        $this->add_control(
            'custom_order_by_date',
            [
                'label' => esc_html__( 'Custom Date', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
                'condition' =>[
                    'orderby'=>'date'
                ]
            ]
        );
        $this->add_control(
            'order_by_date_before',
            [
                'label' => __( 'Before Date', 'htmega-pro' ),
                'type' => Controls_Manager::DATE_TIME,
                'condition' =>[
                    'orderby'=>'date',
                    'custom_order_by_date'=>'yes',
                ]
            ]
        );
        $this->add_control(
            'order_by_date_after',
            [
                'label' => __( 'After Date', 'htmega-pro' ),
                'type' => Controls_Manager::DATE_TIME,
                'condition' =>[
                    'orderby'=>'date',
                    'custom_order_by_date'=>'yes',
                ]
            ]
        );
        $this->add_control(
            'postorder',
            [
                'label' => esc_html__( 'Order', 'htmega-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'DESC'  => esc_html__('Descending','htmega-pro'),
                    'ASC'   => esc_html__('Ascending','htmega-pro'),
                ],

            ]
        );
        $this->add_control(
            'hide_empty_thumbnail_post',
            [
                'label'         => esc_html__( 'Hide Empty Thumbnail', 'htmega-pro' ),
                'type'          => Controls_Manager::SWITCHER,
                'return_value'  => 'yes',
                'default'       => 'no',
                'separator'     =>'after',
            ]
        );
    }


}
