<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\HTMega_Icon_manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Post_Timeline_Element extends Widget_Base {
    public function get_name() {
        return 'htmega-post-timeline-addons';
    }
    
    public function get_title() {
        return __( 'Post Timeline', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-time-line';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }

    public function get_script_depends() {
        return [ 'htmega-post-timeline-active','slick' ];
    }

    public function get_style_depends() {
        return ['slick' ];
    }

    public function get_keywords() {
        return [ 'post timeline', 'timeline',' vertical timeline','horizontal timeline','htmega addons','htmega pro' ];
    }
    
    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/post-widgets/post-timeline-widget/';
	}

    protected function register_controls() {

        // Content
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Post Timeline', 'htmega-pro' ),
            ]
        );
            
            $this->add_control(
                'timeline_layout',
                [
                    'label' => __( 'Layout', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'horizontal',
                    'options' => [
                        'horizontal'      => __( 'Horizontal', 'htmega-pro' ),
                        'vertical'      => __( 'Vertical', 'htmega-pro' ),
                    ],
                ]
            );
            $this->add_control(
                'card_style',
                [
                    'label' => esc_html__( 'Timeline Style', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => '1',
                    'options' => [
                        '1'  => esc_html__('Style One','htmega-pro'),
                        '2'   => esc_html__('Style Two','htmega-pro'),
                    ],
                    'condition' =>[
                        'timeline_layout' =>'horizontal'
                    ]
    
                ]
            );
            $this->add_control(
                'timeline_style',
                [
                    'label' => esc_html__( 'Timeline Style', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => '3',
                    'options' => [
                        '3'  => esc_html__('Style One','htmega-pro'),
                        '4'   => esc_html__('Style Two','htmega-pro'),
                    ],
                    'condition' =>[
                        'timeline_layout' =>'vertical'
                    ]
    
                ]
            );
            $this->show_post_source();

            $this->add_control(
                'post_limit',
                [
                    'label' => __('Limit', 'htmega-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 10,
                    'separator'=>'before',
                ]
            );

            $this->add_control(
                'orderby',
                [
                    'label' => esc_html__( 'Order By', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'date',
                    'options' => [
                        'ID'            => esc_html__('ID','htmega-pro'),
                        'date'          => esc_html__('Date','htmega-pro'),
                        'name'          => esc_html__('Name','htmega-pro'),
                        'title'         => esc_html__('Title','htmega-pro'),
                        'comment_count' => esc_html__('Comment count','htmega-pro'),
                        'rand'          => esc_html__('Random','htmega-pro'),
                    ],
                ]
            );
            $this->add_control(
                'custom_order_by_date',
                [
                    'label' => esc_html__( 'Custom Date', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' =>[
                        'orderby'=>'date'
                    ]
                ]
            );
            $this->add_control(
                'order_by_date_before',
                [
                    'label' => __( 'Before Date', 'htmega-pro' ),
                    'type' => Controls_Manager::DATE_TIME,
                    'condition' =>[
                        'orderby'=>'date',
                        'custom_order_by_date'=>'yes',
                    ]
                ]
            );
            $this->add_control(
                'order_by_date_after',
                [
                    'label' => __( 'After Date', 'htmega-pro' ),
                    'type' => Controls_Manager::DATE_TIME,
                    'condition' =>[
                        'orderby'=>'date',
                        'custom_order_by_date'=>'yes',
                    ]
                ]
            );
            $this->add_control(
                'postorder',
                [
                    'label' => esc_html__( 'Order', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'DESC',
                    'options' => [
                        'DESC'  => esc_html__('Descending','htmega-pro'),
                        'ASC'   => esc_html__('Ascending','htmega-pro'),
                    ],

                ]
            );
            $this->add_control(
                'hide_empty_thumbnail_post',
                [
                    'label'         => esc_html__( 'Hide Empty Thumbnail', 'htmega-pro' ),
                    'type'          => Controls_Manager::SWITCHER,
                    'return_value'  => 'yes',
                    'default'       => 'no',
                ]
            );

        $this->end_controls_section();
        // Display Options
        $this->start_controls_section(
            'display_option_section',
            [
                'label' => __( 'Display Options', 'htmega-pro' ),
            ]
        );

        $this->add_control(
            'show_category',
            [
                'label' => esc_html__( 'Category', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_date',
            [
                'label' => esc_html__( 'Date', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

         $this->add_control(
            'show_title',
            [
                'label' => esc_html__( 'Title', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'title_length',
            [
                'label' => __( 'Title Length', 'htmega-pro' ),
                'type' => Controls_Manager::NUMBER,
                'step' => 1,
                'default' => 5,
                'condition'=>[
                    'show_title'=>'yes',
                ]
            ]
        );

        $this->add_control(
            'show_content',
            [
                'label' => esc_html__( 'Content', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'content_length',
            [
                'label' => __( 'Content Length', 'htmega-pro' ),
                'type' => Controls_Manager::NUMBER,
                'step' => 1,
                'default' => 20,
                'condition'=>[
                    'show_content'=>'yes',
                ]
            ]
        );

        $this->add_control(
            'show_read_more_btn',
            [
                'label' => esc_html__( 'Read More', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'read_more_txt',
            [
                'label' => __( 'Read More Button Text', 'htmega-pro' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Read More', 'htmega-pro' ),
                'placeholder' => __( 'Read More', 'htmega-pro' ),
                'label_block'=>true,
                'condition'=>[
                    'show_read_more_btn'=>'yes',
                ]
            ]
        );

        $this->add_control(
            'show_author',
            [
                'label' => esc_html__( 'Author', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                        'terms' => [
                            ['name' => 'timeline_style', 'operator' => '===', 'value' => '4'],
                            ['name' => 'timeline_layout', 'operator' => '==', 'value' => 'vertical'],
                            ]
                        ],
                        [
                        'terms' => [
                                ['name' => 'card_style', 'operator' => '===', 'value' => '2'],
                                ['name' => 'timeline_layout', 'operator' => '==', 'value' => 'horizontal'],
                            ]
                        ],
                    ]
                ],
            ]
        );
        $this->add_control(
            'show_comment',
            [
                'label' => esc_html__( 'Comments', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
                'condition'=>[
                    'card_style'=>'2',
                    'timeline_layout' =>'horizontal'
                ]
            ]
        );
        $this->add_control(
            'show_load_more_btn',
            [
                'label' => esc_html__( 'Show Load More Button', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
                'condition' =>[
                    'timeline_layout' =>'vertical'
                ]
            ]
        );

        $this->add_control(
            'show_load_txt',
            [
                'label' => __( 'Button Text', 'htmega-pro' ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Load More', 'htmega-pro' ),
                'placeholder' => __( 'Load More', 'htmega-pro' ),
                'label_block'=>true,
                'condition' =>[
                    'timeline_layout' =>'vertical',
                    'show_load_more_btn' =>'yes'
                ]
            ]
        );
        $this->add_control(
            'show_load_initial_items',
            [
                'label' => __('Initial Items', 'htmega-pro'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'step' => 1,
                'default' => 4,
                'condition' =>[
                    'timeline_layout' =>'vertical',
                    'show_load_more_btn' =>'yes'
                ]
            ]
        );
        $this->add_control(
            'show_load_items',
            [
                'label' => __('Load More Items', 'htmega-pro'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'step' => 4,
                'default' => 4,
                'condition' =>[
                    'timeline_layout' =>'vertical',
                    'show_load_more_btn' =>'yes'
                ]
            ]
        );

        $this->end_controls_section();

        // Display Options
        $this->start_controls_section(
            'carousel_settings',
            [
                'label' => __( 'Carousel Settings', 'htmega-pro' ),
                'condition' =>[
                    'timeline_layout' => 'horizontal'
                ]
            ]
        );
            $this->add_responsive_control(
                'slitems',
                [
                    'label' => esc_html__( 'Items', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 1,
                    'max' => 10,
                    'step' => 1,
                    'default' => 3,
                    'condition' =>[
                        'timeline_layout' =>'horizontal'
                    ],
                    'separator' =>'before'
                ]
            );
            $this->add_responsive_control(
                'slscroll_columns',
                [
                    'label' => __('Item to Scroll', 'htmega-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 1,
                    'max' => 10,
                    'step' => 1,
                    'default' => 1,
                    'condition' =>[
                        'timeline_layout' =>'horizontal'
                    ]
                ]
            );
            $this->add_responsive_control(
                'gird_gutter',
                [
                    'label' => __('Column Gap', 'htmega-pro'),
                    'description' => __('This Column gap value shows in multiplying 2', 'htmega-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 10,
                    'selectors' => [
                        '{{WRAPPER}} .slick-slide' => 'padding-left: {{SIZE}}px; padding-right: {{SIZE}}px;',
                        '{{WRAPPER}} .slick-list' => 'margin-left: -{{SIZE}}px;margin-right: -{{SIZE}}px;',
                    ],
                ]
            );
            $this->add_control(
                'equal_height_column',
                [
                    'label' => esc_html__( 'Equal Height Column', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'separator' => 'before',
                    'default' => 'no',
                    'condition' => [
                        'timeline_layout' =>'horizontal'
                    ]
                ]
            );    
            $this->add_control(
                'slider_resolution_toggle',
                [
                    'type' =>Controls_Manager::POPOVER_TOGGLE,
                    'label' => esc_html__( 'Responsive Breakpoints', 'htmega-pro' ),
                    'label_off' => esc_html__( 'Default', 'htmega-pro' ),
                    'label_on' => esc_html__( 'Custom', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'condition' =>[
                        'timeline_layout' =>'horizontal'
                    ]
                ]
            );
            
            $this->start_popover();
            
                $this->add_control(
                    'tablet_width',
                    [
                        'label' => __('Tablet Breakpoints', 'htmega-pro'),
                        'description' => __('The resolution to tablet device.', 'htmega-pro'),
                        'type' => Controls_Manager::NUMBER,
                        'default' => 991,
                        'separator' => 'after',
                    ]
                );

                $this->add_control(
                    'mobile_width',
                    [
                        'label' => __('Mobile Breakpoints', 'htmega-pro'),
                        'description' => __('The resolution to mobile device.', 'htmega-pro'),
                        'type' => Controls_Manager::NUMBER,
                        'default' => 575,
                    ]
                );
                $this->end_popover();

            $this->add_control(
                'slautolay',
                [
                    'label' => esc_html__( 'Auto Play', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'separator' => 'before',
                    'default' => 'no',
                    'condition' => [
                        'slarrows' => 'yes',
                        'timeline_layout' =>'horizontal'
                    ]
                ]
            );
            $this->add_control(
                'slautoplay_speed',
                [
                    'label' => __('Autoplay Speed', 'htmega-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 3000,
                    'condition' => [
                        'slautolay' => 'yes',
                        'timeline_layout' =>'horizontal'
                    ]
                ]
            );

            $this->add_control(
                'slanimation_speed',
                [
                    'label' => __('Autoplay Animation Speed', 'htmega-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 300,
                    'condition' => [
                        'slautolay' => 'yes',
                        'timeline_layout' =>'horizontal'
                    ]
                ]
            );
            $this->add_control(
                'slloop',
                [
                    'label' => esc_html__( 'Repeat', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' => [
                        'slarrows' => 'yes',
                        'timeline_layout' =>'horizontal'
                    ]
                ]
            );
            $this->add_control(
                'slarrows',
                [
                    'label' => esc_html__( 'Arrow', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'condition' =>[
                        'timeline_layout' =>'horizontal'
                    ]
                ]
            );
            $this->add_control(
                'slprevicon',
                [
                    'label' => __( 'Prev Icon', 'htmega-pro' ),
                    'type' => Controls_Manager::ICONS,
                    'default' => [
                        'value'=>'fas fa-angle-left',
                        'library'=>'fa-solid',
                    ],
                    'condition' => [
                        'slarrows' => 'yes',
                        'timeline_layout' =>'horizontal'
                    ],
                    'separator' =>'before'
                ]
            );

            $this->add_control(
                'slnexticon',
                [
                    'label' => __( 'Next Icon', 'htmega-pro' ),
                    'type' => Controls_Manager::ICONS,
                    'default' => [
                        'value'=>'fas fa-angle-right',
                        'library'=>'fa-solid',
                    ],
                    'condition' => [
                        'slarrows' => 'yes',
                        'timeline_layout' =>'horizontal'
                    ]
                ]
            );

            $this->add_control(
                'sldots',
                [
                    'label' => esc_html__( 'Dots', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' => [
                        'timeline_layout' =>'horizontal'
                    ],
                ]
            );
        $this->end_controls_section();

        // Style
        $this->start_controls_section(
            'item_style_section',
            array(
                'label' => __( 'Item Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            )
            );

            $this->add_responsive_control(
                'box_content_alignment',
                [
                    'label' => esc_html__( 'Alignment', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__( 'Left', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-post-timeline-card-inner' => 'text-align: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'box_normal_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-post-timeline-card-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                    ],
                ]
            );

            $this->add_responsive_control(
                'box_background_color',
                [
                    'label' => __( 'Background Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-post-timeline-card.htmega-post-timeline-card-4:nth-child(2n) .htmega-post-timeline-card-inner::after' => 'border-right-color: {{VALUE}}',
                        '{{WRAPPER}} .htmega-post-timeline-card-1 .htmega-post-timeline-card-inner::after' => 'border-bottom-color: {{VALUE}}',
                        '{{WRAPPER}} .htmega-post-timeline-card-inner' => 'background-color: {{VALUE}}',

                        '{{WRAPPER}} .htmega-post-timeline-card.htmega-post-timeline-card-4 .htmega-post-timeline-card-inner::after' => 'border-left-color: {{VALUE}}',
                        '{{WRAPPER}} .htmega-post-timeline-card.htmega-post-timeline-card-3 .htmega-post-timeline-card-inner::after' => 'border-left-color: {{VALUE}}',
                        '{{WRAPPER}} .htmega-post-timeline-card.htmega-post-timeline-card-3:nth-child(2n) .htmega-post-timeline-card-inner::after' => 'border-right-color: {{VALUE}}',

                        '{{WRAPPER}} .htmega-mobile .htmega-post-timeline-card.htmega-post-timeline-card-3 .htmega-post-timeline-card-inner::after' => 'border-left-color:transparent!important; border-right-color:{{VALUE}}!important',
                    ],
                ]
            );
            $this->add_control(
                'item_overlay_color_heading',
                [
                    'label' => __( 'Image Overlay Color', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'timeline_layout' =>'vertical',
                        'timeline_style' =>'4',
                    ]
                ]
            );
    
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'box_background_overlay_color',
                    'label' => __( 'Background', 'htmega-pro' ),
                    'types' => [ 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-post-timeline-card.htmega-post-timeline-card-4 .htmega-post-timeline-image::before',
                    'condition' => [
                        'timeline_layout' =>'vertical',
                        'timeline_style' =>'4',
                    ]
                ]
            );
            $this->add_control(
                'item_overlay_color_hover_heading',
                [
                    'label' => __( 'Image Overlay Hover Color', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'timeline_layout' =>'vertical',
                        'timeline_style' =>'4',
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'box_background_overlay_hover_color',
                    'label' => __( 'Background', 'htmega-pro' ),
                    'types' => ['gradient' ],
                    
                    'selector' => '{{WRAPPER}} .htmega-post-timeline-card.htmega-post-timeline-card-4:hover .htmega-post-timeline-image::before',
                    'condition' => [
                        'timeline_layout' =>'vertical',
                        'timeline_style' =>'4',
                    ],
                ]
            );

            $this->add_responsive_control(
                'box_border_radius',
                [
                    'label' => __( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-post-timeline-card-inner' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                    
                ]
            );
            $this->add_responsive_control(
                'content_box_spacing',
                [
                    'label' => esc_html__( 'Content Box Spacing', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                    ],
                ]
            );
        $this->end_controls_section();
 
        // Timeline Style
        $this->start_controls_section(
            'timeline_style_section',
            [
                'label' => __( 'Timeline Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
            );

            $this->add_control(
                'line_color',
                [
                    'label' => __( 'Line Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-post-timeline-wrap-1 .slick-list::after,{{WRAPPER}} .htmega-post-timeline-wrap-2 .slick-list::after,{{WRAPPER}} .htmega-post-timeline-wrap-3::after,{{WRAPPER}} .htmega-post-timeline-wrappper .htmega-post-timeline-year-wrap:not(:first-child) .htmega-post-timeline-year-text::before,{{WRAPPER}} .htmega-post-timeline-wrap-4::after,{{WRAPPER}} .htmega-post-timeline-wrappper .htmega-post-timeline-year-wrap:not(:first-child) .htmega-post-timeline-year-text::before,{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-bullet::before' => 'background-color: {{VALUE}}',
                        '{{WRAPPER}} .htmega-post-timeline-year-text::after' => 'border-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'line_dot_color',
                [
                    'label' => __( 'Line Dot Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-bullet::before' => 'border-color: {{VALUE}}',
                        '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-bullet::before' => 'border-color: {{VALUE}}',
                        '{{WRAPPER}} .htmega-post-timeline-card.htmega-post-timeline-card-2 .htmega-post-timeline-bullet .htmega-post-timeline-inner-image svg path' => 'fill: {{VALUE}}',
                        '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-bullet::after' => 'background-color: {{VALUE}}',
                        
                    ],
                ]
            );
            $this->add_control(
                'year_color',
                [
                    'label' => __( 'Year Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-post-timeline-year-text' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'timeline_layout' =>'vertical',
                        'timeline_style' =>'3',
                    ],
                    'separator' =>'before'
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'year_background',
                    'label' => __( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-post-timeline-year-text',
                    'condition' => [
                        'timeline_layout' =>'vertical',
                        'timeline_style' =>'3',
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'year_typography',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-post-timeline-year-text',
                    'condition' => [
                        'timeline_layout' =>'vertical',
                        'timeline_style' =>'3',
                    ]
                ]
            );

        $this->end_controls_section();
       // Date Style
       $this->start_controls_section(
        'date_style',
        [
            'label' => __( 'Date Style', 'htmega-pro' ),
            'tab' => Controls_Manager::TAB_STYLE,
            'condition' => [
                'show_date' =>'yes',
                'timeline_style!' =>'4',

            ]
        ]
    );

        $this->add_control(
            'date_color',
            [
                'label' => __( 'Color', 'htmega-pro' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-card-date' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'date_background',
                'label' => __( 'Background', 'htmega-pro' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-card-date',
                'condition' =>[
                    'timeline_layout' =>'vertical',
                    'timeline_style' =>'3',
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'date_typography',
                'label' => __( 'Typography', 'htmega-pro' ),
                'selector' => '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-card-date',
            ]
        );
        $this->add_responsive_control(
            'date_padding',
            [
                'label' => __( 'Padding', 'htmega-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-card-date' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' =>[
                    'timeline_layout' =>'vertical',
                    'timeline_style' =>'3',
                ]
            ]
        );
        $this->add_responsive_control(
            'date_border_radius',
            [
                'label' => __( 'Border Radius', 'htmega-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-card-date' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' =>[
                    'timeline_layout' =>'vertical',
                    'timeline_style' =>'3',
                ]
            ]
        );
    $this->end_controls_section();
        // Title Style
        $this->start_controls_section(
            'title_style',
            [
                'label' => __( 'Title Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_title' =>'yes',
                ]
            ]
        );

            $this->add_control(
                'title_color',
                [
                    'label' => __( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-title a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'title_color_hover',
                [
                    'label' => __( 'Hover Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-title a:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-title',
                ]
            );

            $this->add_responsive_control(
                'title_margin',
                [
                    'label' => __( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();
        // Style Content tab section
        $this->start_controls_section(
            'content_style_section',
            [
                'label' => __( 'Content', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition'=>[
                    'show_content'=>'yes',
                ]
            ]
        );
            $this->add_control(
                'content_color',
                [
                    'label' => __( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-des' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-des',
                ]
            );

            $this->add_responsive_control(
                'content_margin',
                [
                    'label' => __( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-des' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
        $this->end_controls_section();

        //style thumbnail opacity section
        $this->start_controls_section(
            'post_thumbnail_opacity_section',
            [
                'label' => __( 'Thumbnail', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'htmega_image',
                'label' => esc_html__( 'Image Size', 'htmega-pro' ),
                'exclude'      => ['custom'],
                'default'      => 'medium',
                'separator' => 'none',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'image_border',
                'label' => __( 'Border', 'htmega-pro' ),
                'selector' => '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-image img',
            ]
        );

        $this->add_responsive_control(
            'image_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-image img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );


        $this->end_controls_section();

        // Style Category tab section
        $this->start_controls_section(
            'category_style_section',
            [
                'label' => __( 'Category', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition'=>[
                    'show_category'=>'yes',
                ]
            ]
        );
            
            $this->start_controls_tabs('category_style_tabs');

                $this->start_controls_tab(
                    'category_style_normal_tab',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                );

                    $this->add_control(
                        'category_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default'=>'#ffffff',
                            'selectors' => [
                                '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-category' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'category_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-category',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'category_typography',
                            'label' => __( 'Typography', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-category',
                        ]
                    );
                    $this->add_responsive_control(
                        'category_padding',
                        [
                            'label' => __( 'Padding', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-category' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );

                    $this->add_responsive_control(
                        'category_margin',
                        [
                            'label' => __( 'Margin', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-categorys' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'category_border_radius',
                        [
                            'label' => __( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-category' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                $this->end_controls_tab(); // Normal Tab end

                $this->start_controls_tab(
                    'category_style_hover_tab',
                    [
                        'label' => __( 'Hover', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'category_hover_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default'=>'#ffffff',
                            'selectors' => [
                                '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-category:hover' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'category_hover_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-category:hover',
                        ]
                    );

                $this->end_controls_tab(); // Hover Tab end

            $this->end_controls_tabs();

        $this->end_controls_section();

        // Style Meta tab section
        $this->start_controls_section(
            'post_meta_style_section',
            [
                'label' => __( 'Meta', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                        'terms' => [
                            ['name' => 'card_style', 'operator' => '===', 'value' => '2'],
                            ['name' => 'timeline_layout', 'operator' => '==', 'value' => 'horizontal'],
                            ]
                        ],
                        [
                        'terms' => [
                                ['name' => 'timeline_style', 'operator' => '===', 'value' => '4'],
                                ['name' => 'timeline_layout', 'operator' => '==', 'value' => 'vertical'],
                            ]
                        ],
                    ]
                ],
            ]
        );
            $this->add_control(
                'meta_color',
                [
                    'label' => __( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-meta-item,{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-meta-item .htmega-post-timeline-meta-name, {{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-meta-item-link' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-meta-item svg path' => 'fill: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'meta_color_hover',
                [
                    'label' => __( 'Meta Hover Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .post-carousel-wrapper .htmega-single-post-slide .content .post-inner ul.meta li a:hover,{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-meta-item-link:hover,{{WRAPPER}} .htmega-post-timeline-card.htmega-post-timeline-card-2 .htmega-post-timeline-meta-item:hover .htmega-post-timeline-meta-name' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'meta_typography',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-post-timeline-card.htmega-post-timeline-card-2 .htmega-post-timeline-meta-item .htmega-post-timeline-meta-name,{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-meta-item,{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-meta-item-link',
                ]
            );
            $this->add_responsive_control(
                'meta_icon_font_size',
                [
                    'label' => __( 'Icon Size', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px'],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-meta-item svg' => 'width: {{SIZE}}px;',
                    ],
                ]
            );
            $this->add_control(
                'meta_separator_color',
                [
                    'label' => __( 'Separator Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-post-timeline-card.htmega-post-timeline-card-2 .htmega-post-timeline-meta-item:not(:last-child)::after' => 'background: {{VALUE}}',
                    ],
                    'condition' =>[
                        'timeline_layout' =>'horizontal',
                        'card_style' =>'2',
                        'show_comment' =>'yes',
                    ]
                ]
            );
            $this->add_responsive_control(
                'meta_margin',
                [
                    'label' => __( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-meta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();

        // Style Read More button tab section
        $this->start_controls_section(
            'readmore_style_section',
            [
                'label' => __( 'Read More', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition'=>[
                    'show_read_more_btn'=>'yes',
                    'read_more_txt!'=>'',
                ]
            ]
            );
            $this->start_controls_tabs('readmore_style_tabs');

                $this->start_controls_tab(
                    'readmore_style_normal_tab',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                );

                    $this->add_control(
                        'readmore_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-button' => 'color: {{VALUE}}; border-bottom: 1px solid {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'readmore_typography',
                            'label' => __( 'Typography', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-button',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'readmore_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-button',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'readmore_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-button',
                        ]
                    );

                    $this->add_responsive_control(
                        'readmore_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'readmore_padding',
                        [
                            'label' => __( 'Padding', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'readmore_margin',
                        [
                            'label' => __( 'Margin', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                $this->end_controls_tab(); // Normal Tab end

                $this->start_controls_tab(
                    'readmore_style_hover_tab',
                    [
                        'label' => __( 'Hover', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'readmore_hover_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-button:hover' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'readmore_hover_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-button:hover',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'readmore_hover_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-button:hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'readmore_hover_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-post-timeline-card .htmega-post-timeline-button:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab(); // Hover Tab end

            $this->end_controls_tabs();

        $this->end_controls_section();
        // Style Load More button tab section
        $this->start_controls_section(
            'load_more_style_section',
            [
                'label' => __( 'Load More Button', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition'=>[
                    'timeline_layout'=>'vertical',
                    'show_load_more_btn'=>'yes',
                    'show_load_txt!'=>'',
                ]
            ]
        );
            $this->start_controls_tabs('load_more_style_tabs');

                $this->start_controls_tab(
                    'load_more_style_normal_tab',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                );

                    $this->add_control(
                        'load_more_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-timeline-load-more-button.htmega-timeline-load-more-active' => 'color: {{VALUE}}; border-bottom: 1px solid {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'load_more_typography',
                            'label' => __( 'Typography', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-timeline-load-more-button.htmega-timeline-load-more-active',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'load_more_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-timeline-load-more-button.htmega-timeline-load-more-active',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'load_more_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-timeline-load-more-button.htmega-timeline-load-more-active',
                        ]
                    );

                    $this->add_responsive_control(
                        'load_more_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-timeline-load-more-button.htmega-timeline-load-more-active' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'load_more_padding',
                        [
                            'label' => __( 'Padding', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-timeline-load-more-button.htmega-timeline-load-more-active' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'load_more_margin',
                        [
                            'label' => __( 'Margin', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-timeline-load-more-button.htmega-timeline-load-more-active' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                $this->end_controls_tab(); // Normal Tab end

                $this->start_controls_tab(
                    'load_more_style_hover_tab',
                    [
                        'label' => __( 'Hover', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'load_more_hover_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-timeline-load-more-button.htmega-timeline-load-more-active:hover' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'load_more_hover_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-timeline-load-more-button.htmega-timeline-load-more-active:hover',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'load_more_hover_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-timeline-load-more-button.htmega-timeline-load-more-active:hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'load_more_hover_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-timeline-load-more-button.htmega-timeline-load-more-active:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab(); // Hover Tab end

            $this->end_controls_tabs();

        $this->end_controls_section();
       // Style arrow style start
       $this->start_controls_section(
        'htmega_carousel_arrow_style',
        [
            'label'     => __( 'Arrow', 'htmega-pro' ),
            'tab'       => Controls_Manager::TAB_STYLE,
            'condition' =>[
                'timeline_layout' => 'horizontal',
                'slarrows'  => 'yes',
            ],
        ]
    );
        
        $this->start_controls_tabs( 'carousel_arrow_style_tabs' );

            // Normal tab Start
            $this->start_controls_tab(
                'carousel_arrow_style_normal_tab',
                [
                    'label' => __( 'Normal', 'htmega-pro' ),
                ]
            );

                $this->add_responsive_control(
                    'htmega_carousel_arrow_color',
                    [
                        'label' => __( 'Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#ffffff',
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'color: {{VALUE}};',
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow svg path' => 'fill: {{VALUE}};',
                        ],
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_arrow_fontsize',
                    [
                        'label' => __( 'Font Size', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 100,
                                'step' => 1,
                            ],
                            '%' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 20,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'font-size: {{SIZE}}{{UNIT}};',
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow svg' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'carousel_arrow_background',
                        'label' => __( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow',
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'htmega_carousel_arrow_border',
                        'label' => __( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow',
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_arrow_border_radius',
                    [
                        'label' => __( 'Border Radius', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                        ],
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_arrow_height',
                    [
                        'label' => __( 'Height', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 1000,
                                'step' => 1,
                            ],
                            '%' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 30,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'height: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_arrow_width',
                    [
                        'label' => __( 'Width', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 1000,
                                'step' => 1,
                            ],
                            '%' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 30,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_arrow_padding',
                    [
                        'label' => __( 'Padding', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'separator' =>'before',
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_arrow_position',
                    [
                        'label' => __( 'Vertical Position', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 1000,
                                'step' => 1,
                            ],
                            '%' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => '42',
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'top: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_arrow_position_x',
                    [
                        'label' => __( 'Horizontal Position', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                                'step' => 1,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => '',
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .htmega-carosul-next.slick-arrow' => 'right: {{SIZE}}{{UNIT}};',
                            '{{WRAPPER}} .htmega-pro-carousel-activation .htmega-carosul-prev.slick-arrow' => 'left: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );

            $this->end_controls_tab(); // Normal tab end

            // Hover tab Start
            $this->start_controls_tab(
                'carousel_arrow_style_hover_tab',
                [
                    'label' => __( 'Hover', 'htmega-pro' ),
                ]
            );

                $this->add_control(
                    'htmega_carousel_arrow_hover_color',
                    [
                        'label' => __( 'Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'default' => '#ffffff',
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow:hover' => 'color: {{VALUE}};',
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow:hover svg path' => 'fill: {{VALUE}};',
                        ],
                    ]
                );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'carousel_arrow_hover_background',
                        'label' => __( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow:hover',
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'htmega_carousel_arrow_hover_border',
                        'label' => __( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow:hover',
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_arrow_hover_border_radius',
                    [
                        'label' => __( 'Border Radius', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                        ],
                    ]
                );

            $this->end_controls_tab(); // Hover tab end

        $this->end_controls_tabs();

    $this->end_controls_section(); // Style instagram arrow style end


    // Style Dots style start
    $this->start_controls_section(
        'htmega_carousel_dots_style',
        [
            'label'     => __( 'Pagination', 'htmega-pro' ),
            'tab'       => Controls_Manager::TAB_STYLE,
            'condition' =>[
                'timeline_layout' => 'horizontal',
                'sldots'  => 'yes',
            ],
        ]
        );
        
        $this->start_controls_tabs( 'carousel_dots_style_tabs' );

            // Normal tab Start
            $this->start_controls_tab(
                'carousel_dots_style_normal_tab',
                [
                    'label' => __( 'Normal', 'htmega-pro' ),
                ]
            );

                $this->add_responsive_control(
                    'carousel_dots_pagination_align',
                    [
                        'label' => __( 'Alignment', 'htmega-pro' ),
                        'type' => Controls_Manager::CHOOSE,
                        'options' => [
                            'left' => [
                                'title' => __( 'Left', 'htmega-pro' ),
                                'icon' => 'eicon-text-align-left',
                            ],
                            'center' => [
                                'title' => __( 'Center', 'htmega-pro' ),
                                'icon' => 'eicon-text-align-center',
                            ],
                            'right' => [
                                'title' => __( 'Right', 'htmega-pro' ),
                                'icon' => 'eicon-text-align-right',
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots' => 'text-align: {{VALUE}};',
                        ],
                    ]
                );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'carousel_dots_background',
                        'label' => __( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li button',
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'htmega_carousel_dots_border',
                        'label' => __( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li button',
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_dots_border_radius',
                    [
                        'label' => __( 'Border Radius', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                        ],
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_dots_height',
                    [
                        'label' => __( 'Height', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 200,
                                'step' => 1,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 15,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li button,{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li' => 'height: {{SIZE}}px;',
                        ],
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_dots_width',
                    [
                        'label' => __( 'Width', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px'],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 200,
                                'step' => 1,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 15,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li button,{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li' => 'width: {{SIZE}}px !important;',
                        ],
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_dots_position_x',
                    [
                        'label' => __( 'Horizontal Position', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'range' => [
                            'px' => [
                                'min' => -200,
                                'max' => 200,
                                'step' => 1,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => '',
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots' => 'bottom: {{SIZE}}px;',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'htmega_carousel_dots_pagination_inner_space',
                    [
                        'label' => __( 'Inner Gap', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 200,
                                'step' => 1,
                            ],
                            '%' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => '',
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li:not(:last-child)' => 'margin-right: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );

            $this->end_controls_tab(); // Normal tab end

            // Hover tab Start
            $this->start_controls_tab(
                'carousel_dots_style_hover_tab',
                [
                    'label' => __( 'Active', 'htmega-pro' ),
                ]
            );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'carousel_dots_hover_background',
                        'label' => __( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li.slick-active button',
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'htmega_carousel_dots_hover_border',
                        'label' => __( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li.slick-active button',
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_dots_hover_border_radius',
                    [
                        'label' => __( 'Border Radius', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li.slick-active button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                        ],
                    ]
                );

            $this->end_controls_tab(); // Hover tab end

        $this->end_controls_tabs();

    $this->end_controls_section(); // Style dots style end
    }

    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();
        $sectionid =  $this-> get_id();
        $sectionid = 'secid'.$sectionid;
        $htmega_image  = $this->get_settings_for_display('htmega_image_size');
        $post_type = $settings['post_type'];
        $post_categorys = $settings[ $post_type.'_post_category'];
        $post_author = $settings['post_author'];
        $exclude_posts = $settings['exclude_posts'];
        $custom_order_ck    = $this->get_settings_for_display('custom_order');
        $orderby            = $this->get_settings_for_display('orderby');
        $postorder          = $this->get_settings_for_display('postorder');
        $category_name =  get_object_taxonomies($post_type);
        $card_style = $settings['card_style'];
        $slider_settings = [
            'sectionid'=> $sectionid,
            'arrows' => ('yes' === $settings['slarrows']),
            'arrow_prev_txt' => HTMega_Icon_manager::render_icon( $settings['slprevicon'], [ 'aria-hidden' => 'true' ] ),
            'arrow_next_txt' => HTMega_Icon_manager::render_icon( $settings['slnexticon'], [ 'aria-hidden' => 'true' ] ),
            'dots' => ('yes' === $settings['sldots']),
            'autoplay' => ('yes' === $settings['slautolay']),
            'autoplay_speed' => absint($settings['slautoplay_speed']),
            'animation_speed' => absint($settings['slanimation_speed']),
            'loop' => ('yes' === $settings['slloop']),
            'equal_height_column' => ('yes' === $settings['equal_height_column']),
            'equal_height_column_class' => '.htmega-post-timeline-card-inner',
        ];

        $slider_responsive_settings = [
            'display_columns' => $settings['slitems'],
            'scroll_columns' => $settings['slscroll_columns'],
            'tablet_width' =>$settings['tablet_width'],
            'tablet_display_columns' => isset( $settings["slitems_tablet"] ) ? $settings["slitems_tablet"]:$settings['slitems'],
            'tablet_scroll_columns' => isset( $settings["slscroll_columns_tablet"] ) ? $settings["slscroll_columns_tablet"]:$settings['slscroll_columns'],
            'mobile_width' => $settings['mobile_width'],
            'mobile_display_columns' => isset( $settings["slitems_mobile"] )? $settings["slitems_mobile"]:$settings['slitems'],
            'mobile_scroll_columns' => isset( $settings["slscroll_columns_mobile"] ) ? $settings["slscroll_columns_mobile"] : $settings['slscroll_columns'],
        ];
        $slider_settings = array_merge( $slider_settings, $slider_responsive_settings );
        
        // Post query
        $args = array(
            'post_type'             => $post_type,
            'post_status'           => 'publish',
            'ignore_sticky_posts'   => 1,
            'posts_per_page'        => !empty( $settings['post_limit'] ) ? $settings['post_limit'] : 3,
        );

        if (  !empty( $post_categorys ) ) {

            if( $category_name && $category_name['0'] == "product_type" ){

                    $category_name['0'] = 'product_cat';
            }

            if( $category_name &&  is_array($post_categorys) && count($post_categorys) > 0 ){

                $field_name = is_numeric( $post_categorys[0] ) ? 'term_id' : 'slug';
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => $category_name[0],
                        'terms' => $post_categorys,
                        'field' => $field_name,
                        'include_children' => false
                    )
                );
            }
        }
        // author check
        if (  !empty( $post_author ) ) {
            $args['author__in'] = $post_author;
        }
        // order by  check
        if ( !empty( $orderby ) ) {
            if ( 'date' == $orderby && 'yes'== $settings['custom_order_by_date'] && (!empty( $settings['order_by_date_after'] || $settings['order_by_date_before'] ) ) ) {
            $order_by_date_after = strtotime($settings['order_by_date_after']);
            $order_by_date_before = strtotime($settings['order_by_date_before']);
                $args['date_query'] = array(
                    array(
                        'before'    => array(
                            'year'  => gmdate('Y', $order_by_date_before),
                            'month' =>gmdate('m', $order_by_date_before),
                            'day'   => gmdate('d', $order_by_date_before),
                        ),
                        'after'    => array(
                            'year'  => gmdate('Y', $order_by_date_after),
                            'month' =>gmdate('m', $order_by_date_after),
                            'day'   => gmdate('d', $order_by_date_after),
                        ),
                        'inclusive' => true,
                    ),
                );

            } else {
                $args['orderby'] = $orderby;
            }
        }

        // Exclude posts check
        if (  !empty( $exclude_posts ) ) {
            $exclude_posts = explode(',',$exclude_posts);
            $args['post__not_in'] =  $exclude_posts;
        }

        // Order check
        if (  !empty( $postorder ) ) {
            $args['order'] =  $postorder;
        }
        // empty thumbnail post
        if ( 'yes' === $settings['hide_empty_thumbnail_post'] ) {
            $args['meta_query'] = [
                [
                    'key' => '_thumbnail_id',
                    'compare' => 'EXISTS'
                ],
            ];
        }
        $post_query = new \WP_Query( $args );

       $timeline_style =  $settings['timeline_style'];
       $load_more_times_class = ('yes' == $settings['show_load_more_btn']) ? "htmega-timeline-load-more-item-{$sectionid}":'';

        if( 'vertical' == $settings['timeline_layout'] ){

            $this->add_render_attribute( 'htmega_pro_wrapper_attr', 'class', "htmega-post-timeline-wrap-{$timeline_style}" );

            if( '4' == $timeline_style ){
                $this->add_render_attribute( 'htmega_card_classes', 'class', "htmega-post-timeline-card htmega-post-timeline-column  htmega-post-timeline-card-{$timeline_style} {$load_more_times_class}" );
            } else {
                $this->add_render_attribute( 'htmega_card_classes', 'class', "htmega-post-timeline-card htmega-post-timeline-card-{$timeline_style} {$load_more_times_class}" );
            }

        }else{
            $this->add_render_attribute( 'htmega_pro_wrapper_attr', 'class', "htmega-slider-active-1 htmega-post-timeline-wrap-{$card_style} htmega-pro-carousel-activation {$sectionid}" );   
            $this->add_render_attribute( 'htmega_pro_wrapper_attr', 'data-settings', wp_json_encode( $slider_settings ) );  
        }

        $this->add_render_attribute( 'htmega_card_classes', 'class', "htmega-post-timeline-card htmega-post-timeline-card-{$card_style}" );
        $s_display_none = ( $settings['timeline_layout'] == 'horizontal') ? ' style="display:none;"':'';
        ?>
        <?php

        if( 'vertical' == $settings['timeline_layout'] ){ 
            if( '4' == $timeline_style ){ ?>
                <div class="htmega-post-timeline-wrap-4">
                    <?php 
                    if( $post_query->have_posts() ):

                        while( $post_query->have_posts() ): $post_query->the_post();
                        ?>
                            <div <?php echo $this->get_render_attribute_string( 'htmega_card_classes' ); ?>>
                                <div class="htmega-post-timeline-bullet"></div>
                                <div class="htmega-post-timeline-card-inner">
                                <?php 
                                if ( has_post_thumbnail() ){ ?>
                                    <a href="<?php the_permalink();?>" class="htmega-post-timeline-image"><?php the_post_thumbnail( $htmega_image );?></a>
                                    <?php 
                                } ?>
                                <?php 
                                if( $settings['show_category'] == 'yes' || $settings['show_title'] == 'yes' || $settings['show_content'] == 'yes' || $settings['show_read_more_btn'] == 'yes' || $settings['show_author'] == 'yes' || $settings['show_date'] == 'yes' ) { ?>
                                    <div class="htmega-post-timeline-content">
                                        <?php 
                                        if( $category_name ){
                                            $get_terms = get_the_terms( $post_query->ID, $category_name[0] );
                                            if($post_type == 'product'){
                                                $get_terms = get_the_terms($post_query->ID, 'product_cat');
                                            }

                                            if( $settings['show_category'] == 'yes' && $get_terms ): ?>
                                                <div class="htmega-post-categorys">
                                                    <?php
                                                        foreach ( $get_terms as $category ) {
                                                            $term_link = get_term_link( $category );
                                                            ?>
                                                                <a href="<?php echo esc_url( $term_link ); ?>" class=" htmega-post-timeline-category htmega-cat-<?php echo esc_attr( $category->slug ); ?>"><?php echo esc_html( $category->name );?></a>
                                                            <?php
                                                        }
                                                    ?>
                                                </div>
                                                <?php 
                                            endif; 
                                        }
                                        ?>
                                        <?php 
                                        if( $settings['show_title'] == 'yes' ): ?>
                                            <h3 class="htmega-post-timeline-title">
                                                <a href="<?php the_permalink();?>">
                                                    <?php
                                                    if ( 0 > $settings['title_length'] ) { 
                                                        the_title();
                                                    } else { 
                                                        echo esc_html( wp_trim_words( get_the_title(), $settings['title_length'], '' ) );
                                                    }
                                                    ?>
                                                </a>
                                            </h3>
                                            <?php 
                                        endif;

                                        if( $settings['show_author'] == 'yes' || $settings['show_date'] == 'yes' ){ ?>
                                            <ul class="htmega-post-timeline-meta">
                                                <?php 
                                                if( $settings['show_author'] == 'yes'): ?>
                                                    <li class="htmega-post-timeline-meta-item">
                                                        <svg width="13" height="13" viewBox="0 0 13 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M6.48161 12.2741C4.41063 12.2741 2.33836 12.2715 0.266082 12.2806C0.0463741 12.2819 0.0229733 12.2039 0.00867272 12.0128C-0.091431 10.7088 0.687298 9.99252 1.71044 9.4387C2.36696 9.08249 3.08849 8.87838 3.77231 8.58717C4.04272 8.47147 4.31183 8.35186 4.54584 8.17116C4.84615 7.93845 4.90985 7.66284 4.71355 7.33913C4.56144 7.08822 4.37423 6.86071 4.21173 6.6163C3.3641 5.34355 3.05729 3.9629 3.4148 2.46395C3.77491 0.95849 5.04766 -0.0464472 6.59342 0.00165457C7.89216 0.0432561 8.8581 0.68158 9.36902 1.87502C10.0658 3.50398 9.76033 5.05624 8.8542 6.5227C8.70339 6.7658 8.51749 6.98551 8.35758 7.22212C8.06247 7.65764 8.13007 7.98005 8.58509 8.26606C9.09861 8.58847 9.67193 8.77438 10.2387 8.97849C11.0383 9.2658 11.7897 9.62981 12.3968 10.2486C12.9311 10.7895 13.0404 11.4512 12.9884 12.1675C12.978 12.3222 12.8661 12.2728 12.7881 12.2728C12.0497 12.2767 11.3113 12.2767 10.5729 12.2767C9.20911 12.278 7.84536 12.278 6.48161 12.278V12.2741Z" fill="white" />
                                                        </svg>
                                                        <a href="<?php echo esc_url( get_author_posts_url(get_the_author_meta( 'ID' )) ); ?>" class="htmega-post-timeline-meta-item-link" >
                                                            <?php the_author(); ?>
                                                        </a>
                                                    </li>
                                                    <?php
                                                endif; ?>
                                                <?php 
                                                if( $settings['show_date'] == 'yes'): ?>
                                                    <li class="htmega-post-timeline-meta-item">
                                                        <svg width="11" height="13" viewBox="0 0 11 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M10.5566 2.13624C10.5554 1.52355 10.2116 1.21536 9.60382 1.23132C9.39755 1.23623 9.35212 1.31727 9.35703 1.50022C9.36562 1.80963 9.37053 2.12027 9.35457 2.42969C9.33002 2.93065 9.03288 3.24252 8.53683 3.28181C8.27408 3.30268 8.00764 3.30145 7.74611 3.28304C7.21323 3.2462 6.91486 2.92328 6.90258 2.38794C6.89645 2.08958 6.89276 1.79122 6.90381 1.49285C6.91118 1.30131 6.8461 1.23255 6.64965 1.23378C5.73123 1.24237 4.81281 1.24237 3.89562 1.23378C3.68688 1.23132 3.64636 1.32095 3.6525 1.50145C3.66233 1.81086 3.6611 2.1215 3.65373 2.43092C3.64268 2.89872 3.37256 3.21673 2.90844 3.26953C2.62481 3.30268 2.33504 3.30023 2.04895 3.28304C1.52712 3.25234 1.23612 2.94292 1.21771 2.41741C1.20788 2.108 1.20666 1.79735 1.21771 1.48794C1.22507 1.29271 1.14895 1.23623 0.957405 1.23255C0.332436 1.21904 0.000920877 1.53214 0.000920877 2.17062C-0.000306959 5.22424 -0.000306959 8.27664 0.000920877 11.3303C0.000920877 11.9884 0.284551 12.2769 0.941443 12.2782C3.83422 12.2806 6.72578 12.2806 9.61856 12.2782C10.2804 12.2782 10.5566 11.9958 10.5566 11.3315C10.5591 9.8053 10.5566 8.27787 10.5566 6.75167C10.5579 5.21196 10.5603 3.67349 10.5566 2.13624ZM1.20297 4.30705C1.20174 4.14743 1.2705 4.08358 1.43012 4.08358C2.10543 4.08727 2.78074 4.08727 3.45482 4.08481C3.59971 4.08481 3.65619 4.14498 3.65496 4.29109C3.65005 4.83993 3.64882 5.39 3.65619 5.93884C3.65864 6.12056 3.56042 6.14144 3.41799 6.14021C3.08647 6.13653 2.75496 6.13898 2.42221 6.13898C2.0907 6.13898 1.75795 6.13407 1.42644 6.14144C1.26559 6.14512 1.20052 6.08373 1.20174 5.92165C1.20788 5.38263 1.20666 4.84484 1.20297 4.30705ZM3.65742 10.8269C3.65987 11.0024 3.60216 11.0724 3.4229 11.07C2.77092 11.0638 2.11894 11.0638 1.46696 11.07C1.27664 11.0724 1.19929 11.0061 1.20174 10.8121C1.20911 10.2854 1.20788 9.75987 1.20297 9.23313C1.20174 9.07228 1.26559 9.00843 1.42644 9.01212C1.75795 9.01948 2.08947 9.01457 2.42221 9.01457C2.75373 9.01457 3.08647 9.02071 3.41799 9.01212C3.59234 9.0072 3.6611 9.06614 3.65864 9.24786C3.64882 9.7746 3.65005 10.3013 3.65742 10.8269ZM3.37992 8.61061C3.05946 8.59711 2.73777 8.60693 2.41607 8.60693C2.10666 8.60693 1.79602 8.59711 1.4866 8.61061C1.28524 8.61921 1.1956 8.56396 1.20052 8.34417C1.21157 7.82848 1.21034 7.31156 1.20174 6.79464C1.19806 6.59574 1.2791 6.54048 1.46696 6.54294C2.10911 6.55153 2.7525 6.55522 3.39466 6.54171C3.61812 6.5368 3.66233 6.62766 3.65864 6.82534C3.64882 7.32998 3.64514 7.83585 3.65987 8.34049C3.66478 8.55904 3.58375 8.61921 3.37992 8.61061ZM4.29098 4.08481C4.94541 4.0885 5.59985 4.08972 6.25429 4.08358C6.4311 4.08236 6.49863 4.14743 6.49617 4.32547C6.4888 4.85344 6.48758 5.38141 6.49617 5.90938C6.49863 6.09723 6.41513 6.14389 6.24692 6.14021C5.91418 6.13284 5.58143 6.13775 5.24869 6.13775C4.927 6.13775 4.6053 6.13284 4.28484 6.14021C4.12277 6.14389 4.0626 6.0825 4.06383 5.9192C4.06997 5.38018 4.06997 4.83993 4.06383 4.30091C4.06137 4.13147 4.13627 4.08358 4.29098 4.08481ZM4.0626 6.78482C4.06015 6.61047 4.1154 6.54171 4.29835 6.54417C4.95155 6.55276 5.60476 6.55153 6.2592 6.54417C6.44092 6.54171 6.49863 6.6117 6.49617 6.78605C6.49003 7.31279 6.49003 7.84076 6.49617 8.36873C6.49863 8.54431 6.43846 8.6143 6.25797 8.60939C5.92523 8.59956 5.59371 8.60693 5.26097 8.60693C4.95155 8.60693 4.64214 8.60079 4.33272 8.60939C4.15346 8.61552 4.05769 8.57746 4.0626 8.3675C4.07365 7.84076 4.06997 7.31279 4.0626 6.78482ZM6.49863 10.7949C6.50354 11.0061 6.42618 11.0749 6.21868 11.0724C5.58757 11.0626 4.95647 11.0651 4.32413 11.0712C4.13627 11.0737 4.05646 11.0184 4.06137 10.817C4.07242 10.3001 4.07242 9.78442 4.06137 9.2675C4.05769 9.07105 4.12768 9.00475 4.31922 9.01212C4.63968 9.02317 4.96138 9.0158 5.28307 9.0158C5.59248 9.0158 5.90313 9.02439 6.21254 9.01212C6.41391 9.00475 6.50231 9.06123 6.4974 9.27978C6.48512 9.78442 6.48635 10.2903 6.49863 10.7949ZM6.8989 4.32792C6.89645 4.15234 6.95784 4.08113 7.1371 4.08358C7.79031 4.08972 8.44229 4.08972 9.0955 4.08358C9.27967 4.08236 9.36685 4.13884 9.36317 4.33897C9.35457 4.86572 9.35703 5.39246 9.36194 5.9192C9.36317 6.08127 9.30055 6.14389 9.13847 6.14021C8.79468 6.13407 8.45088 6.13775 8.10832 6.13775C7.7989 6.13775 7.48949 6.12916 7.1813 6.14144C6.98117 6.1488 6.89276 6.09232 6.8989 5.87377C6.90995 5.3593 6.90627 4.84361 6.8989 4.32792ZM9.36071 10.849C9.36194 11.0147 9.28336 11.0687 9.12988 11.0687C8.45457 11.0663 7.77803 11.0663 7.10272 11.0687C6.95784 11.0687 6.8989 11.0061 6.90013 10.8612C6.90381 10.3112 6.90504 9.76232 6.90013 9.21225C6.8989 9.0293 7.00572 9.01334 7.14447 9.01457C7.47598 9.01703 7.80873 9.0158 8.14024 9.0158C8.47176 9.0158 8.8045 9.02071 9.13602 9.01457C9.29686 9.01089 9.36194 9.07228 9.35948 9.23558C9.3558 9.77215 9.3558 10.3112 9.36071 10.849ZM9.07708 8.60939C8.75662 8.59711 8.43615 8.6057 8.11569 8.6057C7.78417 8.6057 7.45143 8.59956 7.11991 8.60693C6.95784 8.61061 6.89645 8.54799 6.8989 8.38592C6.90381 7.84813 6.90627 7.31034 6.89767 6.77254C6.89522 6.58468 6.97871 6.54171 7.14692 6.54294C7.7989 6.54908 8.45088 6.5503 9.10287 6.54171C9.29686 6.53925 9.36562 6.60556 9.36194 6.79833C9.35334 7.31279 9.35089 7.82848 9.36317 8.34295C9.36931 8.56641 9.27476 8.61675 9.07708 8.60939ZM2.48115 2.86434C2.89739 2.8361 3.22031 2.50459 3.24118 2.07239C3.251 1.85506 3.24241 1.63651 3.24241 1.41918C3.24241 1.2129 3.24977 1.00663 3.24118 0.800352C3.22153 0.363242 2.90598 0.0341825 2.48852 0.00225879C2.07474 -0.0284371 1.70025 0.256421 1.64376 0.692302C1.57992 1.18098 1.58237 1.67825 1.64254 2.16693C1.69533 2.60281 2.0686 2.89136 2.48115 2.86434ZM8.10464 2.86557C8.55157 2.88276 8.91255 2.53406 8.94448 2.04169C8.95675 1.8477 8.94693 1.65247 8.94693 1.45724H8.9457C8.9457 1.23992 8.95921 1.02013 8.94325 0.804035C8.90764 0.332546 8.5528 -0.00510823 8.11814 0.00103095C7.68226 0.00717013 7.33233 0.35342 7.31514 0.824908C7.3004 1.22518 7.30163 1.62791 7.31514 2.02819C7.32987 2.50459 7.66384 2.84838 8.10464 2.86557Z" fill="white" />
                                                        </svg>
                                                            <?php the_time('d F Y') ?>
                                                    </li>
                                                    <?php
                                                endif; ?>
                                            </ul>
                                        <?php
                                        }; ?>
                                        <?php
                                        if( $settings['show_content'] == 'yes' || $settings['show_read_more_btn'] == 'yes' ){ ?>
                                            <div class="htmega-post-timeline-content-bottom">
                                                <?php
                                                if( $settings['show_content'] == 'yes') {
                                                    echo ' <p class="htmega-post-timeline-des">'. wp_kses_post( wp_trim_words( strip_shortcodes( get_the_content() ), floatval($settings['content_length'] ), '' ) ).'</p>';
                                                }

                                                if( $settings['show_read_more_btn'] == 'yes' ): ?>
                                                    <a class="htmega-post-timeline-button" href="<?php the_permalink();?>"><?php echo htmega_kses_desc( $settings['read_more_txt'] );?></a>
                                                    <?php
                                                endif; ?>
                                        </div>
                                            <?php 
                                        } ?>
                                    </div>
                                    <?php
                                } ?>
                                </div>
                            </div>

                        <?php
                        endwhile;

                    else:
                        echo "<div class='htmega-error-notice'>".esc_html__('There are no posts in this query','htmega-pro')."</div>";
                            
                    endif;
                    ?>
                </div>
                <?php
                if( $settings['show_load_more_btn'] == 'yes' && $post_query->have_posts() ): ?>
                    <div class="load-more">
                        <button class="htmega-timeline-load-more-button htmega-timeline-load-more-active <?php echo esc_attr($sectionid);?>"><?php echo htmega_kses_desc( $settings['show_load_txt'] );?> <span class="htmega-loader-img"><img src="<?php echo esc_url( HTMEGA_ADDONS_PL_URL_PRO.'/assets/images/load-more-icon.png' ); ?>" alt="<?php echo esc_attr('...') ?>"><span></span></span></button>
                    </div>
                    <?php
                endif; ?>
            <?php    
            } else { ?>
                <!-- timeline vertical timeline style one -->
                <div class="htmega-post-timeline-wrappper">
                <?php 
                if( $post_query->have_posts() ):
                    $count = 0;

                    while( $post_query->have_posts() ): $post_query->the_post();
                        $current_year = (int)get_the_time('Y');
                        if( $count == 0  ){ 
                            $prev_year = (int)get_the_time('Y');
                            ?>
                            <div class="htmega-post-timeline-year-wrap">
                                <h5 class="htmega-post-timeline-year-text"><?php the_time('Y'); ?></h5>
                            </div>
                            <div class="htmega-post-timeline-wrap-3">
                            <?php 
                        } ?>
                        <?php 
                            $check_order = ($postorder == 'ASC') ? $current_year > $prev_year : $current_year < $prev_year;
                        if(  $check_order ){ ?>
                            </div>
                            <div class="htmega-post-timeline-year-wrap <?php  echo esc_attr($load_more_times_class) ?>">
                                <h5 class="htmega-post-timeline-year-text"><?php the_time('Y'); ?></h5>
                            </div>
                            <div class="htmega-post-timeline-wrap-3">
                        <?php
                        } 
                        ?>

                        <div <?php echo $this->get_render_attribute_string( 'htmega_card_classes' ); ?>>
                            <?php 
                            if( $settings['show_date'] == 'yes' ): ?>
                                <div class="htmega-post-timeline-card-date"><?php the_time('d F Y') ?></div>
                                <?php 
                            endif; ?>
                            <div class="htmega-post-timeline-card-inner-box">
                                <div class="htmega-post-timeline-bullet"></div>
                                <div class="htmega-post-timeline-card-inner">
                                    <?php 
                                    if ( has_post_thumbnail() ){ ?>
                                        <a href="<?php the_permalink();?>" class="htmega-post-timeline-image"><?php the_post_thumbnail( $htmega_image );?></a>
                                        <?php 
                                    } ?>
                                    <?php 
                                    if( $settings['show_category'] == 'yes' || $settings['show_title'] == 'yes' || $settings['show_content'] == 'yes' || $settings['show_read_more_btn'] == 'yes' ) { ?>
                                        <div class="htmega-post-timeline-content">
                                            <?php 
                                            if( $category_name ){
                                                $get_terms = get_the_terms( $post_query->ID, $category_name[0] );
                                                if($post_type == 'product'){
                                                    $get_terms = get_the_terms($post_query->ID, 'product_cat');
                                                }

                                                if( $settings['show_category'] == 'yes' && $get_terms): ?>
                                                    <div class="htmega-post-categorys">
                                                        <?php
                                                            foreach ( $get_terms as $category ) {
                                                                $term_link = get_term_link( $category );
                                                                ?>
                                                                <a href="<?php echo esc_url( $term_link ); ?>" class=" htmega-post-timeline-category htmega-cat-<?php echo esc_attr( $category->slug ); ?>"><?php echo esc_html( $category->name );?></a>
                                                            <?php
                                                            }
                                                        ?>
                                                    </div>
                                                    <?php 
                                                endif; 
                                            }
                                            ?>
                                            <?php 
                                            if( $settings['show_title'] == 'yes' ): ?>
                                                <h3 class="htmega-post-timeline-title">
                                                    <a href="<?php the_permalink();?>">
                                                        <?php
                                                        if ( 0 > $settings['title_length'] ) { 
                                                            the_title();
                                                        } else { 
                                                            echo esc_html( wp_trim_words( get_the_title(), $settings['title_length'], '' ) );
                                                        }
                                                        ?>
                                                    </a>
                                                </h3>
                                                <?php 
                                            endif; ?>
                                            <?php
                                            if( $settings['show_content'] == 'yes' || $settings['show_read_more_btn'] == 'yes' ){ ?>
                                                <div class="htmega-post-timeline-content-bottom">
                                                    <?php
                                                    if( $settings['show_content'] == 'yes') {
                                                        echo ' <p class="htmega-post-timeline-des">'. wp_kses_post( wp_trim_words( strip_shortcodes( get_the_content() ), floatval($settings['content_length'] ), '' ) ).'</p>';
                                                    }

                                                    if( $settings['show_read_more_btn'] == 'yes' ): ?>
                                                        <a class="htmega-post-timeline-button" href="<?php the_permalink();?>"><?php echo htmega_kses_desc( $settings['read_more_txt'] );?></a>
                                                        <?php
                                                    endif; ?>
                                                </div>
                                                <?php 
                                            } ?>
                                        </div>
                                        <?php 
                                    } ?>
                                </div>
                            </div>
                        </div>

                        <?php 
                            if($count == $settings['post_limit'] ){ ?>
                            </div>
                       <?php } ?>
                        <?php
                          $prev_year = $current_year;
                         $count ++;
                    endwhile;

                else:
                    echo "<div class='htmega-error-notice'>".esc_html__('There are no posts in this query','htmega-pro')."</div>";

                endif;
                ?>

                </div> <!-- main wrapper end-->
                <?php
                if( $settings['show_load_more_btn'] == 'yes' && $post_query->have_posts()  ): ?>
                    <div class="load-more">
                        <button class="htmega-timeline-load-more-button htmega-timeline-load-more-active <?php echo esc_attr($sectionid);?>"><?php echo htmega_kses_desc( $settings['show_load_txt'] );?> <span class="htmega-loader-img"><img src="<?php echo esc_url( HTMEGA_ADDONS_PL_URL_PRO.'/assets/images/load-more-icon.png' ); ?>" alt="<?php echo esc_attr('...') ?>"><span></span></span></button>
                    </div>
                    <div class="load-more">
                    <?php
                endif; ?>
                <?php 
            } ?>
            <?php
        } else {
        echo "<div ".$this->get_render_attribute_string( 'htmega_pro_wrapper_attr' ).$s_display_none." >";
                if( $post_query->have_posts() ):

                    while( $post_query->have_posts() ): $post_query->the_post();
                        ?>
                        <div <?php echo $this->get_render_attribute_string( 'htmega_card_classes' ); ?>>
                            <?php 
                            if( $settings['show_date'] == 'yes'): ?>
                                <div class='htmega-post-timeline-card-date'><?php the_time('d F Y') ?></div>
                            <?php
                            endif; ?>
                            <div class="htmega-post-timeline-bullet">
                            <div class="htmega-post-timeline-inner-image">
                                <?php if ( '2' == $settings['card_style'] ){ ?>
                                <svg width="16" height="19" viewBox="0 0 16 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M15.5571 3.14814C15.5553 2.24523 15.0487 1.79106 14.153 1.81458C13.849 1.82182 13.7821 1.94124 13.7893 2.21085C13.802 2.66683 13.8092 3.12462 13.7857 3.5806C13.7495 4.31885 13.3116 4.77845 12.5806 4.83635C12.1934 4.86711 11.8007 4.8653 11.4153 4.83816C10.63 4.78388 10.1903 4.30799 10.1722 3.51908C10.1632 3.07938 10.1578 2.63969 10.174 2.19999C10.1849 1.91772 10.089 1.81639 9.79949 1.8182C8.44602 1.83087 7.09256 1.83087 5.74091 1.8182C5.4333 1.81458 5.37359 1.94667 5.38264 2.21266C5.39711 2.66864 5.39531 3.12643 5.38445 3.58241C5.36816 4.2718 4.97009 4.74045 4.28612 4.81826C3.86814 4.86711 3.44111 4.86349 3.01951 4.83816C2.25049 4.79292 1.82166 4.33694 1.79451 3.5625C1.78004 3.10652 1.77823 2.64873 1.79451 2.19275C1.80537 1.90505 1.69319 1.82182 1.41091 1.81639C0.489906 1.79649 0.00135708 2.25789 0.00135708 3.1988C-0.000452361 7.69889 -0.000452361 12.1972 0.00135708 16.6972C0.00135708 17.6671 0.419338 18.0923 1.38739 18.0941C5.65044 18.0978 9.91167 18.0978 14.1747 18.0941C15.15 18.0941 15.5571 17.678 15.5571 16.6991C15.5608 14.4499 15.5571 12.199 15.5571 9.94983C15.5589 7.68079 15.5626 5.41356 15.5571 3.14814ZM1.7728 6.34723C1.77099 6.11201 1.87232 6.01792 2.10755 6.01792C3.10274 6.02334 4.09793 6.02334 5.09132 6.01973C5.30483 6.01973 5.38807 6.10839 5.38626 6.32371C5.37902 7.13253 5.37721 7.94316 5.38807 8.75198C5.39169 9.01978 5.24693 9.05054 5.03704 9.04873C4.54849 9.0433 4.05994 9.04692 3.56958 9.04692C3.08103 9.04692 2.59067 9.03968 2.10212 9.05054C1.86508 9.05597 1.76918 8.9655 1.77099 8.72665C1.78004 7.93231 1.77823 7.13977 1.7728 6.34723ZM5.38988 15.9554C5.3935 16.2141 5.30845 16.3173 5.04427 16.3136C4.08346 16.3046 3.12265 16.3046 2.16183 16.3136C1.88137 16.3173 1.76737 16.2196 1.77099 15.9337C1.78185 15.1574 1.78004 14.383 1.7728 13.6067C1.77099 13.3697 1.86508 13.2756 2.10212 13.281C2.59067 13.2919 3.07922 13.2846 3.56958 13.2846C4.05813 13.2846 4.54849 13.2937 5.03704 13.281C5.29398 13.2738 5.39531 13.3606 5.39169 13.6284C5.37721 14.4047 5.37902 15.1809 5.38988 15.9554ZM4.98094 12.6893C4.50868 12.6694 4.0346 12.6839 3.56053 12.6839C3.10455 12.6839 2.64676 12.6694 2.19078 12.6893C1.89403 12.702 1.76194 12.6206 1.76918 12.2967C1.78547 11.5367 1.78366 10.7749 1.77099 10.0132C1.76556 9.72003 1.88499 9.63861 2.16183 9.64223C3.10817 9.65489 4.05632 9.66032 5.00266 9.64042C5.33197 9.63318 5.39711 9.76708 5.39169 10.0584C5.37721 10.8021 5.37178 11.5476 5.3935 12.2913C5.40073 12.6133 5.28131 12.702 4.98094 12.6893ZM6.32355 6.01973C7.28798 6.02515 8.25242 6.02696 9.21685 6.01792C9.47741 6.01611 9.57693 6.11201 9.57331 6.37438C9.56245 7.15244 9.56064 7.9305 9.57331 8.70856C9.57693 8.9854 9.45388 9.05416 9.20599 9.04873C8.71563 9.03788 8.22527 9.04511 7.73491 9.04511C7.26084 9.04511 6.78677 9.03788 6.3145 9.04873C6.07566 9.05416 5.98699 8.96369 5.9888 8.72303C5.99785 7.92869 5.99785 7.13253 5.9888 6.33819C5.98518 6.08848 6.09556 6.01792 6.32355 6.01973ZM5.98699 9.99869C5.98337 9.74175 6.0648 9.64042 6.33441 9.64404C7.29703 9.6567 8.25965 9.65489 9.22408 9.64404C9.49188 9.64042 9.57693 9.74356 9.57331 10.0005C9.56426 10.7767 9.56426 11.5548 9.57331 12.3329C9.57693 12.5916 9.48826 12.6948 9.22228 12.6875C8.73192 12.673 8.24337 12.6839 7.75301 12.6839C7.29703 12.6839 6.84105 12.6749 6.38507 12.6875C6.12089 12.6966 5.97975 12.6405 5.98699 12.3311C6.00328 11.5548 5.99785 10.7767 5.98699 9.99869ZM9.57693 15.9083C9.58416 16.2196 9.47017 16.3209 9.16437 16.3173C8.23432 16.3028 7.30427 16.3064 6.3724 16.3155C6.09556 16.3191 5.97795 16.2376 5.98518 15.9409C6.00147 15.1791 6.00147 14.4192 5.98518 13.6574C5.97975 13.3679 6.08289 13.2702 6.36517 13.281C6.83743 13.2973 7.3115 13.2864 7.78558 13.2864C8.24156 13.2864 8.69935 13.2991 9.15533 13.281C9.45207 13.2702 9.58235 13.3534 9.57512 13.6755C9.55702 14.4192 9.55883 15.1646 9.57693 15.9083ZM10.1668 6.37799C10.1632 6.11924 10.2537 6.0143 10.5178 6.01792C11.4805 6.02696 12.4413 6.02696 13.4039 6.01792C13.6753 6.01611 13.8038 6.09934 13.7984 6.39428C13.7857 7.17053 13.7893 7.94678 13.7965 8.72303C13.7984 8.96188 13.7061 9.05416 13.4672 9.04873C12.9606 9.03968 12.4539 9.04511 11.9491 9.04511C11.4931 9.04511 11.0371 9.03245 10.583 9.05054C10.288 9.0614 10.1578 8.97816 10.1668 8.65608C10.1831 7.89793 10.1777 7.13796 10.1668 6.37799ZM13.7947 15.9879C13.7965 16.2322 13.6807 16.3118 13.4546 16.3118C12.4594 16.3082 11.4624 16.3082 10.4672 16.3118C10.2537 16.3118 10.1668 16.2196 10.1686 16.006C10.174 15.1954 10.1759 14.3866 10.1686 13.576C10.1668 13.3063 10.3242 13.2828 10.5287 13.2846C11.0172 13.2883 11.5076 13.2864 11.9962 13.2864C12.4847 13.2864 12.9751 13.2937 13.4636 13.2846C13.7006 13.2792 13.7965 13.3697 13.7929 13.6103C13.7875 14.4011 13.7875 15.1954 13.7947 15.9879ZM13.3768 12.6875C12.9045 12.6694 12.4322 12.6821 11.96 12.6821C11.4714 12.6821 10.9811 12.673 10.4925 12.6839C10.2537 12.6893 10.1632 12.597 10.1668 12.3582C10.174 11.5657 10.1777 10.7731 10.165 9.98059C10.1614 9.70375 10.2844 9.64042 10.5323 9.64223C11.4931 9.65128 12.4539 9.65308 13.4148 9.64042C13.7006 9.6368 13.802 9.73451 13.7965 10.0186C13.7839 10.7767 13.7803 11.5367 13.7984 12.2949C13.8074 12.6242 13.6681 12.6984 13.3768 12.6875ZM3.65643 4.22114C4.26983 4.17952 4.74572 3.69097 4.77648 3.05405C4.79095 2.73378 4.77829 2.4117 4.77829 2.09143C4.77829 1.78744 4.78914 1.48345 4.77648 1.17947C4.74752 0.535305 4.2825 0.0503742 3.66729 0.00332874C3.05751 -0.0419073 2.50563 0.377883 2.42239 1.02024C2.3283 1.74039 2.33192 2.47322 2.42058 3.19338C2.49839 3.83573 3.04846 4.26095 3.65643 4.22114ZM11.9437 4.22295C12.6023 4.24828 13.1343 3.7344 13.1813 3.00881C13.1994 2.72292 13.185 2.43522 13.185 2.14752H13.1831C13.1831 1.82725 13.203 1.50336 13.1795 1.18489C13.1271 0.490069 12.6041 -0.00752792 11.9636 0.0015193C11.3212 0.0105665 10.8055 0.520829 10.7802 1.21566C10.7585 1.80553 10.7603 2.39903 10.7802 2.98891C10.8019 3.69097 11.2941 4.19762 11.9437 4.22295Z" fill="#C29B24" />
                                </svg>
                                <?php 
                                } ?>
                        </div>

                            </div>
                            <div class="htmega-post-timeline-card-inner">
                            <?php 
                                    if ( '2' == $settings['card_style'] ){ 
                                        
                                        if( 'yes' == $settings['show_author'] ||  'yes' == $settings['show_comment'] ){ ?>

                                        <div class="htmega-post-timeline-meta">
                                            <?php
                                            if( 'yes' == $settings['show_author']){ ?>
                                                <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" class="htmega-post-timeline-meta-item">
                                                    <span class="htmega-post-timeline-meta-img">
                                                        <img src="<?php echo esc_url( get_avatar_url( get_the_author_meta( 'ID' ), ['size' => '30'] ) ); ?>" alt="<?php echo the_author();?>" />
                                                    </span>
                                                    <h6 class="htmega-post-timeline-meta-name">
                                                        <?php the_author(); ?>
                                                    </h6>
                                                </a>
                                                <?php } ?>
                                            <?php
                                            if( 'yes' == $settings['show_comment']){   
                                            
                                                $icon_html = "<span class='htmega-post-timeline-meta-icon'>
                                                <svg width='18' height='16' viewBox='0 0 18 16' fill='none' xmlns='http://www.w3.org/2000/svg'> <path d='M10.6661 1.0685C9.54833 0.37909 8.22375 0 6.85547 0C3.1308 0 0 2.77499 0 6.32812C0 7.57389 0.387 8.76811 1.12212 9.79949L0.0952031 13.0235C-0.0132891 13.3641 0.241805 13.7109 0.597762 13.7109C0.679148 13.7109 0.761062 13.6921 0.836648 13.6537L3.95965 12.0658C4.0861 12.1202 4.21414 12.1709 4.34348 12.2179C3.62043 11.0893 3.23437 9.79383 3.23437 8.4375C3.23437 4.39815 6.63321 1.29277 10.6661 1.0685Z' fill='#C29B24'></path>
                                                <path d='M16.8779 11.9089C17.613 10.8775 18 9.68326 18 8.4375C18 4.88306 14.8679 2.10938 11.1445 2.10938C7.41987 2.10938 4.28906 4.88436 4.28906 8.4375C4.28906 11.9919 7.4212 14.7656 11.1445 14.7656C12.1436 14.7656 13.139 14.562 14.0402 14.1751L17.1634 15.763C17.3529 15.8594 17.5818 15.8325 17.7439 15.6948C17.9059 15.5571 17.9694 15.3355 17.9048 15.1329L16.8779 11.9089ZM9 8.96484C8.70877 8.96484 8.47266 8.72873 8.47266 8.4375C8.47266 8.14627 8.70877 7.91016 9 7.91016C9.29123 7.91016 9.52734 8.14627 9.52734 8.4375C9.52734 8.72873 9.29123 8.96484 9 8.96484ZM11.1094 8.96484C10.8181 8.96484 10.582 8.72873 10.582 8.4375C10.582 8.14627 10.8181 7.91016 11.1094 7.91016C11.4006 7.91016 11.6367 8.14627 11.6367 8.4375C11.6367 8.72873 11.4006 8.96484 11.1094 8.96484ZM13.2188 8.96484C12.9275 8.96484 12.6914 8.72873 12.6914 8.4375C12.6914 8.14627 12.9275 7.91016 13.2188 7.91016C13.51 7.91016 13.7461 8.14627 13.7461 8.4375C13.7461 8.72873 13.51 8.96484 13.2188 8.96484Z' fill='#C29B24'></path> </svg>
                                                </span>";
                                                $icon_html_0 = "<span class='htmega-post-timeline-meta-comment'> 0</span>";
                                                $icon_html_1 = "<span class='htmega-post-timeline-meta-comment'> 1</span>";
                                                $icon_html_more = "<span class='htmega-post-timeline-meta-comment'> %</span>";
                                                ?>
                                                <?php comments_popup_link($icon_html.$icon_html_0, $icon_html.$icon_html_1, $icon_html.$icon_html_more, 'htmega-post-timeline-meta-item', esc_html__('Comments off','htmega-pro') ); ?>
                                                <?php 
                                            } ?>
                                        </div>
                                        <?php
                                        }
                                    } ?>
                                <?php 
                                if ( has_post_thumbnail() ){ ?>
                                    <a href="<?php the_permalink();?>" class="htmega-post-timeline-image"><?php the_post_thumbnail( $htmega_image );?></a>
                                    <?php 
                                } ?>
                                
                                <?php 
                                if( $settings['show_category'] == 'yes' || $settings['show_title'] == 'yes' || $settings['show_content'] == 'yes' || $settings['show_read_more_btn'] == 'yes' ) { ?>
                                    <div class="htmega-post-timeline-content">
                                        <?php 
                                        if( $category_name ){
                                            $get_terms = get_the_terms( $post_query->ID, $category_name[0] );
                                            if($post_type == 'product'){
                                                $get_terms = get_the_terms($post_query->ID, 'product_cat');
                                            }
                                            if( $settings['show_category'] == 'yes' && $get_terms ): ?>
                                                <div class="htmega-post-categorys">
                                                    <?php
                                                        foreach ( $get_terms as $category ) {
                                                            $term_link = get_term_link( $category );
                                                            ?>
                                                                <a href="<?php echo esc_url( $term_link ); ?>" class=" htmega-post-timeline-category htmega-cat-<?php echo esc_attr( $category->slug ); ?>"><?php echo esc_html( $category->name );?></a>
                                                            <?php
                                                        }
                                                    ?>
                                                </div>
                                                <?php 
                                            endif; 
                                        }
                                            ?>
                                        <?php 
                                        if( $settings['show_title'] == 'yes' ): ?>
                                            <h3 class="htmega-post-timeline-title">
                                                <a href="<?php the_permalink();?>">
                                                    <?php
                                                    if ( 0 > $settings['title_length'] ) { 
                                                        the_title();
                                                    } else { 
                                                        echo esc_html( wp_trim_words( get_the_title(), $settings['title_length'], '' ) );
                                                    }
                                                    ?>
                                                </a>
                                            </h3>
                                            <?php 
                                        endif; ?>
                                        <?php
                                        if( $settings['show_content'] == 'yes' || $settings['show_read_more_btn'] == 'yes' ){ ?>
                                            <div class="htmega-post-timeline-content-bottom">
                                                <?php
                                                if( $settings['show_content'] == 'yes') {
                                                    echo ' <p class="htmega-post-timeline-des">'. wp_kses_post( wp_trim_words( strip_shortcodes( get_the_content() ), floatval($settings['content_length'] ), '' ) ).'</p>';
                                                }

                                                if( $settings['show_read_more_btn'] == 'yes' ): ?>
                                                    <a class="htmega-post-timeline-button" href="<?php the_permalink();?>"><?php echo htmega_kses_desc( $settings['read_more_txt'] );?></a>
                                                    <?php
                                                endif; ?>
                                        </div>
                                            <?php 
                                        } ?>
                                    </div>
                                    <?php
                                } ?>
                            </div>
                        </div>
                        <?php
                    endwhile;
                else:
                    echo "<div class='htmega-error-notice'>".esc_html__('There are no posts in this query','htmega-pro')."</div>";

                endif;
            ?>
        </div>
        <?php
        }// Horizontal style end        
            ?>
        <script>
            jQuery(document).ready(function($) {                

            let currentDevice = elementorFrontend.getCurrentDeviceMode();
            $(".htmega-post-timeline-wrappper").addClass('htmega-'+currentDevice );
                <?php 
                if( 'yes' == $settings['show_load_more_btn'] ){ ?>

                    function loadMore(elementList, currentItems){
                        return function(e, lodeShowItems){
                            const target = e.target;
                            target.classList.add('show-loader');
                            for(let i = currentItems; i < currentItems + lodeShowItems; i++){
                                setTimeout(()=> {
                                    if(elementList[i]){
                                        elementList[i].style.display = "block";
                                    }
                                }, 1000);
                            }
                            
                            currentItems += lodeShowItems;

                            if(currentItems >= elementList.length) {
                                e.target.classList.add('loaded')
                                setTimeout(()=> {
                                    target.textContent = "<?php esc_html_e( 'All items loaded','htmega-pro' ); ?>";
                                }, 1200)
                            }
                        }
                    }
                    function initialItemShow(elementList, initialItems){
                        elementList.slice(0, initialItems).forEach(el=>{
                            el.style.display = "block";
                        });
                    }

                    (function(){
                        const initialItems = <?php echo esc_js($settings['show_load_initial_items']) ?>;
                        const lodeShowItems = <?php echo esc_js($settings['show_load_items']) ?>;
                        const lodeMoreButton = document.querySelector(".htmega-timeline-load-more-active.<?php echo esc_attr($sectionid);?>");
                        const elementList = [...document.querySelectorAll(".<?php echo esc_attr($load_more_times_class); ?>")];

                        initialItemShow(elementList, initialItems);

                        const loadMoreFunc = loadMore(elementList, initialItems);
                        lodeMoreButton.addEventListener("click", (e) => {
                            loadMoreFunc(e, lodeShowItems);
                        })
                    })();
                    <?php 
                } ?>
            });
        </script>
        <?php
    }

    public function show_post_source(){

        $this->add_control(
            'post_type',
            [
                'label' => esc_html__( 'Content Source', 'htmega-pro' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'default' =>'post',
                'options' => htmega_get_post_types(),
                'separator' => 'before'
            ]
        );
        $this->add_control(
            'include_by',
            [
                'label' => __( 'Include By', 'htmega-pro' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => [
                    'in_author'      => __( 'Author', 'htmega-pro' ),
                    'in_category'      => __( 'Category', 'htmega-pro' ),
                ],
            ]
        );
        $this->add_control(
            'post_author',
            [
                'label' => esc_html__( 'Authors', 'htmega-pro' ),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => htmega_get_authors_list(),
                'condition' =>[
                    'include_by' => 'in_author',
                ]
            ]
        );
        $texnomy_list = htmega_get_post_types();
        foreach( $texnomy_list as $texnomykey => $texnomyValue ){
            
            $this->add_control(
                "{$texnomykey}_post_category",
                [
                    'label' => esc_html__( 'Select Categories', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => all_object_taxonomie_show_catagory($texnomykey),
                    'condition' => [
						'post_type' => $texnomykey,
						'include_by' => 'in_category',
					],
                ]
            );
        }
        $this->add_control(
            "exclude_posts",
            [
                'label' => esc_html__( 'Exclude Posts', 'htmega-pro' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => esc_html__( 'Example: 10,11,105', 'htmega-pro' ),
                'description' => esc_html__( "To Exclude Post, Enter  the post id separated by ','", 'htmega-pro' ),
            ]
        );
    }


}
