<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Source_Code_Element extends Widget_Base {
    public function get_name() {
        return 'htmega-source-code-addons';
    }
    
    public function get_title() {
        return __( 'Source Code', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-code';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }

    public function get_style_depends() {
            return ['prism' ];
    }

    public function get_script_depends() {
        if( !is_preview() ){
            return [ 'htmega-source-code-active-editor','prism' ];
        } else {
            return [ 'prism' ]; 
        }
    }

    public function get_keywords() {
        return [ 'htmega', 'ht mega', 'source code', 'code', 'view code','htmega pro'];
    }
    
    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/';
	}
    protected function is_dynamic_content():bool {
		return false;
	}
    protected function register_controls() {

        // Content
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Source Code', 'htmega-pro' ),
            ]
        );
            
            $this->add_control(
                'code_type',
                [
                    'label' => __('Code Type', 'htmega-pro'),
                    'label_block' => true,
                    'type' => Controls_Manager::SELECT,
                    'default' => 'markup',
                    'options' => [
                        'markup' => __('HTML Markup', 'htmega-pro'),
                        'css' => __('CSS', 'htmega-pro'),
                        'clike' => __('Clike', 'htmega-pro'),
                        'javascript' => __('JavaScript', 'htmega-pro'),
                        'abap' => __('ABAP', 'htmega-pro'),
                        'abnf' => __('Augmented Backus–Naur form', 'htmega-pro'),
                        'actionscript' => __('ActionScript', 'htmega-pro'),
                        'ada' => __('Ada', 'htmega-pro'),
                        'apacheconf' => __('Apache Configuration', 'htmega-pro'),
                        'apl' => __('APL', 'htmega-pro'),
                        'applescript' => __('AppleScript', 'htmega-pro'),
                        'arduino' => __('Arduino', 'htmega-pro'),
                        'arff' => __('ARFF', 'htmega-pro'),
                        'asciidoc' => __('AsciiDoc', 'htmega-pro'),
                        'asm6502' => __('6502 Assembly', 'htmega-pro'),
                        'aspnet' => __('ASP.NET (C#)', 'htmega-pro'),
                        'autohotkey' => __('AutoHotkey', 'htmega-pro'),
                        'autoit' => __('Autoit', 'htmega-pro'),
                        'bash' => __('Bash', 'htmega-pro'),
                        'basic' => __('BASIC', 'htmega-pro'),
                        'batch' => __('Batch', 'htmega-pro'),
                        'bison' => __('Bison', 'htmega-pro'),
                        'bnf' => __('Bnf', 'htmega-pro'),
                        'brainfuck' => __('Brainfuck', 'htmega-pro'),
                        'bro' => __('Bro', 'htmega-pro'),
                        'c' => __('C', 'htmega-pro'),
                        'csharp' => __('Csharp', 'htmega-pro'),
                        'cpp' => __('Cpp', 'htmega-pro'),
                        'cil' => __('Cil', 'htmega-pro'),
                        'coffeescript' => __('Coffeescript', 'htmega-pro'),
                        'cmake' => __('Cmake', 'htmega-pro'),
                        'clojure' => __('Clojure', 'htmega-pro'),
                        'crystal' => __('Crystal', 'htmega-pro'),
                        'csp' => __('Csp', 'htmega-pro'),
                        'css-extras' => __('Css-extras', 'htmega-pro'),
                        'd' => __('D', 'htmega-pro'),
                        'dart' => __('Dart', 'htmega-pro'),
                        'diff' => __('Diff', 'htmega-pro'),
                        'django' => __('Django', 'htmega-pro'),
                        'dns-zone-file' => __('Dns-zone-file', 'htmega-pro'),
                        'docker' => __('Docker', 'htmega-pro'),
                        'ebnf' => __('Ebnf', 'htmega-pro'),
                        'eiffel' => __('Eiffel', 'htmega-pro'),
                        'ejs' => __('Ejs', 'htmega-pro'),
                        'elixir' => __('Elixir', 'htmega-pro'),
                        'elm' => __('Elm', 'htmega-pro'),
                        'erb' => __('Erb', 'htmega-pro'),
                        'erlang' => __('Erlang', 'htmega-pro'),
                        'fsharp' => __('Fsharp', 'htmega-pro'),
                        'firestore-security-rules' => __('Firestore-security-rules', 'htmega-pro'),
                        'flow' => __('Flow', 'htmega-pro'),
                        'fortran' => __('Fortran', 'htmega-pro'),
                        'gcode' => __('Gcode', 'htmega-pro'),
                        'gdscript' => __('Gdscript', 'htmega-pro'),
                        'gedcom' => __('Gedcom', 'htmega-pro'),
                        'gherkin' => __('Gherkin', 'htmega-pro'),
                        'git' => __('Git', 'htmega-pro'),
                        'glsl' => __('Glsl', 'htmega-pro'),
                        'gml' => __('Gml', 'htmega-pro'),
                        'go' => __('Go', 'htmega-pro'),
                        'graphql' => __('Graphql', 'htmega-pro'),
                        'groovy' => __('Groovy', 'htmega-pro'),
                        'haml' => __('Haml', 'htmega-pro'),
                        'handlebars' => __('Handlebars', 'htmega-pro'),
                        'haskell' => __('Haskell', 'htmega-pro'),
                        'haxe' => __('Haxe', 'htmega-pro'),
                        'hcl' => __('Hcl', 'htmega-pro'),
                        'http' => __('Http', 'htmega-pro'),
                        'hpkp' => __('Hpkp', 'htmega-pro'),
                        'hsts' => __('Hsts', 'htmega-pro'),
                        'ichigojam' => __('Ichigojam', 'htmega-pro'),
                        'icon' => __('Icon', 'htmega-pro'),
                        'inform7' => __('Inform7', 'htmega-pro'),
                        'ini' => __('Ini', 'htmega-pro'),
                        'io' => __('Io', 'htmega-pro'),
                        'j' => __('J', 'htmega-pro'),
                        'java' => __('Java', 'htmega-pro'),
                        'javadoc' => __('Javadoc', 'htmega-pro'),
                        'javadoclike' => __('Javadoclike', 'htmega-pro'),
                        'javastacktrace' => __('Javastacktrace', 'htmega-pro'),
                        'jolie' => __('Jolie', 'htmega-pro'),
                        'jq' => __('Jq', 'htmega-pro'),
                        'jsdoc' => __('Jsdoc', 'htmega-pro'),
                        'js-extras' => __('Js-extras', 'htmega-pro'),
                        'js-templates' => __('Js-templates', 'htmega-pro'),
                        'json' => __('Json', 'htmega-pro'),
                        'jsonp' => __('Jsonp', 'htmega-pro'),
                        'json5' => __('Json5', 'htmega-pro'),
                        'julia' => __('Julia', 'htmega-pro'),
                        'keyman' => __('Keyman', 'htmega-pro'),
                        'kotlin' => __('Kotlin', 'htmega-pro'),
                        'latex' => __('Latex', 'htmega-pro'),
                        'less' => __('Less', 'htmega-pro'),
                        'lilypond' => __('Lilypond', 'htmega-pro'),
                        'liquid' => __('Liquid', 'htmega-pro'),
                        'lisp' => __('Lisp', 'htmega-pro'),
                        'livescript' => __('Livescript', 'htmega-pro'),
                        'lolcode' => __('Lolcode', 'htmega-pro'),
                        'lua' => __('Lua', 'htmega-pro'),
                        'makefile' => __('Makefile', 'htmega-pro'),
                        'markdown' => __('Markdown', 'htmega-pro'),
                        'markup-templating' => __('Markup-templating', 'htmega-pro'),
                        'matlab' => __('Matlab', 'htmega-pro'),
                        'mel' => __('Mel', 'htmega-pro'),
                        'mizar' => __('Mizar', 'htmega-pro'),
                        'monkey' => __('Monkey', 'htmega-pro'),
                        'n1ql' => __('N1ql', 'htmega-pro'),
                        'n4js' => __('N4js', 'htmega-pro'),
                        'nand2tetris-hdl' => __('Nand2tetris-hdl', 'htmega-pro'),
                        'nasm' => __('Nasm', 'htmega-pro'),
                        'nginx' => __('Nginx', 'htmega-pro'),
                        'nim' => __('Nim', 'htmega-pro'),
                        'nix' => __('Nix', 'htmega-pro'),
                        'nsis' => __('Nsis', 'htmega-pro'),
                        'objectivec' => __('Objectivec', 'htmega-pro'),
                        'ocaml' => __('Ocaml', 'htmega-pro'),
                        'opencl' => __('Opencl', 'htmega-pro'),
                        'oz' => __('Oz', 'htmega-pro'),
                        'parigp' => __('Parigp', 'htmega-pro'),
                        'parser' => __('Parser', 'htmega-pro'),
                        'pascal' => __('Pascal', 'htmega-pro'),
                        'pascaligo' => __('Pascaligo', 'htmega-pro'),
                        'pcaxis' => __('Pcaxis', 'htmega-pro'),
                        'perl' => __('Perl', 'htmega-pro'),
                        'php' => __('Php', 'htmega-pro'),
                        'phpdoc' => __('Phpdoc', 'htmega-pro'),
                        'php-extras' => __('Php-extras', 'htmega-pro'),
                        'plsql' => __('Plsql', 'htmega-pro'),
                        'powershell' => __('Powershell', 'htmega-pro'),
                        'processing' => __('Processing', 'htmega-pro'),
                        'prolog' => __('Prolog', 'htmega-pro'),
                        'properties' => __('Properties', 'htmega-pro'),
                        'protobuf' => __('Protobuf', 'htmega-pro'),
                        'pug' => __('Pug', 'htmega-pro'),
                        'puppet' => __('Puppet', 'htmega-pro'),
                        'pure' => __('Pure', 'htmega-pro'),
                        'python' => __('Python', 'htmega-pro'),
                        'q' => __('Q', 'htmega-pro'),
                        'qore' => __('Qore', 'htmega-pro'),
                        'r' => __('R', 'htmega-pro'),
                        'jsx' => __('Jsx', 'htmega-pro'),
                        'tsx' => __('Tsx', 'htmega-pro'),
                        'renpy' => __('Renpy', 'htmega-pro'),
                        'reason' => __('Reason', 'htmega-pro'),
                        'regex' => __('Regex', 'htmega-pro'),
                        'rest' => __('Rest', 'htmega-pro'),
                        'rip' => __('Rip', 'htmega-pro'),
                        'roboconf' => __('Roboconf', 'htmega-pro'),
                        'ruby' => __('Ruby', 'htmega-pro'),
                        'rust' => __('Rust', 'htmega-pro'),
                        'sas' => __('Sas', 'htmega-pro'),
                        'sass' => __('Sass', 'htmega-pro'),
                        'scss' => __('Scss', 'htmega-pro'),
                        'scala' => __('Scala', 'htmega-pro'),
                        'scheme' => __('Scheme', 'htmega-pro'),
                        'shell-session' => __('Shell-session', 'htmega-pro'),
                        'smalltalk' => __('Smalltalk', 'htmega-pro'),
                        'smarty' => __('Smarty', 'htmega-pro'),
                        'soy' => __('Soy', 'htmega-pro'),
                        'splunk-spl' => __('Splunk-spl', 'htmega-pro'),
                        'sql' => __('Sql', 'htmega-pro'),
                        'stylus' => __('Stylus', 'htmega-pro'),
                        'swift' => __('Swift', 'htmega-pro'),
                        'tap' => __('Tap', 'htmega-pro'),
                        'tcl' => __('Tcl', 'htmega-pro'),
                        'textile' => __('Textile', 'htmega-pro'),
                        'toml' => __('Toml', 'htmega-pro'),
                        'tt2' => __('Tt2', 'htmega-pro'),
                        'turtle' => __('Turtle', 'htmega-pro'),
                        'twig' => __('Twig', 'htmega-pro'),
                        'typescript' => __('Typescript', 'htmega-pro'),
                        't4-cs' => __('T4-cs', 'htmega-pro'),
                        't4-vb' => __('T4-vb', 'htmega-pro'),
                        't4-templating' => __('T4-templating', 'htmega-pro'),
                        'vala' => __('Vala', 'htmega-pro'),
                        'vbnet' => __('Vbnet', 'htmega-pro'),
                        'velocity' => __('Velocity', 'htmega-pro'),
                        'verilog' => __('Verilog', 'htmega-pro'),
                        'vhdl' => __('Vhdl', 'htmega-pro'),
                        'vim' => __('Vim', 'htmega-pro'),
                        'visual-basic' => __('Visual-basic', 'htmega-pro'),
                        'wasm' => __('Wasm', 'htmega-pro'),
                        'wiki' => __('Wiki', 'htmega-pro'),
                        'xeora' => __('Xeora', 'htmega-pro'),
                        'xojo' => __('Xojo', 'htmega-pro'),
                        'xquery' => __('Xquery', 'htmega-pro'),
                        'yaml' => __('Yaml', 'htmega-pro'),
                    ]
                ]
            );

            $this->add_control(
                'theme',
                [
                    'label' => __('Theme', 'htmega-pro'),
                    'label_block' => true,
                    'type' => Controls_Manager::SELECT,
                    'default' => 'default',
                    'options' => [
                        'default' => __('Default', 'htmega-pro'),
                        'coy' => __('Coy', 'htmega-pro'),
                        'dark' => __('Dark', 'htmega-pro'),
                        'funky' => __('Funky', 'htmega-pro'),
                        // 'okaidia' => __('Okaidia', 'htmega-pro'),
                        'solarized-light' => __('Solarized light', 'htmega-pro'),
                        // 'tomorrow' => __('Tomorrow', 'htmega-pro'),
                        // 'twilight' => __('Twilight', 'htmega-pro'),
                        'white-bg' => __('White BG', 'htmega-pro'),
                        'custom' => __('Custom Color', 'htmega-pro'),
                    ],
                ]
            );

            $this->add_control(
                'source_code',
                [
                    'label' => __('Source Code', 'htmega-pro'),
                    'type' => Controls_Manager::CODE,
                    'rows' => 20,
                    'default' => '<p class="htmega-notice">Build Beautiful Websites Faster with HT Mega Addons for Elementor Addons.</p>',
                    'placeholder' => __('Add Source Code Here...', 'htmega-pro'),
                    'condition' => [
                        'code_type!' => '',
                    ],
                ]
            );
            $this->add_control(
                'copy_button_show',
                [
                    'label' => __('Copy Button Show?', 'htmega-pro'),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'block',
                    'default' => 'block',
                    'selectors' => [
                        '{{WRAPPER}} .htmega-copy-btn .copy-to-clipboard-button'   => 'display:{{value}}',
                    ],
                    'frontend_available' => true,
                ]
                
            );
            $this->add_control(
                'copy_btn_text',
                [
                    'label' => __('Copy Button Text', 'htmega-pro'),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Copy to clipboard', 'htmega-pro'),
                    'placeholder' => __('Copy Button Text', 'htmega-pro'),
                    'condition' => [
                        'copy_button_show' => 'block',
                    ],
                ]
            );
            $this->add_control(
                'copied_button_text',
                [
                    'label' => __('After Copy Button Text', 'htmega-pro'),
                    'type' => Controls_Manager::TEXT,
                    'default' => __('Copied', 'htmega-pro'),
                    'placeholder' => __('Copied', 'htmega-pro'),
                    'condition' => [
                        'copy_button_show' => 'block',
                    ],
                ]
            );
            $this->add_control(
                'show_line_number',
                [
                    'label' => __('Line Numbers Show?', 'htmega-pro'),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );

        $this->end_controls_section();

        // Style
        $this->start_controls_section(
            'source_code_style_section',
                array(
                    'label' => __( 'Box Style', 'htmega-pro' ),
                    'tab' => Controls_Manager::TAB_STYLE,
                )
            );
            $this->add_control(
                'box_height',
                [
                    'label' => esc_html__( 'Max Height', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 500,
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'source_code_border',
                    'label' => __( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-source-code-wrap',
                    'separator'     => 'before',
                ]
            );

            $this->add_responsive_control(
                'source_code_border_radius',
                [
                    'label' => __( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-source-code-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'source_code_padding',
                [
                    'label' => __( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-source-code-wrap pre[class*=language-]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                    ],
                ]
            );
            // Custom theme option
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'source_code_background',
                    'label' => __( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-source-code-wrap pre[class*=language-]',
                    'condition' =>[
                        'theme' =>'custom',
                    ]
                ]
            );

            $this->add_control(
                'source_code_text_color',
                [
                    'label' => __( 'Text Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-source-code-wrap pre[class*=language-]' => 'color: {{VALUE}}',
                    ],
                    'condition' =>[
                        'theme' =>'custom',
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'source_code_text_typography',
                    'label' => __( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-source-code-wrap pre[class*=language-] code,{{WRAPPER}} .htmega-source-code-wrap pre[class*=language-] span',
                ]
            );
            $this->add_control(
                'source_code_number_color',
                [
                    'label' => __( 'Number Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .line-numbers-rows > span:before' => 'color: {{VALUE}}',
                    ],
                    'condition' =>[
                        'theme' =>'custom',
                        'show_line_number' =>'yes',
                    ]
                ]
            );
            $this->add_control(
                'source_code_bdrer_color',
                [
                    'label' => __( 'Border Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .line-numbers .line-numbers-rows' => 'border-color: {{VALUE}}',
                    ],
                    'condition' =>[
                        'theme' =>'custom',
                        'show_line_number' =>'yes',
                    ]
                ]
            );
        $this->end_controls_section();
        // Style Copy button tab section
        $this->start_controls_section(
            'copy_style_section',
            [
                'label' => __( 'Copy Button', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition'=>[
                    'copy_button_show'=>'block',
                    'copy_btn_text!'=>'',
                ]
            ]
            );
            $this->start_controls_tabs('copy_style_tabs');

                $this->start_controls_tab(
                    'copy_style_normal_tab',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                );

                    $this->add_control(
                        'copy_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-copy-btn .copy-to-clipboard-button' => 'color: {{VALUE}}; border-bottom: 1px solid {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'copy_typography',
                            'label' => __( 'Typography', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-copy-btn .copy-to-clipboard-button',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'copy_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-copy-btn .copy-to-clipboard-button',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'copy_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-copy-btn .copy-to-clipboard-button',
                        ]
                    );

                    $this->add_responsive_control(
                        'copy_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-copy-btn .copy-to-clipboard-button' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'copy_padding',
                        [
                            'label' => __( 'Padding', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-copy-btn .copy-to-clipboard-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_control(
                        'copy_button_position_toggle',
                        [
                            'type' =>Controls_Manager::POPOVER_TOGGLE,
                            'label' => esc_html__( 'Button Position', 'htmega-pro' ),
                            'label_off' => esc_html__( 'Default', 'htmega-pro' ),
                            'label_on' => esc_html__( 'Custom', 'htmega-pro' ),
                            'return_value' => 'yes',
                        ]
                    );
                    $this->start_popover();
            
                    $this->add_responsive_control(
                        'position_vertical',
                        [
                            'label' => __( 'Vertical Position', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 500,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-copy-btn .copy-to-clipboard-button' => 'top: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    ); 
                    $this->add_responsive_control(
                        'position_horizontal',
                        [
                            'label' => __( 'Horizontal Position', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 100,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-copy-btn .copy-to-clipboard-button' => 'right: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    ); 
    
                    $this->end_popover();
                $this->end_controls_tab(); // Normal Tab end

                $this->start_controls_tab(
                    'copy_style_hover_tab',
                    [
                        'label' => __( 'Hover', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'copy_hover_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-copy-btn .copy-to-clipboard-button:hover' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'copy_hover_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-copy-btn .copy-to-clipboard-button:hover',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'copy_hover_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-copy-btn .copy-to-clipboard-button:hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'copy_hover_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-copy-btn .copy-to-clipboard-button:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab(); // Hover Tab end

            $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render( $instance = [] ) {

        $settings   = $this->get_settings_for_display();
        $theme = $settings['theme'];
        $code_type = $settings['code_type'];

        $this->add_render_attribute( 'source_code_wrapper', 'class', "htmega-source-code-wrap htmega-copy-btn htmega-source-{$theme}" );

        $this->add_render_attribute( 'source_code_pre', 'class', "htmega-source-pre language-{$code_type}" );
        $this->add_render_attribute( 'source_code_pre', 'data-htmega', esc_attr( $settings['box_height'] ) );

        if( 'yes' == $settings['show_line_number'] ){
            $this->add_render_attribute( 'source_code_pre', 'class', " line-numbers" );
        }
        $this->add_render_attribute( 'source_code_options', 'class', "language-{$code_type}" );
        $this->add_render_attribute( 'source_code_options', 'data-lng-type', esc_attr( $code_type ) );
        $this->add_render_attribute( 'source_code_options', 'data-prismjs-copy-timeout', "5000" );
        if( 'block' == $settings['copy_button_show'] && !empty( $settings['copy_btn_text']) ){
            $this->add_render_attribute( 'source_code_options', 'data-prismjs-copy', esc_html( $settings['copy_btn_text'] ) );
            $this->add_render_attribute( 'source_code_options', 'data-prismjs-copy-success', esc_html( $settings['copied_button_text'] ) );
        }

        ?>
        <div <?php echo $this->get_render_attribute_string( 'source_code_wrapper' ); ?> >
            <pre <?php echo $this->get_render_attribute_string( 'source_code_pre' ); ?> >
                <code <?php echo $this->get_render_attribute_string( 'source_code_options' ); ?> >
                <?php echo esc_html($settings['source_code']); ?>
                </code>
            </pre>
        </div>
    <?php
    }
}

