<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Repeater;
use Elementor\HTMega_Icon_Manager;
use Elementor\Group_Control_Image_Size;


if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Team_Carousel_Element extends Widget_Base {
    public function get_name() {
        return 'htmega-team-carousel-addons';
    }
    
    public function get_title() {
        return esc_html__( 'Team Carousel', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-person';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }

    public function get_style_depends() {
        return [ 'swiper','slick' ];
    }

    public function get_script_depends() {
        return ['swiper','slick'];
    }

    public function get_keywords() {
        return [ 'htmega', 'ht mega', 'team', 'team carousel', 'team member', 'member carousel', 'agent', 'htmega pro' ];
    }

    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/general-widgets/team-carousel-widget/';
	}

    protected function register_controls() {
        $this->_general_controls();
        $this->_style_controls();
    }
    protected function is_dynamic_content():bool {
		return false;
	}
    protected function _general_controls(){
        $this->__team_carousel_preset();
        $this->__team_mambers_list();  
        $this->__team_carousel_option();  
            
    }

    //__team_carousel_preset
    protected function __team_carousel_preset(){
        $this->start_controls_section(
            'team_carousel_preset',
            [
                'label' => esc_html__( 'Team Carousel', 'htmega-pro' ),
            ]
        );

            $this->add_control(
                'team_carousel_style',
                [
                    'label' => esc_html__( 'Layout', 'htmega-pro' ),
                    'type' => 'htmega-preset-select',
                    'default' => '1',
                    'options' => [
                        '1'   => esc_html__( 'Layout One', 'htmega-pro' ),
                        '2'   => esc_html__( 'Layout Two', 'htmega-pro' ),
                        '3'   => esc_html__( 'Layout Three', 'htmega-pro' ),
                        '4'   => esc_html__( 'Layout Four', 'htmega-pro' ),
                        '5'   => esc_html__( 'Layout Five', 'htmega-pro' ),
                        '6'   => esc_html__( 'Layout Six', 'htmega-pro' ),
                    ],
                ]
            );
            
        $this->end_controls_section();
    }

    //__team_mambers_list
    protected function __team_mambers_list() {
        $this->start_controls_section(
			'team_Carousel_info',
			[
				'label' => esc_html__( 'Team Mamber', 'htmega-pro' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

            $repeater = new Repeater();

            $repeater->start_controls_tabs('members_tab' );
            $repeater->start_controls_tab(
                'info_tab',
                [
                    'label' => esc_html__( 'Information', 'htmega-pro' ),
                ]
            );

            $repeater->add_control(
                'mamber_photo',
                [
                    'label' => esc_html__( 'Mamder Photo', 'htmega-pro' ),
                    'type' => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => \Elementor\Utils::get_placeholder_image_src(),
                    ],
                ]
            );

            $repeater->add_control(
                'title',
                [
                    'label' => esc_html__( 'Name', 'htmega-pro' ),
                    'label_block' => true,
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__( 'Team Member Name', 'htmega-pro' ),
                    'placeholder' => esc_html__( 'Type Member Name', 'htmega-pro' ),
                ]
            );

            $repeater->add_control(
                'job_designation',
                [
                    'label' => esc_html__( 'Designation', 'htmega-pro' ),
                    'label_block' => true,
                    'type' => Controls_Manager::TEXT,
                    'default' => '',
                    'placeholder' => esc_html__( 'Type Member Designation', 'htmega-pro' ),
                ]
            );

            $repeater->add_control(
                'bio_info',
                [
                    'label' => esc_html__( 'Bio Info', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'placeholder' => esc_html__( 'Write Something About Your Shot Bio.', 'htmega-pro' ),
                    'rows' => 5,
                ]
            );

            $repeater->end_controls_tab();

                $repeater->start_controls_tab(
                    'social_tab',
                    [
                        'label' => esc_html__( 'Social Links', 'htmega-pro' ),
                    ]
                );

                    $repeater->add_control(
                        'show_social_links',
                        [
                            'label' => esc_html__( 'Show Social Links', 'htmega-pro' ),
                            'type' => Controls_Manager::SWITCHER,
                            'label_on' => esc_html__( 'Show', 'htmega-pro' ),
                            'label_off' => esc_html__( 'Hide', 'htmega-pro' ),
                            'return_value' => 'yes',
                            'default' => 'yes',
                            'style_transfer' => true,
                        ]
                    );


                    $repeater->add_control(
                        'facebook', [
                            'label' => esc_html__( 'Facebook', 'htmega-pro' ),
                            'type' => Controls_Manager::TEXT,
                            'placeholder' => esc_html__( 'Add Your Facebook Address', 'htmega-pro' ),
                            'input_type' => 'url',
                            'label_block' => false,
                            'condition' => [
                                'show_social_links' => 'yes'
                            ],
                        ]
                    );

                    $repeater->add_control(
                        'twitter', [
                            'label' => esc_html__( 'Twitter', 'htmega-pro' ),
                            'type' => Controls_Manager::TEXT,
                            'placeholder' => esc_html__( 'Add Your Twitter Address', 'htmega-pro' ),
                            'input_type' => 'url',
                            'label_block' => false,
                            'condition' => [
                                'show_social_links' => 'yes'
                            ],
                        ]
                    );

                    $repeater->add_control(
                        'instagram', [
                            'label' => esc_html__( 'Instagram', 'htmega-pro' ),
                            'type' => Controls_Manager::TEXT,
                            'placeholder' => esc_html__( 'Add Your Instagram Address', 'htmega-pro' ),
                            'input_type' => 'url',
                            'label_block' => false,
                            'condition' => [
                                'show_social_links' => 'yes'
                            ],
                        ]
                    );

                    $repeater->add_control(
                        'snapchat', [
                            'label' => esc_html__( 'Snapchat', 'htmega-pro' ),
                            'type' => Controls_Manager::TEXT,
                            'placeholder' => esc_html__( 'Add Your Snapchat Address', 'htmega-pro' ),
                            'input_type' => 'url',
                            'label_block' => false,
                            'condition' => [
                                'show_social_links' => 'yes'
                            ],
                        ]
                    );

                    $repeater->add_control(
                        'linkedin', [
                            'label' => esc_html__( 'LinkedIn', 'htmega-pro' ),
                            'type' => Controls_Manager::TEXT,
                            'placeholder' => esc_html__( 'Add Your LinkedIn Address', 'htmega-pro' ),
                            'input_type' => 'url',
                            'label_block' => false,
                            'condition' => [
                                'show_social_links' => 'yes'
                            ],
                        ]
                    );

                    $repeater->add_control(
                        'github', [
                            'label' => esc_html__( 'Github', 'htmega-pro' ),
                            'type' => Controls_Manager::TEXT,
                            'placeholder' => esc_html__( 'Add Your Github Address', 'htmega-pro' ),
                            'input_type' => 'url',
                            'label_block' => false,
                            'condition' => [
                                'show_social_links' => 'yes'
                            ],
                        ]
                    );


                $repeater->end_controls_tab();
            $repeater->end_controls_tabs();

            $this->add_control(
                'members_list',
                [
                    'label' => esc_html__( 'Team Members Lists', 'htmega-pro' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'title_field' => '{{{ title }}}',
                    'default' => [
                        [
                            'title' => esc_html__( 'Regan Flanders', 'htmega-pro' ),
                            'job_designation' => esc_html__( 'CEO', 'htmega-pro' ),
                            'instagram' => '#',
                            'facebook' => '#',
                            'twitter' => '#',
                            'snapchat' => '#',
                        ],
                        [
                            'title' => esc_html__( 'Jessica Watson', 'htmega-pro' ),
                            'job_designation' => esc_html__( 'Support Manager', 'htmega-pro' ),
                            'instagram' => '#',
                            'facebook' => '#',
                            'twitter' => '#',
                            'snapchat' => '#',
                        ],
                        [
                            'title' => esc_html__( 'Marchelle Needham', 'htmega-pro' ),
                            'job_designation' => esc_html__( 'Marketing Officer', 'htmega-pro' ),
                            'instagram' => '#',
                            'facebook' => '#',
                            'twitter' => '#',
                            'snapchat' => '#',
                        ],
                        [
                            'title' => esc_html__( 'Nakisha Morse', 'htmega-pro' ),
                            'job_designation' => esc_html__( 'Technical Officer', 'htmega-pro' ),
                            'instagram' => '#',
                            'facebook' => '#',
                            'twitter' => '#',
                            'snapchat' => '#',
                        ],
                    ],
                ]
            );


            $this->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'mamber_photo_thumbnail',
                    'default' => 'large',
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'align',
                [
                    'label' => esc_html__( 'Alignment', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__( 'Left', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}}' => 'text-align: {{VALUE}}',
                        '{{WRAPPER}} .htmega-team-carousel-item-content' => 'text-align: {{VALUE}}',
                        '{{WRAPPER}} .htmega-team-carousel-item-social' => 'justify-content: {{VALUE}}',
                    ],
                    'condition' => [
                        'team_carousel_style!' => ['2','4']
                    ],
                ]
            );

        $this->end_controls_section();
    }
    //__team_carousel_option
    protected function __team_carousel_option() {
         // Slider setting
         $this->start_controls_section(
            'carosul_slider_option',
            [
                'label' => esc_html__( 'Slider Options', 'htmega-pro' ),
            ]
        );

            $this->add_control(
                'slitems',
                [
                    'label' => esc_html__( 'Slider Items', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 1,
                    'max' => 20,
                    'step' => 1,
                    'default' => 3,
                ]
            );

            $this->add_control(
                'slitems_space_between',
                [
                    'label' => esc_html__( 'Slider Items Space Between', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                    'default' => 30,
                    'condition' => [
                        'team_carousel_style!'  => '6',
                    ],
                ]
            );

            $this->add_control(
                'slaut_center_slides',
                [
                    'label' => esc_html__( 'Slider Center', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' => [
                        'team_carousel_style!'  => '6',
                    ],
                ]
            );

            $this->add_control(
                'slaut_loop',
                [
                    'label' => esc_html__( 'Slider Loop', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );
            

            $this->add_control(
                'slarrows',
                [
                    'label' => esc_html__( 'Slider Arrow', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
            );

            $this->add_control(
                'slprevicon',
                [
                    'label' => esc_html__( 'Previous Icon', 'htmega-pro' ),
                    'type' => Controls_Manager::ICONS,
                    'default' => [
                        'value'=>'fas fa-angle-left',
                        'library' => 'fa-solid',
                    ],
                    'condition' => [
                        'slarrows' => 'yes',
                    ]
                ]
            );

            $this->add_control(
                'slnexticon',
                [
                    'label' => esc_html__( 'Next Icon', 'htmega-pro' ),
                    'type' => Controls_Manager::ICONS,
                    'default' => [
                        'value'=>'fas fa-angle-right',
                        'library' => 'fa-solid',
                    ],
                    'condition' => [
                        'slarrows' => 'yes',
                    ]
                ]
            );


            $this->add_control(
                'sldots',
                [
                    'label' => esc_html__( 'Slider dots', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                    'separator' => 'before',
                    'condition' => [
                        'team_carousel_style!'  => '6',
                    ],
                ]
            );

            $this->add_control(
                'sldots_style',
                [
                    'label' => esc_html__( 'Slider Dots Style', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => '2',
                    'options' => [
                        '2'   => esc_html__( 'Style One', 'htmega-pro' ),
                        '3'   => esc_html__( 'Style Two', 'htmega-pro' ),
                        '4'   => esc_html__( 'Style Three', 'htmega-pro' ),
                        '5'   => esc_html__( 'Style Four', 'htmega-pro' ),
                        '6'   => esc_html__( 'Mobile Dots Style', 'htmega-pro' ),
                    ],
                    'condition' => [
                        'sldots' => 'yes',
                        'team_carousel_style!'  => '6',
                    ]
                ]
            );

            $this->add_control(
                'slautolay',
                [
                    'label' => esc_html__( 'Slider Autoplay', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'separator' => 'before',
                    'default' => 'no',
                ]
            );
            

            $this->add_control(
                'sl_animation_speed',
                [
                    'label' => esc_html__('Animation speed', 'htmega-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 800,
                ]
            );

            $this->add_control(
                'heading_tablet',
                [
                    'label' => esc_html__( 'Tablet', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'after',
                ]
            );
            $this->add_control(
                'sltablet_display_columns',
                [
                    'label' => esc_html__('Slider Items', 'htmega-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 1,
                    'max' => 8,
                    'step' => 1,
                    'default' => 3,
                ]
            );

            $this->add_control(
                'tablet_slitems_space_between',
                [
                    'label' => esc_html__( 'Slider Items Space Between', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                    'default' => 30,
                    'condition' => [
                        'team_carousel_style!'  => '6',
                    ],
                ]
            );

            $this->add_control(
                'heading_mobile',
                [
                    'label' => esc_html__( 'Mobile Phone', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'after',
                ]
            );

            $this->add_control(
                'slmobile_display_columns',
                [
                    'label' => esc_html__('Slider Items', 'htmega-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 1,
                    'max' => 4,
                    'step' => 1,
                    'default' => 1,
                ]
            );

            $this->add_control(
                'mobile_slitems_space_between',
                [
                    'label' => esc_html__( 'Slider Items Space Between', 'htmega-pro' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                    'default' => 30,
                    'condition' => [
                        'team_carousel_style!'  => '6',
                    ],
                ]
            );
        $this->end_controls_section(); // Slider Option end
    }


    //_style_controls
    protected function _style_controls() {
        $this->_layout_controll_style();
        $this->_style_image();
        $this->__content_style();
        $this->__social_style();
        $this->_style_image_thumbnail();
        $this->__style_arrow();
        $this->__style_dot_pagination();
    }

    protected function __content_style() {
        $this->start_controls_section(
            'team_style_section',
            [
                'label' => esc_html__( 'Content Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_control(
                'content_section_heading',
                [
                    'label' => esc_html__( 'Content Section', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'condition' => [
                                'team_carousel_style!'  => '6',
                            ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'content_section_background',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-content',
                    'condition' => [
                        'team_carousel_style!'  => '6',
                    ],
                ]
            );

            $this->add_responsive_control(
                'content_section_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'team_carousel_style!'  => '6',
                    ],
                ]
            );

            $this->add_responsive_control(
                'content_section_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'team_carousel_style!'  => '6',
                    ],
                ]
            );

            $this->add_control(
                'content_section_color_corner_header',
                [
                    'label' => esc_html__( 'Content Corner Style', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'team_carousel_style' => ['1'],
                    ],
                ]
            );

            $this->add_control(
                'content_section_color_corner',
                [
                    'label' => esc_html__( 'Corner Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-team-carousel-item-1 .htmega-team-carousel-item-content::after' => 'border-color: transparent {{VALUE}} {{VALUE}} transparent',
                    ],
                    'condition' => [
                        'team_carousel_style' => ['1'],
                    ],
                ]
            );
            // for style six
            $this->add_control(
                'content_box_area_heading',
                [
                    'label' => esc_html__( 'Content Box', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'condition' => [
                                'team_carousel_style'  => '6',
                            ],
                ]
            );

            $this->add_responsive_control(
                'team_content_box_alignment',
                [
                    'label' => esc_html__( 'Content Alignment', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__( 'Left', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-team-content-wrapper' => 'text-align: {{VALUE}};',
                        '{{WRAPPER}} .htemga-pro-slider-for .htmega-team-carousel-item-social' => 'justify-content: {{VALUE}};',
                    ],
                ]
            );
            $this->add_control(
                'team_title_heading',
                [
                    'label' => esc_html__( 'Title', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-title' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-title',
                ]
            );

            $this->add_responsive_control(
                'title_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'team_designation_heading',
                [
                    'label' => esc_html__( 'Designation', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'team_designation_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-designation' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'team_designation_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-designation',
                ]
            );

            $this->add_responsive_control(
                'team_designation_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-designation' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'team_carousel_style!'  => '6',
                    ],
                ]
            );


            $this->add_control(
                'team_bio_info_heading',
                [
                    'label' => esc_html__( 'Bio Info', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'team_bio_info_color',
                [
                    'label' => esc_html__( 'Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-bio-info' => 'color: {{VALUE}}',
                    ],
                ]
            );


            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'team_bio_info_typography',
                    'label' => esc_html__( 'Typography', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-bio-info',
                ]
            );

            $this->add_responsive_control(
                'team_bio_info_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-bio-info' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'hover_after_heading',
                [
                    'label' => esc_html__( 'Hover Opacity Color', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'team_carousel_style' => ['2','4'],
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'hover_after_color',
                    'types' => [ 'classic','gradient'],
                    'selector' => '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-thumb::after',
                    'condition' => [
                        'team_carousel_style' => ['2','4'],
                    ],
                ]
            );

            $this->add_control(
                'hover_before_heading',
                [
                    'label' => esc_html__( 'Item Hover Background Image', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'team_carousel_style' => ['2'],
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'hover_before_background',
                    'types' => [ 'classic' ],
                    'selector' => '{{WRAPPER}} .htmega-team-carousel-item::before',
                    'condition' => [
                        'team_carousel_style' => ['2'],
                    ],
                ]
            );

            $this->add_control(
                'hover_after_border_heading',
                [
                    'label' => esc_html__( 'Hover After Border', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'team_carousel_style' => ['5'],
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'hover_after_border',
                    'selector' => '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-thumb::after',
                    'condition' => [
                        'team_carousel_style' => ['5'],
                    ],
                ]
            );

            $this->add_responsive_control(
                'hover_after_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-thumb::after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'team_carousel_style' => ['5'],
                    ],
                ]
            );

        $this->end_controls_section();
    }
    protected function __social_style() {
        $this->start_controls_section(
            'social_style',
            [
                'label' => esc_html__( 'Social Icons', 'htmega-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_control(
                'social_icon_section_heading',
                [
                    'label' => esc_html__( 'Social Icon Section', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'condition' => [
                        'team_carousel_style!'  => '6',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'social_icon_section_background',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-social',
                    'condition' => [
                        'team_carousel_style!'  => '6',
                    ],
                ]
            );

            $this->add_responsive_control(
                'social_icon_section_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-social' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'team_carousel_style!'  => '6',
                    ],
                ]
            );

            $this->add_responsive_control(
                'social_icon_section_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-social' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'social_icon_heading',
                [
                    'label' => esc_html__( 'Icons', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'team_carousel_style!'  => '6',
                    ],
                ]
            );
            $this->add_responsive_control(
                'social_icons_spacing',
                [
                    'label' => esc_html__( 'Spacing', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-social' => 'gap: {{SIZE}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'social_icon_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-social-icon' => 'padding: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'social_icon_size',
                [
                    'label' => esc_html__( 'Icon Size', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-social-icon' => 'font-size: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'social_icon_colors_and_borders',
                [
                    'label' => esc_html__( 'Colors & Border', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $this->start_controls_tabs( 'social_icon_colors' );
            $this->start_controls_tab(
                'social_icon_normal',
                [
                    'label' => esc_html__( 'Normal', 'htmega-pro' ),
                ]
            );

                $this->add_control(
                    'social_icon_color',
                    [
                        'label' => esc_html__( 'Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-social-icon' => 'color: {{VALUE}}',
                        ],
                    ]
                );

                $this->add_control(
                    'social_icon_bg_color',
                    [
                        'label' => esc_html__( 'Background Color', 'htmega-pro' ),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-social-icon' => 'background-color: {{VALUE}}',
                        ],
                    ]
                );
                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'social_icon_border',
                        'selector' => '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-social-icon'
                    ]
                );
    
                $this->add_responsive_control(
                    'social_icon_border_radius',
                    [
                        'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-social-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                    ]
                );
                $this->end_controls_tab();
                    $this->start_controls_tab(
                        'social_icon_hover',
                        [
                            'label' => esc_html__( 'Hover', 'htmega-pro' ),
                        ]
                    );

                    $this->add_control(
                        'social_icon_hover_color',
                        [
                            'label' => esc_html__( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-social-icon:hover, {{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-social-icon:focus' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_control(
                        'social_icon_hover_bg_color',
                        [
                            'label' => esc_html__( 'Background Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-social-icon:hover, {{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-social-icon:focus' => 'background-color: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'social_icon_border_hover',
                            'selector' => '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-social-icon:hover'
                        ]
                    );
        
                    $this->add_responsive_control(
                        'social_icon_border_radius_hover',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-team-carousel-item .htmega-team-carousel-item-social-icon:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();

	}

    protected function __style_arrow(){
        // Style arrow style start
        $this->start_controls_section(
            'htmega_team_arrow_style',
            [
                'label'     => esc_html__( 'Arrow', 'htmega-pro' ),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' =>[
                    'slarrows'  => 'yes',
                ],
            ]
        );
        $this->add_control(
            'arrow_position',
            [
                'label' => __('Alignment', 'htmega-pro'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'htmega-pro'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'htmega-pro'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'htmega-pro'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => false,
                'condition' =>[
                    'team_carousel_style'  => '6',
                ],
            ]
        );
        $this->add_responsive_control(
            'htmega_team_arrow_height',
            [
                'label' => esc_html__( 'Height', 'htmega-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-team-swiper-button-prev, {{WRAPPER}} .htmega-team-swiper-button-next,{{WRAPPER}} .htemga-pro-slider-nav .slick-arrow' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'htmega_team_arrow_width',
            [
                'label' => esc_html__( 'Width', 'htmega-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-team-swiper-button-prev, {{WRAPPER}} .htmega-team-swiper-button-next,{{WRAPPER}} .htemga-pro-slider-nav .slick-arrow' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'htmega_team_arrow_fontsize',
            [
                'label' => esc_html__( 'Icon Size', 'htmega-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-team-swiper-button-prev, {{WRAPPER}} .htmega-team-swiper-button-next, {{WRAPPER}} .htemga-pro-slider-nav .slick-arrow' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .htmega-team-swiper-button-prev svg, {{WRAPPER}} .htmega-team-swiper-button-next svg, {{WRAPPER}} .htemga-pro-slider-nav .slick-arrow svg' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'htmega_team_arrow_position',
            [
                'label' => esc_html__( 'Vertical Position', 'htmega-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-team-swiper-button-prev, {{WRAPPER}} .htmega-team-swiper-button-next' => 'top: {{SIZE}}{{UNIT}};',
                ],
                'separator' =>'before',
                'condition' =>[
                    'team_carousel_style!'  => '6',
                ],
            ]
        );

        $this->add_responsive_control(
            'htmega_team_arrow_position_x',
            [
                'label' => esc_html__( 'Horizontal Position', 'htmega-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-team-swiper-button-prev' => 'right: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .htmega-team-swiper-button-next' => 'left: {{SIZE}}{{UNIT}};',
                ],
                'condition' =>[
                    'team_carousel_style!'  => '6',
                ],
            ]
        );
        $this->add_responsive_control(
            'htmega_team_arrow_inner_space',
            [
                'label' => esc_html__( 'Innter Space', 'htmega-pro' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-pro-tcsl-position-left .slick-next.slick-arrow' => 'left: {{SIZE}}px;',
                    '{{WRAPPER}} .htmega-pro-tcsl-position-right .slick-prev.slick-arrow' => 'right: {{SIZE}}px;',
                    '{{WRAPPER}} .htmega-pro-tcsl-position-center .slick-next.slick-arrow' => 'margin-left: {{SIZE}}px;',
                    '{{WRAPPER}} .htmega-pro-tcsl-position-center .slick-prev.slick-arrow' => 'margin-left: -{{SIZE}}px;',
                ],
                'condition' =>[
                    'team_carousel_style'  => '6',
                ],
            ]
        );

        $this->add_responsive_control(
            'arrow_nav_hide_on',
            [
                'label' => esc_html__( 'Hide Arrow', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'none',
                'description' => esc_html__('Toggle this switch to hide the arrow button on responsive devices.','htmega-pro'),
                'separator' => 'before',
                'default' => 'flex',
                'selectors' => [
                    '{{WRAPPER}} .htemga-pro-slider-nav .slick-arrow, {{WRAPPER}} .htmega-team-swiper-button-prev, {{WRAPPER}} .htmega-team-swiper-button-next' => 'display: {{VALUE}}!important',
                ],
                'tablet_default' => 'flex',
                'mobile_default' => 'none',
            ]
        );
        $this->add_control(
            'arrow_border_color_heading',
            [
                'label' => __( 'Colors and Border', 'htmega-pro' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
            $this->start_controls_tabs( 'team_arrow_style_tabs' );

                // Normal tab Start
                $this->start_controls_tab(
                    'team_arrow_style_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'htmega_team_arrow_color',
                        [
                            'label' => esc_html__( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .htmega-team-swiper-button-prev, {{WRAPPER}} .htmega-team-swiper-button-next,
                                {{WRAPPER}} .htemga-pro-slider-nav .slick-arrow,{{WRAPPER}} .htemga-pro-slider-nav .slick-arrow::after' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-team-swiper-button-prev svg path,
                                {{WRAPPER}} .htmega-team-swiper-button-next svg path,
                                {{WRAPPER}} .htemga-pro-slider-nav .slick-arrow svg path' => 'fill: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'team_arrow_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-team-swiper-button-prev, {{WRAPPER}} .htmega-team-swiper-button-next,{{WRAPPER}} .htemga-pro-slider-nav .slick-arrow',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'htmega_team_arrow_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-team-swiper-button-prev, {{WRAPPER}} .htmega-team-swiper-button-next,{{WRAPPER}} .htemga-pro-slider-nav .slick-arrow',
                        ]
                    );

                    $this->add_responsive_control(
                        'htmega_team_arrow_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-team-swiper-button-prev, {{WRAPPER}} .htmega-team-swiper-button-next, {{WRAPPER}} .htemga-pro-slider-nav .slick-arrow' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab(); // Normal tab end

                // Hover tab Start
                $this->start_controls_tab(
                    'team_arrow_style_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'htmega-pro' ),
                    ]
                );

                    $this->add_control(
                        'htmega_team_arrow_hover_color',
                        [
                            'label' => esc_html__( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '#ffffff',
                            'selectors' => [
                                '{{WRAPPER}} .htmega-team-swiper-button-prev:hover, {{WRAPPER}} .htmega-team-swiper-button-next:hover,
                                {{WRAPPER}} .htemga-pro-slider-nav .slick-arrow:hover' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-team-swiper-button-prev:hover svg path,
                                {{WRAPPER}} .htmega-team-swiper-button-next:hover svg path,
                                {{WRAPPER}} .htemga-pro-slider-nav .slick-arrow:hover svg path' => 'fill: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'team_arrow_hover_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-team-swiper-button-prev:hover, {{WRAPPER}} .htmega-team-swiper-button-next:hover,{{WRAPPER}} .htemga-pro-slider-nav .slick-arrow:hover',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'htmega_team_arrow_hover_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-team-swiper-button-prev:hover, {{WRAPPER}} .htmega-team-swiper-button-next:hover,{{WRAPPER}} .htemga-pro-slider-nav .slick-arrow:hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'htmega_team_arrow_hover_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-team-swiper-button-prev:hover, {{WRAPPER}} .htmega-team-swiper-button-next:hover,{{WRAPPER}} .htemga-pro-slider-nav .slick-arrow:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab(); // Hover tab end

            $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function __style_dot_pagination(){
        // Style Dots style start
        $this->start_controls_section(
            'htmega_pagination_dots_style',
            [
                'label'     => esc_html__( 'Pagination Dot', 'htmega-pro' ),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' =>[
                    'sldots'  => 'yes',
                ],
            ]
        );
            
            $this->start_controls_tabs( 'pagination_dots_style_tabs' );

                // Normal tab Start
                $this->start_controls_tab(
                    'pagination_dots_style_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'htmega-pro' ),
                    ]
                );

                    $this->add_responsive_control(
                        'pagination_dots_pagination_align',
                        [
                            'label' => esc_html__( 'Alignment', 'htmega-pro' ),
                            'type' => Controls_Manager::CHOOSE,
                            'options' => [
                                'left' => [
                                    'title' => esc_html__( 'Left', 'htmega-pro' ),
                                    'icon' => 'eicon-text-align-left',
                                ],
                                'center' => [
                                    'title' => esc_html__( 'Center', 'htmega-pro' ),
                                    'icon' => 'eicon-text-align-center',
                                ],
                                'right' => [
                                    'title' => esc_html__( 'Right', 'htmega-pro' ),
                                    'icon' => 'eicon-text-align-right',
                                ],
                            ],
                            'default' => 'center',
                            'selectors' => [
                                '{{WRAPPER}} .htmega-team-carousel-wrap .swiper-pagination-bullets' => 'text-align: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'pagination_dots_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-team-carousel-wrap .swiper-pagination-bullet',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'htmega_pagination_dots_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-team-carousel-wrap .swiper-pagination-bullet',
                        ]
                    );

                    $this->add_responsive_control(
                        'htmega_pagination_dots_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-team-carousel-wrap .swiper-pagination-bullet' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                    $this->add_responsive_control(
                        'htmega_pagination_dots_height',
                        [
                            'label' => esc_html__( 'Height', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-team-carousel-wrap .swiper-pagination-bullet' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );

                    $this->add_responsive_control(
                        'htmega_pagination_dots_width',
                        [
                            'label' => esc_html__( 'Width', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 200,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-team-carousel-wrap .swiper-pagination-bullet' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );

                    $this->add_responsive_control(
                        'htmega_pagination_dots_pagination_margin',
                        [
                            'label' => esc_html__( 'Margin', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-team-carousel-wrap .swiper-pagination-bullet' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );

                $this->end_controls_tab(); // Normal tab end

                // Hover tab Start
                $this->start_controls_tab(
                    'pagination_dots_style_hover_tab',
                    [
                        'label' => esc_html__( 'Active', 'htmega-pro' ),
                    ]
                );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'pagination_dots_hover_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-team-carousel-wrap .swiper-pagination-bullet-active',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'htmega_pagination_dots_hover_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-team-carousel-wrap .swiper-pagination-bullet-active',
                        ]
                    );

                    $this->add_responsive_control(
                        'htmega_pagination_dots_hover_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-team-carousel-wrap .swiper-pagination-bullet-active' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                    $this->add_responsive_control(
                        'htmega_pagination_dots_width_active',
                        [
                            'label' => esc_html__( 'Width', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 100,
                                    'step' => 1,
                                ],
                                'default' => [
                                    'unit' => 'px',
                                    'size' => 45,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-team-swiper-pagination-4 .swiper-pagination-bullet-active' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' =>[
                                'sldots_style'  => '4',
                            ],
                        ]
                    );

                $this->end_controls_tab(); // Hover tab end

            $this->end_controls_tabs();

        $this->end_controls_section(); // Style dots style end
    }
    protected function _style_image(){
        // Style Dots style start
        $this->start_controls_section(
            'htmega_image_style',
            [
                'label'     => esc_html__( 'Image', 'htmega-pro' ),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'team_carousel_style'  => '6',
                ],
            ]
        );
            $this->add_responsive_control(
                'big_image_box_height',
                [
                    'label' => esc_html__( 'Image Box Height', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htemga-pro-slider-for .htmega-team-carousel-item-thumb' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'big_image_box_background',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'exclude' => ['image'],
                    'selector' => '{{WRAPPER}} .htemga-pro-slider-for .htmega-team-carousel-item-thumb',
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'htmega_big_image_box_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htemga-pro-slider-for .htmega-team-carousel-item-thumb',
                ]
            );

            $this->add_responsive_control(
                'htmega_big_image_box_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htemga-pro-slider-for .htmega-team-carousel-item-thumb' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );

            $this->add_responsive_control(
                'big_image_box_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htemga-pro-slider-for .htmega-team-carousel-item-thumb' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section(); // Style dots style end
    }
    protected function _style_image_thumbnail(){
        // Style Dots style start
        $this->start_controls_section(
            'htmega_image_thumbnail_style',
            [
                'label'     => esc_html__( 'Slider Thumbnails', 'htmega-pro' ),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'team_carousel_style'  => '6',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_thumbnail_inner_space',
            [
                'label' => esc_html__( 'Column Gap', 'htmega-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px'],
                'description' => __('This Column gap value shows in multiplying 2', 'htmega-pro'),
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .htemga-pro-slider-nav .slick-list' => 'margin: 0 -{{SIZE}}px',
                    '{{WRAPPER}} .htemga-pro-slider-nav .slick-slide' => 'padding-left:{{SIZE}}px;padding-right: {{SIZE}}px',
                ],
            ]
        );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'htmega_thumbnail_image_box_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htemga-pro-slider-nav-thumb img',
                ]
            );
            $this->add_responsive_control(
                'htmega_thumb_image_box_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htemga-pro-slider-nav-thumb img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );
            $this->add_control(
                'tmega_thumb_image_box_border_hover_color',
                [
                    'label' => esc_html__( 'Active Border Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .slick-active.slick-center .htemga-pro-slider-nav-thumb img' => 'border-color: {{VALUE}};'
                    ],
                ]
            );
            $this->add_responsive_control(
                'slide_nav_hide_on',
                [
                    'label' => esc_html__( 'Hide Thumbnail Slider', 'htmega-pro' ),
                    'description' => esc_html__('Toggle this switch to hide the Slider on responsive devices.','htmega-pro'),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'none',
                    'separator' => 'before',
                    'default' => 'block',
                    'selectors' => [
                        '{{WRAPPER}} .htemga-pro-slider-nav .slick-list' => 'display: {{VALUE}}',
                    ],
                    'tablet_default' => 'none', // Default value for tablet
                    'mobile_default' => 'none', // Default value for mobile
                ]
            );

            $this->add_responsive_control(
                'carousel_wrapper_space_from_bottom',
                [
                    'label' => esc_html__( 'Slider Bottom Space', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => '%',
                        'size' => '',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-team-carousel-wrap' => 'padding-bottom: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
        $this->end_controls_section(); // Style dots style end
    }
    protected function _layout_controll_style(){
        $this->start_controls_section(
            'layout_control_style',
            [
                'label' => esc_html__( 'Layout Control Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'team_carousel_style'  => '6',
                ],
            ]
        );
        $this->add_responsive_control(
            'big_image_box_width',
            [
                'label' => esc_html__( 'Image Width', 'htmega-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                // 'default' => [
                //     'unit' => '%',
                //     'size' => '40',
                // ],
                'selectors' => [
                    '{{WRAPPER}} .htemga-pro-slider-for .htmega-team-carousel-item-thumb' => 'width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .htmega-team-content-wrapper' => 'width:calc( 100% - {{SIZE}}{{UNIT}} );',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_box_area_width',
            [
                'label' => esc_html__( 'Content Box Width', 'htmega-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-team-content-wrapper' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' =>[
                    'team_carousel_style'  => '6',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_thumbnail_box_width',
            [
                'label' => esc_html__( 'Thumbnail Box Width', 'htmega-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .htemga-pro-slider-nav' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_thumbnail_box_space',
            [
                'label' => esc_html__( 'Thumbnail Box Space Top', 'htmega-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -200,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .htemga-pro-slider-nav' => 'bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section(); // layout controll style
    }

    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();
        $id         = esc_attr( $this->get_id() );

        $style_three_class = "";
        if($settings['team_carousel_style'] == "3"){
            $style_three_class = "htmega-team-carousel-slider-active-3";
        }
        
        $this->add_render_attribute( 'swiperslider_area_attr', 'class', 'htmega-team-carousel-slider-active swiper ' . esc_attr( $style_three_class ) );
        
        $pagination = "";
        $pagination_mobile = "";
        if($settings["sldots_style"] == "6"){
            $pagination = "";
            $pagination_mobile = "-1";
        }else{
            $pagination = "-".$settings["sldots_style"];
            $pagination_mobile = "";
        }


        $slider_settings = [
            'arrows' => ('yes' === $settings['slarrows']),
            'arrow_prev_txt' => ".htmega-team-button-prev-".$id,
            'arrow_next_txt' => ".htmega-team-button-next-".$id,
            'dots_style' => ".swiper-pagination".esc_attr( $pagination ),
            'autoplay' => ('yes' === $settings['slautolay']),
            'autoplay_speed' => absint($settings['sl_animation_speed']),
            'loop' => ('yes' === $settings['slaut_loop']),
        ];


        $slider_responsive_settings = [
            'display_columns' => absint( $settings['slitems'] ),
            'slaut_center_slides' => ('yes' === $settings['slaut_center_slides']),
            'slitems_space_between' => absint( $settings['slitems_space_between'] ),
            'tablet_display_columns' => absint( $settings['sltablet_display_columns'] ),
            'tablet_slitems_space_between' => absint( $settings['tablet_slitems_space_between'] ),
            'mobile_display_columns' => absint( $settings['slmobile_display_columns'] ),
            'mobile_slitems_space_between' => absint( $settings['mobile_slitems_space_between'] ),
        ];
        if ( "6" == $settings['team_carousel_style'] ) {
            $slider_settings['arrowNext'] = HTMega_Icon_manager::render_icon( $settings['slnexticon'], [ 'aria-hidden' => 'true' ] );
            $slider_settings['arrowPrev'] = HTMega_Icon_manager::render_icon( $settings['slprevicon'], [ 'aria-hidden' => 'true' ] );
        }


        $slider_settings = array_merge( $slider_settings, $slider_responsive_settings );
        $this->add_render_attribute( 'swiperslider_area_attr', 'data-settings', wp_json_encode( $slider_settings ) );
        $this->add_render_attribute( 'slick_slider_area_attr', 'class', 'htemga-pro-slider-for' );
        $this->add_render_attribute( 'slick_slider_area_attr', 'data-settings', wp_json_encode( $slider_settings ) );
        $s_display_none = ( !empty( $settings['team_carousel_style'] ) ) ? ' style="display:none;"' : '';
        ?>
        
        <!-- Team Carousel Start -->
            <div class="htmega-team-carousel-wrap htmega-carousel-wrap<?php echo esc_attr( $pagination_mobile ) ?> htmega-team-carousel-st-<?php echo esc_attr( $settings['team_carousel_style'] ); ?>">
                

                <?php if ( "6" == $settings['team_carousel_style'] ) : ?>

                    <div <?php echo $this->get_render_attribute_string( 'slick_slider_area_attr' ).$s_display_none; ?>>

                        <?php foreach( $settings["members_list"] as $member ): ?>
                            <!-- Team Single -->
                            <div class="htmega-team-carousel-item">
                                    <?php $this->member_image_render($member, $settings['mamber_photo_thumbnail_size']); ?>
                                <div class="htmega-team-content-wrapper">
                                    <div class="thumb-personal-info">
                                        <?php if(!empty($member["title"])): ?>
                                            <h3 class="htmega-team-carousel-item-title"><?php echo esc_html( $member["title"] ) ?></h3>
                                        <?php endif; //end show title ?>
                                            <?php 
                                            if(!empty($member["job_designation"])): ?>
                                                <div class="htmega-team-carousel-item-designation"><?php echo esc_html( $member["job_designation"] ) ?></div>
                                            <?php endif; ?>
                                            <?php
                                                $this->team_social_list_render($member); 
                                            ?>
                                        <?php 
                                    if(!empty($member["bio_info"])): ?>
                                            <div class="htmega-team-carousel-bio-info"><?php echo esc_html( $member["bio_info"] ) ?></div>
                                        <?php 
                                        endif; 
                                        ?>

                                    </div>
                                </div>
                            </div>
                            <!-- Team Single end -->                                                
                            <?php endforeach; // while have_posts ?>
                        </div>

                        <!--Thumb Area Start -->
                        <div class="slider htemga-pro-slider-nav <?php echo esc_attr( $id .' htmega-pro-tcsl-position-' . $settings['arrow_position'] ); ?>" <?php echo $s_display_none; ?>>
                        <?php foreach($settings["members_list"] as $member): 
                            
                            $image = wp_get_attachment_image_url( $member['mamber_photo']['id'], $settings['mamber_photo_thumbnail_size'] );
                            if ( ! $image ) {
                                $image = $member['mamber_photo']['url'];
                            }
                            ?>
                            <div class="htemga-pro-slider-nav-thumb">
                                <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $member['title'] ); ?>">
                            </div>
                            <?php endforeach?>
                        </div>
                <?php else:  ?> <!-- start style 6 -->
                    <div <?php echo $this->get_render_attribute_string( 'swiperslider_area_attr' ).$s_display_none; ?>>
                        <div class="swiper-wrapper">
                            
                            <?php foreach($settings["members_list"] as $member): ?>

                                <div class="swiper-slide">
                                    <div class="htmega-team-carousel-item htmega-team-carousel-item-<?php echo esc_attr( $settings["team_carousel_style"] ) ?>">
                                        
                                        <?php if($settings["team_carousel_style"] == "1"){ ?>
                                            <?php $this->member_image_render($member, $settings['mamber_photo_thumbnail_size']); ?>
                                            <div class="htmega-team-carousel-item-content">
                                                <?php $this->member_information_render($member) ?>
                                            </div>
                                            <div class="htmega-team-carousel-item-content htmega-team-carousel-item-content-hover">
                                                <?php
                                                    $this->member_information_render($member);
                                                    $this->team_social_list_render($member); 
                                                ?> 
                                            </div>                                
                                        <?php }else if($settings["team_carousel_style"] == "2" || $settings["team_carousel_style"] == "5"){ ?>
                                            <!-- Style 2 -->
                                            <div class="htmega-team-carousel-item-thumb">
                                                <?php 
                                                    $this->member_image_render($member, $settings['mamber_photo_thumbnail_size']); 
                                                    // Social Network Link
                                                    $this->team_social_list_render($member); 
                                                ?>
                                            </div>
                                            <div class="htmega-team-carousel-item-content">
                                                <!-- Member Information -->
                                                <?php  $this->member_information_render($member); ?>
                                            </div>
                                        <?php }else if($settings["team_carousel_style"] == "3" || $settings["team_carousel_style"] == "4"){ ?>
                                            <!-- Style 3 -->
                                            <div class="htmega-team-carousel-item-thumb">
                                                <?php $this->member_image_render($member, $settings['mamber_photo_thumbnail_size']); ?>
                                            </div>
                                            <div class="htmega-team-carousel-item-content">
                                            <?php 
                                                // Member Information
                                                $this->member_information_render($member);
                                                // Social Network Link
                                                $this->team_social_list_render($member); 
                                            ?> 
                                            </div>
                                        
                                        <?php } ?>

                                    </div>
                                </div>
                            <?php endforeach ?>

                        </div>
                    </div>
                    <!-- pagination -->
                    <?php if($settings["sldots"] == "yes"): ?>
                        <div class="htmega-team-swiper-pagination<?php echo esc_attr($pagination) ?> swiper-pagination<?php echo esc_attr($pagination) ?>"></div>
                    <?php endif;
                    
                    if($settings["slarrows"] == "yes"): ?>
                        <!-- If we need navigation buttons -->
                        <div class="htmega-team-swiper-button-prev htmega-team-button-prev-<?php echo esc_attr( $id  ) ?>">
                            <?php echo HTMega_Icon_manager::render_icon( $settings['slnexticon'], [ 'aria-hidden' => 'true' ] ) ?>
                        </div>
                        <div class="htmega-team-swiper-button-next htmega-team-button-next-<?php echo esc_attr( $id  ) ?>">
                            <?php echo HTMega_Icon_manager::render_icon( $settings['slprevicon'], [ 'aria-hidden' => 'true' ] ) ?>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
    <?php
        
    }

    //member_image_render
    protected function member_image_render($member, $image_size){
        //Image Process
        $image = wp_get_attachment_image_url( $member['mamber_photo']['id'], $image_size );
        if ( ! $image ) {
            $image = $member['mamber_photo']['url'];
        }

        if($image):?>
            <div class="htmega-team-carousel-item-thumb"><img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $member['title'] ); ?>"></div>
        <?php endif;
    }

    //member_information_render
    protected function member_information_render($member){
        //Mamber Title
        if(!empty($member["title"])): ?>
            <h3 class="htmega-team-carousel-item-title"> <span><?php echo esc_html( $member["title"] ) ?></span></h3>
        <?php endif;

        //Mamber Designation
        if(!empty($member["job_designation"])): ?>
            <div class="htmega-team-carousel-item-designation"><span><?php echo esc_html( $member["job_designation"] ) ?></span></div>
        <?php endif; 

        //Mamber Designation
        if(!empty($member["bio_info"])): ?>
            <div class="htmega-team-carousel-bio-info"><span><?php echo esc_html( $member["bio_info"] ) ?></span></div>
        <?php 
        endif; 
    }
    
    //team_social_list_render
    protected function team_social_list_render($member){?>
        
        <?php if($member['show_social_links'] == "yes"): ?>
        
            <ul class="htmega-team-carousel-item-social">
            
                <!-- facebook -->
                <?php if(!empty($member["facebook"])): ?>
                    <li class="htmega-team-carousel-item-social-list">
                        <a href="<?php echo esc_url( $member["facebook"] ) ?>" class="htmega-team-carousel-item-social-icon"><i aria-hidden="true" class="fab fa-facebook"></i></a>
                    </li>
                <?php endif;

                // twitter
                if(!empty($member["twitter"])): ?>
                    <li class="htmega-team-carousel-item-social-list">
                        <a href="<?php echo esc_url( $member["twitter"] ) ?>" class="htmega-team-carousel-item-social-icon"><i aria-hidden="true" class="fab fa-x-twitter"></i></a>
                    </li>
                <?php endif;

                //instagram
                if(!empty($member["instagram"])): ?>
                    <li class="htmega-team-carousel-item-social-list">
                        <a href="<?php echo esc_url( $member["instagram"] ) ?>" class="htmega-team-carousel-item-social-icon"><i aria-hidden="true" class="fab fa-instagram"></i></a>
                    </li>
                <?php endif;

                // snapchat
                if(!empty($member["snapchat"])): ?>
                    <li class="htmega-team-carousel-item-social-list">
                        <a href="<?php echo esc_url( $member["snapchat"] ) ?>" class="htmega-team-carousel-item-social-icon"><i aria-hidden="true" class="fab fa-snapchat"></i></a>
                    </li>
                <?php endif;

                // linkedin
                if(!empty($member["linkedin"])): ?>
                    <li class="htmega-team-carousel-item-social-list">
                        <a href="<?php echo esc_url( $member["linkedin"] ) ?>" class="htmega-team-carousel-item-social-icon"><i aria-hidden="true" class="fab fa-linkedin"></i></a>
                    </li>
                <?php endif;

                // github
                if(!empty($member["github"])): ?>
                    <li class="htmega-team-carousel-item-social-list">
                        <a href="<?php echo esc_url( $member["github"] ) ?>" class="htmega-team-carousel-item-social-icon"><i aria-hidden="true" class="fab fa-github"></i></a>
                    </li>
                <?php endif ?>
            </ul>
    <?php 
        endif;
    }
}