<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\HTMega_Icon_Manager;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Threesixty_Rotation_Element extends Widget_Base {
    public function get_name() {
        return 'htmega-threesixty-rotation-addons';
    }
    
    public function get_title() {
        return __( '360 Rotation', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon htmega-threesixty-rotation-img';
    }

    public function get_categories() {
        return [ 'htmegapro-addons' ];
    }

    public function get_script_depends() {

        return [ 'circlr' ]; 
    }

    public function get_keywords() {
        return [ 'htmega', 'ht mega', '360 rotation', 'image rotation','threesixty rotation', 'product rotation','htmega pro'];
    }
    
    public function get_custom_help_url() {
		return 'https://wphtmega.com/docs/';
	}
    protected function is_dynamic_content():bool {
		return false;
	}
    protected function register_controls() {

        // Content Images
        $this->start_controls_section(
            'content_section',
                [
                    'label' => __( '360 Rotation', 'htmega-pro' ),
                ]
            );
            
            $this->add_control(
                'images',
                [
                    'label' => __('Rotation Images', 'htmega-pro'),
                    'type' => Controls_Manager::GALLERY,
                    'default' => [
                        [
                            'url' => Utils::get_placeholder_image_src(),
                        ]
                    ],
                ]
            );

        $this->end_controls_section();
        // Settings
        $this->start_controls_section(
            'settings_section',
                [
                    'label' => __( 'Settings', 'htmega-pro' ),
                ]
            );
            
            $this->add_control(
                'play_option',
                [
                    'label' => __('Play Option', 'htmega-pro'),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'play_button',
                    'options' => [
                        'autoplay' => __('Auto Play', 'htmega-pro'),
                        'play_button' => __('Play Button', 'htmega-pro'),
                        'none' => __('None', 'htmega-pro'),
                    ],
                ]
            );
            $this->add_control(
                'play_icon',
                [
                    'label'         => esc_html__( 'Play Icon', 'htmega-pro' ),
                    'type'          => Controls_Manager::ICONS,
                    'condition' => [
                        'play_option' => 'play_button',
                    ]
                ]
            );
            $this->add_control(
                'play_speed',
                [
                    'label' => __('Speed', 'htmega-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 100,
                    'condition' => [
                        'play_option' => array('autoplay','play_button'),
                    ]
                ]
            );

            $this->add_control(
                'image_shadow_show',
                [
                    'label' => __('Show Image Shadow', 'htmega-pro'),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
            $this->add_control(
                'image_shadow',
                [
                    'label' => __( 'Shadow Background Image', 'htmega-pro' ),
                    'type' => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => HTMEGA_ADDONS_PL_URL_PRO.'/assets/images/360-rotation-shap1.png',
                    ],
                    'condition' =>[
                        'image_shadow_show' =>'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'shadow_image_width',
                [
                    'label' => __( 'Image Width', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    // 'default' => [
                    //     'unit' => 'px',
                    //     'size' => 23,
                    // ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-360-rotation-wrap .htmega-360-rotation-shap' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' =>[
                        'image_shadow_show' =>'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'image_shadow_vertical',
                [
                    'label' => __( 'Vertical Position', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => -100,
                            'max' => 100,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => -100,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-360-rotation-wrap .htmega-360-rotation-shap' => 'bottom: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' =>[
                        'image_shadow_show' =>'yes'
                    ]
                ]
            );

        $this->end_controls_section();

        // Style
        $this->start_controls_section(
            'rotation_style_section',
                array(
                    'label' => __( 'Box Style', 'htmega-pro' ),
                    'tab' => Controls_Manager::TAB_STYLE,
                )
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'rotation_border',
                    'label' => __( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-threesixty-rotation-wrap',
                    'separator'     => 'before',
                ]
            );

            $this->add_responsive_control(
                'rotation_border_radius',
                [
                    'label' => __( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-threesixty-rotation-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'rotation_padding',
                [
                    'label' => __( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-threesixty-rotation-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'rotation_background',
                    'label' => __( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-threesixty-rotation-wrap',
                ]
            );


        $this->end_controls_section();
        // Style button tab section
        $this->start_controls_section(
            'button_style_section',
            [
                'label' => __( 'Button', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition'=>[
                    'play_option'=> 'play_button',
                ]
            ]
            );
            $this->start_controls_tabs('rotation_button_style_tabs');

                $this->start_controls_tab(
                    'rotation_button_style_normal_tab',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                );

                    $this->add_control(
                        'rotation_button_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-360-rotation-wrap .htmega-360-rotation-autoplay svg path' => 'fill: {{VALUE}};',
                                '{{WRAPPER}} .htmega-360-rotation-wrap .htmega-360-rotation-autoplay i' => 'color: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'rotation_button_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-360-rotation-wrap .htmega-360-rotation-autoplay',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'rotation_button_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-360-rotation-wrap .htmega-360-rotation-autoplay',
                        ]
                    );

                    $this->add_responsive_control(
                        'rotation_button_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-360-rotation-wrap .htmega-360-rotation-autoplay' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'button_width',
                        [
                            'label' => __('Icon Box Width', 'htmega-pro'),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px'],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 200,
                                    'step' => 1,
                                ]
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 60,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-360-rotation-wrap .htmega-360-rotation-autoplay' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'button_height',
                        [
                            'label' => __('Icon Box Height', 'htmega-pro'),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 200,
                                    'step' => 1,
                                ]
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 60,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-360-rotation-wrap .htmega-360-rotation-autoplay' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'icon_font_size',
                        [
                            'label' => __( 'Icon Size', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 100,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 23,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-360-rotation-wrap .htmega-360-rotation-autoplay' => 'font-size: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-360-rotation-wrap .htmega-360-rotation-autoplay svg' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_control(
                        'rotation_button_button_position_toggle',
                        [
                            'type' =>Controls_Manager::POPOVER_TOGGLE,
                            'label' => esc_html__( 'Button Position', 'htmega-pro' ),
                            'label_off' => esc_html__( 'Default', 'htmega-pro' ),
                            'label_on' => esc_html__( 'Custom', 'htmega-pro' ),
                            'return_value' => 'yes',
                        ]
                    );
                    $this->start_popover();
            
                    $this->add_responsive_control(
                        'position_vertical',
                        [
                            'label' => __( 'Vertical Position', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => -100,
                                    'max' => 100,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => -100,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-360-rotation-wrap .htmega-360-rotation-autoplay' => 'bottom: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    ); 
                    $this->add_responsive_control(
                        'position_horizontal',
                        [
                            'label' => __( 'Horizontal Position', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => -500,
                                    'max' => 500,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => -100,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-360-rotation-wrap .htmega-360-rotation-autoplay' => 'margin-left: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    ); 
    
                    $this->end_popover();
                $this->end_controls_tab(); // Normal Tab end

                $this->start_controls_tab(
                    'rotation_button_style_hover_tab',
                    [
                        'label' => __( 'Hover', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'rotation_button_hover_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-360-rotation-wrap .htmega-360-rotation-autoplay:hover svg path' => 'fill: {{VALUE}}',
                                '{{WRAPPER}} .htmega-360-rotation-wrap .htmega-360-rotation-autoplay:hover i' => 'color: {{VALUE}}',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'rotation_button_hover_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-360-rotation-wrap .htmega-360-rotation-autoplay:hover',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'rotation_button_hover_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-360-rotation-wrap .htmega-360-rotation-autoplay:hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'rotation_button_hover_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-360-rotation-wrap .htmega-360-rotation-autoplay:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab(); // Hover Tab end

            $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render( $instance = [] ) {

        $settings   = $this->get_settings_for_display();
        $sectionid = "sid". $this-> get_id();
        $play_option = $settings['play_option'];
        $render_attribute_args = array(
            'play_option'     => $play_option,
            'secid'     => $sectionid,
            'play_speed' => absint($settings['play_speed']),
        );

        $this->add_render_attribute( 'box_wrapper', 'class', "htmega-threesixty-rotation-wrap" );
        $this->add_render_attribute( 'box_wrapper', 'data-settings', wp_json_encode( $render_attribute_args ) );

        ?>
        <div <?php echo $this->get_render_attribute_string( 'box_wrapper' ); ?> >
            <div class="htmega-360-rotation-wrap">
                <div id="htmega-360-rotation<?php echo esc_attr($sectionid ); ?>" class="htmega-360-rotation">
                    <?php 
                    foreach ($settings['images'] as $item) : ?>
                        <img data-src="<?php echo esc_url($item['url']); ?>">
                    <?php 
                    endforeach; ?>
                </div>
                <div class="htmega-360-rotation-shap">
                    <?php 
                    if( 'yes' == $settings['image_shadow_show'] && !empty( $settings['image_shadow']['url'] ) ){ ?>
                        <img src="<?php echo esc_url($settings['image_shadow']['url']); ?>" alt="<?php echo esc_html( 'Shadow Image', 'htmega-pro' ); ?>">
                        <?php 
                    }
                    if( 'play_button' == $play_option ){ ?>
                        <button id="htmega-play-button-<?php echo esc_attr( $sectionid ); ?>" class="htmega-360-rotation-autoplay htmega-play-btn-2">
                            <?php if($settings['play_icon']['value']) {
                                echo HTMega_Icon_manager::render_icon( $settings['play_icon'], [ 'aria-hidden' => 'true' ] );
                            }else{
                                ?>
                            <svg width="23" height="27" viewBox="0 0 23 27" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M1 2.70766V24.2362C1 25.5309 2.26202 26.3534 3.30133 25.7328L21.7045 14.7183C22.6042 14.1801 22.6042 12.7637 21.7045 12.2255L3.30133 1.21105C2.26202 0.590436 1 1.41297 1 2.70766Z" stroke="white" stroke-miterlimit="10" />
                            </svg>
                            <?php } ?>
                        </button>
                        <?php
                    }
                    ?>
                </div>
            </div>
        </div>
    <?php
    }
}