<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Elementor_Widget_User_Register_Form extends Widget_Base {

    public function get_name() {
        return 'htmega-userregister-form-addons';
    }
    
    public function get_title() {
        return esc_html__( 'User Register Form', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-lock-user';
    }

    public function get_categories() {
        return [ 'htmega-addons' ];
    }

    public function get_keywords() {
        return ['user register form', 'register form', 'htmega', 'ht mega', 'create account','user form', 'htmega pro'];
    }

    public function get_help_url() {
        return 'https://wphtmega.com/docs/general-widgets/user-register-form-widget/';
    }

    public function get_style_depends() {
        return [
            'elementor-icons-fa-brands','elementor-icons-fa-regular','elementor-icons-fa-solid'
        ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'user_register_form_content',
            [
                'label' => __( 'Register Form', 'htmega-pro' ),
            ]
        );

            $this->add_control(
                'register_form_style',
                [
                    'label' => __( 'Style', 'htmega-pro' ),
                    'type' => 'htmega-preset-select',
                    'default' => '1',
                    'options' => [
                        '1'   => __( 'Style One', 'htmega-pro' ),
                        '2'   => __( 'Style Two', 'htmega-pro' ),
                        '3'   => __( 'Style Three', 'htmega-pro' ),
                        '4'   => __( 'Style Four', 'htmega-pro' ),
                        '5'   => __( 'Style Five', 'htmega-pro' ),
                        '6'   => __( 'Style Six', 'htmega-pro' ),
                    ],
                ]
            );        
            
            $this->add_control(
                'htmega_register_heading',
                [
                    'label' => __( 'Register Heading', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );  

            $this->add_control(
                'show_register_heading',
                [
                    'label' => __( 'Show Heading And Content', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => __( 'Show', 'htmega-pro' ),
                    'label_off' => __( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );

            $this->add_control(
                'register_heading_title',
                [
                    'label' => __( 'Register Heading', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default' => __( 'Hello!', 'htmega-pro' ),
                    'placeholder' => __( 'Hello!', 'htmega-pro' ),
                    'condition'=>[
                        'show_register_heading'=>'yes',
                    ],
                ]
            );

            $this->add_control(
                'register_heading_content',
                [
                    'label' => __( 'Register Content', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => esc_html__( "Don’t Have account? You can create an account by using this form. ","htmega-pro" ),
                    'placeholder' => esc_html__( "Don’t Have account? You can create an account by using this form. ","htmega-pro" ),
                    'condition'=>[
                        'show_register_heading'=>'yes',
                    ],
                ]
            );

            $this->add_control(
                'register_heading_url',
                [
                    'label' => __( 'Register Heading Login', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'no',
                    'label_off' => __( 'No', 'htmega-pro' ),
                    'label_on' => __( 'Yes', 'htmega-pro' ),
                    'condition'=>[
                        'show_register_heading'=>'yes',
                    ],
                ]
            );

            $this->add_control(
                'register_heading_url_control',
                [
                    'label' => __( 'URL Content', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Sign in', 'htmega-pro' ),
                    'placeholder' => __( 'Sign in', 'htmega-pro' ),
                    'condition'     => [
                        'register_heading_url' => 'yes',
                    ],
                ]
            );            
            
            $this->add_control(
                'htmega_register_form',
                [
                    'label' => __( 'Register Form', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );            

            $this->add_control(
                'show_firstname',
                [
                    'label' => __( 'Show First Name', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => __( 'Show', 'htmega-pro' ),
                    'label_off' => __( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );

            $this->add_control(
                'show_lastname',
                [
                    'label' => __( 'Show Last Name', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => __( 'Show', 'htmega-pro' ),
                    'label_off' => __( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );

            $this->add_control(
                'show_nickname',
                [
                    'label' => __( 'Nick Name', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => __( 'Show', 'htmega-pro' ),
                    'label_off' => __( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );

            $this->add_control(
                'show_website',
                [
                    'label' => __( 'Website', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => __( 'Show', 'htmega-pro' ),
                    'label_off' => __( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );

            $this->add_control(
                'show_bio',
                [
                    'label' => __( 'Biographical Info', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => __( 'Show', 'htmega-pro' ),
                    'label_off' => __( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );

            $this->add_control(
                'show_terms',
                [
                    'label' => __( 'Terms and conditions', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default'=>'no',
                ]
            );

            $this->add_control(
                'terms_label',
                [
                    'label' => __( 'Terms and conditions Label', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Creating an account means you’re okay with our Terms of Service, Privacy Policy', 'htmega-pro' ),
                    'placeholder' => __( 'Terms and conditions', 'htmega-pro' ),
                    'condition'=>[
                        'show_terms'=>'yes',
                    ],
                    'label_block'=>true,
                ]
            );

            $this->add_control(
                'select_terms_page',
                [
                    'label' => __( 'Terms & Condition Page', 'htmega-pro' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => '0',
                    'options' => htmega_get_page_list(),
                    'condition'=>[
                        'show_terms'=>'yes',
                    ],
                ]
            );       

            $this->add_control(
                'terms_conditions_label_color_settings',
                [
                    'label' => __( 'Color Settings', 'htmega-pro' ),
                    'type' => Controls_Manager::POPOVER_TOGGLE,
                    'label_off' => __( 'None', 'htmega-pro' ),
                    'label_on' => __( 'Custom', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'condition'=>[
                        'show_terms'=>'yes',
                    ]
                ]
            );

            $this->start_popover();

            $this->add_control(
                'terms_conditions_label_text_color',
                [
                    'label'     => __( 'Text Color', 'htmega-pro' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-wrapper label.htmega-form-label'   => 'color: {{VALUE}};',
                    ],
                    'condition'=>[
                        'show_terms'=>'yes',
                    ]
                ]
            );

            $this->add_control(
                'terms_conditions_label_link_color',
                [
                    'label'     => __( 'Link Color', 'htmega-pro' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-wrapper label.htmega-form-label a.terms-conditions'   => 'color: {{VALUE}};',
                    ],
                    'condition'=>[
                        'show_terms'=>'yes',
                    ]
                ]
            );

            $this->add_control(
                'terms_conditions_label_link_hover_color',
                [
                    'label'     => __( 'Link Hover Color', 'htmega-pro' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-wrapper label.htmega-form-label a.terms-conditions:hover'   => 'color: {{VALUE}};',
                    ],
                    'condition'=>[
                        'show_terms'=>'yes',
                    ]
                ]
            );
            
            $this->end_popover();     

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'terms_conditions_label_typography',
                    'selector' => '{{WRAPPER}} .htmega-register-wrapper label.htmega-form-label',
                    'condition'=>[
                        'show_terms'=>'yes',
                    ]
                ]
            );          

            $this->add_responsive_control(
                'terms_conditions_label_padding',
                [
                    'label' => __( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-wrapper .termscondition' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition'=>[
                        'show_terms'=>'yes',
                    ],
                ]
            );  

            $this->add_responsive_control(
                'show_terms_align',
                [
                    'label' => __( 'Alignment', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => __( 'Left', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => __( 'Center', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => __( 'Right', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .termscondition' => 'text-align: {{VALUE}};',
                    ],
                    'default' => 'left',
                    'condition'=>[
                        'show_terms'=>'yes',
                    ]
                ]
            );

            $this->add_control(
                'show_label',
                [
                    'label' => __( 'Show label', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => __( 'Show', 'htmega-pro' ),
                    'label_off' => __( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'separator' => 'before',
                    'condition'=>[
                        'register_form_style!'=>'3',
                    ]
                ]
            );

            $this->add_control(
                'show_custom_label',
                [
                    'label' => __( 'Custom label', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => __( 'Show', 'htmega-pro' ),
                    'label_off' => __( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'separator' => 'before',
                    'condition'=>[
                        'show_label'=>'yes',
                    ]
                ]
            );

            $this->add_control(
                'username_label',
                [
                    'label' => __( 'Username Label', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Username', 'htmega-pro' ),
                    'placeholder' => __( 'Username', 'htmega-pro' ),
                    'condition'=>[
                        'show_label'=>'yes',
                        'show_custom_label'=>'yes',
                    ]
                ]
            );

            $this->add_control(
                'password_label',
                [
                    'label' => __( 'Password Label', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Password', 'htmega-pro' ),
                    'placeholder' => __( 'Password', 'htmega-pro' ),
                    'condition'=>[
                        'show_label'=>'yes',
                        'show_custom_label'=>'yes',
                    ]
                ]
            );

            $this->add_control(
                'email_label',
                [
                    'label' => __( 'Mail Label', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Mail', 'htmega-pro' ),
                    'placeholder' => __( 'Mail', 'htmega-pro' ),
                    'condition'=>[
                        'show_label'=>'yes',
                        'show_custom_label'=>'yes',
                    ]
                ]
            );

            $this->add_control(
                'firstname_label',
                [
                    'label' => __( 'First Name Label', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'First Name', 'htmega-pro' ),
                    'placeholder' => __( 'First Name', 'htmega-pro' ),
                    'condition'=>[
                        'show_label'=>'yes',
                        'show_custom_label'=>'yes',
                        'show_firstname'=>'yes',
                    ]
                ]
            );

            $this->add_control(
                'lastname_label',
                [
                    'label' => __( 'Last Name Label', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Last Name', 'htmega-pro' ),
                    'placeholder' => __( 'Last Name', 'htmega-pro' ),
                    'condition'=>[
                        'show_label'=>'yes',
                        'show_custom_label'=>'yes',
                        'show_lastname'=>'yes',
                    ]
                ]
            );

            $this->add_control(
                'nickname_label',
                [
                    'label' => __( 'Nick Name Label', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Nick Name', 'htmega-pro' ),
                    'placeholder' => __( 'Nick Name', 'htmega-pro' ),
                    'condition'=>[
                        'show_label'=>'yes',
                        'show_custom_label'=>'yes',
                        'show_nickname'=>'yes',
                    ]
                ]
            );

            $this->add_control(
                'website_label',
                [
                    'label' => __( 'Website Label', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Website', 'htmega-pro' ),
                    'placeholder' => __( 'Website', 'htmega-pro' ),
                    'condition'=>[
                        'show_label'=>'yes',
                        'show_custom_label'=>'yes',
                        'show_website'=>'yes',
                    ]
                ]
            );

            $this->add_control(
                'bio_label',
                [
                    'label' => __( 'Biographical Info Label', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Biographical', 'htmega-pro' ),
                    'placeholder' => __( 'Biographical', 'htmega-pro' ),
                    'condition'=>[
                        'show_label'=>'yes',
                        'show_custom_label'=>'yes',
                        'show_bio'=>'yes',
                    ]
                ]
            );

            $this->add_control(
                'show_custom_placeholder',
                [
                    'label' => __( 'Custom Placeholder', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => __( 'Show', 'htmega-pro' ),
                    'label_off' => __( 'Hide', 'htmega-pro' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'username_placeholder_label',
                [
                    'label' => __( 'Username Placeholder', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Username', 'htmega-pro' ),
                    'placeholder' => __( 'Username', 'htmega-pro' ),
                    'condition'=>[
                        'show_custom_placeholder'=>'yes',
                    ],
                ]
            );

            $this->add_control(
                'password_placeholder_label',
                [
                    'label' => __( 'Password Placeholder', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Password', 'htmega-pro' ),
                    'placeholder' => __( 'Password', 'htmega-pro' ),
                    'condition'=>[
                        'show_custom_placeholder'=>'yes',
                    ],
                ]
            );

            $this->add_control(
                'email_placeholder_label',
                [
                    'label' => __( 'Mail Placeholder', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Mail', 'htmega-pro' ),
                    'placeholder' => __( 'Mail', 'htmega-pro' ),
                    'condition'=>[
                        'show_custom_placeholder'=>'yes',
                    ],
                ]
            );

            $this->add_control(
                'firstname_placeholder_label',
                [
                    'label' => __( 'First Name Placeholder', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'First Name', 'htmega-pro' ),
                    'placeholder' => __( 'First Name', 'htmega-pro' ),
                    'condition'=>[
                        'show_custom_placeholder'=>'yes',
                        'show_firstname'=>'yes',
                    ],
                ]
            );

            $this->add_control(
                'lastname_placeholder_label',
                [
                    'label' => __( 'Last Name Placeholder', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Last Name', 'htmega-pro' ),
                    'placeholder' => __( 'Last Name', 'htmega-pro' ),
                    'condition'=>[
                        'show_custom_placeholder'=>'yes',
                        'show_lastname'=>'yes',
                    ],
                ]
            );

            $this->add_control(
                'nickname_placeholder_label',
                [
                    'label' => __( 'Nick Name Placeholder', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Nick Name', 'htmega-pro' ),
                    'placeholder' => __( 'Nick Name', 'htmega-pro' ),
                    'condition'=>[
                        'show_custom_placeholder'=>'yes',
                        'show_nickname'=>'yes',
                    ],
                ]
            );

            $this->add_control(
                'website_placeholder_label',
                [
                    'label' => __( 'Website Placeholder', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Website', 'htmega-pro' ),
                    'placeholder' => __( 'Website', 'htmega-pro' ),
                    'condition'=>[
                        'show_custom_placeholder'=>'yes',
                        'show_website'=>'yes',
                    ],
                ]
            );

            $this->add_control(
                'bio_placeholder_label',
                [
                    'label' => __( 'Biographical Placeholder', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Bio', 'htmega-pro' ),
                    'placeholder' => __( 'Bio', 'htmega-pro' ),
                    'condition'=>[
                        'show_custom_placeholder'=>'yes',
                        'show_bio'=>'yes',
                    ],
                ]
            ); 

            $this->add_control(
                'submit_button_label',
                [
                    'label' => __( 'Submit Button label', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'REGISTER', 'htmega-pro' ),
                    'placeholder' => __( 'REGISTER', 'htmega-pro' ),
                    'separator' =>'before',
                ]
            );

            $this->add_control(
                'redirect_page',
                [
                    'label' => __( 'Redirect page after register', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'no',
                    'label_off' => __( 'No', 'htmega-pro' ),
                    'label_on' => __( 'Yes', 'htmega-pro' ),
                ]
            );

            $this->add_control(
                'redirect_page_url',
                [
                    'type'          => Controls_Manager::URL,
                    'show_label'    => false,
                    'show_external' => false,
                    'separator'     => false,
                    'placeholder'   => 'http://your-link.com/',
                    'condition'     => [
                        'redirect_page' => 'yes',
                    ],
                ]
            );
  
            $this->add_control(
                'login_option_content',
                [
                    'label' => __( 'Or Login Text', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'no',
                    'label_off' => __( 'No', 'htmega-pro' ),
                    'label_on' => __( 'Yes', 'htmega-pro' ),
                ]
            );

            $this->add_control(
                'or_login_content_text',
                [
                    'label' => __( 'Or Login Content', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'or you can', 'htmega-pro' ),
                    'placeholder' => __( 'or you can', 'htmega-pro' ),
                    'separator' =>'before',
                    'condition'     => [
                        'login_option_content' => 'yes',
                    ],
                ]
            );

            $this->add_control(
                'login_option_button',
                [
                    'label' => __( 'Login Button', 'htmega-pro' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'no',
                    'label_off' => __( 'No', 'htmega-pro' ),
                    'label_on' => __( 'Yes', 'htmega-pro' ),
                ]
            );
            $this->add_control(
                'login_button_text',
                [
                    'label' => __( 'Button Text', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => __( 'Login', 'htmega-pro' ),
                    'condition'     => [
                        'login_option_button' => 'yes',
                    ],
                ]
            );
            $this->add_control(
                'custom_login',
                [
                    'label'                    => __( 'Custom Login URL ', 'htmega-pro' ),
                    'type'                     => Controls_Manager::SWITCHER,
                    'default'                  => 'no',
                    'label_off'                => __( 'No', 'htmega-pro' ),
                    'label_on'                 => __( 'Yes', 'htmega-pro' ),
                    'return'                   => 'yes',
                    'condition'                => [
                        'login_option_button' => 'yes',
                    ],
                ]
            );
            $this->add_control(
                'custom_login_url',
                [
                    'label' => __( 'Login URL', 'htmega-pro' ),
                    'type' => Controls_Manager::URL,
                    'placeholder' => __( 'https://your-link.com/login', 'htmega-pro' ),
                    'show_external' => true,
                    'default' => [
                        'url'         => '#',
                        'is_external' => false,
                        'nofollow'    =>  false,
                    ],
                    'condition'=>[
                        'login_option_button' => 'yes',
                        'custom_login'       => 'yes',
                    ]
                ]
            );
            $this->add_responsive_control(
                'register_form_buttons_align',
                [
                    'label' => __( 'Buttons Alignment', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => __( 'Left', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => __( 'Center', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => __( 'Right', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                        'justify' => [
                            'title' => __( 'Justified', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-justify',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-wrapper .htmega-submit-button' => 'text-align: {{VALUE}};',
                    ],
                    'default' => 'center',
                    'condition'=>[
                        'register_form_style!'=>'3',
                    ]
                ]
            );

        $this->end_controls_section();
        $this->start_controls_section(
            'validation_messages_section',
                [
                'label' => __( 'Errors & Success Messages', 'htmega-pro' ),
            ]
        );
            $this->add_control(
                'required_msg',
                [
                    'label' => __( 'Required Fields', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default' => __( 'Username, Password and E-Mail are required', 'htmega-pro' ),
                    'placeholder' => __( 'Username, Password and E-Mail are required', 'htmega-pro' ),
                ]
            );
            $this->add_control(
                'user_length_msg',
                [
                    'label' => __( 'Username Length', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default' => __( 'Username too short. At least 4 characters is required', 'htmega-pro' ),
                    'placeholder' => __( 'Username too short. At least 4 characters is required', 'htmega-pro' ),
                ]
            );
            $this->add_control(
                'user_exists_msg',
                [
                    'label' => __( 'Username Exists', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default' => __( 'Sorry, that username already exists!', 'htmega-pro' ),
                    'placeholder' => __( 'Sorry, that username already exists!', 'htmega-pro' ),
                ]
            );
            $this->add_control(
                'user_invalid_msg',
                [
                    'label' => __( 'Username Invalid', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default' => __( 'Sorry, the username you entered is not valid', 'htmega-pro' ),
                    'placeholder' => __( 'Sorry, the username you entered is not valid', 'htmega-pro' ),
                ]
            );
            $this->add_control(
                'password_length_msg',
                [
                    'label' => __( 'Password Length', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default' => __( 'Password length must be greater than 5', 'htmega-pro' ),
                    'placeholder' => __( 'Password length must be greater than 5', 'htmega-pro' ),
                ]
            );
            $this->add_control(
                'invalid_email_msg',
                [
                    'label' => __( 'Invalid Email ', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default' => __( 'Email is not valid', 'htmega-pro' ),
                    'placeholder' => __( 'Email is not valid', 'htmega-pro' ),
                ]
            );
            $this->add_control(
                'email_exists_msg',
                [
                    'label' => __( 'Email Exists', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default' => __( 'Email Already in Use', 'htmega-pro' ),
                    'placeholder' => __( 'Email Already in Use', 'htmega-pro' ),
                ]
            );
            $this->add_control(
                'invalid_url_msg',
                [
                    'label' => __( 'Invalid URL', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default' => __( 'Website is not a valid URL', 'htmega-pro' ),
                    'placeholder' => __( 'Website is not a valid URL', 'htmega-pro' ),
                ]
            );
            $this->add_control(
                'success_msg',
                [
                    'label' => __( 'Successfully Register', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default' => __( 'Successfully Register', 'htmega-pro' ),
                    'placeholder' => __( 'Successfully Register', 'htmega-pro' ),
                    'separator' => 'before'
                ]
            );
            $this->add_control(
                'loading_msg',
                [
                    'label' => __( 'Loading Text', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default' => __( 'Loading...', 'htmega-pro' ),
                    'placeholder' => __( 'Loading...', 'htmega-pro' ),
                ]
            );
            $this->add_control(
                'server_error_msg',
                [
                    'label' => __( 'Server Error', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default' => __( 'Something is wrong please check again!', 'htmega-pro' ),
                    'placeholder' => __( 'Something is wrong please check again!', 'htmega-pro' ),
                ]
            );
            $this->add_control(
                'login_as_msg',
                [
                    'label' => __( 'You are Logged in as ', 'htmega-pro' ),
                    'type' => Controls_Manager::TEXT,
                    'label_block' => true,
                    'default' => __( 'You are Logged in as', 'htmega-pro' ),
                    'placeholder' => __( 'You are Logged in as', 'htmega-pro' ),
                ]
            );

        $this->end_controls_section();

        // Style tab section
        $this->start_controls_section(
            'register_form_style_section',
            [
                'label' => __( 'Form Wrapper', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'htmega_register_area_background',
                    'label' => __( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-register-wrapper',
                ]
            );

            $this->add_responsive_control(
                'htmega_register_area_border_radius',
                [
                    'label' => __( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-wrapper' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'htmega_register_area_box_shadow',
                    'label' => __( 'Box Shadow', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-register-wrapper',
                ]
            );

            $this->add_responsive_control(
                'register_form_section_margin',
                [
                    'label' => __( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' =>'before',
                ]
            );

            $this->add_responsive_control(
                'register_form_section_padding',
                [
                    'label' => __( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' =>'before',
                ]
            );

        $this->end_controls_section();

        // Style tab section
        $this->start_controls_section(
            'register_form_heading_style',
            [
                'label' => __( 'Register Heading', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition'=>[
                    'show_register_heading'=>'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'register_heading_align',
            [
                'label' => __( 'Alignment', 'htmega-pro' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'htmega-pro' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'htmega-pro' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'htmega-pro' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => __( 'Justified', 'htmega-pro' ),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-register-wrapper .user-register-header' => 'text-align: {{VALUE}};',
                ],
                'default' => 'left',
                'separator' =>'before',
            ]
        );

        $this->add_responsive_control(
            'register_form_text_color_padding',
            [
                'label' => __( 'Padding', 'htmega-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .user-register-header' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
            
        $this->add_control(
            'register_form_heading_style_heading',
            [
                'label' => __( 'Heading Title Style', 'htmega-pro' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition'=>[
                    'register_heading_title!'=>'',
                ]
            ]
        );  

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'register_form_heading_typography',
                'selector' => '{{WRAPPER}} .user-register-header h2',
                'condition'=>[
                    'register_heading_title!'=>'',
                ]
            ]
        );
            
        $this->add_control(
            'register_form_heading_color',
            [
                'label'     => __( 'Header Color', 'htmega-pro' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .user-register-header h2'   => 'color: {{VALUE}};',
                ],
                'condition'=>[
                    'register_heading_title!'=>'',
                ]
            ]
        );

        $this->add_responsive_control(
            'register_form_text_color_margin',
            [
                'label' => __( 'Margin', 'htmega-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .user-register-header h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                'condition'=>[
                    'register_heading_title!'=>'',
                ]
            ]
        );
        
        $this->add_control(
            'register_form_heading_style_content',
            [
                'label' => __( 'Header Content', 'htmega-pro' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition'=>[
                    'register_heading_content!'=>'',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'register_form_content_typography',
                'selector' => '{{WRAPPER}} .user-register-header p',
                'condition'=>[
                    'register_heading_content!'=>'',
                ]
            ]
        );
            
        $this->add_control(
            'register_form_content_color',
            [
                'label'     => __( 'Content Color', 'htmega-pro' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .user-register-header p'   => 'color: {{VALUE}};',
                ],
                'condition'=>[
                    'register_heading_content!'=>'',
                ]
            ]
        );

        $this->add_responsive_control(
            'register_form_content_color_margin',
            [
                'label' => __( 'Margin', 'htmega-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .user-register-header p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                'condition'=>[
                    'register_heading_content!'=>'',
                ]
            ]
        ); 
            
        $this->add_control(
            'register_form_content_link_color',
            [
                'label'     => __( 'Link Color', 'htmega-pro' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .user-register-header p a'   => 'color: {{VALUE}};',
                ],
                'condition'=>[
                    'register_heading_url_control!'=>'',
                ]
            ]
        );
            
        $this->add_control(
            'register_form_content_link_hover_color',
            [
                'label'     => __( 'Link Hover Color', 'htmega-pro' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .user-register-header p a:hover'   => 'color: {{VALUE}};',
                ],
                'condition'=>[
                    'register_heading_url_control!'=>'',
                ]
            ]
        );

        $this->end_controls_section();
        // Style tab section
        $this->start_controls_section(
            'register_form_style_input',
            [
                'label' => __( 'Input', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $this->add_responsive_control(
                'input_form_area_padding',
                [
                    'label' => __( 'Input Area Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-style-1 form' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' =>'before',
                    'condition'=>[
                        'register_form_style!'=>'3',
                    ]
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'register_form_input_typography',
                    'selector' => '{{WRAPPER}} .htmega-register-wrapper input',
                ]
            );

            $this->add_responsive_control(
                'register_input_margin',
                [
                    'label' => __( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-wrapper input' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' =>'before',
                    'condition'=>[
                        'register_form_style!'=>'3',
                    ]
                ]
            );

            $this->add_responsive_control(
                'register_input_margin_three',
                [
                    'label' => __( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-style-3 form .input_box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' =>'before',
                    'condition'=>[
                        'register_form_style'=>'3',
                    ]
                ]
            );

            $this->add_responsive_control(
                'register_input_padding',
                [
                    'label' => __( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-wrapper input:not(input[type="submit"])' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'register_input_height',
                [
                    'label' => __( 'Height', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 70,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-wrapper.htmega-register-style-3 input' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                    'separator' =>'before',
                    'condition'=>[
                        'register_form_style' => '3',
                    ],
                ]
            );

            $this->add_control(
                'register_input_height_not_three',
                [
                    'label' => __( 'Height', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 50,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-wrapper input' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                    'separator' =>'before',
                    'condition'=>[
                        'register_form_style!' => '3',
                    ],
                ]
            );

            $this->add_control(
                'input_color_border_heading',
                [
                    'label' => __( 'Colors and Border', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $this->start_controls_tabs(
                'input_fields_tab'
            );
                // Normal Style Tab
                $this->start_controls_tab(
                    'input_normal',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'register_form_input_text_color',
                        [
                            'label'     => __( 'Text Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper input'   => 'color: {{VALUE}};',
                            ],
                        ]
                    );
        
                    $this->add_control(
                        'register_form_input_placeholder_color',
                        [
                            'label'     => __( 'Placeholder Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper input[type*="text"]::-webkit-input-placeholder'  => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-register-wrapper input[type*="text"]::-moz-placeholder'  => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-register-wrapper input[type*="text"]:-ms-input-placeholder'  => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-register-wrapper input[type*="password"]::-webkit-input-placeholder'  => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-register-wrapper input[type*="password"]::-moz-placeholder'  => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-register-wrapper input[type*="password"]:-ms-input-placeholder'  => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-register-wrapper input[type*="email"]::-webkit-input-placeholder'  => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-register-wrapper input[type*="email"]::-moz-placeholder'  => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-register-wrapper input[type*="email"]:-ms-input-placeholder'  => 'color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'register_input_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-register-wrapper input',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'register_input_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-register-wrapper input',
                            'separator' =>'before',
                        ]
                    );
        
                    $this->add_responsive_control(
                        'register_input_border_radius',
                        [
                            'label' => __( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper input' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
                $this->end_controls_tab();

                // Hover Style Tab
                $this->start_controls_tab(
                    'input_focus',
                    [
                        'label' => __( 'Focus', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'register_form_input_text_color_focus',
                        [
                            'label'     => __( 'Text Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper input:focus'   => 'color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'register_input_background_focus',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-register-wrapper input:focus',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'register_input_border_focus',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-register-wrapper input:focus',
                            'separator' =>'before',
                        ]
                    );
        
                    $this->add_responsive_control(
                        'register_input_border_radius_focus',
                        [
                            'label' => __( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper input:focus' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();

        // Style tab Textarea section
        $this->start_controls_section(
            'register_form_style_textarea',
            [
                'label' => __( 'Textarea', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' =>[
                    'show_bio' =>'yes',
                ]
            ]
        );
            
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'register_form_textarea_typography',
                    'selector' => '{{WRAPPER}} .htmega-register-wrapper textarea',
                ]
            );

            $this->add_responsive_control(
                'register_textarea_margin',
                [
                    'label' => __( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-wrapper textarea' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' =>'before',
                ]
            );

            $this->add_responsive_control(
                'register_textarea_padding',
                [
                    'label' => __( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-wrapper textarea' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'register_textarea_height',
                [
                    'label' => __( 'Height', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 100,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-wrapper textarea' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                    'separator' =>'before',
                ]
            );

            $this->add_control(
                'textarea_color_border_heading',
                [
                    'label' => __( 'Colors and Border', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $this->start_controls_tabs(
                'textarea_fields_tab'
            );
                // Normal Style Tab
                $this->start_controls_tab(
                    'textarea_normal',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'register_form_textarea_text_color',
                        [
                            'label'     => __( 'Text Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper textarea'   => 'color: {{VALUE}};',
                            ],
                        ]
                    );
        
                    $this->add_control(
                        'register_form_textarea_placeholder_color',
                        [
                            'label'     => __( 'Placeholder Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper textarea::-webkit-input-placeholder'  => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-register-wrapper textarea::-moz-placeholder'  => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-register-wrapper textarea:-ms-input-placeholder'  => 'color: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'register_textarea_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-register-wrapper textarea',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'register_textarea_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-register-wrapper textarea',
                            'separator' =>'before',
                        ]
                    );
        
                    $this->add_responsive_control(
                        'register_textarea_border_radius',
                        [
                            'label' => __( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper textarea' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
                $this->end_controls_tab();

                // Hover Style Tab
                $this->start_controls_tab(
                    'textarea_focus',
                    [
                        'label' => __( 'Focus', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'textarea_text_color_focus',
                        [
                            'label'     => __( 'Text Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper textarea:focus'   => 'color: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'register_textarea_background_focus',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-register-wrapper textarea:focus',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'register_textarea_border_focus',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-register-wrapper textarea:focus',
                            'separator' =>'before',
                        ]
                    );
        
                    $this->add_responsive_control(
                        'textarea_border_radius_focus',
                        [
                            'label' => __( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper textarea:focus' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();

        // Submit Button
        $this->start_controls_section(
            'register_form_input_box_style',
            [
                'label' => __( 'Input Icon', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition'=>[
                    'register_form_style'=>'3',
                ]
            ]
        );

        $this->add_control(
            'register_form_input_box_height',
            [
                'label' => __( 'Height', 'htmega-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 70,
                ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-register-style-3 form .input_box i' => 'height: {{SIZE}}{{UNIT}};line-height: {{SIZE}}{{UNIT}};',
                ],
                'separator' =>'before',
            ]
        );

        $this->add_control(
            'register_form_input_box_width',
            [
                'label' => __( 'Width', 'htmega-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 70,
                ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-register-style-3 form .input_box i' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'separator' =>'before',
            ]
        );

        $this->add_control(
            'register_form_input_box_icon_size',
            [
                'label' => __( 'Icon Size', 'htmega-pro' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-register-style-3 form .input_box i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'separator' =>'before',
            ]
        );
        $this->add_control(
            'input_box_icon_color',
            [
                'label'     => __( 'Text Color', 'htmega-pro' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .htmega-register-style-3 form .input_box i'   => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'input_box_icon_background',
                'label' => __( 'Background', 'htmega-pro' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .htmega-register-style-3 form .input_box i',
            ]
        );
        $this->add_responsive_control(
            'register_form_input_box_border_radius',
            [
                'label' => __( 'Border Radius', 'htmega-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .htmega-register-style-3 form .input_box i' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );

        $this->add_responsive_control(
            'register_form_input_box_margin',
            [
                'label' => __( 'Margin', 'htmega-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .htmega-register-style-3 form .input_box i' => 'margin: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );

        $this->add_responsive_control(
            'register_form_input_box_padding',
            [
                'label' => __( 'Padding', 'htmega-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'selectors' => [
                    '{{WRAPPER}} .htmega-register-style-3 form .input_box i' => 'padding: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                ],
            ]
        );

        $this->end_controls_section();
        // Label Style Start
        $this->start_controls_section(
            'register_form_style_label',
            [
                'label' => __( 'Label', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition'=>[
                    'show_label'=>'yes',
                ]
            ]
        );

            $this->add_control(
                'register_form_label_text_color',
                [
                    'label'     => __( 'Color', 'htmega-pro' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-wrapper label:not(.htmega-form-label)'   => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'register_form_label_typography',
                    'selector' => '{{WRAPPER}} .htmega-register-wrapper label:not(.htmega-form-label)',
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'register_form_label_background',
                    'label' => __( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-register-wrapper label:not(.htmega-form-label)',
                ]
            );

            $this->add_responsive_control(
                'register_form_label_margin',
                [
                    'label' => __( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-wrapper label:not(.htmega-form-label)' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' =>'before',
                ]
            );

            $this->add_responsive_control(
                'register_form_label_padding',
                [
                    'label' => __( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-wrapper label:not(.htmega-form-label)' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'register_form_label_border',
                    'label' => __( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-register-wrapper label:not(.htmega-form-label)',
                    'separator' =>'before',
                ]
            );

            $this->add_responsive_control(
                'register_form_label_border_radius',
                [
                    'label' => __( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-wrapper label:not(.htmega-form-label)' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                    ],
                ]
            );

            $this->add_responsive_control(
                'register_form_label_align',
                [
                    'label' => __( 'Alignment', 'htmega-pro' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => __( 'Left', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => __( 'Center', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => __( 'Right', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                        'justify' => [
                            'title' => __( 'Justified', 'htmega-pro' ),
                            'icon' => 'eicon-text-align-justify',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-wrapper label:not(.htmega-form-label)' => 'text-align: {{VALUE}};',
                    ],
                    'default' => 'left',
                    'separator' =>'before',
                ]
            );

        $this->end_controls_section();       

        // Submit Button
        $this->start_controls_section(
            'register_form_style_submit_button',
            [
                'label' => __( 'Submit Button', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            // Button Tabs Start
            $this->start_controls_tabs('register_form_style_submit_tabs');

                // Start Normal Submit button tab
                $this->start_controls_tab(
                    'register_form_style_submit_normal_tab',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                );
                    
                    $this->add_control(
                        'register_form_submitbutton_text_color',
                        [
                            'label'     => __( 'Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper input[type="submit"]'   => 'color: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'register_form_submitbutton_typography',
                            'selector' => '{{WRAPPER}} .htmega-register-wrapper input[type="submit"]',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'register_form_submitbutton_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-register-wrapper input[type="submit"]',
                        ]
                    );

                    $this->add_responsive_control(
                        'register_form_submitbutton_margin',
                        [
                            'label' => __( 'Margin', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper input[type="submit"]' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' =>'before',
                        ]
                    );

                    $this->add_responsive_control(
                        'register_form_submitbutton_padding',
                        [
                            'label' => __( 'Padding', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper input[type="submit"]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );

                    $this->add_responsive_control(
                        'register_form_submitbutton_height',
                        [
                            'label' => __( 'Height', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 50,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper input[type="submit"]' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                            'separator' =>'before',
                        ]
                    );

                    $this->add_responsive_control(
                        'register_form_submitbutton_width',
                        [
                            'label' => __( 'Width', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => '%',
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper input[type="submit"]' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );                    

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'register_form_submitbutton_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-register-wrapper input[type="submit"]',
                            'separator' =>'before',
                        ]
                    );

                    $this->add_responsive_control(
                        'register_form_submitbutton_border_radius',
                        [
                            'label' => __( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper input[type="submit"]' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab(); // Normal submit Button tab end

                // Start Hover Submit button tab
                $this->start_controls_tab(
                    'register_form_style_submit_hover_tab',
                    [
                        'label' => __( 'Hover', 'htmega-pro' ),
                    ]
                );
                    
                    $this->add_control(
                        'register_form_submitbutton_hover_text_color',
                        [
                            'label'     => __( 'Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper input[type="submit"]:hover'   => 'color: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'register_form_submitbutton_hover_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-register-wrapper input[type="submit"]:hover',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'register_form_submitbutton_hover_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-register-wrapper input[type="submit"]:hover',
                            'separator' =>'before',
                        ]
                    );

                    $this->add_responsive_control(
                        'register_form_submitbutton_hover_border_radius',
                        [
                            'label' => __( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper input[type="submit"]:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab(); // Hover Submit Button tab End

            $this->end_controls_tabs(); // Button Tabs End

        $this->end_controls_section();

        // Login Button
        $this->start_controls_section(
            'register_form_style_before_login_text',
            [
                'label' => __( 'Before Login Text', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'register_form_style' =>'3',
                ],
            ]
        );

            $this->add_control(
                'register_form_style_before_text_color',
                [
                    'label'     => __( 'Color', 'htmega-pro' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-style-3 .separator span'   => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'register_form_style_before_border_color',
                [
                    'label' => __( 'Border Color', 'htmega-pro' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-style-3 .separator span::before , {{WRAPPER}} .htmega-register-style-3 .separator span::after' => 'background-color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_responsive_control(
                'register_form_style_before_border_width',
                [
                    'label' => __( 'Width', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 130,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-style-3 .separator span::before , {{WRAPPER}} .htmega-register-style-3 .separator span::after' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'register_form_style_before_border_height',
                [
                    'label' => __( 'Height', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 1,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-register-style-3 .separator span::before , {{WRAPPER}} .htmega-register-style-3 .separator span::after' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();

        // Login Button
        $this->start_controls_section(
            'register_form_style_login_button',
            [
                'label' => __( 'Login Button', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'register_form_style' =>'3',
                ],
            ]
        );

            // Button Tabs Start
            $this->start_controls_tabs('register_form_style_login_tabs');

                // Start Normal Login button tab
                $this->start_controls_tab(
                    'register_form_style_login_normal_tab',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                );
                    
                    $this->add_control(
                        'register_form_loginbutton_text_color',
                        [
                            'label'     => __( 'Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-style-3 .login a'   => 'color: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'register_form_loginbutton_typography',
                            'selector' => '{{WRAPPER}} .htmega-register-style-3 .login a',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'register_form_loginbutton_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-register-style-3 .login a',
                        ]
                    );

                    $this->add_responsive_control(
                        'register_form_loginbutton_margin',
                        [
                            'label' => __( 'Margin', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-style-3 .login a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' =>'before',
                        ]
                    );

                    $this->add_responsive_control(
                        'register_form_loginbutton_padding',
                        [
                            'label' => __( 'Padding', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-style-3 .login a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );

                    $this->add_responsive_control(
                        'register_form_loginbutton_height',
                        [
                            'label' => __( 'Height', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 90,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-style-3 .login a' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                            'separator' =>'before',
                        ]
                    );

                    $this->add_responsive_control(
                        'register_form_loginbutton_width',
                        [
                            'label' => __( 'Width', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => '%',
                                'size' => 100,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-style-3 .login a' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'register_form_loginbutton_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-register-style-3 .login a',
                            'separator' =>'before',
                        ]
                    );

                    $this->add_responsive_control(
                        'register_form_loginbutton_border_radius',
                        [
                            'label' => __( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-style-3 .login a' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab(); // Normal login Button tab end

                // Start Hover login button tab
                $this->start_controls_tab(
                    'register_form_style_login_hover_tab',
                    [
                        'label' => __( 'Hover', 'htmega-pro' ),
                    ]
                );
                    
                    $this->add_control(
                        'register_form_loginbutton_hover_text_color',
                        [
                            'label'     => __( 'Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-style-3 .login a:hover'   => 'color: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'register_form_loginbutton_hover_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-register-style-3 .login a:hover',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'register_form_loginbutton_hover_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-register-style-3 .login a:hover',
                            'separator' =>'before',
                        ]
                    );

                    $this->add_responsive_control(
                        'register_form_loginbutton_hover_border_radius',
                        [
                            'label' => __( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-style-3 .login a:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab(); // Hover Submit Button tab End

            $this->end_controls_tabs(); // Button Tabs End

        $this->end_controls_section();


        // Before Login text Content
        $this->start_controls_section(
            'before_login_text_style',
            [
                'label' => __( 'Before Login Text', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition'=>[
                    'or_login_content_text!' => '',
                    'register_form_style!' => '3',
                    'login_option_content' => 'yes'
                ]
            ]
        );
            
        $this->add_control(
            'before_login_text_color',
            [
                'label'     => __( 'Text Color', 'htmega-pro' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .htmega-register-wrapper .separator span'   => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'before_login_text_typography',
                'selector' => '{{WRAPPER}} .htmega-register-wrapper .separator span',
            ]
        );

        $this->add_responsive_control(
            'before_login_text_margin',
            [
                'label' => __( 'Margin', 'htmega-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-register-wrapper .separator span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' =>'before',
            ]
        );

        $this->add_responsive_control(
            'before_login_text_padding',
            [
                'label' => __( 'Padding', 'htmega-pro' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .htmega-register-wrapper .separator span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' =>'before',
            ]
        );

        $this->end_controls_section(); // Before Login text Content End
        

        // Submit Button
        $this->start_controls_section(
            'login_style_submit_button',
            [
                'label' => __( 'Login Button', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition'=>[
                    'register_form_style!'=>'3',
                    'login_option_button'=>'yes'
                ]
            ]
        );

            // Login Tabs Start
            $this->start_controls_tabs('login_style_submit_tabs');

                // Start Normal Submit button tab
                $this->start_controls_tab(
                    'login_style_submit_normal_tab',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                );
                    
                    $this->add_control(
                        'login_button_text_color',
                        [
                            'label'     => __( 'Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper:not(.htmega-register-style-3) .htmega-register-form form a:not(.terms-conditions)'   => 'color: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'login_button_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-register-wrapper:not(.htmega-register-style-3) .htmega-register-form form a:not(.terms-conditions)',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'login_button_typography',
                            'selector' => '{{WRAPPER}} .htmega-register-wrapper:not(.htmega-register-style-3) .htmega-register-form form a:not(.terms-conditions)',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'login_button_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-register-wrapper:not(.htmega-register-style-3) .htmega-register-form form a:not(.terms-conditions)',
                            'separator' =>'before',
                        ]
                    );

                    $this->add_responsive_control(
                        'login_button_margin',
                        [
                            'label' => __( 'Margin', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper:not(.htmega-register-style-3) .htmega-register-form form a:not(.terms-conditions)' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' =>'before',
                        ]
                    );

                    $this->add_responsive_control(
                        'login_button_padding',
                        [
                            'label' => __( 'Padding', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper:not(.htmega-register-style-3) .htmega-register-form form a:not(.terms-conditions)' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );

                    $this->add_responsive_control(
                        'login_button_border_radius',
                        [
                            'label' => __( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper:not(.htmega-register-style-3) .htmega-register-form form a:not(.terms-conditions)' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                    $this->add_responsive_control(
                        'login_button_width',
                        [
                            'label' => __( 'Width', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => '%',
                                'size' => 50,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper:not(.htmega-register-style-3) .htmega-register-form form a:not(.terms-conditions)' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );

                $this->end_controls_tab(); // Normal submit Button tab end

                // Start Hover Submit button tab
                $this->start_controls_tab(
                    'login_button_submit_hover_tab',
                    [
                        'label' => __( 'Hover', 'htmega-pro' ),
                    ]
                );
                    
                    $this->add_control(
                        'login_button_hover_text_color',
                        [
                            'label'     => __( 'Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper:not(.htmega-register-style-3) .htmega-register-form form a:not(.terms-conditions):hover'   => 'color: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'login_button_hover_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-register-wrapper:not(.htmega-register-style-3) .htmega-register-form form a:not(.terms-conditions):hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'login_hover_button_opacity',
                        [
                            'label' => __( 'Opacity', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'range' => [
                                'px' => [
                                    'min' => 0.1,
                                    'max' => 1,
                                    'step' => 0.1,
                                ],
                            ],
                            'default' => [
                                'size' => 0.7,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper:not(.htmega-register-style-3) .htmega-register-form form a:not(.terms-conditions):hover' => 'opacity: {{SIZE}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'login_button_hover_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-register-wrapper:not(.htmega-register-style-3) .htmega-register-form form a:not(.terms-conditions):hover',
                            'separator' =>'before',
                        ]
                    );

                    $this->add_responsive_control(
                        'login_button_hover_border_radius',
                        [
                            'label' => __( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-register-wrapper:not(.htmega-register-style-3) .htmega-register-form form a:not(.terms-conditions):hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab(); // Hover Submit Button tab End

            $this->end_controls_tabs(); // Button Tabs End

        $this->end_controls_section(); // End Login Button Control

        // Validation message
        $this->start_controls_section(
            'validation_message_style',
            [
                'label' => __( 'Errors & Success', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->start_controls_tabs('error_success_style_tabs');
                // Start Hover Submit button tab
                $this->start_controls_tab(
                    'login_success_tab',
                    [
                        'label' => __( 'Success', 'htmega-pro' ),
                    ]
                );
                    
                $this->add_control(
                    'success_text_color',
                    [
                        'label'     => __( 'Color', 'htmega-pro' ),
                        'type'      => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega_success_msg'   => 'color: {{VALUE}};',
                        ],
                    ]
                );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'success_background',
                        'label' => __( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'exclude' =>['image'],
                        'selector' => '{{WRAPPER}} .htmega_success_msg',
                    ]
                );

                $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                        'name' => 'success_typography',
                        'selector' => '{{WRAPPER}} .htmega_success_msg',
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'success_border',
                        'label' => __( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega_success_msg',
                        'separator' =>'before',
                    ]
                );
                $this->add_responsive_control(
                    'success_border_radius',
                    [
                        'label' => __( 'Border Radius', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'selectors' => [
                            '{{WRAPPER}} .htmega_success_msg' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                        ],
                    ]
                );

                $this->add_responsive_control(
                    'success_padding',
                    [
                        'label' => __( 'Padding', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega_success_msg' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'success_margin',
                    [
                        'label' => __( 'Margin', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega_success_msg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                        'separator' =>'before',
                    ]
                );

                $this->end_controls_tab(); 
                // Loading tab
                $this->start_controls_tab(
                    'loading_style_tab',
                    [
                        'label' => __( 'Loading', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'loading_text_color',
                        [
                            'label'     => __( 'Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega_message .htmega_lodding_msg'   => 'color: {{VALUE}}!important;',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'loading_typography',
                            'selector' => '{{WRAPPER}} .htmega_message .htmega_lodding_msg',
                        ]
                    );
                $this->end_controls_tab(); // Normal submit Button tab end
                // Start Normal Submit 
                $this->start_controls_tab(
                    'error_tab',
                    [
                        'label' => __( 'Error', 'htmega-pro' ),
                    ]
                );
                    
                    $this->add_control(
                        'error_text_color',
                        [
                            'label'     => __( 'Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega_invalid_msg'   => 'color: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'error_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'exclude' =>['image'],
                            'selector' => '{{WRAPPER}} .htmega_invalid_msg',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Typography::get_type(),
                        [
                            'name' => 'error_typography',
                            'selector' => '{{WRAPPER}} .htmega_invalid_msg',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'error_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega_invalid_msg',
                            'separator' =>'before',
                        ]
                    );
                    $this->add_responsive_control(
                        'error_border_radius',
                        [
                            'label' => __( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega_invalid_msg' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                    $this->add_responsive_control(
                        'error_padding',
                        [
                            'label' => __( 'Padding', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega_invalid_msg' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'error_margin',
                        [
                            'label' => __( 'Margin', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega_invalid_msg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' =>'before',
                        ]
                    );
                $this->end_controls_tab(); // Normal submit Button tab end

            $this->end_controls_tabs(); 
        
        $this->end_controls_section(); 
    }

    protected function render( $instance = [] ) {

        $settings   = $this->get_settings_for_display();
        $current_url = remove_query_arg( 'fake_arg' );
        $id = $this->get_id();

        if ( $settings['redirect_page'] == 'yes' && ! empty( $settings['redirect_page_url']['url'] ) ) {
            $redirect_url = $settings['redirect_page_url']['url'];
        } else {
            $redirect_url = $current_url;
        }

        $this->add_render_attribute( 'register_area_attr', 'class', 'htmega-register-wrapper' );
        $this->add_render_attribute( 'register_area_attr', 'class', 'htmega-register-style-'.$settings['register_form_style'] );

        $terms_label = ( !empty( $settings['terms_label'] ) ? $settings['terms_label'] : esc_html__('Terms and conditions','htmega-pro') );
        $terms_page = ( !empty( $settings['select_terms_page'] ) ? $settings['select_terms_page'] : '0');
        $login_url  = '';
        if( 'yes' == $settings['custom_login'] ){
            $this->add_link_attributes( 'custom_login_url', $settings['custom_login_url'] );
            $login_url = $this->get_render_attribute_string( 'custom_login_url' );
        } else {
            $login_url = "href='" . esc_url( wp_login_url()) . "'";
        }

        if($settings['select_terms_page'] == '0'){
            $page_id = "";
            $page_title = "";
        }else{
            $page_id = get_permalink($terms_page);
            $page_title = get_the_title($terms_page);
        }
        $messages = [
            'required_msg'        => esc_html( $settings['required_msg'] ),
            'user_length_msg'     => esc_html( $settings['user_length_msg'] ),
            'user_exists_msg'     => esc_html( $settings['user_exists_msg'] ),
            'user_invalid_msg'    => esc_html( $settings['user_invalid_msg'] ),
            'password_length_msg' => esc_html( $settings['password_length_msg'] ),
            'invalid_email_msg'   => esc_html( $settings['invalid_email_msg'] ),
            'email_exists_msg'    => esc_html( $settings['email_exists_msg'] ),
            'invalid_url_msg'     => esc_html( $settings['invalid_url_msg'] ),
            'success_msg'         => esc_html( $settings['success_msg'] ),
            'loading_msg'         => esc_html( $settings['loading_msg'] ),
            'server_error_msg'    => esc_html( $settings['server_error_msg'] ),
        ];

            if ( is_user_logged_in() && ! Plugin::instance()->editor->is_edit_mode() ) {
                $current_user = wp_get_current_user();
                $login_as_msg = ! empty( $settings['login_as_msg'] ) ? esc_html( $settings['login_as_msg'] ) : esc_html__( 'You are logged in as', 'htmega-pro' );
                $logout_url = wp_logout_url( $current_url );
            
                printf(
                    '<div class="htmega-user-login">%1$s %2$s (<a href="%3$s">%4$s</a>)</div>',
                    esc_html( $login_as_msg ),
                    esc_html( $current_user->display_name ),
                    esc_url( $logout_url ),
                    esc_html__( 'Logout', 'htmega-pro' )
                );
            
                return;
            }
                $this->add_render_attribute(
                    'username_input_attr', [
                        'name'  => 'reg_name',
                        'id'    => 'reg_name'.esc_attr( $id ),
                        'type'  => 'text',
                        'value' => isset( $_REQUEST['reg_name'] ) ? $_REQUEST['reg_name'] : null,
                        'placeholder' => isset( $settings['username_placeholder_label'] ) ? esc_html( $settings['username_placeholder_label'] ) : __('Username', 'htmega-pro'),
                    ]
                );

                $this->add_render_attribute(
                    'password_input_attr', [
                        'name'  => 'reg_password',
                        'id'    => 'reg_password'.esc_attr( $id ),
                        'type'  => 'password',
                        'value' => isset( $_REQUEST['reg_password'] ) ? $_REQUEST['reg_password'] : null,
                        'placeholder' => isset( $settings['password_placeholder_label'] ) ? esc_html( $settings['password_placeholder_label'] ) : __('Password', 'htmega-pro'),
                    ]
                );

                $this->add_render_attribute(
                    'email_input_attr', [
                        'name'  => 'reg_email',
                        'id'    => 'reg_email'.esc_attr( $id ),
                        'type'  => 'email',
                        'value' => isset( $_REQUEST['reg_email'] ) ? $_REQUEST['reg_email'] : null,
                        'placeholder' => isset( $settings['email_placeholder_label'] ) ? esc_html( $settings['email_placeholder_label'] ) : __('Email', 'htmega-pro'),
                    ]
                );

                $this->add_render_attribute(
                    'fname_input_attr', [
                        'name'  => 'reg_fname',
                        'id'    => 'reg_fname'.esc_attr( $id ),
                        'type'  => 'text',
                        'value' => isset( $_REQUEST['reg_fname'] ) ? $_REQUEST['reg_fname'] : null,
                        'placeholder' => isset( $settings['firstname_placeholder_label'] ) ? esc_html( $settings['firstname_placeholder_label'] ) : __('First Name', 'htmega-pro'),
                    ]
                );

                $this->add_render_attribute(
                    'lname_input_attr', [
                        'name'  => 'reg_lname',
                        'id'    => 'reg_lname'.esc_attr( $id ),
                        'type'  => 'text',
                        'value' => isset( $_REQUEST['reg_lname'] ) ? $_REQUEST['reg_lname'] : null,
                        'placeholder' => isset( $settings['lastname_placeholder_label'] ) ? esc_html( $settings['lastname_placeholder_label'] ) : __('Last Name', 'htmega-pro'),
                    ]
                );

                $this->add_render_attribute(
                    'nickname_input_attr', [
                        'name'  => 'reg_nickname',
                        'id'    => 'reg_nickname'.esc_attr( $id ),
                        'type'  => 'text',
                        'value' => isset( $_REQUEST['reg_nickname'] ) ? $_REQUEST['reg_nickname'] : null,
                        'placeholder' => isset( $settings['nickname_placeholder_label'] ) ? esc_html( $settings['nickname_placeholder_label'] ) : __('Nick Name', 'htmega-pro'),
                    ]
                );

                $this->add_render_attribute(
                    'website_input_attr', [
                        'name'  => 'reg_website',
                        'id'    => 'reg_website'.esc_attr( $id ),
                        'type'  => 'text',
                        'value' => isset( $_REQUEST['reg_website'] ) ? $_REQUEST['reg_website'] : null,
                        'placeholder' => isset( $settings['website_placeholder_label'] ) ? esc_html( $settings['website_placeholder_label'] ) : __('Website', 'htmega-pro'),
                    ]
                );

                $this->add_render_attribute(
                    'bio_textarea_attr', [
                        'name'  => 'reg_bio',
                        'id'    => 'reg_bio'.$id,
                        'placeholder' => isset( $settings['bio_placeholder_label'] ) ? esc_html( $settings['bio_placeholder_label'] ) : __('Biographical Info', 'htmega-pro'),
                    ]
                );

                $this->add_render_attribute(
                    'submit_input_attr', [
                        'name'  => 'reg_submit'.$id,
                        'id'    => 'reg_submit'.$id,
                        'type'  => 'submit',
                        'value' => isset( $settings['submit_button_label'] ) ? esc_html( $settings['submit_button_label'] ) : __('REGISTER', 'htmega-pro'),
                    ]
                );
            ?>

            <div id="htmega_message_<?php echo esc_attr( $id ); ?>" class="htmega_message">&nbsp;</div>
            <div <?php echo $this->get_render_attribute_string( 'register_area_attr' ); ?>>
                <div class="htmega-register-form">
                    <?php if($settings['show_register_heading']): ?>
                    <div class="user-register-header">
                        <?php if($settings['register_heading_title']):
                            echo '<h2>'. htmega_kses_title($settings['register_heading_title']) .'</h2>';
                        endif; ?>
                        <?php if($settings['register_heading_content']):                            
                            echo '<p>' .
                            sprintf( '%1$s <a %2$s>%3$s</a>', wp_kses_post($settings['register_heading_content']) , $login_url , wp_kses_post($settings['register_heading_url_control']) ) .
                            '</p>';

                        endif; ?>
                    </div>
                    <?php endif; ?>    

                    <form id="htmega_register_form_<?php echo esc_attr( $id ); ?>" method="post" action="htmegaregisteraction">

                        <?php if( $settings['register_form_style'] == 2 ): ?>
                            <div class="htb-row">
                                <div class="htb-col-lg-6">
                                    <?php
                                        if( $settings['show_label'] == 'yes' ){
                                            echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_name'.esc_attr( $id ) ,(isset( $settings['username_label'] )) ? htmega_kses_title( $settings['username_label'] ) : esc_html__( 'Username', 'htmega-pro' ));
                                        }
                                        echo '<input '.$this->get_render_attribute_string( 'username_input_attr' ).' />';
                                    ?>
                                </div>

                                <div class="htb-col-lg-6">
                                    <?php
                                        if( $settings['show_label'] == 'yes' ){ 
                                            echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_password'.esc_attr( $id ) , (isset( $settings['password_label'] )) ? htmega_kses_title( $settings['password_label'] ) : esc_html__( 'Password', 'htmega-pro' ));
                                        }
                                        echo '<input '.$this->get_render_attribute_string( 'password_input_attr' ).' />';
                                    ?>
                                </div>

                                <div class="htb-col-lg-12">
                                    <?php
                                        if( $settings['show_label'] == 'yes' ){ 
                                            echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_email'.esc_attr( $id ) ,isset( $settings['email_label'] ) ?  htmega_kses_title( $settings['email_label'] ): esc_html__( 'Email', 'htmega-pro' ));
                                        }
                                        echo '<input '.$this->get_render_attribute_string( 'email_input_attr' ).' />';
                                    ?>
                                </div>

                                <!-- Editional Fiedls -->
                                <?php
                                    if( $settings['show_firstname'] == 'yes' ){
                                        echo '<div class="htb-col-lg-12">';
                                            if( $settings['show_label'] == 'yes' ){ 
                                                echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_fname'.esc_attr( $id ) , (isset( $settings['firstname_label'] )) ? htmega_kses_title( $settings['firstname_label']) : esc_html__( 'First Name', 'htmega-pro'));
                                            }
                                            echo '<input '.$this->get_render_attribute_string( 'fname_input_attr' ).' />';
                                        echo '</div>';
                                    }
                                    if( $settings['show_lastname'] == 'yes' ){
                                        echo '<div class="htb-col-lg-12">';
                                            if( $settings['show_label'] == 'yes' ){ 
                                                echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_lname'.esc_attr( $id ) , ( isset( $settings['lastname_label'] )) ? htmega_kses_title( $settings['lastname_label'] ) : esc_html__( 'Last Name', 'htmega-pro'));
                                            }
                                            echo '<input '.$this->get_render_attribute_string( 'lname_input_attr' ).' />';
                                        echo '</div>';
                                    }

                                    if( $settings['show_nickname'] == 'yes' ){
                                        echo '<div class="htb-col-lg-12">';
                                            if( $settings['show_label'] == 'yes' ){ 
                                                echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_nickname'.esc_attr( $id ) , ( isset( $settings['nickname_label'] )) ? htmega_kses_title( $settings['nickname_label'] ) : esc_html__( 'Nick Name', 'htmega-pro' ));
                                            }
                                            echo '<input '.$this->get_render_attribute_string( 'nickname_input_attr' ).' />';
                                        echo '</div>';
                                    }

                                    if( $settings['show_website'] == 'yes' ){
                                        echo '<div class="htb-col-lg-12">';
                                            if( $settings['show_label'] == 'yes' ){ 
                                                echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_website'.esc_attr( $id ) , (isset( $settings['website_label'] )) ? htmega_kses_title( $settings['website_label'] ) : esc_html__( 'Website', 'htmega-pro' ));
                                            }
                                            echo '<input '.$this->get_render_attribute_string( 'website_input_attr' ).' />';
                                        echo '</div>';
                                    }

                                    if( $settings['show_bio'] == 'yes' ){
                                        echo '<div class="htb-col-lg-12">';
                                            if( $settings['show_label'] == 'yes' ){ 
                                                echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_bio'.$id , ( isset( $settings['bio_label'] )) ? htmega_kses_title( $settings['bio_label'] ) : esc_html__( 'Biographical Info', 'htmega-pro' ));
                                            }
                                            echo sprintf( '<textarea %1$s>%2$s</textarea>', $this->get_render_attribute_string( 'bio_textarea_attr' ), ( isset( $_REQUEST['reg_bio'] ) ? esc_html( $_REQUEST['reg_bio'] ) : NULL ));
                                        echo '</div>';

                                    }

                                    if( $settings['show_terms'] == 'yes' ){ ?>
                                        <div class="htb-col-lg-12 termscondition">
                                            <input name="termscondition" type="checkbox" id="terms-<?php echo esc_attr( $id );?>">
                                            <?php 
                                                echo sprintf('<label for="%1$s" class="htmega-form-label">%2$s <a class="terms-conditions" href="%3$s">%4$s</a>  </label>' ,'terms-'.$id , $terms_label , $page_id , $page_title  );
                                            ?>
                                        </div>
                                    <?php }

                                ?>
                                <div class="htb-col-lg-12 htmega-submit-button">
                                    <input <?php echo $this->get_render_attribute_string( 'submit_input_attr' ); ?> />
                                </div>

                                <?php if($settings['login_option_content']) : ?>
                                    <div class="htb-col-lg-12 htmega-submit-button">
                                        <div class="separator">
                                            <?php if($settings['or_login_content_text']):
                                                echo '<span>'. wp_kses_post($settings['or_login_content_text']) .'</span>';
                                            endif; ?>
                                        </div>
                                    </div>                                    
                                <?php endif; ?>
                                
                                <?php if( $settings['login_option_button'] == 'yes' && !empty( $settings['login_button_text'] ) ){ ?>
                                    <div class="htb-col-lg-12 htmega-submit-button">
                                        <?php 
                                        echo sprintf('<a %1$s >%2$s</a>', $login_url, esc_html( $settings['login_button_text'] ) );
                                        ?>
                                    </div>
                                <?php } ?>

                            </div>

                            <?php elseif( $settings['register_form_style'] == 6 ): ?>
                            <div class="htb-row">
                                <div class="htb-col-lg-6">
                                    <?php
                                        if( $settings['show_firstname'] == 'yes' ){
                                            if( $settings['show_label'] == 'yes' ){ 
                                                echo sprintf('<label>%1$s</label>',isset( $settings['firstname_label'] ) ? htmega_kses_title( $settings['firstname_label'] ): esc_html__( 'First Name', 'htmega-pro' ));
                                            }
                                            echo '<input '.$this->get_render_attribute_string( 'fname_input_attr' ).' />';
                                        }
                                    ?>
                                </div>

                                <div class="htb-col-lg-6">
                                    <?php
                                        if( $settings['show_lastname'] == 'yes' ){
                                            if( $settings['show_label'] == 'yes' ){ 
                                                echo sprintf('<label>%1$s</label>',isset( $settings['lastname_label'] ) ? htmega_kses_title( $settings['lastname_label'] ) : esc_html__( 'Last Name', 'htmega-pro' ));
                                            }
                                            echo '<input '.$this->get_render_attribute_string( 'lname_input_attr' ).' />';
                                        }
                                    ?>
                                </div>

                                <div class="htb-col-lg-12">
                                    <?php
                                        if( $settings['show_label'] == 'yes' ){ 
                                            echo sprintf('<label>%1$s</label>', ( isset( $settings['email_label'] )) ? htmega_kses_title( $settings['email_label'] ) : esc_html__( 'Email', 'htmega-pro' ));
                                        }
                                        echo '<input '.$this->get_render_attribute_string( 'email_input_attr' ).' />';
                                    ?>
                                </div>

                                <div class="htb-col-lg-12">
                                    <?php
                                        if( $settings['show_label'] == 'yes' ){
                                            echo sprintf('<label>%1$s</label>', (isset( $settings['username_label'] )) ? htmega_kses_title( $settings['username_label'] ) : esc_html__( 'Username', 'htmega-pro' ));
                                        }
                                        echo '<input '.$this->get_render_attribute_string( 'username_input_attr' ).' />';
                                    ?>
                                </div>

                                <div class="htb-col-lg-12">
                                    <?php
                                        if( $settings['show_label'] == 'yes' ){ 
                                            echo sprintf('<label>%1$s</label>', ( isset( $settings['password_label'] )) ? htmega_kses_title( $settings['password_label'] ) : esc_html__( 'Password', 'htmega-pro' ));
                                        }
                                        echo '<input '.$this->get_render_attribute_string( 'password_input_attr' ).' />';
                                    ?>
                                </div>

                                <!-- Editional Fiedls -->
                                <?php
                                    if( $settings['show_nickname'] == 'yes' ){
                                        echo '<div class="htb-col-lg-12">';
                                            if( $settings['show_label'] == 'yes' ){ 
                                                echo sprintf('<label>%1$s</label>', ( isset( $settings['nickname_label'] )) ? htmega_kses_title( $settings['nickname_label'] ) : esc_html__( 'Nick Name', 'htmega-pro' ));
                                            }
                                            echo '<input '.$this->get_render_attribute_string( 'nickname_input_attr' ).' />';
                                        echo '</div>';
                                    }

                                    if( $settings['show_website'] == 'yes' ){
                                        echo '<div class="htb-col-lg-12">';
                                            if( $settings['show_label'] == 'yes' ){ 
                                                echo sprintf('<label>%1$s</label>', (isset( $settings['website_label'] )) ? ( $settings['website_label']) : esc_html__( 'Website', 'htmega-pro' ));
                                            }
                                            echo '<input '.$this->get_render_attribute_string( 'website_input_attr' ).' />';
                                        echo '</div>';
                                    }

                                    if( $settings['show_bio'] == 'yes' ){
                                        echo '<div class="htb-col-lg-12">';
                                            if( $settings['show_label'] == 'yes' ){ 
                                                echo sprintf('<label>%1$s</label>', ( isset( $settings['bio_label'] )) ? htmega_kses_title( $settings['bio_label'] ) : esc_html__('Biographical Info', 'htmega-pro' ));
                                            }
                                            echo sprintf( '<textarea %1$s>%2$s</textarea>', $this->get_render_attribute_string( 'bio_textarea_attr' ), ( isset( $_REQUEST['reg_bio'] ) ? esc_html( $_REQUEST['reg_bio'] ) : NULL ));
                                        echo '</div>';

                                    }

                                    if( $settings['show_terms'] == 'yes' ){ ?>
                                        <div class="htb-col-lg-12 termscondition">
                                            <input name="termscondition" type="checkbox" id="terms-<?php echo esc_attr( $id );?>">
                                            <?php 
                                                echo sprintf('<label for="%1$s" class="htmega-form-label">%2$s <a class="terms-conditions" href="%3$s">%4$s</a>  </label>' ,'terms-'.$id , $terms_label , $page_id , $page_title  );
                                            ?>
                                        </div>
                                    <?php }

                                ?>
                                <div class="htb-col-lg-12 htmega-submit-button">
                                    <input <?php echo $this->get_render_attribute_string( 'submit_input_attr' ); ?> />
                                </div>

                                <?php if($settings['login_option_content']) : ?>
                                    <div class="htb-col-lg-12 htmega-submit-button">
                                        <div class="separator">
                                            <?php if($settings['or_login_content_text']):
                                                echo '<span>'. wp_kses_post($settings['or_login_content_text']) .'</span>';
                                            endif; ?>
                                        </div>
                                    </div>                                    
                                <?php endif; ?>
                                
                                <?php if( $settings['login_option_button'] == 'yes' && !empty( $settings['login_button_text'] ) ){ ?>
                                    <div class="htb-col-lg-12 htmega-submit-button">
                                    <?php 
                                        echo sprintf('<a %1$s >%2$s</a>', $login_url, esc_html( $settings['login_button_text'] ) );
                                        ?>
                                    </div>
                                <?php } ?>
                                
                            </div>                            

                        <?php elseif( $settings['register_form_style'] == 3 ): ?>

                            <div class="htb-row">

                                <?php if( $settings['show_firstname'] == 'yes' ){ ?>
                                    <div class="htb-col-lg-12">
                                        <div class="input_box">
                                            <?php
                                                echo '<i class="fa fa-user-circle" aria-hidden="true"></i> <input '.$this->get_render_attribute_string( 'fname_input_attr' ).' />';
                                            ?>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if( $settings['show_lastname'] == 'yes' ){ ?>
                                    <div class="htb-col-lg-12">
                                        <div class="input_box">
                                            <?php
                                                echo '<i class="fa fa-user-circle" aria-hidden="true"></i> <input '.$this->get_render_attribute_string( 'lname_input_attr' ).' />';
                                            ?>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if( $settings['show_nickname'] == 'yes' ){ ?>
                                    <div class="htb-col-lg-12">
                                        <div class="input_box">
                                            <?php
                                                echo '<i class="fa fa-user-circle" aria-hidden="true"></i> <input '.$this->get_render_attribute_string( 'nickname_input_attr' ).' />';
                                            ?>
                                        </div>
                                    </div>
                                <?php } ?>

                                <div class="htb-col-lg-12">
                                    <div class="input_box">
                                        <?php
                                            echo '<i class="fa fa-user"></i><input '.$this->get_render_attribute_string( 'username_input_attr' ).' />';
                                        ?>
                                    </div>
                                </div>

                                <div class="htb-col-lg-12">
                                    <div class="input_box">
                                        <?php
                                            echo '<i class="fa fa-lock" aria-hidden="true"></i>
                                            <input '.$this->get_render_attribute_string( 'password_input_attr' ).' />';
                                        ?>
                                    </div>
                                </div>

                                <div class="htb-col-lg-12">
                                    <div class="input_box">
                                        <?php
                                            echo '<i class="fa fa-envelope"></i><input '.$this->get_render_attribute_string( 'email_input_attr' ).' />';
                                        ?>
                                    </div>
                                </div>
                                
                                <?php if( $settings['show_website'] == 'yes' ){ ?>
                                    <div class="htb-col-lg-12">
                                        <div class="input_box">
                                            <?php
                                                echo '<i class="fa fa-address-book" aria-hidden="true"></i> <input '.$this->get_render_attribute_string( 'website_input_attr' ).' />';
                                            ?>
                                        </div>
                                    </div>
                                <?php } ?>
                                
                                <?php if( $settings['show_bio'] == 'yes' ){ ?>
                                    <div class="htb-col-lg-12">
                                        <div class="input_box">
                                            <?php                                            
                                                echo sprintf( '<textarea %1$s>%2$s</textarea>' ,$this->get_render_attribute_string( 'bio_textarea_attr' ), ( isset( $_REQUEST['reg_bio'] ) ? esc_html( $_REQUEST['reg_bio'] ) : NULL ) );
                                            ?>
                                        </div>
                                    </div>
                                <?php } ?>

                                <?php if( $settings['show_terms'] == 'yes' ){ ?>
                                    <div class="htb-col-lg-12 termscondition">
                                        <input name="termscondition" type="checkbox" id="terms-<?php echo esc_attr( $id );?>">
                                        <?php 
                                            echo sprintf('<label for="%1$s" class="htmega-form-label">%2$s <a class="terms-conditions" href="%3$s">%4$s</a>  </label>' ,'terms-'.$id , $terms_label , $page_id , $page_title  );
                                        ?>
                                    </div>
                                <?php } ?>

                                <div class="htb-col-lg-12 htmega-submit-button">
                                    <input <?php echo $this->get_render_attribute_string( 'submit_input_attr' ); ?> />
                                </div>

                                <?php if($settings['login_option_content']) : ?>
                                    <div class="htb-col-lg-12 htmega-submit-button">
                                        <div class="separator">
                                            <?php if($settings['or_login_content_text']):
                                                echo '<span>'. wp_kses_post($settings['or_login_content_text']) .'</span>';
                                            endif; ?>
                                        </div>
                                    </div>                                    
                                <?php endif; ?>
                                <?php if( $settings['login_option_button'] == 'yes' && !empty( $settings['login_button_text'] ) ){ ?>
                                <div class="htb-col-lg-12 htmega-submit-button">
                                    <div class="login">
                                    <?php 
                                        echo sprintf('<a %1$s >%2$s</a>', $login_url, esc_html( $settings['login_button_text'] ) );
                                        ?>
                                    </div>
                                </div>
                                <?php } ?>

                            </div>

                        <?php elseif( $settings['register_form_style'] == 4 ): ?>
                            <div class="htb-row">
                                <?php if( $settings['show_firstname'] == 'yes' ){ ?>
                                    <div class="htb-col-lg-12">
                                        <?php
                                            if( $settings['show_label'] == 'yes' ){ 
                                                echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_fname'.esc_attr( $id ) ,isset( $settings['firstname_label'] ) ? htmega_kses_title( $settings['firstname_label']) :  esc_html__( 'First Name', 'htmega-pro' ));
                                            }
                                            echo '<input '.$this->get_render_attribute_string( 'fname_input_attr' ).' />';
                                        ?>
                                    </div>
                                <?php } ?>
                                <?php if( $settings['show_lastname'] == 'yes' ){ ?>
                                    <div class="htb-col-lg-12">
                                        <?php
                                            if( $settings['show_label'] == 'yes' ){ 
                                                echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_lname'.esc_attr( $id ) ,isset( $settings['lastname_label'] ) ? htmega_kses_title( $settings['lastname_label']) :  esc_html__( 'First Name', 'htmega-pro' ));
                                            }
                                            echo '<input '.$this->get_render_attribute_string( 'lname_input_attr' ).' />';
                                        ?>
                                    </div>
                                <?php } ?>
                                <?php if( $settings['show_nickname'] == 'yes' ){ ?>
                                    <div class="htb-col-lg-12">
                                        <?php
                                            if( $settings['show_label'] == 'yes' ){ 
                                                echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_nickname'.esc_attr( $id ) ,isset( $settings['nickname_label'] ) ? htmega_kses_title( $settings['nickname_label']) :  esc_html__( 'Nick Name', 'htmega-pro' ));
                                            }
                                            echo '<input '.$this->get_render_attribute_string( 'nickname_input_attr' ).' />';
                                        ?>
                                    </div>
                                <?php } ?>

                                <div class="htb-col-lg-12">
                                    <?php
                                        if( $settings['show_label'] == 'yes' ){
                                            echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_name'.esc_attr( $id ) ,isset( $settings['username_label'] ) ? htmega_kses_title( $settings['username_label']) :  esc_html__( 'Username', 'htmega-pro' ));
                                        }
                                        echo '<input '.$this->get_render_attribute_string( 'username_input_attr' ).' />';
                                    ?>
                                </div>
                                <div class="htb-col-lg-12">
                                    <?php
                                        if( $settings['show_label'] == 'yes' ){ 
                                            echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_password'.esc_attr( $id ) ,isset( $settings['password_label'] ) ? htmega_kses_title( $settings['password_label'] ):  esc_html__( 'Password', 'htmega-pro' ));
                                        }
                                        echo '<input '.$this->get_render_attribute_string( 'password_input_attr' ).' />';
                                    ?>
                                </div>
                                <div class="htb-col-lg-12">
                                    <?php
                                        if( $settings['show_label'] == 'yes' ){ 
                                            echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_email'.esc_attr( $id ) ,isset( $settings['email_label'] ) ? htmega_kses_title( $settings['email_label']) :  esc_html__( 'Email', 'htmega-pro' ));
                                        }
                                        echo '<input '.$this->get_render_attribute_string( 'email_input_attr' ).' />';
                                    ?>
                                </div>
                                <?php if( $settings['show_website'] == 'yes' ){ ?>
                                    <div class="htb-col-lg-12">
                                        <?php
                                            if( $settings['show_label'] == 'yes' ){ 
                                                echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_website'.esc_attr( $id ) ,isset( $settings['website_label'] ) ? htmega_kses_title( $settings['website_label']) :  esc_html__( 'Nick Name', 'htmega-pro' ));
                                            }
                                            echo '<input '.$this->get_render_attribute_string( 'website_input_attr' ).' />';
                                        ?>
                                    </div>
                                <?php } ?>
                                <?php if( $settings['show_bio'] == 'yes' ){ ?>
                                    <div class="htb-col-lg-12">
                                        <?php
                                            if( $settings['show_label'] == 'yes' ){ 
                                                echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_bio'.$id ,isset( $settings['bio_label'] ) ? htmega_kses_title( $settings['bio_label']) :  esc_html__( 'Nick Name', 'htmega-pro' ));
                                            }
                                            
                                            echo sprintf( '<textarea %1$s>%2$s</textarea>', $this->get_render_attribute_string( 'bio_textarea_attr' ), ( isset( $_REQUEST['reg_bio'] ) ? esc_html( $_REQUEST['reg_bio'] ) : NULL ) );
                                        ?>
                                    </div>
                                <?php } ?>

                                <?php if( $settings['show_terms'] == 'yes' ){ ?>
                                    <div class="htb-col-lg-12 termscondition">
                                        <input name="termscondition" type="checkbox" id="terms-<?php echo esc_attr( $id );?>">
                                        <?php 
                                            echo sprintf('<label for="%1$s" class="htmega-form-label">%2$s <a class="terms-conditions" href="%3$s">%4$s</a>  </label>' ,'terms-'.$id , $terms_label , $page_id , $page_title  );
                                        ?>
                                    </div>
                                <?php } ?>                               

                                <div class="htb-col-lg-12 htmega-submit-button">
                                    <input <?php echo $this->get_render_attribute_string( 'submit_input_attr' ); ?> />
                                </div>

                                <?php if($settings['login_option_content']) : ?>
                                    <div class="htb-col-lg-12 htmega-submit-button">
                                        <div class="separator">
                                            <?php if($settings['or_login_content_text']):
                                                echo '<span>'. wp_kses_post($settings['or_login_content_text']) .'</span>';
                                            endif; ?>
                                        </div>
                                    </div>                                    
                                <?php endif; ?>
                                
                                <?php if( $settings['login_option_button'] == 'yes' && !empty( $settings['login_button_text'] ) ){ ?>
                                    <div class="htb-col-lg-12 htmega-submit-button">
                                        <?php 
                                        echo sprintf('<a %1$s >%2$s</a>', $login_url, esc_html( $settings['login_button_text'] ) );
                                        ?>
                                    </div>
                                <?php } ?>
                            </div>

                        <?php elseif( $settings['register_form_style'] == 5 ): ?>
                            <div class="htb-row">

                                <?php if( $settings['show_firstname'] == 'yes' ){ ?>
                                    <div class="htb-col-lg-12">
                                        <?php
                                            if( $settings['show_label'] == 'yes' ){
                                                echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_fname'.esc_attr( $id ) ,isset( $settings['firstname_label'] ) ? htmega_kses_title(  $settings['firstname_label']) :  esc_html__( 'First Name', 'htmega-pro' ));
                                            }
                                            echo '<input '.$this->get_render_attribute_string( 'fname_input_attr' ).' />';
                                        ?>
                                    </div>
                                <?php } ?>

                                <?php if( $settings['show_lastname'] == 'yes' ){ ?>
                                    <div class="htb-col-lg-12">
                                        <?php
                                            if( $settings['show_label'] == 'yes' ){
                                                echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_lname'.esc_attr( $id ) ,isset( $settings['lastname_label'] ) ? htmega_kses_title(  $settings['lastname_label']) :  esc_html__( 'Last Name', 'htmega-pro' ));
                                            }
                                            echo '<input '.$this->get_render_attribute_string( 'lname_input_attr' ).' />';
                                        ?>
                                    </div>
                                <?php } ?>

                                <?php if( $settings['show_nickname'] == 'yes' ){ ?>
                                    <div class="htb-col-lg-12">
                                        <?php
                                            if( $settings['show_label'] == 'yes' ){
                                                echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_nickname'.esc_attr( $id ) ,isset( $settings['nickname_label'] ) ? htmega_kses_title(  $settings['nickname_label']) :  esc_html__( 'Nick Name', 'htmega-pro' ));
                                            }
                                            echo '<input '.$this->get_render_attribute_string( 'nickname_input_attr' ).' />';
                                        ?>
                                    </div>
                                <?php } ?>

                                <div class="htb-col-lg-12">
                                    <?php
                                        if( $settings['show_label'] == 'yes' ){
                                            echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_name'.esc_attr( $id ) ,isset( $settings['username_label'] ) ? htmega_kses_title(  $settings['username_label']) :  esc_html__( 'Username', 'htmega-pro' ));
                                        }
                                        echo '<input '.$this->get_render_attribute_string( 'username_input_attr' ).' />';
                                    ?>
                                </div>

                                <div class="htb-col-lg-12">
                                    <?php
                                        if( $settings['show_label'] == 'yes' ){ 
                                            echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_password'.esc_attr( $id ) ,isset( $settings['password_label'] ) ? htmega_kses_title( $settings['password_label']) :  esc_html__( 'Password', 'htmega-pro' ));
                                        }
                                        echo '<input '.$this->get_render_attribute_string( 'password_input_attr' ).' />';
                                    ?>
                                </div>

                                <div class="htb-col-lg-12">
                                    <?php
                                        if( $settings['show_label'] == 'yes' ){ 
                                            echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_email'.esc_attr( $id ) ,isset( $settings['email_label'] ) ? htmega_kses_title( $settings['email_label']) :  esc_html__( 'Email', 'htmega-pro' ));
                                        }
                                        echo '<input '.$this->get_render_attribute_string( 'email_input_attr' ).' />';
                                    ?>
                                </div>

                                <?php if( $settings['show_website'] == 'yes' ){ ?>
                                    <div class="htb-col-lg-12">
                                        <?php
                                            if( $settings['show_label'] == 'yes' ){
                                                echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_website'.esc_attr( $id ) ,isset( $settings['website_label'] ) ? htmega_kses_title(  $settings['website_label']) :  esc_html__( 'Website', 'htmega-pro' ));
                                            }
                                            echo '<input '.$this->get_render_attribute_string( 'website_input_attr' ).' />';
                                        ?>
                                    </div>
                                <?php } ?>

                                <?php if( $settings['show_bio'] == 'yes' ){ ?>
                                    <div class="htb-col-lg-12">
                                        <?php
                                            if( $settings['show_label'] == 'yes' ){
                                                echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_bio'.$id ,isset( $settings['bio_label'] ) ? htmega_kses_title(  $settings['bio_label']) :  esc_html__( 'Biographical Info', 'htmega-pro' ));
                                            }
                                            
                                            echo sprintf( '<textarea %1$s>%2$s</textarea>', $this->get_render_attribute_string( 'bio_textarea_attr' ), ( isset( $_REQUEST['reg_bio'] ) ? esc_html( $_REQUEST['reg_bio'] ) : NULL ) );
                                        ?>
                                    </div>
                                <?php } ?>

                                <?php if( $settings['show_terms'] == 'yes' ){ ?>
                                    <div class="htb-col-lg-12 termscondition">
                                        <input name="termscondition" type="checkbox" id="terms-<?php echo esc_attr( $id );?>">
                                        <?php 
                                            echo sprintf('<label for="%1$s" class="htmega-form-label">%2$s <a class="terms-conditions" href="%3$s">%4$s</a>  </label>' ,'terms-'.$id , $terms_label , $page_id , $page_title  );
                                        ?>
                                    </div>
                                <?php } ?>  

                                <div class="htb-col-lg-12 htmega-submit-button">
                                    <input <?php echo $this->get_render_attribute_string( 'submit_input_attr' ); ?> />
                                </div>

                                <?php if($settings['login_option_content']) : ?>
                                    <div class="htb-col-lg-12 htmega-submit-button">
                                        <div class="separator">
                                            <?php if($settings['or_login_content_text']):
                                                echo '<span>'. wp_kses_post($settings['or_login_content_text']) .'</span>';
                                            endif; ?>
                                        </div>
                                    </div>                                    
                                <?php endif; ?>
                                
                                <?php if( $settings['login_option_button'] == 'yes' && !empty( $settings['login_button_text'] ) ){ ?>
                                    <div class="htb-col-lg-12 htmega-submit-button">
                                        <?php 
                                        echo sprintf('<a %1$s >%2$s</a>', $login_url, esc_html( $settings['login_button_text'] ) );
                                        ?>
                                    </div>
                                <?php } ?>
                            </div>

                        <?php else:?>
                            <div class="htmega-fields">
                                <?php
                                    // Default Field
                                    if( $settings['show_label'] == 'yes' ){
                                        echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_name'.esc_attr( $id ) ,isset( $settings['username_label'] ) ? htmega_kses_title( $settings['username_label']) :  esc_html__( 'Username', 'htmega-pro' ));
                                    }
                                    echo '<input '.$this->get_render_attribute_string( 'username_input_attr' ).' />';

                                    if( $settings['show_label'] == 'yes' ){ 
                                        echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_password'.esc_attr( $id ) ,isset( $settings['password_label'] ) ? htmega_kses_title( $settings['password_label']) :  esc_html__( 'Password', 'htmega-pro' ));
                                    }
                                    echo '<input '.$this->get_render_attribute_string( 'password_input_attr' ).' />';

                                    if( $settings['show_label'] == 'yes' ){ 
                                        echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_email'.esc_attr( $id ) ,isset( $settings['email_label'] ) ? htmega_kses_title( $settings['email_label']) :  esc_html__( 'Email', 'htmega-pro' ));
                                    }
                                    echo '<input '.$this->get_render_attribute_string( 'email_input_attr' ).' />';

                                    // Additionnal Field
                                    if( $settings['show_firstname'] == 'yes' ){
                                        if( $settings['show_label'] == 'yes' ){ 
                                            echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_fname'.esc_attr( $id ) ,isset( $settings['firstname_label'] ) ? htmega_kses_title( $settings['firstname_label']) :  esc_html__('First Name', 'htmega-pro' ));
                                        }
                                        echo '<input '.$this->get_render_attribute_string( 'fname_input_attr' ).' />';
                                    }
                                    if( $settings['show_lastname'] == 'yes' ){
                                        if( $settings['show_label'] == 'yes' ){ 
                                            echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_lname'.esc_attr( $id ) ,isset( $settings['lastname_label'] ) ? htmega_kses_title( $settings['lastname_label']) :  esc_html__( 'Last Name', 'htmega-pro' ));
                                        }
                                        echo '<input '.$this->get_render_attribute_string( 'lname_input_attr' ).' />';
                                    }
                                    if( $settings['show_nickname'] == 'yes' ){
                                        if( $settings['show_label'] == 'yes' ){ 
                                            echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_nickname'.esc_attr( $id ) ,isset( $settings['nickname_label'] ) ? htmega_kses_title( $settings['nickname_label']) :  esc_html__( 'Nick Name', 'htmega-pro' ));
                                        }
                                        echo '<input '.$this->get_render_attribute_string( 'nickname_input_attr' ).' />';
                                    }
                                    if( $settings['show_website'] == 'yes' ){
                                        if( $settings['show_label'] == 'yes' ){ 
                                            echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_website'.esc_attr( $id ) ,isset( $settings['website_label'] ) ? htmega_kses_title( $settings['website_label']) :  esc_html__( 'Website', 'htmega-pro' ));
                                        }
                                        echo '<input '.$this->get_render_attribute_string( 'website_input_attr' ).' />';
                                    }
                                    if( $settings['show_bio'] == 'yes' ){
                                        if( $settings['show_label'] == 'yes' ){ 
                                            echo sprintf('<label for="%1$s">%2$s</label>' ,'reg_bio'.$id , isset( $settings['bio_label'] ) ? htmega_kses_title( $settings['bio_label']) :  esc_html__('Biographical Info', 'htmega-pro' ));
                                        }
                                        
                                        echo sprintf( '<textarea %1$s>%2$s</textarea>', $this->get_render_attribute_string( 'bio_textarea_attr' ), ( isset( $_REQUEST['reg_bio'] ) ? esc_html( $_REQUEST['reg_bio'] ) : NULL ));
                                    }

                                    if( $settings['show_terms'] == 'yes' ){ ?>
                                        <div class="termscondition">
                                            <input name="termscondition" type="checkbox" id="terms-<?php echo esc_attr( $id );?>">
                                            <?php 
                                                echo sprintf('<label for="%1$s" class="htmega-form-label">%2$s <a class="terms-conditions" href="%3$s">%4$s</a>  </label>' ,'terms-'.$id , $terms_label , $page_id , $page_title  );
                                            ?>

                                        </div>
                                    <?php }
                                ?>
                                <div class="htb-col-lg-12 htmega-submit-button">
                                    <input <?php echo $this->get_render_attribute_string( 'submit_input_attr' ); ?> />
                                </div>

                                <?php if( $settings['login_option_content'] ) : ?>
                                    <div class="htb-col-lg-12 htmega-submit-button">
                                        <div class="separator">
                                            <?php if( $settings['or_login_content_text'] ):
                                                echo '<span>'. wp_kses_post( $settings['or_login_content_text'] ) .'</span>';
                                            endif; ?>
                                        </div>
                                    </div>                                    
                                <?php endif; ?>
                                
                                <?php if( $settings['login_option_button'] == 'yes' && !empty( $settings['login_button_text'] ) ){ ?>
                                    <div class="htb-col-lg-12 htmega-submit-button">
                                        <?php
                                        echo sprintf('<a %1$s >%2$s</a>', $login_url, esc_html( $settings['login_button_text'] ) );
                                        ?>
                                    </div>
                                 <?php } ?>
                            </div>
                        <?php endif;?>
                    </form>
                </div>
            </div>

        <?php
        $this->htmega_register_request( $id, $settings['redirect_page'], $redirect_url, $messages );

    }

    public function htmega_register_request( $id=null, $reddirectstatus=null , $redirect_url=null, $messages=null, $role=null ){
        ?>
            <script type="text/javascript">
                jQuery(document).ready(function($) {
                    "use strict";

                    var ajaxurl = '<?php echo admin_url('admin-ajax.php'); ?>';
                    var loadingmessage = '<?php echo !empty( $messages['loading_msg'] ) ? wp_kses_post( $messages['loading_msg'] ) :  esc_html__( 'Please Wait...','htmega-pro' ); ?>';
                    var form_id = 'form#htmega_register_form_<?php echo esc_attr( $id ); ?>';
                    var button_id = '#reg_submit<?php echo esc_attr( $id ); ?>';
                    var nonce = '<?php echo wp_create_nonce( 'htmega_register_nonce' ); ?>';
                    var messages = '<?php echo wp_json_encode( htmega_clean ($messages) ); ?>';
                    var redirect = '<?php echo esc_attr( $reddirectstatus ); ?>';

                    $( button_id ).on('click', function(){

                        $('#htmega_message_<?php echo esc_attr( $id ); ?>').html('<span class="htmega_lodding_msg">'+ loadingmessage +'</span>').fadeIn();

                        var data = {
                            action:         "htmega_ajax_register",
                            nonce:          nonce,
                            reg_name:       $( form_id + ' #reg_name<?php echo esc_attr( $id ); ?>').val(),
                            reg_password:   $( form_id + ' #reg_password<?php echo esc_attr( $id ); ?>').val(),
                            reg_email:      $( form_id + ' #reg_email<?php echo esc_attr( $id ); ?>').val(),
                            reg_website:    $( form_id + ' #reg_website<?php echo esc_attr( $id ); ?>').val(),
                            reg_fname:      $( form_id + ' #reg_fname<?php echo esc_attr( $id ); ?>').val(),
                            reg_lname:      $( form_id + ' #reg_lname<?php echo esc_attr( $id ); ?>').val(),
                            reg_nickname:   $( form_id + ' #reg_nickname<?php echo esc_attr( $id ); ?>').val(),
                            reg_bio:        $( form_id + ' #reg_bio<?php echo esc_attr( $id ); ?>').val(),
                            messages:       messages,
                        };
                        $.ajax({  
                            type: 'POST',
                            dataType: 'json',  
                            url:  ajaxurl,
                            data: data,
                            success: function( msg ){
                                if ( msg.registerauth == true ){
                                    $('#htmega_message_<?php echo esc_attr( $id ); ?>').html('<div class="htmega_success_msg alert alert-success">'+ msg.message +'</div>').fadeIn();
                                    if( redirect === 'yes' ){
                                        document.location.href = '<?php echo esc_url( $redirect_url ); ?>';
                                    }
                                }else{
                                    $('#htmega_message_<?php echo esc_attr( $id ); ?>').html('<div class="htmega_invalid_msg alert alert-danger">'+ msg.message +'</div>').fadeIn();
                                }
                            }  
                        });
                        return false;
                      
                    });

                });

            </script>
        <?php
    }

}