<?php
namespace HTMegaPro\Elementor\Widget;
use Elementor\Plugin as Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\HTMega_Icon_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Repeater;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class HTMega_Video_Gallery_Element extends Widget_Base {

    public function get_name() {
        return 'htmega-video-gallery-addons';
    }
    
    public function get_title() {
        return __( 'Video Gallery', 'htmega-pro' );
    }

    public function get_icon() {
        return 'htmega-icon eicon-media-carousel';
    }

    public function get_categories() {
        return [ 'htmega-pro' ];
    }

    public function get_style_depends() {
        return [ 'magnific-popup','slick'];
    }
    public function get_script_depends() {
        return [
            'imagesloaded',
            'isotope',
            'slick',
            'magnific-popup'
        ];
	}
    public function get_keywords() {
        return ['video gallery', 'gallery','video popup', 'youtube gallery', 'vimeo gallery', 'video carousel', 'video grid', 'htmega', 'ht mega'];
    }

    public function get_help_url() {
        return 'https://wphtmega.com/docs/';
    }
    protected function is_dynamic_content():bool {
		return false;
	}
    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Video Content', 'htmega-pro' ),
            ]
        );
            $repeater = new \Elementor\Repeater();

                $repeater->add_control(
                    'video_type',
                    [
                        'label' =>esc_html__( 'Video Source', 'htmega-pro' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'youtube',
                        'options' => [
                            'youtube'    => esc_html__( 'YouTube', 'htmega-pro' ),
                            'vimeo'      => esc_html__( 'Vimeo', 'htmega-pro' ),
                            'selfhosted' => esc_html__( 'Self Hosted', 'htmega-pro' )
                        ],
                    ]
                );
                
                $repeater->add_control(
                    'video_url',
                    [
                        'label'          => esc_html__( 'URL', 'htmega-pro' ),
                        'type'           => Controls_Manager::URL,
                        'placeholder'    => esc_url('https://www.youtube.com/watch?v=z_9Z9VWhaEQ'),
                        'dynamic'        => [
                            'active'     => true,
                        ],
                        'label_block' => true,
                        'condition'      => [
                            'video_type' => ['youtube','vimeo']
                        ]
                    ]
                );

                $repeater->add_control(
                    'self_hosted_video',
                    [
                        'label' => esc_html__( 'Upload Video', 'htmega-pro' ),
                        'type' => Controls_Manager::MEDIA,
                        'media_type' => 'video',
                        'condition'      => [
                            'video_type' => 'selfhosted'
                        ]
                    ]
                );
                $repeater->add_control(
                    'video_title',
                    [
                        'label' =>esc_html__( 'Video Title', 'htmega-pro' ),
                        'type' => Controls_Manager::TEXT,
                        'label_block' => true,
                        'dynamic' => [
                            'active' => true,
                        ],
                    ]
                );
                $repeater->add_control(
                    'video_des',
                    [
                        'label' =>esc_html__( 'Video Description', 'htmega-pro' ),
                        'type' => Controls_Manager::TEXTAREA,
                        'dynamic' => [
                            'active' => true,
                        ],
                        'label_block' => true,
                    ]
                );
                $repeater->add_control(
                    'filter_label',
                    [
                        'label' =>esc_html__( 'Filter Label', 'htmega-pro' ),
                        'type' => Controls_Manager::TEXT,
                        'dynamic' => [
                            'active' => true,
                        ],
                        'label_block' => true,
                    ]
                );
                $repeater->add_control(
                    'video_thumbnail',
                    [
                        'label' => esc_html__( 'Custom Thumbnail', 'htmega-pro' ),
                        'type' => Controls_Manager::MEDIA,
                        'dynamic' => [
                            'active' => true,
                        ],
                    ]
                );


            $this->add_control(
                'item_list',
                [
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                    'default' => [
                        [
                            'video_title' => esc_html__( 'Video Title One', 'htmega-pro' ),
                            'video_type'  => 'youtube',
                            'video_url' => ['url' => 'https://www.youtube.com/watch?v=z_9Z9VWhaEQ'],
                        ],
                        [
                            'video_title' => esc_html__( 'Video Title Two', 'htmega-pro' ),
                            'video_type'  => 'youtube',
                            'video_url' => ['url' => 'https://www.youtube.com/watch?v=z_9Z9VWhaEQ'],
                        ],
                        [
                            'video_title' => esc_html__( 'Video Title Three', 'htmega-pro' ),
                            'video_type'  => 'youtube',
                            'video_url' => ['url' => 'https://www.youtube.com/watch?v=z_9Z9VWhaEQ'],
                        ]
                    ],
                    'title_field' => '{{video_title}}',
                ]
            );

        $this->end_controls_section();

        // Carousel Settings
        $this->start_controls_section(
            'video_gallery_layout_section',
            [
                'label' => esc_html__( 'Layout', 'htmega-pro' ),
            ]
        );
        $this->add_control(
            'video_gallery_layout',
            [
                'label' => __( 'Layout', 'htmega-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'grid',
                'options' => [
                    'grid'      => __( 'Grid', 'htmega-pro' ),
                    'carousel'      => __( 'Carousel', 'htmega-pro' ),
                ],
                
            ]
        );
        $this->add_responsive_control(
            'grid_column',
            [
                'label' => esc_html__( 'Column', 'htmega-pro' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    "100.00"  => esc_html__('Style One','htmega-pro'),
                    "50.00"  => esc_html__('Style Two','htmega-pro'),
                    "33.33"   => esc_html__('Style Three','htmega-pro'),
                    "25.00"  => esc_html__('Style Four','htmega-pro'),
                    "20.00"   => esc_html__('Style Five','htmega-pro'),
                ],
                'desktop_default' => "33.33",
                'tablet_default' => "50",
                'mobile_default' => "100",
                'selectors' => [
                    '{{WRAPPER}} .htmega-flex-column'   => 'flex: 0 0 {{VALUE}}%; max-width:{{VALUE}}%;width:{{VALUE}}%',
                ],
                'frontend_available' => true,
                'condition' =>[
                    'video_gallery_layout' =>'grid'
                ],
                'separator' =>'before'
            ]
        );
        $this->add_responsive_control(
            'slitems',
            [
                'label' => esc_html__( 'Slide Items', 'htmega-pro' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 10,
                'step' => 1,
                'default' => 3,
                'condition' =>[
                    'video_gallery_layout' =>'carousel'
                ],
                'separator' =>'before'
            ]
        );
        $this->add_responsive_control(
            'slscroll_columns',
            [
                'label' => __('Slide Item to Scroll', 'htmega-pro'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 10,
                'step' => 1,
                'default' => 1,
                'condition' =>[
                    'video_gallery_layout' =>'carousel'
                ]
            ]
        );
        $this->add_responsive_control(
            'gird_gutter',
            [
                'label' => __('Column Gap', 'htmega-pro'),
                'description' => __('This Column gap value shows in multiplying 2', 'htmega-pro'),
                'type' => Controls_Manager::NUMBER,
                'default' => 10,
                'selectors' => [
                    '{{WRAPPER}} .htmega-pro-row .htmega-flex-column,{{WRAPPER}} .slick-slide' => 'padding: {{SIZE}}px;',
                    '{{WRAPPER}} .htmega-pro-row, {{WRAPPER}} .slick-list,{{WRAPPER}} .htmega-video-gallery-items-wrapper' => 'margin: -{{SIZE}}px;',
                    '{{WRAPPER}} .slick-slide .htmega-flex-column' => 'padding: 0px;',
                ],
            ]
        );            
        $this->add_control(
            'slider_resolution_toggle',
            [
                'type' =>Controls_Manager::POPOVER_TOGGLE,
                'label' => esc_html__( 'Responsive Breakpoints', 'htmega-pro' ),
                'label_off' => esc_html__( 'Default', 'htmega-pro' ),
                'label_on' => esc_html__( 'Custom', 'htmega-pro' ),
                'return_value' => 'yes',
                'condition' =>[
                    'video_gallery_layout' =>'carousel'
                ]
            ]
        );
        
        $this->start_popover();
        
            $this->add_control(
                'tablet_width',
                [
                    'label' => __('Tablet Breakpoints', 'htmega-pro'),
                    'description' => __('The resolution to tablet device.', 'htmega-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 991,
                    'separator' => 'after',
                ]
            );

            $this->add_control(
                'mobile_width',
                [
                    'label' => __('Mobile Breakpoints', 'htmega-pro'),
                    'description' => __('The resolution to mobile device.', 'htmega-pro'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 575,
                ]
            );
            $this->end_popover();

        $this->add_control(
            'slautolay',
            [
                'label' => esc_html__( 'Slide Auto Play', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'separator' => 'before',
                'default' => 'no',
                'condition' => [
                    'slarrows' => 'yes',
                    'video_gallery_layout' =>'carousel'
                ]
            ]
        );
        $this->add_control(
            'slautoplay_speed',
            [
                'label' => __('Autoplay Speed', 'htmega-pro'),
                'type' => Controls_Manager::NUMBER,
                'default' => 3000,
                'condition' => [
                    'slautolay' => 'yes',
                    'video_gallery_layout' =>'carousel'
                ]
            ]
        );

        $this->add_control(
            'slanimation_speed',
            [
                'label' => __('Autoplay Animation Speed', 'htmega-pro'),
                'type' => Controls_Manager::NUMBER,
                'default' => 300,
                'condition' => [
                    'slautolay' => 'yes',
                    'video_gallery_layout' =>'carousel'
                ]
            ]
        );
        $this->add_control(
            'slloop',
            [
                'label' => esc_html__( 'Slide Repeat', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [
                    'slarrows' => 'yes',
                    'video_gallery_layout' =>'carousel'
                ]
            ]
        );
        $this->add_control(
            'slarrows',
            [
                'label' => esc_html__( 'Slider Arrow', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' =>[
                    'video_gallery_layout' =>'carousel'
                ]
            ]
        );
        $this->add_control(
            'slprevicon',
            [
                'label' => __( 'Prev Icon', 'htmega-pro' ),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value'=>'fas fa-angle-left',
                    'library'=>'fa-solid',
                ],
                'condition' => [
                    'slarrows' => 'yes',
                    'video_gallery_layout' =>'carousel'
                ],
                'separator' =>'before'
            ]
        );

        $this->add_control(
            'slnexticon',
            [
                'label' => __( 'Next Icon', 'htmega-pro' ),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value'=>'fas fa-angle-right',
                    'library'=>'fa-solid',
                ],
                'condition' => [
                    'slarrows' => 'yes',
                    'video_gallery_layout' =>'carousel'
                ]
            ]
        );

        $this->add_control(
            'sldots',
            [
                'label' => esc_html__( 'Slider Dots', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [
                    'video_gallery_layout' =>'carousel'
                ],
            ]
        );
        $this->end_controls_section();
        // Carousel Settings
        $this->start_controls_section(
            'video_gallery_settings_section',
            [
                'label' => esc_html__( 'Settings', 'htmega-pro' ),
            ]
        );

        $this->add_control(
            'video_show_in',
            [
                'label' => __( 'Video Show In ', 'htmega-pro' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'popup',
                'options' => [
                    'popup'      => __( 'Popup', 'htmega-pro' ),
                    'inline'      => __( 'Inline', 'htmega-pro' ),
                ],
                
            ]
        );
        $this->add_control(
            'play_icon',
            [
                'label' => __( 'Icon', 'htmega-pro' ),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'far fa-play-circle',
                    'library' => 'fa-solid',
                ],
                'condition' =>['video_show_in'=> 'popup'],
            ]
        );
        $this->add_control(
            'button_on_hover',
            [
                'label' => esc_html__( 'Button On Hover', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
                'condition' =>['video_show_in'=> 'popup'],
            ]
        );
        $this->add_control(
            'filter_enable',
            [
                'label' => esc_html__( 'Filter Show/Hide', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
                'separator'=>'before',
                'condition' => ['video_gallery_layout'=> 'grid'],
            ]
        );                               

        $this->add_control(
            'all_btn_show_hide',
            [
                'label' => esc_html__( 'All Button Show/Hide', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'video_gallery_layout'=> 'grid',
                    'filter_enable'=> 'yes'
                ],
            ]
        );
        $this->add_control(
            'all_btn_text',
            [
                'label' => __( 'All Button Text', 'htmega-pro' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'All',
                'title' => __( 'Enter All Button Text', 'htmega-pro' ),
                'condition' => [
                    'video_gallery_layout'=> 'grid',
                    'all_btn_show_hide' => 'yes',
                    'filter_enable'=> 'yes'
                ]
            ]
        );

        $this->add_control(
            'show_video_title',
            [
                'label' => esc_html__( 'Video Title', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
                'separator'=>'before',
            ]
        );
        $this->add_control(
            'show_video_description',
            [
                'label' => esc_html__( 'Video Description', 'htmega-pro' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->end_controls_section();
        // content section end
        // Video Item style section
        $this->start_controls_section(
            'box_style',
            [
                'label' => esc_html__( 'Video Item', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_responsive_control(
                'box_normal_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-video-gallery-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'box_normal_background',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-video-gallery-item',
                ]
            );

            $this->start_controls_tabs('gallery_item_box_style_tabs');
                
                // Box Normal Style Tab
                $this->start_controls_tab(
                    'box_normal_style_tab',
                    [
                        'label' => esc_html__( 'Normal', 'htmega-pro' ),
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'box_normal_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-video-gallery-item',
                        ]
                    );

                    $this->add_responsive_control(
                        'box_normal_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-video-gallery-item' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'box_normal_shadow',
                            'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-video-gallery-item',
                        ]
                    );

                $this->end_controls_tab();

                // Box Hover Style Tab
                $this->start_controls_tab(
                    'box_hover_style_tab',
                    [
                        'label' => esc_html__( 'Hover', 'htmega-pro' ),
                    ]
                );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'box_hover_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-video-gallery-item:hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'box_hover_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-video-gallery-item:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'box_hover_shadow',
                            'label' => esc_html__( 'Box Shadow', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-video-gallery-item:hover',
                        ]
                    );

                $this->end_controls_tab();

            $this->end_controls_tabs();

        $this->end_controls_section();
        // item style end


        // Thumbnail Style
        $this->start_controls_section(
            'thumbnials_style_section',
            [
                'label' => esc_html__( 'Thumbnails', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['video_show_in' =>'popup']
            ]
        );
            $this->add_responsive_control(
                'thumbnial_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-video-gallery-thumbnail' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                    ],
                ]
            );
            $this->start_controls_tabs('thumbnial_style_tabs');
                
                // Box Normal Style Tab
                $this->start_controls_tab(
                    'thumbnial_style_tab',
                    [
                        'label' => esc_html__( 'Normal', 'htmega-pro' ),
                    ]
                );
                    $this->add_responsive_control(
                        'thumbnail_overlay_color',
                        [
                            'label' => __( 'Overlay Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '#0000002e',
                            'selectors' => [
                                '{{WRAPPER}} .htmega-video-gallery-thumbnail::after' => 'background: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'thumbnial_box_normal_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-video-gallery-thumbnail',
                        ]
                    );

                    $this->add_responsive_control(
                        'thumbnial_normal_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-video-gallery-thumbnail' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab();

                // Box Hover Style Tab
                $this->start_controls_tab(
                    'thumbnial_hover_style_tab',
                    [
                        'label' => esc_html__( 'Hover', 'htmega-pro' ),
                    ]
                );
                    $this->add_responsive_control(
                        'thumbnail_overlay_color_hover',
                        [
                            'label' => __( 'Overlay Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .htmega-video-gallery-thumbnail:hover::after' => 'background: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'thumbnial_hover_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-video-gallery-thumbnail:hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'thumbnial_hover_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-video-gallery-thumbnail:hover' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
                            ],
                        ]
                    );

                $this->end_controls_tab();

            $this->end_controls_tabs();

        $this->end_controls_section();
        // item style end

         $this->__filterable_menu_style();
         $this->__video_gallery_button_style();
         $this->__video_gallery_content_box_style();
        $this->start_controls_section(
            'htmega_carousel_arrow_style',
            [
                'label'     => __( 'Navigation', 'htmega-pro' ),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' =>[
                    'slarrows'  => 'yes',
                    'video_gallery_layout' =>'carousel'
                ],
            ]
            );
            $this->add_responsive_control(
                'htmega_carousel_arrow_height',
                [
                    'label' => __( 'Height', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 45,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'height: {{SIZE}}{{UNIT}};opacity:1;',
                    ],
                ]
            );

            $this->add_responsive_control(
                'htmega_carousel_arrow_width',
                [
                    'label' => __( 'Width', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 45,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'arrow_position_opover',
                [
                    'type' =>Controls_Manager::POPOVER_TOGGLE,
                    'label' => esc_html__( 'Positions', 'htmega-pro' ),
                    'label_off' => esc_html__( 'Default', 'htmega-pro' ),
                    'label_on' => esc_html__( 'Custom', 'htmega-pro' ),
                    'return_value' => 'yes',
                ]
            );
        
            $this->start_popover();
            
            $this->add_responsive_control(
                'htmega_carousel_arrow_position',
                [
                    'label' => __( 'Vertical Position', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => -100,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => '',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'top: {{SIZE}}{{UNIT}};',
                    ], 
                    'condition' => ['arrow_position_opover' => 'yes' ],
                ]
            );

            $this->add_responsive_control(
                'htmega_carousel_arrow_position_x',
                [
                    'label' => __( 'Horizontal Position', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => -100,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => '',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pro-carousel-activation .htmega-carosul-next.slick-arrow' => 'right: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-pro-carousel-activation .htmega-carosul-prev.slick-arrow' => 'left: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => ['arrow_position_opover' => 'yes' ],
                ]
            );

            $this->end_popover();
            $this->add_responsive_control(
                'htmega_carousel_arrow_fontsize',
                [
                    'label' => __( 'Font Size', 'htmega-pro' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                            'step' => 1,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 32,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow svg' => 'width: {{SIZE}}{{UNIT}};height: auto;',
                    ],
                ]
            );
            $this->add_control(
                'navigaton_border_heading',
                [
                    'label' => __( 'Colors and Border', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $this->start_controls_tabs( 'carousel_arrow_style_tabs' );
    
                // Normal tab Start
                $this->start_controls_tab(
                    'carousel_arrow_style_normal_tab',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                );
    
                    $this->add_responsive_control(
                        'htmega_carousel_arrow_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '#000000',
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow svg path' => 'fill: {{VALUE}}; height: auto; transition: all 0.3s ease-in-out;',
                            ],
                        ]
                    );
    
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'carousel_arrow_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow',
                        ]
                    );
    
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'htmega_carousel_arrow_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow',
                        ]
                    );
    
                    $this->add_responsive_control(
                        'htmega_carousel_arrow_border_radius',
                        [
                            'label' => __( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
        
                $this->end_controls_tab(); // Normal tab end
    
                // Hover tab Start
                $this->start_controls_tab(
                    'carousel_arrow_style_hover_tab',
                    [
                        'label' => __( 'Hover', 'htmega-pro' ),
                    ]
                );
    
                    $this->add_control(
                        'htmega_carousel_arrow_hover_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'default' => '#ffffff',
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow:hover' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow:hover svg path' => 'fill: {{VALUE}};',
                            ],
                        ]
                    );
    
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'carousel_arrow_hover_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow:hover',
                        ]
                    );
    
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'htmega_carousel_arrow_hover_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow:hover',
                        ]
                    );
    
                    $this->add_responsive_control(
                        'htmega_carousel_arrow_hover_border_radius',
                        [
                            'label' => __( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-pro-carousel-activation .slick-arrow:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
    
                $this->end_controls_tab(); // Hover tab end
    
            $this->end_controls_tabs();
    
        $this->end_controls_section(); // Style arrow style end
    
    
        // Style Dots style start
        $this->start_controls_section(
            'htmega_carousel_dots_style',
            [
                'label'     => __( 'Pagination', 'htmega-pro' ),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' =>[
                    'sldots'  => 'yes',
                ],
            ]
            );

            $this->start_controls_tabs( 'carousel_dots_style_tabs' );

            // Normal tab Start
            $this->start_controls_tab(
                'carousel_dots_style_normal_tab',
                [
                    'label' => __( 'Normal', 'htmega-pro' ),
                ]
            );

                $this->add_responsive_control(
                    'carousel_dots_pagination_align',
                    [
                        'label' => __( 'Alignment', 'htmega-pro' ),
                        'type' => Controls_Manager::CHOOSE,
                        'options' => [
                            'left' => [
                                'title' => __( 'Left', 'htmega-pro' ),
                                'icon' => 'eicon-text-align-left',
                            ],
                            'center' => [
                                'title' => __( 'Center', 'htmega-pro' ),
                                'icon' => 'eicon-text-align-center',
                            ],
                            'right' => [
                                'title' => __( 'Right', 'htmega-pro' ),
                                'icon' => 'eicon-text-align-right',
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots' => 'text-align: {{VALUE}};',
                        ],
                    ]
                );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'carousel_dots_background',
                        'label' => __( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li button',
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'htmega_carousel_dots_border',
                        'label' => __( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li button',
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_dots_border_radius',
                    [
                        'label' => __( 'Border Radius', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_dots_height',
                    [
                        'label' => __( 'Height', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 200,
                                'step' => 1,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 15,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li button,{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li' => 'height: {{SIZE}}px;',
                        ],
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_dots_width',
                    [
                        'label' => __( 'Width', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px'],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 200,
                                'step' => 1,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 15,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li button,{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li' => 'width: {{SIZE}}px !important;',
                        ],
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_dots_position_x',
                    [
                        'label' => __( 'Horizontal Position', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'range' => [
                            'px' => [
                                'min' => -200,
                                'max' => 200,
                                'step' => 1,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => '',
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots' => 'bottom: {{SIZE}}px;',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'htmega_carousel_dots_pagination_inner_space',
                    [
                        'label' => __( 'Inner Gap', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%' ],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 200,
                                'step' => 1,
                            ],
                            '%' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => '',
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li:not(:last-child)' => 'margin-right: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );

            $this->end_controls_tab(); // Normal tab end

            // Hover tab Start
            $this->start_controls_tab(
                'carousel_dots_style_hover_tab',
                [
                    'label' => __( 'Active', 'htmega-pro' ),
                ]
            );

                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'carousel_dots_hover_background',
                        'label' => __( 'Background', 'htmega-pro' ),
                        'types' => [ 'classic', 'gradient' ],
                        'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li.slick-active button',
                    ]
                );

                $this->add_group_control(
                    Group_Control_Border::get_type(),
                    [
                        'name' => 'htmega_carousel_dots_hover_border',
                        'label' => __( 'Border', 'htmega-pro' ),
                        'selector' => '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li.slick-active button',
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_dots_hover_border_radius',
                    [
                        'label' => __( 'Border Radius', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li.slick-active button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'htmega_carousel_dots_hover_height',
                    [
                        'label' => __( 'Height', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 200,
                                'step' => 1,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 15,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li.slick-active button,{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li.slick-active' => 'height: {{SIZE}}px;',
                        ],
                    ]
                );

                $this->add_responsive_control(
                    'htmega_carousel_dots_hover_width',
                    [
                        'label' => __( 'Width', 'htmega-pro' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px'],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 200,
                                'step' => 1,
                            ],
                        ],
                        'default' => [
                            'unit' => 'px',
                            'size' => 15,
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li.slick-active button,{{WRAPPER}} .htmega-pro-carousel-activation .slick-dots li.slick-active' => 'width: {{SIZE}}px !important;',
                        ],
                    ]
                );
            $this->end_controls_tab(); // Hover tab end

        $this->end_controls_tabs();

    $this->end_controls_section(); // Style dots style end


        // Caption Style
        $this->start_controls_section(
			'filter_label_styles_section',
			[
				'label' => esc_html__( 'Caption', 'htmega-pro' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'filter_label_switcher' => 'yes'
				]
			]
		);

		$this->add_control(
			'caption_color',
			[
				'label'  => esc_html__( 'Color', 'htmega-pro' ),
				'type' => Controls_Manager::COLOR,
				'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .htmega-flip-caption' => 'color: {{VALUE}}',
				],
			]
		);
			
		$this->add_control(
			'caption_background_color',
			[
				'label'  => esc_html__( 'Background Color', 'htmega-pro' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .htmega-flip-caption' => 'background-color: {{VALUE}}',
				],
			]
		);
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'caption_typography',
                'selector' => '{{WRAPPER}} .htmega-flip-caption',
            ]
        );

		$this->add_responsive_control(
			'flipcaption_padding',
			[
				'label' => esc_html__( 'Padding', 'htmega-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .htmega-flip-caption' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'flipcaption_margin',
			[
				'label' => esc_html__( 'Margin', 'htmega-pro' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .htmega-flip-caption' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'flipcaption_alignment',
			[
				'label' => esc_html__( 'Alignment', 'htmega-pro' ),
				'type' => Controls_Manager::CHOOSE,
				'label_block' => false,
				'default' => 'center',
				'separator' => 'before',
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'htmega-pro' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'htmega-pro' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'htmega-pro' ),
						'icon' => 'eicon-text-align-right',
					],
				],
                'selectors' => [
					'{{WRAPPER}} .htmega-flip-caption' => 'text-align: {{VALUE}};',
				]
			]
		);

		$this->end_controls_section();

    }

    protected function render( $instance = [] ) {
        $settings   = $this->get_settings_for_display();
        $items = $this->get_settings_for_display('item_list');
        $sectionid         = $this->get_id();
        $video_show_in =  $settings['video_show_in'];
        $slider_settings = [
            'sectionid'=> esc_url( $sectionid ),
            'filter_enable' => ( 'yes' === $settings['filter_enable'] ),
            'is_edit_mode' => \Elementor\Plugin::$instance->editor->is_edit_mode(),
            'arrows' => ('yes' === $settings['slarrows']),
            'arrow_prev_txt' => HTMega_Icon_manager::render_icon( $settings['slprevicon'], [ 'aria-hidden' => 'true' ] ),
            'arrow_next_txt' => HTMega_Icon_manager::render_icon( $settings['slnexticon'], [ 'aria-hidden' => 'true' ] ),
            'dots' => ('yes' === $settings['sldots']),
            'autoplay' => ('yes' === $settings['slautolay']),
            'autoplay_speed' => absint($settings['slautoplay_speed']),
            'animation_speed' => absint($settings['slanimation_speed']),
            'loop' => ('yes' === $settings['slloop']),
        ];

        $slider_responsive_settings = [
            'display_columns' => absint( $settings['slitems'] ),
            'scroll_columns' => absint( $settings['slscroll_columns'] ),
            'tablet_width' =>absint( $settings['tablet_width'] ),
            'tablet_display_columns' => isset( $settings["slitems_tablet"] ) ? absint( $settings["slitems_tablet"] ) : absint( $settings['slitems'] ),
            'tablet_scroll_columns' => isset( $settings["slscroll_columns_tablet"] ) ? absint( $settings["slscroll_columns_tablet"] ) : absint( $settings['slscroll_columns'] ),
            'mobile_width' => absint( $settings['mobile_width'] ),
            'mobile_display_columns' => isset( $settings["slitems_mobile"] ) ? absint( $settings["slitems_mobile"] ) : absint( $settings['slitems'] ),
            'mobile_scroll_columns' => isset( $settings["slscroll_columns_mobile"] ) ? absint( $settings["slscroll_columns_mobile"] ) : absint( $settings['slscroll_columns'] ) ,
        ];
        $filter_settings = [
            'sectionid'=> $sectionid,
            'is_edit_mode' => \Elementor\Plugin::$instance->editor->is_edit_mode(),
        ];
        $slider_settings = array_merge( $slider_settings, $slider_responsive_settings );

        $this->add_render_attribute( 'area_attr', 'class', 'htmega-video-gallery-wrapper htmega-video-gallery-' . esc_attr( $settings['video_gallery_layout'] ) );

        if ( $settings['video_gallery_layout'] == 'carousel') {
            $this->add_render_attribute( 'item_wrapper', 'class', ' htmega-pro-carousel-activation' );   
            $this->add_render_attribute( 'item_wrapper', 'data-settings', wp_json_encode( $slider_settings ) );   
        } else {
            $this->add_render_attribute( 'item_wrapper', 'class', 'htmega-pro-row' );   
            $this->add_render_attribute( 'item_wrapper', 'data-settings', wp_json_encode( $filter_settings ) );
        }
        if ( $settings['filter_enable'] == 'yes' ) { 
            $this->add_render_attribute( 'item_wrapper', 'class', 'htmega-video-gallery-filter-wrapper' );
            $this->add_render_attribute( 'video_filter_gallery_colum_attr', 'class', 'htmega-video-gallery-filter-item' );
          
        }
        $this->add_render_attribute( 'item_wrapper', 'class', 'htmega-video-gallery-button-onhover-' . esc_attr(  $settings['button_on_hover'] ) );
        $s_display_none = ( $settings['video_gallery_layout'] == 'carousel') ? ' style="display:none;"':'';

        $this->add_render_attribute( 'area_attr', 'style', 'display:none;' );
        $this->add_render_attribute( 'popup_content_attr', 'data-elementor-open-lightbox', 'no' );
        $this->add_render_attribute( 'popup_content_attr', 'class', 'htmega-video-popup-link' );

        ?>
        <div <?php echo $this->get_render_attribute_string( 'area_attr' ); ?> >
        <?php
        if( $items ) {
            // filter menu
            if($settings['filter_enable'] == 'yes' ) { 
                $all_categories = array_column($items, 'filter_label');
                $flattened_categories = [];
                foreach ( $all_categories as $single_category ) {
                    if ( strpos( $single_category, ',' ) !== false ) {
                        $split_categories = explode( ',', $single_category );
                        $flattened_categories = array_merge($flattened_categories, $split_categories);
                    } else {
                        $flattened_categories[] = $single_category;
                    }
                }
                $flattened_categories = array_map('trim', $flattened_categories);
                $get_item_categories = array_unique($flattened_categories);

                ?>
                
                <div class="htmega-video-gallery-filter-menu">
                        <?php  if( $settings['all_btn_show_hide'] == 'yes' ) { ?>
                            <button class="htmega-vgf-btn is-checked" data-filter="*"><?php echo esc_html( $settings['all_btn_text'] ); ?></button>
                        <?php } ?>

                        <?php  if($get_item_categories) { 

                        foreach( $get_item_categories as $category_name ): 
                        ?>

                        <button class="htmega-vgf-btn" data-filter=".<?php echo esc_attr( htmega_slugify($category_name) ); ?>"><?php echo esc_html( $category_name ); ?></button>
                        <?php endforeach; } ?>

                    </div>
                <?php } ?>
                <!-- items wrapper -->
                <?php if ( $settings['filter_enable'] == 'yes' ) { ?>
                <div class="htmega-video-gallery-items-wrapper">
                <?php } ?>
                    <div <?php echo $this->get_render_attribute_string( 'item_wrapper' ); ?> >
                    <?php
                    if ( $settings['filter_enable'] == 'yes' ) { 
                        $this->gallery_sizer_controller();
                    }

                        foreach( $items as $key=>$item ) {
                            $this->add_render_attribute( $key, 'class', 'htmega-flex-column htmega-video-gallery-filter-item' );
                            if ( $settings['filter_enable'] == 'yes' ) { 
                                $this->add_render_attribute( $key, 'class', htmega_slugify( $item['filter_label'], true) );
                            }
                            //thumbnial generate
                            if ( $item['video_type'] == 'selfhosted' ) {
                                if ( !empty( $item['video_thumbnail']['url'] ) ) {
                                    $thumbnailUrl = esc_url( $item['video_thumbnail']['url'] );
                                } else {
                                    $thumbnailUrl = HTMEGA_ADDONS_PL_URL.'assets/images/image-placeholder.png';
                                }
                            } else {
                                $video_id = htmega_extract_video_id( $item['video_url']['url'] ); // get the video id from the link
                                if ( $item['video_type'] == 'vimeo' ) {
                                    if ( !empty( $item['video_thumbnail']['url'] ) ) {
                                        $thumbnailUrl = $item['video_thumbnail']['url'];
                                    } else {

                                        $vimeoVideoUrl = esc_url( $item['video_url']['url'] );
                                        $encodedUrl = urlencode($vimeoVideoUrl);
                                        $oembedApiUrl = "https://vimeo.com/api/oembed.json?url={$encodedUrl}";
                                        $response = htmega_get_remote_file_data($oembedApiUrl);
                                        
                                        if ( $response !== false ) {
                                            $data = json_decode($response, true);
                                            if ( isset($data['thumbnail_url']) ) {
                                                $thumbnailUrl = $data['thumbnail_url'];
                                            }
                                            $newWidth = 1280;
                                            $newHeight = 720;
                                            $thumbnailUrl = preg_replace('/(\d+)x(\d+)/', "{$newWidth}x{$newHeight}", $thumbnailUrl);
                                        }
                                    }
                                    
                                } elseif ( $item['video_type'] == 'youtube' ) {
                                    if ( !empty( $item['video_thumbnail']['url'] ) ) {
                                        $thumbnailUrl = esc_url( $item['video_thumbnail']['url'] );
                                    } else {
                                        $thumbnailUrl ="https://img.youtube.com/vi/" . $video_id . "/maxresdefault.jpg";
                                    }
                                    
                                }
                            }
                            ?> 
                            <div <?php echo $this->get_render_attribute_string( $key ); ?> >
                                <div class="htmega-video-gallery-item">
                                    <?php 
                                    // popup option
                                    if ( 'popup' === $video_show_in ) {                        
                                        if ( $item['video_type'] == 'selfhosted' ){ ?>
                                        
                                            <div class="htmega-video-gallery-thumbnail">
                                                <a <?php echo $this->get_render_attribute_string( 'popup_content_attr' ); ?> data-type="inline" href="#<?php echo esc_attr( $item['_id'] ); ?>">
                                                    <?php echo HTMega_Icon_manager::render_icon( $settings['play_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                                </a>
                                                <img src="<?php echo esc_url( $thumbnailUrl ); ?>" alt="<?php echo esc_attr( $item['video_title'] ); ?>">
                                            </div>
                                            
                                            <div id="<?php echo esc_attr( $item['_id'] );?>" class="mfp-hide">
                                                <div class="htmega-inline-video-container">
                                                    <video width="800" controls>
                                                        <source src="<?php echo esc_url( $item['self_hosted_video']['url'] ); ?>" type="video/mp4">
                                                    </video>
                                                </div>
                                            </div>
                                        <?php
                                        } else { ?>

                                            <div class="htmega-video-gallery-thumbnail">
                                                <a <?php echo $this->get_render_attribute_string( 'popup_content_attr' ); ?> href="<?php echo esc_url( $item['video_url']['url'] ) ;?>">
                                                    <?php echo HTMega_Icon_manager::render_icon( $settings['play_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                                </a>
                                                <img src="<?php echo esc_url( $thumbnailUrl ); ?>" alt="<?php echo esc_attr( $item['video_title'] ); ?>">
                                            </div>
                                        <?php
                                        }
                                    } else {  //inline option
                                        
                                        if ( $item['video_type'] == 'vimeo' ):
                                        ?>
                                            <iframe src="https://player.vimeo.com/video/<?php echo esc_attr($video_id); ?>" width="560" height="315" frameborder="0" allowfullscreen></iframe>
                                        <?php 
                                        elseif ( $item['video_type'] == 'youtube' ):
                                        ?>
                                            <iframe width="560" height="315" src="https://www.youtube.com/embed/<?php echo esc_attr($video_id); ?>" frameborder="0" allowfullscreen></iframe>
                                        <?php  
                                        elseif ( $item['video_type'] == 'selfhosted' ):

                                            if ( !empty( $item['self_hosted_video']['url'] ) ) :
                                            ?>
                                                <div class="htmega-inline-video-container">
                                                    <video width="560" height="315" controls>
                                                        <source src="<?php echo esc_url( $item['self_hosted_video']['url'] ); ?>" type="video/mp4">
                                                    </video>
                                                </div>
                                            <?php 
                                            endif;
                                            ?>
                                        <?php 
                                        endif;
                                    }

                                    // video galery caption
                                    if( $settings['show_video_title'] == 'yes' || $settings['show_video_description'] == 'yes' ) { ?>
                                    
                                        <div class="htmega-video-gallery-caption">
                                            <?php
                                            if ( $settings['show_video_title'] == 'yes' && !empty( $item['video_title'] ) ) {
                                                echo '<h4 class="htmega-video-title">' . esc_html( $item['video_title'] ) . '</h4>';
                                            }
                                            if ( $settings['show_video_description'] == 'yes' && !empty( $item['video_des'] ) ) {
                                                echo '<p class="htmega-video-description">' . esc_html( $item['video_des'] ) . '</p>';
                                            }
                                            ?>
                                        </div>
                                        <?php 
                                    } ?>
                                </div>
                                
                            </div>
                            
                        <?php
                        }
                        ?>
                    </div>
                <?php if ( $settings['filter_enable'] == 'yes' ) { ?>
                </div>
                <?php }?>
        </div>
         <?php
       }

    }
    protected function gallery_sizer_controller(){
        if ( ! (\Elementor\Plugin::$instance->editor->is_edit_mode()) ) {
            printf('<div %1$s></div>', $this->get_render_attribute_string( 'video_filter_gallery_colum_attr' ));
        }
    }
    // Filter Menu style
    protected function __filterable_menu_style(){
        $this->start_controls_section(
            'filterable_menu_style_section',
            [
                'label' => esc_html__( 'Filter  Style', 'htmega-pro' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'filter_enable' => 'yes',
                ]
            ]
        );

            $this->add_control(
                'menu_section_style',
                [
                    'label' => esc_html__( 'Filter Wrapper', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_responsive_control(
                'filterable_menu_alignment',
                [
                    'label'   => esc_html__( 'Alignment', 'htmega-pro' ),
                    'type'    => Controls_Manager::CHOOSE,
                    'options' => [
                        'left'    => [
                            'title' => esc_html__( 'Left', 'htmega-pro' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'htmega-pro' ),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'htmega-pro' ),
                            'icon'  => 'eicon-text-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-video-gallery-filter-menu'   => 'text-align: {{VALUE}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'menu_section_background',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-video-gallery-filter-menu',
                ]
            );

            $this->add_responsive_control(
                'menu_section_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-video-gallery-filter-menu' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'menu_section_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-video-gallery-filter-menu' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'menu_section_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-video-gallery-filter-menu',
                ]
            );

            $this->add_responsive_control(
                'menu_section_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-video-gallery-filter-menu' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'after',
                ]
            );

            $this->add_control(
                'menu_style',
                [
                    'label' => esc_html__( 'Filter Button Style', 'htmega-pro' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'filterable_menu_typography',
                    'selector' => '{{WRAPPER}} .htmega-video-gallery-filter-menu button',
                ]
            );
            $this->add_responsive_control(
                'menu_normal_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-video-gallery-filter-menu button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'menu_normal_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-video-gallery-filter-menu button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            // Menu Style Normal Tabs Start
            $this->start_controls_tabs( 'menu_style_tabs' );

                // Menu Style Normal Tab Start
                $this->start_controls_tab(
                    'menu_style_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'menu_normal_color',
                        [
                            'label'     => esc_html__( 'Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-video-gallery-filter-menu button' => 'color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'menu_normal_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-video-gallery-filter-menu button',
                            'exclude' =>['image']
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'menu_normal_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-video-gallery-filter-menu button',
                        ]
                    );

                    $this->add_responsive_control(
                        'menu_normal_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-video-gallery-filter-menu button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'menu_normal_box_shadow',
                            'selector' => '{{WRAPPER}} .htmega-video-gallery-filter-menu button',
                            'separator' => 'before',
                        ]
                    );

                $this->end_controls_tab(); // Menu Style Normal Tab end

                // Menu Style Hover Tab Start
                $this->start_controls_tab(
                    'menu_style_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'htmega-pro' ),
                    ]
                );
                    
                    $this->add_control(
                        'menu_hover_color',
                        [
                            'label'     => esc_html__( 'Color', 'htmega-pro' ),
                            'type'      => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-video-gallery-filter-menu button.is-checked' => 'color: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'menu_hover_background',
                            'label' => esc_html__( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-video-gallery-filter-menu button.is-checked, {{WRAPPER}} .htmega-video-gallery-filter-menu button:hover',
                            'exclude' =>['image']
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'menu_hover_border',
                            'label' => esc_html__( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-video-gallery-filter-menu button.is-checked,
                                {{WRAPPER}} .htmega-video-gallery-filter-menu button:hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'menu_hover_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-video-gallery-filter-menu button.is-checked,
                                {{WRAPPER}} .htmega-video-gallery-filter-menu button:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'menu_hover_box_shadow',
                            'selector' => '{{WRAPPER}} .htmega-video-gallery-filter-menu button.is-checked,
                            {{WRAPPER}} .htmega-video-gallery-filter-menu button:hover',
                            'separator' => 'before',
                        ]
                    );
                $this->end_controls_tab(); // Menu Style Hover Tab End
            $this->end_controls_tabs(); // Menu Style Normal Tabs End
        $this->end_controls_section();
    }
    // popup button style
    protected function __video_gallery_button_style() {
        // Style Load More button tab section
        $this->start_controls_section(
            'video_popup_style_section',
                [
                    'label' => __( 'Popup Button', 'htmega-pro' ),
                    'tab' => Controls_Manager::TAB_STYLE,
                    'condition'=>[
                        'video_show_in' => 'popup',
                    ]
                ]
            );
            $this->start_controls_tabs('video_popup_style_tabs');

                $this->start_controls_tab(
                    'video_popup_style_normal_tab',
                    [
                        'label' => __( 'Normal', 'htmega-pro' ),
                    ]
                );

                    $this->add_control(
                        'video_popup_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-video-popup-link i' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .htmega-video-popup-link svg path' => 'fill: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_responsive_control(
                        'htmega_video_popup_fontsize',
                        [
                            'label' => __( 'Font Size', 'htmega-pro' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 100,
                                    'step' => 1,
                                ],
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'default' => [
                                'unit' => 'px',
                                'size' => 32,
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-video-popup-link' => 'font-size: {{SIZE}}{{UNIT}};',
                                '{{WRAPPER}} .htmega-video-popup-link svg' => 'width: {{SIZE}}{{UNIT}};height: auto;',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'video_popup_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-video-popup-link',
                            'exclude' =>['image'],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'video_popup_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-video-popup-link',
                        ]
                    );

                    $this->add_responsive_control(
                        'video_popup_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-video-popup-link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'video_popup_padding',
                        [
                            'label' => __( 'Padding', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-video-popup-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                $this->end_controls_tab(); // Normal Tab end

                $this->start_controls_tab(
                    'video_popup_style_hover_tab',
                    [
                        'label' => __( 'Hover', 'htmega-pro' ),
                    ]
                );
                    $this->add_control(
                        'video_popup_hover_color',
                        [
                            'label' => __( 'Color', 'htmega-pro' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .htmega-video-popup-link:hover i,{{WRAPPER}} .htmega-video-popup-link:hover' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .htmega-video-popup-link:hover svg path' => 'fill: {{VALUE}};',
                            ],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'video_popup_hover_background',
                            'label' => __( 'Background', 'htmega-pro' ),
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .htmega-video-popup-link:hover',
                            'exclude' =>['image'],
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'video_popup_hover_border',
                            'label' => __( 'Border', 'htmega-pro' ),
                            'selector' => '{{WRAPPER}} .htmega-video-popup-link:hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'video_popup_hover_border_radius',
                        [
                            'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px', '%', 'em' ],
                            'selectors' => [
                                '{{WRAPPER}} .htmega-video-popup-link:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );

                $this->end_controls_tab(); // Hover Tab end

            $this->end_controls_tabs();

        $this->end_controls_section();
    }
    protected function __video_gallery_content_box_style() {
        $this->start_controls_section(
            'video_gallery_title_section',
                [
                    'label' => esc_html__('Content Box', 'htmega-pro'),
                    'tab' => Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'show_video_title' => 'yes',
                    ]
                ]
            );
            $this->add_responsive_control(
                'content_box_alignment',
                [
                    'label'   => esc_html__( 'Alignment', 'htmega-pro' ),
                    'type'    => Controls_Manager::CHOOSE,
                    'options' => [
                        'left'    => [
                            'title' => esc_html__( 'Left', 'htmega-pro' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'htmega-pro' ),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'htmega-pro' ),
                            'icon'  => 'eicon-text-align-right',
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-video-gallery-caption'   => 'text-align: {{VALUE}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'content_box_background',
                    'label' => esc_html__( 'Background', 'htmega-pro' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .htmega-video-gallery-caption',
                ]
            );

            $this->add_responsive_control(
                'content_box_padding',
                [
                    'label' => esc_html__( 'Padding', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-video-gallery-caption' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'content_box_margin',
                [
                    'label' => esc_html__( 'Margin', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-video-gallery-caption' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'content_box_border',
                    'label' => esc_html__( 'Border', 'htmega-pro' ),
                    'selector' => '{{WRAPPER}} .htmega-video-gallery-caption',
                ]
            );

            $this->add_responsive_control(
                'content_box_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'htmega-pro' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em' ],
                    'selectors' => [
                        '{{WRAPPER}} .htmega-video-gallery-caption' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'after',
                ]
            );
            $this->start_controls_tabs( 'vg_contents_tabs' );
    
            // Title tab Start
            $this->start_controls_tab(
                'content_title_tab',
                [
                    'label' => __( 'Title', 'htmega-pro' ),
                ]
            );
                $this->add_control(
                    'video_gallery_title_color',
                    [
                        'label' => esc_html__('Color', 'htmega-pro'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-video-title' => 'color: {{VALUE}};',
                        ],

                    ]
                );            
                $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                        'name' => 'video_gallery_title_typography',
                        'selector' => '{{WRAPPER}} .htmega-video-title',
                    ]
                );

                $this->add_responsive_control(
                    'video_gallery_title_hover_margin',
                    [
                        'label' => esc_html__( 'Margin', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-video-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],                
                    ]
                );
            
            $this->end_controls_tab(); // Title tab end
            // Title tab Start
            $this->start_controls_tab(
                'content_description_tab',
                [
                    'label' => __( 'Description', 'htmega-pro' ),
                ]
            );
                $this->add_control(
                    'video_gallery_description_color',
                    [
                        'label' => esc_html__('Color', 'htmega-pro'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .htmega-video-description' => 'color: {{VALUE}};',
                        ],

                    ]
                );
                
                $this->add_group_control(
                    Group_Control_Typography::get_type(),
                    [
                        'name' => 'video_gallery_description_typography',
                        'selector' => '{{WRAPPER}} .htmega-video-description',
                    ]
                );
                $this->add_responsive_control(
                    'video_gallery_description_margin',
                    [
                        'label' => esc_html__( 'Margin', 'htmega-pro' ),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', '%', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .htmega-video-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],                
                    ]
                );

            $this->end_controls_tab(); // Title tab end
            $this->end_controls_tabs();
        $this->end_controls_section();
    }
}