;(function($){
    "use strict";

    let areaBtnNext = HTMEGAF['buttion_area_text_next'];
    let areaBtnPrev = HTMEGAF['buttion_area_text_prev'];
        // Carousel Handler
        var WidgetHtmegaPorCarouselHandler = function ($scope, $) {

            var carousel_elem = $scope.find( '.htmega-pro-carousel-activation' ).eq(0);
            if( carousel_elem.length > 0){
                if( carousel_elem[0].parentNode.classList[0] == 'htmega-advanced-slider-wrapper' ){
                    carousel_elem[0].parentNode.style.display='block';
                }
                carousel_elem[0].style.display='block';
             }

            if ( carousel_elem.length > 0 ) {
    
                var settings = carousel_elem.data('settings');
                var arrows = settings['arrows'];
                var arrow_prev_txt = settings['arrow_prev_txt'];
                var arrow_next_txt = settings['arrow_next_txt'];
                var dots = settings['dots'];
                var autoplay = settings['autoplay'];
                var fade = settings['fade'] ? true : false;
                var autoplay_speed = parseInt(settings['autoplay_speed']) || 3000;
                var animation_speed = parseInt(settings['animation_speed']) || 300;
                var pause_on_hover = settings['pause_on_hover'];
                var center_mode = settings['center_mode'];
                var loop = settings['loop'];
                var vertical = settings['vertical'] ? true : false;
                var center_padding = settings['center_padding'] ? parseInt( settings['center_padding'] ): 0;
                var variable_width = settings['variable_width'] ? true : false;
                var display_columns = parseInt(settings['display_columns']) || 1;
                var scroll_columns = parseInt(settings['scroll_columns']) || 1;
                var tablet_width = parseInt(settings['tablet_width']) || 800;
                var tablet_display_columns = parseInt(settings['tablet_display_columns']) || 1;
                var tablet_scroll_columns = parseInt(settings['tablet_scroll_columns']) || 1;
                var mobile_width = parseInt(settings['mobile_width']) || 480;
                var mobile_display_columns = parseInt(settings['mobile_display_columns']) || 1;
                var mobile_scroll_columns = parseInt(settings['mobile_scroll_columns']) || 1;


                    carousel_elem.slick({
                        arrows: arrows,
                        prevArrow: '<button aria-label="'+areaBtnPrev+'" class="htmega-carosul-prev">'+arrow_prev_txt+'</button>',
                        nextArrow: '<button aria-label="'+areaBtnNext+'" class="htmega-carosul-next">'+arrow_next_txt+'</button>',
                        dots: dots,
                        autoplay: autoplay,
                        autoplaySpeed: autoplay_speed,
                        speed: animation_speed,
                        infinite:loop,
                        fade: fade,
                        pauseOnHover: pause_on_hover,
                        slidesToShow: display_columns,
                        slidesToScroll: scroll_columns,
                        centerMode: center_mode,
                        centerPadding: center_padding+'px',
                        variableWidth: variable_width,
                        rtl: elementorFrontendConfig.is_rtl,
                        vertical:vertical,
                        adaptiveHeight: false,
                        responsive: [
                            {
                                breakpoint: tablet_width,
                                settings: {
                                    slidesToShow: tablet_display_columns,
                                    slidesToScroll: tablet_scroll_columns
                                }
                            },
                            {
                                breakpoint: mobile_width,
                                settings: {
                                    slidesToShow: mobile_display_columns,
                                    slidesToScroll: mobile_scroll_columns
                                }
                            }
                        ],
                        customPaging : function(slider, i=i+1) {
                            var customnum = i+1;
                            if( i < 9){
                                return '<button> 0'+customnum+'</button>';
                            }else{
                                return '<button> '+customnum+'</button>';
                            }
                        },
                        
                    });

                    //equel height column
                    if( settings['equal_height_column'] ){
                        var maxHeight = -1;
                        $('.'+settings['sectionid']+' '+settings['equal_height_column_class']).each(function() {
                            if ( $('.'+settings['sectionid']+' '+settings['equal_height_column_class'] ).outerHeight() > maxHeight ) {
                                maxHeight = $('.'+settings['sectionid']+' '+settings['equal_height_column_class']).outerHeight();
                            }
                        });
                      
                        $('.'+settings['sectionid']+' '+settings['equal_height_column_class'] ).each(function() {
                            if ($(this).outerHeight() < maxHeight) {
                                $(this).css('height', maxHeight+ 'px');
                            }
                        });
                    }


            // Slider Area Element Animation
            var $sliderArea = $('.htmega-template-slide');
            if ($sliderArea.length) {
                $sliderArea.each(function () {
                    var $this = $(this),
                        $singleSlideElem = $this.find('.slick-slide .elementor-widget-wrap .elementor-element');
                    function $slideElemAnimation() {
                        $singleSlideElem.each(function () {
                            var $this = $(this),
                                $thisSetting = $this.data('settings') ? $this.data('settings') : '',
                                $animationName = $thisSetting._animation,
                                $animationDelay = $thisSetting._animation_delay;
                                if( $animationName ){
                                    $this.removeClass('animated ' + $animationName).addClass('animated fadeOut');
                                    if( $this.closest('.slick-slide').hasClass('slick-active')) {
                                        $this.removeClass('animated fadeOut').addClass('animated ' + $animationName).css({
                                            'animation-delay': $animationDelay+'ms'
                                        });
                                    }
                                }
                        });
                    }
                    $slideElemAnimation();
                    $this.on('afterChange', function(slick, currentSlide){
                        $slideElemAnimation();
                    });
                    $this.on('beforeChange', function(slick, currentSlide){
                        $slideElemAnimation();
                    });
                    $this.on('init', function(slick){
                        $slideElemAnimation();
                    });
                });
            }

                }
            }

        // Run this code under Elementor.
        $(window).on('elementor/frontend/init', function () {
            elementorFrontend.hooks.addAction( 'frontend/element_ready/htmega-facebook-review-addons.default', WidgetHtmegaPorCarouselHandler);
            elementorFrontend.hooks.addAction( 'frontend/element_ready/htmega-post-timeline-addons.default', WidgetHtmegaPorCarouselHandler);
            elementorFrontend.hooks.addAction( 'frontend/element_ready/htmega-advanced-slider-addons.default', WidgetHtmegaPorCarouselHandler);
            elementorFrontend.hooks.addAction( 'frontend/element_ready/htmega-video-gallery-addons.default', WidgetHtmegaPorCarouselHandler);
        });

        
    })(jQuery);