(function ($) {

    "use strict";
    var HTMegaCopyCouponCode = function ( $scope, $ ){
        var container_elem = $scope.find('.htmega-cpc-wrapper').eq(0);

        if ( container_elem.length > 0 ) {
            // Toggle trigger-action class when hover
            if( container_elem.hasClass('htmega-coupon-animation') ) {
                $(container_elem).on('mouseenter', function() {
                    $(this).removeClass('htmega-coupon-animation');
                  }).on('mouseleave', function() {
                    $(this).addClass('htmega-coupon-animation');
                  });
            }

            var couponButton =  container_elem.find(".htmega-coupon-btn")[0];
            var couponText = container_elem.find(".htmega-coupon-text")[0];

            $(container_elem).css('min-width', $(couponButton).outerWidth() + 'px');
            couponButton.addEventListener("click", () => {
                var textValue = couponText.value;
                navigator.clipboard.writeText(textValue);
                couponButton.classList.remove("htmega-btn-copy-status-copy");
                couponButton.classList.add("htmega-btn-copy-status-copied");
                setTimeout(() => {
                    couponButton.classList.remove("htmega-btn-copy-status-copied");
                    couponButton.classList.add("htmega-btn-copy-status-copy");
                }, 3000);
            });
        }
    }
    // Run this code under Elementor.
    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/htmega-copy-coupon-code-addons.default', HTMegaCopyCouponCode);
    });      


})(jQuery);
