(function ($) {
    "use strict";
    var WidgetFilterableGalleryHandler = function ($scope, $) {
        
        var filterable_elem = $scope.find('.htmega-filterable-active').eq(0);
        if( filterable_elem.length > 0){ filterable_elem[0].style.display='block'; }
        
        if (filterable_elem.length > 0) {
            var filterable_opt = filterable_elem.data('settings');

            var $isotopFilter = $('.htmega-filterable-gallery-filter');
            var $isotopeGrid = $('.htmega-filterable-gallery-grid');
            $isotopFilter.on('click', '[data-filter]', function() {
                var $this = $(this),
                    $filterValue = $this.attr('data-filter'),
                    $targetIsotop = $this.parent().data('target');
                $this.addClass('is-checked').siblings().removeClass('is-checked');
                $($targetIsotop).isotope({
                    filter: $filterValue
                });
            });
            if(filterable_opt.is_edit_mode != true){
                $isotopeGrid.imagesLoaded(function() {
                    $isotopeGrid.isotope({
                        itemSelector: '.htmega-gallery-item',
                        masonry: {
                            columnWidth: '.htmega-gallery-sizer'
                        }
                    });
                });
            
                // init Isotope for Filter Selector
                let filterValueSelector;
                const $htmegaFG_Grid = $(".htmega-fg-select-grid");
                $htmegaFG_Grid.imagesLoaded(function() {
                    $htmegaFG_Grid.isotope({
                        itemSelector: ".htmega-gallery-item",
                        masonry: {
                            columnWidth: '.htmega-gallery-sizer'
                        },
                        filter() {
                            const $this = $(this);
                            const selectResult = filterValueSelector ? $this.is(filterValueSelector) : true;
                            return  selectResult;
                        }
                    });
                    // bind filter on select change
                    $("#htmega-filters-select").on("change", function() {
                        // get filter value from option value
                        filterValueSelector = $(this).val();
                        $htmegaFG_Grid.isotope();
                    });
                });
            }
            
            $(filterable_opt.img_popup).magnificPopup({
                type: 'image',
                gallery: {
                    enabled: true
                }
            });
            // Magnific Popup Video
            $('.htmega-filterable-popup-youtube').magnificPopup({
                type: 'iframe',
                removalDelay: 300,
                mainClass: 'mfp-fade'
            });

            $("#htmega-filters-select").on("change",function(){
                $('.htmega-gallery-item').css({
                        'position':'absolute'
                });
                $('.htmega-gallery-sizer').css({
                    'display':'none'
                });
                document.getElementById("htmega-filters-quicksearch").value = "";
            });
        }
    }

    // Run this code under Elementor.
    $(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/htmega-filterable-gallery-addons.default', WidgetFilterableGalleryHandler);
    });

})(jQuery);

// JavaScript code
 let selectID = document.getElementById('htmega-filters-select');

function search_gallery(element) {
    var dataAttribute = element.getAttribute('data-searchsettings');
    var personObject = JSON.parse(dataAttribute);
    
	let input = document.getElementById('htmega-filters-quicksearch').value
	input=input.toLowerCase();
    
    let selectID = document.getElementById('htmega-filters-select');
       
        selectID = ('*' == selectID.value)?personObject.gallery_item:selectID.value.replace(".", "");
  
	let x = document.getElementsByClassName(selectID);

    let sizer = document.querySelector('.htmega-gallery-sizer');
    if(sizer ){
        sizer.style.display="none"; 
    }

	for (i = 0; i < x.length; i++) {
	
		if( x[i].style.display == 'none'){
			x[i].style.display="none";
		}

		if (!x[i].innerHTML.toLowerCase().includes(input) ) {

			x[i].style.display="none";
		}
		else {
			x[i].style.display="inline-block";
			x[i].style.position="static";		
		}
	}    
}